/*
 Custom build of Typr.ts (https://github.com/fredli74/Typr.ts) for use in Troika text rendering.
  Original MIT license applies: https://github.com/fredli74/Typr.ts/blob/master/LICENSE
 Custom bundle of woff2otf (https://github.com/arty-name/woff2otf) with fflate
  (https://github.com/101arrowz/fflate) for use in Troika text rendering. 
  Original licenses apply: 
  - fflate: https://github.com/101arrowz/fflate/blob/master/LICENSE (MIT)
  - woff2otf.js: https://github.com/arty-name/woff2otf/blob/master/woff2otf.js (Apache2)
*/
'use strict';(function(x,y){"object"===typeof exports&&"undefined"!==typeof module?y(exports,require("three"),require("troika-worker-utils"),require("webgl-sdf-generator"),require("bidi-js"),require("troika-three-utils")):"function"===typeof define&&define.amd?define("exports three troika-worker-utils webgl-sdf-generator bidi-js troika-three-utils".split(" "),y):(x="undefined"!==typeof globalThis?globalThis:x||self,y(x.troika_three_text={},x.THREE,x.troika_worker_utils,x.webgl_sdf_generator,x.bidi_js,
x.troika_three_utils))})(this,function(x,y,K,W,V,ja){function ma(k){return k&&"object"===typeof k&&"default"in k?k:{"default":k}}function za(k,f,p,m,b,a,c,d,e,g,h=!0){return h?Aa(k,f,p,m,b,a,c,d,e,g).then(null,h=>{na||(console.warn("WebGL SDF generation failed, falling back to JS",h),na=!0);return oa(k,f,p,m,b,a,c,d,e,g)}):oa(k,f,p,m,b,a,c,d,e,g)}function O(){return(self.performance||Date).now()}function pa(k,f){qa=!0;k=ra({},k);let p=O();k.font=Ba(k.font||S.defaultFontURL);k.text=""+k.text;k.sdfGlyphSize=
k.sdfGlyphSize||S.sdfGlyphSize;if(null!=k.colorRanges){var m={};for(let a in k.colorRanges)if(k.colorRanges.hasOwnProperty(a)){let b=k.colorRanges[a];"number"!==typeof b&&(b=Ca.set(b).getHex());m[a]=b}k.colorRanges=m}Object.freeze(k);let {textureWidth:b,sdfExponent:a}=S,{sdfGlyphSize:c}=k,d=b/c*4,e=aa[c];e||(m=document.createElement("canvas"),m.width=b,m.height=256*c/d,e=aa[c]={glyphCount:0,sdfGlyphSize:c,sdfCanvas:m,sdfTexture:new y.Texture(m,void 0,void 0,void 0,y.LinearFilter,y.LinearFilter),contextLost:!1,
glyphsByFont:new Map},e.sdfTexture.generateMipmaps=!1,Da(e));let {sdfTexture:g,sdfCanvas:h}=e,l=e.glyphsByFont.get(k.font);l||e.glyphsByFont.set(k.font,l=new Map);Ea(k).then(r=>{let {glyphIds:E,glyphPositions:ba,fontSize:n,unitsPerEm:t,timings:q}=r,v=[],u=new Float32Array(4*E.length),w=n/t,m=0,G=0;var B=O();E.forEach((a,b)=>{var d=l.get(a);if(!d){let {path:b,pathBounds:f}=r.glyphData[a];d=Math.max(f[2]-f[0],f[3]-f[1])/c*(S.sdfMargin*c+.5);var g=e.glyphCount++;l.set(a,d={path:b,atlasIndex:g,sdfViewBox:[f[0]-
d,f[1]-d,f[2]+d,f[3]+d]});v.push(d)}({sdfViewBox:a}=d);g=ba[G++];let f=ba[G++];u[m++]=g+a[0]*w;u[m++]=f+a[1]*w;u[m++]=g+a[2]*w;u[m++]=f+a[3]*w;E[b]=d.atlasIndex});q.quads=(q.quads||0)+(O()-B);let H=O();q.sdf={};B=h.height;let I=Math.pow(2,Math.ceil(Math.log2(Math.ceil(e.glyphCount/d)*c)));I>B&&(console.info(`Increasing SDF texture size ${B}->${I}`),Fa(h,b,I),g.dispose());K.Thenable.all(v.map(a=>sa(a,e,k.gpuAccelerateSDF).then(({timing:b})=>{q.sdf[a.atlasIndex]=b}))).then(()=>{v.length&&!e.contextLost&&
(ta(e),g.needsUpdate=!0);q.sdfTotal=O()-H;q.total=O()-p;f(Object.freeze({parameters:k,sdfTexture:g,sdfGlyphSize:c,sdfExponent:a,glyphBounds:u,glyphAtlasIndices:E,glyphColors:r.glyphColors,caretPositions:r.caretPositions,caretHeight:r.caretHeight,chunkedBounds:r.chunkedBounds,ascender:r.ascender,descender:r.descender,lineHeight:r.lineHeight,topBaseline:r.topBaseline,blockBounds:r.blockBounds,visibleBounds:r.visibleBounds,timings:r.timings,get totalBounds(){console.log("totalBounds deprecated, use blockBounds instead");
return r.blockBounds},get totalBlockSize(){console.log("totalBlockSize deprecated, use blockBounds instead");let [a,b,c,d]=r.blockBounds;return[c-a,d-b]}}))})});K.Thenable.all([]).then(()=>{e.contextLost||h._warm||(X.webgl.isSupported(h),h._warm=!0)})}function sa({path:k,atlasIndex:f,sdfViewBox:p},{sdfGlyphSize:m,sdfCanvas:b,contextLost:a},c){if(a)return Promise.resolve({timing:-1});let {textureWidth:d,sdfExponent:e}=S;a=Math.floor(f/4);return za(m,m,k,p,Math.max(p[2]-p[0],p[3]-p[1]),e,b,a%(d/m)*
m,Math.floor(a/(d/m))*m,f%4,c)}function Da(k){let f=k.sdfCanvas;f.addEventListener("webglcontextlost",f=>{console.log("Context Lost",f);f.preventDefault();k.contextLost=!0});f.addEventListener("webglcontextrestored",f=>{console.log("Context Restored",f);k.contextLost=!1;let m=[];k.glyphsByFont.forEach(b=>{b.forEach(a=>{m.push(sa(a,k,!0))})});K.Thenable.all(m).then(()=>{ta(k);k.sdfTexture.needsUpdate=!0})})}function ra(k,f){for(let p in f)f.hasOwnProperty(p)&&(k[p]=f[p]);return k}function Ba(k){Y||
(Y="undefined"===typeof document?{}:document.createElement("a"));Y.href=k;return Y.href}function ta(k){if("function"!==typeof createImageBitmap){console.info("Safari<15: applying SDF canvas workaround");let {sdfCanvas:f,sdfTexture:p}=k,{width:m,height:b}=f;k=k.sdfCanvas.getContext("webgl");let a=p.image.data;a&&a.length===m*b*4||(a=new Uint8Array(m*b*4),p.image={width:m,height:b,data:a},p.flipY=!1,p.isDataTexture=!0);k.readPixels(0,0,m,b,k.RGBA,k.UNSIGNED_BYTE,a)}}function ua(k){k=ja.createDerivedMaterial(k,
{chained:!0,extensions:{derivatives:!0},uniforms:{uTroikaSDFTexture:{value:null},uTroikaSDFTextureSize:{value:new y.Vector2},uTroikaSDFGlyphSize:{value:0},uTroikaSDFExponent:{value:0},uTroikaTotalBounds:{value:new y.Vector4(0,0,0,0)},uTroikaClipRect:{value:new y.Vector4(0,0,0,0)},uTroikaDistanceOffset:{value:0},uTroikaOutlineOpacity:{value:0},uTroikaFillOpacity:{value:1},uTroikaPositionOffset:{value:new y.Vector2},uTroikaCurveRadius:{value:0},uTroikaBlurRadius:{value:0},uTroikaStrokeWidth:{value:0},
uTroikaStrokeColor:{value:new y.Color},uTroikaStrokeOpacity:{value:1},uTroikaOrient:{value:new y.Matrix3},uTroikaUseGlyphColors:{value:!0},uTroikaSDFDebug:{value:!1}},vertexDefs:"\nuniform vec2 uTroikaSDFTextureSize;\nuniform float uTroikaSDFGlyphSize;\nuniform vec4 uTroikaTotalBounds;\nuniform vec4 uTroikaClipRect;\nuniform mat3 uTroikaOrient;\nuniform bool uTroikaUseGlyphColors;\nuniform float uTroikaDistanceOffset;\nuniform float uTroikaBlurRadius;\nuniform vec2 uTroikaPositionOffset;\nuniform float uTroikaCurveRadius;\nattribute vec4 aTroikaGlyphBounds;\nattribute float aTroikaGlyphIndex;\nattribute vec3 aTroikaGlyphColor;\nvarying vec2 vTroikaGlyphUV;\nvarying vec4 vTroikaTextureUVBounds;\nvarying float vTroikaTextureChannel;\nvarying vec3 vTroikaGlyphColor;\nvarying vec2 vTroikaGlyphDimensions;\n",
vertexTransform:"\nvec4 bounds = aTroikaGlyphBounds;\nbounds.xz += uTroikaPositionOffset.x;\nbounds.yw -= uTroikaPositionOffset.y;\n\nvec4 outlineBounds = vec4(\n  bounds.xy - uTroikaDistanceOffset - uTroikaBlurRadius,\n  bounds.zw + uTroikaDistanceOffset + uTroikaBlurRadius\n);\nvec4 clippedBounds = vec4(\n  clamp(outlineBounds.xy, uTroikaClipRect.xy, uTroikaClipRect.zw),\n  clamp(outlineBounds.zw, uTroikaClipRect.xy, uTroikaClipRect.zw)\n);\n\nvec2 clippedXY = (mix(clippedBounds.xy, clippedBounds.zw, position.xy) - bounds.xy) / (bounds.zw - bounds.xy);\n\nposition.xy = mix(bounds.xy, bounds.zw, clippedXY);\n\nuv = (position.xy - uTroikaTotalBounds.xy) / (uTroikaTotalBounds.zw - uTroikaTotalBounds.xy);\n\nfloat rad = uTroikaCurveRadius;\nif (rad != 0.0) {\n  float angle = position.x / rad;\n  position.xz = vec2(sin(angle) * rad, rad - cos(angle) * rad);\n  normal.xz = vec2(sin(angle), cos(angle));\n}\n  \nposition = uTroikaOrient * position;\nnormal = uTroikaOrient * normal;\n\nvTroikaGlyphUV = clippedXY.xy;\nvTroikaGlyphDimensions = vec2(bounds[2] - bounds[0], bounds[3] - bounds[1]);\n\n\nfloat txCols = uTroikaSDFTextureSize.x / uTroikaSDFGlyphSize;\nvec2 txUvPerSquare = uTroikaSDFGlyphSize / uTroikaSDFTextureSize;\nvec2 txStartUV = txUvPerSquare * vec2(\n  mod(floor(aTroikaGlyphIndex / 4.0), txCols),\n  floor(floor(aTroikaGlyphIndex / 4.0) / txCols)\n);\nvTroikaTextureUVBounds = vec4(txStartUV, vec2(txStartUV) + txUvPerSquare);\nvTroikaTextureChannel = mod(aTroikaGlyphIndex, 4.0);\n",
fragmentDefs:"\nuniform sampler2D uTroikaSDFTexture;\nuniform vec2 uTroikaSDFTextureSize;\nuniform float uTroikaSDFGlyphSize;\nuniform float uTroikaSDFExponent;\nuniform float uTroikaDistanceOffset;\nuniform float uTroikaFillOpacity;\nuniform float uTroikaOutlineOpacity;\nuniform float uTroikaBlurRadius;\nuniform vec3 uTroikaStrokeColor;\nuniform float uTroikaStrokeWidth;\nuniform float uTroikaStrokeOpacity;\nuniform bool uTroikaSDFDebug;\nvarying vec2 vTroikaGlyphUV;\nvarying vec4 vTroikaTextureUVBounds;\nvarying float vTroikaTextureChannel;\nvarying vec2 vTroikaGlyphDimensions;\n\nfloat troikaSdfValueToSignedDistance(float alpha) {\n  // Inverse of exponential encoding in webgl-sdf-generator\n  \n  float maxDimension = max(vTroikaGlyphDimensions.x, vTroikaGlyphDimensions.y);\n  float absDist = (1.0 - pow(2.0 * (alpha > 0.5 ? 1.0 - alpha : alpha), 1.0 / uTroikaSDFExponent)) * maxDimension;\n  float signedDist = absDist * (alpha > 0.5 ? -1.0 : 1.0);\n  return signedDist;\n}\n\nfloat troikaGlyphUvToSdfValue(vec2 glyphUV) {\n  vec2 textureUV = mix(vTroikaTextureUVBounds.xy, vTroikaTextureUVBounds.zw, glyphUV);\n  vec4 rgba = texture2D(uTroikaSDFTexture, textureUV);\n  float ch = floor(vTroikaTextureChannel + 0.5); //NOTE: can't use round() in WebGL1\n  return ch == 0.0 ? rgba.r : ch == 1.0 ? rgba.g : ch == 2.0 ? rgba.b : rgba.a;\n}\n\nfloat troikaGlyphUvToDistance(vec2 uv) {\n  return troikaSdfValueToSignedDistance(troikaGlyphUvToSdfValue(uv));\n}\n\nfloat troikaGetAADist() {\n  \n  #if defined(GL_OES_standard_derivatives) || __VERSION__ >= 300\n  return length(fwidth(vTroikaGlyphUV * vTroikaGlyphDimensions)) * 0.5;\n  #else\n  return vTroikaGlyphDimensions.x / 64.0;\n  #endif\n}\n\nfloat troikaGetFragDistValue() {\n  vec2 clampedGlyphUV = clamp(vTroikaGlyphUV, 0.5 / uTroikaSDFGlyphSize, 1.0 - 0.5 / uTroikaSDFGlyphSize);\n  float distance = troikaGlyphUvToDistance(clampedGlyphUV);\n \n  // Extrapolate distance when outside bounds:\n  distance += clampedGlyphUV == vTroikaGlyphUV ? 0.0 : \n    length((vTroikaGlyphUV - clampedGlyphUV) * vTroikaGlyphDimensions);\n\n  \n\n  return distance;\n}\n\nfloat troikaGetEdgeAlpha(float distance, float distanceOffset, float aaDist) {\n  #if defined(IS_DEPTH_MATERIAL) || defined(IS_DISTANCE_MATERIAL)\n  float alpha = step(-distanceOffset, -distance);\n  #else\n\n  float alpha = smoothstep(\n    distanceOffset + aaDist,\n    distanceOffset - aaDist,\n    distance\n  );\n  #endif\n\n  return alpha;\n}\n",
fragmentColorTransform:"\nfloat aaDist = troikaGetAADist();\nfloat fragDistance = troikaGetFragDistValue();\nfloat edgeAlpha = uTroikaSDFDebug ?\n  troikaGlyphUvToSdfValue(vTroikaGlyphUV) :\n  troikaGetEdgeAlpha(fragDistance, uTroikaDistanceOffset, max(aaDist, uTroikaBlurRadius));\n\n#if !defined(IS_DEPTH_MATERIAL) && !defined(IS_DISTANCE_MATERIAL)\nvec4 fillRGBA = gl_FragColor;\nfillRGBA.a *= uTroikaFillOpacity;\nvec4 strokeRGBA = uTroikaStrokeWidth == 0.0 ? fillRGBA : vec4(uTroikaStrokeColor, uTroikaStrokeOpacity);\nif (fillRGBA.a == 0.0) fillRGBA.rgb = strokeRGBA.rgb;\ngl_FragColor = mix(fillRGBA, strokeRGBA, smoothstep(\n  -uTroikaStrokeWidth - aaDist,\n  -uTroikaStrokeWidth + aaDist,\n  fragDistance\n));\ngl_FragColor.a *= edgeAlpha;\n#endif\n\nif (edgeAlpha == 0.0) {\n  discard;\n}\n",
customRewriter({vertexShader:f,fragmentShader:k}){let m=/\buniform\s+vec3\s+diffuse\b/;m.test(k)&&(k=k.replace(m,"varying vec3 vTroikaGlyphColor").replace(/\bdiffuse\b/g,"vTroikaGlyphColor"),m.test(f)||(f=f.replace(ja.voidMainRegExp,"uniform vec3 diffuse;\n$&\nvTroikaGlyphColor = uTroikaUseGlyphColors ? aTroikaGlyphColor / 255.0 : diffuse;\n")));return{vertexShader:f,fragmentShader:k}}});k.transparent=!0;Object.defineProperties(k,{isTroikaTextMaterial:{value:!0},shadowSide:{get(){return this.side},
set(){}}});return k}function Ga(k){let f=va.get(k);if(!f){let {caretPositions:p,caretHeight:m}=k;f=new Map;for(let b=0;b<p.length;b+=3){let a=p[b+2],c=f.get(a);c||f.set(a,c=[]);c.push({x:p[b],y:a,height:m,charIndex:b/3});b+3>=p.length&&c.push({x:p[b+1],y:a,height:m,charIndex:b/3+1})}}va.set(k,f);return f}var wa=ma(W);W=ma(V);let P=()=>(self.performance||Date).now(),X=wa["default"](),na,Aa=function(){function k(){const m=P();for(;f.length&&5>P()-m;)f.shift()();p=f.length?setTimeout(k,0):0}const f=
[];let p=0;return(...m)=>{const b=K.Thenable();f.push(()=>{const a=P();try{X.webgl.generateIntoCanvas(...m),b.resolve({timing:P()-a})}catch(c){b.reject(c)}});p||(p=setTimeout(k,0));return b}}(),oa=function(){const k={};let f=0;return function(p,m,b,a,c,d,e,g,h,l){const r="TroikaTextSDFGenerator_JS_"+f++%4;let E=k[r];E||(E=k[r]={workerModule:K.defineWorkerModule({name:r,workerId:r,dependencies:[wa["default"],P],init(a,b){const c=a().javascript.generate;return function(...a){const d=b();return{textureData:c(...a),
timing:b()-d}}},getTransferables(a){return[a.textureData.buffer]}}),requests:0,idleTimer:null});E.requests++;clearTimeout(E.idleTimer);return E.workerModule(p,m,b,a,c,d).then(({textureData:a,timing:b})=>{const c=P(),d=new Uint8Array(4*a.length);for(let b=0;b<a.length;b++)d[4*b+l]=a[b];X.webglUtils.renderImageData(e,d,g,h,p,m,1<<3-l);b+=P()-c;0===--E.requests&&(E.idleTimer=setTimeout(()=>{K.terminateWorker(r)},2E3));return{timing:b}})}}(),Fa=X.webglUtils.resizeWebGLCanvasWithoutClearing;V=K.defineWorkerModule({name:"Typr Font Parser",
dependencies:[function(){return"undefined"==typeof window&&(self.window=self),function(k){var f={parse:function(b){var a=f._bin;b=new Uint8Array(b);if("ttcf"==a.readASCII(b,0,4)){var c=4;a.readUshort(b,c);c+=2;a.readUshort(b,c);c+=2;var d=a.readUint(b,c);c+=4;for(var e=[],g=0;g<d;g++){var h=a.readUint(b,c);c+=4;e.push(f._readFont(b,h))}return e}return[f._readFont(b,0)]},_readFont:function(b,a){var c=f._bin,d=a;c.readFixed(b,a);a+=4;var e=c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;c.readUshort(b,
a);a+=2;c.readUshort(b,a);a+=2;var g="cmap;head;hhea;maxp;hmtx;name;OS/2;post;loca;glyf;kern;CFF ;GPOS;GSUB;SVG ".split(";");d={_data:b,_offset:d};for(var h={},l=0;l<e;l++){var r=c.readASCII(b,a,4);a+=4;c.readUint(b,a);a+=4;var k=c.readUint(b,a);a+=4;var m=c.readUint(b,a);a+=4;h[r]={offset:k,length:m}}for(l=0;l<g.length;l++)a=g[l],h[a]&&(d[a.trim()]=f[a.trim()].parse(b,h[a].offset,h[a].length,d));return d},_tabOffset:function(b,a,c){var d=f._bin,e=d.readUshort(b,c+4);c+=12;for(var g=0;g<e;g++){var h=
d.readASCII(b,c,4);c+=4;d.readUint(b,c);c+=4;var l=d.readUint(b,c);if(c+=4,d.readUint(b,c),c+=4,h==a)return l}return 0}};f._bin={readFixed:function(b,a){return(b[a]<<8|b[a+1])+(b[a+2]<<8|b[a+3])/65540},readF2dot14:function(b,a){return f._bin.readShort(b,a)/16384},readInt:function(b,a){return f._bin._view(b).getInt32(a)},readInt8:function(b,a){return f._bin._view(b).getInt8(a)},readShort:function(b,a){return f._bin._view(b).getInt16(a)},readUshort:function(b,a){return f._bin._view(b).getUint16(a)},
readUshorts:function(b,a,c){for(var d=[],e=0;e<c;e++)d.push(f._bin.readUshort(b,a+2*e));return d},readUint:function(b,a){return f._bin._view(b).getUint32(a)},readUint64:function(b,a){return 4294967296*f._bin.readUint(b,a)+f._bin.readUint(b,a+4)},readASCII:function(b,a,c){for(var d="",e=0;e<c;e++)d+=String.fromCharCode(b[a+e]);return d},readUnicode:function(b,a,c){for(var d="",e=0;e<c;e++){var g=b[a++]<<8|b[a++];d+=String.fromCharCode(g)}return d},_tdec:"undefined"!=typeof window&&window.TextDecoder?
new window.TextDecoder:null,readUTF8:function(b,a,c){var d=f._bin._tdec;return d&&0==a&&c==b.length?d.decode(b):f._bin.readASCII(b,a,c)},readBytes:function(b,a,c){for(var d=[],e=0;e<c;e++)d.push(b[a+e]);return d},readASCIIArray:function(b,a,c){for(var d=[],e=0;e<c;e++)d.push(String.fromCharCode(b[a+e]));return d},_view:function(b){return b._dataView||(b._dataView=b.buffer?new DataView(b.buffer,b.byteOffset,b.byteLength):new DataView((new Uint8Array(b)).buffer))}};f._lctf={};f._lctf.parse=function(b,
a,c,d,e){var g=f._bin;c={};d=a;g.readFixed(b,a);a+=4;var h=g.readUshort(b,a);a+=2;var l=g.readUshort(b,a);a=g.readUshort(b,a+2);return c.scriptList=f._lctf.readScriptList(b,d+h),c.featureList=f._lctf.readFeatureList(b,d+l),c.lookupList=f._lctf.readLookupList(b,d+a,e),c};f._lctf.readLookupList=function(b,a,c){var d=f._bin,e=a,g=[],h=d.readUshort(b,a);a+=2;for(var l=0;l<h;l++){var r=d.readUshort(b,a);a+=2;r=f._lctf.readLookupTable(b,e+r,c);g.push(r)}return g};f._lctf.readLookupTable=function(b,a,c){var d=
f._bin,e=a,g={tabs:[]};g.ltype=d.readUshort(b,a);a+=2;g.flag=d.readUshort(b,a);a+=2;var h=d.readUshort(b,a);a+=2;for(var l=g.ltype,r=0;r<h;r++){var k=d.readUshort(b,a);a+=2;k=c(b,l,e+k,g);g.tabs.push(k)}return g};f._lctf.numOfOnes=function(b){for(var a=0,c=0;32>c;c++)0!=(b>>>c&1)&&a++;return a};f._lctf.readClassDef=function(b,a){var c=f._bin,d=[],e=c.readUshort(b,a);if(a+=2,1==e){var g=c.readUshort(b,a);a+=2;var h=c.readUshort(b,a);a+=2;for(var l=0;l<h;l++)d.push(g+l),d.push(g+l),d.push(c.readUshort(b,
a)),a+=2}if(2==e)for(e=c.readUshort(b,a),a+=2,l=0;l<e;l++)d.push(c.readUshort(b,a)),a+=2,d.push(c.readUshort(b,a)),a+=2,d.push(c.readUshort(b,a)),a+=2;return d};f._lctf.getInterval=function(b,a){for(var c=0;c<b.length;c+=3){var d=b[c],e=b[c+1];if(b[c+2],d<=a&&a<=e)return c}return-1};f._lctf.readCoverage=function(b,a){var c=f._bin,d={};d.fmt=c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);return a+=2,1==d.fmt&&(d.tab=c.readUshorts(b,a,e)),2==d.fmt&&(d.tab=c.readUshorts(b,a,3*e)),d};f._lctf.coverageIndex=
function(b,a){var c=b.tab;return 1==b.fmt?c.indexOf(a):2==b.fmt&&(b=f._lctf.getInterval(c,a),-1!=b)?c[b+2]+(a-c[b]):-1};f._lctf.readFeatureList=function(b,a){var c=f._bin,d=a,e=[],g=c.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=c.readASCII(b,a,4);a+=4;var r=c.readUshort(b,a);a+=2;r=f._lctf.readFeatureTable(b,d+r);r.tag=l.trim();e.push(r)}return e};f._lctf.readFeatureTable=function(b,a){var c=f._bin,d=a,e={},g=c.readUshort(b,a);a+=2;0<g&&(e.featureParams=d+g);d=c.readUshort(b,a);a+=2;e.tab=[];
for(g=0;g<d;g++)e.tab.push(c.readUshort(b,a+2*g));return e};f._lctf.readScriptList=function(b,a){var c=f._bin,d=a,e={},g=c.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=c.readASCII(b,a,4);a+=4;var r=c.readUshort(b,a);a+=2;e[l.trim()]=f._lctf.readScriptTable(b,d+r)}return e};f._lctf.readScriptTable=function(b,a){var c=f._bin,d=a,e={},g=c.readUshort(b,a);a+=2;e.default=f._lctf.readLangSysTable(b,d+g);g=c.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=c.readASCII(b,a,4);a+=4;var r=c.readUshort(b,
a);a+=2;e[l.trim()]=f._lctf.readLangSysTable(b,d+r)}return e};f._lctf.readLangSysTable=function(b,a){var c=f._bin,d={};c.readUshort(b,a);a+=2;d.reqFeature=c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);return a+=2,d.features=c.readUshorts(b,a,e),d};f.CFF={};f.CFF.parse=function(b,a,c){var d=f._bin;(b=new Uint8Array(b.buffer,a,c))[a=0];b[++a];b[++a];b[++a];a++;var e=[];a=f.CFF.readIndex(b,a,e);var g=[];for(c=0;c<e.length-1;c++)g.push(d.readASCII(b,a+e[c],e[c+1]-e[c]));a+=e[e.length-1];e=[];a=f.CFF.readIndex(b,
a,e);g=[];for(c=0;c<e.length-1;c++)g.push(f.CFF.readDict(b,a+e[c],a+e[c+1]));a+=e[e.length-1];e=g[0];var h=[];a=f.CFF.readIndex(b,a,h);g=[];for(c=0;c<h.length-1;c++)g.push(d.readASCII(b,a+h[c],h[c+1]-h[c]));if(a+=h[h.length-1],f.CFF.readSubrs(b,a,e),e.CharStrings){a=e.CharStrings;h=[];a=f.CFF.readIndex(b,a,h);var l=[];for(c=0;c<h.length-1;c++)l.push(d.readBytes(b,a+h[c],h[c+1]-h[c]));e.CharStrings=l}if(e.ROS){a=e.FDArray;h=[];a=f.CFF.readIndex(b,a,h);e.FDArray=[];for(c=0;c<h.length-1;c++)l=f.CFF.readDict(b,
a+h[c],a+h[c+1]),f.CFF._readFDict(b,l,g),e.FDArray.push(l);a=e.FDSelect;e.FDSelect=[];c=b[a];if(a++,3!=c)throw c;h=d.readUshort(b,a);a+=2;for(c=0;c<h+1;c++)e.FDSelect.push(d.readUshort(b,a),b[a+2]),a+=3}return e.Encoding&&(e.Encoding=f.CFF.readEncoding(b,e.Encoding,e.CharStrings.length)),e.charset&&(e.charset=f.CFF.readCharset(b,e.charset,e.CharStrings.length)),f.CFF._readFDict(b,e,g),e};f.CFF._readFDict=function(b,a,c){var d,e;for(e in a.Private&&(d=a.Private[1],a.Private=f.CFF.readDict(b,d,d+a.Private[0]),
a.Private.Subrs&&f.CFF.readSubrs(b,d+a.Private.Subrs,a.Private)),a)-1!="FamilyName FontName FullName Notice version Copyright".split(" ").indexOf(e)&&(a[e]=c[a[e]-426+35])};f.CFF.readSubrs=function(b,a,c){var d=f._bin,e=[];a=f.CFF.readIndex(b,a,e);var g=e.length;c.Bias=1240>g?107:33900>g?1131:32768;c.Subrs=[];for(g=0;g<e.length-1;g++)c.Subrs.push(d.readBytes(b,a+e[g],e[g+1]-e[g]))};f.CFF.tableSE=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,0,111,112,113,114,0,115,116,117,118,119,120,121,122,0,123,0,124,125,126,127,128,129,130,131,0,132,133,0,134,135,136,137,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,138,0,139,0,0,0,0,140,141,142,143,0,0,0,0,0,144,0,0,0,145,0,0,146,147,148,149,0,0,0,0];f.CFF.glyphByUnicode=function(b,a){for(var c=0;c<b.charset.length;c++)if(b.charset[c]==a)return c;return-1};f.CFF.glyphBySE=function(b,a){return 0>a||255<a?-1:f.CFF.glyphByUnicode(b,f.CFF.tableSE[a])};f.CFF.readEncoding=function(b,a,c){f._bin;c=[".notdef"];var d=b[a];if(a++,0!=d)throw"error: unknown encoding format: "+d;d=b[a];a++;for(var e=0;e<d;e++)c.push(b[a+e]);return c};f.CFF.readCharset=function(b,
a,c){var d=f._bin,e=[".notdef"],g=b[a];if(a++,0==g)for(var h=0;h<c;h++){var l=d.readUshort(b,a);a+=2;e.push(l)}else{if(1!=g&&2!=g)throw"error: format: "+g;for(;e.length<c;){l=d.readUshort(b,a);a+=2;var r=0;1==g?(r=b[a],a++):(r=d.readUshort(b,a),a+=2);for(h=0;h<=r;h++)e.push(l),l++}}return e};f.CFF.readIndex=function(b,a,c){var d=f._bin,e=d.readUshort(b,a)+1,g=b[a+=2];if(a++,1==g)for(var h=0;h<e;h++)c.push(b[a+h]);else if(2==g)for(h=0;h<e;h++)c.push(d.readUshort(b,a+2*h));else if(3==g)for(h=0;h<e;h++)c.push(16777215&
d.readUint(b,a+3*h-1));else if(1!=e)throw"unsupported offset size: "+g+", count: "+e;return a+e*g-1};f.CFF.getCharString=function(b,a,c){var d=f._bin,e=b[a],g=b[a+1];b[a+2];b[a+3];b[a+4];var h=1,l=null,r=null;20>=e&&(l=e,h=1);12==e&&(l=100*e+g,h=2);21<=e&&27>=e&&(l=e,h=1);28==e&&(r=d.readShort(b,a+1),h=3);29<=e&&31>=e&&(l=e,h=1);32<=e&&246>=e&&(r=e-139,h=1);247<=e&&250>=e&&(r=256*(e-247)+g+108,h=2);251<=e&&254>=e&&(r=256*-(e-251)-g-108,h=2);255==e&&(r=d.readInt(b,a+1)/65535,h=5);c.val=null!=r?r:"o"+
l;c.size=h};f.CFF.readCharString=function(b,a,c){c=a+c;for(var d=f._bin,e=[];a<c;){var g=b[a],h=b[a+1];b[a+2];b[a+3];b[a+4];var l=1,r=null,k=null;20>=g&&(r=g,l=1);12==g&&(r=100*g+h,l=2);19!=g&&20!=g||(r=g,l=2);21<=g&&27>=g&&(r=g,l=1);28==g&&(k=d.readShort(b,a+1),l=3);29<=g&&31>=g&&(r=g,l=1);32<=g&&246>=g&&(k=g-139,l=1);247<=g&&250>=g&&(k=256*(g-247)+h+108,l=2);251<=g&&254>=g&&(k=256*-(g-251)-h-108,l=2);255==g&&(k=d.readInt(b,a+1)/65535,l=5);e.push(null!=k?k:"o"+r);a+=l}return e};f.CFF.readDict=function(b,
a,c){for(var d=f._bin,e={},g=[];a<c;){var h=b[a],l=b[a+1];b[a+2];b[a+3];b[a+4];var r=1,k=null,m=null;if(28==h&&(m=d.readShort(b,a+1),r=3),29==h&&(m=d.readInt(b,a+1),r=5),32<=h&&246>=h&&(m=h-139,r=1),247<=h&&250>=h&&(m=256*(h-247)+l+108,r=2),251<=h&&254>=h&&(m=256*-(h-251)-l-108,r=2),255==h)throw d.readInt(b,a+1),"unknown number";if(30==h){m=[];for(r=1;;){var n=b[a+r];r++;var t=n>>4;n&=15;if(15!=t&&m.push(t),15!=n&&m.push(n),15==n)break}t="";n=[0,1,2,3,4,5,6,7,8,9,".","e","e-","reserved","-","endOfNumber"];
for(var q=0;q<m.length;q++)t+=n[m[q]];m=parseFloat(t)}21>=h&&(k="version Notice FullName FamilyName Weight FontBBox BlueValues OtherBlues FamilyBlues FamilyOtherBlues StdHW StdVW escape UniqueID XUID charset Encoding CharStrings Private Subrs defaultWidthX nominalWidthX".split(" ")[h],r=1,12==h)&&(k=["Copyright","isFixedPitch","ItalicAngle","UnderlinePosition","UnderlineThickness","PaintType","CharstringType","FontMatrix","StrokeWidth","BlueScale","BlueShift","BlueFuzz","StemSnapH","StemSnapV","ForceBold",
0,0,"LanguageGroup","ExpansionFactor","initialRandomSeed","SyntheticBase","PostScript","BaseFontName","BaseFontBlend",0,0,0,0,0,0,"ROS","CIDFontVersion","CIDFontRevision","CIDFontType","CIDCount","UIDBase","FDArray","FDSelect","FontName"][l],r=2);null!=k?(e[k]=1==g.length?g[0]:g,g=[]):g.push(m);a+=r}return e};f.cmap={};f.cmap.parse=function(b,a,c){b=new Uint8Array(b.buffer,a,c);a=0;c=f._bin;var d={};c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);a+=2;var g=[];d.tables=[];for(var h=0;h<e;h++){var l=
c.readUshort(b,a);a+=2;var r=c.readUshort(b,a);a+=2;var k=c.readUint(b,a);a+=4;var m="p"+l+"e"+r,n=g.indexOf(k);if(-1==n){var t;n=d.tables.length;g.push(k);var q=c.readUshort(b,k);0==q?t=f.cmap.parse0(b,k):4==q?t=f.cmap.parse4(b,k):6==q?t=f.cmap.parse6(b,k):12==q?t=f.cmap.parse12(b,k):console.debug("unknown format: "+q,l,r,k);d.tables.push(t)}if(null!=d[m])throw"multiple tables for one platform+encoding";d[m]=n}return d};f.cmap.parse0=function(b,a){var c=f._bin,d={};d.format=c.readUshort(b,a);a+=
2;var e=c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;d.map=[];for(c=0;c<e-6;c++)d.map.push(b[a+c]);return d};f.cmap.parse4=function(b,a){var c=f._bin,d=a,e={};e.format=c.readUshort(b,a);a+=2;var g=c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;var h=c.readUshort(b,a);a+=2;h/=2;e.searchRange=c.readUshort(b,a);a+=2;e.entrySelector=c.readUshort(b,a);a+=2;e.rangeShift=c.readUshort(b,a);a+=2;e.endCount=c.readUshorts(b,a,h);a=a+2*h+2;e.startCount=c.readUshorts(b,a,h);a+=2*h;e.idDelta=[];for(var l=0;l<h;l++)e.idDelta.push(c.readShort(b,
a)),a+=2;e.idRangeOffset=c.readUshorts(b,a,h);a+=2*h;for(e.glyphIdArray=[];a<d+g;)e.glyphIdArray.push(c.readUshort(b,a)),a+=2;return e};f.cmap.parse6=function(b,a){var c=f._bin,d={};d.format=c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;d.firstCode=c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);a+=2;d.glyphIdArray=[];for(var g=0;g<e;g++)d.glyphIdArray.push(c.readUshort(b,a)),a+=2;return d};f.cmap.parse12=function(b,a){var c=f._bin,d={};d.format=c.readUshort(b,a);a=a+2+2;c.readUint(b,
a);a+=4;c.readUint(b,a);a+=4;var e=c.readUint(b,a);a+=4;d.groups=[];for(var g=0;g<e;g++){var h=a+12*g,l=c.readUint(b,h+0),r=c.readUint(b,h+4);h=c.readUint(b,h+8);d.groups.push([l,r,h])}return d};f.glyf={};f.glyf.parse=function(b,a,c,d){b=[];for(a=0;a<d.maxp.numGlyphs;a++)b.push(null);return b};f.glyf._parseGlyf=function(b,a){var c=f._bin,d=b._data,e=f._tabOffset(d,"glyf",b._offset)+b.loca[a];if(b.loca[a]==b.loca[a+1])return null;b={};if(b.noc=c.readShort(d,e),e+=2,b.xMin=c.readShort(d,e),e+=2,b.yMin=
c.readShort(d,e),e+=2,b.xMax=c.readShort(d,e),e+=2,b.yMax=c.readShort(d,e),e+=2,b.xMin>=b.xMax||b.yMin>=b.yMax)return null;if(0<b.noc){b.endPts=[];for(a=0;a<b.noc;a++)b.endPts.push(c.readUshort(d,e)),e+=2;a=c.readUshort(d,e);if(e+=2,d.length-e<a)return null;b.instructions=c.readBytes(d,e,a);e+=a;var g=b.endPts[b.noc-1]+1;b.flags=[];for(a=0;a<g;a++){var h=d[e];if(e++,b.flags.push(h),0!=(8&h)){var l=d[e];e++;for(var r=0;r<l;r++)b.flags.push(h),a++}}b.xs=[];for(a=0;a<g;a++)h=0!=(2&b.flags[a]),l=0!=(16&
b.flags[a]),h?(b.xs.push(l?d[e]:-d[e]),e++):l?b.xs.push(0):(b.xs.push(c.readShort(d,e)),e+=2);b.ys=[];for(a=0;a<g;a++)h=0!=(4&b.flags[a]),l=0!=(32&b.flags[a]),h?(b.ys.push(l?d[e]:-d[e]),e++):l?b.ys.push(0):(b.ys.push(c.readShort(d,e)),e+=2);for(a=e=d=0;a<g;a++)d+=b.xs[a],e+=b.ys[a],b.xs[a]=d,b.ys[a]=e}else{b.parts=[];do a=c.readUshort(d,e),e+=2,g={m:{a:1,b:0,c:0,d:1,tx:0,ty:0},p1:-1,p2:-1},(b.parts.push(g),g.glyphIndex=c.readUshort(d,e),e+=2,1&a)?(h=c.readShort(d,e),e+=2,l=c.readShort(d,e),e+=2):
(h=c.readInt8(d,e),e++,l=c.readInt8(d,e),e++),2&a?(g.m.tx=h,g.m.ty=l):(g.p1=h,g.p2=l),8&a?(g.m.a=g.m.d=c.readF2dot14(d,e),e+=2):64&a?(g.m.a=c.readF2dot14(d,e),e+=2,g.m.d=c.readF2dot14(d,e),e+=2):128&a&&(g.m.a=c.readF2dot14(d,e),e+=2,g.m.b=c.readF2dot14(d,e),e+=2,g.m.c=c.readF2dot14(d,e),e+=2,g.m.d=c.readF2dot14(d,e),e+=2);while(32&a);if(256&a)for(c=c.readUshort(d,e),e+=2,b.instr=[],a=0;a<c;a++)b.instr.push(d[e]),e++}return b};f.GPOS={};f.GPOS.parse=function(b,a,c,d){return f._lctf.parse(b,a,c,d,f.GPOS.subt)};
f.GPOS.subt=function(b,a,c,d){var e=f._bin,g=c,h={};if(h.fmt=e.readUshort(b,c),c+=2,1==a||2==a||3==a||7==a||8==a&&2>=h.fmt){var l=e.readUshort(b,c);c+=2;h.coverage=f._lctf.readCoverage(b,l+g)}if(1==a&&1==h.fmt)d=e.readUshort(b,c),c+=2,f._lctf.numOfOnes(d),0!=d&&(h.pos=f.GPOS.readValueRecord(b,c,d));else if(2==a&&1<=h.fmt&&2>=h.fmt){d=e.readUshort(b,c);c+=2;l=e.readUshort(b,c);c+=2;a=f._lctf.numOfOnes(d);var r=f._lctf.numOfOnes(l);if(1==h.fmt){h.pairsets=[];var k=e.readUshort(b,c);c+=2;for(var m=0;m<
k;m++){var n=g+e.readUshort(b,c);c+=2;var t=e.readUshort(b,n);n+=2;for(var q=[],v=0;v<t;v++){var u=e.readUshort(b,n);n+=2;0!=d&&(w=f.GPOS.readValueRecord(b,n,d),n+=2*a);0!=l&&(p=f.GPOS.readValueRecord(b,n,l),n+=2*r);q.push({gid2:u,val1:w,val2:p})}h.pairsets.push(q)}}if(2==h.fmt)for(w=e.readUshort(b,c),c+=2,p=e.readUshort(b,c),c+=2,k=e.readUshort(b,c),c+=2,e=e.readUshort(b,c),c+=2,h.classDef1=f._lctf.readClassDef(b,g+w),h.classDef2=f._lctf.readClassDef(b,g+p),h.matrix=[],m=0;m<k;m++){g=[];for(v=0;v<
e;v++){var w=null,p=null;0!=d&&(w=f.GPOS.readValueRecord(b,c,d),c+=2*a);0!=l&&(p=f.GPOS.readValueRecord(b,c,l),c+=2*r);g.push({val1:w,val2:p})}h.matrix.push(g)}}else{if(9==a&&1==h.fmt){h=e.readUshort(b,c);c=e.readUint(b,c+2);if(9==d.ltype)d.ltype=h;else if(d.ltype!=h)throw"invalid extension substitution";return f.GPOS.subt(b,d.ltype,g+c)}console.debug("unsupported GPOS table LookupType",a,"format",h.fmt)}return h};f.GPOS.readValueRecord=function(b,a,c){var d=f._bin,e=[];return e.push(1&c?d.readShort(b,
a):0),a+=1&c?2:0,e.push(2&c?d.readShort(b,a):0),a+=2&c?2:0,e.push(4&c?d.readShort(b,a):0),a+=4&c?2:0,e.push(8&c?d.readShort(b,a):0),e};f.GSUB={};f.GSUB.parse=function(b,a,c,d){return f._lctf.parse(b,a,c,d,f.GSUB.subt)};f.GSUB.subt=function(b,a,c,d){var e=f._bin,g=c,h={};if(h.fmt=e.readUshort(b,c),c+=2,1!=a&&4!=a&&5!=a&&6!=a)return null;if(1==a||4==a||5==a&&2>=h.fmt||6==a&&2>=h.fmt){var l=e.readUshort(b,c);c+=2;h.coverage=f._lctf.readCoverage(b,g+l)}if(1==a&&1<=h.fmt&&2>=h.fmt)1==h.fmt?h.delta=e.readShort(b,
c):2==h.fmt&&(a=e.readUshort(b,c),h.newg=e.readUshorts(b,c+2,a));else if(4==a)for(h.vals=[],a=e.readUshort(b,c),c+=2,d=0;d<a;d++)l=e.readUshort(b,c),c+=2,h.vals.push(f.GSUB.readLigatureSet(b,g+l));else if(5==a&&2==h.fmt){if(2==h.fmt)for(d=e.readUshort(b,c),c+=2,h.cDef=f._lctf.readClassDef(b,g+d),h.scset=[],a=e.readUshort(b,c),c+=2,d=0;d<a;d++)l=e.readUshort(b,c),c+=2,h.scset.push(0==l?null:f.GSUB.readSubClassSet(b,g+l))}else if(6==a&&3==h.fmt){if(3==h.fmt){for(d=0;3>d;d++){a=e.readUshort(b,c);c+=
2;l=[];for(var r=0;r<a;r++)l.push(f._lctf.readCoverage(b,g+e.readUshort(b,c+2*r)));c+=2*a;0==d&&(h.backCvg=l);1==d&&(h.inptCvg=l);2==d&&(h.ahedCvg=l)}a=e.readUshort(b,c);h.lookupRec=f.GSUB.readSubstLookupRecords(b,c+2,a)}}else{if(7==a&&1==h.fmt){h=e.readUshort(b,c);c=e.readUint(b,c+2);if(9==d.ltype)d.ltype=h;else if(d.ltype!=h)throw"invalid extension substitution";return f.GSUB.subt(b,d.ltype,g+c)}console.debug("unsupported GSUB table LookupType",a,"format",h.fmt)}return h};f.GSUB.readSubClassSet=
function(b,a){var c=f._bin.readUshort,d=a,e=[],g=c(b,a);a+=2;for(var h=0;h<g;h++){var l=c(b,a);a+=2;e.push(f.GSUB.readSubClassRule(b,d+l))}return e};f.GSUB.readSubClassRule=function(b,a){var c=f._bin.readUshort,d={},e=c(b,a),g=c(b,a+=2);a+=2;d.input=[];for(var h=0;h<e-1;h++)d.input.push(c(b,a)),a+=2;return d.substLookupRecords=f.GSUB.readSubstLookupRecords(b,a,g),d};f.GSUB.readSubstLookupRecords=function(b,a,c){for(var d=f._bin.readUshort,e=[],g=0;g<c;g++)e.push(d(b,a),d(b,a+2)),a+=4;return e};f.GSUB.readChainSubClassSet=
function(b,a){var c=f._bin,d=a,e=[],g=c.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=c.readUshort(b,a);a+=2;e.push(f.GSUB.readChainSubClassRule(b,d+l))}return e};f.GSUB.readChainSubClassRule=function(b,a){for(var c=f._bin,d={},e=["backtrack","input","lookahead"],g=0;g<e.length;g++){var h=c.readUshort(b,a);a+=2;1==g&&h--;d[e[g]]=c.readUshorts(b,a,h);a+=2*d[e[g]].length}h=c.readUshort(b,a);return a+=2,d.subst=c.readUshorts(b,a,2*h),d};f.GSUB.readLigatureSet=function(b,a){var c=f._bin,d=a,e=[],g=
c.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=c.readUshort(b,a);a+=2;e.push(f.GSUB.readLigature(b,d+l))}return e};f.GSUB.readLigature=function(b,a){var c=f._bin,d={chain:[]};d.nglyph=c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);a+=2;for(var g=0;g<e-1;g++)d.chain.push(c.readUshort(b,a)),a+=2;return d};f.head={};f.head.parse=function(b,a,c){c=f._bin;var d={};return c.readFixed(b,a),a+=4,d.fontRevision=c.readFixed(b,a),a+=4,c.readUint(b,a),a+=4,c.readUint(b,a),a+=4,d.flags=c.readUshort(b,a),a+=
2,d.unitsPerEm=c.readUshort(b,a),a+=2,d.created=c.readUint64(b,a),a+=8,d.modified=c.readUint64(b,a),a+=8,d.xMin=c.readShort(b,a),a+=2,d.yMin=c.readShort(b,a),a+=2,d.xMax=c.readShort(b,a),a+=2,d.yMax=c.readShort(b,a),a+=2,d.macStyle=c.readUshort(b,a),a+=2,d.lowestRecPPEM=c.readUshort(b,a),a+=2,d.fontDirectionHint=c.readShort(b,a),a+=2,d.indexToLocFormat=c.readShort(b,a),a+=2,d.glyphDataFormat=c.readShort(b,a),d};f.hhea={};f.hhea.parse=function(b,a,c){c=f._bin;var d={};return c.readFixed(b,a),a+=4,
d.ascender=c.readShort(b,a),a+=2,d.descender=c.readShort(b,a),a+=2,d.lineGap=c.readShort(b,a),a+=2,d.advanceWidthMax=c.readUshort(b,a),a+=2,d.minLeftSideBearing=c.readShort(b,a),a+=2,d.minRightSideBearing=c.readShort(b,a),a+=2,d.xMaxExtent=c.readShort(b,a),a+=2,d.caretSlopeRise=c.readShort(b,a),a+=2,d.caretSlopeRun=c.readShort(b,a),a+=2,d.caretOffset=c.readShort(b,a),a+=2,a+=8,d.metricDataFormat=c.readShort(b,a),a+=2,d.numberOfHMetrics=c.readUshort(b,a),d};f.hmtx={};f.hmtx.parse=function(b,a,c,d){c=
f._bin;for(var e={aWidth:[],lsBearing:[]},g=0,h=0,l=0;l<d.maxp.numGlyphs;l++)l<d.hhea.numberOfHMetrics&&(g=c.readUshort(b,a),a+=2,h=c.readShort(b,a),a+=2),e.aWidth.push(g),e.lsBearing.push(h);return e};f.kern={};f.kern.parse=function(b,a,c,d){var e=f._bin,g=e.readUshort(b,a);if(a+=2,1==g)return f.kern.parseV1(b,a-2,c,d);c=e.readUshort(b,a);a+=2;d={glyph1:[],rval:[]};for(g=0;g<c;g++){a+=2;e.readUshort(b,a);a+=2;var h=e.readUshort(b,a);a+=2;h>>>=8;if(0!=(h&=15))throw"unknown kern table format: "+h;
a=f.kern.readFormat0(b,a,d)}return d};f.kern.parseV1=function(b,a,c,d){c=f._bin;c.readFixed(b,a);a+=4;d=c.readUint(b,a);a+=4;for(var e={glyph1:[],rval:[]},g=0;g<d;g++){c.readUint(b,a);a+=4;var h=c.readUshort(b,a);a+=2;c.readUshort(b,a);a+=2;h>>>=8;if(0!=(h&=15))throw"unknown kern table format: "+h;a=f.kern.readFormat0(b,a,e)}return e};f.kern.readFormat0=function(b,a,c){var d=f._bin,e=-1,g=d.readUshort(b,a);a+=2;d.readUshort(b,a);a+=2;d.readUshort(b,a);a+=2;d.readUshort(b,a);a+=2;for(var h=0;h<g;h++){var l=
d.readUshort(b,a);a+=2;var r=d.readUshort(b,a);a+=2;var k=d.readShort(b,a);a+=2;l!=e&&(c.glyph1.push(l),c.rval.push({glyph2:[],vals:[]}));e=c.rval[c.rval.length-1];e.glyph2.push(r);e.vals.push(k);e=l}return a};f.loca={};f.loca.parse=function(b,a,c,d){c=f._bin;var e=[],g=d.head.indexToLocFormat;d=d.maxp.numGlyphs+1;if(0==g)for(var h=0;h<d;h++)e.push(c.readUshort(b,a+(h<<1))<<1);if(1==g)for(h=0;h<d;h++)e.push(c.readUint(b,a+(h<<2)));return e};f.maxp={};f.maxp.parse=function(b,a,c){c=f._bin;var d={},
e=c.readUint(b,a);return a+=4,d.numGlyphs=c.readUshort(b,a),a+=2,65536==e&&(d.maxPoints=c.readUshort(b,a),a+=2,d.maxContours=c.readUshort(b,a),a+=2,d.maxCompositePoints=c.readUshort(b,a),a+=2,d.maxCompositeContours=c.readUshort(b,a),a+=2,d.maxZones=c.readUshort(b,a),a+=2,d.maxTwilightPoints=c.readUshort(b,a),a+=2,d.maxStorage=c.readUshort(b,a),a+=2,d.maxFunctionDefs=c.readUshort(b,a),a+=2,d.maxInstructionDefs=c.readUshort(b,a),a+=2,d.maxStackElements=c.readUshort(b,a),a+=2,d.maxSizeOfInstructions=
c.readUshort(b,a),a+=2,d.maxComponentElements=c.readUshort(b,a),a+=2,d.maxComponentDepth=c.readUshort(b,a)),d};f.name={};f.name.parse=function(b,a,c){c=f._bin;var d={};c.readUshort(b,a);a+=2;var e=c.readUshort(b,a);a+=2;c.readUshort(b,a);for(var g,h="copyright fontFamily fontSubfamily ID fullName version postScriptName trademark manufacturer designer description urlVendor urlDesigner licence licenceURL --- typoFamilyName typoSubfamilyName compatibleFull sampleText postScriptCID wwsFamilyName wwsSubfamilyName lightPalette darkPalette".split(" "),
l=a+=2,r=0;r<e;r++){var k=c.readUshort(b,a);a+=2;var m=c.readUshort(b,a);a+=2;var n=c.readUshort(b,a);a+=2;var t=c.readUshort(b,a);a+=2;var q=c.readUshort(b,a);a+=2;var v=c.readUshort(b,a);a+=2;var u=h[t];v=l+12*e+v;if(0==k)q=c.readUnicode(b,v,q/2);else if(3==k&&0==m)q=c.readUnicode(b,v,q/2);else if(0==m)q=c.readASCII(b,v,q);else if(1==m)q=c.readUnicode(b,v,q/2);else if(3==m)q=c.readUnicode(b,v,q/2);else{if(1!=k)throw"unknown encoding "+m+", platformID: "+k;q=c.readASCII(b,v,q);console.debug("reading unknown MAC encoding "+
m+" as ASCII")}k="p"+k+","+n.toString(16);null==d[k]&&(d[k]={});d[k][void 0!==u?u:t]=q;d[k]._lang=n}for(var w in d)if(null!=d[w].postScriptName&&1033==d[w]._lang)return d[w];for(w in d)if(null!=d[w].postScriptName&&0==d[w]._lang)return d[w];for(w in d)if(null!=d[w].postScriptName&&3084==d[w]._lang)return d[w];for(w in d)if(null!=d[w].postScriptName)return d[w];for(w in d){g=w;break}return console.debug("returning name table with languageID "+d[g]._lang),d[g]};f["OS/2"]={};f["OS/2"].parse=function(b,
a,c){c=f._bin.readUshort(b,a);a+=2;var d={};if(0==c)f["OS/2"].version0(b,a,d);else if(1==c)f["OS/2"].version1(b,a,d);else if(2==c||3==c||4==c)f["OS/2"].version2(b,a,d);else{if(5!=c)throw"unknown OS/2 table version: "+c;f["OS/2"].version5(b,a,d)}return d};f["OS/2"].version0=function(b,a,c){var d=f._bin;return c.xAvgCharWidth=d.readShort(b,a),a+=2,c.usWeightClass=d.readUshort(b,a),a+=2,c.usWidthClass=d.readUshort(b,a),a+=2,c.fsType=d.readUshort(b,a),a+=2,c.ySubscriptXSize=d.readShort(b,a),a+=2,c.ySubscriptYSize=
d.readShort(b,a),a+=2,c.ySubscriptXOffset=d.readShort(b,a),a+=2,c.ySubscriptYOffset=d.readShort(b,a),a+=2,c.ySuperscriptXSize=d.readShort(b,a),a+=2,c.ySuperscriptYSize=d.readShort(b,a),a+=2,c.ySuperscriptXOffset=d.readShort(b,a),a+=2,c.ySuperscriptYOffset=d.readShort(b,a),a+=2,c.yStrikeoutSize=d.readShort(b,a),a+=2,c.yStrikeoutPosition=d.readShort(b,a),a+=2,c.sFamilyClass=d.readShort(b,a),a+=2,c.panose=d.readBytes(b,a,10),a+=10,c.ulUnicodeRange1=d.readUint(b,a),a+=4,c.ulUnicodeRange2=d.readUint(b,
a),a+=4,c.ulUnicodeRange3=d.readUint(b,a),a+=4,c.ulUnicodeRange4=d.readUint(b,a),a+=4,c.achVendID=[d.readInt8(b,a),d.readInt8(b,a+1),d.readInt8(b,a+2),d.readInt8(b,a+3)],a+=4,c.fsSelection=d.readUshort(b,a),a+=2,c.usFirstCharIndex=d.readUshort(b,a),a+=2,c.usLastCharIndex=d.readUshort(b,a),a+=2,c.sTypoAscender=d.readShort(b,a),a+=2,c.sTypoDescender=d.readShort(b,a),a+=2,c.sTypoLineGap=d.readShort(b,a),a+=2,c.usWinAscent=d.readUshort(b,a),a+=2,c.usWinDescent=d.readUshort(b,a),a+2};f["OS/2"].version1=
function(b,a,c){var d=f._bin;return a=f["OS/2"].version0(b,a,c),c.ulCodePageRange1=d.readUint(b,a),a+=4,c.ulCodePageRange2=d.readUint(b,a),a+4};f["OS/2"].version2=function(b,a,c){var d=f._bin;return a=f["OS/2"].version1(b,a,c),c.sxHeight=d.readShort(b,a),a+=2,c.sCapHeight=d.readShort(b,a),a+=2,c.usDefault=d.readUshort(b,a),a+=2,c.usBreak=d.readUshort(b,a),a+=2,c.usMaxContext=d.readUshort(b,a),a+2};f["OS/2"].version5=function(b,a,c){var d=f._bin;return a=f["OS/2"].version2(b,a,c),c.usLowerOpticalPointSize=
d.readUshort(b,a),a+=2,c.usUpperOpticalPointSize=d.readUshort(b,a),a+2};f.post={};f.post.parse=function(b,a,c){c=f._bin;var d={};return d.version=c.readFixed(b,a),a+=4,d.italicAngle=c.readFixed(b,a),a+=4,d.underlinePosition=c.readShort(b,a),a+=2,d.underlineThickness=c.readShort(b,a),d};null==f&&(f={});null==f.U&&(f.U={});f.U.codeToGlyph=function(b,a){b=b.cmap;var c=-1;if(null!=b.p0e4?c=b.p0e4:null!=b.p3e1?c=b.p3e1:null!=b.p1e0?c=b.p1e0:null!=b.p0e3&&(c=b.p0e3),-1==c)throw"no familiar platform and encoding!";
b=b.tables[c];if(0==b.format)return a>=b.map.length?0:b.map[a];if(4==b.format){var d=-1;for(c=0;c<b.endCount.length;c++)if(a<=b.endCount[c]){d=c;break}return-1==d||b.startCount[d]>a?0:65535&(0!=b.idRangeOffset[d]?b.glyphIdArray[a-b.startCount[d]+(b.idRangeOffset[d]>>1)-(b.idRangeOffset.length-d)]:a+b.idDelta[d])}if(12==b.format){if(a>b.groups[b.groups.length-1][1])return 0;for(c=0;c<b.groups.length;c++)if(d=b.groups[c],d[0]<=a&&a<=d[1])return d[2]+(a-d[0]);return 0}throw"unknown cmap table format "+
b.format;};f.U.glyphToPath=function(b,a){var c={cmds:[],crds:[]};if(b.SVG&&b.SVG.entries[a]){var d=b.SVG.entries[a];return null==d?c:("string"==typeof d&&(d=f.SVG.toPath(d),b.SVG.entries[a]=d),d)}if(b.CFF){d={x:0,y:0,stack:[],nStems:0,haveWidth:!1,width:b.CFF.Private?b.CFF.Private.defaultWidthX:0,open:!1};var e=b.CFF,g=b.CFF.Private;if(e.ROS){for(g=0;e.FDSelect[g+2]<=a;)g+=2;g=e.FDArray[e.FDSelect[g+1]].Private}f.U._drawCFF(b.CFF.CharStrings[a],d,e,g,c)}else b.glyf&&f.U._drawGlyf(a,b,c);return c};
f.U._drawGlyf=function(b,a,c){var d=a.glyf[b];null==d&&(d=a.glyf[b]=f.glyf._parseGlyf(a,b));null!=d&&(-1<d.noc?f.U._simpleGlyph(d,c):f.U._compoGlyph(d,a,c))};f.U._simpleGlyph=function(b,a){for(var c=0;c<b.noc;c++){for(var d=0==c?0:b.endPts[c-1]+1,e=b.endPts[c],g=d;g<=e;g++){var h=g==d?e:g-1,l=g==e?d:g+1,k=1&b.flags[g],m=1&b.flags[h],p=1&b.flags[l],n=b.xs[g],t=b.ys[g];if(g==d)if(k){if(!m){f.U.P.moveTo(a,n,t);continue}f.U.P.moveTo(a,b.xs[h],b.ys[h])}else m?f.U.P.moveTo(a,b.xs[h],b.ys[h]):f.U.P.moveTo(a,
(b.xs[h]+n)/2,(b.ys[h]+t)/2);k?m&&f.U.P.lineTo(a,n,t):p?f.U.P.qcurveTo(a,n,t,b.xs[l],b.ys[l]):f.U.P.qcurveTo(a,n,t,(n+b.xs[l])/2,(t+b.ys[l])/2)}f.U.P.closePath(a)}};f.U._compoGlyph=function(b,a,c){for(var d=0;d<b.parts.length;d++){var e={cmds:[],crds:[]},g=b.parts[d];f.U._drawGlyf(g.glyphIndex,a,e);g=g.m;for(var h=0;h<e.crds.length;h+=2){var l=e.crds[h],k=e.crds[h+1];c.crds.push(l*g.a+k*g.b+g.tx);c.crds.push(l*g.c+k*g.d+g.ty)}for(h=0;h<e.cmds.length;h++)c.cmds.push(e.cmds[h])}};f.U._getGlyphClass=
function(b,a){b=f._lctf.getInterval(a,b);return-1==b?0:a[b+2]};f.U.getPairAdjustment=function(b,a,c){var d=0,e=!1;if(b.GPOS){var g=b.GPOS,h=g.lookupList;g=g.featureList;for(var l=[],k=0;k<g.length;k++){var m=g[k];if("kern"==m.tag){e=!0;for(var p=0;p<m.tab.length;p++)if(!l[m.tab[p]]){l[m.tab[p]]=!0;for(var n=h[m.tab[p]],t=0;t<n.tabs.length;t++)if(null!=n.tabs[t]){var q,v=n.tabs[t];if((!v.coverage||-1!=(q=f._lctf.coverageIndex(v.coverage,a)))&&1!=n.ltype&&2==n.ltype){var u;if(1==v.fmt)for(v=v.pairsets[q],
k=0;k<v.length;k++)v[k].gid2==c&&(u=v[k]);else if(2==v.fmt){u=f.U._getGlyphClass(a,v.classDef1);var w=f.U._getGlyphClass(c,v.classDef2);u=v.matrix[u][w]}u&&u.val1&&u.val1[2]&&(d+=u.val1[2]);u&&u.val2&&u.val2[0]&&(d+=u.val2[0])}}}}}}b.kern&&!e&&(a=b.kern.glyph1.indexOf(a),-1!=a&&(c=b.kern.rval[a].glyph2.indexOf(c),-1!=c&&(d+=b.kern.rval[a].vals[c])));return d};f.U._applySubs=function(b,a,c,d){for(var e=b.length-a-1,g=0;g<c.tabs.length;g++)if(null!=c.tabs[g]){var h,l=c.tabs[g];if(!l.coverage||-1!=(h=
f._lctf.coverageIndex(l.coverage,b[a])))if(1==c.ltype)b[a],1==l.fmt?b[a]+=l.delta:b[a]=l.newg[h];else if(4==c.ltype)for(var k=l.vals[h],m=0;m<k.length;m++){var p=k[m];l=p.chain.length;if(!(l>e)){for(var n=!0,t=0,q=0;q<l;q++){for(;-1==b[a+t+(1+q)];)t++;p.chain[q]!=b[a+t+(1+q)]&&(n=!1)}if(n){b[a]=p.nglyph;for(q=0;q<l+t;q++)b[a+q+1]=-1;break}}}else if(5==c.ltype&&2==l.fmt)for(k=f._lctf.getInterval(l.cDef,b[a]),t=l.scset[l.cDef[k+2]],p=0;p<t.length;p++){m=t[p];var v=m.input;if(!(v.length>e)){n=!0;for(q=
0;q<v.length;q++){var u=f._lctf.getInterval(l.cDef,b[a+1+q]);if(-1==k&&l.cDef[u+2]!=v[q]){n=!1;break}}if(n)for(n=m.substLookupRecords,m=0;m<n.length;m+=2)n[m],n[m+1]}}else if(6==c.ltype&&3==l.fmt&&f.U._glsCovered(b,l.backCvg,a-l.backCvg.length)&&f.U._glsCovered(b,l.inptCvg,a)&&f.U._glsCovered(b,l.ahedCvg,a+l.inptCvg.length))for(n=l.lookupRec,p=0;p<n.length;p+=2)k=n[p],f.U._applySubs(b,a+k,d[n[p+1]],d)}};f.U._glsCovered=function(b,a,c){for(var d=0;d<a.length;d++)if(-1==f._lctf.coverageIndex(a[d],b[c+
d]))return!1;return!0};f.U.glyphsToPath=function(b,a,c){for(var d={cmds:[],crds:[]},e=0,g=0;g<a.length;g++){var h=a[g];if(-1!=h){for(var l=g<a.length-1&&-1!=a[g+1]?a[g+1]:0,k=f.U.glyphToPath(b,h),m=0;m<k.crds.length;m+=2)d.crds.push(k.crds[m]+e),d.crds.push(k.crds[m+1]);c&&d.cmds.push(c);for(m=0;m<k.cmds.length;m++)d.cmds.push(k.cmds[m]);c&&d.cmds.push("X");e+=b.hmtx.aWidth[h];g<a.length-1&&(e+=f.U.getPairAdjustment(b,h,l))}}return d};f.U.P={};f.U.P.moveTo=function(b,a,c){b.cmds.push("M");b.crds.push(a,
c)};f.U.P.lineTo=function(b,a,c){b.cmds.push("L");b.crds.push(a,c)};f.U.P.curveTo=function(b,a,c,d,e,g,f){b.cmds.push("C");b.crds.push(a,c,d,e,g,f)};f.U.P.qcurveTo=function(b,a,c,d,e){b.cmds.push("Q");b.crds.push(a,c,d,e)};f.U.P.closePath=function(b){b.cmds.push("Z")};f.U._drawCFF=function(b,a,c,d,e){for(var g=a.stack,h=a.nStems,l=a.haveWidth,k=a.width,m=a.open,p=0,n=a.x,t=a.y,q=0,v=0,u=0,w=0,D=0,G=0,B=0,H=0,I=0,F=0,N={val:0,size:0};p<b.length;){f.CFF.getCharString(b,p,N);var C=N.val;if(p+=N.size,
"o1"==C||"o18"==C)0!=g.length%2&&!l&&(k=g.shift()+d.nominalWidthX),h+=g.length>>1,g.length=0,l=!0;else if("o3"==C||"o23"==C)0!=g.length%2&&!l&&(k=g.shift()+d.nominalWidthX),h+=g.length>>1,g.length=0,l=!0;else if("o4"==C)1<g.length&&!l&&(k=g.shift()+d.nominalWidthX,l=!0),m&&f.U.P.closePath(e),t+=g.pop(),f.U.P.moveTo(e,n,t),m=!0;else if("o5"==C)for(;0<g.length;)n+=g.shift(),t+=g.shift(),f.U.P.lineTo(e,n,t);else if("o6"==C||"o7"==C){var y=g.length,J="o6"==C;for(C=0;C<y;C++){var z=g.shift();J?n+=z:t+=
z;J=!J;f.U.P.lineTo(e,n,t)}}else if("o8"==C||"o24"==C){y=g.length;for(J=0;J+6<=y;)q=n+g.shift(),v=t+g.shift(),u=q+g.shift(),w=v+g.shift(),n=u+g.shift(),t=w+g.shift(),f.U.P.curveTo(e,q,v,u,w,n,t),J+=6;"o24"==C&&(n+=g.shift(),t+=g.shift(),f.U.P.lineTo(e,n,t))}else{if("o11"==C)break;if("o1234"==C||"o1235"==C||"o1236"==C||"o1237"==C)"o1234"==C&&(v=t,u=(q=n+g.shift())+g.shift(),F=w=v+g.shift(),G=w,H=t,n=(B=(D=(I=u+g.shift())+g.shift())+g.shift())+g.shift(),f.U.P.curveTo(e,q,v,u,w,I,F),f.U.P.curveTo(e,
D,G,B,H,n,t)),"o1235"==C&&(q=n+g.shift(),v=t+g.shift(),u=q+g.shift(),w=v+g.shift(),I=u+g.shift(),F=w+g.shift(),D=I+g.shift(),G=F+g.shift(),B=D+g.shift(),H=G+g.shift(),n=B+g.shift(),t=H+g.shift(),g.shift(),f.U.P.curveTo(e,q,v,u,w,I,F),f.U.P.curveTo(e,D,G,B,H,n,t)),"o1236"==C&&(q=n+g.shift(),v=t+g.shift(),u=q+g.shift(),F=w=v+g.shift(),G=w,B=(D=(I=u+g.shift())+g.shift())+g.shift(),H=G+g.shift(),n=B+g.shift(),f.U.P.curveTo(e,q,v,u,w,I,F),f.U.P.curveTo(e,D,G,B,H,n,t)),"o1237"==C&&(q=n+g.shift(),v=t+g.shift(),
u=q+g.shift(),w=v+g.shift(),I=u+g.shift(),F=w+g.shift(),D=I+g.shift(),G=F+g.shift(),B=D+g.shift(),H=G+g.shift(),Math.abs(B-n)>Math.abs(H-t)?n=B+g.shift():t=H+g.shift(),f.U.P.curveTo(e,q,v,u,w,I,F),f.U.P.curveTo(e,D,G,B,H,n,t));else if("o14"==C){if(0<g.length&&!l&&(k=g.shift()+c.nominalWidthX,l=!0),4==g.length)y=g.shift(),J=g.shift(),z=g.shift(),C=g.shift(),z=f.CFF.glyphBySE(c,z),C=f.CFF.glyphBySE(c,C),f.U._drawCFF(c.CharStrings[z],a,c,d,e),a.x=y,a.y=J,f.U._drawCFF(c.CharStrings[C],a,c,d,e);m&&(f.U.P.closePath(e),
m=!1)}else if("o19"==C||"o20"==C)0!=g.length%2&&!l&&(k=g.shift()+d.nominalWidthX),h+=g.length>>1,g.length=0,l=!0,p+=h+7>>3;else if("o21"==C)2<g.length&&!l&&(k=g.shift()+d.nominalWidthX,l=!0),t+=g.pop(),n+=g.pop(),m&&f.U.P.closePath(e),f.U.P.moveTo(e,n,t),m=!0;else if("o22"==C)1<g.length&&!l&&(k=g.shift()+d.nominalWidthX,l=!0),n+=g.pop(),m&&f.U.P.closePath(e),f.U.P.moveTo(e,n,t),m=!0;else if("o25"==C){for(;6<g.length;)n+=g.shift(),t+=g.shift(),f.U.P.lineTo(e,n,t);q=n+g.shift();v=t+g.shift();u=q+g.shift();
w=v+g.shift();n=u+g.shift();t=w+g.shift();f.U.P.curveTo(e,q,v,u,w,n,t)}else if("o26"==C)for(g.length%2&&(n+=g.shift());0<g.length;)q=n,v=t+g.shift(),n=u=q+g.shift(),t=(w=v+g.shift())+g.shift(),f.U.P.curveTo(e,q,v,u,w,n,t);else if("o27"==C)for(g.length%2&&(t+=g.shift());0<g.length;)v=t,u=(q=n+g.shift())+g.shift(),w=v+g.shift(),n=u+g.shift(),t=w,f.U.P.curveTo(e,q,v,u,w,n,t);else if("o10"==C||"o29"==C)y="o10"==C?d:c,0==g.length?console.debug("error: empty stack"):(J=g.pop(),y=y.Subrs[J+y.Bias],a.x=n,
a.y=t,a.nStems=h,a.haveWidth=l,a.width=k,a.open=m,f.U._drawCFF(y,a,c,d,e),n=a.x,t=a.y,h=a.nStems,l=a.haveWidth,k=a.width,m=a.open);else if("o30"==C||"o31"==C)for(y=g.length,C=(J=0,"o31"==C),J+=y-(y&=-3);J<y;)C?(v=t,u=(q=n+g.shift())+g.shift(),t=(w=v+g.shift())+g.shift(),5==y-J?(n=u+g.shift(),J++):n=u,C=!1):(q=n,v=t+g.shift(),u=q+g.shift(),w=v+g.shift(),n=u+g.shift(),5==y-J?(t=w+g.shift(),J++):t=w,C=!0),f.U.P.curveTo(e,q,v,u,w,n,t),J+=4;else{if("o"==(C+"").charAt(0))throw console.debug("Unknown operation: "+
C,b),C;g.push(C)}}}a.x=n;a.y=t;a.nStems=h;a.haveWidth=l;a.width=k;a.open=m};var p=f,m={Typr:p};return k.Typr=p,k.default=m,Object.defineProperty(k,"__esModule",{value:!0}),k}({}).Typr},function(){return function(k){var f=Uint8Array,p=Uint16Array,m=Uint32Array,b=new f([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),a=new f([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),c=new f([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),d=function(a,b){for(var c=
new p(31),d=0;31>d;++d)c[d]=b+=1<<a[d-1];a=new m(c[30]);for(d=1;30>d;++d)for(b=c[d];b<c[d+1];++b)a[b]=b-c[d]<<5|d;return[c,a]},e=d(b,2),g=e[0];e=e[1];g[28]=258;e[258]=28;var h=d(a,0)[0],l=new p(32768);for(d=0;32768>d;++d)e=(43690&d)>>>1|(21845&d)<<1,e=(61680&(e=(52428&e)>>>2|(13107&e)<<2))>>>4|(3855&e)<<4,l[d]=((65280&e)>>>8|(255&e)<<8)>>>1;var r=function(a,b,c){for(var d=a.length,e=0,g=new p(b);e<d;++e)++g[a[e]-1];var f=new p(b);for(e=0;e<b;++e)f[e]=f[e-1]+g[e-1]<<1;if(c)for(c=new p(1<<b),g=15-b,
e=0;e<d;++e){if(a[e]){var h=e<<4|a[e],n=b-a[e],k=f[a[e]-1]++<<n;for(n=k|(1<<n)-1;k<=n;++k)c[l[k]>>>g]=h}}else for(c=new p(d),e=0;e<d;++e)a[e]&&(c[e]=l[f[a[e]-1]++]>>>15-a[e]);return c};e=new f(288);for(d=0;144>d;++d)e[d]=8;for(d=144;256>d;++d)e[d]=9;for(d=256;280>d;++d)e[d]=7;for(d=280;288>d;++d)e[d]=8;var y=new f(32);for(d=0;32>d;++d)y[d]=5;var ba=r(e,9,1),n=r(y,5,1),t=function(a){for(var b=a[0],c=1;c<a.length;++c)a[c]>b&&(b=a[c]);return b},q=function(a,b,c){var d=b/8|0;return(a[d]|a[d+1]<<8)>>(7&
b)&c},v=function(a,b){var c=b/8|0;return(a[c]|a[c+1]<<8|a[c+2]<<16)>>(7&b)},u=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],w=function(a,b,c){b=Error(b||u[a]);if(b.code=a,Error.captureStackTrace&&Error.captureStackTrace(b,w),!c)throw b;return b},D=function(d,e,k){var l=d.length;
if(!l||k&&!k.l&&5>l)return e||new f(0);var u=!e||k,y=!k||k.i;k||(k={});e||(e=new f(3*l));var C,H=function(a){var b=e.length;a>b&&(a=new f(Math.max(2*b,a)),a.set(e),e=a)},D=k.f||0,z=k.p||0,B=k.b||0,G=k.l,E=k.d,x=k.m,T=k.n,K=8*l;do{if(!G){k.f=D=q(d,z,1);var A=q(d,z+1,3);if(z+=3,!A){z=d[(U=((C=z)/8|0)+(7&C&&1)+4)-4]|d[U-3]<<8;A=U+z;if(A>l){y&&w(0);break}u&&H(B+z);e.set(d.subarray(U,A),B);k.b=B+=z;k.p=z=8*A;continue}if(1==A)G=ba,E=n,x=9,T=5;else if(2==A){x=q(d,z,31)+257;E=q(d,z+10,15)+4;G=x+q(d,z+5,31)+
1;z+=14;T=new f(G);var M=new f(19);for(A=0;A<E;++A)M[c[A]]=q(d,z+3*A,7);z+=3*E;A=t(M);E=(1<<A)-1;var ka=r(M,A,1);for(A=0;A<G;){var U;U=ka[q(d,z,E)];if(z+=15&U,16>(U>>>=4))T[A++]=U;else{var ca=M=0;for(16==U?(ca=3+q(d,z,3),z+=2,M=T[A-1]):17==U?(ca=3+q(d,z,7),z+=3):18==U&&(ca=11+q(d,z,127),z+=7);ca--;)T[A++]=M}}G=T.subarray(0,x);A=T.subarray(x);x=t(G);T=t(A);G=r(G,x,1);E=r(A,T,1)}else w(1);if(z>K){y&&w(0);break}}u&&H(B+131072);ka=(1<<x)-1;ca=(1<<T)-1;for(var la=z;;la=z){A=(M=G[v(d,z)&ka])>>>4;if((z+=
15&M)>K){y&&w(0);break}if(M||w(2),256>A)e[B++]=A;else{if(256==A){la=z;G=null;break}M=A-254;if(264<A){var L=b[A-=257];M=q(d,z,(1<<L)-1)+g[A];z+=L}A=E[v(d,z)&ca];L=A>>>4;A||w(3);z+=15&A;A=h[L];3<L&&(L=a[L],A+=v(d,z)&(1<<L)-1,z+=L);if(z>K){y&&w(0);break}u&&H(B+131072);for(M=B+M;B<M;B+=4)e[B]=e[B-A],e[B+1]=e[B+1-A],e[B+2]=e[B+2-A],e[B+3]=e[B+3-A];B=M}}k.l=G;k.p=la;k.b=B;G&&(D=1,k.m=x,k.d=E,k.n=T)}while(!D);return B==e.length?e:function(a,b,c){(null==b||0>b)&&(b=0);(null==c||c>a.length)&&(c=a.length);
var d=new (a instanceof p?p:a instanceof m?m:f)(c-b);return d.set(a.subarray(b,c)),d}(e,0,B)};d=new f(0);e="undefined"!=typeof TextDecoder&&new TextDecoder;try{e.decode(d,{stream:!0}),1}catch(G){}return k.convert_streams=function(a){function b(){var a=g.getUint16(f);return f+=2,a}function c(){var a=g.getUint32(f);return f+=4,a}function d(a){p.setUint16(w,a);w+=2}function e(a){p.setUint32(w,a);w+=4}var g=new DataView(a),f=0;c();var h=c();c();var n=b();b();c();b();b();c();c();c();c();c();for(var k=
0;Math.pow(2,k)<=n;)k++;k--;for(var l=16*Math.pow(2,k),t=16*n-l,q=12,m=[],v=0;v<n;v++)m.push({tag:c(),offset:c(),compLength:c(),origLength:c(),origChecksum:c()}),q+=16;var u,r=new Uint8Array(12+16*m.length+m.reduce(function(a,b){return a+b.origLength+4},0));v=r.buffer;var p=new DataView(v),w=0;return e(h),d(n),d(l),d(k),d(t),m.forEach(function(a){e(a.tag);e(a.origChecksum);e(q);e(a.origLength);a.outOffset=q;0!=(q+=a.origLength)%4&&(q+=4-q%4)}),m.forEach(function(b){var c=a.slice(b.offset,b.offset+
b.compLength);if(b.compLength!=b.origLength){var d=new Uint8Array(b.origLength);c=new Uint8Array(c,2);D(c,d)}else d=new Uint8Array(c);r.set(d,b.outOffset);d=0;0!=(q=b.outOffset+b.origLength)%4&&(d=4-q%4);r.set((new Uint8Array(d)).buffer,b.outOffset+b.origLength);u=q+d}),v.slice(0,u)},Object.defineProperty(k,"__esModule",{value:!0}),k}({}).convert_streams},function(k,f){function p(a){if(!d){let a={R:2,L:1,D:4,C:16,U:32,T:8};d=new Map;for(let b in c){let e=0;c[b].split(",").forEach(c=>{let [g,f]=c.split("+");
g=parseInt(g,36);f=f?parseInt(f,36):0;d.set(e+=g,a[b]);for(c=f;c--;)d.set(++e,a[b])})}}return d.get(a)||32}function m(a,b){let c=[];for(let d=0;d<b.length;d++){let e=b.codePointAt(d);65535<e&&d++;c.push(k.U.codeToGlyph(a,e))}if(a=a.GSUB){let {lookupList:d,featureList:g}=a,f,h=/^(rlig|liga|mset|isol|init|fina|medi|half|pres|blws)$/,l=[];g.forEach(a=>{if(h.test(a.tag))for(let h=0;h<a.tab.length;h++){if(l[a.tab[h]])continue;l[a.tab[h]]=!0;let n=d[a.tab[h]],q=/^(isol|init|fina|medi)$/.test(a.tag);if(q&&
!f){{var g=b;let a=new Uint8Array(g.length),c=32,d=1,e=-1;for(let b=0;b<g.length;b++){let f=g.codePointAt(b),h=p(f)|0,n=1;h&8||(c&21?h&22?(n=3,1!==d&&3!==d||a[e]++):h&33&&(2===d||4===d)&&a[e]--:c&34&&(2===d||4===d)&&a[e]--,d=a[b]=n,c=h,e=b,65535<f&&b++)}f=a}}for(g=0;g<c.length;g++)f&&q&&e[f[g]]!==a.tag||k.U._applySubs(c,g,n,d)}})}return c}function b(b){let c=Object.create(null),d={unitsPerEm:b.head.unitsPerEm,ascender:b.hhea.ascender,descender:b.hhea.descender,forEachGlyph(e,g,f,h){let n=0;const l=
1/d.unitsPerEm*g;let v=0,u=-1;m(b,e).forEach((d,q)=>{if(-1!==d){q=c[d];if(!q){const {cmds:e,crds:g}=k.U.glyphToPath(b,d);q="";var t=0;for(let b=0,c=e.length;b<c;b++){var m=a[e[b]];q+=e[b];for(var r=1;r<=m;r++)q+=(1<r?",":"")+g[t++]}let f;if(g.length){t=m=Infinity;r=f=-Infinity;for(let a=0,b=g.length;a<b;a+=2){let b=g[a],c=g[a+1];b<t&&(t=b);c<m&&(m=c);b>r&&(r=b);c>f&&(f=c)}}else t=r=m=f=0;q=c[d]={index:d,advanceWidth:b.hmtx.aWidth[d],xMin:t,yMin:m,xMax:r,yMax:f,path:q,pathCommandCount:e.length}}-1!==
u&&(n+=k.U.getPairAdjustment(b,u,d)*l);h.call(null,q,n,v);q.advanceWidth&&(n+=q.advanceWidth*l);f&&(n+=f*g);u=d}v+=65535<e.codePointAt(v)?2:1});return n}};return d}let a={M:2,L:2,Q:4,C:6,Z:0},c={C:"18g,ca,368,1kz",D:"17k,6,2,2+4,5+c,2+6,2+1,10+1,9+f,j+11,2+1,a,2,2+1,15+2,3,j+2,6+3,2+8,2,2,2+1,w+a,4+e,3+3,2,3+2,3+5,23+w,2f+4,3,2+9,2,b,2+3,3,1k+9,6+1,3+1,2+2,2+d,30g,p+y,1,1+1g,f+x,2,sd2+1d,jf3+4,f+3,2+4,2+2,b+3,42,2,4+2,2+1,2,3,t+1,9f+w,2,el+2,2+g,d+2,2l,2+1,5,3+1,2+1,2,3,6,16wm+1v",R:"17m+3,2,2,6+3,m,15+2,2+2,h+h,13,3+8,2,2,3+1,2,p+1,x,5+4,5,a,2,2,3,u,c+2,g+1,5,2+1,4+1,5j,6+1,2,b,2+2,f,2+1,1s+2,2,3+1,7,1ez0,2,2+1,4+4,b,4,3,b,42,2+2,4,3,2+1,2,o+3,ae,ep,x,2o+2,3+1,3,5+1,6",
L:"x9u,jff,a,fd,jv",T:"4t,gj+33,7o+4,1+1,7c+18,2,2+1,2+1,2,21+a,2,1b+k,h,2u+6,3+5,3+1,2+3,y,2,v+q,2k+a,1n+8,a,p+3,2+8,2+2,2+4,18+2,3c+e,2+v,1k,2,5+7,5,4+6,b+1,u,1n,5+3,9,l+1,r,3+1,1m,5+1,5+1,3+2,4,v+1,4,c+1,1m,5+4,2+1,5,l+1,n+5,2,1n,3,2+3,9,8+1,c+1,v,1q,d,1f,4,1m+2,6+2,2+3,8+1,c+1,u,1n,3,7,6+1,l+1,t+1,1m+1,5+3,9,l+1,u,21,8+2,2,2j,3+6,d+7,2r,3+8,c+5,23+1,s,2,2,1k+d,2+4,2+1,6+a,2+z,a,2v+3,2+5,2+1,3+1,q+1,5+2,h+3,e,3+1,7,g,jk+2,qb+2,u+2,u+1,v+1,1t+1,2+6,9,3+a,a,1a+2,3c+1,z,3b+2,5+1,a,7+2,64+1,3,1n,2+6,2,2,3+7,7+9,3,1d+d,1,1+1,1s+3,1d,2+4,2,6,15+8,d+1,x+3,3+1,2+2,1l,2+1,4,2+2,1n+7,3+1,49+2,2+c,2+6,5,7,4+1,5j+1l,2+4,ek,3+1,r+4,1e+4,6+5,2p+c,1+3,1,1+2,1+b,2db+2,3y,2p+v,ff+3,30+1,n9x,1+2,2+9,x+1,29+1,7l,4,5,q+1,6,48+1,r+h,e,13+7,q+a,1b+2,1d,3+3,3+1,14,1w+5,3+1,3+1,d,9,1c,1g,2+2,3+1,6+1,2,17+1,9,6n,3,5,fn5,ki+f,h+f,5s,6y+2,ea,6b,46+4,1af+2,2+1,6+3,15+2,5,4m+1,fy+3,as+1,4a+a,4x,1j+e,1l+2,1e+3,3+1,1y+2,11+4,2+7,1r,d+1,1h+8,b+3,3,2o+2,3,2+1,7,4h,4+7,m+1,1m+1,4,12+6,4+4,5g+7,3+2,2,o,2d+5,2,5+1,2+1,6n+3,7+1,2+1,s+1,2e+7,3,2+1,2z,2,3+5,2,2u+2,3+3,2+4,78+8,2+1,75+1,2,5,41+3,3+1,5,x+9,15+5,3+3,9,a+5,3+2,1b+c,2+1,bb+6,2+5,2,2b+l,3+6,2+1,2+1,3f+5,4,2+1,2+6,2,21+1,4,2,9o+1,470+8,at4+4,1o+6,t5,1s+3,2a,f5l+1,2+3,43o+2,a+7,1+7,3+6,v+3,45+2,1j0+1i,5+1d,9,f,n+4,2+e,11t+6,2+g,3+6,2+1,2+4,7a+6,c6+3,15t+6,32+6,1,gzau,v+2n,3l+6n"},
d,e=[null,"isol","init","fina","medi"];return function(a){var c=new Uint8Array(a,0,4);c=k._bin.readASCII(c,0,4);if("wOFF"===c)a=f(a);else if("wOF2"===c)throw Error("woff2 fonts not supported");return b(k.parse(a)[0])}}],init(k,f,p){k=k();f=f();return p(k,f)}});let S={defaultFontURL:"https://fonts.gstatic.com/s/roboto/v18/KFOmCnqEu92Fr1Mu4mxM.woff",sdfGlyphSize:64,sdfMargin:.0625,sdfExponent:9,textureWidth:2048},Ca=new y.Color,qa=!1,aa=Object.create(null),Y;W=K.defineWorkerModule({name:"Typesetter",
dependencies:[S,V,function(k,f,p){function m(a,b){function c(){let d=b=>{console.error(`Failure loading font ${a}${a===h?"":"; trying fallback"}`,b);a!==h&&(a=h,c())};try{let c=new XMLHttpRequest;c.open("get",a,!0);c.responseType="arraybuffer";c.onload=function(){if(400<=c.status)d(Error(c.statusText));else if(0<c.status)try{let a=k(c.response);b(a)}catch(w){d(w)}};c.onerror=d;c.send()}catch(u){d(u)}}c()}function b(a,b){a||(a=h);let c=l[a];c?c.pending?c.pending.push(b):b(c):(l[a]={pending:[b]},m(a,
b=>{let c=l[a].pending;l[a]=b;c.forEach(a=>a(b))}))}function a({text:a="",font:k=h,fontSize:l=1,letterSpacing:m=0,lineHeight:u="normal",maxWidth:p=Infinity,direction:D,textAlign:G="left",textIndent:B=0,whiteSpace:x="normal",overflowWrap:E="normal",anchorX:F=0,anchorY:N=0,includeCaretPositions:C=!1,chunkedBoundsSize:K=8192,colorRanges:J=null},z,ba=!1){let h=e(),n={fontLoad:0,typesetting:0};-1<a.indexOf("\r")&&(console.info("Typesetter: got text with \\r chars; normalizing to \\n"),a=a.replace(/\r\n/g,
"\n").replace(/\r/g,"\n"));l=+l;m=+m;p=+p;u=u||"normal";B=+B;b(k,b=>{let k=isFinite(p),q=null,t=null,v=null,w=null,H=null,I=null,S=null,L=0,P=0,W="nowrap"!==x,{ascender:O,descender:da,unitsPerEm:V}=b;n.fontLoad=e()-h;let aa=e(),Q=l/V;"normal"===u&&(u=(O-da)/V);u*=l;var ia=(u-(O-da)*Q)/2;let X=-(O*Q+ia),Y=Math.min(u,(O-da)*Q),ja=(O+da)/2*Q-Y/2,ea=B,R=new g,fa=[R];b.forEachGlyph(a,l,m,(b,c,d)=>{let e=a.charAt(d),f=b.advanceWidth*Q;var h=R.count;"isEmpty"in b||(b.isWhitespace=!!e&&/\s/.test(e),b.canBreakAfter=
!!e&&y.test(e),b.isEmpty=b.xMin===b.xMax||b.yMin===b.yMax||r.test(e));b.isWhitespace||b.isEmpty||P++;if(W&&k&&!b.isWhitespace&&c+f+ea>p&&h){if(R.glyphAt(h-1).glyphObj.canBreakAfter){var n=new g;ea=-c}else for(;h--;)if(0===h&&"break-word"===E){n=new g;ea=-c;break}else if(R.glyphAt(h).glyphObj.canBreakAfter){n=R.splitAt(h+1);h=n.glyphAt(0).x;ea-=h;for(let a=n.count;a--;)n.glyphAt(a).x-=h;break}n&&(R.isSoftWrapped=!0,R=n,fa.push(R),L=p)}n=R.glyphAt(R.count);n.glyphObj=b;n.x=c+ea;n.width=f;n.charIndex=
d;"\n"===e&&(R=new g,fa.push(R),ea=-(c+f+m*l)+B)});fa.forEach(a=>{for(let b=a.count;b--;){let {glyphObj:c,x:d,width:e}=a.glyphAt(b);if(!c.isWhitespace){a.width=d+e;a.width>L&&(L=a.width);break}}});let Z=0,ha=0;F&&("number"===typeof F?Z=-F:"string"===typeof F&&(Z=-L*("left"===F?0:"center"===F?.5:"right"===F?1:c(F))));if(N)if("number"===typeof N)ha=-N;else if("string"===typeof N){let a=fa.length*u;ha="top"===N?0:"top-baseline"===N?-X:"middle"===N?a/2:"bottom"===N?a:"bottom-baseline"===N?a-ia+da*Q:c(N)*
a}if(!ba){let c=f.getEmbeddingLevels(a,D);q=new Uint16Array(P);t=new Float32Array(2*P);v={};I=[Infinity,Infinity,-Infinity,-Infinity];S=[];let e=X;C&&(H=new Float32Array(3*a.length));J&&(w=new Uint8Array(3*P));let g=0,h=-1,k=-1,n,l;fa.forEach((m,r)=>{let {count:p,width:y}=m;if(0<p){r=0;for(var B=p;B--&&m.glyphAt(B).glyphObj.isWhitespace;)r++;var z=B=0;if("center"===G)B=(L-y)/2;else if("right"===G)B=L-y;else if("justify"===G&&m.isSoftWrapped){z=0;for(var A=p-r;A--;)m.glyphAt(A).glyphObj.isWhitespace&&
z++;z=(L-y)/z}if(z||B){A=0;for(var D=0;D<p;D++){var x=m.glyphAt(D),E=x.glyphObj;x.x+=B+A;0!==z&&E.isWhitespace&&D<p-r&&(A+=z,x.width+=z)}}B=f.getReorderSegments(a,c,m.glyphAt(0).charIndex,m.glyphAt(m.count-1).charIndex);for(z=0;z<B.length;z++){let [a,b]=B[z];A=Infinity;D=-Infinity;for(x=0;x<p;x++)if(m.glyphAt(x).charIndex>=a){for(E=x;x<p;x++){var F=m.glyphAt(x);if(F.charIndex>b)break;x<p-r&&(A=Math.min(A,F.x),D=Math.max(D,F.x+F.width))}for(;E<x;E++)F=m.glyphAt(E),F.x=D-(F.x+F.width-A);break}}let u;
r=a=>u=a;for(B=0;B<p;B++){A=m.glyphAt(B);u=A.glyphObj;z=u.index;(D=c.levels[A.charIndex]&1)&&(x=f.getMirroredCharacter(a[A.charIndex]))&&b.forEachGlyph(x,0,0,r);C&&({charIndex:x}=A,E=A.x+Z,F=A.x+A.width+Z,H[3*x]=D?F:E,H[3*x+1]=D?E:F,H[3*x+2]=e+ja+ha,D=x-h,1<D&&d(H,h,D),h=x);if(J)for({charIndex:D}=A;D>k;)k++,J.hasOwnProperty(k)&&(l=J[k]);if(!u.isWhitespace&&!u.isEmpty){D=g++;v[z]||(v[z]={path:u.path,pathBounds:[u.xMin,u.yMin,u.xMax,u.yMax]});E=A.x+Z;F=e+ha;t[2*D]=E;t[2*D+1]=F;A=E+u.xMin*Q;x=F+u.yMin*
Q;E+=u.xMax*Q;F+=u.yMax*Q;A<I[0]&&(I[0]=A);x<I[1]&&(I[1]=x);E>I[2]&&(I[2]=E);F>I[3]&&(I[3]=F);0===D%K&&(n={start:D,end:D,rect:[Infinity,Infinity,-Infinity,-Infinity]},S.push(n));n.end++;let a=n.rect;A<a[0]&&(a[0]=A);x<a[1]&&(a[1]=x);E>a[2]&&(a[2]=E);F>a[3]&&(a[3]=F);q[D]=z;J&&(z=3*D,w[z]=l>>16&255,w[z+1]=l>>8&255,w[z+2]=l&255)}}}e-=u});H&&(ia=a.length-h,1<ia&&d(H,h,ia))}n.typesetting=e()-aa;z({glyphIds:q,glyphPositions:t,glyphData:v,caretPositions:H,caretHeight:Y,glyphColors:w,chunkedBounds:S,fontSize:l,
unitsPerEm:V,ascender:O*Q,descender:da*Q,lineHeight:u,topBaseline:X,blockBounds:[Z,ha-fa.length*u,Z+L,ha],visibleBounds:I,timings:n})})}function c(a){a=(a=a.match(/^([\d.]+)%$/))?parseFloat(a[1]):NaN;return isNaN(a)?0:a/100}function d(a,b,c){let d=a[3*b],e=a[3*b+2],g=(a[3*b+1]-d)/c;for(let f=0;f<c;f++){let c=3*(b+f);a[c]=d+g*f;a[c+1]=d+g*(f+1);a[c+2]=e}}function e(){return(self.performance||Date).now()}function g(){this.data=[]}let {defaultFontURL:h}=p,l=Object.create(null),r=/[\u00AD\u034F\u061C\u115F-\u1160\u17B4-\u17B5\u180B-\u180E\u200B-\u200F\u202A-\u202E\u2060-\u206F\u3164\uFE00-\uFE0F\uFEFF\uFFA0\uFFF0-\uFFF8]/,
y=/[\s\-\u007C\u00AD\u2010\u2012-\u2014\u2027\u2056\u2E17\u2E40]/,x=["glyphObj","x","width","charIndex"];g.prototype={width:0,isSoftWrapped:!1,get count(){return Math.ceil(this.data.length/x.length)},glyphAt(a){let b=g.flyweight;b.data=this.data;b.index=a;return b},splitAt(a){let b=new g;b.data=this.data.splice(a*x.length);return b}};g.flyweight=x.reduce((a,b,c,d)=>{Object.defineProperty(a,b,{get(){return this.data[this.index*x.length+c]},set(a){this.data[this.index*x.length+c]=a}});return a},{data:null,
index:0});return{typeset:a,measure:function(b,c){a(b,a=>{let [b,d,e,g]=a.blockBounds;c({width:e-b,height:g-d})},{metricsOnly:!0})},loadFont:b}},W["default"]],init(k,f,p,m){({defaultFontURL:k}=k);return p(f,m(),{defaultFontURL:k})}});let Ea=K.defineWorkerModule({name:"Typesetter",dependencies:[W,K.ThenableWorkerModule],init(k,f){return function(p){const m=new f;k.typeset(p,m.resolve);return m}},getTransferables(k){const f=[k.glyphPositions.buffer,k.glyphIds.buffer];k.caretPositions&&f.push(k.caretPositions.buffer);
k.glyphColors&&f.push(k.glyphColors.buffer);return f}}),xa=(()=>{function k(a){var b=m[a];if(!b){b=new y.PlaneBufferGeometry(1,1,a,a);const c=b.clone(),e=b.attributes,g=c.attributes,f=new y.BufferGeometry,k=e.uv.count;for(let a=0;a<k;a++)g.position.array[3*a]*=-1,g.normal.array[3*a+2]*=-1;["position","normal","uv"].forEach(a=>{f.setAttribute(a,new y.Float32BufferAttribute([...e[a].array,...g[a].array],e[a].itemSize))});f.setIndex([...b.index.array,...c.index.array.map(a=>a+k)]);f.translate(.5,.5,
0);b=m[a]=f}return b}function f(a,b,d,e){const c=a.getAttribute(b);d?c&&c.array.length===d.length?(c.array.set(d),c.needsUpdate=!0):(a.setAttribute(b,new y.InstancedBufferAttribute(d,e)),delete a._maxInstanceCount,a.dispose()):c&&a.deleteAttribute(b)}function p(a,b){a[a.hasOwnProperty("instanceCount")?"instanceCount":"maxInstancedCount"]=b}const m={};class b extends y.InstancedBufferGeometry{constructor(){super();this.detail=1;this.curveRadius=0;this.groups=[{start:0,count:Infinity,materialIndex:0},
{start:0,count:Infinity,materialIndex:1}];this.boundingSphere=new y.Sphere;this.boundingBox=new y.Box3}computeBoundingSphere(){}computeBoundingBox(){}setSide(a){const b=this.getIndex().count;this.setDrawRange(a===y.BackSide?b/2:0,a===y.DoubleSide?b:b/2)}set detail(a){if(a!==this._detail){this._detail=a;if("number"!==typeof a||1>a)a=1;let b=k(a);["position","normal","uv"].forEach(a=>{this.attributes[a]=b.attributes[a].clone()});this.setIndex(b.getIndex().clone())}}get detail(){return this._detail}set curveRadius(a){a!==
this._curveRadius&&(this._curveRadius=a,this._updateBounds())}get curveRadius(){return this._curveRadius}updateGlyphs(a,b,d,e,g){f(this,"aTroikaGlyphBounds",a,4);f(this,"aTroikaGlyphIndex",b,1);f(this,"aTroikaGlyphColor",g,3);this._blockBounds=d;this._chunkedBounds=e;p(this,b.length);this._updateBounds()}_updateBounds(){const a=this._blockBounds;if(a){const {curveRadius:c,boundingBox:g}=this;if(c){const {PI:e,floor:f,min:k,max:m,sin:p,cos:n}=Math;var b=e/2,d=2*e;const t=Math.abs(c),q=a[0]/t,v=a[2]/
t,u=f((q+b)/d)!==f((v+b)/d)?-t:k(p(q)*t,p(v)*t);b=f((q-b)/d)!==f((v-b)/d)?t:m(p(q)*t,p(v)*t);d=f((q+e)/d)!==f((v+e)/d)?2*t:m(t-n(q)*t,t-n(v)*t);g.min.set(u,a[1],0>c?-d:0);g.max.set(b,a[3],0>c?0:d)}else g.min.set(a[0],a[1],0),g.max.set(a[2],a[3],0);g.getBoundingSphere(this.boundingSphere)}}applyClipRect(a){let b=this.getAttribute("aTroikaGlyphIndex").count,d=this._chunkedBounds;if(d)for(let c=d.length;c--;){b=d[c].end;let e=d[c].rect;if(e[1]<a.w&&e[3]>a.y&&e[0]<a.z&&e[2]>a.x)break}p(this,b)}}b.prototype.setAttribute||
(b.prototype.setAttribute=function(a,b){this.attributes[a]=b;return this});return b})();V=(()=>{function k(a){return Array.isArray(a)?a[0]:a}const f=new y.MeshBasicMaterial({color:16777215,side:y.DoubleSide,transparent:!0}),p=new y.Matrix4,m=new y.Vector3,b=new y.Vector3,a=[],c=new y.Vector3;let d=()=>{const a=new y.Mesh(new y.PlaneBufferGeometry(1,1),f);d=()=>a;return a},e=()=>{const a=new y.Mesh(new y.PlaneBufferGeometry(1,1,32,1),f);e=()=>a;return a};const g={type:"syncstart"},h={type:"synccomplete"},
l="font fontSize letterSpacing lineHeight maxWidth overflowWrap text direction textAlign textIndent whiteSpace anchorX anchorY colorRanges sdfGlyphSize".split(" "),r=l.concat("material","color","depthOffset","clipRect","curveRadius","orientation","glyphGeometryDetail");class x extends y.Mesh{constructor(){super(new xa,null);this.text="";this.curveRadius=this.anchorY=this.anchorX=0;this.direction="auto";this.font=null;this.fontSize=.1;this.letterSpacing=0;this.lineHeight="normal";this.maxWidth=Infinity;
this.overflowWrap="normal";this.textAlign="left";this.textIndent=0;this.whiteSpace="normal";this.colorRanges=this.color=this.material=null;this.outlineColor=this.outlineWidth=0;this.outlineOpacity=1;this.strokeWidth=this.outlineOffsetY=this.outlineOffsetX=this.outlineBlur=0;this.strokeColor=8421504;this.fillOpacity=this.strokeOpacity=1;this.depthOffset=0;this.clipRect=null;this.orientation="+x+y";this.glyphGeometryDetail=1;this.sdfGlyphSize=null;this.gpuAccelerateSDF=!0;this.debugSDF=!1}sync(a){this._needsSync&&
(this._needsSync=!1,this._isSyncing?(this._queuedSyncs||(this._queuedSyncs=[])).push(a):(this._isSyncing=!0,this.dispatchEvent(g),pa({text:this.text,font:this.font,fontSize:this.fontSize||.1,letterSpacing:this.letterSpacing||0,lineHeight:this.lineHeight||"normal",maxWidth:this.maxWidth,direction:this.direction||"auto",textAlign:this.textAlign,textIndent:this.textIndent,whiteSpace:this.whiteSpace,overflowWrap:this.overflowWrap,anchorX:this.anchorX,anchorY:this.anchorY,colorRanges:this.colorRanges,
includeCaretPositions:!0,sdfGlyphSize:this.sdfGlyphSize,gpuAccelerateSDF:this.gpuAccelerateSDF},b=>{this._isSyncing=!1;this._textRenderInfo=b;this.geometry.updateGlyphs(b.glyphBounds,b.glyphAtlasIndices,b.blockBounds,b.chunkedBounds,b.glyphColors);const c=this._queuedSyncs;c&&(this._queuedSyncs=null,this._needsSync=!0,this.sync(()=>{c.forEach(a=>a&&a())}));this.dispatchEvent(h);a&&a()})))}onBeforeRender(a,b,c,d,e,f){this.sync();e.isTroikaTextMaterial&&this._prepareForRender(e);e._hadOwnSide=e.hasOwnProperty("side");
this.geometry.setSide(e._actualSide=e.side);e.side=y.FrontSide}onAfterRender(a,b,c,d,e,f){e._hadOwnSide?e.side=e._actualSide:delete e.side}dispose(){this.geometry.dispose()}get textRenderInfo(){return this._textRenderInfo||null}get material(){let a=this._derivedMaterial;const b=this._baseMaterial||this._defaultMaterial||(this._defaultMaterial=f.clone());a&&a.baseMaterial===b||(a=this._derivedMaterial=ua(b),b.addEventListener("dispose",function v(){b.removeEventListener("dispose",v);a.dispose()}));
if(this.outlineWidth||this.outlineBlur||this.outlineOffsetX||this.outlineOffsetY){let b=a._outlineMtl;b||(b=a._outlineMtl=Object.create(a,{id:{value:a.id+.1}}),b.isTextOutlineMaterial=!0,b.depthWrite=!1,b.map=null,a.addEventListener("dispose",function u(){a.removeEventListener("dispose",u);b.dispose()}));return[b,a]}return a}set material(a){a&&a.isTroikaTextMaterial?(this._derivedMaterial=a,this._baseMaterial=a.baseMaterial):this._baseMaterial=a}get glyphGeometryDetail(){return this.geometry.detail}set glyphGeometryDetail(a){this.geometry.detail=
a}get curveRadius(){return this.geometry.curveRadius}set curveRadius(a){this.geometry.curveRadius=a}get customDepthMaterial(){return k(this.material).getDepthMaterial()}get customDistanceMaterial(){return k(this.material).getDistanceMaterial()}_prepareForRender(a){var d=a.isTextOutlineMaterial,e=a.uniforms,f=this.textRenderInfo;if(f){const {sdfTexture:a,blockBounds:b}=f;e.uTroikaSDFTexture.value=a;e.uTroikaSDFTextureSize.value.set(a.image.width,a.image.height);e.uTroikaSDFGlyphSize.value=f.sdfGlyphSize;
e.uTroikaSDFExponent.value=f.sdfExponent;e.uTroikaTotalBounds.value.fromArray(b);e.uTroikaUseGlyphColors.value=!d&&!!f.glyphColors;let c=f=0,h=0,k;let l=0,m=0;if(d){let {outlineWidth:a,outlineOffsetX:b,outlineOffsetY:d,outlineBlur:e,outlineOpacity:g}=this;f=this._parsePercent(a)||0;c=Math.max(0,this._parsePercent(e)||0);k=g;l=this._parsePercent(b)||0;m=this._parsePercent(d)||0}else{if(h=Math.max(0,this._parsePercent(this.strokeWidth)||0)){var g=this.strokeColor;e.uTroikaStrokeColor.value.set(null==
g?8421504:g);g=this.strokeOpacity;null==g&&(g=1)}k=this.fillOpacity}e.uTroikaDistanceOffset.value=f;e.uTroikaPositionOffset.value.set(l,m);e.uTroikaBlurRadius.value=c;e.uTroikaStrokeWidth.value=h;e.uTroikaStrokeOpacity.value=g;e.uTroikaFillOpacity.value=null==k?1:k;e.uTroikaCurveRadius.value=this.curveRadius||0;(f=this.clipRect)&&Array.isArray(f)&&4===f.length?e.uTroikaClipRect.value.fromArray(f):(f=100*(this.fontSize||.1),e.uTroikaClipRect.value.set(b[0]-f,b[1]-f,b[2]+f,b[3]+f));this.geometry.applyClipRect(e.uTroikaClipRect.value)}e.uTroikaSDFDebug.value=
!!this.debugSDF;a.polygonOffset=!!this.depthOffset;a.polygonOffsetFactor=a.polygonOffsetUnits=this.depthOffset||0;d=d?this.outlineColor||0:this.color;null==d?delete a.color:(f=a.hasOwnProperty("color")?a.color:a.color=new y.Color,(d!==f._input||"object"===typeof d)&&f.set(f._input=d));d=this.orientation||"+x+y";if(d!==a._orientation){e=e.uTroikaOrient.value;d=d.replace(/[^-+xyz]/g,"");if(f="+x+y"!==d&&d.match(/^([-+])([xyz])([-+])([xyz])$/)){let [,a,d,g,h]=f;m.set(0,0,0)[d]="-"===a?1:-1;b.set(0,0,
0)[h]="-"===g?-1:1;p.lookAt(c,m.cross(b),b);e.setFromMatrix4(p)}else e.identity();a._orientation=d}}_parsePercent(a){"string"===typeof a&&(a=(a=a.match(/^(-?[\d.]+)%$/))?parseFloat(a[1]):NaN,a=(isNaN(a)?0:a/100)*this.fontSize);return a}localPositionToTextCoords(a,b=new y.Vector2){b.copy(a);const c=this.curveRadius;c&&(b.x=Math.atan2(a.x,Math.abs(c)-Math.abs(a.z))*Math.abs(c));return b}worldPositionToTextCoords(a,b=new y.Vector2){m.copy(a);return this.localPositionToTextCoords(this.worldToLocal(m),
b)}raycast(b,c){const {textRenderInfo:f,curveRadius:g}=this;if(f){const h=f.blockBounds,k=g?e():d(),l=k.geometry,{position:m,uv:n}=l.attributes;for(let a=0;a<n.count;a++){let b=h[0]+n.getX(a)*(h[2]-h[0]);const c=h[1]+n.getY(a)*(h[3]-h[1]);let d=0;g&&(d=g-Math.cos(b/g)*g,b=Math.sin(b/g)*g);m.setXYZ(a,b,c,d)}l.boundingSphere=this.geometry.boundingSphere;l.boundingBox=this.geometry.boundingBox;k.matrixWorld=this.matrixWorld;k.material.side=this.material.side;a.length=0;k.raycast(b,a);for(b=0;b<a.length;b++)a[b].object=
this,c.push(a[b])}}copy(a){const b=this.geometry;super.copy(a);this.geometry=b;r.forEach(b=>{this[b]=a[b]});return this}clone(){return(new this.constructor).copy(this)}}l.forEach(a=>{const b="_private_"+a;Object.defineProperty(x.prototype,a,{get(){return this[b]},set(a){a!==this[b]&&(this[b]=a,this._needsSync=!0)}})});let K=!1;Object.defineProperty(x.prototype,"anchor",{get(){return this._deprecated_anchor},set(a){this._deprecated_anchor=a;K||(console.warn("TextMesh: `anchor` has been deprecated; use `anchorX` and `anchorY` instead."),
K=!0);Array.isArray(a)?(this.anchorX=`${100*(+a[0]||0)}%`,this.anchorY=`${100*(+a[1]||0)}%`):this.anchorX=this.anchorY=0}});return x})();let ya=new WeakMap,va=new WeakMap;x.GlyphsGeometry=xa;x.Text=V;x.configureTextBuilder=function(k){qa?console.warn("configureTextBuilder called after first font request; will be ignored."):ra(S,k)};x.createTextDerivedMaterial=ua;x.dumpSDFTextures=function(){Object.keys(aa).forEach(k=>{k=aa[k].sdfCanvas;let {width:f,height:p}=k;console.log("%c.",`
      background: url(${k.toDataURL()});
      background-size: ${f}px ${p}px;
      color: transparent;
      font-size: 0;
      line-height: ${p}px;
      padding-left: ${f}px;
    `)})};x.getCaretAtPoint=function(k,f,p){let m=null,{caretHeight:b}=k;k=Ga(k);let a=Infinity;k.forEach((c,d)=>{Math.abs(p-(d+b/2))<Math.abs(p-(a+b/2))&&(a=d)});k.get(a).forEach(a=>{if(!m||Math.abs(f-a.x)<Math.abs(f-m.x))m=a});return m};x.getSelectionRects=function(k,f,p){var m;if(k){if((m=ya.get(k))&&m.start===f&&m.end===p)return m.rects;let {caretPositions:g,caretHeight:h}=k;p<f&&(m=f,f=p,p=m);f=Math.max(f,0);p=Math.min(p,g.length+1);m=[];var b=null;for(var a=f;a<p;a++){var c=g[3*a],d=g[3*a+1],
e=Math.min(c,d);c=Math.max(c,d);d=g[3*a+2];if(!b||d!==b.bottom||e>b.right||c<b.left)b={left:Infinity,right:-Infinity,bottom:d,top:d+h},m.push(b);b.left=Math.min(e,b.left);b.right=Math.max(c,b.right)}m.sort((a,b)=>b.bottom-a.bottom||a.left-b.left);for(b=m.length-1;0<b--;)a=m[b],e=m[b+1],a.bottom===e.bottom&&a.left<=e.right&&a.right>=e.left&&(e.left=Math.min(e.left,a.left),e.right=Math.max(e.right,a.right),m.splice(b,1));ya.set(k,{start:f,end:p,rects:m})}return m};x.preloadFont=function({font:k,characters:f,
sdfGlyphSize:p},m){f=Array.isArray(f)?f.join("\n"):""+f;pa({font:k,sdfGlyphSize:p,text:f},m)};x.typesetterWorkerModule=W;Object.defineProperty(x,"__esModule",{value:!0})})
