"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t,e=require("three"),n=((t=new e.RawShaderMaterial({uniforms:{roughnessMap:{value:null},normalMap:{value:null},texelSize:{value:new e.Vector2(1,1)}},vertexShader:"\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tattribute vec3 position;\n\t\t\tattribute vec2 uv;\n\n\t\t\tvarying vec2 vUv;\n\n\t\t\tvoid main() {\n\n\t\t\t\tvUv = uv;\n\n\t\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t\t}\n\t\t",fragmentShader:"\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec2 vUv;\n\n\t\t\tuniform sampler2D roughnessMap;\n\t\t\tuniform sampler2D normalMap;\n\t\t\tuniform vec2 texelSize;\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\n\t\t\tvec4 envMapTexelToLinear( vec4 a ) { return a; }\n\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tfloat roughnessToVariance( float roughness ) {\n\n\t\t\t\tfloat variance = 0.0;\n\n\t\t\t\tif ( roughness >= r1 ) {\n\n\t\t\t\t\tvariance = ( r0 - roughness ) * ( v1 - v0 ) / ( r0 - r1 ) + v0;\n\n\t\t\t\t} else if ( roughness >= r4 ) {\n\n\t\t\t\t\tvariance = ( r1 - roughness ) * ( v4 - v1 ) / ( r1 - r4 ) + v1;\n\n\t\t\t\t} else if ( roughness >= r5 ) {\n\n\t\t\t\t\tvariance = ( r4 - roughness ) * ( v5 - v4 ) / ( r4 - r5 ) + v4;\n\n\t\t\t\t} else {\n\n\t\t\t\t\tfloat roughness2 = roughness * roughness;\n\n\t\t\t\t\tvariance = 1.79 * roughness2 * roughness2;\n\n\t\t\t\t}\n\n\t\t\t\treturn variance;\n\n\t\t\t}\n\n\t\t\tfloat varianceToRoughness( float variance ) {\n\n\t\t\t\tfloat roughness = 0.0;\n\n\t\t\t\tif ( variance >= v1 ) {\n\n\t\t\t\t\troughness = ( v0 - variance ) * ( r1 - r0 ) / ( v0 - v1 ) + r0;\n\n\t\t\t\t} else if ( variance >= v4 ) {\n\n\t\t\t\t\troughness = ( v1 - variance ) * ( r4 - r1 ) / ( v1 - v4 ) + r1;\n\n\t\t\t\t} else if ( variance >= v5 ) {\n\n\t\t\t\t\troughness = ( v4 - variance ) * ( r5 - r4 ) / ( v4 - v5 ) + r4;\n\n\t\t\t\t} else {\n\n\t\t\t\t\troughness = pow( 0.559 * variance, 0.25 ); // 0.559 = 1.0 / 1.79\n\n\t\t\t\t}\n\n\t\t\t\treturn roughness;\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = texture2D( roughnessMap, vUv, - 1.0 );\n\n\t\t\t\tif ( texelSize.x == 0.0 ) return;\n\n\t\t\t\tfloat roughness = gl_FragColor.g;\n\n\t\t\t\tfloat variance = roughnessToVariance( roughness );\n\n\t\t\t\tvec3 avgNormal;\n\n\t\t\t\tfor ( float x = - 1.0; x < 2.0; x += 2.0 ) {\n\n\t\t\t\t\tfor ( float y = - 1.0; y < 2.0; y += 2.0 ) {\n\n\t\t\t\t\t\tvec2 uv = vUv + vec2( x, y ) * 0.25 * texelSize;\n\n\t\t\t\t\t\tavgNormal += normalize( texture2D( normalMap, uv, - 1.0 ).xyz - 0.5 );\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t\tvariance += 1.0 - 0.25 * length( avgNormal );\n\n\t\t\t\tgl_FragColor.g = varianceToRoughness( variance );\n\n\t\t\t}\n\t\t",blending:e.NoBlending,depthTest:!1,depthWrite:!1})).type="RoughnessMipmapper",t),r=new e.Mesh(new e.PlaneGeometry(2,2),n),a=new e.OrthographicCamera(0,1,0,1,0,1),s=null,o=null;function i(t){(o=t).compile(r,a)}i.prototype={constructor:i,generateMipmaps:function(t){if("roughnessMap"in t!=!1){var{roughnessMap:i,normalMap:u}=t;if(null!==i&&null!==u&&i.generateMipmaps&&!t.userData.roughnessUpdated){t.userData.roughnessUpdated=!0;var l=Math.max(i.image.width,u.image.width),v=Math.max(i.image.height,u.image.height);if(e.MathUtils.isPowerOfTwo(l)&&e.MathUtils.isPowerOfTwo(v)){var g=o.getRenderTarget(),p=o.autoClear;if(o.autoClear=!1,null!==s&&s.width===l&&s.height===v||(null!==s&&s.dispose(),(s=new e.WebGLRenderTarget(l,v,{depthBuffer:!1})).scissorTest=!0),l!==i.image.width||v!==i.image.height){var h={wrapS:i.wrapS,wrapT:i.wrapT,magFilter:i.magFilter,minFilter:i.minFilter,depthBuffer:!1},m=new e.WebGLRenderTarget(l,v,h);m.texture.generateMipmaps=!0,o.setRenderTarget(m),t.roughnessMap=m.texture,t.metalnessMap==i&&(t.metalnessMap=t.roughnessMap),t.aoMap==i&&(t.aoMap=t.roughnessMap)}n.uniforms.roughnessMap.value=i,n.uniforms.normalMap.value=u;var c=new e.Vector2(0,0),f=n.uniforms.texelSize.value;for(let e=0;l>=1&&v>=1;++e,l/=2,v/=2)f.set(1/l,1/v),0==e&&f.set(0,0),s.viewport.set(c.x,c.y,l,v),s.scissor.set(c.x,c.y,l,v),o.setRenderTarget(s),o.render(r,a),o.copyFramebufferToTexture(c,t.roughnessMap,e),n.uniforms.roughnessMap.value=t.roughnessMap;i!==t.roughnessMap&&i.dispose(),o.setRenderTarget(g),o.autoClear=p}}}},dispose:function(){n.dispose(),r.geometry.dispose(),null!=s&&s.dispose()}},exports.RoughnessMipmapper=i;
