"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three"),e=require("./Pass.cjs.js");require("@babel/runtime/helpers/defineProperty");class n extends e.Pass{constructor(n,i,a,o,l={}){var s,d;super(),this.pixelSize=i,this.resolution=new t.Vector2,this.renderResolution=new t.Vector2,this.setSize(n.x,n.y),this.fsQuad=new e.FullScreenQuad(this.material()),this.scene=a,this.camera=o,this.normalEdgeStrength=null!=(s=l.normalEdgeStrength)?s:.3,this.depthEdgeStrength=null!=(d=l.depthEdgeStrength)?d:.4,this.rgbRenderTarget=r(this.renderResolution,t.RGBAFormat,!0),this.normalRenderTarget=r(this.renderResolution,t.RGBAFormat,!1),this.normalMaterial=new t.MeshNormalMaterial}dispose(){this.rgbRenderTarget.dispose(),this.normalRenderTarget.dispose(),this.fsQuad.dispose()}setSize(t,e){var n,r,i;this.resolution.set(t,e),this.renderResolution.set(t/this.pixelSize|0,e/this.pixelSize|0);const{x:a,y:o}=this.renderResolution;null===(n=this.rgbRenderTarget)||void 0===n||n.setSize(a,o),null===(r=this.normalRenderTarget)||void 0===r||r.setSize(a,o),null===(i=this.fsQuad)||void 0===i||i.material.uniforms.resolution.value.set(a,o,1/a,1/o)}setPixelSize(t){this.pixelSize=t,this.setSize(this.resolution.x,this.resolution.y)}render(t,e){const n=this.fsQuad.material.uniforms;n.normalEdgeStrength.value=this.normalEdgeStrength,n.depthEdgeStrength.value=this.depthEdgeStrength,t.setRenderTarget(this.rgbRenderTarget),t.render(this.scene,this.camera);const r=this.scene.overrideMaterial;t.setRenderTarget(this.normalRenderTarget),this.scene.overrideMaterial=this.normalMaterial,t.render(this.scene,this.camera),this.scene.overrideMaterial=r,n.tDiffuse.value=this.rgbRenderTarget.texture,n.tDepth.value=this.rgbRenderTarget.depthTexture,n.tNormal.value=this.normalRenderTarget.texture,this.renderToScreen?t.setRenderTarget(null):(t.setRenderTarget(e),this.clear&&t.clear()),this.fsQuad.render(t)}material(){return new t.ShaderMaterial({uniforms:{tDiffuse:{value:null},tDepth:{value:null},tNormal:{value:null},resolution:{value:new t.Vector4(this.renderResolution.x,this.renderResolution.y,1/this.renderResolution.x,1/this.renderResolution.y)},normalEdgeStrength:{value:0},depthEdgeStrength:{value:0}},vertexShader:"\n\t\t\t\tvarying vec2 vUv;\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvUv = uv;\n\t\t\t\t\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\n\t\t\t\t}\n\t\t\t\t",fragmentShader:"\n\t\t\t\tuniform sampler2D tDiffuse;\n\t\t\t\tuniform sampler2D tDepth;\n\t\t\t\tuniform sampler2D tNormal;\n\t\t\t\tuniform vec4 resolution;\n\t\t\t\tuniform float normalEdgeStrength;\n\t\t\t\tuniform float depthEdgeStrength;\n\t\t\t\tvarying vec2 vUv;\n\n\t\t\t\tfloat getDepth(int x, int y) {\n\n\t\t\t\t\treturn texture2D( tDepth, vUv + vec2(x, y) * resolution.zw ).r;\n\n\t\t\t\t}\n\n\t\t\t\tvec3 getNormal(int x, int y) {\n\n\t\t\t\t\treturn texture2D( tNormal, vUv + vec2(x, y) * resolution.zw ).rgb * 2.0 - 1.0;\n\n\t\t\t\t}\n\n\t\t\t\tfloat depthEdgeIndicator(float depth, vec3 normal) {\n\n\t\t\t\t\tfloat diff = 0.0;\n\t\t\t\t\tdiff += clamp(getDepth(1, 0) - depth, 0.0, 1.0);\n\t\t\t\t\tdiff += clamp(getDepth(-1, 0) - depth, 0.0, 1.0);\n\t\t\t\t\tdiff += clamp(getDepth(0, 1) - depth, 0.0, 1.0);\n\t\t\t\t\tdiff += clamp(getDepth(0, -1) - depth, 0.0, 1.0);\n\t\t\t\t\treturn floor(smoothstep(0.01, 0.02, diff) * 2.) / 2.;\n\n\t\t\t\t}\n\n\t\t\t\tfloat neighborNormalEdgeIndicator(int x, int y, float depth, vec3 normal) {\n\n\t\t\t\t\tfloat depthDiff = getDepth(x, y) - depth;\n\t\t\t\t\tvec3 neighborNormal = getNormal(x, y);\n\t\t\t\t\t\n\t\t\t\t\t// Edge pixels should yield to faces who's normals are closer to the bias normal.\n\t\t\t\t\tvec3 normalEdgeBias = vec3(1., 1., 1.); // This should probably be a parameter.\n\t\t\t\t\tfloat normalDiff = dot(normal - neighborNormal, normalEdgeBias);\n\t\t\t\t\tfloat normalIndicator = clamp(smoothstep(-.01, .01, normalDiff), 0.0, 1.0);\n\t\t\t\t\t\n\t\t\t\t\t// Only the shallower pixel should detect the normal edge.\n\t\t\t\t\tfloat depthIndicator = clamp(sign(depthDiff * .25 + .0025), 0.0, 1.0);\n\n\t\t\t\t\treturn (1.0 - dot(normal, neighborNormal)) * depthIndicator * normalIndicator;\n\n\t\t\t\t}\n\n\t\t\t\tfloat normalEdgeIndicator(float depth, vec3 normal) {\n\t\t\t\t\t\n\t\t\t\t\tfloat indicator = 0.0;\n\n\t\t\t\t\tindicator += neighborNormalEdgeIndicator(0, -1, depth, normal);\n\t\t\t\t\tindicator += neighborNormalEdgeIndicator(0, 1, depth, normal);\n\t\t\t\t\tindicator += neighborNormalEdgeIndicator(-1, 0, depth, normal);\n\t\t\t\t\tindicator += neighborNormalEdgeIndicator(1, 0, depth, normal);\n\n\t\t\t\t\treturn step(0.1, indicator);\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec4 texel = texture2D( tDiffuse, vUv );\n\n\t\t\t\t\tfloat depth = 0.0;\n\t\t\t\t\tvec3 normal = vec3(0.0);\n\n\t\t\t\t\tif (depthEdgeStrength > 0.0 || normalEdgeStrength > 0.0) {\n\n\t\t\t\t\t\tdepth = getDepth(0, 0);\n\t\t\t\t\t\tnormal = getNormal(0, 0);\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat dei = 0.0;\n\t\t\t\t\tif (depthEdgeStrength > 0.0) \n\t\t\t\t\t\tdei = depthEdgeIndicator(depth, normal);\n\n\t\t\t\t\tfloat nei = 0.0; \n\t\t\t\t\tif (normalEdgeStrength > 0.0) \n\t\t\t\t\t\tnei = normalEdgeIndicator(depth, normal);\n\n\t\t\t\t\tfloat Strength = dei > 0.0 ? (1.0 - depthEdgeStrength * dei) : (1.0 + normalEdgeStrength * nei);\n\n\t\t\t\t\tgl_FragColor = texel * Strength;\n\n\t\t\t\t}\n\t\t\t\t"})}}function r(e,n,r){const i=new t.WebGLRenderTarget(e.x,e.y,r?{depthTexture:new t.DepthTexture(e.x,e.y),depthBuffer:!0}:void 0);return i.texture.format=n,i.texture.minFilter=t.NearestFilter,i.texture.magFilter=t.NearestFilter,i.texture.generateMipmaps=!1,i.stencilBuffer=!1,i}exports.RenderPixelatedPass=n;
