"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three"),e=require("./Reflector.cjs.js"),r=require("./Refractor.cjs.js");class o extends t.Mesh{constructor(o,n={}){super(o),this.type="Water";const a=this,l=void 0!==n.color?new t.Color(n.color):new t.Color(16777215),i=n.textureWidth||512,f=n.textureHeight||512,c=n.clipBias||0,u=n.flowDirection||new t.Vector2(1,0),v=n.flowSpeed||.03,m=n.reflectivity||.02,s=n.scale||1,p=n.shader||Water.WaterShader,d=void 0!==n.encoding?n.encoding:t.LinearEncoding,x=new t.TextureLoader,g=n.flowMap||void 0,h=n.normalMap0||x.load("textures/water/Water_1_M_Normal.jpg"),w=n.normalMap1||x.load("textures/water/Water_2_M_Normal.jpg"),y=.15,M=.075,_=new t.Matrix4,R=new t.Clock;if(void 0===e.Reflector)return void console.error("THREE.Water: Required component Reflector not found.");if(void 0===r.Refractor)return void console.error("THREE.Water: Required component Refractor not found.");const C=new e.Reflector(o,{textureWidth:i,textureHeight:f,clipBias:c,encoding:d}),W=new r.Refractor(o,{textureWidth:i,textureHeight:f,clipBias:c,encoding:d});C.matrixAutoUpdate=!1,W.matrixAutoUpdate=!1,this.material=new t.ShaderMaterial({uniforms:t.UniformsUtils.merge([t.UniformsLib.fog,p.uniforms]),vertexShader:p.vertexShader,fragmentShader:p.fragmentShader,transparent:!0,fog:!0}),void 0!==g?(this.material.defines.USE_FLOWMAP="",this.material.uniforms.tFlowMap={type:"t",value:g}):this.material.uniforms.flowDirection={type:"v2",value:u},h.wrapS=h.wrapT=t.RepeatWrapping,w.wrapS=w.wrapT=t.RepeatWrapping,this.material.uniforms.tReflectionMap.value=C.getRenderTarget().texture,this.material.uniforms.tRefractionMap.value=W.getRenderTarget().texture,this.material.uniforms.tNormalMap0.value=h,this.material.uniforms.tNormalMap1.value=w,this.material.uniforms.color.value=l,this.material.uniforms.reflectivity.value=m,this.material.uniforms.textureMatrix.value=_,this.material.uniforms.config.value.x=0,this.material.uniforms.config.value.y=M,this.material.uniforms.config.value.z=M,this.material.uniforms.config.value.w=s,this.onBeforeRender=function(t,e,r){!function(t){_.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),_.multiply(t.projectionMatrix),_.multiply(t.matrixWorldInverse),_.multiply(a.matrixWorld)}(r),function(){const t=R.getDelta(),e=a.material.uniforms.config;e.value.x+=v*t,e.value.y=e.value.x+M,e.value.x>=y?(e.value.x=0,e.value.y=M):e.value.y>=y&&(e.value.y=e.value.y-y)}(),a.visible=!1,C.matrixWorld.copy(a.matrixWorld),W.matrixWorld.copy(a.matrixWorld),C.onBeforeRender(t,e,r),W.onBeforeRender(t,e,r),a.visible=!0}}}o.prototype.isWater=!0,o.WaterShader={uniforms:{color:{type:"c",value:null},reflectivity:{type:"f",value:0},tReflectionMap:{type:"t",value:null},tRefractionMap:{type:"t",value:null},tNormalMap0:{type:"t",value:null},tNormalMap1:{type:"t",value:null},textureMatrix:{type:"m4",value:null},config:{type:"v4",value:new t.Vector4}},vertexShader:"\n\n\t\t#include <common>\n\t\t#include <fog_pars_vertex>\n\t\t#include <logdepthbuf_pars_vertex>\n\n\t\tuniform mat4 textureMatrix;\n\n\t\tvarying vec4 vCoord;\n\t\tvarying vec2 vUv;\n\t\tvarying vec3 vToEye;\n\n\t\tvoid main() {\n\n\t\t\tvUv = uv;\n\t\t\tvCoord = textureMatrix * vec4( position, 1.0 );\n\n\t\t\tvec4 worldPosition = modelMatrix * vec4( position, 1.0 );\n\t\t\tvToEye = cameraPosition - worldPosition.xyz;\n\n\t\t\tvec4 mvPosition =  viewMatrix * worldPosition; // used in fog_vertex\n\t\t\tgl_Position = projectionMatrix * mvPosition;\n\n\t\t\t#include <logdepthbuf_vertex>\n\t\t\t#include <fog_vertex>\n\n\t\t}",fragmentShader:"\n\n\t\t#include <common>\n\t\t#include <fog_pars_fragment>\n\t\t#include <logdepthbuf_pars_fragment>\n\n\t\tuniform sampler2D tReflectionMap;\n\t\tuniform sampler2D tRefractionMap;\n\t\tuniform sampler2D tNormalMap0;\n\t\tuniform sampler2D tNormalMap1;\n\n\t\t#ifdef USE_FLOWMAP\n\t\t\tuniform sampler2D tFlowMap;\n\t\t#else\n\t\t\tuniform vec2 flowDirection;\n\t\t#endif\n\n\t\tuniform vec3 color;\n\t\tuniform float reflectivity;\n\t\tuniform vec4 config;\n\n\t\tvarying vec4 vCoord;\n\t\tvarying vec2 vUv;\n\t\tvarying vec3 vToEye;\n\n\t\tvoid main() {\n\n\t\t\t#include <logdepthbuf_fragment>\n\n\t\t\tfloat flowMapOffset0 = config.x;\n\t\t\tfloat flowMapOffset1 = config.y;\n\t\t\tfloat halfCycle = config.z;\n\t\t\tfloat scale = config.w;\n\n\t\t\tvec3 toEye = normalize( vToEye );\n\n\t\t\t// determine flow direction\n\t\t\tvec2 flow;\n\t\t\t#ifdef USE_FLOWMAP\n\t\t\t\tflow = texture2D( tFlowMap, vUv ).rg * 2.0 - 1.0;\n\t\t\t#else\n\t\t\t\tflow = flowDirection;\n\t\t\t#endif\n\t\t\tflow.x *= - 1.0;\n\n\t\t\t// sample normal maps (distort uvs with flowdata)\n\t\t\tvec4 normalColor0 = texture2D( tNormalMap0, ( vUv * scale ) + flow * flowMapOffset0 );\n\t\t\tvec4 normalColor1 = texture2D( tNormalMap1, ( vUv * scale ) + flow * flowMapOffset1 );\n\n\t\t\t// linear interpolate to get the final normal color\n\t\t\tfloat flowLerp = abs( halfCycle - flowMapOffset0 ) / halfCycle;\n\t\t\tvec4 normalColor = mix( normalColor0, normalColor1, flowLerp );\n\n\t\t\t// calculate normal vector\n\t\t\tvec3 normal = normalize( vec3( normalColor.r * 2.0 - 1.0, normalColor.b,  normalColor.g * 2.0 - 1.0 ) );\n\n\t\t\t// calculate the fresnel term to blend reflection and refraction maps\n\t\t\tfloat theta = max( dot( toEye, normal ), 0.0 );\n\t\t\tfloat reflectance = reflectivity + ( 1.0 - reflectivity ) * pow( ( 1.0 - theta ), 5.0 );\n\n\t\t\t// calculate final uv coords\n\t\t\tvec3 coord = vCoord.xyz / vCoord.w;\n\t\t\tvec2 uv = coord.xy + coord.z * normal.xz * 0.05;\n\n\t\t\tvec4 reflectColor = texture2D( tReflectionMap, vec2( 1.0 - uv.x, uv.y ) );\n\t\t\tvec4 refractColor = texture2D( tRefractionMap, uv );\n\n\t\t\t// multiply water color with the mix of both textures\n\t\t\tgl_FragColor = vec4( color, 1.0 ) * mix( refractColor, reflectColor, reflectance );\n\n\t\t\t#include <tonemapping_fragment>\n\t\t\t#include <encodings_fragment>\n\t\t\t#include <fog_fragment>\n\n\t\t}"},exports.Water2=o;
