"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three");class e extends t.Mesh{constructor(e,r={}){super(e);const o=this,n=void 0!==r.textureWidth?r.textureWidth:512,i=void 0!==r.textureHeight?r.textureHeight:512,a=void 0!==r.clipBias?r.clipBias:0,l=void 0!==r.alpha?r.alpha:1,s=void 0!==r.time?r.time:0,u=void 0!==r.waterNormals?r.waterNormals:null,c=void 0!==r.sunDirection?r.sunDirection:new t.Vector3(.70707,.70707,0),m=new t.Color(void 0!==r.sunColor?r.sunColor:16777215),d=new t.Color(void 0!==r.waterColor?r.waterColor:8355711),v=void 0!==r.eye?r.eye:new t.Vector3(0,0,0),f=void 0!==r.distortionScale?r.distortionScale:20,p=void 0!==r.side?r.side:t.FrontSide,x=void 0!==r.fog&&r.fog,g=new t.Plane,w=new t.Vector3,h=new t.Vector3,y=new t.Vector3,C=new t.Matrix4,M=new t.Vector3(0,0,-1),S=new t.Vector4,_=new t.Vector3,b=new t.Vector3,D=new t.Vector4,P=new t.Matrix4,V=new t.PerspectiveCamera,z=new t.WebGLRenderTarget(n,i),L={uniforms:t.UniformsUtils.merge([t.UniformsLib.fog,t.UniformsLib.lights,{normalSampler:{value:null},mirrorSampler:{value:null},alpha:{value:1},time:{value:0},size:{value:1},distortionScale:{value:20},textureMatrix:{value:new t.Matrix4},sunColor:{value:new t.Color(8355711)},sunDirection:{value:new t.Vector3(.70707,.70707,0)},eye:{value:new t.Vector3},waterColor:{value:new t.Color(5592405)}}]),vertexShader:"\n\t\t\t\tuniform mat4 textureMatrix;\n\t\t\t\tuniform float time;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <fog_pars_vertex>\n\t\t\t\t#include <shadowmap_pars_vertex>\n\t\t\t\t#include <logdepthbuf_pars_vertex>\n\n\t\t\t\tvoid main() {\n\t\t\t\t\tmirrorCoord = modelMatrix * vec4( position, 1.0 );\n\t\t\t\t\tworldPosition = mirrorCoord.xyzw;\n\t\t\t\t\tmirrorCoord = textureMatrix * mirrorCoord;\n\t\t\t\t\tvec4 mvPosition =  modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t\tgl_Position = projectionMatrix * mvPosition;\n\n\t\t\t\t#include <beginnormal_vertex>\n\t\t\t\t#include <defaultnormal_vertex>\n\t\t\t\t#include <logdepthbuf_vertex>\n\t\t\t\t#include <fog_vertex>\n\t\t\t\t#include <shadowmap_vertex>\n\t\t\t}",fragmentShader:"\n\t\t\t\tuniform sampler2D mirrorSampler;\n\t\t\t\tuniform float alpha;\n\t\t\t\tuniform float time;\n\t\t\t\tuniform float size;\n\t\t\t\tuniform float distortionScale;\n\t\t\t\tuniform sampler2D normalSampler;\n\t\t\t\tuniform vec3 sunColor;\n\t\t\t\tuniform vec3 sunDirection;\n\t\t\t\tuniform vec3 eye;\n\t\t\t\tuniform vec3 waterColor;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\tvec4 getNoise( vec2 uv ) {\n\t\t\t\t\tvec2 uv0 = ( uv / 103.0 ) + vec2(time / 17.0, time / 29.0);\n\t\t\t\t\tvec2 uv1 = uv / 107.0-vec2( time / -19.0, time / 31.0 );\n\t\t\t\t\tvec2 uv2 = uv / vec2( 8907.0, 9803.0 ) + vec2( time / 101.0, time / 97.0 );\n\t\t\t\t\tvec2 uv3 = uv / vec2( 1091.0, 1027.0 ) - vec2( time / 109.0, time / -113.0 );\n\t\t\t\t\tvec4 noise = texture2D( normalSampler, uv0 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv1 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv2 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv3 );\n\t\t\t\t\treturn noise * 0.5 - 1.0;\n\t\t\t\t}\n\n\t\t\t\tvoid sunLight( const vec3 surfaceNormal, const vec3 eyeDirection, float shiny, float spec, float diffuse, inout vec3 diffuseColor, inout vec3 specularColor ) {\n\t\t\t\t\tvec3 reflection = normalize( reflect( -sunDirection, surfaceNormal ) );\n\t\t\t\t\tfloat direction = max( 0.0, dot( eyeDirection, reflection ) );\n\t\t\t\t\tspecularColor += pow( direction, shiny ) * sunColor * spec;\n\t\t\t\t\tdiffuseColor += max( dot( sunDirection, surfaceNormal ), 0.0 ) * sunColor * diffuse;\n\t\t\t\t}\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <packing>\n\t\t\t\t#include <bsdfs>\n\t\t\t\t#include <fog_pars_fragment>\n\t\t\t\t#include <logdepthbuf_pars_fragment>\n\t\t\t\t#include <lights_pars_begin>\n\t\t\t\t#include <shadowmap_pars_fragment>\n\t\t\t\t#include <shadowmask_pars_fragment>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\t#include <logdepthbuf_fragment>\n\t\t\t\t\tvec4 noise = getNoise( worldPosition.xz * size );\n\t\t\t\t\tvec3 surfaceNormal = normalize( noise.xzy * vec3( 1.5, 1.0, 1.5 ) );\n\n\t\t\t\t\tvec3 diffuseLight = vec3(0.0);\n\t\t\t\t\tvec3 specularLight = vec3(0.0);\n\n\t\t\t\t\tvec3 worldToEye = eye-worldPosition.xyz;\n\t\t\t\t\tvec3 eyeDirection = normalize( worldToEye );\n\t\t\t\t\tsunLight( surfaceNormal, eyeDirection, 100.0, 2.0, 0.5, diffuseLight, specularLight );\n\n\t\t\t\t\tfloat distance = length(worldToEye);\n\n\t\t\t\t\tvec2 distortion = surfaceNormal.xz * ( 0.001 + 1.0 / distance ) * distortionScale;\n\t\t\t\t\tvec3 reflectionSample = vec3( texture2D( mirrorSampler, mirrorCoord.xy / mirrorCoord.w + distortion ) );\n\n\t\t\t\t\tfloat theta = max( dot( eyeDirection, surfaceNormal ), 0.0 );\n\t\t\t\t\tfloat rf0 = 0.3;\n\t\t\t\t\tfloat reflectance = rf0 + ( 1.0 - rf0 ) * pow( ( 1.0 - theta ), 5.0 );\n\t\t\t\t\tvec3 scatter = max( 0.0, dot( surfaceNormal, eyeDirection ) ) * waterColor;\n\t\t\t\t\tvec3 albedo = mix( ( sunColor * diffuseLight * 0.3 + scatter ) * getShadowMask(), ( vec3( 0.1 ) + reflectionSample * 0.9 + reflectionSample * specularLight ), reflectance);\n\t\t\t\t\tvec3 outgoingLight = albedo;\n\t\t\t\t\tgl_FragColor = vec4( outgoingLight, alpha );\n\n\t\t\t\t\t#include <tonemapping_fragment>\n\t\t\t\t\t#include <fog_fragment>\n\t\t\t\t}"},N=new t.ShaderMaterial({fragmentShader:L.fragmentShader,vertexShader:L.vertexShader,uniforms:t.UniformsUtils.clone(L.uniforms),lights:!0,side:p,fog:x});N.uniforms.mirrorSampler.value=z.texture,N.uniforms.textureMatrix.value=P,N.uniforms.alpha.value=l,N.uniforms.time.value=s,N.uniforms.normalSampler.value=u,N.uniforms.sunColor.value=m,N.uniforms.waterColor.value=d,N.uniforms.sunDirection.value=c,N.uniforms.distortionScale.value=f,N.uniforms.eye.value=v,o.material=N,o.onBeforeRender=function(t,e,r){if(h.setFromMatrixPosition(o.matrixWorld),y.setFromMatrixPosition(r.matrixWorld),C.extractRotation(o.matrixWorld),w.set(0,0,1),w.applyMatrix4(C),_.subVectors(h,y),_.dot(w)>0)return;_.reflect(w).negate(),_.add(h),C.extractRotation(r.matrixWorld),M.set(0,0,-1),M.applyMatrix4(C),M.add(y),b.subVectors(h,M),b.reflect(w).negate(),b.add(h),V.position.copy(_),V.up.set(0,1,0),V.up.applyMatrix4(C),V.up.reflect(w),V.lookAt(b),V.far=r.far,V.updateMatrixWorld(),V.projectionMatrix.copy(r.projectionMatrix),P.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),P.multiply(V.projectionMatrix),P.multiply(V.matrixWorldInverse),g.setFromNormalAndCoplanarPoint(w,h),g.applyMatrix4(V.matrixWorldInverse),S.set(g.normal.x,g.normal.y,g.normal.z,g.constant);const n=V.projectionMatrix;D.x=(Math.sign(S.x)+n.elements[8])/n.elements[0],D.y=(Math.sign(S.y)+n.elements[9])/n.elements[5],D.z=-1,D.w=(1+n.elements[10])/n.elements[14],S.multiplyScalar(2/S.dot(D)),n.elements[2]=S.x,n.elements[6]=S.y,n.elements[10]=S.z+1-a,n.elements[14]=S.w,v.setFromMatrixPosition(r.matrixWorld);const i=t.getRenderTarget(),l=t.xr.enabled,s=t.shadowMap.autoUpdate;o.visible=!1,t.xr.enabled=!1,t.shadowMap.autoUpdate=!1,t.setRenderTarget(z),t.state.buffers.depth.setMask(!0),!1===t.autoClear&&t.clear(),t.render(e,V),o.visible=!0,t.xr.enabled=l,t.shadowMap.autoUpdate=s,t.setRenderTarget(i);const u=r.viewport;void 0!==u&&t.state.viewport(u)}}}e.prototype.isWater=!0,exports.Water=e;
