"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three");class e extends t.Mesh{constructor(r,a={}){super(r),this.type="ReflectorForSSRPass";const n=this,i=void 0!==a.color?new t.Color(a.color):new t.Color(8355711),o=a.textureWidth||512,l=a.textureHeight||512,s=a.clipBias||0,u=a.shader||e.ReflectorShader,c=!0===a.useDepthTexture,d=new t.Vector3(0,1,0),v=new t.Vector3,f=new t.Vector3;n.needsUpdate=!1,n.maxDistance=e.ReflectorShader.uniforms.maxDistance.value,n.opacity=e.ReflectorShader.uniforms.opacity.value,n.color=i,n.resolution=a.resolution||new t.Vector2(window.innerWidth,window.innerHeight),n._distanceAttenuation=e.ReflectorShader.defines.DISTANCE_ATTENUATION,Object.defineProperty(n,"distanceAttenuation",{get:()=>n._distanceAttenuation,set(t){n._distanceAttenuation!==t&&(n._distanceAttenuation=t,n.material.defines.DISTANCE_ATTENUATION=t,n.material.needsUpdate=!0)}}),n._fresnel=e.ReflectorShader.defines.FRESNEL,Object.defineProperty(n,"fresnel",{get:()=>n._fresnel,set(t){n._fresnel!==t&&(n._fresnel=t,n.material.defines.FRESNEL=t,n.material.needsUpdate=!0)}});const p=new t.Vector3,m=new t.Vector3,x=new t.Vector3,h=new t.Matrix4,w=new t.Vector3(0,0,-1),g=new t.Vector3,M=new t.Vector3,b=new t.Matrix4,y=new t.PerspectiveCamera;let C;c&&(C=new t.DepthTexture,C.type=t.UnsignedShortType,C.minFilter=t.NearestFilter,C.magFilter=t.NearestFilter);const P={depthTexture:c?C:null},D=new t.WebGLRenderTarget(o,l,P),S=new t.ShaderMaterial({transparent:c,defines:Object.assign({},e.ReflectorShader.defines,{useDepthTexture:c}),uniforms:t.UniformsUtils.clone(u.uniforms),fragmentShader:u.fragmentShader,vertexShader:u.vertexShader});S.uniforms.tDiffuse.value=D.texture,S.uniforms.color.value=n.color,S.uniforms.textureMatrix.value=b,c&&(S.uniforms.tDepth.value=D.depthTexture),this.material=S;const T=[new t.Plane(new t.Vector3(0,1,0),s)];this.doRender=function(t,e,r){if(S.uniforms.maxDistance.value=n.maxDistance,S.uniforms.color.value=n.color,S.uniforms.opacity.value=n.opacity,v.copy(r.position).normalize(),f.copy(v).reflect(d),S.uniforms.fresnelCoe.value=(v.dot(f)+1)/2,m.setFromMatrixPosition(n.matrixWorld),x.setFromMatrixPosition(r.matrixWorld),h.extractRotation(n.matrixWorld),p.set(0,0,1),p.applyMatrix4(h),g.subVectors(m,x),g.dot(p)>0)return;g.reflect(p).negate(),g.add(m),h.extractRotation(r.matrixWorld),w.set(0,0,-1),w.applyMatrix4(h),w.add(x),M.subVectors(m,w),M.reflect(p).negate(),M.add(m),y.position.copy(g),y.up.set(0,1,0),y.up.applyMatrix4(h),y.up.reflect(p),y.lookAt(M),y.far=r.far,y.updateMatrixWorld(),y.projectionMatrix.copy(r.projectionMatrix),S.uniforms.virtualCameraNear.value=r.near,S.uniforms.virtualCameraFar.value=r.far,S.uniforms.virtualCameraMatrixWorld.value=y.matrixWorld,S.uniforms.virtualCameraProjectionMatrix.value=r.projectionMatrix,S.uniforms.virtualCameraProjectionMatrixInverse.value=r.projectionMatrixInverse,S.uniforms.resolution.value=n.resolution,b.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),b.multiply(y.projectionMatrix),b.multiply(y.matrixWorldInverse),b.multiply(n.matrixWorld),D.texture.encoding=t.outputEncoding;const a=t.getRenderTarget(),i=t.xr.enabled,o=t.shadowMap.autoUpdate,l=t.clippingPlanes;t.xr.enabled=!1,t.shadowMap.autoUpdate=!1,t.clippingPlanes=T,t.setRenderTarget(D),t.state.buffers.depth.setMask(!0),!1===t.autoClear&&t.clear(),t.render(e,y),t.xr.enabled=i,t.shadowMap.autoUpdate=o,t.clippingPlanes=l,t.setRenderTarget(a);const s=r.viewport;void 0!==s&&t.state.viewport(s)},this.getRenderTarget=function(){return D}}}e.prototype.isReflectorForSSRPass=!0,e.ReflectorShader={defines:{DISTANCE_ATTENUATION:!0,FRESNEL:!0},uniforms:{color:{value:null},tDiffuse:{value:null},tDepth:{value:null},textureMatrix:{value:new t.Matrix4},maxDistance:{value:180},opacity:{value:.5},fresnelCoe:{value:null},virtualCameraNear:{value:null},virtualCameraFar:{value:null},virtualCameraProjectionMatrix:{value:new t.Matrix4},virtualCameraMatrixWorld:{value:new t.Matrix4},virtualCameraProjectionMatrixInverse:{value:new t.Matrix4},resolution:{value:new t.Vector2}},vertexShader:"\n\t\tuniform mat4 textureMatrix;\n\t\tvarying vec4 vUv;\n\n\t\tvoid main() {\n\n\t\t\tvUv = textureMatrix * vec4( position, 1.0 );\n\n\t\t\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\n\t\t}",fragmentShader:"\n\t\tuniform vec3 color;\n\t\tuniform sampler2D tDiffuse;\n\t\tuniform sampler2D tDepth;\n\t\tuniform float maxDistance;\n\t\tuniform float opacity;\n\t\tuniform float fresnelCoe;\n\t\tuniform float virtualCameraNear;\n\t\tuniform float virtualCameraFar;\n\t\tuniform mat4 virtualCameraProjectionMatrix;\n\t\tuniform mat4 virtualCameraProjectionMatrixInverse;\n\t\tuniform mat4 virtualCameraMatrixWorld;\n\t\tuniform vec2 resolution;\n\t\tvarying vec4 vUv;\n\t\t#include <packing>\n\t\tfloat blendOverlay( float base, float blend ) {\n\t\t\treturn( base < 0.5 ? ( 2.0 * base * blend ) : ( 1.0 - 2.0 * ( 1.0 - base ) * ( 1.0 - blend ) ) );\n\t\t}\n\t\tvec3 blendOverlay( vec3 base, vec3 blend ) {\n\t\t\treturn vec3( blendOverlay( base.r, blend.r ), blendOverlay( base.g, blend.g ), blendOverlay( base.b, blend.b ) );\n\t\t}\n\t\tfloat getDepth( const in vec2 uv ) {\n\t\t\treturn texture2D( tDepth, uv ).x;\n\t\t}\n\t\tfloat getViewZ( const in float depth ) {\n\t\t\treturn perspectiveDepthToViewZ( depth, virtualCameraNear, virtualCameraFar );\n\t\t}\n\t\tvec3 getViewPosition( const in vec2 uv, const in float depth/*clip space*/, const in float clipW ) {\n\t\t\tvec4 clipPosition = vec4( ( vec3( uv, depth ) - 0.5 ) * 2.0, 1.0 );//ndc\n\t\t\tclipPosition *= clipW; //clip\n\t\t\treturn ( virtualCameraProjectionMatrixInverse * clipPosition ).xyz;//view\n\t\t}\n\t\tvoid main() {\n\t\t\tvec4 base = texture2DProj( tDiffuse, vUv );\n\t\t\t#ifdef useDepthTexture\n\t\t\t\tvec2 uv=(gl_FragCoord.xy-.5)/resolution.xy;\n\t\t\t\tuv.x=1.-uv.x;\n\t\t\t\tfloat depth = texture2DProj( tDepth, vUv ).r;\n\t\t\t\tfloat viewZ = getViewZ( depth );\n\t\t\t\tfloat clipW = virtualCameraProjectionMatrix[2][3] * viewZ+virtualCameraProjectionMatrix[3][3];\n\t\t\t\tvec3 viewPosition=getViewPosition( uv, depth, clipW );\n\t\t\t\tvec3 worldPosition=(virtualCameraMatrixWorld*vec4(viewPosition,1)).xyz;\n\t\t\t\tif(worldPosition.y>maxDistance) discard;\n\t\t\t\tfloat op=opacity;\n\t\t\t\t#ifdef DISTANCE_ATTENUATION\n\t\t\t\t\tfloat ratio=1.-(worldPosition.y/maxDistance);\n\t\t\t\t\tfloat attenuation=ratio*ratio;\n\t\t\t\t\top=opacity*attenuation;\n\t\t\t\t#endif\n\t\t\t\t#ifdef FRESNEL\n\t\t\t\t\top*=fresnelCoe;\n\t\t\t\t#endif\n\t\t\t\tgl_FragColor = vec4( blendOverlay( base.rgb, color ), op );\n\t\t\t#else\n\t\t\t\tgl_FragColor = vec4( blendOverlay( base.rgb, color ), 1.0 );\n\t\t\t#endif\n\t\t}\n\t"},exports.ReflectorForSSRPass=e;
