"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three"),e=require("./VolumeSlice.cjs.js"),n=function(e,n,i,a,s){if(arguments.length>0){switch(this.xLength=Number(e)||1,this.yLength=Number(n)||1,this.zLength=Number(i)||1,a){case"Uint8":case"uint8":case"uchar":case"unsigned char":case"uint8_t":this.data=new Uint8Array(s);break;case"Int8":case"int8":case"signed char":case"int8_t":this.data=new Int8Array(s);break;case"Int16":case"int16":case"short":case"short int":case"signed short":case"signed short int":case"int16_t":this.data=new Int16Array(s);break;case"Uint16":case"uint16":case"ushort":case"unsigned short":case"unsigned short int":case"uint16_t":this.data=new Uint16Array(s);break;case"Int32":case"int32":case"int":case"signed int":case"int32_t":this.data=new Int32Array(s);break;case"Uint32":case"uint32":case"uint":case"unsigned int":case"uint32_t":this.data=new Uint32Array(s);break;case"longlong":case"long long":case"long long int":case"signed long long":case"signed long long int":case"int64":case"int64_t":case"ulonglong":case"unsigned long long":case"unsigned long long int":case"uint64":case"uint64_t":throw"Error in Volume constructor : this type is not supported in JavaScript";case"Float32":case"float32":case"float":this.data=new Float32Array(s);break;case"Float64":case"float64":case"double":this.data=new Float64Array(s);break;default:this.data=new Uint8Array(s)}if(this.data.length!==this.xLength*this.yLength*this.zLength)throw"Error in Volume constructor, lengths are not matching arrayBuffer size"}this.spacing=[1,1,1],this.offset=[0,0,0],this.matrix=new t.Matrix3,this.matrix.identity();var r=-1/0;Object.defineProperty(this,"lowerThreshold",{get:function(){return r},set:function(t){r=t,this.sliceList.forEach((function(t){t.geometryNeedsUpdate=!0}))}});var h=1/0;Object.defineProperty(this,"upperThreshold",{get:function(){return h},set:function(t){h=t,this.sliceList.forEach((function(t){t.geometryNeedsUpdate=!0}))}}),this.sliceList=[]};n.prototype={constructor:n,getData:function(t,e,n){return this.data[n*this.xLength*this.yLength+e*this.xLength+t]},access:function(t,e,n){return n*this.xLength*this.yLength+e*this.xLength+t},reverseAccess:function(t){var e=Math.floor(t/(this.yLength*this.xLength)),n=Math.floor((t-e*this.yLength*this.xLength)/this.xLength);return[t-e*this.yLength*this.xLength-n*this.xLength,n,e]},map:function(t,e){var n=this.data.length;e=e||this;for(let i=0;i<n;i++)this.data[i]=t.call(e,this.data[i],i,this.data);return this},extractPerpendicularPlane:function(e,n){var i,a,s,r,h,c,o,g,u=(new t.Matrix4).identity(),l=this,d=new t.Vector3,f=new t.Vector3,p=new t.Vector3,x=new t.Vector3(this.xLength,this.yLength,this.zLength);switch(e){case"x":d.set(1,0,0),f.set(0,0,-1),p.set(0,-1,0),h=this.spacing[2],c=this.spacing[1],g=new t.Vector3(n,0,0),u.multiply((new t.Matrix4).makeRotationY(Math.PI/2)),o=(l.RASDimensions[0]-1)/2,u.setPosition(new t.Vector3(n-o,0,0));break;case"y":d.set(0,1,0),f.set(1,0,0),p.set(0,0,1),h=this.spacing[0],c=this.spacing[2],g=new t.Vector3(0,n,0),u.multiply((new t.Matrix4).makeRotationX(-Math.PI/2)),o=(l.RASDimensions[1]-1)/2,u.setPosition(new t.Vector3(0,n-o,0));break;case"z":default:d.set(0,0,1),f.set(1,0,0),p.set(0,-1,0),h=this.spacing[0],c=this.spacing[1],g=new t.Vector3(0,0,n),o=(l.RASDimensions[2]-1)/2,u.setPosition(new t.Vector3(0,0,n-o))}f.applyMatrix4(l.inverseMatrix).normalize(),f.argVar="i",p.applyMatrix4(l.inverseMatrix).normalize(),p.argVar="j",d.applyMatrix4(l.inverseMatrix).normalize(),i=Math.floor(Math.abs(f.dot(x))),a=Math.floor(Math.abs(p.dot(x))),s=Math.abs(i*h),r=Math.abs(a*c),g=Math.abs(Math.round(g.applyMatrix4(l.inverseMatrix).dot(d)));var y=[new t.Vector3(1,0,0),new t.Vector3(0,1,0),new t.Vector3(0,0,1)],L=[f,p,d].find((function(t){return Math.abs(t.dot(y[0]))>.9})),w=[f,p,d].find((function(t){return Math.abs(t.dot(y[1]))>.9})),M=[f,p,d].find((function(t){return Math.abs(t.dot(y[2]))>.9}));return{iLength:i,jLength:a,sliceAccess:function(t,e){var n=L===d?g:"i"===L.argVar?t:e,i=w===d?g:"i"===w.argVar?t:e,a=M===d?g:"i"===M.argVar?t:e,s=L.dot(y[0])>0?n:l.xLength-1-n,r=w.dot(y[1])>0?i:l.yLength-1-i,h=M.dot(y[2])>0?a:l.zLength-1-a;return l.access(s,r,h)},matrix:u,planeWidth:s,planeHeight:r}},extractSlice:function(t,n){var i=new e.VolumeSlice(this,n,t);return this.sliceList.push(i),i},repaintAllSlices:function(){return this.sliceList.forEach((function(t){t.repaint()})),this},computeMinMax:function(){var t=1/0,e=-1/0,n=this.data.length,i=0;for(i=0;i<n;i++)if(!isNaN(this.data[i])){var a=this.data[i];t=Math.min(t,a),e=Math.max(e,a)}return this.min=t,this.max=e,[t,e]}},exports.Volume=n;
