"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("three");const t=new e.Vector3,r=new e.Vector3;class a extends e.ShaderMaterial{constructor(t){super({uniforms:e.UniformsUtils.merge([e.UniformsLib.fog,{diffuse:{value:new e.Color},opacity:{value:1}}]),vertexShader:"\n        attribute vec3 control0;\n        attribute vec3 control1;\n        attribute vec3 direction;\n        varying float discardFlag;\n\n        #include <common>\n        #include <color_pars_vertex>\n        #include <fog_pars_vertex>\n        #include <logdepthbuf_pars_vertex>\n        #include <clipping_planes_pars_vertex>\n\n        void main() {\n          #include <color_vertex>\n\n          vec4 mvPosition = modelViewMatrix * vec4(position, 1.0);\n          gl_Position = projectionMatrix * mvPosition;\n\n          // Transform the line segment ends and control points into camera clip space\n          vec4 c0 = projectionMatrix * modelViewMatrix * vec4(control0, 1.0);\n          vec4 c1 = projectionMatrix * modelViewMatrix * vec4(control1, 1.0);\n          vec4 p0 = projectionMatrix * modelViewMatrix * vec4(position, 1.0);\n          vec4 p1 = projectionMatrix * modelViewMatrix * vec4(position + direction, 1.0);\n\n          c0.xy /= c0.w;\n          c1.xy /= c1.w;\n          p0.xy /= p0.w;\n          p1.xy /= p1.w;\n\n          // Get the direction of the segment and an orthogonal vector\n          vec2 dir = p1.xy - p0.xy;\n          vec2 norm = vec2(-dir.y, dir.x);\n\n          // Get control point directions from the line\n          vec2 c0dir = c0.xy - p1.xy;\n          vec2 c1dir = c1.xy - p1.xy;\n\n          // If the vectors to the controls points are pointed in different directions away\n          // from the line segment then the line should not be drawn.\n          float d0 = dot(normalize(norm), normalize(c0dir));\n          float d1 = dot(normalize(norm), normalize(c1dir));\n          discardFlag = float(sign(d0) != sign(d1));\n\n          #include <logdepthbuf_vertex>\n          #include <clipping_planes_vertex>\n          #include <fog_vertex>\n        }\n      ",fragmentShader:"\n        uniform vec3 diffuse;\n        uniform float opacity;\n        varying float discardFlag;\n\n        #include <common>\n        #include <color_pars_fragment>\n        #include <fog_pars_fragment>\n        #include <logdepthbuf_pars_fragment>\n        #include <clipping_planes_pars_fragment>\n\n        void main() {\n          if (discardFlag > 0.5) discard;\n\n          #include <clipping_planes_fragment>\n          vec3 outgoingLight = vec3(0.0);\n          vec4 diffuseColor = vec4(diffuse, opacity);\n          #include <logdepthbuf_fragment>\n          #include <color_fragment>\n          outgoingLight = diffuseColor.rgb; // simple shader\n          gl_FragColor = vec4(outgoingLight, diffuseColor.a);\n          #include <tonemapping_fragment>\n          #include <encodings_fragment>\n          #include <fog_fragment>\n          #include <premultiplied_alpha_fragment>\n        }\n      "}),Object.defineProperties(this,{opacity:{get:function(){return this.uniforms.opacity.value},set:function(e){this.uniforms.opacity.value=e}},color:{get:function(){return this.uniforms.diffuse.value}}}),this.setValues(t),this.isLDrawConditionalLineMaterial=!0}}class n extends e.LineSegments{constructor(e,t){super(e,t),this.isConditionalLine=!0}}const o=new e.Ray;function i(e){return"Part"===e||"Unofficial_Part"===e}class s{constructor(e,t){this.line=e,this.lineLength=e.length,this.currentCharIndex=0,this.currentChar=" ",this.lineNumber=t}seekNonSpace(){for(;this.currentCharIndex<this.lineLength;){if(this.currentChar=this.line.charAt(this.currentCharIndex)," "!==this.currentChar&&"\t"!==this.currentChar)return;this.currentCharIndex++}}getToken(){const e=this.currentCharIndex++;for(;this.currentCharIndex<this.lineLength&&(this.currentChar=this.line.charAt(this.currentCharIndex)," "!==this.currentChar&&"\t"!==this.currentChar);)this.currentCharIndex++;const t=this.currentCharIndex;return this.seekNonSpace(),this.line.substring(e,t)}getVector(){return new e.Vector3(parseFloat(this.getToken()),parseFloat(this.getToken()),parseFloat(this.getToken()))}getRemainingString(){return this.line.substring(this.currentCharIndex,this.lineLength)}isAtTheEnd(){return this.currentCharIndex>=this.lineLength}setToEnd(){this.currentCharIndex=this.lineLength}getLineNumberString(){return this.lineNumber>=0?" at line "+this.lineNumber:""}}class l{constructor(e){this.loader=e,this._cache={}}cloneResult(e){const t={};return t.faces=e.faces.map((e=>({colorCode:e.colorCode,material:e.material,vertices:e.vertices.map((e=>e.clone())),normals:e.normals.map((()=>null)),faceNormal:null}))),t.conditionalSegments=e.conditionalSegments.map((e=>({colorCode:e.colorCode,material:e.material,vertices:e.vertices.map((e=>e.clone())),controlPoints:e.controlPoints.map((e=>e.clone()))}))),t.lineSegments=e.lineSegments.map((e=>({colorCode:e.colorCode,material:e.material,vertices:e.vertices.map((e=>e.clone()))}))),t.type=e.type,t.category=e.category,t.keywords=e.keywords,t.subobjects=e.subobjects,t.totalFaces=e.totalFaces,t.startingConstructionStep=e.startingConstructionStep,t.materials=e.materials,t.group=null,t}async fetchData(t){let r=!1,a=0;for(;6!==a;){let n=t;switch(a){case 0:a+=1;break;case 1:n="parts/"+n,a+=1;break;case 2:n="p/"+n,a+=1;break;case 3:n="models/"+n,a+=1;break;case 4:n=t.substring(0,t.lastIndexOf("/")+1)+n,a+=1;break;case 5:r?a=6:(n=t=t.toLowerCase(),r=!0,a=0)}const o=this.loader,i=new e.FileLoader(o.manager);i.setPath(o.partsLibraryPath),i.setRequestHeader(o.requestHeader),i.setWithCredentials(o.withCredentials);try{return await i.loadAsync(n)}catch{continue}}throw new Error('LDrawLoader: Subobject "'+t+'" could not be loaded.')}parse(t,r=null){const a=this.loader,n=[],o=[],i=[],l=[],c={},h=e=>c[e]||null;let u="Model",d=null,g=null,p=0;-1!==t.indexOf("\r\n")&&(t=t.replace(/\r\n/g,"\n"));const m=t.split("\n"),f=m.length;let C=!1,w=null,M=null,b=!1,y=!0,L=!1,v=!0,k=!1;for(let t=0;t<f;t++){const r=m[t];if(0===r.length)continue;if(C){r.startsWith("0 FILE ")?(this.setData(w,M),w=r.substring(7),M=""):M+=r+"\n";continue}const f=new s(r,t+1);if(f.seekNonSpace(),f.isAtTheEnd())continue;const x=f.getToken();let S,D,E,T,_,N,V,F,A,I,P;switch(x){case"0":const r=f.getToken();if(r)switch(r){case"!LDRAW_ORG":u=f.getToken();break;case"!COLOUR":S=a.parseColorMetaDirective(f),S?c[S.userData.code]=S:console.warn("LDrawLoader: Error parsing material"+f.getLineNumberString());break;case"!CATEGORY":d=f.getToken();break;case"!KEYWORDS":const e=f.getRemainingString().split(",");e.length>0&&(g||(g=[]),e.forEach((function(e){g.push(e.trim())})));break;case"FILE":t>0&&(C=!0,w=f.getRemainingString(),M="",b=!1,y=!0);break;case"BFC":for(;!f.isAtTheEnd();){const e=f.getToken();switch(e){case"CERTIFY":case"NOCERTIFY":b="CERTIFY"===e,y=!0;break;case"CW":case"CCW":y="CCW"===e;break;case"INVERTNEXT":L=!0;break;case"CLIP":case"NOCLIP":v="CLIP"===e;break;default:console.warn('THREE.LDrawLoader: BFC directive "'+e+'" is unknown.')}}break;case"STEP":k=!0}break;case"1":D=f.getToken(),S=h(D);const s=parseFloat(f.getToken()),m=parseFloat(f.getToken()),R=parseFloat(f.getToken()),O=parseFloat(f.getToken()),z=parseFloat(f.getToken()),W=parseFloat(f.getToken()),U=parseFloat(f.getToken()),G=parseFloat(f.getToken()),j=parseFloat(f.getToken()),B=parseFloat(f.getToken()),H=parseFloat(f.getToken()),q=parseFloat(f.getToken()),$=(new e.Matrix4).set(O,z,W,s,U,G,j,m,B,H,q,R,0,0,0,1);let Y=f.getRemainingString().trim().replace(/\\/g,"/");a.fileMap[Y]?Y=a.fileMap[Y]:Y.startsWith("s/")?Y="parts/"+Y:Y.startsWith("48/")&&(Y="p/"+Y),l.push({material:S,colorCode:D,matrix:$,fileName:Y,inverted:L,startingConstructionStep:k}),L=!1;break;case"2":D=f.getToken(),S=h(D),N=f.getVector(),V=f.getVector(),E={material:S,colorCode:D,vertices:[N,V]},o.push(E);break;case"5":D=f.getToken(),S=h(D),N=f.getVector(),V=f.getVector(),I=f.getVector(),P=f.getVector(),E={material:S,colorCode:D,vertices:[N,V],controlPoints:[I,P]},i.push(E);break;case"3":D=f.getToken(),S=h(D),T=y,_=!b||!v,!0===T?(N=f.getVector(),V=f.getVector(),F=f.getVector()):(F=f.getVector(),V=f.getVector(),N=f.getVector()),n.push({material:S,colorCode:D,faceNormal:null,vertices:[N,V,F],normals:[null,null,null]}),p++,!0===_&&(n.push({material:S,colorCode:D,faceNormal:null,vertices:[F,V,N],normals:[null,null,null]}),p++);break;case"4":D=f.getToken(),S=h(D),T=y,_=!b||!v,!0===T?(N=f.getVector(),V=f.getVector(),F=f.getVector(),A=f.getVector()):(A=f.getVector(),F=f.getVector(),V=f.getVector(),N=f.getVector()),n.push({material:S,colorCode:D,faceNormal:null,vertices:[N,V,F,A],normals:[null,null,null,null]}),p+=2,!0===_&&(n.push({material:S,colorCode:D,faceNormal:null,vertices:[A,F,V,N],normals:[null,null,null,null]}),p+=2);break;default:throw new Error('LDrawLoader: Unknown line type "'+x+'"'+f.getLineNumberString()+".")}}return C&&this.setData(w,M),{faces:n,conditionalSegments:i,lineSegments:o,type:u,category:d,keywords:g,subobjects:l,totalFaces:p,startingConstructionStep:k,materials:c,fileName:r,group:null}}getData(e,t=!0){const r=e.toLowerCase(),a=this._cache[r];return null===a||a instanceof Promise?null:t?this.cloneResult(a):a}async ensureDataLoaded(e){const t=e.toLowerCase();t in this._cache||(this._cache[t]=this.fetchData(e).then((r=>{const a=this.parse(r,e);return this._cache[t]=a,a}))),await this._cache[t]}setData(e,t){const r=e.toLowerCase();this._cache[r]=this.parse(t,e)}}function c(e,t,r,a){return(!a&&"16"===e||a&&"24"===e)&&(e=t),r[e]||null}class h{constructor(e){this.loader=e,this.parseCache=new l(e),this._cache={}}async processIntoMesh(a){const n=this.loader,i=this.parseCache,s=new Set,l=async(t,r=null)=>{const a=t.subobjects,o=[];for(let e=0,t=a.length;e<t;e++){const t=a[e],r=i.ensureDataLoaded(t.fileName).then((()=>{const e=i.getData(t.fileName,!1);return r=e.type,/primitive/i.test(r)||"Subpart"===r?l(i.getData(t.fileName),t):this.loadModel(t.fileName).catch((e=>(console.warn(e),null)));var r}));o.push(r)}const h=new e.Group;h.userData.category=t.category,h.userData.keywords=t.keywords,t.group=h;const u=await Promise.all(o);for(let e=0,r=u.length;e<r;e++){const r=t.subobjects[e],a=u[e];if(null===a)continue;if(a.isGroup){const e=a;r.matrix.decompose(e.position,e.quaternion,e.scale),e.userData.startingConstructionStep=r.startingConstructionStep,e.name=r.fileName,n.applyMaterialsToMesh(e,r.colorCode,t.materials),h.add(e);continue}a.group.children.length&&h.add(a.group);const o=t.lineSegments,i=t.conditionalSegments,l=t.faces,d=a.lineSegments,g=a.conditionalSegments,p=a.faces,m=r.matrix,f=r.inverted,C=m.determinant()<0,w=r.colorCode,M="16"===w?"24":w;for(let e=0,r=d.length;e<r;e++){const r=d[e],a=r.vertices;a[0].applyMatrix4(m),a[1].applyMatrix4(m),r.colorCode="24"===r.colorCode?M:r.colorCode,r.material=r.material||c(r.colorCode,r.colorCode,t.materials,!0),o.push(r)}for(let e=0,r=g.length;e<r;e++){const r=g[e],a=r.vertices,n=r.controlPoints;a[0].applyMatrix4(m),a[1].applyMatrix4(m),n[0].applyMatrix4(m),n[1].applyMatrix4(m),r.colorCode="24"===r.colorCode?M:r.colorCode,r.material=r.material||c(r.colorCode,r.colorCode,t.materials,!0),i.push(r)}for(let e=0,r=p.length;e<r;e++){const r=p[e],a=r.vertices;for(let e=0,t=a.length;e<t;e++)a[e].applyMatrix4(m);r.colorCode="16"===r.colorCode?w:r.colorCode,r.material=r.material||c(r.colorCode,w,t.materials,!1),s.add(r.colorCode),C!==f&&a.reverse(),l.push(r)}t.totalFaces+=a.totalFaces}return r&&n.applyMaterialsToMesh(h,r.colorCode,t.materials),t};for(let e=0,t=a.faces;e<t;e++)s.add(a.faces[e].colorCode);if(await l(a),n.smoothNormals){const n=s.size>1;!function(a){for(let n=0,o=a.length;n<o;n++){const o=a[n],i=o.vertices,s=i[0],l=i[1],c=i[2];t.subVectors(l,s),r.subVectors(c,l),o.faceNormal=(new e.Vector3).crossVectors(t,r).normalize()}}(a.faces),function(t,r,a=!1){const n=100*(1+1e-10);function i(e){return`${~~(e.x*n)},${~~(e.y*n)},${~~(e.z*n)}`}function s(e,t){return`${i(e)}_${i(t)}`}function l(e,t,r){r.direction.subVectors(t,e).normalize();const a=e.dot(r.direction);return r.origin.copy(e).addScaledVector(r.direction,-a),r}function c(e){return s(e.origin,e.direction)}const h=new Set,u=new Map,d={},g=[];for(let t=0,n=r.length;t<n;t++){const n=r[t].vertices,o=n[0],i=n[1];if(h.add(s(o,i)),h.add(s(i,o)),a){const t=l(o,i,new e.Ray),r=c(t);if(!u.has(r)){l(i,o,t);const e=c(t),a={ray:t,distances:[]};u.set(r,a),u.set(e,a)}const a=u.get(r);let n=a.ray.direction.dot(o),s=a.ray.direction.dot(i);n>s&&([n,s]=[s,n]),a.distances.push(n,s)}}for(let e=0,r=t.length;e<r;e++){const r=t[e],n=r.vertices,i=n.length;for(let e=0;e<i;e++){const t=e,g=(e+1)%i,p=n[t],m=n[g],f=s(p,m);if(h.has(f))continue;if(a){l(p,m,o);const e=c(o);if(u.has(e)){const t=u.get(e),{ray:r,distances:a}=t;let n=r.direction.dot(p),o=r.direction.dot(m);n>o&&([n,o]=[o,n]);let i=!1;for(let e=0,t=a.length;e<t;e+=2)if(n>=a[e]&&o<=a[e+1]){i=!0;break}if(i)continue}}const C={index:t,tri:r};d[f]=C}}for(;;){let t=null;for(const e in d){t=d[e];break}if(null===t)break;const r=[t];for(;r.length>0;){const t=r.pop().tri,a=t.vertices,n=t.normals,o=t.faceNormal,i=a.length;for(let l=0;l<i;l++){const c=l,h=(l+1)%i,u=a[c],p=a[h];delete d[s(u,p)];const m=s(p,u),f=d[m];if(f){const a=f.tri,i=f.index,s=a.normals,l=s.length,u=a.faceNormal;if(Math.abs(a.faceNormal.dot(t.faceNormal))<.25)continue;m in d&&(r.push(f),delete d[m]);const p=(i+1)%l;n[c]&&s[p]&&n[c]!==s[p]&&(s[p].norm.add(n[c].norm),n[c].norm=s[p].norm);let C=n[c]||s[p];null===C&&(C={norm:new e.Vector3},g.push(C.norm)),null===n[c]&&(n[c]=C,C.norm.add(o)),null===s[p]&&(s[p]=C,C.norm.add(u)),n[h]&&s[i]&&n[h]!==s[i]&&(s[i].norm.add(n[h].norm),n[h].norm=s[i].norm);let w=n[h]||s[i];null===w&&(w={norm:new e.Vector3},g.push(w.norm)),null===n[h]&&(n[h]=w,w.norm.add(o)),null===s[i]&&(s[i]=w,w.norm.add(u))}}}}for(let e=0,t=g.length;e<t;e++)g[e].normalize()}(a.faces,a.lineSegments,n)}const h=a.group;return a.faces.length>0&&h.add(d(a.faces,3,!1,a.totalFaces)),a.lineSegments.length>0&&h.add(d(a.lineSegments,2)),a.conditionalSegments.length>0&&h.add(d(a.conditionalSegments,2,!0)),h}hasCachedModel(e){return null!==e&&e.toLowerCase()in this._cache}async getCachedModel(e){if(null!==e&&this.hasCachedModel(e)){const t=e.toLowerCase();return(await this._cache[t]).clone()}return null}async loadModel(e){const t=this.parseCache,r=e.toLowerCase();if(this.hasCachedModel(e))return this.getCachedModel(e);{await t.ensureDataLoaded(e);const a=t.getData(e),n=this.processIntoMesh(a);if(this.hasCachedModel(e))return this.getCachedModel(e);i(a.type)&&(this._cache[r]=n);return(await n).clone()}}async parseModel(e){const t=this.parseCache.parse(e);return i(t.type)&&this.hasCachedModel(t.fileName)?this.getCachedModel(t.fileName):this.processIntoMesh(t)}}function u(e,t){return e.colorCode===t.colorCode?0:e.colorCode<t.colorCode?-1:1}function d(a,o,i=!1,s=null){a.sort(u),null===s&&(s=a.length);const l=new Float32Array(o*s*3),c=3===o?new Float32Array(o*s*3):null,h=[],d=new Array(6),g=new e.BufferGeometry;let p=null,m=0,f=0,C=0;for(let n=0,s=a.length;n<s;n++){const s=a[n];let u=s.vertices;4===u.length&&(d[0]=u[0],d[1]=u[1],d[2]=u[2],d[3]=u[0],d[4]=u[2],d[5]=u[3],u=d);for(let e=0,t=u.length;e<t;e++){const t=u[e],r=C+3*e;l[r+0]=t.x,l[r+1]=t.y,l[r+2]=t.z}if(3===o){if(!s.faceNormal){const a=u[0],n=u[1],o=u[2];t.subVectors(n,a),r.subVectors(o,n),s.faceNormal=(new e.Vector3).crossVectors(t,r).normalize()}let a=s.normals;4===a.length&&(d[0]=a[0],d[1]=a[1],d[2]=a[2],d[3]=a[0],d[4]=a[2],d[5]=a[3],a=d);for(let e=0,t=a.length;e<t;e++){let t=s.faceNormal;a[e]&&(t=a[e].norm);const r=C+3*e;c[r+0]=t.x,c[r+1]=t.y,c[r+2]=t.z}}if(p!==s.colorCode){null!==p&&g.addGroup(m,f,h.length-1);const e=s.material;null!==e?3===o?h.push(e):2===o&&(null!==e?i?h.push(e.userData.edgeMaterial.userData.conditionalEdgeMaterial):h.push(e.userData.edgeMaterial):h.push(null)):h.push(s.colorCode),p=s.colorCode,m=C/3,f=u.length}else f+=u.length;C+=3*u.length}f>0&&g.addGroup(m,1/0,h.length-1),g.setAttribute("position",new e.BufferAttribute(l,3)),null!==c&&g.setAttribute("normal",new e.BufferAttribute(c,3));let w=null;if(2===o?w=i?new n(g,1===h.length?h[0]:h):new e.LineSegments(g,1===h.length?h[0]:h):3===o&&(w=new e.Mesh(g,1===h.length?h[0]:h)),i){w.isConditionalLine=!0;const t=new Float32Array(3*a.length*2),r=new Float32Array(3*a.length*2),n=new Float32Array(3*a.length*2);for(let e=0,o=a.length;e<o;e++){const o=a[e],i=o.vertices,s=o.controlPoints,l=s[0],c=s[1],h=i[0],u=i[1],d=3*e*2;t[d+0]=l.x,t[d+1]=l.y,t[d+2]=l.z,t[d+3]=l.x,t[d+4]=l.y,t[d+5]=l.z,r[d+0]=c.x,r[d+1]=c.y,r[d+2]=c.z,r[d+3]=c.x,r[d+4]=c.y,r[d+5]=c.z,n[d+0]=u.x-h.x,n[d+1]=u.y-h.y,n[d+2]=u.z-h.z,n[d+3]=u.x-h.x,n[d+4]=u.y-h.y,n[d+5]=u.z-h.z}g.setAttribute("control0",new e.BufferAttribute(t,3,!1)),g.setAttribute("control1",new e.BufferAttribute(r,3,!1)),g.setAttribute("direction",new e.BufferAttribute(n,3,!1))}return w}class g extends e.Loader{constructor(e){super(e),this.materials=[],this.materialLibrary={},this.partsCache=new h(this),this.fileMap={},this.setMaterials([]),this.smoothNormals=!0,this.partsLibraryPath=""}setPartsLibraryPath(e){return this.partsLibraryPath=e,this}async preloadMaterials(t){const r=new e.FileLoader(this.manager);r.setPath(this.path),r.setRequestHeader(this.requestHeader),r.setWithCredentials(this.withCredentials);const a=/^0 !COLOUR/,n=(await r.loadAsync(t)).split(/[\n\r]/g),o=[];for(let e=0,t=n.length;e<t;e++){const t=n[e];if(a.test(t)){const e=t.replace(a,""),r=this.parseColorMetaDirective(new s(e));o.push(r)}}this.setMaterials(o)}load(t,r,a,n){const o=new e.FileLoader(this.manager);o.setPath(this.path),o.setRequestHeader(this.requestHeader),o.setWithCredentials(this.withCredentials),o.load(t,(e=>{this.partsCache.parseModel(e,this.materialLibrary).then((e=>{this.applyMaterialsToMesh(e,"16",this.materialLibrary,!0),this.computeConstructionSteps(e),r(e)})).catch(n)}),a,n)}parse(e,t){this.partsCache.parseModel(e,this.materialLibrary).then((e=>{this.computeConstructionSteps(e),t(e)}))}setMaterials(e){this.materialLibrary={},this.materials=[];for(let t=0,r=e.length;t<r;t++)this.addMaterial(e[t]);return this.addMaterial(this.parseColorMetaDirective(new s("Main_Colour CODE 16 VALUE #FF8080 EDGE #333333"))),this.addMaterial(this.parseColorMetaDirective(new s("Edge_Colour CODE 24 VALUE #A0A0A0 EDGE #333333"))),this}setFileMap(e){return this.fileMap=e,this}addMaterial(e){const t=this.materialLibrary;return t[e.userData.code]||(this.materials.push(e),t[e.userData.code]=e),this}getMaterial(e){if(e.startsWith("0x2")){const t=e.substring(3);return this.parseColorMetaDirective(new s("Direct_Color_"+t+" CODE -1 VALUE #"+t+" EDGE #"+t))}return this.materialLibrary[e]||null}applyMaterialsToMesh(e,t,r,a=!1){const n=this,o="16"===t;function i(e,i){if(o&&!(i in r)&&!a)return i;const s=e.isLineSegments||e.isConditionalLine;(!s&&"16"===i||s&&"24"===i)&&(i=t);let l=null;if(i in r)l=r[i];else{if(!a)return i;if(l=n.getMaterial(i),null===l)throw new Error(`LDrawLoader: Material properties for code ${i} not available.`)}return e.isLineSegments&&(l=l.userData.edgeMaterial,e.isConditionalLine&&(l=l.userData.conditionalEdgeMaterial)),l}e.traverse((e=>{if(e.isMesh||e.isLineSegments)if(Array.isArray(e.material))for(let t=0,r=e.material.length;t<r;t++)e.material[t].isMaterial||(e.material[t]=i(e,e.material[t]));else e.material.isMaterial||(e.material=i(e,e.material))}))}getMainMaterial(){return this.getMaterial("16")}getMainEdgeMaterial(){return this.getMaterial("24")}parseColorMetaDirective(t){let r=null,n=16711935,o=16711935,i=1,l=!1,c=0,h=0,u=null;const d=t.getToken();if(!d)throw new Error('LDrawLoader: Material name was expected after "!COLOUR tag'+t.getLineNumberString()+".");let g=null;for(;g=t.getToken(),g;)switch(g.toUpperCase()){case"CODE":r=t.getToken();break;case"VALUE":if(n=t.getToken(),n.startsWith("0x"))n="#"+n.substring(2);else if(!n.startsWith("#"))throw new Error("LDrawLoader: Invalid color while parsing material"+t.getLineNumberString()+".");break;case"EDGE":if(o=t.getToken(),o.startsWith("0x"))o="#"+o.substring(2);else if(!o.startsWith("#")){if(u=this.getMaterial(o),!u)throw new Error("LDrawLoader: Invalid edge color while parsing material"+t.getLineNumberString()+".");u=u.userData.edgeMaterial}break;case"ALPHA":if(i=parseInt(t.getToken()),isNaN(i))throw new Error("LDrawLoader: Invalid alpha value in material definition"+t.getLineNumberString()+".");i=Math.max(0,Math.min(1,i/255)),i<1&&(l=!0);break;case"LUMINANCE":if(c=parseInt(t.getToken()),isNaN(c))throw new Error("LDrawLoader: Invalid luminance value in material definition"+s.getLineNumberString()+".");c=Math.max(0,Math.min(1,c/255));break;case"CHROME":h=1;break;case"PEARLESCENT":h=2;break;case"RUBBER":h=3;break;case"MATTE_METALLIC":h=4;break;case"METAL":h=5;break;case"MATERIAL":t.setToEnd();break;default:throw new Error('LDrawLoader: Unknown token "'+g+'" while parsing material'+t.getLineNumberString()+".")}let p=null;switch(h){case 0:p=new e.MeshStandardMaterial({color:n,roughness:.3,metalness:0});break;case 2:p=new e.MeshStandardMaterial({color:n,roughness:.3,metalness:.25});break;case 1:p=new e.MeshStandardMaterial({color:n,roughness:0,metalness:1});break;case 3:p=new e.MeshStandardMaterial({color:n,roughness:.9,metalness:0});break;case 4:p=new e.MeshStandardMaterial({color:n,roughness:.8,metalness:.4});break;case 5:p=new e.MeshStandardMaterial({color:n,roughness:.2,metalness:.85})}return p.transparent=l,p.premultipliedAlpha=!0,p.opacity=i,p.depthWrite=!l,p.polygonOffset=!0,p.polygonOffsetFactor=1,0!==c&&p.emissive.set(p.color).multiplyScalar(c),u||(u=new e.LineBasicMaterial({color:o,transparent:l,opacity:i,depthWrite:!l}),u.userData.code=r,u.name=d+" - Edge",u.userData.conditionalEdgeMaterial=new a({fog:!0,transparent:l,depthWrite:!l,color:o,opacity:i})),p.userData.code=r,p.name=d,p.userData.edgeMaterial=u,this.addMaterial(p),p}computeConstructionSteps(e){let t=0;e.traverse((e=>{e.isGroup&&(e.userData.startingConstructionStep&&t++,e.userData.constructionStep=t)})),e.userData.numConstructionSteps=t+1}}exports.LDrawLoader=g;
