import { ShaderMaterial, Vector2, Color } from 'three';
import type { ShaderMaterialParameters } from 'three';
export declare type ColorOptions = Color | string | number;
export interface LineMaterialParameters extends ShaderMaterialParameters {
    color?: ColorOptions;
    dashed?: boolean;
    dashOffset?: number;
    dashScale?: number;
    dashSize?: number;
    gapSize?: number;
    linewidth?: number;
    resolution?: Vector2;
}
declare class LineMaterial extends ShaderMaterial {
    private readonly isLineMaterial;
    dashed: boolean;
    color: Color;
    lineWidth: number;
    dashScale: number;
    dashOffset: number;
    dashSize: number;
    opacity: number;
    resolution: Vector2;
    alphaToCoverage: boolean;
    constructor(parameters?: LineMaterialParameters);
}
export { LineMaterial };
