"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("@babel/runtime/helpers/defineProperty"),e=require("fflate"),i=require("three");function n(t){return t&&"object"==typeof t&&"default"in t?t:{default:t}}var r=n(t);exports.USDZExporter=class{constructor(){r.default(this,"PRECISION",7),r.default(this,"materials",void 0),r.default(this,"textures",void 0),r.default(this,"files",void 0),this.materials={},this.textures={},this.files={}}async parse(t){this.files["model.usda"]=null;let n=this.buildHeader();t.traverseVisible((t=>{if(t instanceof i.Mesh&&t.isMesh&&t.material.isMeshStandardMaterial){const e=t.geometry,i=t.material,r="geometries/Geometry_"+e.id+".usd";if(!(r in this.files)){const t=this.buildMeshObject(e);this.files[r]=this.buildUSDFileAsString(t)}i.uuid in this.materials||(this.materials[i.uuid]=i),n+=this.buildXform(t,e,i)}})),n+=this.buildMaterials(this.materials),this.files["model.usda"]=e.strToU8(n),n=null;for(const t in this.textures){const e=this.textures[t],i=t.split("_")[1],n=1023===e.format,r=this.imageToCanvas(e.image,i),s=await new Promise((t=>null==r?void 0:r.toBlob(t,n?"image/png":"image/jpeg",1)));s&&(this.files[`textures/Texture_${t}.${n?"png":"jpg"}`]=new Uint8Array(await s.arrayBuffer()))}let r=0;for(const t in this.files){const e=this.files[t];r+=34+t.length;const i=63&r;if(4!==i&&null!==e&&e instanceof Uint8Array){const n=new Uint8Array(64-i);this.files[t]=[e,{extra:{12345:n}}]}e&&"number"==typeof e.length&&(r=e.length)}return e.zipSync(this.files,{level:0})}imageToCanvas(t,e){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const i=1024/Math.max(t.width,t.height),n=document.createElement("canvas");n.width=t.width*Math.min(1,i),n.height=t.height*Math.min(1,i);const r=n.getContext("2d");if(null==r||r.drawImage(t,0,0,n.width,n.height),void 0!==e){const t=parseInt(e,16),i=(t>>16&255)/255,s=(t>>8&255)/255,a=(255&t)/255,o=null==r?void 0:r.getImageData(0,0,n.width,n.height);if(o){const t=null==o?void 0:o.data;for(let e=0;e<t.length;e+=4)t[e+0]=t[e+0]*i,t[e+1]=t[e+1]*s,t[e+2]=t[e+2]*a;null==r||r.putImageData(o,0,0)}}return n}}buildHeader(){return'#usda 1.0\n(\n    customLayerData = {\n        string creator = "Three.js USDZExporter"\n    }\n    metersPerUnit = 1\n    upAxis = "Y"\n)\n'}buildUSDFileAsString(t){let i=this.buildHeader();return i+=t,e.strToU8(i)}buildXform(t,e,i){const n="Object_"+t.id,r=this.buildMatrix(t.matrixWorld);return t.matrixWorld.determinant()<0&&console.warn("THREE.USDZExporter: USDZ does not support negative scales",t),`def Xform "${n}" (\n    prepend references = @./geometries/Geometry_${e.id}.usd@</Geometry>\n)\n{\n    matrix4d xformOp:transform = ${r}\n    uniform token[] xformOpOrder = ["xformOp:transform"]\n    rel material:binding = </Materials/Material_${i.id}>\n}\n`}buildMatrix(t){const e=t.elements;return`( ${this.buildMatrixRow(e,0)}, ${this.buildMatrixRow(e,4)}, ${this.buildMatrixRow(e,8)}, ${this.buildMatrixRow(e,12)} )`}buildMatrixRow(t,e){return`(${t[e+0]}, ${t[e+1]}, ${t[e+2]}, ${t[e+3]})`}buildMeshObject(t){return`\ndef "Geometry"\n{\n  ${this.buildMesh(t)}\n}\n`}buildMesh(t){const e=t.attributes,i=e.position.count;return`\n    def Mesh "Geometry"\n    {\n        int[] faceVertexCounts = [${this.buildMeshVertexCount(t)}]\n        int[] faceVertexIndices = [${this.buildMeshVertexIndices(t)}]\n        normal3f[] normals = [${this.buildVector3Array(e.normal,i)}] (\n            interpolation = "vertex"\n        )\n        point3f[] points = [${this.buildVector3Array(e.position,i)}]\n        float2[] primvars:st = [${this.buildVector2Array(e.uv,i)}] (\n            interpolation = "vertex"\n        )\n        uniform token subdivisionScheme = "none"\n    }\n`}buildMeshVertexCount(t){const e=null!==t.index?t.index.array.length:t.attributes.position.count;return Array(e/3).fill(3).join(", ")}buildMeshVertexIndices(t){if(null!==t.index)return t.index.array.join(", ");const e=[],i=t.attributes.position.count;for(let t=0;t<i;t++)e.push(t);return e.join(", ")}buildVector3Array(t,e){if(void 0===t)return console.warn("USDZExporter: Normals missing."),Array(e).fill("(0, 0, 0)").join(", ");const i=[],n=t.array;for(let t=0;t<n.length;t+=3)i.push(`(${n[t+0].toPrecision(this.PRECISION)}, ${n[t+1].toPrecision(this.PRECISION)}, ${n[t+2].toPrecision(this.PRECISION)})`);return i.join(", ")}buildVector2Array(t,e){if(void 0===t)return console.warn("USDZExporter: UVs missing."),Array(e).fill("(0, 0)").join(", ");const i=[],n=t.array;for(let t=0;t<n.length;t+=2)i.push(`(${n[t+0].toPrecision(this.PRECISION)}, ${1-n[t+1].toPrecision(this.PRECISION)})`);return i.join(", ")}buildMaterials(t){const e=[];for(const i in t){const n=t[i];e.push(this.buildMaterial(n))}return`def "Materials"\n{\n${e.join("")}\n}\n`}buildMaterial(t){const e="            ",n=[],r=[];return null!==t.map?(n.push(`${e}color3f inputs:diffuseColor.connect = </Materials/Material_${t.id}/Texture_${t.map.id}_diffuse.outputs:rgb>`),r.push(this.buildTexture(t,t.map,"diffuse",t.color))):n.push(`${e}color3f inputs:diffuseColor = ${this.buildColor(t.color)}`),null!==t.emissiveMap?(n.push(`${e}color3f inputs:emissiveColor.connect = </Materials/Material_${t.id}/Texture_${t.emissiveMap.id}_emissive.outputs:rgb>`),r.push(this.buildTexture(t,t.emissiveMap,"emissive"))):t.emissive.getHex()>0&&n.push(`${e}color3f inputs:emissiveColor = ${this.buildColor(t.emissive)}`),null!==t.normalMap&&(n.push(`${e}normal3f inputs:normal.connect = </Materials/Material_${t.id}/Texture_${t.normalMap.id}_normal.outputs:rgb>`),r.push(this.buildTexture(t,t.normalMap,"normal"))),null!==t.aoMap&&(n.push(`${e}float inputs:occlusion.connect = </Materials/Material_${t.id}/Texture_${t.aoMap.id}_occlusion.outputs:r>`),r.push(this.buildTexture(t,t.aoMap,"occlusion"))),null!==t.roughnessMap&&1===t.roughness?(n.push(`${e}float inputs:roughness.connect = </Materials/Material_${t.id}/Texture_${t.roughnessMap.id}_roughness.outputs:g>`),r.push(this.buildTexture(t,t.roughnessMap,"roughness"))):n.push(`${e}float inputs:roughness = ${t.roughness}`),null!==t.metalnessMap&&1===t.metalness?(n.push(`${e}float inputs:metallic.connect = </Materials/Material_${t.id}/Texture_${t.metalnessMap.id}_metallic.outputs:b>`),r.push(this.buildTexture(t,t.metalnessMap,"metallic"))):n.push(`${e}float inputs:metallic = ${t.metalness}`),n.push(`${e}float inputs:opacity = ${t.opacity}`),t instanceof i.MeshPhysicalMaterial&&(n.push(`${e}float inputs:clearcoat = ${t.clearcoat}`),n.push(`${e}float inputs:clearcoatRoughness = ${t.clearcoatRoughness}`),n.push(`${e}float inputs:ior = ${t.ior}`)),`\n    def Material "Material_${t.id}"\n    {\n        def Shader "PreviewSurface"\n        {\n            uniform token info:id = "UsdPreviewSurface"\n${n.join("\n")}\n            int inputs:useSpecularWorkflow = 0\n            token outputs:surface\n        }\n        token outputs:surface.connect = </Materials/Material_${t.id}/PreviewSurface.outputs:surface>\n        token inputs:frame:stPrimvarName = "st"\n        def Shader "uvReader_st"\n        {\n            uniform token info:id = "UsdPrimvarReader_float2"\n            token inputs:varname.connect = </Materials/Material_${t.id}.inputs:frame:stPrimvarName>\n            float2 inputs:fallback = (0.0, 0.0)\n            float2 outputs:result\n        }\n${r.join("\n")}\n    }\n`}buildTexture(t,e,i,n){const r=e.id+(n?"_"+n.getHexString():""),s=1023===e.format;return this.textures[r]=e,`\n      def Shader "Transform2d_${i}" (\n          sdrMetadata = {\n              string role = "math"\n          }\n      )\n      {\n          uniform token info:id = "UsdTransform2d"\n          float2 inputs:in.connect = </Materials/Material_${t.id}/uvReader_st.outputs:result>\n          float2 inputs:scale = ${this.buildVector2(e.repeat)}\n          float2 inputs:translation = ${this.buildVector2(e.offset)}\n          float2 outputs:result\n      }\n      def Shader "Texture_${e.id}_${i}"\n      {\n          uniform token info:id = "UsdUVTexture"\n          asset inputs:file = @textures/Texture_${r}.${s?"png":"jpg"}@\n          float2 inputs:st.connect = </Materials/Material_${t.id}/Transform2d_${i}.outputs:result>\n          token inputs:wrapS = "repeat"\n          token inputs:wrapT = "repeat"\n          float outputs:r\n          float outputs:g\n          float outputs:b\n          float3 outputs:rgb\n      }`}buildColor(t){return`(${t.r}, ${t.g}, ${t.b})`}buildVector2(t){return`(${t.x}, ${t.y})`}};
