"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("@babel/runtime/helpers/defineProperty"),t=require("three");function r(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var i=r(e);exports.ColladaExporter=class{constructor(){i.default(this,"options",void 0),i.default(this,"geometryInfo",void 0),i.default(this,"materialMap",void 0),i.default(this,"imageMap",void 0),i.default(this,"textures",void 0),i.default(this,"libraryImages",void 0),i.default(this,"libraryGeometries",void 0),i.default(this,"libraryEffects",void 0),i.default(this,"libraryMaterials",void 0),i.default(this,"canvas",void 0),i.default(this,"ctx",void 0),i.default(this,"transMat",void 0),i.default(this,"getFuncs",["getX","getY","getZ","getW"]),this.options={version:"1.4.1",author:null,textureDirectory:"",upAxis:"Y_UP",unitName:null,unitMeter:null},this.geometryInfo=new WeakMap,this.materialMap=new WeakMap,this.imageMap=new WeakMap,this.textures=[],this.libraryImages=[],this.libraryGeometries=[],this.libraryEffects=[],this.libraryMaterials=[],this.canvas=null,this.ctx=null,this.transMat=null}parse(e,t,r={}){if(this.options={...this.options,...r},null===this.options.upAxis.match(/^[XYZ]_UP$/))return console.error("ColladaExporter: Invalid upAxis: valid values are X_UP, Y_UP or Z_UP."),null;if(null!==this.options.unitName&&null===this.options.unitMeter)return console.error("ColladaExporter: unitMeter needs to be specified if unitName is specified."),null;if(null!==this.options.unitMeter&&null===this.options.unitName)return console.error("ColladaExporter: unitName needs to be specified if unitMeter is specified."),null;if(""!==this.options.textureDirectory&&(this.options.textureDirectory=`${this.options.textureDirectory}/`.replace(/\\/g,"/").replace(/\/+/g,"/")),"1.4.1"!==this.options.version&&"1.5.0"!==this.options.version)return console.warn(`ColladaExporter : Version ${this.options.version} not supported for export. Only 1.4.1 and 1.5.0.`),null;const i=this.processObject(e);let s=`<?xml version="1.0" encoding="UTF-8" standalone="no" ?><COLLADA xmlns="${"1.4.1"===this.options.version?"http://www.collada.org/2005/11/COLLADASchema":"https://www.khronos.org/collada/"}" version="${this.options.version}"><asset><contributor><authoring_tool>three.js Collada Exporter</authoring_tool>${null!==this.options.author?`<author>${this.options.author}</author>`:""}</contributor><created>${(new Date).toISOString()}</created><modified>${(new Date).toISOString()}</modified><up_axis>Y_UP</up_axis></asset>`;s+=`<library_images>${this.libraryImages.join("")}</library_images>`,s+=`<library_effects>${this.libraryEffects.join("")}</library_effects>`,s+=`<library_materials>${this.libraryMaterials.join("")}</library_materials>`,s+=`<library_geometries>${this.libraryGeometries.join("")}</library_geometries>`,s+=`<library_visual_scenes><visual_scene id="Scene" name="scene">${i}</visual_scene></library_visual_scenes>`,s+='<scene><instance_visual_scene url="#Scene"/></scene>',s+="</COLLADA>";const a={data:this.format(s),textures:this.textures};return"function"==typeof t&&requestAnimationFrame((()=>t(a))),a}format(e){var t,r;const i=/^<\//,s=/(\?>$)|(\/>$)/,a=/<[^>]+>[^<]*<\/[^<]+>/,o=(e,t)=>t>0?e+o(e,t-1):"";let n=0;return null!=(t=null===(r=e.match(/(<[^>]+>[^<]+<\/[^<]+>)|(<[^>]+>)/g))||void 0===r?void 0:r.map((e=>{a.test(e)||s.test(e)||!i.test(e)||n--;const t=`${o("  ",n)}${e}`;return a.test(e)||s.test(e)||i.test(e)||n++,t})).join("\n"))?t:""}base64ToBuffer(e){const t=atob(e),r=new Uint8Array(t.length);for(let e=0,i=r.length;e<i;e++)r[e]=t.charCodeAt(e);return r}imageToData(e,t){var r;this.canvas=this.canvas||document.createElement("canvas"),this.ctx=this.ctx||this.canvas.getContext("2d"),this.canvas.width=e.width instanceof SVGAnimatedLength?0:e.width,this.canvas.height=e.height instanceof SVGAnimatedLength?0:e.height,null===(r=this.ctx)||void 0===r||r.drawImage(e,0,0);const i=this.canvas.toDataURL(`image/${t}`,1).replace(/^data:image\/(png|jpg);base64,/,"");return this.base64ToBuffer(i)}attrBufferToArray(e){if(e instanceof t.InterleavedBufferAttribute&&e.isInterleavedBufferAttribute){const t=new(0,e.array.constructor)(e.count*e.itemSize),r=e.itemSize;for(let i=0,s=e.count;i<s;i++)for(let s=0;s<r;s++)t[i*r+s]=e[this.getFuncs[s]](i);return t}return e.array}subArray(e,t,r){if(Array.isArray(e))return e.slice(t,t+r);return new(0,e.constructor)(e.buffer,t*e.BYTES_PER_ELEMENT,r)}getAttribute(e,t,r,i){const s=this.attrBufferToArray(e);return Array.isArray(s)?`${`<source id="${t}"><float_array id="${t}-array" count="${s.length}">`+s.join(" ")}</float_array><technique_common><accessor source="#${t}-array" count="${Math.floor(s.length/e.itemSize)}" stride="${e.itemSize}">${r.map((e=>`<param name="${e}" type="${i}" />`)).join("")}</accessor></technique_common></source>`:""}getTransform(e){return e.updateMatrix(),this.transMat=this.transMat||new t.Matrix4,this.transMat.copy(e.matrix),this.transMat.transpose(),`<matrix>${this.transMat.toArray().join(" ")}</matrix>`}processGeometry(e){let t=this.geometryInfo.get(e);if(!t){const r=e;if(!r.isBufferGeometry)throw new Error("THREE.ColladaExporter: Geometry is not of type THREE.BufferGeometry.");const i=`Mesh${this.libraryGeometries.length+1}`,s=r.index?r.index.count*r.index.itemSize:r.attributes.position.count,a=null!=r.groups&&0!==r.groups.length?r.groups:[{start:0,count:s,materialIndex:0}];let o=`<geometry id="${i}"${e.name?` name="${e.name}"`:""}><mesh>`;const n=`${i}-position`,l=`${i}-vertices`;o+=this.getAttribute(r.attributes.position,n,["X","Y","Z"],"float"),o+=`<vertices id="${l}"><input semantic="POSITION" source="#${n}" /></vertices>`;let u=`<input semantic="VERTEX" source="#${l}" offset="0" />`;if("normal"in r.attributes){const e=`${i}-normal`;o+=this.getAttribute(r.attributes.normal,e,["X","Y","Z"],"float"),u+=`<input semantic="NORMAL" source="#${e}" offset="0" />`}if("uv"in r.attributes){const e=`${i}-texcoord`;o+=this.getAttribute(r.attributes.uv,e,["S","T"],"float"),u+=`<input semantic="TEXCOORD" source="#${e}" offset="0" set="0" />`}if("uv2"in r.attributes){const e=`${i}-texcoord2`;o+=this.getAttribute(r.attributes.uv2,e,["S","T"],"float"),u+=`<input semantic="TEXCOORD" source="#${e}" offset="0" set="1" />`}if("color"in r.attributes){const e=`${i}-color`;o+=this.getAttribute(r.attributes.color,e,["X","Y","Z"],"uint8"),u+=`<input semantic="COLOR" source="#${e}" offset="0" />`}let c=null;if(r.index)c=this.attrBufferToArray(r.index);else{c=new Array(s);for(let e=0,t=c.length;e<t&&Array.isArray(c);e++)c[e]=e}for(let e=0,t=a.length;e<t;e++){const t=a[e],r=this.subArray(c,t.start,t.count),i=r.length/3;o+=`<triangles material="MESH_MATERIAL_${t.materialIndex}" count="${i}">`,o+=u,o+=`<p>${r.join(" ")}</p>`,o+="</triangles>"}o+="</mesh></geometry>",this.libraryGeometries.push(o),t={meshid:i,bufferGeometry:r},this.geometryInfo.set(e,t)}return t}processTexture(e){let t=this.imageMap.get(e);if(null==t){t=`image-${this.libraryImages.length+1}`;const r="png",i=e.name||t;let s=`<image id="${t}" name="${i}">`;"1.5.0"===this.options.version?s+=`<init_from><ref>${this.options.textureDirectory}${i}.${r}</ref></init_from>`:s+=`<init_from>${this.options.textureDirectory}${i}.${r}</init_from>`,s+="</image>",this.libraryImages.push(s),this.imageMap.set(e,t),this.textures.push({directory:this.options.textureDirectory,name:i,ext:r,data:this.imageToData(e.image,r),original:e})}return t}processMaterial(e){let r=this.materialMap.get(e);if(null==r){r=`Mat${this.libraryEffects.length+1}`;let i="phong";if(e instanceof t.MeshLambertMaterial?i="lambert":e instanceof t.MeshBasicMaterial&&(i="constant",null!==e.map&&console.warn("ColladaExporter: Texture maps not supported with MeshBasicMaterial.")),e instanceof t.MeshPhongMaterial){const s=e.emissive?e.emissive:new t.Color(0,0,0),a=e.color?e.color:new t.Color(0,0,0),o=e.specular?e.specular:new t.Color(1,1,1),n=e.shininess||0,l=e.reflectivity||0;let u="";e.transparent&&(u+=`<transparent>${e.map?'<texture texture="diffuse-sampler"></texture>':"<float>1</float>"}</transparent>`,e.opacity<1&&(u+=`<transparency><float>${e.opacity}</float></transparency>`));const c=`<technique sid="common"><${i}><emission>${e.emissiveMap?'<texture texture="emissive-sampler" texcoord="TEXCOORD" />':`<color sid="emission">${s.r} ${s.g} ${s.b} 1</color>`}</emission>${"constant"!==i?`<diffuse>${e.map?'<texture texture="diffuse-sampler" texcoord="TEXCOORD" />':`<color sid="diffuse">${a.r} ${a.g} ${a.b} 1</color>`}</diffuse>`:""}${"constant"!==i?`<bump>${e.normalMap?'<texture texture="bump-sampler" texcoord="TEXCOORD" />':""}</bump>`:""}${"phong"===i?`<specular><color sid="specular">${o.r} ${o.g} ${o.b} 1</color></specular><shininess>${e.specularMap?'<texture texture="specular-sampler" texcoord="TEXCOORD" />':`<float sid="shininess">${n}</float>`}</shininess>`:""}<reflective><color>${a.r} ${a.g} ${a.b} 1</color></reflective><reflectivity><float>${l}</float></reflectivity>${u}</${i}></technique>`,m=`<effect id="${r}-effect"><profile_COMMON>${e.map?`<newparam sid="diffuse-surface"><surface type="2D"><init_from>${this.processTexture(e.map)}</init_from></surface></newparam><newparam sid="diffuse-sampler"><sampler2D><source>diffuse-surface</source></sampler2D></newparam>`:""}${e.specularMap?`<newparam sid="specular-surface"><surface type="2D"><init_from>${this.processTexture(e.specularMap)}</init_from></surface></newparam><newparam sid="specular-sampler"><sampler2D><source>specular-surface</source></sampler2D></newparam>`:""}${e.emissiveMap?`<newparam sid="emissive-surface"><surface type="2D"><init_from>${this.processTexture(e.emissiveMap)}</init_from></surface></newparam><newparam sid="emissive-sampler"><sampler2D><source>emissive-surface</source></sampler2D></newparam>`:""}${e.normalMap?`<newparam sid="bump-surface"><surface type="2D"><init_from>${this.processTexture(e.normalMap)}</init_from></surface></newparam><newparam sid="bump-sampler"><sampler2D><source>bump-surface</source></sampler2D></newparam>`:""}${c}${e.side===t.DoubleSide?'<extra><technique profile="THREEJS"><double_sided sid="double_sided" type="int">1</double_sided></technique></extra>':""}</profile_COMMON></effect>`,p=`<material id="${r}"${e.name?` name="${e.name}"`:""}><instance_effect url="#${r}-effect" /></material>`;this.libraryMaterials.push(p),this.libraryEffects.push(m),this.materialMap.set(e,r)}}return r}processObject(e){let r=`<node name="${e.name}">`;if(r+=this.getTransform(e),new t.Mesh,e instanceof t.Mesh&&e.isMesh&&null!==e.geometry){const i=this.processGeometry(e.geometry),s=i.meshid,a=i.bufferGeometry;let o,n=null;const l=e.material||new t.MeshBasicMaterial,u=Array.isArray(l)?l:[l];o=a.groups.length>u.length?new Array(a.groups.length):new Array(u.length),n=o.fill(null).map(((e,t)=>this.processMaterial(u[t%u.length]))),r+=`<instance_geometry url="#${s}">`+(null!=n?`<bind_material><technique_common>${n.map(((e,t)=>`<instance_material symbol="MESH_MATERIAL_${t}" target="#${e}" ><bind_vertex_input semantic="TEXCOORD" input_semantic="TEXCOORD" input_set="0" /></instance_material>`)).join("")}</technique_common></bind_material>`:"")+"</instance_geometry>"}return e.children.forEach((e=>r+=this.processObject(e))),r+="</node>",r}};
