"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t=require("three"),e=require("./Frustum.cjs.js"),s=require("./Shader.cjs.js");const a=new t.Matrix4,i=new e,r=new t.Vector3,h=new t.Box3,n=[],o=[];exports.CSM=class{constructor(s){s=s||{},this.camera=s.camera,this.parent=s.parent,this.cascades=s.cascades||3,this.maxFar=s.maxFar||1e5,this.mode=s.mode||"practical",this.shadowMapSize=s.shadowMapSize||2048,this.shadowBias=s.shadowBias||1e-6,this.lightDirection=s.lightDirection||new t.Vector3(1,-1,1).normalize(),this.lightIntensity=s.lightIntensity||1,this.lightNear=s.lightNear||1,this.lightFar=s.lightFar||2e3,this.lightMargin=s.lightMargin||200,this.customSplitsCallback=s.customSplitsCallback,this.fade=!1,this.mainFrustum=new e,this.frustums=[],this.breaks=[],this.lights=[],this.shaders=new Map,this.createLights(),this.updateFrustums(),this.injectInclude()}createLights(){for(let e=0;e<this.cascades;e++){const e=new t.DirectionalLight(16777215,this.lightIntensity);e.castShadow=!0,e.shadow.mapSize.width=this.shadowMapSize,e.shadow.mapSize.height=this.shadowMapSize,e.shadow.camera.near=this.lightNear,e.shadow.camera.far=this.lightFar,e.shadow.bias=this.shadowBias,this.parent.add(e),this.parent.add(e.target),this.lights.push(e)}}initCascades(){const t=this.camera;t.updateProjectionMatrix(),this.mainFrustum.setFromProjectionMatrix(t.projectionMatrix,this.maxFar),this.mainFrustum.split(this.breaks,this.frustums)}updateShadowBounds(){const t=this.frustums;for(let e=0;e<t.length;e++){const t=this.lights[e].shadow.camera,s=this.frustums[e],a=s.vertices.near,i=s.vertices.far,r=i[0];let h;h=r.distanceTo(i[2])>r.distanceTo(a[2])?i[2]:a[2];let n=r.distanceTo(h);if(this.fade){const t=this.camera,e=Math.max(t.far,this.maxFar),a=s.vertices.far[0].z/(e-t.near);n+=.25*Math.pow(a,2)*(e-t.near)}t.left=-n/2,t.right=n/2,t.top=n/2,t.bottom=-n/2,t.updateProjectionMatrix()}}getBreaks(){const e=this.camera,s=Math.min(e.far,this.maxFar);switch(this.breaks.length=0,this.mode){case"uniform":a(this.cascades,e.near,s,this.breaks);break;case"logarithmic":i(this.cascades,e.near,s,this.breaks);break;case"practical":!function(e,s,r,h,c){n.length=0,o.length=0,i(e,s,r,o),a(e,s,r,n);for(let s=1;s<e;s++)c.push(t.MathUtils.lerp(n[s-1],o[s-1],h));c.push(1)}(this.cascades,e.near,s,.5,this.breaks);break;case"custom":void 0===this.customSplitsCallback&&console.error("CSM: Custom split scheme callback not defined."),this.customSplitsCallback(this.cascades,e.near,s,this.breaks)}function a(t,e,s,a){for(let i=1;i<t;i++)a.push((e+(s-e)*i/t)/s);a.push(1)}function i(t,e,s,a){for(let i=1;i<t;i++)a.push(e*(s/e)**(i/t)/s);a.push(1)}}update(){const t=this.camera,e=this.frustums;for(let s=0;s<e.length;s++){const n=this.lights[s],o=n.shadow.camera,c=(o.right-o.left)/this.shadowMapSize,d=(o.top-o.bottom)/this.shadowMapSize;n.shadow.camera.updateMatrixWorld(!0),a.multiplyMatrices(n.shadow.camera.matrixWorldInverse,t.matrixWorld),e[s].toSpace(a,i);const l=i.vertices.near,m=i.vertices.far;h.makeEmpty();for(let t=0;t<4;t++)h.expandByPoint(l[t]),h.expandByPoint(m[t]);h.getCenter(r),r.z=h.max.z+this.lightMargin,r.x=Math.floor(r.x/c)*c,r.y=Math.floor(r.y/d)*d,r.applyMatrix4(n.shadow.camera.matrixWorld),n.position.copy(r),n.target.position.copy(r),n.target.position.x+=this.lightDirection.x,n.target.position.y+=this.lightDirection.y,n.target.position.z+=this.lightDirection.z}}injectInclude(){t.ShaderChunk.lights_fragment_begin=s.lights_fragment_begin,t.ShaderChunk.lights_pars_begin=s.lights_pars_begin}setupMaterial(t){t.defines=t.defines||{},t.defines.USE_CSM=1,t.defines.CSM_CASCADES=this.cascades,this.fade&&(t.defines.CSM_FADE="");const e=[],s=this,a=this.shaders;t.onBeforeCompile=i=>{const r=Math.min(s.camera.far,s.maxFar);s.getExtendedBreaks(e),i.uniforms.CSM_cascades={value:e},i.uniforms.cameraNear={value:s.camera.near},i.uniforms.shadowFar={value:r},a.set(t,i)},a.set(t,null)}updateUniforms(){const t=Math.min(this.camera.far,this.maxFar);this.shaders.forEach((function(e,s){if(null!==e){const s=e.uniforms;this.getExtendedBreaks(s.CSM_cascades.value),s.cameraNear.value=this.camera.near,s.shadowFar.value=t}!this.fade&&"CSM_FADE"in s.defines?(delete s.defines.CSM_FADE,s.needsUpdate=!0):this.fade&&!("CSM_FADE"in s.defines)&&(s.defines.CSM_FADE="",s.needsUpdate=!0)}),this)}getExtendedBreaks(e){for(;e.length<this.breaks.length;)e.push(new t.Vector2);e.length=this.breaks.length;for(let t=0;t<this.cascades;t++){const s=this.breaks[t],a=this.breaks[t-1]||0;e[t].x=a,e[t].y=s}}updateFrustums(){this.getBreaks(),this.initCascades(),this.updateShadowBounds(),this.updateUniforms()}remove(){for(let t=0;t<this.lights.length;t++)this.parent.remove(this.lights[t])}dispose(){const t=this.shaders;t.forEach(((t,e)=>{delete e.onBeforeCompile,delete e.defines.USE_CSM,delete e.defines.CSM_CASCADES,delete e.defines.CSM_FADE,null!==t&&(delete t.uniforms.CSM_cascades,delete t.uniforms.cameraNear,delete t.uniforms.shadowFar),e.needsUpdate=!0})),t.clear()}};
