import { Scene, PerspectiveCamera, OrthographicCamera, EventDispatcher } from 'three';
declare type Camera = OrthographicCamera | PerspectiveCamera;
declare class ArcballControls extends EventDispatcher {
    private camera;
    private domElement;
    private scene;
    private mouseActions;
    private _mouseOp;
    private _v2_1;
    private _v3_1;
    private _v3_2;
    private _m4_1;
    private _m4_2;
    private _quat;
    private _translationMatrix;
    private _rotationMatrix;
    private _scaleMatrix;
    private _rotationAxis;
    private _cameraMatrixState;
    private _cameraProjectionState;
    private _fovState;
    private _upState;
    private _zoomState;
    private _nearPos;
    private _farPos;
    private _gizmoMatrixState;
    private _up0;
    private _zoom0;
    private _fov0;
    private _initialNear;
    private _nearPos0;
    private _initialFar;
    private _farPos0;
    private _cameraMatrixState0;
    private _gizmoMatrixState0;
    private _button;
    private _touchStart;
    private _touchCurrent;
    private _input;
    private _switchSensibility;
    private _startFingerDistance;
    private _currentFingerDistance;
    private _startFingerRotation;
    private _currentFingerRotation;
    private _devPxRatio;
    private _downValid;
    private _nclicks;
    private _downEvents;
    private _clickStart;
    private _maxDownTime;
    private _maxInterval;
    private _posThreshold;
    private _movementThreshold;
    private _currentCursorPosition;
    private _startCursorPosition;
    private _grid;
    private _gridPosition;
    private _gizmos;
    private _curvePts;
    private _timeStart;
    private _animationId;
    focusAnimationTime: number;
    private _timePrev;
    private _timeCurrent;
    private _anglePrev;
    private _angleCurrent;
    private _cursorPosPrev;
    private _cursorPosCurr;
    private _wPrev;
    private _wCurr;
    adjustNearFar: boolean;
    scaleFactor: number;
    dampingFactor: number;
    wMax: number;
    enableAnimations: boolean;
    enableGrid: boolean;
    cursorZoom: boolean;
    minFov: number;
    maxFov: number;
    enabled: boolean;
    enablePan: boolean;
    enableRotate: boolean;
    enableZoom: boolean;
    minDistance: number;
    maxDistance: number;
    minZoom: number;
    maxZoom: number;
    private target;
    private _currentTarget;
    private _tbRadius;
    private _state;
    constructor(camera: Camera | null, domElement?: HTMLElement | null | undefined, scene?: Scene | null | undefined);
    private onWindowResize;
    private onContextMenu;
    private onPointerCancel;
    private onPointerDown;
    private onPointerMove;
    private onPointerUp;
    private onWheel;
    private onSinglePanStart;
    private onSinglePanMove;
    private onSinglePanEnd;
    private onDoubleTap;
    private onDoublePanStart;
    private onDoublePanMove;
    private onDoublePanEnd;
    private onRotateStart;
    private onRotateMove;
    private onRotateEnd;
    private onPinchStart;
    private onPinchMove;
    private onPinchEnd;
    private onTriplePanStart;
    private onTriplePanMove;
    private onTriplePanEnd;
    private setCenter;
    private initializeMouseActions;
    private setMouseAction;
    private getOpFromAction;
    private getOpStateFromAction;
    private getAngle;
    private updateTouchEvent;
    private applyTransformMatrix;
    private calculateAngularSpeed;
    private calculatePointersDistance;
    private calculateRotationAxis;
    private calculateTbRadius;
    private focus;
    private drawGrid;
    connect: (domElement: HTMLElement) => void;
    dispose: () => void;
    private disposeGrid;
    private easeOutCubic;
    private activateGizmos;
    private getCursorNDC;
    private getCursorPosition;
    private setCamera;
    setGizmosVisible(value: boolean): void;
    private makeGizmos;
    private onFocusAnim;
    private onRotationAnim;
    private pan;
    reset: () => void;
    private rotate;
    copyState: () => void;
    pasteState: () => void;
    saveState: () => void;
    private applyScale;
    private setFov;
    setTarget: (x: number, y: number, z: number) => void;
    private setTransformationMatrices;
    private zRotate;
    private unprojectOnObj;
    private unprojectOnTbSurface;
    private unprojectOnTbPlane;
    private updateMatrixState;
    private updateTbState;
    update: () => void;
    private setStateFromJSON;
}
export { ArcballControls };
