'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var postprocessing = require('postprocessing');
var three = require('three');

function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };
  return _extends.apply(this, arguments);
}

var id = 0;

function _classPrivateFieldLooseKey(name) {
  return "__private_" + id++ + "_" + name;
}

function _classPrivateFieldLooseBase(receiver, privateKey) {
  if (!Object.prototype.hasOwnProperty.call(receiver, privateKey)) {
    throw new TypeError("attempted to use private field on non-instance");
  }

  return receiver;
}

var vertexShader = "#define GLSLIFY 1\nvarying vec2 vUv;void main(){vUv=position.xy*0.5+0.5;gl_Position=vec4(position.xy,1.0,1.0);}"; // eslint-disable-line

var fragmentShader$2 = "#define GLSLIFY 1\n#define EULER 2.718281828459045\n#define FLOAT_EPSILON 0.00001\nuniform sampler2D inputTexture;uniform sampler2D lastFrameReflectionsTexture;uniform sampler2D velocityTexture;uniform float samples;uniform float maxSamples;uniform float temporalResolveMix;uniform float temporalResolveCorrectionMix;varying vec2 vUv;\n#include <packing>\n#define min3(a, b, c) min(a, min(b, c))\n#define min4(a, b, c, d) min(a, min3(b, c, d))\n#define min5(a, b, c, d, e) min(a, min4(b, c, d, e))\n#define min6(a, b, c, d, e, f) min(a, min5(b, c, d, e, f))\n#define min7(a, b, c, d, e, f, g) min(a, min6(b, c, d, e, f, g))\n#define min8(a, b, c, d, e, f, g, h) min(a, min7(b, c, d, e, f, g, h))\n#define min9(a, b, c, d, e, f, g, h, i) min(a, min8(b, c, d, e, f, g, h, i))\n#define max3(a, b, c) max(a, max(b, c))\n#define max4(a, b, c, d) max(a, max3(b, c, d))\n#define max5(a, b, c, d, e) max(a, max4(b, c, d, e))\n#define max6(a, b, c, d, e, f) max(a, max5(b, c, d, e, f))\n#define max7(a, b, c, d, e, f, g) max(a, max6(b, c, d, e, f, g))\n#define max8(a, b, c, d, e, f, g, h) max(a, max7(b, c, d, e, f, g, h))\n#define max9(a, b, c, d, e, f, g, h, i) max(a, max8(b, c, d, e, f, g, h, i))\nvoid main(){vec4 inputTexel=texture2D(inputTexture,vUv);vec4 lastFrameReflectionsTexel;vec3 newColor;\n#ifdef TEMPORAL_RESOLVE\nvec2 velUv=texture2D(velocityTexture,vUv).xy;float movement=length(velUv)*100.;if(samples<2.){vec2 reprojectedUv=vUv-velUv;if(reprojectedUv.x>=0.&&reprojectedUv.x<=1.&&reprojectedUv.y>=0.&&reprojectedUv.y<=1.){lastFrameReflectionsTexel=texture2D(lastFrameReflectionsTexture,reprojectedUv);if(samples<2.){ivec2 size=textureSize(inputTexture,0);vec2 pxSize=vec2(float(size.x),float(size.y));vec2 px=1./pxSize;vec3 c02=texture2D(inputTexture,vUv+vec2(-px.x,px.y)).rgb;vec3 c12=texture2D(inputTexture,vUv+vec2(0.,px.y)).rgb;vec3 c22=texture2D(inputTexture,vUv+vec2(px.x,px.y)).rgb;vec3 c01=texture2D(inputTexture,vUv+vec2(-px.x,0.)).rgb;vec3 c11=inputTexel.rgb;vec3 c21=texture2D(inputTexture,vUv+vec2(px.x,0.)).rgb;vec3 c00=texture2D(inputTexture,vUv+vec2(-px.x,-px.y)).rgb;vec3 c10=texture2D(inputTexture,vUv+vec2(0.,-px.y)).rgb;vec3 c20=texture2D(inputTexture,vUv+vec2(px.x,-px.y)).rgb;vec3 minNeighborColor=min9(c02,c12,c22,c01,c11,c21,c00,c10,c20);vec3 maxNeighborColor=max9(c02,c12,c22,c01,c11,c21,c00,c10,c20);vec3 clampedColor=clamp(lastFrameReflectionsTexel.rgb,minNeighborColor,maxNeighborColor);lastFrameReflectionsTexel.rgb=mix(lastFrameReflectionsTexel.rgb,clampedColor,temporalResolveCorrectionMix);}}else{lastFrameReflectionsTexel.rgb=inputTexel.rgb;}}else{lastFrameReflectionsTexel=texture2D(lastFrameReflectionsTexture,vUv);}float alpha=min(inputTexel.a,lastFrameReflectionsTexel.a);alpha=samples<2.||movement<FLOAT_EPSILON ?(0.05+alpha): 0.;if(maxSamples!=0.&&samples>maxSamples&&alpha>1.-FLOAT_EPSILON){gl_FragColor=lastFrameReflectionsTexel;return;}if(alpha<1.){newColor=mix(lastFrameReflectionsTexel.rgb,inputTexel.rgb,(1.-alpha)*0.25);}else if(samples>4.&&movement<FLOAT_EPSILON&&length(lastFrameReflectionsTexel.rgb)<FLOAT_EPSILON){newColor=lastFrameReflectionsTexel.rgb;}else if(1./samples>=1.-temporalResolveMix){newColor=lastFrameReflectionsTexel.rgb*(temporalResolveMix)+inputTexel.rgb*(1.-temporalResolveMix);}else{float mixVal=(1./samples)/EULER;if(alpha<FLOAT_EPSILON&&samples<15.)mixVal+=0.3;newColor=mix(lastFrameReflectionsTexel.rgb,inputTexel.rgb,mixVal);}gl_FragColor=vec4(newColor,alpha);\n#else\nlastFrameReflectionsTexel=texture2D(lastFrameReflectionsTexture,vUv);vec2 velUv=texture2D(velocityTexture,vUv).xy;float movement=length(velUv)*100.;float alpha=min(inputTexel.a,lastFrameReflectionsTexel.a);alpha=samples<2.||movement<FLOAT_EPSILON ?(0.05+alpha): 0.;if(maxSamples!=0.&&samples>maxSamples&&alpha>1.-FLOAT_EPSILON){newColor=lastFrameReflectionsTexel.rgb;}else{float samplesMultiplier=pow(samples/32.,4.)+1.;if(samples>1.&&alpha>1.-FLOAT_EPSILON){newColor=lastFrameReflectionsTexel.rgb*(1.-1./(samples*samplesMultiplier))+inputTexel.rgb/(samples*samplesMultiplier);}else{newColor=inputTexel.rgb;}}gl_FragColor=vec4(newColor,alpha);\n#endif\n}"; // eslint-disable-line

class ComposeReflectionsPass extends postprocessing.Pass {
  constructor(ssrEffect) {
    super("ComposeReflectionsPass");
    this.ssrEffect = ssrEffect;
    this.renderTarget = new three.WebGLRenderTarget(typeof window !== "undefined" ? window.innerWidth : 2000, typeof window !== "undefined" ? window.innerHeight : 1000, {
      minFilter: three.NearestFilter,
      magFilter: three.NearestFilter
    });
    this.fullscreenMaterial = new three.ShaderMaterial({
      type: "ComposeReflectionsMaterial",
      uniforms: {
        inputTexture: new three.Uniform(null),
        lastFrameReflectionsTexture: new three.Uniform(null),
        velocityTexture: new three.Uniform(null),
        samples: new three.Uniform(1),
        maxSamples: new three.Uniform(0),
        temporalResolveMix: new three.Uniform(0.9),
        temporalResolveCorrectionMix: new three.Uniform(0.3875)
      },
      vertexShader,
      fragmentShader: fragmentShader$2
    });
  }

  dispose() {
    this.renderTarget.dispose();
    this.fullscreenMaterial.dispose();
  }

  setSize(width, height) {
    this.renderTarget.setSize(width, height);
  }

  render(renderer) {
    this.fullscreenMaterial.uniforms.samples.value = this.ssrEffect.samples;
    renderer.setRenderTarget(this.renderTarget);
    renderer.render(this.scene, this.camera);
  }

}

var bilateralBlur = "#define GLSLIFY 1\nconst float KERNEL_RADIUS=5.;uniform float g_Sharpness;uniform vec2 g_InvResolutionDirection;uniform float kernelRadius;float getViewZ(const float depth){return perspectiveDepthToViewZ(depth,cameraNear,cameraFar);}vec4 BlurFunction(sampler2D texSource,sampler2D texLinearDepth,vec2 uv,float r,vec4 center_c,float center_d,inout float w_total,in float radius){vec4 c=texture2D(texSource,uv);float d=getViewZ(1./unpackRGBAToDepth(texture2D(texLinearDepth,uv)));float BlurSigma=radius*0.5;float BlurFalloff=1.0/(2.0*BlurSigma*BlurSigma);float ddiff=(d-center_d)*g_Sharpness*10.;float w=exp2(-r*r*BlurFalloff-ddiff*ddiff);w_total+=w;return c*w;}vec4 blur(sampler2D blurTexture,sampler2D depthTexture){vec4 center_c=texture2D(blurTexture,vUv);float center_d=getViewZ(1./unpackRGBAToDepth(texture2D(depthTexture,vUv)));float radius=kernelRadius;vec4 c_total=center_c;float w_total=1.0;vec2 uv;for(float r=1.;r<=radius;++r){uv=vUv+g_InvResolutionDirection*r;c_total+=BlurFunction(blurTexture,depthTexture,uv,r,center_c,center_d,w_total,radius);}for(float r=1.;r<=radius;++r){uv=vUv-g_InvResolutionDirection*r;c_total+=BlurFunction(blurTexture,depthTexture,uv,r,center_c,center_d,w_total,radius);}return c_total/w_total;}"; // eslint-disable-line

var fragmentShader$1 = "#define GLSLIFY 1\n#define MODE_DEFAULT 0\n#define MODE_REFLECTIONS 1\n#define MODE_RAW_REFLECTION 2\n#define MODE_BLURRED_REFLECTIONS 3\n#define MODE_INPUT 4\n#define MODE_BLUR_MIX 5\n#define FLOAT_EPSILON 0.00001\n#define SQRT_3 1.7320508075688772 + FLOAT_EPSILON\nuniform sampler2D inputTexture;uniform sampler2D reflectionsTexture;uniform sampler2D depthTexture;uniform float samples;uniform float blurMix;\n#include <bilateralBlur>\nvoid mainImage(const in vec4 inputColor,const in vec2 uv,out vec4 outputColor){vec4 reflectionsTexel=texture2D(reflectionsTexture,vUv);vec3 reflectionClr=reflectionsTexel.xyz;\n#ifdef ENABLE_BLUR\nvec4 blurredReflectionsTexel=blur(reflectionsTexture,depthTexture);reflectionClr=mix(reflectionClr,blurredReflectionsTexel.xyz,blurMix);\n#endif\n#if RENDER_MODE == MODE_DEFAULT\noutputColor=vec4(inputColor.rgb+reflectionClr,1.);\n#endif\n#if RENDER_MODE == MODE_REFLECTIONS\noutputColor=vec4(reflectionClr,1.);\n#endif\n#if RENDER_MODE == MODE_RAW_REFLECTION\noutputColor=vec4(reflectionsTexel.xyz,1.);\n#endif\n#if RENDER_MODE == MODE_BLURRED_REFLECTIONS\n#ifdef ENABLE_BLUR\noutputColor=vec4(blurredReflectionsTexel.xyz,1.);\n#endif\n#endif\n#if RENDER_MODE == MODE_INPUT\noutputColor=vec4(inputColor.xyz,1.);\n#endif\n#if RENDER_MODE == MODE_BLUR_MIX\n#ifdef ENABLE_BLUR\noutputColor=vec4(vec3(blurMix),1.);\n#endif\n#endif\n}"; // eslint-disable-line

var helperFunctions = "#define GLSLIFY 1\nvec3 getViewPosition(const float depth){float clipW=_projectionMatrix[2][3]*depth+_projectionMatrix[3][3];vec4 clipPosition=vec4((vec3(vUv,depth)-0.5)*2.0,1.0);clipPosition*=clipW;return(_inverseProjectionMatrix*clipPosition).xyz;}float getViewZ(const float depth){return perspectiveDepthToViewZ(depth,cameraNear,cameraFar);}vec3 screenSpaceToWorldSpace(const vec2 uv,const float depth){vec4 ndc=vec4((uv.x-0.5)*2.0,(uv.y-0.5)*2.0,(depth-0.5)*2.0,1.0);vec4 clip=_inverseProjectionMatrix*ndc;vec4 view=cameraMatrixWorld*(clip/clip.w);return view.xyz;}\n#define Scale (vec3(0.8, 0.8, 0.8))\n#define K (19.19)\nvec3 hash(vec3 a){a=fract(a*Scale);a+=dot(a,a.yxz+K);return fract((a.xxy+a.yxx)*a.zyx);}float fresnel_dielectric_cos(float cosi,float eta){float c=abs(cosi);float g=eta*eta-1.0+c*c;float result;if(g>0.0){g=sqrt(g);float A=(g-c)/(g+c);float B=(c*(g+c)-1.0)/(c*(g-c)+1.0);result=0.5*A*A*(1.0+B*B);}else{result=1.0;}return result;}float fresnel_dielectric(vec3 Incoming,vec3 Normal,float eta){float cosine=dot(Incoming,Normal);return min(1.0,5.0*fresnel_dielectric_cos(cosine,eta));}float czm_luminance(vec3 rgb){const vec3 W=vec3(0.2125,0.7154,0.0721);return dot(rgb,W);}"; // eslint-disable-line

// a second set of bone information from the previou frame

const prev_skinning_pars_vertex =
/* glsl */
`
		#ifdef USE_SKINNING
		#ifdef BONE_TEXTURE
			uniform sampler2D prevBoneTexture;
			mat4 getPrevBoneMatrix( const in float i ) {
				float j = i * 4.0;
				float x = mod( j, float( boneTextureSize ) );
				float y = floor( j / float( boneTextureSize ) );
				float dx = 1.0 / float( boneTextureSize );
				float dy = 1.0 / float( boneTextureSize );
				y = dy * ( y + 0.5 );
				vec4 v1 = texture2D( prevBoneTexture, vec2( dx * ( x + 0.5 ), y ) );
				vec4 v2 = texture2D( prevBoneTexture, vec2( dx * ( x + 1.5 ), y ) );
				vec4 v3 = texture2D( prevBoneTexture, vec2( dx * ( x + 2.5 ), y ) );
				vec4 v4 = texture2D( prevBoneTexture, vec2( dx * ( x + 3.5 ), y ) );
				mat4 bone = mat4( v1, v2, v3, v4 );
				return bone;
			}
		#else
			uniform mat4 prevBoneMatrices[ MAX_BONES ];
			mat4 getPrevBoneMatrix( const in float i ) {
				mat4 bone = prevBoneMatrices[ int(i) ];
				return bone;
			}
		#endif
		#endif
	`; // Returns the body of the vertex shader for the velocity buffer and
// outputs the position of the current and last frame positions

const velocity_vertex =
/* glsl */
`
		vec3 transformed;

		// Get the normal
		${three.ShaderChunk.skinbase_vertex}
		${three.ShaderChunk.beginnormal_vertex}
		${three.ShaderChunk.skinnormal_vertex}
		${three.ShaderChunk.defaultnormal_vertex}

		// Get the current vertex position
		transformed = vec3( position );
		${three.ShaderChunk.skinning_vertex}
		newPosition = modelViewMatrix * vec4( transformed, 1.0 );

		// Get the previous vertex position
		transformed = vec3( position );
		${three.ShaderChunk.skinbase_vertex.replace(/mat4 /g, "").replace(/getBoneMatrix/g, "getPrevBoneMatrix")}
		${three.ShaderChunk.skinning_vertex.replace(/vec4 /g, "")}
		prevPosition = prevModelViewMatrix * vec4( transformed, 1.0 );

		newPosition =  projectionMatrix * newPosition;
		prevPosition = prevProjectionMatrix * prevPosition;

		gl_Position = mix( newPosition, prevPosition, interpolateGeometry );

	`;
const VelocityShader = {
  uniforms: {
    prevProjectionMatrix: {
      value: new three.Matrix4()
    },
    prevModelViewMatrix: {
      value: new three.Matrix4()
    },
    prevBoneTexture: {
      value: null
    },
    interpolateGeometry: {
      value: 0
    },
    intensity: {
      value: 1
    },
    alphaTest: {
      value: 0.0
    },
    map: {
      value: null
    },
    alphaMap: {
      value: null
    },
    opacity: {
      value: 1.0
    }
  },
  vertexShader:
  /* glsl */
  `
			${three.ShaderChunk.skinning_pars_vertex}
			${prev_skinning_pars_vertex}

			uniform mat4 prevProjectionMatrix;
			uniform mat4 prevModelViewMatrix;
			uniform float interpolateGeometry;
			varying vec4 prevPosition;
			varying vec4 newPosition;

			void main() {

				${velocity_vertex}

			}
		`,
  fragmentShader:
  /* glsl */
  `
			uniform float intensity;
			varying vec4 prevPosition;
			varying vec4 newPosition;

			void main() {
				#ifdef NEEDS_UPDATED_REFLECTIONS
					gl_FragColor = vec4(1., 1., 1., 1. );
					return;
				#endif

				vec3 pos0 = prevPosition.xyz / prevPosition.w;
				pos0 += 1.0;
				pos0 /= 2.0;

				vec3 pos1 = newPosition.xyz / newPosition.w;
				pos1 += 1.0;
				pos1 /= 2.0;

				vec3 vel = pos1 - pos0;
				gl_FragColor = vec4( vel * intensity, 1.0 );

			}
		`
};

// WebGL2: will render normals to RGB channel of "gNormal" buffer, roughness to A channel of "gNormal" buffer, depth to RGBA channel of "gDepth" buffer

class NormalDepthRoughnessMaterial extends three.ShaderMaterial {
  constructor() {
    super({
      type: "NormalDepthRoughnessMaterial",
      defines: {
        USE_UV: "",
        TEMPORAL_RESOLVE: ""
      },
      uniforms: _extends({
        opacity: new three.Uniform(1),
        normalMap: new three.Uniform(null),
        normalScale: new three.Uniform(new three.Vector2(1, 1)),
        uvTransform: new three.Uniform(new three.Matrix3()),
        roughness: new three.Uniform(1),
        roughnessMap: new three.Uniform(null)
      }, three.UniformsUtils.clone(VelocityShader.uniforms)),
      vertexShader:
      /* glsl */
      `
                #ifdef USE_MRT
                out vec2 vHighPrecisionZW;
                #endif

                #ifdef TEMPORAL_RESOLVE

                uniform mat4 prevProjectionMatrix;
                uniform mat4 prevModelViewMatrix;
                uniform float interpolateGeometry;
                varying vec4 prevPosition;
                varying vec4 newPosition;
                #endif

                #define NORMAL
                #if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )
                    varying vec3 vViewPosition;
                #endif
                #include <common>
                #include <uv_pars_vertex>
                #include <displacementmap_pars_vertex>
                #include <normal_pars_vertex>
                #include <morphtarget_pars_vertex>
                #include <skinning_pars_vertex>
                #include <logdepthbuf_pars_vertex>
                #include <clipping_planes_pars_vertex>

                void main() {
                    #include <uv_vertex>
                    #include <beginnormal_vertex>
                    #include <morphnormal_vertex>
                    #include <skinbase_vertex>
                    #include <skinnormal_vertex>
                    #include <defaultnormal_vertex>
                    #include <normal_vertex>
                    #include <begin_vertex>
                    #include <morphtarget_vertex>
                    #include <skinning_vertex>
                    #include <displacementmap_vertex>
                    #include <project_vertex>
                    #include <logdepthbuf_vertex>
                    #include <clipping_planes_vertex>
                    #if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )
                        vViewPosition = - mvPosition.xyz;
                    #endif

                    #ifdef USE_MRT
                        vHighPrecisionZW = gl_Position.zw;
                    #endif 

                    #ifdef USE_UV
                        vUv = ( uvTransform * vec3( uv, 1 ) ).xy;
                    #endif

                    #ifdef TEMPORAL_RESOLVE
                        #ifndef NEEDS_UPDATED_REFLECTIONS
                        transformed = vec3( position );
                        
                        newPosition = modelViewMatrix * vec4( transformed, 1.0 );
                        prevPosition = prevModelViewMatrix * vec4( transformed, 1.0 );

                        newPosition =  projectionMatrix * newPosition;
                        prevPosition = prevProjectionMatrix * prevPosition;

                        // gl_Position = mix( newPosition, prevPosition, interpolateGeometry );
                        #endif
                    #endif

                }
            `,
      fragmentShader:
      /* glsl */
      `
                #define NORMAL
                #if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )
                    varying vec3 vViewPosition;
                #endif
                #include <packing>
                #include <uv_pars_fragment>
                #include <normal_pars_fragment>
                #include <bumpmap_pars_fragment>
                #include <normalmap_pars_fragment>
                #include <logdepthbuf_pars_fragment>
                #include <clipping_planes_pars_fragment>

                #include <roughnessmap_pars_fragment>

                
                #ifdef USE_MRT
                    layout(location = 0) out vec4 gNormal;
                    layout(location = 1) out vec4 gDepth;

                    #ifdef TEMPORAL_RESOLVE
                        layout(location = 2) out vec4 gVelocity;

                        uniform float intensity;
                        varying vec4 prevPosition;
                        varying vec4 newPosition;
                    #endif
                
                    in vec2 vHighPrecisionZW;
                #endif

                uniform float roughness;

                void main() {
                    #include <clipping_planes_fragment>
                    #include <logdepthbuf_fragment>
                    #include <normal_fragment_begin>
                    #include <normal_fragment_maps>
                    #include <roughnessmap_fragment>

                    vec3 normalColor = packNormalToRGB( normal );
                    float roughnessValue = min(1., roughnessFactor);

                    #ifdef USE_MRT
                        float fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;
                        vec4 depthColor = packDepthToRGBA( fragCoordZ );
                        gNormal = vec4( normalColor, 1.0 );
                        gNormal.a = roughnessValue;
                        gDepth = depthColor;

                        #ifdef TEMPORAL_RESOLVE
                            #ifdef NEEDS_UPDATED_REFLECTIONS
                                gVelocity = vec4(1., 1., 1., 1.);
                            #else
                                vec3 pos0 = prevPosition.xyz / prevPosition.w;
                                pos0 += 1.0;
                                pos0 /= 2.0;

                                vec3 pos1 = newPosition.xyz / newPosition.w;
                                pos1 += 1.0;
                                pos1 /= 2.0;

                                vec3 vel = pos1 - pos0;
                                
                                gVelocity = vec4( vel * intensity, 1.0 );
                            #endif
                        #endif

                    #else
                        gl_FragColor = vec4(normalColor, roughnessValue);
                    #endif

                }
            `,
      toneMapped: false
    });
    this.normalMapType = three.TangentSpaceNormalMap;
    this.normalScale = new three.Vector2(1, 1);
    Object.defineProperty(this, "glslVersion", {
      get() {
        return "USE_MRT" in this.defines ? three.GLSL3 : null;
      },

      set(_) {}

    });
  }

}

var fragmentShader = "#define GLSLIFY 1\nvarying vec2 vUv;uniform sampler2D inputTexture;uniform sampler2D lastFrameReflectionsTexture;uniform sampler2D normalTexture;uniform sampler2D depthTexture;uniform mat4 _projectionMatrix;uniform mat4 _inverseProjectionMatrix;uniform mat4 cameraMatrixWorld;uniform float cameraNear;uniform float cameraFar;uniform float rayStep;uniform float intensity;uniform float maxDepthDifference;uniform float roughnessFadeOut;uniform float maxRoughness;uniform float maxDepth;uniform float rayFadeOut;uniform float thickness;uniform float ior;uniform float samples;\n#ifdef ENABLE_JITTERING\nuniform float jitter;uniform float jitterRough;uniform float jitterSpread;\n#endif\n#define FLOAT_EPSILON 0.00001\n#define EARLY_OUT_COLOR vec4(0., 0., 0., 1.)\nconst vec2 INVALID_RAY_COORDS=vec2(-1.);float _maxDepthDifference;\n#include <packing>\n#include <helperFunctions>\nvec2 BinarySearch(inout vec3 dir,inout vec3 hitPos,inout float rayHitDepthDifference);vec2 RayMarch(vec3 dir,inout vec3 hitPos,inout float rayHitDepthDifference);void main(){vec4 depthTexel=texture2D(depthTexture,vUv);if(dot(depthTexel.rgb,depthTexel.rgb)<FLOAT_EPSILON){gl_FragColor=EARLY_OUT_COLOR;return;}float unpackedDepth=unpackRGBAToDepth(depthTexel);if(unpackedDepth>maxDepth){gl_FragColor=EARLY_OUT_COLOR;return;}vec4 normalTexel=texture2D(normalTexture,vUv);float roughness=normalTexel.a;if(roughness>maxRoughness){gl_FragColor=EARLY_OUT_COLOR;return;}if(roughness>1.-FLOAT_EPSILON&&roughnessFadeOut>1.-FLOAT_EPSILON){gl_FragColor=EARLY_OUT_COLOR;return;}float specular=1.-roughness;specular*=specular;normalTexel.rgb=unpackRGBToNormal(normalTexel.rgb);float depth=getViewZ(unpackedDepth);vec3 viewNormal=normalTexel.xyz;vec3 viewPos=getViewPosition(depth);vec3 worldPos=screenSpaceToWorldSpace(vUv,unpackedDepth);vec3 jitt=vec3(0.);\n#ifdef ENABLE_JITTERING\nvec3 randomJitter=hash(5.*(samples*worldPos))-0.5;float spread=((2.-specular)+roughness*jitterRough)*jitterSpread;float jitterMix=jitter+jitterRough*roughness;if(jitterMix>1.)jitterMix=1.;jitt=mix(vec3(0.),randomJitter*spread,jitterMix);\n#endif\njitt=mix(jitt,vec3(0.),0.5);viewNormal+=jitt;vec3 reflected=normalize(reflect(normalize(viewPos),normalize(viewNormal)));_maxDepthDifference=maxDepthDifference*0.01;vec3 rayDir=reflected*-viewPos.z;vec3 hitPos=viewPos;float rayHitDepthDifference;vec2 coords=RayMarch(rayDir,hitPos,rayHitDepthDifference);if(coords.x==-1.){gl_FragColor=EARLY_OUT_COLOR;return;}vec2 coordsNDC=(coords*2.0-1.0);float screenFade=0.1;float maxDimension=min(1.0,max(abs(coordsNDC.x),abs(coordsNDC.y)));float screenEdgefactor=1.0-(max(0.0,maxDimension-screenFade)/(1.0-screenFade));screenEdgefactor=max(0.,screenEdgefactor);vec4 SSRTexel=texture2D(inputTexture,coords.xy);vec4 SSRTexelReflected=texture2D(lastFrameReflectionsTexture,coords.xy);vec3 SSR=SSRTexel.rgb+SSRTexelReflected.rgb;float roughnessFactor=mix(specular,1.,max(0.,1.-roughnessFadeOut));vec3 finalSSR=SSR*screenEdgefactor*roughnessFactor;vec3 hitWorldPos=screenSpaceToWorldSpace(coords,rayHitDepthDifference);float reflectionDistance=distance(hitWorldPos,worldPos);reflectionDistance+=1.;if(rayFadeOut!=0.){float opacity=1./(reflectionDistance*reflectionDistance*rayFadeOut*0.01);if(opacity>1.)opacity=1.;finalSSR*=opacity;}float blurMix=0.;\n#ifdef ENABLE_BLUR\nblurMix=sqrt(reflectionDistance)*maxRoughness;if(blurMix>1.)blurMix=1.;\n#endif\nfloat fresnelFactor=fresnel_dielectric(normalize(viewPos),viewNormal,ior);finalSSR=finalSSR*fresnelFactor*intensity;finalSSR=min(vec3(1.),finalSSR);gl_FragColor=vec4(finalSSR,SSRTexelReflected.a);\n#include <encodings_fragment>\n}vec2 RayMarch(vec3 dir,inout vec3 hitPos,inout float rayHitDepthDifference){dir=normalize(dir);dir*=rayStep;float depth;int steps;vec4 projectedCoord;vec4 lastProjectedCoord;float unpackedDepth;float stepMultiplier=1.;vec4 depthTexel;for(int i=0;i<MAX_STEPS;i++){hitPos+=dir*stepMultiplier;projectedCoord=_projectionMatrix*vec4(hitPos,1.0);projectedCoord.xy/=projectedCoord.w;projectedCoord.xy=projectedCoord.xy*0.5+0.5;if(projectedCoord.x>1.||projectedCoord.y>1.){hitPos-=dir*stepMultiplier;stepMultiplier*=0.5;continue;}depthTexel=textureLod(depthTexture,projectedCoord.xy,0.);unpackedDepth=unpackRGBAToDepth(depthTexel);depth=getViewZ(unpackedDepth);rayHitDepthDifference=depth-hitPos.z;if(rayHitDepthDifference>=0.&&rayHitDepthDifference<thickness){\n#if NUM_BINARY_SEARCH_STEPS == 0\nif(dot(depthTexel.rgb,depthTexel.rgb)<FLOAT_EPSILON)return INVALID_RAY_COORDS;\n#else\nprojectedCoord.xy=BinarySearch(dir,hitPos,rayHitDepthDifference);\n#endif\nreturn projectedCoord.xy;}steps++;lastProjectedCoord=projectedCoord;}\n#ifndef STRETCH_MISSED_RAYS\nreturn INVALID_RAY_COORDS;\n#endif\nrayHitDepthDifference=unpackedDepth;return projectedCoord.xy;}vec2 BinarySearch(inout vec3 dir,inout vec3 hitPos,inout float rayHitDepthDifference){float depth;vec4 projectedCoord;vec2 lastMinProjectedCoordXY;float unpackedDepth;vec4 depthTexel;for(int i=0;i<NUM_BINARY_SEARCH_STEPS;i++){projectedCoord=_projectionMatrix*vec4(hitPos,1.0);projectedCoord.xy/=projectedCoord.w;projectedCoord.xy=projectedCoord.xy*0.5+0.5;if((lastMinProjectedCoordXY.x>1.||lastMinProjectedCoordXY.y>1.)&&(projectedCoord.x>1.||projectedCoord.y>1.))return INVALID_RAY_COORDS;depthTexel=textureLod(depthTexture,projectedCoord.xy,0.);unpackedDepth=unpackRGBAToDepth(depthTexel);depth=getViewZ(unpackedDepth);rayHitDepthDifference=depth-hitPos.z;dir*=0.5;if(rayHitDepthDifference>0.0){hitPos-=dir;}else{hitPos+=dir;lastMinProjectedCoordXY=projectedCoord.xy;}}if(dot(depthTexel.rgb,depthTexel.rgb)<FLOAT_EPSILON)return INVALID_RAY_COORDS;if(abs(rayHitDepthDifference)>_maxDepthDifference)return INVALID_RAY_COORDS;projectedCoord=_projectionMatrix*vec4(hitPos,1.0);projectedCoord.xy/=projectedCoord.w;projectedCoord.xy=projectedCoord.xy*0.5+0.5;\n#ifndef STRETCH_MISSED_RAYS\nif(projectedCoord.x>1.||projectedCoord.y>1.)return INVALID_RAY_COORDS;\n#endif\nrayHitDepthDifference=unpackedDepth;return projectedCoord.xy;}"; // eslint-disable-line

class ReflectionsMaterial extends three.ShaderMaterial {
  constructor() {
    super({
      type: "ReflectionsMaterial",
      uniforms: {
        inputTexture: new three.Uniform(null),
        lastFrameReflectionsTexture: new three.Uniform(null),
        normalTexture: new three.Uniform(null),
        depthTexture: new three.Uniform(null),
        _projectionMatrix: new three.Uniform(new three.Matrix4()),
        _inverseProjectionMatrix: new three.Uniform(new three.Matrix4()),
        cameraMatrixWorld: new three.Uniform(new three.Matrix4()),
        cameraNear: new three.Uniform(0),
        cameraFar: new three.Uniform(0),
        rayStep: new three.Uniform(0.1),
        intensity: new three.Uniform(1),
        roughnessFadeOut: new three.Uniform(1),
        rayFadeOut: new three.Uniform(0),
        thickness: new three.Uniform(10),
        ior: new three.Uniform(1.45),
        maxDepthDifference: new three.Uniform(1),
        maxDepth: new three.Uniform(1),
        jitter: new three.Uniform(0.5),
        jitterRough: new three.Uniform(0.5),
        jitterSpread: new three.Uniform(1),
        maxRoughness: new three.Uniform(1),
        samples: new three.Uniform(0)
      },
      defines: {
        MAX_STEPS: 20,
        NUM_BINARY_SEARCH_STEPS: 5
      },
      fragmentShader: fragmentShader.replace("#include <helperFunctions>", helperFunctions),
      vertexShader,
      toneMapped: false,
      depthWrite: false,
      depthTest: false
    });
  }

}

var _defaultMaterials$1 = /*#__PURE__*/_classPrivateFieldLooseKey("defaultMaterials");

var _velocityMaterials = /*#__PURE__*/_classPrivateFieldLooseKey("velocityMaterials");

var _prevProjectionMatrix = /*#__PURE__*/_classPrivateFieldLooseKey("prevProjectionMatrix");

var _setVelocityMaterialInScene = /*#__PURE__*/_classPrivateFieldLooseKey("setVelocityMaterialInScene");

var _unsetVelocityMaterialInScene = /*#__PURE__*/_classPrivateFieldLooseKey("unsetVelocityMaterialInScene");

class VelocityPass extends postprocessing.Pass {
  constructor(scene, camera) {
    super("VelocityPass");
    Object.defineProperty(this, _unsetVelocityMaterialInScene, {
      value: _unsetVelocityMaterialInScene2
    });
    Object.defineProperty(this, _setVelocityMaterialInScene, {
      value: _setVelocityMaterialInScene2
    });
    Object.defineProperty(this, _defaultMaterials$1, {
      writable: true,
      value: {}
    });
    Object.defineProperty(this, _velocityMaterials, {
      writable: true,
      value: {}
    });
    Object.defineProperty(this, _prevProjectionMatrix, {
      writable: true,
      value: new three.Matrix4()
    });
    this._scene = scene;
    this._camera = camera;
    this.renderTarget = new three.WebGLRenderTarget(typeof window !== "undefined" ? window.innerWidth : 2000, typeof window !== "undefined" ? window.innerHeight : 1000, {
      minFilter: three.NearestFilter,
      magFilter: three.NearestFilter,
      type: three.HalfFloatType
    });
  }

  render(renderer, inputTexture) {
    _classPrivateFieldLooseBase(this, _setVelocityMaterialInScene)[_setVelocityMaterialInScene]();

    renderer.setRenderTarget(this.renderTarget);
    renderer.clear();
    renderer.render(this._scene, this._camera);

    _classPrivateFieldLooseBase(this, _unsetVelocityMaterialInScene)[_unsetVelocityMaterialInScene]();

    _classPrivateFieldLooseBase(this, _prevProjectionMatrix)[_prevProjectionMatrix].copy(this._camera.projectionMatrix);
  }

}

function _setVelocityMaterialInScene2() {
  this._scene.traverse(c => {
    if (c.material) {
      const origMat = c.material;
      _classPrivateFieldLooseBase(this, _defaultMaterials$1)[_defaultMaterials$1][c.material.uuid] = origMat;

      if (_classPrivateFieldLooseBase(this, _velocityMaterials)[_velocityMaterials][origMat.uuid] === undefined) {
        _classPrivateFieldLooseBase(this, _velocityMaterials)[_velocityMaterials][origMat.uuid] = new three.ShaderMaterial({
          uniforms: three.UniformsUtils.clone(VelocityShader.uniforms),
          vertexShader: VelocityShader.vertexShader,
          fragmentShader: VelocityShader.fragmentShader,
          side: three.FrontSide
        });

        const velocityMaterial = _classPrivateFieldLooseBase(this, _velocityMaterials)[_velocityMaterials][origMat.uuid];

        velocityMaterial._originalUuid = c.material.uuid;
        velocityMaterial.extensions.derivatives = true;
      }

      const velocityMaterial = _classPrivateFieldLooseBase(this, _velocityMaterials)[_velocityMaterials][c.material.uuid];

      velocityMaterial.uniforms.prevModelViewMatrix.value.multiplyMatrices(this._camera.matrixWorldInverse, c.matrixWorld);
      velocityMaterial.uniforms.prevProjectionMatrix.value = _classPrivateFieldLooseBase(this, _prevProjectionMatrix)[_prevProjectionMatrix];

      if (c.userData.prevModelViewMatrix) {
        velocityMaterial.uniforms.prevModelViewMatrix.value.copy(c.userData.prevModelViewMatrix);
      }

      const needsUpatedReflections = c.material.userData.needsUpatedReflections || c.material.map instanceof three.VideoTexture; // mark the material as "ANIMATED" so that, when using temporal resolve, we get updated reflections

      if (needsUpatedReflections && !Object.keys(velocityMaterial.defines).includes("NEEDS_UPDATED_REFLECTIONS")) {
        velocityMaterial.defines.NEEDS_UPDATED_REFLECTIONS = "";
        velocityMaterial.needsUpdate = true;
      } else if (!needsUpatedReflections && Object.keys(velocityMaterial.defines).includes("NEEDS_UPDATED_REFLECTIONS")) {
        delete velocityMaterial.defines.NEEDS_UPDATED_REFLECTIONS;
        velocityMaterial.needsUpdate = true;
      }

      c.material = velocityMaterial;
    }
  });
}

function _unsetVelocityMaterialInScene2() {
  this._scene.traverse(c => {
    if (c.material) {
      if (c.userData.prevModelViewMatrix === undefined) c.userData.prevModelViewMatrix = new three.Matrix4();
      c.userData.prevModelViewMatrix.multiplyMatrices(this._camera.matrixWorldInverse, c.matrixWorld);
      c.material = _classPrivateFieldLooseBase(this, _defaultMaterials$1)[_defaultMaterials$1][c.material._originalUuid];
    }
  });
}

const isWebGL2Available = () => {
  try {
    const canvas = document.createElement("canvas");
    return !!(window.WebGL2RenderingContext && canvas.getContext("webgl2"));
  } catch (e) {
    return false;
  }
};

var _defaultMaterials = /*#__PURE__*/_classPrivateFieldLooseKey("defaultMaterials");

var _normalDepthMaterials = /*#__PURE__*/_classPrivateFieldLooseKey("normalDepthMaterials");

var _USE_MRT = /*#__PURE__*/_classPrivateFieldLooseKey("USE_MRT");

var _webgl1DepthPass = /*#__PURE__*/_classPrivateFieldLooseKey("webgl1DepthPass");

var _webgl1VelocityPass = /*#__PURE__*/_classPrivateFieldLooseKey("webgl1VelocityPass");

var _keepMaterialUpdated = /*#__PURE__*/_classPrivateFieldLooseKey("keepMaterialUpdated");

var _setNormalDepthRoughnessMaterialInScene = /*#__PURE__*/_classPrivateFieldLooseKey("setNormalDepthRoughnessMaterialInScene");

var _unsetNormalDepthRoughnessMaterialInScene = /*#__PURE__*/_classPrivateFieldLooseKey("unsetNormalDepthRoughnessMaterialInScene");

class ReflectionsPass extends postprocessing.Pass {
  constructor(ssrPass, options = {}) {
    super("ReflectionsPass");
    Object.defineProperty(this, _unsetNormalDepthRoughnessMaterialInScene, {
      value: _unsetNormalDepthRoughnessMaterialInScene2
    });
    Object.defineProperty(this, _setNormalDepthRoughnessMaterialInScene, {
      value: _setNormalDepthRoughnessMaterialInScene2
    });
    Object.defineProperty(this, _keepMaterialUpdated, {
      value: _keepMaterialUpdated2
    });
    Object.defineProperty(this, _defaultMaterials, {
      writable: true,
      value: {}
    });
    Object.defineProperty(this, _normalDepthMaterials, {
      writable: true,
      value: {}
    });
    Object.defineProperty(this, _USE_MRT, {
      writable: true,
      value: false
    });
    Object.defineProperty(this, _webgl1DepthPass, {
      writable: true,
      value: null
    });
    Object.defineProperty(this, _webgl1VelocityPass, {
      writable: true,
      value: null
    });
    this.samples = 1;
    this.ssrPass = ssrPass;
    this._scene = ssrPass._scene;
    this._camera = ssrPass._camera;
    this.fullscreenMaterial = new ReflectionsMaterial();
    const width = options.width || typeof window !== "undefined" ? window.innerWidth : 2000;
    const height = options.height || typeof window !== "undefined" ? window.innerHeight : 1000;
    this.renderTarget = new three.WebGLRenderTarget(width, height, {
      minFilter: three.NearestFilter,
      magFilter: three.NearestFilter
    });
    this.renderPass = new postprocessing.RenderPass(this._scene, this._camera);
    _classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT] = options.USE_MRT && isWebGL2Available();

    if (_classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT]) {
      // buffers: normal, depth (2), roughness will be written to the alpha channel of the normal buffer
      this.gBuffersRenderTarget = new three.WebGLMultipleRenderTargets(width, height, 3, {
        minFilter: three.NearestFilter,
        magFilter: three.NearestFilter,
        type: three.HalfFloatType
      });
      this.normalTexture = this.gBuffersRenderTarget.texture[0];
      this.depthTexture = this.gBuffersRenderTarget.texture[1];
      this.velocityTexture = this.gBuffersRenderTarget.texture[2];
    } else {
      // depth pass
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass] = new postprocessing.DepthPass(this._scene, this._camera);
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.minFilter = three.NearestFilter;
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.magFilter = three.NearestFilter;
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.generateMipmaps = true;
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.texture.minFilter = three.NearestFilter;
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.texture.magFilter = three.NearestFilter;
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget.texture.generateMipmaps = true;

      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].setSize(typeof window !== "undefined" ? window.innerWidth : 2000, typeof window !== "undefined" ? window.innerHeight : 1000); // render normals (in the rgb channel) and roughness (in the alpha channel) in gBuffersRenderTarget


      this.gBuffersRenderTarget = new three.WebGLRenderTarget(width, height, {
        minFilter: three.NearestFilter,
        magFilter: three.NearestFilter
      });
      this.normalTexture = this.gBuffersRenderTarget.texture;
      this.depthTexture = _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].texture;
      _classPrivateFieldLooseBase(this, _webgl1VelocityPass)[_webgl1VelocityPass] = new VelocityPass(this._scene, this._camera);
      this.velocityTexture = _classPrivateFieldLooseBase(this, _webgl1VelocityPass)[_webgl1VelocityPass].renderTarget.texture;
    }

    this.lastFrameReflectionsTexture = new three.FramebufferTexture(width, height, three.RGBAFormat);
    this.lastFrameReflectionsTexture.minFilter = three.NearestFilter;
    this.lastFrameReflectionsTexture.magFilter = three.NearestFilter;
    this.fullscreenMaterial.uniforms.normalTexture.value = this.normalTexture;
    this.fullscreenMaterial.uniforms.depthTexture.value = this.depthTexture;
    this.fullscreenMaterial.uniforms.lastFrameReflectionsTexture.value = this.lastFrameReflectionsTexture;
    this.fullscreenMaterial.uniforms.cameraMatrixWorld.value = this._camera.matrixWorld;
    this.fullscreenMaterial.uniforms._projectionMatrix.value = this._camera.projectionMatrix;
    this.fullscreenMaterial.uniforms._inverseProjectionMatrix.value = this._camera.projectionMatrixInverse;
  }

  setSize(width, height) {
    this.renderTarget.setSize(width * this.ssrPass.resolutionScale, height * this.ssrPass.resolutionScale);
    this.gBuffersRenderTarget.setSize(width * this.ssrPass.resolutionScale, height * this.ssrPass.resolutionScale);
    this.lastFrameReflectionsTexture.dispose();
    this.lastFrameReflectionsTexture = new three.FramebufferTexture(width, height, three.RGBAFormat);
    this.lastFrameReflectionsTexture.minFilter = three.NearestFilter;
    this.lastFrameReflectionsTexture.magFilter = three.NearestFilter;
    this.fullscreenMaterial.uniforms.lastFrameReflectionsTexture.value = this.lastFrameReflectionsTexture;
    this.fullscreenMaterial.needsUpdate = true;
    this.ssrPass.composeReflectionsPass.fullscreenMaterial.uniforms.lastFrameReflectionsTexture.value = this.lastFrameReflectionsTexture;
    this.ssrPass.composeReflectionsPass.fullscreenMaterial.needsUpdate = true;

    if (!_classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT]) {
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].setSize(width, height);

      _classPrivateFieldLooseBase(this, _webgl1VelocityPass)[_webgl1VelocityPass].setSize(width, height);
    }
  }

  dispose() {
    this.renderTarget.dispose();
    this.gBuffersRenderTarget.dispose();
    this.renderPass.dispose();
    this.fullscreenMaterial.dispose();

    if (!_classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT]) {
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].dispose();

      _classPrivateFieldLooseBase(this, _webgl1VelocityPass)[_webgl1VelocityPass].dispose();
    }

    this.lastFrameReflectionsTexture.dispose();
    this.normalTexture = null;
    this.depthTexture = null;
    this.velocityTexture = null;
  }

  render(renderer, inputTexture) {
    _classPrivateFieldLooseBase(this, _setNormalDepthRoughnessMaterialInScene)[_setNormalDepthRoughnessMaterialInScene]();

    renderer.setRenderTarget(this.gBuffersRenderTarget);
    this.renderPass.render(renderer, this.gBuffersRenderTarget, this.gBuffersRenderTarget);

    _classPrivateFieldLooseBase(this, _unsetNormalDepthRoughnessMaterialInScene)[_unsetNormalDepthRoughnessMaterialInScene](); // render depth and velocity in seperate passes


    if (!_classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT]) {
      _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderPass.render(renderer, _classPrivateFieldLooseBase(this, _webgl1DepthPass)[_webgl1DepthPass].renderTarget);

      if (this.ssrPass.temporalResolve) _classPrivateFieldLooseBase(this, _webgl1VelocityPass)[_webgl1VelocityPass].render(renderer, inputTexture);
    }

    this.fullscreenMaterial.uniforms.inputTexture.value = inputTexture.texture;
    this.fullscreenMaterial.uniforms.samples.value = this.ssrPass.samples;
    this.fullscreenMaterial.uniforms.cameraNear.value = this._camera.near;
    this.fullscreenMaterial.uniforms.cameraFar.value = this._camera.far;
    renderer.setRenderTarget(this.renderTarget);
    renderer.render(this.scene, this.camera);
  }

}

function _keepMaterialUpdated2(normalDepthMaterial, origMat, prop, define) {
  if (this.ssrPass[define]) {
    if (origMat[prop] !== normalDepthMaterial[prop]) {
      normalDepthMaterial[prop] = origMat[prop];
      normalDepthMaterial.uniforms[prop].value = origMat[prop];

      if (origMat[prop]) {
        normalDepthMaterial.defines[define] = "";
      } else {
        delete normalDepthMaterial.defines[define];
      }

      normalDepthMaterial.needsUpdate = true;
    }
  } else if (normalDepthMaterial[prop] !== undefined) {
    normalDepthMaterial[prop] = undefined;
    normalDepthMaterial.uniforms[prop].value = undefined;
    delete normalDepthMaterial.defines[define];
    normalDepthMaterial.needsUpdate = true;
  }
}

function _setNormalDepthRoughnessMaterialInScene2() {
  this._scene.traverse(c => {
    if (c.material) {
      const origMat = c.material;
      _classPrivateFieldLooseBase(this, _defaultMaterials)[_defaultMaterials][c.material.uuid] = origMat;

      if (_classPrivateFieldLooseBase(this, _normalDepthMaterials)[_normalDepthMaterials][origMat.uuid] === undefined) {
        _classPrivateFieldLooseBase(this, _normalDepthMaterials)[_normalDepthMaterials][origMat.uuid] = new NormalDepthRoughnessMaterial();

        const normalDepthMaterial = _classPrivateFieldLooseBase(this, _normalDepthMaterials)[_normalDepthMaterials][origMat.uuid];

        if (_classPrivateFieldLooseBase(this, _USE_MRT)[_USE_MRT]) normalDepthMaterial.defines.USE_MRT = "";
        normalDepthMaterial._originalUuid = c.material.uuid;
        Object.defineProperty(normalDepthMaterial.uniforms.roughness, "value", {
          get() {
            return origMat.roughness || 0;
          },

          set(_) {}

        });
        normalDepthMaterial.normalScale = origMat.normalScale;
        normalDepthMaterial.uniforms.normalScale.value = origMat.normalScale;
        const map = origMat.map || origMat.normalMap || origMat.roughnessMap || origMat.metalnessMap;
        if (map) normalDepthMaterial.uniforms.uvTransform.value = map.matrix;
      }

      const normalDepthMaterial = _classPrivateFieldLooseBase(this, _normalDepthMaterials)[_normalDepthMaterials][c.material.uuid];

      _classPrivateFieldLooseBase(this, _keepMaterialUpdated)[_keepMaterialUpdated](normalDepthMaterial, origMat, "normalMap", "USE_NORMALMAP");

      _classPrivateFieldLooseBase(this, _keepMaterialUpdated)[_keepMaterialUpdated](normalDepthMaterial, origMat, "roughnessMap", "USE_ROUGHNESSMAP");

      const needsUpatedReflections = c.material.userData.needsUpatedReflections || c.material.map instanceof three.VideoTexture; // mark the material as "ANIMATED" so that, when using temporal resolve, we get updated reflections

      if (needsUpatedReflections && !Object.keys(normalDepthMaterial.defines).includes("NEEDS_UPDATED_REFLECTIONS")) {
        normalDepthMaterial.defines.NEEDS_UPDATED_REFLECTIONS = "";
        normalDepthMaterial.needsUpdate = true;
      } else if (!needsUpatedReflections && Object.keys(normalDepthMaterial.defines).includes("NEEDS_UPDATED_REFLECTIONS")) {
        delete normalDepthMaterial.defines.NEEDS_UPDATED_REFLECTIONS;
        normalDepthMaterial.needsUpdate = true;
      }

      c.material = normalDepthMaterial;
    }
  });
}

function _unsetNormalDepthRoughnessMaterialInScene2() {
  this._scene.traverse(c => {
    if (c.material?.type === "NormalDepthRoughnessMaterial") {
      c.material.uniforms.prevProjectionMatrix.value.copy(this._camera.projectionMatrix);
      c.material.uniforms.prevModelViewMatrix.value.copy(c.modelViewMatrix);
      c.material.uniforms.prevModelViewMatrix.value.multiplyMatrices(this._camera.matrixWorldInverse, c.matrixWorld);
      c.material = _classPrivateFieldLooseBase(this, _defaultMaterials)[_defaultMaterials][c.material._originalUuid];
    }
  });
}

const finalFragmentShader = fragmentShader$1.replace("#include <helperFunctions>", helperFunctions).replace("#include <bilateralBlur>", bilateralBlur);
const zeroVec2 = new three.Vector2();
const defaultSSROptions = {
  temporalResolve: true,
  temporalResolveMix: 0.9,
  temporalResolveCorrectionMix: 0.3875,
  maxSamples: 0,
  resolutionScale: 1,
  width: typeof window !== "undefined" ? window.innerWidth : 2000,
  height: typeof window !== "undefined" ? window.innerHeight : 1000,
  ENABLE_BLUR: true,
  blurMix: 0.5,
  blurKernelSize: 8,
  blurSharpness: 0.5,
  rayStep: 0.1,
  intensity: 1,
  maxRoughness: 0.1,
  ENABLE_JITTERING: false,
  jitter: 0.1,
  jitterSpread: 0.1,
  jitterRough: 0.1,
  roughnessFadeOut: 1,
  rayFadeOut: 0,
  MAX_STEPS: 20,
  NUM_BINARY_SEARCH_STEPS: 5,
  maxDepthDifference: 3,
  maxDepth: 1,
  thickness: 10,
  ior: 1.45,
  STRETCH_MISSED_RAYS: true,
  USE_MRT: true,
  USE_NORMALMAP: true,
  USE_ROUGHNESSMAP: true
}; // all the properties for which we don't have to resample

const noResetSamplesProperties = ["ENABLE_BLUR", "blurSharpness", "blurKernelSize", "blurMix"];

var _lastSize = /*#__PURE__*/_classPrivateFieldLooseKey("lastSize");

var _lastCameraTransform = /*#__PURE__*/_classPrivateFieldLooseKey("lastCameraTransform");

var _makeOptionsReactive = /*#__PURE__*/_classPrivateFieldLooseKey("makeOptionsReactive");

class SSREffect extends postprocessing.Effect {
  constructor(scene, camera, _options = defaultSSROptions) {
    super("SSRPass", finalFragmentShader, {
      type: "FinalSSRMaterial",
      uniforms: new Map([["inputTexture", new three.Uniform(null)], ["reflectionsTexture", new three.Uniform(null)], ["depthTexture", new three.Uniform(null)], ["samples", new three.Uniform(0)], ["blurMix", new three.Uniform(0)], ["g_Sharpness", new three.Uniform(0)], ["g_InvResolutionDirection", new three.Uniform(new three.Vector2())], ["kernelRadius", new three.Uniform(0)]]),
      defines: new Map([["RENDER_MODE", "0"]])
    });
    Object.defineProperty(this, _makeOptionsReactive, {
      value: _makeOptionsReactive2
    });
    Object.defineProperty(this, _lastSize, {
      writable: true,
      value: void 0
    });
    this.samples = 0;
    Object.defineProperty(this, _lastCameraTransform, {
      writable: true,
      value: {
        position: new three.Vector3(),
        quaternion: new three.Quaternion()
      }
    });
    this._scene = scene;
    this._camera = camera;
    _options = _extends({}, defaultSSROptions, _options);
    _classPrivateFieldLooseBase(this, _lastSize)[_lastSize] = {
      width: _options.width,
      height: _options.height,
      resolutionScale: _options.resolutionScale
    };

    _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].position.copy(camera.position);

    _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].quaternion.copy(camera.quaternion); // returns just the calculates reflections


    this.reflectionsPass = new ReflectionsPass(this, _options);
    this.composeReflectionsPass = new ComposeReflectionsPass(this);
    this.composeReflectionsPass.fullscreenMaterial.uniforms.inputTexture.value = this.reflectionsPass.renderTarget.texture;
    this.composeReflectionsPass.fullscreenMaterial.uniforms.lastFrameReflectionsTexture.value = this.reflectionsPass.lastFrameReflectionsTexture;
    this.composeReflectionsPass.fullscreenMaterial.uniforms.velocityTexture.value = this.reflectionsPass.velocityTexture;
    this.uniforms.get("reflectionsTexture").value = this.composeReflectionsPass.renderTarget.texture;
    this.uniforms.get("depthTexture").value = this.reflectionsPass.depthTexture;
    this.setSize(_options.width, _options.height);

    _classPrivateFieldLooseBase(this, _makeOptionsReactive)[_makeOptionsReactive](_options);
  }

  setSize(width, height) {
    if (width === _classPrivateFieldLooseBase(this, _lastSize)[_lastSize].width && height === _classPrivateFieldLooseBase(this, _lastSize)[_lastSize].height && this.resolutionScale === _classPrivateFieldLooseBase(this, _lastSize)[_lastSize].resolutionScale) return;
    this.composeReflectionsPass.setSize(width, height);
    this.reflectionsPass.setSize(width, height);
    _classPrivateFieldLooseBase(this, _lastSize)[_lastSize] = {
      width,
      height,
      resolutionScale: this.resolutionScale
    };
  }

  checkNeedsResample() {
    const moveDist = _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].position.distanceToSquared(this._camera.position);

    const rotateDist = 8 * (1 - _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].quaternion.dot(this._camera.quaternion));

    if (moveDist > 0.000001 || rotateDist > 0.000001) {
      this.samples = 1;

      _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].position.copy(this._camera.position);

      _classPrivateFieldLooseBase(this, _lastCameraTransform)[_lastCameraTransform].quaternion.copy(this._camera.quaternion);
    }
  }

  dispose() {
    super.dispose();
    this.reflectionsPass.dispose();
    this.composeReflectionsPass.dispose();
  }

  update(renderer, inputTexture) {
    this.samples++;
    this.checkNeedsResample(); // update uniforms

    this.uniforms.get("samples").value = this.samples; // render reflections of current frame

    this.reflectionsPass.render(renderer, inputTexture); // compose reflection of last and current frame into one reflection

    this.composeReflectionsPass.render(renderer);
    renderer.setRenderTarget(this.composeReflectionsPass.renderTarget);
    renderer.copyFramebufferToTexture(zeroVec2, this.reflectionsPass.lastFrameReflectionsTexture);
  }

}

function _makeOptionsReactive2(options) {
  // this can't be toggled during run-time
  if (options.ENABLE_BLUR) {
    this.defines.set("ENABLE_BLUR", "");
    this.reflectionsPass.fullscreenMaterial.defines.ENABLE_BLUR = "";
  }

  const dpr = window.devicePixelRatio;
  let needsUpdate = false;
  const reflectionPassFullscreenMaterialUniforms = this.reflectionsPass.fullscreenMaterial.uniforms;
  const reflectionPassFullscreenMaterialUniformsKeys = Object.keys(reflectionPassFullscreenMaterialUniforms);

  for (const key of Object.keys(options)) {
    Object.defineProperty(this, key, {
      get() {
        return options[key];
      },

      set(value) {
        if (options[key] === value && needsUpdate) return;
        options[key] = value;
        if (!noResetSamplesProperties.includes(key)) this.samples = 1;

        switch (key) {
          case "resolutionScale":
            this.setSize(options.width, options.height);
            break;

          case "width":
            if (value === undefined) return;
            this.setSize(value * dpr, options.height);
            this.uniforms.get("g_InvResolutionDirection").value.set(1 / (value * dpr), 1 / options.height);
            break;

          case "height":
            if (value === undefined) return;
            this.setSize(options.width, value * dpr);
            this.uniforms.get("g_InvResolutionDirection").value.set(1 / options.width, 1 / (value * dpr));
            break;

          case "maxSamples":
            this.composeReflectionsPass.fullscreenMaterial.uniforms.maxSamples.value = this.maxSamples;
            break;

          case "blurMix":
            this.uniforms.get("blurMix").value = value;
            break;

          case "blurSharpness":
            this.uniforms.get("g_Sharpness").value = value;
            break;

          case "blurKernelSize":
            this.uniforms.get("kernelRadius").value = value;
            break;
          // defines

          case "MAX_STEPS":
            this.reflectionsPass.fullscreenMaterial.defines.MAX_STEPS = parseInt(value);
            this.reflectionsPass.fullscreenMaterial.needsUpdate = needsUpdate;
            break;

          case "NUM_BINARY_SEARCH_STEPS":
            this.reflectionsPass.fullscreenMaterial.defines.NUM_BINARY_SEARCH_STEPS = parseInt(value);
            this.reflectionsPass.fullscreenMaterial.needsUpdate = needsUpdate;
            break;

          case "ENABLE_JITTERING":
            if (value) {
              this.reflectionsPass.fullscreenMaterial.defines.ENABLE_JITTERING = "";
            } else {
              delete this.reflectionsPass.fullscreenMaterial.defines.ENABLE_JITTERING;
            }

            this.reflectionsPass.fullscreenMaterial.needsUpdate = needsUpdate;
            break;

          case "STRETCH_MISSED_RAYS":
            if (value) {
              this.reflectionsPass.fullscreenMaterial.defines.STRETCH_MISSED_RAYS = "";
            } else {
              delete this.reflectionsPass.fullscreenMaterial.defines.STRETCH_MISSED_RAYS;
            }

            this.reflectionsPass.fullscreenMaterial.needsUpdate = needsUpdate;
            break;

          case "USE_NORMALMAP":
            break;

          case "USE_ROUGHNESSMAP":
            break;

          case "temporalResolve":
            if (value) {
              this.composeReflectionsPass.fullscreenMaterial.defines.TEMPORAL_RESOLVE = "";
            } else {
              delete this.composeReflectionsPass.fullscreenMaterial.defines.TEMPORAL_RESOLVE;
            }

            this.composeReflectionsPass.fullscreenMaterial.needsUpdate = true;
            break;

          case "temporalResolveMix":
            this.composeReflectionsPass.fullscreenMaterial.uniforms.temporalResolveMix.value = value;
            break;

          case "temporalResolveCorrectionMix":
            this.composeReflectionsPass.fullscreenMaterial.uniforms.temporalResolveCorrectionMix.value = value;
            break;
          // must be a uniform

          default:
            if (reflectionPassFullscreenMaterialUniformsKeys.includes(key)) {
              reflectionPassFullscreenMaterialUniforms[key].value = value;
            }

        }
      }

    }); // apply all uniforms and defines

    this[key] = options[key];
  }

  needsUpdate = true;
}

exports.SSREffect = SSREffect;
exports.defaultSSROptions = defaultSSROptions;
