// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"node_modules/object-assign/index.js":[function(require,module,exports) {
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
'use strict';
/* eslint-disable no-unused-vars */

var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
  if (val === null || val === undefined) {
    throw new TypeError('Object.assign cannot be called with null or undefined');
  }

  return Object(val);
}

function shouldUseNative() {
  try {
    if (!Object.assign) {
      return false;
    } // Detect buggy property enumeration order in older V8 versions.
    // https://bugs.chromium.org/p/v8/issues/detail?id=4118


    var test1 = new String('abc'); // eslint-disable-line no-new-wrappers

    test1[5] = 'de';

    if (Object.getOwnPropertyNames(test1)[0] === '5') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test2 = {};

    for (var i = 0; i < 10; i++) {
      test2['_' + String.fromCharCode(i)] = i;
    }

    var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
      return test2[n];
    });

    if (order2.join('') !== '0123456789') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test3 = {};
    'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
      test3[letter] = letter;
    });

    if (Object.keys(Object.assign({}, test3)).join('') !== 'abcdefghijklmnopqrst') {
      return false;
    }

    return true;
  } catch (err) {
    // We don't expect any of the above to throw, but better to be safe.
    return false;
  }
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
  var from;
  var to = toObject(target);
  var symbols;

  for (var s = 1; s < arguments.length; s++) {
    from = Object(arguments[s]);

    for (var key in from) {
      if (hasOwnProperty.call(from, key)) {
        to[key] = from[key];
      }
    }

    if (getOwnPropertySymbols) {
      symbols = getOwnPropertySymbols(from);

      for (var i = 0; i < symbols.length; i++) {
        if (propIsEnumerable.call(from, symbols[i])) {
          to[symbols[i]] = from[symbols[i]];
        }
      }
    }
  }

  return to;
};
},{}],"node_modules/prop-types/lib/ReactPropTypesSecret.js":[function(require,module,exports) {
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;

},{}],"node_modules/prop-types/checkPropTypes.js":[function(require,module,exports) {
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

var printWarning = function () {};

if ("development" !== 'production') {
  var ReactPropTypesSecret = require('./lib/ReactPropTypesSecret');

  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function (text) {
    var message = 'Warning: ' + text;

    if (typeof console !== 'undefined') {
      console.error(message);
    }

    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}
/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */


function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if ("development" !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error; // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.

        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.');
            err.name = 'Invariant Violation';
            throw err;
          }

          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
        } catch (ex) {
          error = ex;
        }

        if (error && !(error instanceof Error)) {
          printWarning((componentName || 'React class') + ': type specification of ' + location + ' `' + typeSpecName + '` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a ' + typeof error + '. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).');
        }

        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;
          var stack = getStack ? getStack() : '';
          printWarning('Failed ' + location + ' type: ' + error.message + (stack != null ? stack : ''));
        }
      }
    }
  }
}
/**
 * Resets warning cache when testing.
 *
 * @private
 */


checkPropTypes.resetWarningCache = function () {
  if ("development" !== 'production') {
    loggedTypeFailures = {};
  }
};

module.exports = checkPropTypes;
},{"./lib/ReactPropTypesSecret":"node_modules/prop-types/lib/ReactPropTypesSecret.js"}],"node_modules/react/cjs/react.development.js":[function(require,module,exports) {
/** @license React v16.12.0
 * react.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

if ("development" !== "production") {
  (function () {
    'use strict';

    var _assign = require('object-assign');

    var checkPropTypes = require('prop-types/checkPropTypes'); // TODO: this is special because it gets imported during build.


    var ReactVersion = '16.12.0'; // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
    // nor polyfill, then a plain number is used for performance.

    var hasSymbol = typeof Symbol === 'function' && Symbol.for;
    var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
    var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
    var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
    var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
    var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
    var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
    var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
    // (unstable) APIs that have been removed. Can we remove the symbols?

    var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
    var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
    var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
    var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
    var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
    var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
    var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
    var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
    var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;
    var MAYBE_ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator';

    function getIteratorFn(maybeIterable) {
      if (maybeIterable === null || typeof maybeIterable !== 'object') {
        return null;
      }

      var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];

      if (typeof maybeIterator === 'function') {
        return maybeIterator;
      }

      return null;
    } // Do not require this module directly! Use normal `invariant` calls with
    // template literal strings. The messages will be replaced with error codes
    // during build.

    /**
     * Use invariant() to assert state which your program assumes to be true.
     *
     * Provide sprintf-style format (only %s is supported) and arguments
     * to provide information about what broke and what you were
     * expecting.
     *
     * The invariant message will be stripped in production, but the invariant
     * will remain to ensure logic does not differ in production.
     */

    /**
     * Forked from fbjs/warning:
     * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
     *
     * Only change is we use console.warn instead of console.error,
     * and do nothing when 'console' is not supported.
     * This really simplifies the code.
     * ---
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */


    var lowPriorityWarningWithoutStack = function () {};

    {
      var printWarning = function (format) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        var argIndex = 0;
        var message = 'Warning: ' + format.replace(/%s/g, function () {
          return args[argIndex++];
        });

        if (typeof console !== 'undefined') {
          console.warn(message);
        }

        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch (x) {}
      };

      lowPriorityWarningWithoutStack = function (condition, format) {
        if (format === undefined) {
          throw new Error('`lowPriorityWarningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
        }

        if (!condition) {
          for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
            args[_key2 - 2] = arguments[_key2];
          }

          printWarning.apply(void 0, [format].concat(args));
        }
      };
    }
    var lowPriorityWarningWithoutStack$1 = lowPriorityWarningWithoutStack;
    /**
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */

    var warningWithoutStack = function () {};

    {
      warningWithoutStack = function (condition, format) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        if (format === undefined) {
          throw new Error('`warningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
        }

        if (args.length > 8) {
          // Check before the condition to catch violations early.
          throw new Error('warningWithoutStack() currently supports at most 8 arguments.');
        }

        if (condition) {
          return;
        }

        if (typeof console !== 'undefined') {
          var argsWithFormat = args.map(function (item) {
            return '' + item;
          });
          argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it
          // breaks IE9: https://github.com/facebook/react/issues/13610

          Function.prototype.apply.call(console.error, console, argsWithFormat);
        }

        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          var argIndex = 0;
          var message = 'Warning: ' + format.replace(/%s/g, function () {
            return args[argIndex++];
          });
          throw new Error(message);
        } catch (x) {}
      };
    }
    var warningWithoutStack$1 = warningWithoutStack;
    var didWarnStateUpdateForUnmountedComponent = {};

    function warnNoop(publicInstance, callerName) {
      {
        var _constructor = publicInstance.constructor;
        var componentName = _constructor && (_constructor.displayName || _constructor.name) || 'ReactClass';
        var warningKey = componentName + "." + callerName;

        if (didWarnStateUpdateForUnmountedComponent[warningKey]) {
          return;
        }

        warningWithoutStack$1(false, "Can't call %s on a component that is not yet mounted. " + 'This is a no-op, but it might indicate a bug in your application. ' + 'Instead, assign to `this.state` directly or define a `state = {};` ' + 'class property with the desired state in the %s component.', callerName, componentName);
        didWarnStateUpdateForUnmountedComponent[warningKey] = true;
      }
    }
    /**
     * This is the abstract API for an update queue.
     */


    var ReactNoopUpdateQueue = {
      /**
       * Checks whether or not this composite component is mounted.
       * @param {ReactClass} publicInstance The instance we want to test.
       * @return {boolean} True if mounted, false otherwise.
       * @protected
       * @final
       */
      isMounted: function (publicInstance) {
        return false;
      },

      /**
       * Forces an update. This should only be invoked when it is known with
       * certainty that we are **not** in a DOM transaction.
       *
       * You may want to call this when you know that some deeper aspect of the
       * component's state has changed but `setState` was not called.
       *
       * This will not invoke `shouldComponentUpdate`, but it will invoke
       * `componentWillUpdate` and `componentDidUpdate`.
       *
       * @param {ReactClass} publicInstance The instance that should rerender.
       * @param {?function} callback Called after component is updated.
       * @param {?string} callerName name of the calling function in the public API.
       * @internal
       */
      enqueueForceUpdate: function (publicInstance, callback, callerName) {
        warnNoop(publicInstance, 'forceUpdate');
      },

      /**
       * Replaces all of the state. Always use this or `setState` to mutate state.
       * You should treat `this.state` as immutable.
       *
       * There is no guarantee that `this.state` will be immediately updated, so
       * accessing `this.state` after calling this method may return the old value.
       *
       * @param {ReactClass} publicInstance The instance that should rerender.
       * @param {object} completeState Next state.
       * @param {?function} callback Called after component is updated.
       * @param {?string} callerName name of the calling function in the public API.
       * @internal
       */
      enqueueReplaceState: function (publicInstance, completeState, callback, callerName) {
        warnNoop(publicInstance, 'replaceState');
      },

      /**
       * Sets a subset of the state. This only exists because _pendingState is
       * internal. This provides a merging strategy that is not available to deep
       * properties which is confusing. TODO: Expose pendingState or don't use it
       * during the merge.
       *
       * @param {ReactClass} publicInstance The instance that should rerender.
       * @param {object} partialState Next partial state to be merged with state.
       * @param {?function} callback Called after component is updated.
       * @param {?string} Name of the calling function in the public API.
       * @internal
       */
      enqueueSetState: function (publicInstance, partialState, callback, callerName) {
        warnNoop(publicInstance, 'setState');
      }
    };
    var emptyObject = {};
    {
      Object.freeze(emptyObject);
    }
    /**
     * Base class helpers for the updating state of a component.
     */

    function Component(props, context, updater) {
      this.props = props;
      this.context = context; // If a component has string refs, we will assign a different object later.

      this.refs = emptyObject; // We initialize the default updater but the real one gets injected by the
      // renderer.

      this.updater = updater || ReactNoopUpdateQueue;
    }

    Component.prototype.isReactComponent = {};
    /**
     * Sets a subset of the state. Always use this to mutate
     * state. You should treat `this.state` as immutable.
     *
     * There is no guarantee that `this.state` will be immediately updated, so
     * accessing `this.state` after calling this method may return the old value.
     *
     * There is no guarantee that calls to `setState` will run synchronously,
     * as they may eventually be batched together.  You can provide an optional
     * callback that will be executed when the call to setState is actually
     * completed.
     *
     * When a function is provided to setState, it will be called at some point in
     * the future (not synchronously). It will be called with the up to date
     * component arguments (state, props, context). These values can be different
     * from this.* because your function may be called after receiveProps but before
     * shouldComponentUpdate, and this new state, props, and context will not yet be
     * assigned to this.
     *
     * @param {object|function} partialState Next partial state or function to
     *        produce next partial state to be merged with current state.
     * @param {?function} callback Called after state is updated.
     * @final
     * @protected
     */

    Component.prototype.setState = function (partialState, callback) {
      if (!(typeof partialState === 'object' || typeof partialState === 'function' || partialState == null)) {
        {
          throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");
        }
      }

      this.updater.enqueueSetState(this, partialState, callback, 'setState');
    };
    /**
     * Forces an update. This should only be invoked when it is known with
     * certainty that we are **not** in a DOM transaction.
     *
     * You may want to call this when you know that some deeper aspect of the
     * component's state has changed but `setState` was not called.
     *
     * This will not invoke `shouldComponentUpdate`, but it will invoke
     * `componentWillUpdate` and `componentDidUpdate`.
     *
     * @param {?function} callback Called after update is complete.
     * @final
     * @protected
     */


    Component.prototype.forceUpdate = function (callback) {
      this.updater.enqueueForceUpdate(this, callback, 'forceUpdate');
    };
    /**
     * Deprecated APIs. These APIs used to exist on classic React classes but since
     * we would like to deprecate them, we're not going to move them over to this
     * modern base class. Instead, we define a getter that warns if it's accessed.
     */


    {
      var deprecatedAPIs = {
        isMounted: ['isMounted', 'Instead, make sure to clean up subscriptions and pending requests in ' + 'componentWillUnmount to prevent memory leaks.'],
        replaceState: ['replaceState', 'Refactor your code to use setState instead (see ' + 'https://github.com/facebook/react/issues/3236).']
      };

      var defineDeprecationWarning = function (methodName, info) {
        Object.defineProperty(Component.prototype, methodName, {
          get: function () {
            lowPriorityWarningWithoutStack$1(false, '%s(...) is deprecated in plain JavaScript React classes. %s', info[0], info[1]);
            return undefined;
          }
        });
      };

      for (var fnName in deprecatedAPIs) {
        if (deprecatedAPIs.hasOwnProperty(fnName)) {
          defineDeprecationWarning(fnName, deprecatedAPIs[fnName]);
        }
      }
    }

    function ComponentDummy() {}

    ComponentDummy.prototype = Component.prototype;
    /**
     * Convenience component with default shallow equality check for sCU.
     */

    function PureComponent(props, context, updater) {
      this.props = props;
      this.context = context; // If a component has string refs, we will assign a different object later.

      this.refs = emptyObject;
      this.updater = updater || ReactNoopUpdateQueue;
    }

    var pureComponentPrototype = PureComponent.prototype = new ComponentDummy();
    pureComponentPrototype.constructor = PureComponent; // Avoid an extra prototype jump for these methods.

    _assign(pureComponentPrototype, Component.prototype);

    pureComponentPrototype.isPureReactComponent = true; // an immutable object with a single mutable value

    function createRef() {
      var refObject = {
        current: null
      };
      {
        Object.seal(refObject);
      }
      return refObject;
    }
    /**
     * Keeps track of the current dispatcher.
     */


    var ReactCurrentDispatcher = {
      /**
       * @internal
       * @type {ReactComponent}
       */
      current: null
    };
    /**
     * Keeps track of the current batch's configuration such as how long an update
     * should suspend for if it needs to.
     */

    var ReactCurrentBatchConfig = {
      suspense: null
    };
    /**
     * Keeps track of the current owner.
     *
     * The current owner is the component who should own any components that are
     * currently being constructed.
     */

    var ReactCurrentOwner = {
      /**
       * @internal
       * @type {ReactComponent}
       */
      current: null
    };
    var BEFORE_SLASH_RE = /^(.*)[\\\/]/;

    var describeComponentFrame = function (name, source, ownerName) {
      var sourceInfo = '';

      if (source) {
        var path = source.fileName;
        var fileName = path.replace(BEFORE_SLASH_RE, '');
        {
          // In DEV, include code for a common special case:
          // prefer "folder/index.js" instead of just "index.js".
          if (/^index\./.test(fileName)) {
            var match = path.match(BEFORE_SLASH_RE);

            if (match) {
              var pathBeforeSlash = match[1];

              if (pathBeforeSlash) {
                var folderName = pathBeforeSlash.replace(BEFORE_SLASH_RE, '');
                fileName = folderName + '/' + fileName;
              }
            }
          }
        }
        sourceInfo = ' (at ' + fileName + ':' + source.lineNumber + ')';
      } else if (ownerName) {
        sourceInfo = ' (created by ' + ownerName + ')';
      }

      return '\n    in ' + (name || 'Unknown') + sourceInfo;
    };

    var Resolved = 1;

    function refineResolvedLazyComponent(lazyComponent) {
      return lazyComponent._status === Resolved ? lazyComponent._result : null;
    }

    function getWrappedName(outerType, innerType, wrapperName) {
      var functionName = innerType.displayName || innerType.name || '';
      return outerType.displayName || (functionName !== '' ? wrapperName + "(" + functionName + ")" : wrapperName);
    }

    function getComponentName(type) {
      if (type == null) {
        // Host root, text node or just invalid type.
        return null;
      }

      {
        if (typeof type.tag === 'number') {
          warningWithoutStack$1(false, 'Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');
        }
      }

      if (typeof type === 'function') {
        return type.displayName || type.name || null;
      }

      if (typeof type === 'string') {
        return type;
      }

      switch (type) {
        case REACT_FRAGMENT_TYPE:
          return 'Fragment';

        case REACT_PORTAL_TYPE:
          return 'Portal';

        case REACT_PROFILER_TYPE:
          return "Profiler";

        case REACT_STRICT_MODE_TYPE:
          return 'StrictMode';

        case REACT_SUSPENSE_TYPE:
          return 'Suspense';

        case REACT_SUSPENSE_LIST_TYPE:
          return 'SuspenseList';
      }

      if (typeof type === 'object') {
        switch (type.$$typeof) {
          case REACT_CONTEXT_TYPE:
            return 'Context.Consumer';

          case REACT_PROVIDER_TYPE:
            return 'Context.Provider';

          case REACT_FORWARD_REF_TYPE:
            return getWrappedName(type, type.render, 'ForwardRef');

          case REACT_MEMO_TYPE:
            return getComponentName(type.type);

          case REACT_LAZY_TYPE:
            {
              var thenable = type;
              var resolvedThenable = refineResolvedLazyComponent(thenable);

              if (resolvedThenable) {
                return getComponentName(resolvedThenable);
              }

              break;
            }
        }
      }

      return null;
    }

    var ReactDebugCurrentFrame = {};
    var currentlyValidatingElement = null;

    function setCurrentlyValidatingElement(element) {
      {
        currentlyValidatingElement = element;
      }
    }

    {
      // Stack implementation injected by the current renderer.
      ReactDebugCurrentFrame.getCurrentStack = null;

      ReactDebugCurrentFrame.getStackAddendum = function () {
        var stack = ''; // Add an extra top frame while an element is being validated

        if (currentlyValidatingElement) {
          var name = getComponentName(currentlyValidatingElement.type);
          var owner = currentlyValidatingElement._owner;
          stack += describeComponentFrame(name, currentlyValidatingElement._source, owner && getComponentName(owner.type));
        } // Delegate to the injected renderer-specific implementation


        var impl = ReactDebugCurrentFrame.getCurrentStack;

        if (impl) {
          stack += impl() || '';
        }

        return stack;
      };
    }
    /**
     * Used by act() to track whether you're inside an act() scope.
     */

    var IsSomeRendererActing = {
      current: false
    };
    var ReactSharedInternals = {
      ReactCurrentDispatcher: ReactCurrentDispatcher,
      ReactCurrentBatchConfig: ReactCurrentBatchConfig,
      ReactCurrentOwner: ReactCurrentOwner,
      IsSomeRendererActing: IsSomeRendererActing,
      // Used by renderers to avoid bundling object-assign twice in UMD bundles:
      assign: _assign
    };
    {
      _assign(ReactSharedInternals, {
        // These should not be included in production.
        ReactDebugCurrentFrame: ReactDebugCurrentFrame,
        // Shim for React DOM 16.0.0 which still destructured (but not used) this.
        // TODO: remove in React 17.0.
        ReactComponentTreeHook: {}
      });
    }
    /**
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */

    var warning = warningWithoutStack$1;
    {
      warning = function (condition, format) {
        if (condition) {
          return;
        }

        var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
        var stack = ReactDebugCurrentFrame.getStackAddendum(); // eslint-disable-next-line react-internal/warning-and-invariant-args

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        warningWithoutStack$1.apply(void 0, [false, format + '%s'].concat(args, [stack]));
      };
    }
    var warning$1 = warning;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var RESERVED_PROPS = {
      key: true,
      ref: true,
      __self: true,
      __source: true
    };
    var specialPropKeyWarningShown;
    var specialPropRefWarningShown;

    function hasValidRef(config) {
      {
        if (hasOwnProperty.call(config, 'ref')) {
          var getter = Object.getOwnPropertyDescriptor(config, 'ref').get;

          if (getter && getter.isReactWarning) {
            return false;
          }
        }
      }
      return config.ref !== undefined;
    }

    function hasValidKey(config) {
      {
        if (hasOwnProperty.call(config, 'key')) {
          var getter = Object.getOwnPropertyDescriptor(config, 'key').get;

          if (getter && getter.isReactWarning) {
            return false;
          }
        }
      }
      return config.key !== undefined;
    }

    function defineKeyPropWarningGetter(props, displayName) {
      var warnAboutAccessingKey = function () {
        if (!specialPropKeyWarningShown) {
          specialPropKeyWarningShown = true;
          warningWithoutStack$1(false, '%s: `key` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://fb.me/react-special-props)', displayName);
        }
      };

      warnAboutAccessingKey.isReactWarning = true;
      Object.defineProperty(props, 'key', {
        get: warnAboutAccessingKey,
        configurable: true
      });
    }

    function defineRefPropWarningGetter(props, displayName) {
      var warnAboutAccessingRef = function () {
        if (!specialPropRefWarningShown) {
          specialPropRefWarningShown = true;
          warningWithoutStack$1(false, '%s: `ref` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://fb.me/react-special-props)', displayName);
        }
      };

      warnAboutAccessingRef.isReactWarning = true;
      Object.defineProperty(props, 'ref', {
        get: warnAboutAccessingRef,
        configurable: true
      });
    }
    /**
     * Factory method to create a new React element. This no longer adheres to
     * the class pattern, so do not use new to call it. Also, instanceof check
     * will not work. Instead test $$typeof field against Symbol.for('react.element') to check
     * if something is a React Element.
     *
     * @param {*} type
     * @param {*} props
     * @param {*} key
     * @param {string|object} ref
     * @param {*} owner
     * @param {*} self A *temporary* helper to detect places where `this` is
     * different from the `owner` when React.createElement is called, so that we
     * can warn. We want to get rid of owner and replace string `ref`s with arrow
     * functions, and as long as `this` and owner are the same, there will be no
     * change in behavior.
     * @param {*} source An annotation object (added by a transpiler or otherwise)
     * indicating filename, line number, and/or other information.
     * @internal
     */


    var ReactElement = function (type, key, ref, self, source, owner, props) {
      var element = {
        // This tag allows us to uniquely identify this as a React Element
        $$typeof: REACT_ELEMENT_TYPE,
        // Built-in properties that belong on the element
        type: type,
        key: key,
        ref: ref,
        props: props,
        // Record the component responsible for creating this element.
        _owner: owner
      };
      {
        // The validation flag is currently mutative. We put it on
        // an external backing store so that we can freeze the whole object.
        // This can be replaced with a WeakMap once they are implemented in
        // commonly used development environments.
        element._store = {}; // To make comparing ReactElements easier for testing purposes, we make
        // the validation flag non-enumerable (where possible, which should
        // include every environment we run tests in), so the test framework
        // ignores it.

        Object.defineProperty(element._store, 'validated', {
          configurable: false,
          enumerable: false,
          writable: true,
          value: false
        }); // self and source are DEV only properties.

        Object.defineProperty(element, '_self', {
          configurable: false,
          enumerable: false,
          writable: false,
          value: self
        }); // Two elements created in two different places should be considered
        // equal for testing purposes and therefore we hide it from enumeration.

        Object.defineProperty(element, '_source', {
          configurable: false,
          enumerable: false,
          writable: false,
          value: source
        });

        if (Object.freeze) {
          Object.freeze(element.props);
          Object.freeze(element);
        }
      }
      return element;
    };
    /**
     * https://github.com/reactjs/rfcs/pull/107
     * @param {*} type
     * @param {object} props
     * @param {string} key
     */

    /**
     * https://github.com/reactjs/rfcs/pull/107
     * @param {*} type
     * @param {object} props
     * @param {string} key
     */


    function jsxDEV(type, config, maybeKey, source, self) {
      var propName; // Reserved names are extracted

      var props = {};
      var key = null;
      var ref = null; // Currently, key can be spread in as a prop. This causes a potential
      // issue if key is also explicitly declared (ie. <div {...props} key="Hi" />
      // or <div key="Hi" {...props} /> ). We want to deprecate key spread,
      // but as an intermediary step, we will use jsxDEV for everything except
      // <div {...props} key="Hi" />, because we aren't currently able to tell if
      // key is explicitly declared to be undefined or not.

      if (maybeKey !== undefined) {
        key = '' + maybeKey;
      }

      if (hasValidKey(config)) {
        key = '' + config.key;
      }

      if (hasValidRef(config)) {
        ref = config.ref;
      } // Remaining properties are added to a new props object


      for (propName in config) {
        if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
          props[propName] = config[propName];
        }
      } // Resolve default props


      if (type && type.defaultProps) {
        var defaultProps = type.defaultProps;

        for (propName in defaultProps) {
          if (props[propName] === undefined) {
            props[propName] = defaultProps[propName];
          }
        }
      }

      if (key || ref) {
        var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;

        if (key) {
          defineKeyPropWarningGetter(props, displayName);
        }

        if (ref) {
          defineRefPropWarningGetter(props, displayName);
        }
      }

      return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
    }
    /**
     * Create and return a new ReactElement of the given type.
     * See https://reactjs.org/docs/react-api.html#createelement
     */


    function createElement(type, config, children) {
      var propName; // Reserved names are extracted

      var props = {};
      var key = null;
      var ref = null;
      var self = null;
      var source = null;

      if (config != null) {
        if (hasValidRef(config)) {
          ref = config.ref;
        }

        if (hasValidKey(config)) {
          key = '' + config.key;
        }

        self = config.__self === undefined ? null : config.__self;
        source = config.__source === undefined ? null : config.__source; // Remaining properties are added to a new props object

        for (propName in config) {
          if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
            props[propName] = config[propName];
          }
        }
      } // Children can be more than one argument, and those are transferred onto
      // the newly allocated props object.


      var childrenLength = arguments.length - 2;

      if (childrenLength === 1) {
        props.children = children;
      } else if (childrenLength > 1) {
        var childArray = Array(childrenLength);

        for (var i = 0; i < childrenLength; i++) {
          childArray[i] = arguments[i + 2];
        }

        {
          if (Object.freeze) {
            Object.freeze(childArray);
          }
        }
        props.children = childArray;
      } // Resolve default props


      if (type && type.defaultProps) {
        var defaultProps = type.defaultProps;

        for (propName in defaultProps) {
          if (props[propName] === undefined) {
            props[propName] = defaultProps[propName];
          }
        }
      }

      {
        if (key || ref) {
          var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;

          if (key) {
            defineKeyPropWarningGetter(props, displayName);
          }

          if (ref) {
            defineRefPropWarningGetter(props, displayName);
          }
        }
      }
      return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
    }
    /**
     * Return a function that produces ReactElements of a given type.
     * See https://reactjs.org/docs/react-api.html#createfactory
     */


    function cloneAndReplaceKey(oldElement, newKey) {
      var newElement = ReactElement(oldElement.type, newKey, oldElement.ref, oldElement._self, oldElement._source, oldElement._owner, oldElement.props);
      return newElement;
    }
    /**
     * Clone and return a new ReactElement using element as the starting point.
     * See https://reactjs.org/docs/react-api.html#cloneelement
     */


    function cloneElement(element, config, children) {
      if (!!(element === null || element === undefined)) {
        {
          throw Error("React.cloneElement(...): The argument must be a React element, but you passed " + element + ".");
        }
      }

      var propName; // Original props are copied

      var props = _assign({}, element.props); // Reserved names are extracted


      var key = element.key;
      var ref = element.ref; // Self is preserved since the owner is preserved.

      var self = element._self; // Source is preserved since cloneElement is unlikely to be targeted by a
      // transpiler, and the original source is probably a better indicator of the
      // true owner.

      var source = element._source; // Owner will be preserved, unless ref is overridden

      var owner = element._owner;

      if (config != null) {
        if (hasValidRef(config)) {
          // Silently steal the ref from the parent.
          ref = config.ref;
          owner = ReactCurrentOwner.current;
        }

        if (hasValidKey(config)) {
          key = '' + config.key;
        } // Remaining properties override existing props


        var defaultProps;

        if (element.type && element.type.defaultProps) {
          defaultProps = element.type.defaultProps;
        }

        for (propName in config) {
          if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
            if (config[propName] === undefined && defaultProps !== undefined) {
              // Resolve default props
              props[propName] = defaultProps[propName];
            } else {
              props[propName] = config[propName];
            }
          }
        }
      } // Children can be more than one argument, and those are transferred onto
      // the newly allocated props object.


      var childrenLength = arguments.length - 2;

      if (childrenLength === 1) {
        props.children = children;
      } else if (childrenLength > 1) {
        var childArray = Array(childrenLength);

        for (var i = 0; i < childrenLength; i++) {
          childArray[i] = arguments[i + 2];
        }

        props.children = childArray;
      }

      return ReactElement(element.type, key, ref, self, source, owner, props);
    }
    /**
     * Verifies the object is a ReactElement.
     * See https://reactjs.org/docs/react-api.html#isvalidelement
     * @param {?object} object
     * @return {boolean} True if `object` is a ReactElement.
     * @final
     */


    function isValidElement(object) {
      return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
    }

    var SEPARATOR = '.';
    var SUBSEPARATOR = ':';
    /**
     * Escape and wrap key so it is safe to use as a reactid
     *
     * @param {string} key to be escaped.
     * @return {string} the escaped key.
     */

    function escape(key) {
      var escapeRegex = /[=:]/g;
      var escaperLookup = {
        '=': '=0',
        ':': '=2'
      };
      var escapedString = ('' + key).replace(escapeRegex, function (match) {
        return escaperLookup[match];
      });
      return '$' + escapedString;
    }
    /**
     * TODO: Test that a single child and an array with one item have the same key
     * pattern.
     */


    var didWarnAboutMaps = false;
    var userProvidedKeyEscapeRegex = /\/+/g;

    function escapeUserProvidedKey(text) {
      return ('' + text).replace(userProvidedKeyEscapeRegex, '$&/');
    }

    var POOL_SIZE = 10;
    var traverseContextPool = [];

    function getPooledTraverseContext(mapResult, keyPrefix, mapFunction, mapContext) {
      if (traverseContextPool.length) {
        var traverseContext = traverseContextPool.pop();
        traverseContext.result = mapResult;
        traverseContext.keyPrefix = keyPrefix;
        traverseContext.func = mapFunction;
        traverseContext.context = mapContext;
        traverseContext.count = 0;
        return traverseContext;
      } else {
        return {
          result: mapResult,
          keyPrefix: keyPrefix,
          func: mapFunction,
          context: mapContext,
          count: 0
        };
      }
    }

    function releaseTraverseContext(traverseContext) {
      traverseContext.result = null;
      traverseContext.keyPrefix = null;
      traverseContext.func = null;
      traverseContext.context = null;
      traverseContext.count = 0;

      if (traverseContextPool.length < POOL_SIZE) {
        traverseContextPool.push(traverseContext);
      }
    }
    /**
     * @param {?*} children Children tree container.
     * @param {!string} nameSoFar Name of the key path so far.
     * @param {!function} callback Callback to invoke with each child found.
     * @param {?*} traverseContext Used to pass information throughout the traversal
     * process.
     * @return {!number} The number of children in this subtree.
     */


    function traverseAllChildrenImpl(children, nameSoFar, callback, traverseContext) {
      var type = typeof children;

      if (type === 'undefined' || type === 'boolean') {
        // All of the above are perceived as null.
        children = null;
      }

      var invokeCallback = false;

      if (children === null) {
        invokeCallback = true;
      } else {
        switch (type) {
          case 'string':
          case 'number':
            invokeCallback = true;
            break;

          case 'object':
            switch (children.$$typeof) {
              case REACT_ELEMENT_TYPE:
              case REACT_PORTAL_TYPE:
                invokeCallback = true;
            }

        }
      }

      if (invokeCallback) {
        callback(traverseContext, children, // If it's the only child, treat the name as if it was wrapped in an array
        // so that it's consistent if the number of children grows.
        nameSoFar === '' ? SEPARATOR + getComponentKey(children, 0) : nameSoFar);
        return 1;
      }

      var child;
      var nextName;
      var subtreeCount = 0; // Count of children found in the current subtree.

      var nextNamePrefix = nameSoFar === '' ? SEPARATOR : nameSoFar + SUBSEPARATOR;

      if (Array.isArray(children)) {
        for (var i = 0; i < children.length; i++) {
          child = children[i];
          nextName = nextNamePrefix + getComponentKey(child, i);
          subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext);
        }
      } else {
        var iteratorFn = getIteratorFn(children);

        if (typeof iteratorFn === 'function') {
          {
            // Warn about using Maps as children
            if (iteratorFn === children.entries) {
              !didWarnAboutMaps ? warning$1(false, 'Using Maps as children is unsupported and will likely yield ' + 'unexpected results. Convert it to a sequence/iterable of keyed ' + 'ReactElements instead.') : void 0;
              didWarnAboutMaps = true;
            }
          }
          var iterator = iteratorFn.call(children);
          var step;
          var ii = 0;

          while (!(step = iterator.next()).done) {
            child = step.value;
            nextName = nextNamePrefix + getComponentKey(child, ii++);
            subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext);
          }
        } else if (type === 'object') {
          var addendum = '';
          {
            addendum = ' If you meant to render a collection of children, use an array ' + 'instead.' + ReactDebugCurrentFrame.getStackAddendum();
          }
          var childrenString = '' + children;
          {
            {
              throw Error("Objects are not valid as a React child (found: " + (childrenString === '[object Object]' ? 'object with keys {' + Object.keys(children).join(', ') + '}' : childrenString) + ")." + addendum);
            }
          }
        }
      }

      return subtreeCount;
    }
    /**
     * Traverses children that are typically specified as `props.children`, but
     * might also be specified through attributes:
     *
     * - `traverseAllChildren(this.props.children, ...)`
     * - `traverseAllChildren(this.props.leftPanelChildren, ...)`
     *
     * The `traverseContext` is an optional argument that is passed through the
     * entire traversal. It can be used to store accumulations or anything else that
     * the callback might find relevant.
     *
     * @param {?*} children Children tree object.
     * @param {!function} callback To invoke upon traversing each child.
     * @param {?*} traverseContext Context for traversal.
     * @return {!number} The number of children in this subtree.
     */


    function traverseAllChildren(children, callback, traverseContext) {
      if (children == null) {
        return 0;
      }

      return traverseAllChildrenImpl(children, '', callback, traverseContext);
    }
    /**
     * Generate a key string that identifies a component within a set.
     *
     * @param {*} component A component that could contain a manual key.
     * @param {number} index Index that is used if a manual key is not provided.
     * @return {string}
     */


    function getComponentKey(component, index) {
      // Do some typechecking here since we call this blindly. We want to ensure
      // that we don't block potential future ES APIs.
      if (typeof component === 'object' && component !== null && component.key != null) {
        // Explicit key
        return escape(component.key);
      } // Implicit key determined by the index in the set


      return index.toString(36);
    }

    function forEachSingleChild(bookKeeping, child, name) {
      var func = bookKeeping.func,
          context = bookKeeping.context;
      func.call(context, child, bookKeeping.count++);
    }
    /**
     * Iterates through children that are typically specified as `props.children`.
     *
     * See https://reactjs.org/docs/react-api.html#reactchildrenforeach
     *
     * The provided forEachFunc(child, index) will be called for each
     * leaf child.
     *
     * @param {?*} children Children tree container.
     * @param {function(*, int)} forEachFunc
     * @param {*} forEachContext Context for forEachContext.
     */


    function forEachChildren(children, forEachFunc, forEachContext) {
      if (children == null) {
        return children;
      }

      var traverseContext = getPooledTraverseContext(null, null, forEachFunc, forEachContext);
      traverseAllChildren(children, forEachSingleChild, traverseContext);
      releaseTraverseContext(traverseContext);
    }

    function mapSingleChildIntoContext(bookKeeping, child, childKey) {
      var result = bookKeeping.result,
          keyPrefix = bookKeeping.keyPrefix,
          func = bookKeeping.func,
          context = bookKeeping.context;
      var mappedChild = func.call(context, child, bookKeeping.count++);

      if (Array.isArray(mappedChild)) {
        mapIntoWithKeyPrefixInternal(mappedChild, result, childKey, function (c) {
          return c;
        });
      } else if (mappedChild != null) {
        if (isValidElement(mappedChild)) {
          mappedChild = cloneAndReplaceKey(mappedChild, // Keep both the (mapped) and old keys if they differ, just as
          // traverseAllChildren used to do for objects as children
          keyPrefix + (mappedChild.key && (!child || child.key !== mappedChild.key) ? escapeUserProvidedKey(mappedChild.key) + '/' : '') + childKey);
        }

        result.push(mappedChild);
      }
    }

    function mapIntoWithKeyPrefixInternal(children, array, prefix, func, context) {
      var escapedPrefix = '';

      if (prefix != null) {
        escapedPrefix = escapeUserProvidedKey(prefix) + '/';
      }

      var traverseContext = getPooledTraverseContext(array, escapedPrefix, func, context);
      traverseAllChildren(children, mapSingleChildIntoContext, traverseContext);
      releaseTraverseContext(traverseContext);
    }
    /**
     * Maps children that are typically specified as `props.children`.
     *
     * See https://reactjs.org/docs/react-api.html#reactchildrenmap
     *
     * The provided mapFunction(child, key, index) will be called for each
     * leaf child.
     *
     * @param {?*} children Children tree container.
     * @param {function(*, int)} func The map function.
     * @param {*} context Context for mapFunction.
     * @return {object} Object containing the ordered map of results.
     */


    function mapChildren(children, func, context) {
      if (children == null) {
        return children;
      }

      var result = [];
      mapIntoWithKeyPrefixInternal(children, result, null, func, context);
      return result;
    }
    /**
     * Count the number of children that are typically specified as
     * `props.children`.
     *
     * See https://reactjs.org/docs/react-api.html#reactchildrencount
     *
     * @param {?*} children Children tree container.
     * @return {number} The number of children.
     */


    function countChildren(children) {
      return traverseAllChildren(children, function () {
        return null;
      }, null);
    }
    /**
     * Flatten a children object (typically specified as `props.children`) and
     * return an array with appropriately re-keyed children.
     *
     * See https://reactjs.org/docs/react-api.html#reactchildrentoarray
     */


    function toArray(children) {
      var result = [];
      mapIntoWithKeyPrefixInternal(children, result, null, function (child) {
        return child;
      });
      return result;
    }
    /**
     * Returns the first child in a collection of children and verifies that there
     * is only one child in the collection.
     *
     * See https://reactjs.org/docs/react-api.html#reactchildrenonly
     *
     * The current implementation of this function assumes that a single child gets
     * passed without a wrapper, but the purpose of this helper function is to
     * abstract away the particular structure of children.
     *
     * @param {?object} children Child collection structure.
     * @return {ReactElement} The first and only `ReactElement` contained in the
     * structure.
     */


    function onlyChild(children) {
      if (!isValidElement(children)) {
        {
          throw Error("React.Children.only expected to receive a single React element child.");
        }
      }

      return children;
    }

    function createContext(defaultValue, calculateChangedBits) {
      if (calculateChangedBits === undefined) {
        calculateChangedBits = null;
      } else {
        {
          !(calculateChangedBits === null || typeof calculateChangedBits === 'function') ? warningWithoutStack$1(false, 'createContext: Expected the optional second argument to be a ' + 'function. Instead received: %s', calculateChangedBits) : void 0;
        }
      }

      var context = {
        $$typeof: REACT_CONTEXT_TYPE,
        _calculateChangedBits: calculateChangedBits,
        // As a workaround to support multiple concurrent renderers, we categorize
        // some renderers as primary and others as secondary. We only expect
        // there to be two concurrent renderers at most: React Native (primary) and
        // Fabric (secondary); React DOM (primary) and React ART (secondary).
        // Secondary renderers store their context values on separate fields.
        _currentValue: defaultValue,
        _currentValue2: defaultValue,
        // Used to track how many concurrent renderers this context currently
        // supports within in a single renderer. Such as parallel server rendering.
        _threadCount: 0,
        // These are circular
        Provider: null,
        Consumer: null
      };
      context.Provider = {
        $$typeof: REACT_PROVIDER_TYPE,
        _context: context
      };
      var hasWarnedAboutUsingNestedContextConsumers = false;
      var hasWarnedAboutUsingConsumerProvider = false;
      {
        // A separate object, but proxies back to the original context object for
        // backwards compatibility. It has a different $$typeof, so we can properly
        // warn for the incorrect usage of Context as a Consumer.
        var Consumer = {
          $$typeof: REACT_CONTEXT_TYPE,
          _context: context,
          _calculateChangedBits: context._calculateChangedBits
        }; // $FlowFixMe: Flow complains about not setting a value, which is intentional here

        Object.defineProperties(Consumer, {
          Provider: {
            get: function () {
              if (!hasWarnedAboutUsingConsumerProvider) {
                hasWarnedAboutUsingConsumerProvider = true;
                warning$1(false, 'Rendering <Context.Consumer.Provider> is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Provider> instead?');
              }

              return context.Provider;
            },
            set: function (_Provider) {
              context.Provider = _Provider;
            }
          },
          _currentValue: {
            get: function () {
              return context._currentValue;
            },
            set: function (_currentValue) {
              context._currentValue = _currentValue;
            }
          },
          _currentValue2: {
            get: function () {
              return context._currentValue2;
            },
            set: function (_currentValue2) {
              context._currentValue2 = _currentValue2;
            }
          },
          _threadCount: {
            get: function () {
              return context._threadCount;
            },
            set: function (_threadCount) {
              context._threadCount = _threadCount;
            }
          },
          Consumer: {
            get: function () {
              if (!hasWarnedAboutUsingNestedContextConsumers) {
                hasWarnedAboutUsingNestedContextConsumers = true;
                warning$1(false, 'Rendering <Context.Consumer.Consumer> is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Consumer> instead?');
              }

              return context.Consumer;
            }
          }
        }); // $FlowFixMe: Flow complains about missing properties because it doesn't understand defineProperty

        context.Consumer = Consumer;
      }
      {
        context._currentRenderer = null;
        context._currentRenderer2 = null;
      }
      return context;
    }

    function lazy(ctor) {
      var lazyType = {
        $$typeof: REACT_LAZY_TYPE,
        _ctor: ctor,
        // React uses these fields to store the result.
        _status: -1,
        _result: null
      };
      {
        // In production, this would just set it on the object.
        var defaultProps;
        var propTypes;
        Object.defineProperties(lazyType, {
          defaultProps: {
            configurable: true,
            get: function () {
              return defaultProps;
            },
            set: function (newDefaultProps) {
              warning$1(false, 'React.lazy(...): It is not supported to assign `defaultProps` to ' + 'a lazy component import. Either specify them where the component ' + 'is defined, or create a wrapping component around it.');
              defaultProps = newDefaultProps; // Match production behavior more closely:

              Object.defineProperty(lazyType, 'defaultProps', {
                enumerable: true
              });
            }
          },
          propTypes: {
            configurable: true,
            get: function () {
              return propTypes;
            },
            set: function (newPropTypes) {
              warning$1(false, 'React.lazy(...): It is not supported to assign `propTypes` to ' + 'a lazy component import. Either specify them where the component ' + 'is defined, or create a wrapping component around it.');
              propTypes = newPropTypes; // Match production behavior more closely:

              Object.defineProperty(lazyType, 'propTypes', {
                enumerable: true
              });
            }
          }
        });
      }
      return lazyType;
    }

    function forwardRef(render) {
      {
        if (render != null && render.$$typeof === REACT_MEMO_TYPE) {
          warningWithoutStack$1(false, 'forwardRef requires a render function but received a `memo` ' + 'component. Instead of forwardRef(memo(...)), use ' + 'memo(forwardRef(...)).');
        } else if (typeof render !== 'function') {
          warningWithoutStack$1(false, 'forwardRef requires a render function but was given %s.', render === null ? 'null' : typeof render);
        } else {
          !( // Do not warn for 0 arguments because it could be due to usage of the 'arguments' object
          render.length === 0 || render.length === 2) ? warningWithoutStack$1(false, 'forwardRef render functions accept exactly two parameters: props and ref. %s', render.length === 1 ? 'Did you forget to use the ref parameter?' : 'Any additional parameter will be undefined.') : void 0;
        }

        if (render != null) {
          !(render.defaultProps == null && render.propTypes == null) ? warningWithoutStack$1(false, 'forwardRef render functions do not support propTypes or defaultProps. ' + 'Did you accidentally pass a React component?') : void 0;
        }
      }
      return {
        $$typeof: REACT_FORWARD_REF_TYPE,
        render: render
      };
    }

    function isValidElementType(type) {
      return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
      type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE);
    }

    function memo(type, compare) {
      {
        if (!isValidElementType(type)) {
          warningWithoutStack$1(false, 'memo: The first argument must be a component. Instead ' + 'received: %s', type === null ? 'null' : typeof type);
        }
      }
      return {
        $$typeof: REACT_MEMO_TYPE,
        type: type,
        compare: compare === undefined ? null : compare
      };
    }

    function resolveDispatcher() {
      var dispatcher = ReactCurrentDispatcher.current;

      if (!(dispatcher !== null)) {
        {
          throw Error("Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\n1. You might have mismatching versions of React and the renderer (such as React DOM)\n2. You might be breaking the Rules of Hooks\n3. You might have more than one copy of React in the same app\nSee https://fb.me/react-invalid-hook-call for tips about how to debug and fix this problem.");
        }
      }

      return dispatcher;
    }

    function useContext(Context, unstable_observedBits) {
      var dispatcher = resolveDispatcher();
      {
        !(unstable_observedBits === undefined) ? warning$1(false, 'useContext() second argument is reserved for future ' + 'use in React. Passing it is not supported. ' + 'You passed: %s.%s', unstable_observedBits, typeof unstable_observedBits === 'number' && Array.isArray(arguments[2]) ? '\n\nDid you call array.map(useContext)? ' + 'Calling Hooks inside a loop is not supported. ' + 'Learn more at https://fb.me/rules-of-hooks' : '') : void 0; // TODO: add a more generic warning for invalid values.

        if (Context._context !== undefined) {
          var realContext = Context._context; // Don't deduplicate because this legitimately causes bugs
          // and nobody should be using this in existing code.

          if (realContext.Consumer === Context) {
            warning$1(false, 'Calling useContext(Context.Consumer) is not supported, may cause bugs, and will be ' + 'removed in a future major release. Did you mean to call useContext(Context) instead?');
          } else if (realContext.Provider === Context) {
            warning$1(false, 'Calling useContext(Context.Provider) is not supported. ' + 'Did you mean to call useContext(Context) instead?');
          }
        }
      }
      return dispatcher.useContext(Context, unstable_observedBits);
    }

    function useState(initialState) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useState(initialState);
    }

    function useReducer(reducer, initialArg, init) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useReducer(reducer, initialArg, init);
    }

    function useRef(initialValue) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useRef(initialValue);
    }

    function useEffect(create, inputs) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useEffect(create, inputs);
    }

    function useLayoutEffect(create, inputs) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useLayoutEffect(create, inputs);
    }

    function useCallback(callback, inputs) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useCallback(callback, inputs);
    }

    function useMemo(create, inputs) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useMemo(create, inputs);
    }

    function useImperativeHandle(ref, create, inputs) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useImperativeHandle(ref, create, inputs);
    }

    function useDebugValue(value, formatterFn) {
      {
        var dispatcher = resolveDispatcher();
        return dispatcher.useDebugValue(value, formatterFn);
      }
    }

    var emptyObject$1 = {};

    function useResponder(responder, listenerProps) {
      var dispatcher = resolveDispatcher();
      {
        if (responder == null || responder.$$typeof !== REACT_RESPONDER_TYPE) {
          warning$1(false, 'useResponder: invalid first argument. Expected an event responder, but instead got %s', responder);
          return;
        }
      }
      return dispatcher.useResponder(responder, listenerProps || emptyObject$1);
    }

    function useTransition(config) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useTransition(config);
    }

    function useDeferredValue(value, config) {
      var dispatcher = resolveDispatcher();
      return dispatcher.useDeferredValue(value, config);
    }

    function withSuspenseConfig(scope, config) {
      var previousConfig = ReactCurrentBatchConfig.suspense;
      ReactCurrentBatchConfig.suspense = config === undefined ? null : config;

      try {
        scope();
      } finally {
        ReactCurrentBatchConfig.suspense = previousConfig;
      }
    }
    /**
     * ReactElementValidator provides a wrapper around a element factory
     * which validates the props passed to the element. This is intended to be
     * used only in DEV and could be replaced by a static type checker for languages
     * that support it.
     */


    var propTypesMisspellWarningShown;
    {
      propTypesMisspellWarningShown = false;
    }
    var hasOwnProperty$1 = Object.prototype.hasOwnProperty;

    function getDeclarationErrorAddendum() {
      if (ReactCurrentOwner.current) {
        var name = getComponentName(ReactCurrentOwner.current.type);

        if (name) {
          return '\n\nCheck the render method of `' + name + '`.';
        }
      }

      return '';
    }

    function getSourceInfoErrorAddendum(source) {
      if (source !== undefined) {
        var fileName = source.fileName.replace(/^.*[\\\/]/, '');
        var lineNumber = source.lineNumber;
        return '\n\nCheck your code at ' + fileName + ':' + lineNumber + '.';
      }

      return '';
    }

    function getSourceInfoErrorAddendumForProps(elementProps) {
      if (elementProps !== null && elementProps !== undefined) {
        return getSourceInfoErrorAddendum(elementProps.__source);
      }

      return '';
    }
    /**
     * Warn if there's no key explicitly set on dynamic arrays of children or
     * object keys are not valid. This allows us to keep track of children between
     * updates.
     */


    var ownerHasKeyUseWarning = {};

    function getCurrentComponentErrorInfo(parentType) {
      var info = getDeclarationErrorAddendum();

      if (!info) {
        var parentName = typeof parentType === 'string' ? parentType : parentType.displayName || parentType.name;

        if (parentName) {
          info = "\n\nCheck the top-level render call using <" + parentName + ">.";
        }
      }

      return info;
    }
    /**
     * Warn if the element doesn't have an explicit key assigned to it.
     * This element is in an array. The array could grow and shrink or be
     * reordered. All children that haven't already been validated are required to
     * have a "key" property assigned to it. Error statuses are cached so a warning
     * will only be shown once.
     *
     * @internal
     * @param {ReactElement} element Element that requires a key.
     * @param {*} parentType element's parent's type.
     */


    function validateExplicitKey(element, parentType) {
      if (!element._store || element._store.validated || element.key != null) {
        return;
      }

      element._store.validated = true;
      var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);

      if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
        return;
      }

      ownerHasKeyUseWarning[currentComponentErrorInfo] = true; // Usually the current owner is the offender, but if it accepts children as a
      // property, it may be the creator of the child that's responsible for
      // assigning it a key.

      var childOwner = '';

      if (element && element._owner && element._owner !== ReactCurrentOwner.current) {
        // Give the component that originally created this child.
        childOwner = " It was passed a child from " + getComponentName(element._owner.type) + ".";
      }

      setCurrentlyValidatingElement(element);
      {
        warning$1(false, 'Each child in a list should have a unique "key" prop.' + '%s%s See https://fb.me/react-warning-keys for more information.', currentComponentErrorInfo, childOwner);
      }
      setCurrentlyValidatingElement(null);
    }
    /**
     * Ensure that every element either is passed in a static location, in an
     * array with an explicit keys property defined, or in an object literal
     * with valid key property.
     *
     * @internal
     * @param {ReactNode} node Statically passed child of any type.
     * @param {*} parentType node's parent's type.
     */


    function validateChildKeys(node, parentType) {
      if (typeof node !== 'object') {
        return;
      }

      if (Array.isArray(node)) {
        for (var i = 0; i < node.length; i++) {
          var child = node[i];

          if (isValidElement(child)) {
            validateExplicitKey(child, parentType);
          }
        }
      } else if (isValidElement(node)) {
        // This element was passed in a valid location.
        if (node._store) {
          node._store.validated = true;
        }
      } else if (node) {
        var iteratorFn = getIteratorFn(node);

        if (typeof iteratorFn === 'function') {
          // Entry iterators used to provide implicit keys,
          // but now we print a separate warning for them later.
          if (iteratorFn !== node.entries) {
            var iterator = iteratorFn.call(node);
            var step;

            while (!(step = iterator.next()).done) {
              if (isValidElement(step.value)) {
                validateExplicitKey(step.value, parentType);
              }
            }
          }
        }
      }
    }
    /**
     * Given an element, validate that its props follow the propTypes definition,
     * provided by the type.
     *
     * @param {ReactElement} element
     */


    function validatePropTypes(element) {
      var type = element.type;

      if (type === null || type === undefined || typeof type === 'string') {
        return;
      }

      var name = getComponentName(type);
      var propTypes;

      if (typeof type === 'function') {
        propTypes = type.propTypes;
      } else if (typeof type === 'object' && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
      // Inner props are checked in the reconciler.
      type.$$typeof === REACT_MEMO_TYPE)) {
        propTypes = type.propTypes;
      } else {
        return;
      }

      if (propTypes) {
        setCurrentlyValidatingElement(element);
        checkPropTypes(propTypes, element.props, 'prop', name, ReactDebugCurrentFrame.getStackAddendum);
        setCurrentlyValidatingElement(null);
      } else if (type.PropTypes !== undefined && !propTypesMisspellWarningShown) {
        propTypesMisspellWarningShown = true;
        warningWithoutStack$1(false, 'Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?', name || 'Unknown');
      }

      if (typeof type.getDefaultProps === 'function') {
        !type.getDefaultProps.isReactClassApproved ? warningWithoutStack$1(false, 'getDefaultProps is only used on classic React.createClass ' + 'definitions. Use a static property named `defaultProps` instead.') : void 0;
      }
    }
    /**
     * Given a fragment, validate that it can only be provided with fragment props
     * @param {ReactElement} fragment
     */


    function validateFragmentProps(fragment) {
      setCurrentlyValidatingElement(fragment);
      var keys = Object.keys(fragment.props);

      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];

        if (key !== 'children' && key !== 'key') {
          warning$1(false, 'Invalid prop `%s` supplied to `React.Fragment`. ' + 'React.Fragment can only have `key` and `children` props.', key);
          break;
        }
      }

      if (fragment.ref !== null) {
        warning$1(false, 'Invalid attribute `ref` supplied to `React.Fragment`.');
      }

      setCurrentlyValidatingElement(null);
    }

    function jsxWithValidation(type, props, key, isStaticChildren, source, self) {
      var validType = isValidElementType(type); // We warn in this case but don't throw. We expect the element creation to
      // succeed and there will likely be errors in render.

      if (!validType) {
        var info = '';

        if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {
          info += ' You likely forgot to export your component from the file ' + "it's defined in, or you might have mixed up default and named imports.";
        }

        var sourceInfo = getSourceInfoErrorAddendum(source);

        if (sourceInfo) {
          info += sourceInfo;
        } else {
          info += getDeclarationErrorAddendum();
        }

        var typeString;

        if (type === null) {
          typeString = 'null';
        } else if (Array.isArray(type)) {
          typeString = 'array';
        } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {
          typeString = "<" + (getComponentName(type.type) || 'Unknown') + " />";
          info = ' Did you accidentally export a JSX literal instead of a component?';
        } else {
          typeString = typeof type;
        }

        warning$1(false, 'React.jsx: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);
      }

      var element = jsxDEV(type, props, key, source, self); // The result can be nullish if a mock or a custom function is used.
      // TODO: Drop this when these are no longer allowed as the type argument.

      if (element == null) {
        return element;
      } // Skip key warning if the type isn't valid since our key validation logic
      // doesn't expect a non-string/function type and can throw confusing errors.
      // We don't want exception behavior to differ between dev and prod.
      // (Rendering will throw with a helpful message and as soon as the type is
      // fixed, the key warnings will appear.)


      if (validType) {
        var children = props.children;

        if (children !== undefined) {
          if (isStaticChildren) {
            if (Array.isArray(children)) {
              for (var i = 0; i < children.length; i++) {
                validateChildKeys(children[i], type);
              }

              if (Object.freeze) {
                Object.freeze(children);
              }
            } else {
              warning$1(false, 'React.jsx: Static children should always be an array. ' + 'You are likely explicitly calling React.jsxs or React.jsxDEV. ' + 'Use the Babel transform instead.');
            }
          } else {
            validateChildKeys(children, type);
          }
        }
      }

      if (hasOwnProperty$1.call(props, 'key')) {
        warning$1(false, 'React.jsx: Spreading a key to JSX is a deprecated pattern. ' + 'Explicitly pass a key after spreading props in your JSX call. ' + 'E.g. <ComponentName {...props} key={key} />');
      }

      if (type === REACT_FRAGMENT_TYPE) {
        validateFragmentProps(element);
      } else {
        validatePropTypes(element);
      }

      return element;
    } // These two functions exist to still get child warnings in dev
    // even with the prod transform. This means that jsxDEV is purely
    // opt-in behavior for better messages but that we won't stop
    // giving you warnings if you use production apis.


    function jsxWithValidationStatic(type, props, key) {
      return jsxWithValidation(type, props, key, true);
    }

    function jsxWithValidationDynamic(type, props, key) {
      return jsxWithValidation(type, props, key, false);
    }

    function createElementWithValidation(type, props, children) {
      var validType = isValidElementType(type); // We warn in this case but don't throw. We expect the element creation to
      // succeed and there will likely be errors in render.

      if (!validType) {
        var info = '';

        if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {
          info += ' You likely forgot to export your component from the file ' + "it's defined in, or you might have mixed up default and named imports.";
        }

        var sourceInfo = getSourceInfoErrorAddendumForProps(props);

        if (sourceInfo) {
          info += sourceInfo;
        } else {
          info += getDeclarationErrorAddendum();
        }

        var typeString;

        if (type === null) {
          typeString = 'null';
        } else if (Array.isArray(type)) {
          typeString = 'array';
        } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {
          typeString = "<" + (getComponentName(type.type) || 'Unknown') + " />";
          info = ' Did you accidentally export a JSX literal instead of a component?';
        } else {
          typeString = typeof type;
        }

        warning$1(false, 'React.createElement: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);
      }

      var element = createElement.apply(this, arguments); // The result can be nullish if a mock or a custom function is used.
      // TODO: Drop this when these are no longer allowed as the type argument.

      if (element == null) {
        return element;
      } // Skip key warning if the type isn't valid since our key validation logic
      // doesn't expect a non-string/function type and can throw confusing errors.
      // We don't want exception behavior to differ between dev and prod.
      // (Rendering will throw with a helpful message and as soon as the type is
      // fixed, the key warnings will appear.)


      if (validType) {
        for (var i = 2; i < arguments.length; i++) {
          validateChildKeys(arguments[i], type);
        }
      }

      if (type === REACT_FRAGMENT_TYPE) {
        validateFragmentProps(element);
      } else {
        validatePropTypes(element);
      }

      return element;
    }

    function createFactoryWithValidation(type) {
      var validatedFactory = createElementWithValidation.bind(null, type);
      validatedFactory.type = type; // Legacy hook: remove it

      {
        Object.defineProperty(validatedFactory, 'type', {
          enumerable: false,
          get: function () {
            lowPriorityWarningWithoutStack$1(false, 'Factory.type is deprecated. Access the class directly ' + 'before passing it to createFactory.');
            Object.defineProperty(this, 'type', {
              value: type
            });
            return type;
          }
        });
      }
      return validatedFactory;
    }

    function cloneElementWithValidation(element, props, children) {
      var newElement = cloneElement.apply(this, arguments);

      for (var i = 2; i < arguments.length; i++) {
        validateChildKeys(arguments[i], newElement.type);
      }

      validatePropTypes(newElement);
      return newElement;
    }

    var hasBadMapPolyfill;
    {
      hasBadMapPolyfill = false;

      try {
        var frozenObject = Object.freeze({});
        var testMap = new Map([[frozenObject, null]]);
        var testSet = new Set([frozenObject]); // This is necessary for Rollup to not consider these unused.
        // https://github.com/rollup/rollup/issues/1771
        // TODO: we can remove these if Rollup fixes the bug.

        testMap.set(0, 0);
        testSet.add(0);
      } catch (e) {
        // TODO: Consider warning about bad polyfills
        hasBadMapPolyfill = true;
      }
    }

    function createFundamentalComponent(impl) {
      // We use responder as a Map key later on. When we have a bad
      // polyfill, then we can't use it as a key as the polyfill tries
      // to add a property to the object.
      if (true && !hasBadMapPolyfill) {
        Object.freeze(impl);
      }

      var fundamantalComponent = {
        $$typeof: REACT_FUNDAMENTAL_TYPE,
        impl: impl
      };
      {
        Object.freeze(fundamantalComponent);
      }
      return fundamantalComponent;
    }

    function createEventResponder(displayName, responderConfig) {
      var getInitialState = responderConfig.getInitialState,
          onEvent = responderConfig.onEvent,
          onMount = responderConfig.onMount,
          onUnmount = responderConfig.onUnmount,
          onRootEvent = responderConfig.onRootEvent,
          rootEventTypes = responderConfig.rootEventTypes,
          targetEventTypes = responderConfig.targetEventTypes,
          targetPortalPropagation = responderConfig.targetPortalPropagation;
      var eventResponder = {
        $$typeof: REACT_RESPONDER_TYPE,
        displayName: displayName,
        getInitialState: getInitialState || null,
        onEvent: onEvent || null,
        onMount: onMount || null,
        onRootEvent: onRootEvent || null,
        onUnmount: onUnmount || null,
        rootEventTypes: rootEventTypes || null,
        targetEventTypes: targetEventTypes || null,
        targetPortalPropagation: targetPortalPropagation || false
      }; // We use responder as a Map key later on. When we have a bad
      // polyfill, then we can't use it as a key as the polyfill tries
      // to add a property to the object.

      if (true && !hasBadMapPolyfill) {
        Object.freeze(eventResponder);
      }

      return eventResponder;
    }

    function createScope() {
      var scopeComponent = {
        $$typeof: REACT_SCOPE_TYPE
      };
      {
        Object.freeze(scopeComponent);
      }
      return scopeComponent;
    } // Helps identify side effects in render-phase lifecycle hooks and setState
    // reducers by double invoking them in Strict Mode.
    // To preserve the "Pause on caught exceptions" behavior of the debugger, we
    // replay the begin phase of a failed component inside invokeGuardedCallback.
    // Warn about deprecated, async-unsafe lifecycles; relates to RFC #6:
    // Gather advanced timing metrics for Profiler subtrees.
    // Trace which interactions trigger each commit.
    // SSR experiments
    // Only used in www builds.
    // Only used in www builds.
    // Disable javascript: URL strings in href for XSS protection.
    // React Fire: prevent the value and checked attributes from syncing
    // with their related DOM properties
    // These APIs will no longer be "unstable" in the upcoming 16.7 release,
    // Control this behavior with a flag to support 16.6 minor releases in the meanwhile.


    var exposeConcurrentModeAPIs = false; // Experimental React Flare event system and event components support.

    var enableFlareAPI = false; // Experimental Host Component support.

    var enableFundamentalAPI = false; // Experimental Scope support.

    var enableScopeAPI = false; // New API for JSX transforms to target - https://github.com/reactjs/rfcs/pull/107

    var enableJSXTransformAPI = false; // We will enforce mocking scheduler with scheduler/unstable_mock at some point. (v17?)
    // Till then, we warn about the missing mock, but still fallback to a legacy mode compatible version
    // For tests, we flush suspense fallbacks in an act scope;
    // *except* in some of our own tests, where we test incremental loading states.
    // Add a callback property to suspense to notify which promises are currently
    // in the update queue. This allows reporting and tracing of what is causing
    // the user to see a loading state.
    // Also allows hydration callbacks to fire when a dehydrated boundary gets
    // hydrated or deleted.
    // Part of the simplification of React.createElement so we can eventually move
    // from React.createElement to React.jsx
    // https://github.com/reactjs/rfcs/blob/createlement-rfc/text/0000-create-element-changes.md
    // Flag to turn event.target and event.currentTarget in ReactNative from a reactTag to a component instance

    var React = {
      Children: {
        map: mapChildren,
        forEach: forEachChildren,
        count: countChildren,
        toArray: toArray,
        only: onlyChild
      },
      createRef: createRef,
      Component: Component,
      PureComponent: PureComponent,
      createContext: createContext,
      forwardRef: forwardRef,
      lazy: lazy,
      memo: memo,
      useCallback: useCallback,
      useContext: useContext,
      useEffect: useEffect,
      useImperativeHandle: useImperativeHandle,
      useDebugValue: useDebugValue,
      useLayoutEffect: useLayoutEffect,
      useMemo: useMemo,
      useReducer: useReducer,
      useRef: useRef,
      useState: useState,
      Fragment: REACT_FRAGMENT_TYPE,
      Profiler: REACT_PROFILER_TYPE,
      StrictMode: REACT_STRICT_MODE_TYPE,
      Suspense: REACT_SUSPENSE_TYPE,
      createElement: createElementWithValidation,
      cloneElement: cloneElementWithValidation,
      createFactory: createFactoryWithValidation,
      isValidElement: isValidElement,
      version: ReactVersion,
      __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: ReactSharedInternals
    };

    if (exposeConcurrentModeAPIs) {
      React.useTransition = useTransition;
      React.useDeferredValue = useDeferredValue;
      React.SuspenseList = REACT_SUSPENSE_LIST_TYPE;
      React.unstable_withSuspenseConfig = withSuspenseConfig;
    }

    if (enableFlareAPI) {
      React.unstable_useResponder = useResponder;
      React.unstable_createResponder = createEventResponder;
    }

    if (enableFundamentalAPI) {
      React.unstable_createFundamental = createFundamentalComponent;
    }

    if (enableScopeAPI) {
      React.unstable_createScope = createScope;
    } // Note: some APIs are added with feature flags.
    // Make sure that stable builds for open source
    // don't modify the React object to avoid deopts.
    // Also let's not expose their names in stable builds.


    if (enableJSXTransformAPI) {
      {
        React.jsxDEV = jsxWithValidation;
        React.jsx = jsxWithValidationDynamic;
        React.jsxs = jsxWithValidationStatic;
      }
    }

    var React$2 = Object.freeze({
      default: React
    });
    var React$3 = React$2 && React || React$2; // TODO: decide on the top-level export form.
    // This is hacky but makes it work with both Rollup and Jest.

    var react = React$3.default || React$3;
    module.exports = react;
  })();
}
},{"object-assign":"node_modules/object-assign/index.js","prop-types/checkPropTypes":"node_modules/prop-types/checkPropTypes.js"}],"node_modules/react/index.js":[function(require,module,exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/react.production.min.js');
} else {
  module.exports = require('./cjs/react.development.js');
}
},{"./cjs/react.development.js":"node_modules/react/cjs/react.development.js"}],"node_modules/scheduler/cjs/scheduler.development.js":[function(require,module,exports) {
/** @license React v0.18.0
 * scheduler.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

if ("development" !== "production") {
  (function () {
    'use strict';

    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    var enableSchedulerDebugging = false;
    var enableIsInputPending = false;
    var enableProfiling = true;
    var requestHostCallback;
    var requestHostTimeout;
    var cancelHostTimeout;
    var shouldYieldToHost;
    var requestPaint;

    if ( // If Scheduler runs in a non-DOM environment, it falls back to a naive
    // implementation using setTimeout.
    typeof window === 'undefined' || // Check if MessageChannel is supported, too.
    typeof MessageChannel !== 'function') {
      // If this accidentally gets imported in a non-browser environment, e.g. JavaScriptCore,
      // fallback to a naive implementation.
      var _callback = null;
      var _timeoutID = null;

      var _flushCallback = function () {
        if (_callback !== null) {
          try {
            var currentTime = exports.unstable_now();
            var hasRemainingTime = true;

            _callback(hasRemainingTime, currentTime);

            _callback = null;
          } catch (e) {
            setTimeout(_flushCallback, 0);
            throw e;
          }
        }
      };

      var initialTime = Date.now();

      exports.unstable_now = function () {
        return Date.now() - initialTime;
      };

      requestHostCallback = function (cb) {
        if (_callback !== null) {
          // Protect against re-entrancy.
          setTimeout(requestHostCallback, 0, cb);
        } else {
          _callback = cb;
          setTimeout(_flushCallback, 0);
        }
      };

      requestHostTimeout = function (cb, ms) {
        _timeoutID = setTimeout(cb, ms);
      };

      cancelHostTimeout = function () {
        clearTimeout(_timeoutID);
      };

      shouldYieldToHost = function () {
        return false;
      };

      requestPaint = exports.unstable_forceFrameRate = function () {};
    } else {
      // Capture local references to native APIs, in case a polyfill overrides them.
      var performance = window.performance;
      var _Date = window.Date;
      var _setTimeout = window.setTimeout;
      var _clearTimeout = window.clearTimeout;

      if (typeof console !== 'undefined') {
        // TODO: Scheduler no longer requires these methods to be polyfilled. But
        // maybe we want to continue warning if they don't exist, to preserve the
        // option to rely on it in the future?
        var requestAnimationFrame = window.requestAnimationFrame;
        var cancelAnimationFrame = window.cancelAnimationFrame; // TODO: Remove fb.me link

        if (typeof requestAnimationFrame !== 'function') {
          console.error("This browser doesn't support requestAnimationFrame. " + 'Make sure that you load a ' + 'polyfill in older browsers. https://fb.me/react-polyfills');
        }

        if (typeof cancelAnimationFrame !== 'function') {
          console.error("This browser doesn't support cancelAnimationFrame. " + 'Make sure that you load a ' + 'polyfill in older browsers. https://fb.me/react-polyfills');
        }
      }

      if (typeof performance === 'object' && typeof performance.now === 'function') {
        exports.unstable_now = function () {
          return performance.now();
        };
      } else {
        var _initialTime = _Date.now();

        exports.unstable_now = function () {
          return _Date.now() - _initialTime;
        };
      }

      var isMessageLoopRunning = false;
      var scheduledHostCallback = null;
      var taskTimeoutID = -1; // Scheduler periodically yields in case there is other work on the main
      // thread, like user events. By default, it yields multiple times per frame.
      // It does not attempt to align with frame boundaries, since most tasks don't
      // need to be frame aligned; for those that do, use requestAnimationFrame.

      var yieldInterval = 5;
      var deadline = 0; // TODO: Make this configurable
      // TODO: Adjust this based on priority?

      var maxYieldInterval = 300;
      var needsPaint = false;

      if (enableIsInputPending && navigator !== undefined && navigator.scheduling !== undefined && navigator.scheduling.isInputPending !== undefined) {
        var scheduling = navigator.scheduling;

        shouldYieldToHost = function () {
          var currentTime = exports.unstable_now();

          if (currentTime >= deadline) {
            // There's no time left. We may want to yield control of the main
            // thread, so the browser can perform high priority tasks. The main ones
            // are painting and user input. If there's a pending paint or a pending
            // input, then we should yield. But if there's neither, then we can
            // yield less often while remaining responsive. We'll eventually yield
            // regardless, since there could be a pending paint that wasn't
            // accompanied by a call to `requestPaint`, or other main thread tasks
            // like network events.
            if (needsPaint || scheduling.isInputPending()) {
              // There is either a pending paint or a pending input.
              return true;
            } // There's no pending input. Only yield if we've reached the max
            // yield interval.


            return currentTime >= maxYieldInterval;
          } else {
            // There's still time left in the frame.
            return false;
          }
        };

        requestPaint = function () {
          needsPaint = true;
        };
      } else {
        // `isInputPending` is not available. Since we have no way of knowing if
        // there's pending input, always yield at the end of the frame.
        shouldYieldToHost = function () {
          return exports.unstable_now() >= deadline;
        }; // Since we yield every frame regardless, `requestPaint` has no effect.


        requestPaint = function () {};
      }

      exports.unstable_forceFrameRate = function (fps) {
        if (fps < 0 || fps > 125) {
          console.error('forceFrameRate takes a positive int between 0 and 125, ' + 'forcing framerates higher than 125 fps is not unsupported');
          return;
        }

        if (fps > 0) {
          yieldInterval = Math.floor(1000 / fps);
        } else {
          // reset the framerate
          yieldInterval = 5;
        }
      };

      var performWorkUntilDeadline = function () {
        if (scheduledHostCallback !== null) {
          var currentTime = exports.unstable_now(); // Yield after `yieldInterval` ms, regardless of where we are in the vsync
          // cycle. This means there's always time remaining at the beginning of
          // the message event.

          deadline = currentTime + yieldInterval;
          var hasTimeRemaining = true;

          try {
            var hasMoreWork = scheduledHostCallback(hasTimeRemaining, currentTime);

            if (!hasMoreWork) {
              isMessageLoopRunning = false;
              scheduledHostCallback = null;
            } else {
              // If there's more work, schedule the next message event at the end
              // of the preceding one.
              port.postMessage(null);
            }
          } catch (error) {
            // If a scheduler task throws, exit the current browser task so the
            // error can be observed.
            port.postMessage(null);
            throw error;
          }
        } else {
          isMessageLoopRunning = false;
        } // Yielding to the browser will give it a chance to paint, so we can
        // reset this.


        needsPaint = false;
      };

      var channel = new MessageChannel();
      var port = channel.port2;
      channel.port1.onmessage = performWorkUntilDeadline;

      requestHostCallback = function (callback) {
        scheduledHostCallback = callback;

        if (!isMessageLoopRunning) {
          isMessageLoopRunning = true;
          port.postMessage(null);
        }
      };

      requestHostTimeout = function (callback, ms) {
        taskTimeoutID = _setTimeout(function () {
          callback(exports.unstable_now());
        }, ms);
      };

      cancelHostTimeout = function () {
        _clearTimeout(taskTimeoutID);

        taskTimeoutID = -1;
      };
    }

    function push(heap, node) {
      var index = heap.length;
      heap.push(node);
      siftUp(heap, node, index);
    }

    function peek(heap) {
      var first = heap[0];
      return first === undefined ? null : first;
    }

    function pop(heap) {
      var first = heap[0];

      if (first !== undefined) {
        var last = heap.pop();

        if (last !== first) {
          heap[0] = last;
          siftDown(heap, last, 0);
        }

        return first;
      } else {
        return null;
      }
    }

    function siftUp(heap, node, i) {
      var index = i;

      while (true) {
        var parentIndex = Math.floor((index - 1) / 2);
        var parent = heap[parentIndex];

        if (parent !== undefined && compare(parent, node) > 0) {
          // The parent is larger. Swap positions.
          heap[parentIndex] = node;
          heap[index] = parent;
          index = parentIndex;
        } else {
          // The parent is smaller. Exit.
          return;
        }
      }
    }

    function siftDown(heap, node, i) {
      var index = i;
      var length = heap.length;

      while (index < length) {
        var leftIndex = (index + 1) * 2 - 1;
        var left = heap[leftIndex];
        var rightIndex = leftIndex + 1;
        var right = heap[rightIndex]; // If the left or right node is smaller, swap with the smaller of those.

        if (left !== undefined && compare(left, node) < 0) {
          if (right !== undefined && compare(right, left) < 0) {
            heap[index] = right;
            heap[rightIndex] = node;
            index = rightIndex;
          } else {
            heap[index] = left;
            heap[leftIndex] = node;
            index = leftIndex;
          }
        } else if (right !== undefined && compare(right, node) < 0) {
          heap[index] = right;
          heap[rightIndex] = node;
          index = rightIndex;
        } else {
          // Neither child is smaller. Exit.
          return;
        }
      }
    }

    function compare(a, b) {
      // Compare sort index first, then task id.
      var diff = a.sortIndex - b.sortIndex;
      return diff !== 0 ? diff : a.id - b.id;
    } // TODO: Use symbols?


    var NoPriority = 0;
    var ImmediatePriority = 1;
    var UserBlockingPriority = 2;
    var NormalPriority = 3;
    var LowPriority = 4;
    var IdlePriority = 5;
    var runIdCounter = 0;
    var mainThreadIdCounter = 0;
    var profilingStateSize = 4;
    var sharedProfilingBuffer = enableProfiling ? // $FlowFixMe Flow doesn't know about SharedArrayBuffer
    typeof SharedArrayBuffer === 'function' ? new SharedArrayBuffer(profilingStateSize * Int32Array.BYTES_PER_ELEMENT) : // $FlowFixMe Flow doesn't know about ArrayBuffer
    typeof ArrayBuffer === 'function' ? new ArrayBuffer(profilingStateSize * Int32Array.BYTES_PER_ELEMENT) : null // Don't crash the init path on IE9
    : null;
    var profilingState = enableProfiling && sharedProfilingBuffer !== null ? new Int32Array(sharedProfilingBuffer) : []; // We can't read this but it helps save bytes for null checks

    var PRIORITY = 0;
    var CURRENT_TASK_ID = 1;
    var CURRENT_RUN_ID = 2;
    var QUEUE_SIZE = 3;

    if (enableProfiling) {
      profilingState[PRIORITY] = NoPriority; // This is maintained with a counter, because the size of the priority queue
      // array might include canceled tasks.

      profilingState[QUEUE_SIZE] = 0;
      profilingState[CURRENT_TASK_ID] = 0;
    } // Bytes per element is 4


    var INITIAL_EVENT_LOG_SIZE = 131072;
    var MAX_EVENT_LOG_SIZE = 524288; // Equivalent to 2 megabytes

    var eventLogSize = 0;
    var eventLogBuffer = null;
    var eventLog = null;
    var eventLogIndex = 0;
    var TaskStartEvent = 1;
    var TaskCompleteEvent = 2;
    var TaskErrorEvent = 3;
    var TaskCancelEvent = 4;
    var TaskRunEvent = 5;
    var TaskYieldEvent = 6;
    var SchedulerSuspendEvent = 7;
    var SchedulerResumeEvent = 8;

    function logEvent(entries) {
      if (eventLog !== null) {
        var offset = eventLogIndex;
        eventLogIndex += entries.length;

        if (eventLogIndex + 1 > eventLogSize) {
          eventLogSize *= 2;

          if (eventLogSize > MAX_EVENT_LOG_SIZE) {
            console.error("Scheduler Profiling: Event log exceeded maximum size. Don't " + 'forget to call `stopLoggingProfilingEvents()`.');
            stopLoggingProfilingEvents();
            return;
          }

          var newEventLog = new Int32Array(eventLogSize * 4);
          newEventLog.set(eventLog);
          eventLogBuffer = newEventLog.buffer;
          eventLog = newEventLog;
        }

        eventLog.set(entries, offset);
      }
    }

    function startLoggingProfilingEvents() {
      eventLogSize = INITIAL_EVENT_LOG_SIZE;
      eventLogBuffer = new ArrayBuffer(eventLogSize * 4);
      eventLog = new Int32Array(eventLogBuffer);
      eventLogIndex = 0;
    }

    function stopLoggingProfilingEvents() {
      var buffer = eventLogBuffer;
      eventLogSize = 0;
      eventLogBuffer = null;
      eventLog = null;
      eventLogIndex = 0;
      return buffer;
    }

    function markTaskStart(task, ms) {
      if (enableProfiling) {
        profilingState[QUEUE_SIZE]++;

        if (eventLog !== null) {
          // performance.now returns a float, representing milliseconds. When the
          // event is logged, it's coerced to an int. Convert to microseconds to
          // maintain extra degrees of precision.
          logEvent([TaskStartEvent, ms * 1000, task.id, task.priorityLevel]);
        }
      }
    }

    function markTaskCompleted(task, ms) {
      if (enableProfiling) {
        profilingState[PRIORITY] = NoPriority;
        profilingState[CURRENT_TASK_ID] = 0;
        profilingState[QUEUE_SIZE]--;

        if (eventLog !== null) {
          logEvent([TaskCompleteEvent, ms * 1000, task.id]);
        }
      }
    }

    function markTaskCanceled(task, ms) {
      if (enableProfiling) {
        profilingState[QUEUE_SIZE]--;

        if (eventLog !== null) {
          logEvent([TaskCancelEvent, ms * 1000, task.id]);
        }
      }
    }

    function markTaskErrored(task, ms) {
      if (enableProfiling) {
        profilingState[PRIORITY] = NoPriority;
        profilingState[CURRENT_TASK_ID] = 0;
        profilingState[QUEUE_SIZE]--;

        if (eventLog !== null) {
          logEvent([TaskErrorEvent, ms * 1000, task.id]);
        }
      }
    }

    function markTaskRun(task, ms) {
      if (enableProfiling) {
        runIdCounter++;
        profilingState[PRIORITY] = task.priorityLevel;
        profilingState[CURRENT_TASK_ID] = task.id;
        profilingState[CURRENT_RUN_ID] = runIdCounter;

        if (eventLog !== null) {
          logEvent([TaskRunEvent, ms * 1000, task.id, runIdCounter]);
        }
      }
    }

    function markTaskYield(task, ms) {
      if (enableProfiling) {
        profilingState[PRIORITY] = NoPriority;
        profilingState[CURRENT_TASK_ID] = 0;
        profilingState[CURRENT_RUN_ID] = 0;

        if (eventLog !== null) {
          logEvent([TaskYieldEvent, ms * 1000, task.id, runIdCounter]);
        }
      }
    }

    function markSchedulerSuspended(ms) {
      if (enableProfiling) {
        mainThreadIdCounter++;

        if (eventLog !== null) {
          logEvent([SchedulerSuspendEvent, ms * 1000, mainThreadIdCounter]);
        }
      }
    }

    function markSchedulerUnsuspended(ms) {
      if (enableProfiling) {
        if (eventLog !== null) {
          logEvent([SchedulerResumeEvent, ms * 1000, mainThreadIdCounter]);
        }
      }
    }
    /* eslint-disable no-var */
    // Math.pow(2, 30) - 1
    // 0b111111111111111111111111111111


    var maxSigned31BitInt = 1073741823; // Times out immediately

    var IMMEDIATE_PRIORITY_TIMEOUT = -1; // Eventually times out

    var USER_BLOCKING_PRIORITY = 250;
    var NORMAL_PRIORITY_TIMEOUT = 5000;
    var LOW_PRIORITY_TIMEOUT = 10000; // Never times out

    var IDLE_PRIORITY = maxSigned31BitInt; // Tasks are stored on a min heap

    var taskQueue = [];
    var timerQueue = []; // Incrementing id counter. Used to maintain insertion order.

    var taskIdCounter = 1; // Pausing the scheduler is useful for debugging.

    var isSchedulerPaused = false;
    var currentTask = null;
    var currentPriorityLevel = NormalPriority; // This is set while performing work, to prevent re-entrancy.

    var isPerformingWork = false;
    var isHostCallbackScheduled = false;
    var isHostTimeoutScheduled = false;

    function advanceTimers(currentTime) {
      // Check for tasks that are no longer delayed and add them to the queue.
      var timer = peek(timerQueue);

      while (timer !== null) {
        if (timer.callback === null) {
          // Timer was cancelled.
          pop(timerQueue);
        } else if (timer.startTime <= currentTime) {
          // Timer fired. Transfer to the task queue.
          pop(timerQueue);
          timer.sortIndex = timer.expirationTime;
          push(taskQueue, timer);

          if (enableProfiling) {
            markTaskStart(timer, currentTime);
            timer.isQueued = true;
          }
        } else {
          // Remaining timers are pending.
          return;
        }

        timer = peek(timerQueue);
      }
    }

    function handleTimeout(currentTime) {
      isHostTimeoutScheduled = false;
      advanceTimers(currentTime);

      if (!isHostCallbackScheduled) {
        if (peek(taskQueue) !== null) {
          isHostCallbackScheduled = true;
          requestHostCallback(flushWork);
        } else {
          var firstTimer = peek(timerQueue);

          if (firstTimer !== null) {
            requestHostTimeout(handleTimeout, firstTimer.startTime - currentTime);
          }
        }
      }
    }

    function flushWork(hasTimeRemaining, initialTime) {
      if (enableProfiling) {
        markSchedulerUnsuspended(initialTime);
      } // We'll need a host callback the next time work is scheduled.


      isHostCallbackScheduled = false;

      if (isHostTimeoutScheduled) {
        // We scheduled a timeout but it's no longer needed. Cancel it.
        isHostTimeoutScheduled = false;
        cancelHostTimeout();
      }

      isPerformingWork = true;
      var previousPriorityLevel = currentPriorityLevel;

      try {
        if (enableProfiling) {
          try {
            return workLoop(hasTimeRemaining, initialTime);
          } catch (error) {
            if (currentTask !== null) {
              var currentTime = exports.unstable_now();
              markTaskErrored(currentTask, currentTime);
              currentTask.isQueued = false;
            }

            throw error;
          }
        } else {
          // No catch in prod codepath.
          return workLoop(hasTimeRemaining, initialTime);
        }
      } finally {
        currentTask = null;
        currentPriorityLevel = previousPriorityLevel;
        isPerformingWork = false;

        if (enableProfiling) {
          var _currentTime = exports.unstable_now();

          markSchedulerSuspended(_currentTime);
        }
      }
    }

    function workLoop(hasTimeRemaining, initialTime) {
      var currentTime = initialTime;
      advanceTimers(currentTime);
      currentTask = peek(taskQueue);

      while (currentTask !== null && !(enableSchedulerDebugging && isSchedulerPaused)) {
        if (currentTask.expirationTime > currentTime && (!hasTimeRemaining || shouldYieldToHost())) {
          // This currentTask hasn't expired, and we've reached the deadline.
          break;
        }

        var callback = currentTask.callback;

        if (callback !== null) {
          currentTask.callback = null;
          currentPriorityLevel = currentTask.priorityLevel;
          var didUserCallbackTimeout = currentTask.expirationTime <= currentTime;
          markTaskRun(currentTask, currentTime);
          var continuationCallback = callback(didUserCallbackTimeout);
          currentTime = exports.unstable_now();

          if (typeof continuationCallback === 'function') {
            currentTask.callback = continuationCallback;
            markTaskYield(currentTask, currentTime);
          } else {
            if (enableProfiling) {
              markTaskCompleted(currentTask, currentTime);
              currentTask.isQueued = false;
            }

            if (currentTask === peek(taskQueue)) {
              pop(taskQueue);
            }
          }

          advanceTimers(currentTime);
        } else {
          pop(taskQueue);
        }

        currentTask = peek(taskQueue);
      } // Return whether there's additional work


      if (currentTask !== null) {
        return true;
      } else {
        var firstTimer = peek(timerQueue);

        if (firstTimer !== null) {
          requestHostTimeout(handleTimeout, firstTimer.startTime - currentTime);
        }

        return false;
      }
    }

    function unstable_runWithPriority(priorityLevel, eventHandler) {
      switch (priorityLevel) {
        case ImmediatePriority:
        case UserBlockingPriority:
        case NormalPriority:
        case LowPriority:
        case IdlePriority:
          break;

        default:
          priorityLevel = NormalPriority;
      }

      var previousPriorityLevel = currentPriorityLevel;
      currentPriorityLevel = priorityLevel;

      try {
        return eventHandler();
      } finally {
        currentPriorityLevel = previousPriorityLevel;
      }
    }

    function unstable_next(eventHandler) {
      var priorityLevel;

      switch (currentPriorityLevel) {
        case ImmediatePriority:
        case UserBlockingPriority:
        case NormalPriority:
          // Shift down to normal priority
          priorityLevel = NormalPriority;
          break;

        default:
          // Anything lower than normal priority should remain at the current level.
          priorityLevel = currentPriorityLevel;
          break;
      }

      var previousPriorityLevel = currentPriorityLevel;
      currentPriorityLevel = priorityLevel;

      try {
        return eventHandler();
      } finally {
        currentPriorityLevel = previousPriorityLevel;
      }
    }

    function unstable_wrapCallback(callback) {
      var parentPriorityLevel = currentPriorityLevel;
      return function () {
        // This is a fork of runWithPriority, inlined for performance.
        var previousPriorityLevel = currentPriorityLevel;
        currentPriorityLevel = parentPriorityLevel;

        try {
          return callback.apply(this, arguments);
        } finally {
          currentPriorityLevel = previousPriorityLevel;
        }
      };
    }

    function timeoutForPriorityLevel(priorityLevel) {
      switch (priorityLevel) {
        case ImmediatePriority:
          return IMMEDIATE_PRIORITY_TIMEOUT;

        case UserBlockingPriority:
          return USER_BLOCKING_PRIORITY;

        case IdlePriority:
          return IDLE_PRIORITY;

        case LowPriority:
          return LOW_PRIORITY_TIMEOUT;

        case NormalPriority:
        default:
          return NORMAL_PRIORITY_TIMEOUT;
      }
    }

    function unstable_scheduleCallback(priorityLevel, callback, options) {
      var currentTime = exports.unstable_now();
      var startTime;
      var timeout;

      if (typeof options === 'object' && options !== null) {
        var delay = options.delay;

        if (typeof delay === 'number' && delay > 0) {
          startTime = currentTime + delay;
        } else {
          startTime = currentTime;
        }

        timeout = typeof options.timeout === 'number' ? options.timeout : timeoutForPriorityLevel(priorityLevel);
      } else {
        timeout = timeoutForPriorityLevel(priorityLevel);
        startTime = currentTime;
      }

      var expirationTime = startTime + timeout;
      var newTask = {
        id: taskIdCounter++,
        callback: callback,
        priorityLevel: priorityLevel,
        startTime: startTime,
        expirationTime: expirationTime,
        sortIndex: -1
      };

      if (enableProfiling) {
        newTask.isQueued = false;
      }

      if (startTime > currentTime) {
        // This is a delayed task.
        newTask.sortIndex = startTime;
        push(timerQueue, newTask);

        if (peek(taskQueue) === null && newTask === peek(timerQueue)) {
          // All tasks are delayed, and this is the task with the earliest delay.
          if (isHostTimeoutScheduled) {
            // Cancel an existing timeout.
            cancelHostTimeout();
          } else {
            isHostTimeoutScheduled = true;
          } // Schedule a timeout.


          requestHostTimeout(handleTimeout, startTime - currentTime);
        }
      } else {
        newTask.sortIndex = expirationTime;
        push(taskQueue, newTask);

        if (enableProfiling) {
          markTaskStart(newTask, currentTime);
          newTask.isQueued = true;
        } // Schedule a host callback, if needed. If we're already performing work,
        // wait until the next time we yield.


        if (!isHostCallbackScheduled && !isPerformingWork) {
          isHostCallbackScheduled = true;
          requestHostCallback(flushWork);
        }
      }

      return newTask;
    }

    function unstable_pauseExecution() {
      isSchedulerPaused = true;
    }

    function unstable_continueExecution() {
      isSchedulerPaused = false;

      if (!isHostCallbackScheduled && !isPerformingWork) {
        isHostCallbackScheduled = true;
        requestHostCallback(flushWork);
      }
    }

    function unstable_getFirstCallbackNode() {
      return peek(taskQueue);
    }

    function unstable_cancelCallback(task) {
      if (enableProfiling) {
        if (task.isQueued) {
          var currentTime = exports.unstable_now();
          markTaskCanceled(task, currentTime);
          task.isQueued = false;
        }
      } // Null out the callback to indicate the task has been canceled. (Can't
      // remove from the queue because you can't remove arbitrary nodes from an
      // array based heap, only the first one.)


      task.callback = null;
    }

    function unstable_getCurrentPriorityLevel() {
      return currentPriorityLevel;
    }

    function unstable_shouldYield() {
      var currentTime = exports.unstable_now();
      advanceTimers(currentTime);
      var firstTask = peek(taskQueue);
      return firstTask !== currentTask && currentTask !== null && firstTask !== null && firstTask.callback !== null && firstTask.startTime <= currentTime && firstTask.expirationTime < currentTask.expirationTime || shouldYieldToHost();
    }

    var unstable_requestPaint = requestPaint;
    var unstable_Profiling = enableProfiling ? {
      startLoggingProfilingEvents: startLoggingProfilingEvents,
      stopLoggingProfilingEvents: stopLoggingProfilingEvents,
      sharedProfilingBuffer: sharedProfilingBuffer
    } : null;
    exports.unstable_ImmediatePriority = ImmediatePriority;
    exports.unstable_UserBlockingPriority = UserBlockingPriority;
    exports.unstable_NormalPriority = NormalPriority;
    exports.unstable_IdlePriority = IdlePriority;
    exports.unstable_LowPriority = LowPriority;
    exports.unstable_runWithPriority = unstable_runWithPriority;
    exports.unstable_next = unstable_next;
    exports.unstable_scheduleCallback = unstable_scheduleCallback;
    exports.unstable_cancelCallback = unstable_cancelCallback;
    exports.unstable_wrapCallback = unstable_wrapCallback;
    exports.unstable_getCurrentPriorityLevel = unstable_getCurrentPriorityLevel;
    exports.unstable_shouldYield = unstable_shouldYield;
    exports.unstable_requestPaint = unstable_requestPaint;
    exports.unstable_continueExecution = unstable_continueExecution;
    exports.unstable_pauseExecution = unstable_pauseExecution;
    exports.unstable_getFirstCallbackNode = unstable_getFirstCallbackNode;
    exports.unstable_Profiling = unstable_Profiling;
  })();
}
},{}],"node_modules/scheduler/index.js":[function(require,module,exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/scheduler.production.min.js');
} else {
  module.exports = require('./cjs/scheduler.development.js');
}
},{"./cjs/scheduler.development.js":"node_modules/scheduler/cjs/scheduler.development.js"}],"node_modules/scheduler/cjs/scheduler-tracing.development.js":[function(require,module,exports) {
/** @license React v0.18.0
 * scheduler-tracing.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

if ("development" !== "production") {
  (function () {
    'use strict';

    Object.defineProperty(exports, '__esModule', {
      value: true
    }); // Helps identify side effects in render-phase lifecycle hooks and setState
    // reducers by double invoking them in Strict Mode.
    // To preserve the "Pause on caught exceptions" behavior of the debugger, we
    // replay the begin phase of a failed component inside invokeGuardedCallback.
    // Warn about deprecated, async-unsafe lifecycles; relates to RFC #6:
    // Gather advanced timing metrics for Profiler subtrees.
    // Trace which interactions trigger each commit.

    var enableSchedulerTracing = true; // SSR experiments
    // Only used in www builds.
    // Only used in www builds.
    // Disable javascript: URL strings in href for XSS protection.
    // React Fire: prevent the value and checked attributes from syncing
    // with their related DOM properties
    // These APIs will no longer be "unstable" in the upcoming 16.7 release,
    // Control this behavior with a flag to support 16.6 minor releases in the meanwhile.
    // Experimental React Flare event system and event components support.
    // Experimental Host Component support.
    // Experimental Scope support.
    // New API for JSX transforms to target - https://github.com/reactjs/rfcs/pull/107
    // We will enforce mocking scheduler with scheduler/unstable_mock at some point. (v17?)
    // Till then, we warn about the missing mock, but still fallback to a legacy mode compatible version
    // For tests, we flush suspense fallbacks in an act scope;
    // *except* in some of our own tests, where we test incremental loading states.
    // Add a callback property to suspense to notify which promises are currently
    // in the update queue. This allows reporting and tracing of what is causing
    // the user to see a loading state.
    // Also allows hydration callbacks to fire when a dehydrated boundary gets
    // hydrated or deleted.
    // Part of the simplification of React.createElement so we can eventually move
    // from React.createElement to React.jsx
    // https://github.com/reactjs/rfcs/blob/createlement-rfc/text/0000-create-element-changes.md
    // Flag to turn event.target and event.currentTarget in ReactNative from a reactTag to a component instance

    var DEFAULT_THREAD_ID = 0; // Counters used to generate unique IDs.

    var interactionIDCounter = 0;
    var threadIDCounter = 0; // Set of currently traced interactions.
    // Interactions "stack"–
    // Meaning that newly traced interactions are appended to the previously active set.
    // When an interaction goes out of scope, the previous set (if any) is restored.

    exports.__interactionsRef = null; // Listener(s) to notify when interactions begin and end.

    exports.__subscriberRef = null;

    if (enableSchedulerTracing) {
      exports.__interactionsRef = {
        current: new Set()
      };
      exports.__subscriberRef = {
        current: null
      };
    }

    function unstable_clear(callback) {
      if (!enableSchedulerTracing) {
        return callback();
      }

      var prevInteractions = exports.__interactionsRef.current;
      exports.__interactionsRef.current = new Set();

      try {
        return callback();
      } finally {
        exports.__interactionsRef.current = prevInteractions;
      }
    }

    function unstable_getCurrent() {
      if (!enableSchedulerTracing) {
        return null;
      } else {
        return exports.__interactionsRef.current;
      }
    }

    function unstable_getThreadID() {
      return ++threadIDCounter;
    }

    function unstable_trace(name, timestamp, callback) {
      var threadID = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : DEFAULT_THREAD_ID;

      if (!enableSchedulerTracing) {
        return callback();
      }

      var interaction = {
        __count: 1,
        id: interactionIDCounter++,
        name: name,
        timestamp: timestamp
      };
      var prevInteractions = exports.__interactionsRef.current; // Traced interactions should stack/accumulate.
      // To do that, clone the current interactions.
      // The previous set will be restored upon completion.

      var interactions = new Set(prevInteractions);
      interactions.add(interaction);
      exports.__interactionsRef.current = interactions;
      var subscriber = exports.__subscriberRef.current;
      var returnValue;

      try {
        if (subscriber !== null) {
          subscriber.onInteractionTraced(interaction);
        }
      } finally {
        try {
          if (subscriber !== null) {
            subscriber.onWorkStarted(interactions, threadID);
          }
        } finally {
          try {
            returnValue = callback();
          } finally {
            exports.__interactionsRef.current = prevInteractions;

            try {
              if (subscriber !== null) {
                subscriber.onWorkStopped(interactions, threadID);
              }
            } finally {
              interaction.__count--; // If no async work was scheduled for this interaction,
              // Notify subscribers that it's completed.

              if (subscriber !== null && interaction.__count === 0) {
                subscriber.onInteractionScheduledWorkCompleted(interaction);
              }
            }
          }
        }
      }

      return returnValue;
    }

    function unstable_wrap(callback) {
      var threadID = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : DEFAULT_THREAD_ID;

      if (!enableSchedulerTracing) {
        return callback;
      }

      var wrappedInteractions = exports.__interactionsRef.current;
      var subscriber = exports.__subscriberRef.current;

      if (subscriber !== null) {
        subscriber.onWorkScheduled(wrappedInteractions, threadID);
      } // Update the pending async work count for the current interactions.
      // Update after calling subscribers in case of error.


      wrappedInteractions.forEach(function (interaction) {
        interaction.__count++;
      });
      var hasRun = false;

      function wrapped() {
        var prevInteractions = exports.__interactionsRef.current;
        exports.__interactionsRef.current = wrappedInteractions;
        subscriber = exports.__subscriberRef.current;

        try {
          var returnValue;

          try {
            if (subscriber !== null) {
              subscriber.onWorkStarted(wrappedInteractions, threadID);
            }
          } finally {
            try {
              returnValue = callback.apply(undefined, arguments);
            } finally {
              exports.__interactionsRef.current = prevInteractions;

              if (subscriber !== null) {
                subscriber.onWorkStopped(wrappedInteractions, threadID);
              }
            }
          }

          return returnValue;
        } finally {
          if (!hasRun) {
            // We only expect a wrapped function to be executed once,
            // But in the event that it's executed more than once–
            // Only decrement the outstanding interaction counts once.
            hasRun = true; // Update pending async counts for all wrapped interactions.
            // If this was the last scheduled async work for any of them,
            // Mark them as completed.

            wrappedInteractions.forEach(function (interaction) {
              interaction.__count--;

              if (subscriber !== null && interaction.__count === 0) {
                subscriber.onInteractionScheduledWorkCompleted(interaction);
              }
            });
          }
        }
      }

      wrapped.cancel = function cancel() {
        subscriber = exports.__subscriberRef.current;

        try {
          if (subscriber !== null) {
            subscriber.onWorkCanceled(wrappedInteractions, threadID);
          }
        } finally {
          // Update pending async counts for all wrapped interactions.
          // If this was the last scheduled async work for any of them,
          // Mark them as completed.
          wrappedInteractions.forEach(function (interaction) {
            interaction.__count--;

            if (subscriber && interaction.__count === 0) {
              subscriber.onInteractionScheduledWorkCompleted(interaction);
            }
          });
        }
      };

      return wrapped;
    }

    var subscribers = null;

    if (enableSchedulerTracing) {
      subscribers = new Set();
    }

    function unstable_subscribe(subscriber) {
      if (enableSchedulerTracing) {
        subscribers.add(subscriber);

        if (subscribers.size === 1) {
          exports.__subscriberRef.current = {
            onInteractionScheduledWorkCompleted: onInteractionScheduledWorkCompleted,
            onInteractionTraced: onInteractionTraced,
            onWorkCanceled: onWorkCanceled,
            onWorkScheduled: onWorkScheduled,
            onWorkStarted: onWorkStarted,
            onWorkStopped: onWorkStopped
          };
        }
      }
    }

    function unstable_unsubscribe(subscriber) {
      if (enableSchedulerTracing) {
        subscribers.delete(subscriber);

        if (subscribers.size === 0) {
          exports.__subscriberRef.current = null;
        }
      }
    }

    function onInteractionTraced(interaction) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onInteractionTraced(interaction);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    function onInteractionScheduledWorkCompleted(interaction) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onInteractionScheduledWorkCompleted(interaction);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    function onWorkScheduled(interactions, threadID) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onWorkScheduled(interactions, threadID);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    function onWorkStarted(interactions, threadID) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onWorkStarted(interactions, threadID);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    function onWorkStopped(interactions, threadID) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onWorkStopped(interactions, threadID);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    function onWorkCanceled(interactions, threadID) {
      var didCatchError = false;
      var caughtError = null;
      subscribers.forEach(function (subscriber) {
        try {
          subscriber.onWorkCanceled(interactions, threadID);
        } catch (error) {
          if (!didCatchError) {
            didCatchError = true;
            caughtError = error;
          }
        }
      });

      if (didCatchError) {
        throw caughtError;
      }
    }

    exports.unstable_clear = unstable_clear;
    exports.unstable_getCurrent = unstable_getCurrent;
    exports.unstable_getThreadID = unstable_getThreadID;
    exports.unstable_trace = unstable_trace;
    exports.unstable_wrap = unstable_wrap;
    exports.unstable_subscribe = unstable_subscribe;
    exports.unstable_unsubscribe = unstable_unsubscribe;
  })();
}
},{}],"node_modules/scheduler/tracing.js":[function(require,module,exports) {
'use strict';

if ("development" === 'production') {
  module.exports = require('./cjs/scheduler-tracing.production.min.js');
} else {
  module.exports = require('./cjs/scheduler-tracing.development.js');
}
},{"./cjs/scheduler-tracing.development.js":"node_modules/scheduler/cjs/scheduler-tracing.development.js"}],"node_modules/react-dom/cjs/react-dom.development.js":[function(require,module,exports) {
/** @license React v16.12.0
 * react-dom.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

if ("development" !== "production") {
  (function () {
    'use strict';

    var React = require('react');

    var _assign = require('object-assign');

    var Scheduler = require('scheduler');

    var checkPropTypes = require('prop-types/checkPropTypes');

    var tracing = require('scheduler/tracing'); // Do not require this module directly! Use normal `invariant` calls with
    // template literal strings. The messages will be replaced with error codes
    // during build.

    /**
     * Use invariant() to assert state which your program assumes to be true.
     *
     * Provide sprintf-style format (only %s is supported) and arguments
     * to provide information about what broke and what you were
     * expecting.
     *
     * The invariant message will be stripped in production, but the invariant
     * will remain to ensure logic does not differ in production.
     */


    if (!React) {
      {
        throw Error("ReactDOM was loaded before React. Make sure you load the React package before loading ReactDOM.");
      }
    }
    /**
     * Injectable ordering of event plugins.
     */


    var eventPluginOrder = null;
    /**
     * Injectable mapping from names to event plugin modules.
     */

    var namesToPlugins = {};
    /**
     * Recomputes the plugin list using the injected plugins and plugin ordering.
     *
     * @private
     */

    function recomputePluginOrdering() {
      if (!eventPluginOrder) {
        // Wait until an `eventPluginOrder` is injected.
        return;
      }

      for (var pluginName in namesToPlugins) {
        var pluginModule = namesToPlugins[pluginName];
        var pluginIndex = eventPluginOrder.indexOf(pluginName);

        if (!(pluginIndex > -1)) {
          {
            throw Error("EventPluginRegistry: Cannot inject event plugins that do not exist in the plugin ordering, `" + pluginName + "`.");
          }
        }

        if (plugins[pluginIndex]) {
          continue;
        }

        if (!pluginModule.extractEvents) {
          {
            throw Error("EventPluginRegistry: Event plugins must implement an `extractEvents` method, but `" + pluginName + "` does not.");
          }
        }

        plugins[pluginIndex] = pluginModule;
        var publishedEvents = pluginModule.eventTypes;

        for (var eventName in publishedEvents) {
          if (!publishEventForPlugin(publishedEvents[eventName], pluginModule, eventName)) {
            {
              throw Error("EventPluginRegistry: Failed to publish event `" + eventName + "` for plugin `" + pluginName + "`.");
            }
          }
        }
      }
    }
    /**
     * Publishes an event so that it can be dispatched by the supplied plugin.
     *
     * @param {object} dispatchConfig Dispatch configuration for the event.
     * @param {object} PluginModule Plugin publishing the event.
     * @return {boolean} True if the event was successfully published.
     * @private
     */


    function publishEventForPlugin(dispatchConfig, pluginModule, eventName) {
      if (!!eventNameDispatchConfigs.hasOwnProperty(eventName)) {
        {
          throw Error("EventPluginHub: More than one plugin attempted to publish the same event name, `" + eventName + "`.");
        }
      }

      eventNameDispatchConfigs[eventName] = dispatchConfig;
      var phasedRegistrationNames = dispatchConfig.phasedRegistrationNames;

      if (phasedRegistrationNames) {
        for (var phaseName in phasedRegistrationNames) {
          if (phasedRegistrationNames.hasOwnProperty(phaseName)) {
            var phasedRegistrationName = phasedRegistrationNames[phaseName];
            publishRegistrationName(phasedRegistrationName, pluginModule, eventName);
          }
        }

        return true;
      } else if (dispatchConfig.registrationName) {
        publishRegistrationName(dispatchConfig.registrationName, pluginModule, eventName);
        return true;
      }

      return false;
    }
    /**
     * Publishes a registration name that is used to identify dispatched events.
     *
     * @param {string} registrationName Registration name to add.
     * @param {object} PluginModule Plugin publishing the event.
     * @private
     */


    function publishRegistrationName(registrationName, pluginModule, eventName) {
      if (!!registrationNameModules[registrationName]) {
        {
          throw Error("EventPluginHub: More than one plugin attempted to publish the same registration name, `" + registrationName + "`.");
        }
      }

      registrationNameModules[registrationName] = pluginModule;
      registrationNameDependencies[registrationName] = pluginModule.eventTypes[eventName].dependencies;
      {
        var lowerCasedName = registrationName.toLowerCase();
        possibleRegistrationNames[lowerCasedName] = registrationName;

        if (registrationName === 'onDoubleClick') {
          possibleRegistrationNames.ondblclick = registrationName;
        }
      }
    }
    /**
     * Registers plugins so that they can extract and dispatch events.
     *
     * @see {EventPluginHub}
     */

    /**
     * Ordered list of injected plugins.
     */


    var plugins = [];
    /**
     * Mapping from event name to dispatch config
     */

    var eventNameDispatchConfigs = {};
    /**
     * Mapping from registration name to plugin module
     */

    var registrationNameModules = {};
    /**
     * Mapping from registration name to event name
     */

    var registrationNameDependencies = {};
    /**
     * Mapping from lowercase registration names to the properly cased version,
     * used to warn in the case of missing event handlers. Available
     * only in true.
     * @type {Object}
     */

    var possibleRegistrationNames = {}; // Trust the developer to only use possibleRegistrationNames in true

    /**
     * Injects an ordering of plugins (by plugin name). This allows the ordering
     * to be decoupled from injection of the actual plugins so that ordering is
     * always deterministic regardless of packaging, on-the-fly injection, etc.
     *
     * @param {array} InjectedEventPluginOrder
     * @internal
     * @see {EventPluginHub.injection.injectEventPluginOrder}
     */

    function injectEventPluginOrder(injectedEventPluginOrder) {
      if (!!eventPluginOrder) {
        {
          throw Error("EventPluginRegistry: Cannot inject event plugin ordering more than once. You are likely trying to load more than one copy of React.");
        }
      } // Clone the ordering so it cannot be dynamically mutated.


      eventPluginOrder = Array.prototype.slice.call(injectedEventPluginOrder);
      recomputePluginOrdering();
    }
    /**
     * Injects plugins to be used by `EventPluginHub`. The plugin names must be
     * in the ordering injected by `injectEventPluginOrder`.
     *
     * Plugins can be injected as part of page initialization or on-the-fly.
     *
     * @param {object} injectedNamesToPlugins Map from names to plugin modules.
     * @internal
     * @see {EventPluginHub.injection.injectEventPluginsByName}
     */


    function injectEventPluginsByName(injectedNamesToPlugins) {
      var isOrderingDirty = false;

      for (var pluginName in injectedNamesToPlugins) {
        if (!injectedNamesToPlugins.hasOwnProperty(pluginName)) {
          continue;
        }

        var pluginModule = injectedNamesToPlugins[pluginName];

        if (!namesToPlugins.hasOwnProperty(pluginName) || namesToPlugins[pluginName] !== pluginModule) {
          if (!!namesToPlugins[pluginName]) {
            {
              throw Error("EventPluginRegistry: Cannot inject two different event plugins using the same name, `" + pluginName + "`.");
            }
          }

          namesToPlugins[pluginName] = pluginModule;
          isOrderingDirty = true;
        }
      }

      if (isOrderingDirty) {
        recomputePluginOrdering();
      }
    }

    var invokeGuardedCallbackImpl = function (name, func, context, a, b, c, d, e, f) {
      var funcArgs = Array.prototype.slice.call(arguments, 3);

      try {
        func.apply(context, funcArgs);
      } catch (error) {
        this.onError(error);
      }
    };

    {
      // In DEV mode, we swap out invokeGuardedCallback for a special version
      // that plays more nicely with the browser's DevTools. The idea is to preserve
      // "Pause on exceptions" behavior. Because React wraps all user-provided
      // functions in invokeGuardedCallback, and the production version of
      // invokeGuardedCallback uses a try-catch, all user exceptions are treated
      // like caught exceptions, and the DevTools won't pause unless the developer
      // takes the extra step of enabling pause on caught exceptions. This is
      // unintuitive, though, because even though React has caught the error, from
      // the developer's perspective, the error is uncaught.
      //
      // To preserve the expected "Pause on exceptions" behavior, we don't use a
      // try-catch in DEV. Instead, we synchronously dispatch a fake event to a fake
      // DOM node, and call the user-provided callback from inside an event handler
      // for that fake event. If the callback throws, the error is "captured" using
      // a global event handler. But because the error happens in a different
      // event loop context, it does not interrupt the normal program flow.
      // Effectively, this gives us try-catch behavior without actually using
      // try-catch. Neat!
      // Check that the browser supports the APIs we need to implement our special
      // DEV version of invokeGuardedCallback
      if (typeof window !== 'undefined' && typeof window.dispatchEvent === 'function' && typeof document !== 'undefined' && typeof document.createEvent === 'function') {
        var fakeNode = document.createElement('react');

        var invokeGuardedCallbackDev = function (name, func, context, a, b, c, d, e, f) {
          // If document doesn't exist we know for sure we will crash in this method
          // when we call document.createEvent(). However this can cause confusing
          // errors: https://github.com/facebookincubator/create-react-app/issues/3482
          // So we preemptively throw with a better message instead.
          if (!(typeof document !== 'undefined')) {
            {
              throw Error("The `document` global was defined when React was initialized, but is not defined anymore. This can happen in a test environment if a component schedules an update from an asynchronous callback, but the test has already finished running. To solve this, you can either unmount the component at the end of your test (and ensure that any asynchronous operations get canceled in `componentWillUnmount`), or you can change the test itself to be asynchronous.");
            }
          }

          var evt = document.createEvent('Event'); // Keeps track of whether the user-provided callback threw an error. We
          // set this to true at the beginning, then set it to false right after
          // calling the function. If the function errors, `didError` will never be
          // set to false. This strategy works even if the browser is flaky and
          // fails to call our global error handler, because it doesn't rely on
          // the error event at all.

          var didError = true; // Keeps track of the value of window.event so that we can reset it
          // during the callback to let user code access window.event in the
          // browsers that support it.

          var windowEvent = window.event; // Keeps track of the descriptor of window.event to restore it after event
          // dispatching: https://github.com/facebook/react/issues/13688

          var windowEventDescriptor = Object.getOwnPropertyDescriptor(window, 'event'); // Create an event handler for our fake event. We will synchronously
          // dispatch our fake event using `dispatchEvent`. Inside the handler, we
          // call the user-provided callback.

          var funcArgs = Array.prototype.slice.call(arguments, 3);

          function callCallback() {
            // We immediately remove the callback from event listeners so that
            // nested `invokeGuardedCallback` calls do not clash. Otherwise, a
            // nested call would trigger the fake event handlers of any call higher
            // in the stack.
            fakeNode.removeEventListener(evtType, callCallback, false); // We check for window.hasOwnProperty('event') to prevent the
            // window.event assignment in both IE <= 10 as they throw an error
            // "Member not found" in strict mode, and in Firefox which does not
            // support window.event.

            if (typeof window.event !== 'undefined' && window.hasOwnProperty('event')) {
              window.event = windowEvent;
            }

            func.apply(context, funcArgs);
            didError = false;
          } // Create a global error event handler. We use this to capture the value
          // that was thrown. It's possible that this error handler will fire more
          // than once; for example, if non-React code also calls `dispatchEvent`
          // and a handler for that event throws. We should be resilient to most of
          // those cases. Even if our error event handler fires more than once, the
          // last error event is always used. If the callback actually does error,
          // we know that the last error event is the correct one, because it's not
          // possible for anything else to have happened in between our callback
          // erroring and the code that follows the `dispatchEvent` call below. If
          // the callback doesn't error, but the error event was fired, we know to
          // ignore it because `didError` will be false, as described above.


          var error; // Use this to track whether the error event is ever called.

          var didSetError = false;
          var isCrossOriginError = false;

          function handleWindowError(event) {
            error = event.error;
            didSetError = true;

            if (error === null && event.colno === 0 && event.lineno === 0) {
              isCrossOriginError = true;
            }

            if (event.defaultPrevented) {
              // Some other error handler has prevented default.
              // Browsers silence the error report if this happens.
              // We'll remember this to later decide whether to log it or not.
              if (error != null && typeof error === 'object') {
                try {
                  error._suppressLogging = true;
                } catch (inner) {// Ignore.
                }
              }
            }
          } // Create a fake event type.


          var evtType = "react-" + (name ? name : 'invokeguardedcallback'); // Attach our event handlers

          window.addEventListener('error', handleWindowError);
          fakeNode.addEventListener(evtType, callCallback, false); // Synchronously dispatch our fake event. If the user-provided function
          // errors, it will trigger our global error handler.

          evt.initEvent(evtType, false, false);
          fakeNode.dispatchEvent(evt);

          if (windowEventDescriptor) {
            Object.defineProperty(window, 'event', windowEventDescriptor);
          }

          if (didError) {
            if (!didSetError) {
              // The callback errored, but the error event never fired.
              error = new Error('An error was thrown inside one of your components, but React ' + "doesn't know what it was. This is likely due to browser " + 'flakiness. React does its best to preserve the "Pause on ' + 'exceptions" behavior of the DevTools, which requires some ' + "DEV-mode only tricks. It's possible that these don't work in " + 'your browser. Try triggering the error in production mode, ' + 'or switching to a modern browser. If you suspect that this is ' + 'actually an issue with React, please file an issue.');
            } else if (isCrossOriginError) {
              error = new Error("A cross-origin error was thrown. React doesn't have access to " + 'the actual error object in development. ' + 'See https://fb.me/react-crossorigin-error for more information.');
            }

            this.onError(error);
          } // Remove our event listeners


          window.removeEventListener('error', handleWindowError);
        };

        invokeGuardedCallbackImpl = invokeGuardedCallbackDev;
      }
    }
    var invokeGuardedCallbackImpl$1 = invokeGuardedCallbackImpl;
    var hasError = false;
    var caughtError = null; // Used by event system to capture/rethrow the first error.

    var hasRethrowError = false;
    var rethrowError = null;
    var reporter = {
      onError: function (error) {
        hasError = true;
        caughtError = error;
      }
    };
    /**
     * Call a function while guarding against errors that happens within it.
     * Returns an error if it throws, otherwise null.
     *
     * In production, this is implemented using a try-catch. The reason we don't
     * use a try-catch directly is so that we can swap out a different
     * implementation in DEV mode.
     *
     * @param {String} name of the guard to use for logging or debugging
     * @param {Function} func The function to invoke
     * @param {*} context The context to use when calling the function
     * @param {...*} args Arguments for function
     */

    function invokeGuardedCallback(name, func, context, a, b, c, d, e, f) {
      hasError = false;
      caughtError = null;
      invokeGuardedCallbackImpl$1.apply(reporter, arguments);
    }
    /**
     * Same as invokeGuardedCallback, but instead of returning an error, it stores
     * it in a global so it can be rethrown by `rethrowCaughtError` later.
     * TODO: See if caughtError and rethrowError can be unified.
     *
     * @param {String} name of the guard to use for logging or debugging
     * @param {Function} func The function to invoke
     * @param {*} context The context to use when calling the function
     * @param {...*} args Arguments for function
     */


    function invokeGuardedCallbackAndCatchFirstError(name, func, context, a, b, c, d, e, f) {
      invokeGuardedCallback.apply(this, arguments);

      if (hasError) {
        var error = clearCaughtError();

        if (!hasRethrowError) {
          hasRethrowError = true;
          rethrowError = error;
        }
      }
    }
    /**
     * During execution of guarded functions we will capture the first error which
     * we will rethrow to be handled by the top level error handler.
     */


    function rethrowCaughtError() {
      if (hasRethrowError) {
        var error = rethrowError;
        hasRethrowError = false;
        rethrowError = null;
        throw error;
      }
    }

    function hasCaughtError() {
      return hasError;
    }

    function clearCaughtError() {
      if (hasError) {
        var error = caughtError;
        hasError = false;
        caughtError = null;
        return error;
      } else {
        {
          {
            throw Error("clearCaughtError was called but no error was captured. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }
    }
    /**
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */


    var warningWithoutStack = function () {};

    {
      warningWithoutStack = function (condition, format) {
        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        if (format === undefined) {
          throw new Error('`warningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
        }

        if (args.length > 8) {
          // Check before the condition to catch violations early.
          throw new Error('warningWithoutStack() currently supports at most 8 arguments.');
        }

        if (condition) {
          return;
        }

        if (typeof console !== 'undefined') {
          var argsWithFormat = args.map(function (item) {
            return '' + item;
          });
          argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it
          // breaks IE9: https://github.com/facebook/react/issues/13610

          Function.prototype.apply.call(console.error, console, argsWithFormat);
        }

        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          var argIndex = 0;
          var message = 'Warning: ' + format.replace(/%s/g, function () {
            return args[argIndex++];
          });
          throw new Error(message);
        } catch (x) {}
      };
    }
    var warningWithoutStack$1 = warningWithoutStack;
    var getFiberCurrentPropsFromNode = null;
    var getInstanceFromNode = null;
    var getNodeFromInstance = null;

    function setComponentTree(getFiberCurrentPropsFromNodeImpl, getInstanceFromNodeImpl, getNodeFromInstanceImpl) {
      getFiberCurrentPropsFromNode = getFiberCurrentPropsFromNodeImpl;
      getInstanceFromNode = getInstanceFromNodeImpl;
      getNodeFromInstance = getNodeFromInstanceImpl;
      {
        !(getNodeFromInstance && getInstanceFromNode) ? warningWithoutStack$1(false, 'EventPluginUtils.setComponentTree(...): Injected ' + 'module is missing getNodeFromInstance or getInstanceFromNode.') : void 0;
      }
    }

    var validateEventDispatches;
    {
      validateEventDispatches = function (event) {
        var dispatchListeners = event._dispatchListeners;
        var dispatchInstances = event._dispatchInstances;
        var listenersIsArr = Array.isArray(dispatchListeners);
        var listenersLen = listenersIsArr ? dispatchListeners.length : dispatchListeners ? 1 : 0;
        var instancesIsArr = Array.isArray(dispatchInstances);
        var instancesLen = instancesIsArr ? dispatchInstances.length : dispatchInstances ? 1 : 0;
        !(instancesIsArr === listenersIsArr && instancesLen === listenersLen) ? warningWithoutStack$1(false, 'EventPluginUtils: Invalid `event`.') : void 0;
      };
    }
    /**
     * Dispatch the event to the listener.
     * @param {SyntheticEvent} event SyntheticEvent to handle
     * @param {function} listener Application-level callback
     * @param {*} inst Internal component instance
     */

    function executeDispatch(event, listener, inst) {
      var type = event.type || 'unknown-event';
      event.currentTarget = getNodeFromInstance(inst);
      invokeGuardedCallbackAndCatchFirstError(type, listener, undefined, event);
      event.currentTarget = null;
    }
    /**
     * Standard/simple iteration through an event's collected dispatches.
     */


    function executeDispatchesInOrder(event) {
      var dispatchListeners = event._dispatchListeners;
      var dispatchInstances = event._dispatchInstances;
      {
        validateEventDispatches(event);
      }

      if (Array.isArray(dispatchListeners)) {
        for (var i = 0; i < dispatchListeners.length; i++) {
          if (event.isPropagationStopped()) {
            break;
          } // Listeners and Instances are two parallel arrays that are always in sync.


          executeDispatch(event, dispatchListeners[i], dispatchInstances[i]);
        }
      } else if (dispatchListeners) {
        executeDispatch(event, dispatchListeners, dispatchInstances);
      }

      event._dispatchListeners = null;
      event._dispatchInstances = null;
    }
    /**
     * @see executeDispatchesInOrderStopAtTrueImpl
     */

    /**
     * Execution of a "direct" dispatch - there must be at most one dispatch
     * accumulated on the event or it is considered an error. It doesn't really make
     * sense for an event with multiple dispatches (bubbled) to keep track of the
     * return values at each dispatch execution, but it does tend to make sense when
     * dealing with "direct" dispatches.
     *
     * @return {*} The return value of executing the single dispatch.
     */

    /**
     * @param {SyntheticEvent} event
     * @return {boolean} True iff number of dispatches accumulated is greater than 0.
     */

    /**
     * Accumulates items that must not be null or undefined into the first one. This
     * is used to conserve memory by avoiding array allocations, and thus sacrifices
     * API cleanness. Since `current` can be null before being passed in and not
     * null after this function, make sure to assign it back to `current`:
     *
     * `a = accumulateInto(a, b);`
     *
     * This API should be sparingly used. Try `accumulate` for something cleaner.
     *
     * @return {*|array<*>} An accumulation of items.
     */


    function accumulateInto(current, next) {
      if (!(next != null)) {
        {
          throw Error("accumulateInto(...): Accumulated items must not be null or undefined.");
        }
      }

      if (current == null) {
        return next;
      } // Both are not empty. Warning: Never call x.concat(y) when you are not
      // certain that x is an Array (x could be a string with concat method).


      if (Array.isArray(current)) {
        if (Array.isArray(next)) {
          current.push.apply(current, next);
          return current;
        }

        current.push(next);
        return current;
      }

      if (Array.isArray(next)) {
        // A bit too dangerous to mutate `next`.
        return [current].concat(next);
      }

      return [current, next];
    }
    /**
     * @param {array} arr an "accumulation" of items which is either an Array or
     * a single item. Useful when paired with the `accumulate` module. This is a
     * simple utility that allows us to reason about a collection of items, but
     * handling the case when there is exactly one item (and we do not need to
     * allocate an array).
     * @param {function} cb Callback invoked with each element or a collection.
     * @param {?} [scope] Scope used as `this` in a callback.
     */


    function forEachAccumulated(arr, cb, scope) {
      if (Array.isArray(arr)) {
        arr.forEach(cb, scope);
      } else if (arr) {
        cb.call(scope, arr);
      }
    }
    /**
     * Internal queue of events that have accumulated their dispatches and are
     * waiting to have their dispatches executed.
     */


    var eventQueue = null;
    /**
     * Dispatches an event and releases it back into the pool, unless persistent.
     *
     * @param {?object} event Synthetic event to be dispatched.
     * @private
     */

    var executeDispatchesAndRelease = function (event) {
      if (event) {
        executeDispatchesInOrder(event);

        if (!event.isPersistent()) {
          event.constructor.release(event);
        }
      }
    };

    var executeDispatchesAndReleaseTopLevel = function (e) {
      return executeDispatchesAndRelease(e);
    };

    function runEventsInBatch(events) {
      if (events !== null) {
        eventQueue = accumulateInto(eventQueue, events);
      } // Set `eventQueue` to null before processing it so that we can tell if more
      // events get enqueued while processing.


      var processingEventQueue = eventQueue;
      eventQueue = null;

      if (!processingEventQueue) {
        return;
      }

      forEachAccumulated(processingEventQueue, executeDispatchesAndReleaseTopLevel);

      if (!!eventQueue) {
        {
          throw Error("processEventQueue(): Additional events were enqueued while processing an event queue. Support for this has not yet been implemented.");
        }
      } // This would be a good time to rethrow if any of the event handlers threw.


      rethrowCaughtError();
    }

    function isInteractive(tag) {
      return tag === 'button' || tag === 'input' || tag === 'select' || tag === 'textarea';
    }

    function shouldPreventMouseEvent(name, type, props) {
      switch (name) {
        case 'onClick':
        case 'onClickCapture':
        case 'onDoubleClick':
        case 'onDoubleClickCapture':
        case 'onMouseDown':
        case 'onMouseDownCapture':
        case 'onMouseMove':
        case 'onMouseMoveCapture':
        case 'onMouseUp':
        case 'onMouseUpCapture':
          return !!(props.disabled && isInteractive(type));

        default:
          return false;
      }
    }
    /**
     * This is a unified interface for event plugins to be installed and configured.
     *
     * Event plugins can implement the following properties:
     *
     *   `extractEvents` {function(string, DOMEventTarget, string, object): *}
     *     Required. When a top-level event is fired, this method is expected to
     *     extract synthetic events that will in turn be queued and dispatched.
     *
     *   `eventTypes` {object}
     *     Optional, plugins that fire events must publish a mapping of registration
     *     names that are used to register listeners. Values of this mapping must
     *     be objects that contain `registrationName` or `phasedRegistrationNames`.
     *
     *   `executeDispatch` {function(object, function, string)}
     *     Optional, allows plugins to override how an event gets dispatched. By
     *     default, the listener is simply invoked.
     *
     * Each plugin that is injected into `EventsPluginHub` is immediately operable.
     *
     * @public
     */

    /**
     * Methods for injecting dependencies.
     */


    var injection = {
      /**
       * @param {array} InjectedEventPluginOrder
       * @public
       */
      injectEventPluginOrder: injectEventPluginOrder,

      /**
       * @param {object} injectedNamesToPlugins Map from names to plugin modules.
       */
      injectEventPluginsByName: injectEventPluginsByName
    };
    /**
     * @param {object} inst The instance, which is the source of events.
     * @param {string} registrationName Name of listener (e.g. `onClick`).
     * @return {?function} The stored callback.
     */

    function getListener(inst, registrationName) {
      var listener; // TODO: shouldPreventMouseEvent is DOM-specific and definitely should not
      // live here; needs to be moved to a better place soon

      var stateNode = inst.stateNode;

      if (!stateNode) {
        // Work in progress (ex: onload events in incremental mode).
        return null;
      }

      var props = getFiberCurrentPropsFromNode(stateNode);

      if (!props) {
        // Work in progress.
        return null;
      }

      listener = props[registrationName];

      if (shouldPreventMouseEvent(registrationName, inst.type, props)) {
        return null;
      }

      if (!(!listener || typeof listener === 'function')) {
        {
          throw Error("Expected `" + registrationName + "` listener to be a function, instead got a value of `" + typeof listener + "` type.");
        }
      }

      return listener;
    }
    /**
     * Allows registered plugins an opportunity to extract events from top-level
     * native browser events.
     *
     * @return {*} An accumulation of synthetic events.
     * @internal
     */


    function extractPluginEvents(topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
      var events = null;

      for (var i = 0; i < plugins.length; i++) {
        // Not every plugin in the ordering may be loaded at runtime.
        var possiblePlugin = plugins[i];

        if (possiblePlugin) {
          var extractedEvents = possiblePlugin.extractEvents(topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags);

          if (extractedEvents) {
            events = accumulateInto(events, extractedEvents);
          }
        }
      }

      return events;
    }

    function runExtractedPluginEventsInBatch(topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
      var events = extractPluginEvents(topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags);
      runEventsInBatch(events);
    }

    var FunctionComponent = 0;
    var ClassComponent = 1;
    var IndeterminateComponent = 2; // Before we know whether it is function or class

    var HostRoot = 3; // Root of a host tree. Could be nested inside another node.

    var HostPortal = 4; // A subtree. Could be an entry point to a different renderer.

    var HostComponent = 5;
    var HostText = 6;
    var Fragment = 7;
    var Mode = 8;
    var ContextConsumer = 9;
    var ContextProvider = 10;
    var ForwardRef = 11;
    var Profiler = 12;
    var SuspenseComponent = 13;
    var MemoComponent = 14;
    var SimpleMemoComponent = 15;
    var LazyComponent = 16;
    var IncompleteClassComponent = 17;
    var DehydratedFragment = 18;
    var SuspenseListComponent = 19;
    var FundamentalComponent = 20;
    var ScopeComponent = 21;
    var ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED; // Prevent newer renderers from RTE when used with older react package versions.
    // Current owner and dispatcher used to share the same ref,
    // but PR #14548 split them out to better support the react-debug-tools package.

    if (!ReactSharedInternals.hasOwnProperty('ReactCurrentDispatcher')) {
      ReactSharedInternals.ReactCurrentDispatcher = {
        current: null
      };
    }

    if (!ReactSharedInternals.hasOwnProperty('ReactCurrentBatchConfig')) {
      ReactSharedInternals.ReactCurrentBatchConfig = {
        suspense: null
      };
    }

    var BEFORE_SLASH_RE = /^(.*)[\\\/]/;

    var describeComponentFrame = function (name, source, ownerName) {
      var sourceInfo = '';

      if (source) {
        var path = source.fileName;
        var fileName = path.replace(BEFORE_SLASH_RE, '');
        {
          // In DEV, include code for a common special case:
          // prefer "folder/index.js" instead of just "index.js".
          if (/^index\./.test(fileName)) {
            var match = path.match(BEFORE_SLASH_RE);

            if (match) {
              var pathBeforeSlash = match[1];

              if (pathBeforeSlash) {
                var folderName = pathBeforeSlash.replace(BEFORE_SLASH_RE, '');
                fileName = folderName + '/' + fileName;
              }
            }
          }
        }
        sourceInfo = ' (at ' + fileName + ':' + source.lineNumber + ')';
      } else if (ownerName) {
        sourceInfo = ' (created by ' + ownerName + ')';
      }

      return '\n    in ' + (name || 'Unknown') + sourceInfo;
    }; // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
    // nor polyfill, then a plain number is used for performance.


    var hasSymbol = typeof Symbol === 'function' && Symbol.for;
    var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
    var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
    var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
    var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
    var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
    var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
    var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
    // (unstable) APIs that have been removed. Can we remove the symbols?

    var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
    var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
    var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
    var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
    var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
    var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
    var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
    var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
    var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;
    var MAYBE_ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator';

    function getIteratorFn(maybeIterable) {
      if (maybeIterable === null || typeof maybeIterable !== 'object') {
        return null;
      }

      var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];

      if (typeof maybeIterator === 'function') {
        return maybeIterator;
      }

      return null;
    }
    /**
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */


    var warning = warningWithoutStack$1;
    {
      warning = function (condition, format) {
        if (condition) {
          return;
        }

        var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
        var stack = ReactDebugCurrentFrame.getStackAddendum(); // eslint-disable-next-line react-internal/warning-and-invariant-args

        for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          args[_key - 2] = arguments[_key];
        }

        warningWithoutStack$1.apply(void 0, [false, format + '%s'].concat(args, [stack]));
      };
    }
    var warning$1 = warning;
    var Uninitialized = -1;
    var Pending = 0;
    var Resolved = 1;
    var Rejected = 2;

    function refineResolvedLazyComponent(lazyComponent) {
      return lazyComponent._status === Resolved ? lazyComponent._result : null;
    }

    function initializeLazyComponentType(lazyComponent) {
      if (lazyComponent._status === Uninitialized) {
        lazyComponent._status = Pending;
        var ctor = lazyComponent._ctor;
        var thenable = ctor();
        lazyComponent._result = thenable;
        thenable.then(function (moduleObject) {
          if (lazyComponent._status === Pending) {
            var defaultExport = moduleObject.default;
            {
              if (defaultExport === undefined) {
                warning$1(false, 'lazy: Expected the result of a dynamic import() call. ' + 'Instead received: %s\n\nYour code should look like: \n  ' + "const MyComponent = lazy(() => import('./MyComponent'))", moduleObject);
              }
            }
            lazyComponent._status = Resolved;
            lazyComponent._result = defaultExport;
          }
        }, function (error) {
          if (lazyComponent._status === Pending) {
            lazyComponent._status = Rejected;
            lazyComponent._result = error;
          }
        });
      }
    }

    function getWrappedName(outerType, innerType, wrapperName) {
      var functionName = innerType.displayName || innerType.name || '';
      return outerType.displayName || (functionName !== '' ? wrapperName + "(" + functionName + ")" : wrapperName);
    }

    function getComponentName(type) {
      if (type == null) {
        // Host root, text node or just invalid type.
        return null;
      }

      {
        if (typeof type.tag === 'number') {
          warningWithoutStack$1(false, 'Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');
        }
      }

      if (typeof type === 'function') {
        return type.displayName || type.name || null;
      }

      if (typeof type === 'string') {
        return type;
      }

      switch (type) {
        case REACT_FRAGMENT_TYPE:
          return 'Fragment';

        case REACT_PORTAL_TYPE:
          return 'Portal';

        case REACT_PROFILER_TYPE:
          return "Profiler";

        case REACT_STRICT_MODE_TYPE:
          return 'StrictMode';

        case REACT_SUSPENSE_TYPE:
          return 'Suspense';

        case REACT_SUSPENSE_LIST_TYPE:
          return 'SuspenseList';
      }

      if (typeof type === 'object') {
        switch (type.$$typeof) {
          case REACT_CONTEXT_TYPE:
            return 'Context.Consumer';

          case REACT_PROVIDER_TYPE:
            return 'Context.Provider';

          case REACT_FORWARD_REF_TYPE:
            return getWrappedName(type, type.render, 'ForwardRef');

          case REACT_MEMO_TYPE:
            return getComponentName(type.type);

          case REACT_LAZY_TYPE:
            {
              var thenable = type;
              var resolvedThenable = refineResolvedLazyComponent(thenable);

              if (resolvedThenable) {
                return getComponentName(resolvedThenable);
              }

              break;
            }
        }
      }

      return null;
    }

    var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;

    function describeFiber(fiber) {
      switch (fiber.tag) {
        case HostRoot:
        case HostPortal:
        case HostText:
        case Fragment:
        case ContextProvider:
        case ContextConsumer:
          return '';

        default:
          var owner = fiber._debugOwner;
          var source = fiber._debugSource;
          var name = getComponentName(fiber.type);
          var ownerName = null;

          if (owner) {
            ownerName = getComponentName(owner.type);
          }

          return describeComponentFrame(name, source, ownerName);
      }
    }

    function getStackByFiberInDevAndProd(workInProgress) {
      var info = '';
      var node = workInProgress;

      do {
        info += describeFiber(node);
        node = node.return;
      } while (node);

      return info;
    }

    var current = null;
    var phase = null;

    function getCurrentFiberOwnerNameInDevOrNull() {
      {
        if (current === null) {
          return null;
        }

        var owner = current._debugOwner;

        if (owner !== null && typeof owner !== 'undefined') {
          return getComponentName(owner.type);
        }
      }
      return null;
    }

    function getCurrentFiberStackInDev() {
      {
        if (current === null) {
          return '';
        } // Safe because if current fiber exists, we are reconciling,
        // and it is guaranteed to be the work-in-progress version.


        return getStackByFiberInDevAndProd(current);
      }
      return '';
    }

    function resetCurrentFiber() {
      {
        ReactDebugCurrentFrame.getCurrentStack = null;
        current = null;
        phase = null;
      }
    }

    function setCurrentFiber(fiber) {
      {
        ReactDebugCurrentFrame.getCurrentStack = getCurrentFiberStackInDev;
        current = fiber;
        phase = null;
      }
    }

    function setCurrentPhase(lifeCyclePhase) {
      {
        phase = lifeCyclePhase;
      }
    }

    var canUseDOM = !!(typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined');

    function endsWith(subject, search) {
      var length = subject.length;
      return subject.substring(length - search.length, length) === search;
    }

    var PLUGIN_EVENT_SYSTEM = 1;
    var RESPONDER_EVENT_SYSTEM = 1 << 1;
    var IS_PASSIVE = 1 << 2;
    var IS_ACTIVE = 1 << 3;
    var PASSIVE_NOT_SUPPORTED = 1 << 4;
    var IS_REPLAYED = 1 << 5;
    var restoreImpl = null;
    var restoreTarget = null;
    var restoreQueue = null;

    function restoreStateOfTarget(target) {
      // We perform this translation at the end of the event loop so that we
      // always receive the correct fiber here
      var internalInstance = getInstanceFromNode(target);

      if (!internalInstance) {
        // Unmounted
        return;
      }

      if (!(typeof restoreImpl === 'function')) {
        {
          throw Error("setRestoreImplementation() needs to be called to handle a target for controlled events. This error is likely caused by a bug in React. Please file an issue.");
        }
      }

      var props = getFiberCurrentPropsFromNode(internalInstance.stateNode);
      restoreImpl(internalInstance.stateNode, internalInstance.type, props);
    }

    function setRestoreImplementation(impl) {
      restoreImpl = impl;
    }

    function enqueueStateRestore(target) {
      if (restoreTarget) {
        if (restoreQueue) {
          restoreQueue.push(target);
        } else {
          restoreQueue = [target];
        }
      } else {
        restoreTarget = target;
      }
    }

    function needsStateRestore() {
      return restoreTarget !== null || restoreQueue !== null;
    }

    function restoreStateIfNeeded() {
      if (!restoreTarget) {
        return;
      }

      var target = restoreTarget;
      var queuedTargets = restoreQueue;
      restoreTarget = null;
      restoreQueue = null;
      restoreStateOfTarget(target);

      if (queuedTargets) {
        for (var i = 0; i < queuedTargets.length; i++) {
          restoreStateOfTarget(queuedTargets[i]);
        }
      }
    }

    var enableUserTimingAPI = true; // Helps identify side effects in render-phase lifecycle hooks and setState
    // reducers by double invoking them in Strict Mode.

    var debugRenderPhaseSideEffectsForStrictMode = true; // To preserve the "Pause on caught exceptions" behavior of the debugger, we
    // replay the begin phase of a failed component inside invokeGuardedCallback.

    var replayFailedUnitOfWorkWithInvokeGuardedCallback = true; // Warn about deprecated, async-unsafe lifecycles; relates to RFC #6:

    var warnAboutDeprecatedLifecycles = true; // Gather advanced timing metrics for Profiler subtrees.

    var enableProfilerTimer = true; // Trace which interactions trigger each commit.

    var enableSchedulerTracing = true; // SSR experiments

    var enableSuspenseServerRenderer = false;
    var enableSelectiveHydration = false; // Only used in www builds.
    // Only used in www builds.
    // Disable javascript: URL strings in href for XSS protection.

    var disableJavaScriptURLs = false; // React Fire: prevent the value and checked attributes from syncing
    // with their related DOM properties

    var disableInputAttributeSyncing = false; // These APIs will no longer be "unstable" in the upcoming 16.7 release,
    // Control this behavior with a flag to support 16.6 minor releases in the meanwhile.

    var exposeConcurrentModeAPIs = false;
    var warnAboutShorthandPropertyCollision = false; // Experimental React Flare event system and event components support.

    var enableFlareAPI = false; // Experimental Host Component support.

    var enableFundamentalAPI = false; // Experimental Scope support.

    var enableScopeAPI = false; // New API for JSX transforms to target - https://github.com/reactjs/rfcs/pull/107
    // We will enforce mocking scheduler with scheduler/unstable_mock at some point. (v17?)
    // Till then, we warn about the missing mock, but still fallback to a legacy mode compatible version

    var warnAboutUnmockedScheduler = false; // For tests, we flush suspense fallbacks in an act scope;
    // *except* in some of our own tests, where we test incremental loading states.

    var flushSuspenseFallbacksInTests = true; // Add a callback property to suspense to notify which promises are currently
    // in the update queue. This allows reporting and tracing of what is causing
    // the user to see a loading state.
    // Also allows hydration callbacks to fire when a dehydrated boundary gets
    // hydrated or deleted.

    var enableSuspenseCallback = false; // Part of the simplification of React.createElement so we can eventually move
    // from React.createElement to React.jsx
    // https://github.com/reactjs/rfcs/blob/createlement-rfc/text/0000-create-element-changes.md

    var warnAboutDefaultPropsOnFunctionComponents = false;
    var warnAboutStringRefs = false;
    var disableLegacyContext = false;
    var disableSchedulerTimeoutBasedOnReactExpirationTime = false;
    var enableTrustedTypesIntegration = false; // Flag to turn event.target and event.currentTarget in ReactNative from a reactTag to a component instance
    // the renderer. Such as when we're dispatching events or if third party
    // libraries need to call batchedUpdates. Eventually, this API will go away when
    // everything is batched by default. We'll then have a similar API to opt-out of
    // scheduled work and instead do synchronous work.
    // Defaults

    var batchedUpdatesImpl = function (fn, bookkeeping) {
      return fn(bookkeeping);
    };

    var discreteUpdatesImpl = function (fn, a, b, c) {
      return fn(a, b, c);
    };

    var flushDiscreteUpdatesImpl = function () {};

    var batchedEventUpdatesImpl = batchedUpdatesImpl;
    var isInsideEventHandler = false;
    var isBatchingEventUpdates = false;

    function finishEventHandler() {
      // Here we wait until all updates have propagated, which is important
      // when using controlled components within layers:
      // https://github.com/facebook/react/issues/1698
      // Then we restore state of any controlled component.
      var controlledComponentsHavePendingUpdates = needsStateRestore();

      if (controlledComponentsHavePendingUpdates) {
        // If a controlled event was fired, we may need to restore the state of
        // the DOM node back to the controlled value. This is necessary when React
        // bails out of the update without touching the DOM.
        flushDiscreteUpdatesImpl();
        restoreStateIfNeeded();
      }
    }

    function batchedUpdates(fn, bookkeeping) {
      if (isInsideEventHandler) {
        // If we are currently inside another batch, we need to wait until it
        // fully completes before restoring state.
        return fn(bookkeeping);
      }

      isInsideEventHandler = true;

      try {
        return batchedUpdatesImpl(fn, bookkeeping);
      } finally {
        isInsideEventHandler = false;
        finishEventHandler();
      }
    }

    function batchedEventUpdates(fn, a, b) {
      if (isBatchingEventUpdates) {
        // If we are currently inside another batch, we need to wait until it
        // fully completes before restoring state.
        return fn(a, b);
      }

      isBatchingEventUpdates = true;

      try {
        return batchedEventUpdatesImpl(fn, a, b);
      } finally {
        isBatchingEventUpdates = false;
        finishEventHandler();
      }
    } // This is for the React Flare event system


    function executeUserEventHandler(fn, value) {
      var previouslyInEventHandler = isInsideEventHandler;

      try {
        isInsideEventHandler = true;
        var type = typeof value === 'object' && value !== null ? value.type : '';
        invokeGuardedCallbackAndCatchFirstError(type, fn, undefined, value);
      } finally {
        isInsideEventHandler = previouslyInEventHandler;
      }
    }

    function discreteUpdates(fn, a, b, c) {
      var prevIsInsideEventHandler = isInsideEventHandler;
      isInsideEventHandler = true;

      try {
        return discreteUpdatesImpl(fn, a, b, c);
      } finally {
        isInsideEventHandler = prevIsInsideEventHandler;

        if (!isInsideEventHandler) {
          finishEventHandler();
        }
      }
    }

    var lastFlushedEventTimeStamp = 0;

    function flushDiscreteUpdatesIfNeeded(timeStamp) {
      // event.timeStamp isn't overly reliable due to inconsistencies in
      // how different browsers have historically provided the time stamp.
      // Some browsers provide high-resolution time stamps for all events,
      // some provide low-resolution time stamps for all events. FF < 52
      // even mixes both time stamps together. Some browsers even report
      // negative time stamps or time stamps that are 0 (iOS9) in some cases.
      // Given we are only comparing two time stamps with equality (!==),
      // we are safe from the resolution differences. If the time stamp is 0
      // we bail-out of preventing the flush, which can affect semantics,
      // such as if an earlier flush removes or adds event listeners that
      // are fired in the subsequent flush. However, this is the same
      // behaviour as we had before this change, so the risks are low.
      if (!isInsideEventHandler && (!enableFlareAPI || timeStamp === 0 || lastFlushedEventTimeStamp !== timeStamp)) {
        lastFlushedEventTimeStamp = timeStamp;
        flushDiscreteUpdatesImpl();
      }
    }

    function setBatchingImplementation(_batchedUpdatesImpl, _discreteUpdatesImpl, _flushDiscreteUpdatesImpl, _batchedEventUpdatesImpl) {
      batchedUpdatesImpl = _batchedUpdatesImpl;
      discreteUpdatesImpl = _discreteUpdatesImpl;
      flushDiscreteUpdatesImpl = _flushDiscreteUpdatesImpl;
      batchedEventUpdatesImpl = _batchedEventUpdatesImpl;
    }

    var DiscreteEvent = 0;
    var UserBlockingEvent = 1;
    var ContinuousEvent = 2; // CommonJS interop named imports.

    var UserBlockingPriority = Scheduler.unstable_UserBlockingPriority;
    var runWithPriority = Scheduler.unstable_runWithPriority;
    var listenToResponderEventTypesImpl;

    function setListenToResponderEventTypes(_listenToResponderEventTypesImpl) {
      listenToResponderEventTypesImpl = _listenToResponderEventTypesImpl;
    }

    var rootEventTypesToEventResponderInstances = new Map();
    var DoNotPropagateToNextResponder = 0;
    var PropagateToNextResponder = 1;
    var currentTimeStamp = 0;
    var currentInstance = null;
    var currentDocument = null;
    var currentPropagationBehavior = DoNotPropagateToNextResponder;
    var eventResponderContext = {
      dispatchEvent: function (eventValue, eventListener, eventPriority) {
        validateResponderContext();
        validateEventValue(eventValue);

        switch (eventPriority) {
          case DiscreteEvent:
            {
              flushDiscreteUpdatesIfNeeded(currentTimeStamp);
              discreteUpdates(function () {
                return executeUserEventHandler(eventListener, eventValue);
              });
              break;
            }

          case UserBlockingEvent:
            {
              runWithPriority(UserBlockingPriority, function () {
                return executeUserEventHandler(eventListener, eventValue);
              });
              break;
            }

          case ContinuousEvent:
            {
              executeUserEventHandler(eventListener, eventValue);
              break;
            }
        }
      },
      isTargetWithinResponder: function (target) {
        validateResponderContext();

        if (target != null) {
          var fiber = getClosestInstanceFromNode(target);
          var responderFiber = currentInstance.fiber;

          while (fiber !== null) {
            if (fiber === responderFiber || fiber.alternate === responderFiber) {
              return true;
            }

            fiber = fiber.return;
          }
        }

        return false;
      },
      isTargetWithinResponderScope: function (target) {
        validateResponderContext();
        var componentInstance = currentInstance;
        var responder = componentInstance.responder;

        if (target != null) {
          var fiber = getClosestInstanceFromNode(target);
          var responderFiber = currentInstance.fiber;

          while (fiber !== null) {
            if (fiber === responderFiber || fiber.alternate === responderFiber) {
              return true;
            }

            if (doesFiberHaveResponder(fiber, responder)) {
              return false;
            }

            fiber = fiber.return;
          }
        }

        return false;
      },
      isTargetWithinNode: function (childTarget, parentTarget) {
        validateResponderContext();
        var childFiber = getClosestInstanceFromNode(childTarget);
        var parentFiber = getClosestInstanceFromNode(parentTarget);

        if (childFiber != null && parentFiber != null) {
          var parentAlternateFiber = parentFiber.alternate;
          var node = childFiber;

          while (node !== null) {
            if (node === parentFiber || node === parentAlternateFiber) {
              return true;
            }

            node = node.return;
          }

          return false;
        } // Fallback to DOM APIs


        return parentTarget.contains(childTarget);
      },
      addRootEventTypes: function (rootEventTypes) {
        validateResponderContext();
        listenToResponderEventTypesImpl(rootEventTypes, currentDocument);

        for (var i = 0; i < rootEventTypes.length; i++) {
          var rootEventType = rootEventTypes[i];
          var eventResponderInstance = currentInstance;
          registerRootEventType(rootEventType, eventResponderInstance);
        }
      },
      removeRootEventTypes: function (rootEventTypes) {
        validateResponderContext();

        for (var i = 0; i < rootEventTypes.length; i++) {
          var rootEventType = rootEventTypes[i];
          var rootEventResponders = rootEventTypesToEventResponderInstances.get(rootEventType);
          var rootEventTypesSet = currentInstance.rootEventTypes;

          if (rootEventTypesSet !== null) {
            rootEventTypesSet.delete(rootEventType);
          }

          if (rootEventResponders !== undefined) {
            rootEventResponders.delete(currentInstance);
          }
        }
      },
      getActiveDocument: getActiveDocument,
      objectAssign: _assign,
      getTimeStamp: function () {
        validateResponderContext();
        return currentTimeStamp;
      },
      isTargetWithinHostComponent: function (target, elementType) {
        validateResponderContext();
        var fiber = getClosestInstanceFromNode(target);

        while (fiber !== null) {
          if (fiber.tag === HostComponent && fiber.type === elementType) {
            return true;
          }

          fiber = fiber.return;
        }

        return false;
      },
      continuePropagation: function () {
        currentPropagationBehavior = PropagateToNextResponder;
      },
      enqueueStateRestore: enqueueStateRestore,
      getResponderNode: function () {
        validateResponderContext();
        var responderFiber = currentInstance.fiber;

        if (responderFiber.tag === ScopeComponent) {
          return null;
        }

        return responderFiber.stateNode;
      }
    };

    function validateEventValue(eventValue) {
      if (typeof eventValue === 'object' && eventValue !== null) {
        var target = eventValue.target,
            type = eventValue.type,
            timeStamp = eventValue.timeStamp;

        if (target == null || type == null || timeStamp == null) {
          throw new Error('context.dispatchEvent: "target", "timeStamp", and "type" fields on event object are required.');
        }

        var showWarning = function (name) {
          {
            warning$1(false, '%s is not available on event objects created from event responder modules (React Flare). ' + 'Try wrapping in a conditional, i.e. `if (event.type !== "press") { event.%s }`', name, name);
          }
        };

        eventValue.isDefaultPrevented = function () {
          {
            showWarning('isDefaultPrevented()');
          }
        };

        eventValue.isPropagationStopped = function () {
          {
            showWarning('isPropagationStopped()');
          }
        }; // $FlowFixMe: we don't need value, Flow thinks we do


        Object.defineProperty(eventValue, 'nativeEvent', {
          get: function () {
            {
              showWarning('nativeEvent');
            }
          }
        });
      }
    }

    function doesFiberHaveResponder(fiber, responder) {
      var tag = fiber.tag;

      if (tag === HostComponent || tag === ScopeComponent) {
        var dependencies = fiber.dependencies;

        if (dependencies !== null) {
          var respondersMap = dependencies.responders;

          if (respondersMap !== null && respondersMap.has(responder)) {
            return true;
          }
        }
      }

      return false;
    }

    function getActiveDocument() {
      return currentDocument;
    }

    function createDOMResponderEvent(topLevelType, nativeEvent, nativeEventTarget, passive, passiveSupported) {
      var _ref = nativeEvent,
          buttons = _ref.buttons,
          pointerType = _ref.pointerType;
      var eventPointerType = '';

      if (pointerType !== undefined) {
        eventPointerType = pointerType;
      } else if (nativeEvent.key !== undefined) {
        eventPointerType = 'keyboard';
      } else if (buttons !== undefined) {
        eventPointerType = 'mouse';
      } else if (nativeEvent.changedTouches !== undefined) {
        eventPointerType = 'touch';
      }

      return {
        nativeEvent: nativeEvent,
        passive: passive,
        passiveSupported: passiveSupported,
        pointerType: eventPointerType,
        target: nativeEventTarget,
        type: topLevelType
      };
    }

    function responderEventTypesContainType(eventTypes, type) {
      for (var i = 0, len = eventTypes.length; i < len; i++) {
        if (eventTypes[i] === type) {
          return true;
        }
      }

      return false;
    }

    function validateResponderTargetEventTypes(eventType, responder) {
      var targetEventTypes = responder.targetEventTypes; // Validate the target event type exists on the responder

      if (targetEventTypes !== null) {
        return responderEventTypesContainType(targetEventTypes, eventType);
      }

      return false;
    }

    function traverseAndHandleEventResponderInstances(topLevelType, targetFiber, nativeEvent, nativeEventTarget, eventSystemFlags) {
      var isPassiveEvent = (eventSystemFlags & IS_PASSIVE) !== 0;
      var isPassiveSupported = (eventSystemFlags & PASSIVE_NOT_SUPPORTED) === 0;
      var isPassive = isPassiveEvent || !isPassiveSupported;
      var eventType = isPassive ? topLevelType : topLevelType + '_active'; // Trigger event responders in this order:
      // - Bubble target responder phase
      // - Root responder phase

      var visitedResponders = new Set();
      var responderEvent = createDOMResponderEvent(topLevelType, nativeEvent, nativeEventTarget, isPassiveEvent, isPassiveSupported);
      var node = targetFiber;
      var insidePortal = false;

      while (node !== null) {
        var _node = node,
            dependencies = _node.dependencies,
            tag = _node.tag;

        if (tag === HostPortal) {
          insidePortal = true;
        } else if ((tag === HostComponent || tag === ScopeComponent) && dependencies !== null) {
          var respondersMap = dependencies.responders;

          if (respondersMap !== null) {
            var responderInstances = Array.from(respondersMap.values());

            for (var i = 0, length = responderInstances.length; i < length; i++) {
              var responderInstance = responderInstances[i];
              var props = responderInstance.props,
                  responder = responderInstance.responder,
                  state = responderInstance.state;

              if (!visitedResponders.has(responder) && validateResponderTargetEventTypes(eventType, responder) && (!insidePortal || responder.targetPortalPropagation)) {
                visitedResponders.add(responder);
                var onEvent = responder.onEvent;

                if (onEvent !== null) {
                  currentInstance = responderInstance;
                  onEvent(responderEvent, eventResponderContext, props, state);

                  if (currentPropagationBehavior === PropagateToNextResponder) {
                    visitedResponders.delete(responder);
                    currentPropagationBehavior = DoNotPropagateToNextResponder;
                  }
                }
              }
            }
          }
        }

        node = node.return;
      } // Root phase


      var rootEventResponderInstances = rootEventTypesToEventResponderInstances.get(eventType);

      if (rootEventResponderInstances !== undefined) {
        var _responderInstances = Array.from(rootEventResponderInstances);

        for (var _i = 0; _i < _responderInstances.length; _i++) {
          var _responderInstance = _responderInstances[_i];
          var props = _responderInstance.props,
              responder = _responderInstance.responder,
              state = _responderInstance.state;
          var onRootEvent = responder.onRootEvent;

          if (onRootEvent !== null) {
            currentInstance = _responderInstance;
            onRootEvent(responderEvent, eventResponderContext, props, state);
          }
        }
      }
    }

    function mountEventResponder(responder, responderInstance, props, state) {
      var onMount = responder.onMount;

      if (onMount !== null) {
        var previousInstance = currentInstance;
        currentInstance = responderInstance;

        try {
          batchedEventUpdates(function () {
            onMount(eventResponderContext, props, state);
          });
        } finally {
          currentInstance = previousInstance;
        }
      }
    }

    function unmountEventResponder(responderInstance) {
      var responder = responderInstance.responder;
      var onUnmount = responder.onUnmount;

      if (onUnmount !== null) {
        var props = responderInstance.props,
            state = responderInstance.state;
        var previousInstance = currentInstance;
        currentInstance = responderInstance;

        try {
          batchedEventUpdates(function () {
            onUnmount(eventResponderContext, props, state);
          });
        } finally {
          currentInstance = previousInstance;
        }
      }

      var rootEventTypesSet = responderInstance.rootEventTypes;

      if (rootEventTypesSet !== null) {
        var rootEventTypes = Array.from(rootEventTypesSet);

        for (var i = 0; i < rootEventTypes.length; i++) {
          var topLevelEventType = rootEventTypes[i];
          var rootEventResponderInstances = rootEventTypesToEventResponderInstances.get(topLevelEventType);

          if (rootEventResponderInstances !== undefined) {
            rootEventResponderInstances.delete(responderInstance);
          }
        }
      }
    }

    function validateResponderContext() {
      if (!(currentInstance !== null)) {
        {
          throw Error("An event responder context was used outside of an event cycle.");
        }
      }
    }

    function dispatchEventForResponderEventSystem(topLevelType, targetFiber, nativeEvent, nativeEventTarget, eventSystemFlags) {
      if (enableFlareAPI) {
        var previousInstance = currentInstance;
        var previousTimeStamp = currentTimeStamp;
        var previousDocument = currentDocument;
        var previousPropagationBehavior = currentPropagationBehavior;
        currentPropagationBehavior = DoNotPropagateToNextResponder; // nodeType 9 is DOCUMENT_NODE

        currentDocument = nativeEventTarget.nodeType === 9 ? nativeEventTarget : nativeEventTarget.ownerDocument; // We might want to control timeStamp another way here

        currentTimeStamp = nativeEvent.timeStamp;

        try {
          batchedEventUpdates(function () {
            traverseAndHandleEventResponderInstances(topLevelType, targetFiber, nativeEvent, nativeEventTarget, eventSystemFlags);
          });
        } finally {
          currentInstance = previousInstance;
          currentTimeStamp = previousTimeStamp;
          currentDocument = previousDocument;
          currentPropagationBehavior = previousPropagationBehavior;
        }
      }
    }

    function addRootEventTypesForResponderInstance(responderInstance, rootEventTypes) {
      for (var i = 0; i < rootEventTypes.length; i++) {
        var rootEventType = rootEventTypes[i];
        registerRootEventType(rootEventType, responderInstance);
      }
    }

    function registerRootEventType(rootEventType, eventResponderInstance) {
      var rootEventResponderInstances = rootEventTypesToEventResponderInstances.get(rootEventType);

      if (rootEventResponderInstances === undefined) {
        rootEventResponderInstances = new Set();
        rootEventTypesToEventResponderInstances.set(rootEventType, rootEventResponderInstances);
      }

      var rootEventTypesSet = eventResponderInstance.rootEventTypes;

      if (rootEventTypesSet === null) {
        rootEventTypesSet = eventResponderInstance.rootEventTypes = new Set();
      }

      if (!!rootEventTypesSet.has(rootEventType)) {
        {
          throw Error("addRootEventTypes() found a duplicate root event type of \"" + rootEventType + "\". This might be because the event type exists in the event responder \"rootEventTypes\" array or because of a previous addRootEventTypes() using this root event type.");
        }
      }

      rootEventTypesSet.add(rootEventType);
      rootEventResponderInstances.add(eventResponderInstance);
    } // A reserved attribute.
    // It is handled by React separately and shouldn't be written to the DOM.


    var RESERVED = 0; // A simple string attribute.
    // Attributes that aren't in the whitelist are presumed to have this type.

    var STRING = 1; // A string attribute that accepts booleans in React. In HTML, these are called
    // "enumerated" attributes with "true" and "false" as possible values.
    // When true, it should be set to a "true" string.
    // When false, it should be set to a "false" string.

    var BOOLEANISH_STRING = 2; // A real boolean attribute.
    // When true, it should be present (set either to an empty string or its name).
    // When false, it should be omitted.

    var BOOLEAN = 3; // An attribute that can be used as a flag as well as with a value.
    // When true, it should be present (set either to an empty string or its name).
    // When false, it should be omitted.
    // For any other value, should be present with that value.

    var OVERLOADED_BOOLEAN = 4; // An attribute that must be numeric or parse as a numeric.
    // When falsy, it should be removed.

    var NUMERIC = 5; // An attribute that must be positive numeric or parse as a positive numeric.
    // When falsy, it should be removed.

    var POSITIVE_NUMERIC = 6;
    /* eslint-disable max-len */

    var ATTRIBUTE_NAME_START_CHAR = ":A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
    /* eslint-enable max-len */

    var ATTRIBUTE_NAME_CHAR = ATTRIBUTE_NAME_START_CHAR + "\\-.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
    var ROOT_ATTRIBUTE_NAME = 'data-reactroot';
    var VALID_ATTRIBUTE_NAME_REGEX = new RegExp('^[' + ATTRIBUTE_NAME_START_CHAR + '][' + ATTRIBUTE_NAME_CHAR + ']*$');
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var illegalAttributeNameCache = {};
    var validatedAttributeNameCache = {};

    function isAttributeNameSafe(attributeName) {
      if (hasOwnProperty.call(validatedAttributeNameCache, attributeName)) {
        return true;
      }

      if (hasOwnProperty.call(illegalAttributeNameCache, attributeName)) {
        return false;
      }

      if (VALID_ATTRIBUTE_NAME_REGEX.test(attributeName)) {
        validatedAttributeNameCache[attributeName] = true;
        return true;
      }

      illegalAttributeNameCache[attributeName] = true;
      {
        warning$1(false, 'Invalid attribute name: `%s`', attributeName);
      }
      return false;
    }

    function shouldIgnoreAttribute(name, propertyInfo, isCustomComponentTag) {
      if (propertyInfo !== null) {
        return propertyInfo.type === RESERVED;
      }

      if (isCustomComponentTag) {
        return false;
      }

      if (name.length > 2 && (name[0] === 'o' || name[0] === 'O') && (name[1] === 'n' || name[1] === 'N')) {
        return true;
      }

      return false;
    }

    function shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag) {
      if (propertyInfo !== null && propertyInfo.type === RESERVED) {
        return false;
      }

      switch (typeof value) {
        case 'function': // $FlowIssue symbol is perfectly valid here

        case 'symbol':
          // eslint-disable-line
          return true;

        case 'boolean':
          {
            if (isCustomComponentTag) {
              return false;
            }

            if (propertyInfo !== null) {
              return !propertyInfo.acceptsBooleans;
            } else {
              var prefix = name.toLowerCase().slice(0, 5);
              return prefix !== 'data-' && prefix !== 'aria-';
            }
          }

        default:
          return false;
      }
    }

    function shouldRemoveAttribute(name, value, propertyInfo, isCustomComponentTag) {
      if (value === null || typeof value === 'undefined') {
        return true;
      }

      if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag)) {
        return true;
      }

      if (isCustomComponentTag) {
        return false;
      }

      if (propertyInfo !== null) {
        switch (propertyInfo.type) {
          case BOOLEAN:
            return !value;

          case OVERLOADED_BOOLEAN:
            return value === false;

          case NUMERIC:
            return isNaN(value);

          case POSITIVE_NUMERIC:
            return isNaN(value) || value < 1;
        }
      }

      return false;
    }

    function getPropertyInfo(name) {
      return properties.hasOwnProperty(name) ? properties[name] : null;
    }

    function PropertyInfoRecord(name, type, mustUseProperty, attributeName, attributeNamespace, sanitizeURL) {
      this.acceptsBooleans = type === BOOLEANISH_STRING || type === BOOLEAN || type === OVERLOADED_BOOLEAN;
      this.attributeName = attributeName;
      this.attributeNamespace = attributeNamespace;
      this.mustUseProperty = mustUseProperty;
      this.propertyName = name;
      this.type = type;
      this.sanitizeURL = sanitizeURL;
    } // When adding attributes to this list, be sure to also add them to
    // the `possibleStandardNames` module to ensure casing and incorrect
    // name warnings.


    var properties = {}; // These props are reserved by React. They shouldn't be written to the DOM.

    ['children', 'dangerouslySetInnerHTML', // TODO: This prevents the assignment of defaultValue to regular
    // elements (not just inputs). Now that ReactDOMInput assigns to the
    // defaultValue property -- do we need this?
    'defaultValue', 'defaultChecked', 'innerHTML', 'suppressContentEditableWarning', 'suppressHydrationWarning', 'style'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, RESERVED, false, // mustUseProperty
      name, // attributeName
      null, // attributeNamespace
      false);
    }); // A few React string attributes have a different name.
    // This is a mapping from React prop names to the attribute names.

    [['acceptCharset', 'accept-charset'], ['className', 'class'], ['htmlFor', 'for'], ['httpEquiv', 'http-equiv']].forEach(function (_ref) {
      var name = _ref[0],
          attributeName = _ref[1];
      properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty
      attributeName, // attributeName
      null, // attributeNamespace
      false);
    }); // These are "enumerated" HTML attributes that accept "true" and "false".
    // In React, we let users pass `true` and `false` even though technically
    // these aren't boolean attributes (they are coerced to strings).

    ['contentEditable', 'draggable', 'spellCheck', 'value'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty
      name.toLowerCase(), // attributeName
      null, // attributeNamespace
      false);
    }); // These are "enumerated" SVG attributes that accept "true" and "false".
    // In React, we let users pass `true` and `false` even though technically
    // these aren't boolean attributes (they are coerced to strings).
    // Since these are SVG attributes, their attribute names are case-sensitive.

    ['autoReverse', 'externalResourcesRequired', 'focusable', 'preserveAlpha'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty
      name, // attributeName
      null, // attributeNamespace
      false);
    }); // These are HTML boolean attributes.

    ['allowFullScreen', 'async', // Note: there is a special case that prevents it from being written to the DOM
    // on the client side because the browsers are inconsistent. Instead we call focus().
    'autoFocus', 'autoPlay', 'controls', 'default', 'defer', 'disabled', 'disablePictureInPicture', 'formNoValidate', 'hidden', 'loop', 'noModule', 'noValidate', 'open', 'playsInline', 'readOnly', 'required', 'reversed', 'scoped', 'seamless', // Microdata
    'itemScope'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, BOOLEAN, false, // mustUseProperty
      name.toLowerCase(), // attributeName
      null, // attributeNamespace
      false);
    }); // These are the few React props that we set as DOM properties
    // rather than attributes. These are all booleans.

    ['checked', // Note: `option.selected` is not updated if `select.multiple` is
    // disabled with `removeAttribute`. We have special logic for handling this.
    'multiple', 'muted', 'selected'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, BOOLEAN, true, // mustUseProperty
      name, // attributeName
      null, // attributeNamespace
      false);
    }); // These are HTML attributes that are "overloaded booleans": they behave like
    // booleans, but can also accept a string value.

    ['capture', 'download'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, OVERLOADED_BOOLEAN, false, // mustUseProperty
      name, // attributeName
      null, // attributeNamespace
      false);
    }); // These are HTML attributes that must be positive numbers.

    ['cols', 'rows', 'size', 'span'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, POSITIVE_NUMERIC, false, // mustUseProperty
      name, // attributeName
      null, // attributeNamespace
      false);
    }); // These are HTML attributes that must be numbers.

    ['rowSpan', 'start'].forEach(function (name) {
      properties[name] = new PropertyInfoRecord(name, NUMERIC, false, // mustUseProperty
      name.toLowerCase(), // attributeName
      null, // attributeNamespace
      false);
    });
    var CAMELIZE = /[\-\:]([a-z])/g;

    var capitalize = function (token) {
      return token[1].toUpperCase();
    }; // This is a list of all SVG attributes that need special casing, namespacing,
    // or boolean value assignment. Regular attributes that just accept strings
    // and have the same names are omitted, just like in the HTML whitelist.
    // Some of these attributes can be hard to find. This list was created by
    // scrapping the MDN documentation.


    ['accent-height', 'alignment-baseline', 'arabic-form', 'baseline-shift', 'cap-height', 'clip-path', 'clip-rule', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'dominant-baseline', 'enable-background', 'fill-opacity', 'fill-rule', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'glyph-name', 'glyph-orientation-horizontal', 'glyph-orientation-vertical', 'horiz-adv-x', 'horiz-origin-x', 'image-rendering', 'letter-spacing', 'lighting-color', 'marker-end', 'marker-mid', 'marker-start', 'overline-position', 'overline-thickness', 'paint-order', 'panose-1', 'pointer-events', 'rendering-intent', 'shape-rendering', 'stop-color', 'stop-opacity', 'strikethrough-position', 'strikethrough-thickness', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'text-anchor', 'text-decoration', 'text-rendering', 'underline-position', 'underline-thickness', 'unicode-bidi', 'unicode-range', 'units-per-em', 'v-alphabetic', 'v-hanging', 'v-ideographic', 'v-mathematical', 'vector-effect', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'word-spacing', 'writing-mode', 'xmlns:xlink', 'x-height'].forEach(function (attributeName) {
      var name = attributeName.replace(CAMELIZE, capitalize);
      properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty
      attributeName, null, // attributeNamespace
      false);
    }); // String SVG attributes with the xlink namespace.

    ['xlink:actuate', 'xlink:arcrole', 'xlink:role', 'xlink:show', 'xlink:title', 'xlink:type'].forEach(function (attributeName) {
      var name = attributeName.replace(CAMELIZE, capitalize);
      properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty
      attributeName, 'http://www.w3.org/1999/xlink', false);
    }); // String SVG attributes with the xml namespace.

    ['xml:base', 'xml:lang', 'xml:space'].forEach(function (attributeName) {
      var name = attributeName.replace(CAMELIZE, capitalize);
      properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty
      attributeName, 'http://www.w3.org/XML/1998/namespace', false);
    }); // These attribute exists both in HTML and SVG.
    // The attribute name is case-sensitive in SVG so we can't just use
    // the React name like we do for attributes that exist only in HTML.

    ['tabIndex', 'crossOrigin'].forEach(function (attributeName) {
      properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty
      attributeName.toLowerCase(), // attributeName
      null, // attributeNamespace
      false);
    }); // These attributes accept URLs. These must not allow javascript: URLS.
    // These will also need to accept Trusted Types object in the future.

    var xlinkHref = 'xlinkHref';
    properties[xlinkHref] = new PropertyInfoRecord('xlinkHref', STRING, false, // mustUseProperty
    'xlink:href', 'http://www.w3.org/1999/xlink', true);
    ['src', 'href', 'action', 'formAction'].forEach(function (attributeName) {
      properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty
      attributeName.toLowerCase(), // attributeName
      null, // attributeNamespace
      true);
    });
    var ReactDebugCurrentFrame$1 = null;
    {
      ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;
    } // A javascript: URL can contain leading C0 control or \u0020 SPACE,
    // and any newline or tab are filtered out as if they're not part of the URL.
    // https://url.spec.whatwg.org/#url-parsing
    // Tab or newline are defined as \r\n\t:
    // https://infra.spec.whatwg.org/#ascii-tab-or-newline
    // A C0 control is a code point in the range \u0000 NULL to \u001F
    // INFORMATION SEPARATOR ONE, inclusive:
    // https://infra.spec.whatwg.org/#c0-control-or-space

    /* eslint-disable max-len */

    var isJavaScriptProtocol = /^[\u0000-\u001F ]*j[\r\n\t]*a[\r\n\t]*v[\r\n\t]*a[\r\n\t]*s[\r\n\t]*c[\r\n\t]*r[\r\n\t]*i[\r\n\t]*p[\r\n\t]*t[\r\n\t]*\:/i;
    var didWarn = false;

    function sanitizeURL(url) {
      if (disableJavaScriptURLs) {
        if (!!isJavaScriptProtocol.test(url)) {
          {
            throw Error("React has blocked a javascript: URL as a security precaution." + ReactDebugCurrentFrame$1.getStackAddendum());
          }
        }
      } else if (true && !didWarn && isJavaScriptProtocol.test(url)) {
        didWarn = true;
        warning$1(false, 'A future version of React will block javascript: URLs as a security precaution. ' + 'Use event handlers instead if you can. If you need to generate unsafe HTML try ' + 'using dangerouslySetInnerHTML instead. React was passed %s.', JSON.stringify(url));
      }
    } // Flow does not allow string concatenation of most non-string types. To work
    // around this limitation, we use an opaque type that can only be obtained by
    // passing the value through getToStringValue first.


    function toString(value) {
      return '' + value;
    }

    function getToStringValue(value) {
      switch (typeof value) {
        case 'boolean':
        case 'number':
        case 'object':
        case 'string':
        case 'undefined':
          return value;

        default:
          // function, symbol are assigned as empty strings
          return '';
      }
    }
    /** Trusted value is a wrapper for "safe" values which can be assigned to DOM execution sinks. */

    /**
     * We allow passing objects with toString method as element attributes or in dangerouslySetInnerHTML
     * and we do validations that the value is safe. Once we do validation we want to use the validated
     * value instead of the object (because object.toString may return something else on next call).
     *
     * If application uses Trusted Types we don't stringify trusted values, but preserve them as objects.
     */


    var toStringOrTrustedType = toString;

    if (enableTrustedTypesIntegration && typeof trustedTypes !== 'undefined') {
      toStringOrTrustedType = function (value) {
        if (typeof value === 'object' && (trustedTypes.isHTML(value) || trustedTypes.isScript(value) || trustedTypes.isScriptURL(value) ||
        /* TrustedURLs are deprecated and will be removed soon: https://github.com/WICG/trusted-types/pull/204 */
        trustedTypes.isURL && trustedTypes.isURL(value))) {
          // Pass Trusted Types through.
          return value;
        }

        return toString(value);
      };
    }
    /**
     * Set attribute for a node. The attribute value can be either string or
     * Trusted value (if application uses Trusted Types).
     */


    function setAttribute(node, attributeName, attributeValue) {
      node.setAttribute(attributeName, attributeValue);
    }
    /**
     * Set attribute with namespace for a node. The attribute value can be either string or
     * Trusted value (if application uses Trusted Types).
     */


    function setAttributeNS(node, attributeNamespace, attributeName, attributeValue) {
      node.setAttributeNS(attributeNamespace, attributeName, attributeValue);
    }
    /**
     * Get the value for a property on a node. Only used in DEV for SSR validation.
     * The "expected" argument is used as a hint of what the expected value is.
     * Some properties have multiple equivalent values.
     */


    function getValueForProperty(node, name, expected, propertyInfo) {
      {
        if (propertyInfo.mustUseProperty) {
          var propertyName = propertyInfo.propertyName;
          return node[propertyName];
        } else {
          if (!disableJavaScriptURLs && propertyInfo.sanitizeURL) {
            // If we haven't fully disabled javascript: URLs, and if
            // the hydration is successful of a javascript: URL, we
            // still want to warn on the client.
            sanitizeURL('' + expected);
          }

          var attributeName = propertyInfo.attributeName;
          var stringValue = null;

          if (propertyInfo.type === OVERLOADED_BOOLEAN) {
            if (node.hasAttribute(attributeName)) {
              var value = node.getAttribute(attributeName);

              if (value === '') {
                return true;
              }

              if (shouldRemoveAttribute(name, expected, propertyInfo, false)) {
                return value;
              }

              if (value === '' + expected) {
                return expected;
              }

              return value;
            }
          } else if (node.hasAttribute(attributeName)) {
            if (shouldRemoveAttribute(name, expected, propertyInfo, false)) {
              // We had an attribute but shouldn't have had one, so read it
              // for the error message.
              return node.getAttribute(attributeName);
            }

            if (propertyInfo.type === BOOLEAN) {
              // If this was a boolean, it doesn't matter what the value is
              // the fact that we have it is the same as the expected.
              return expected;
            } // Even if this property uses a namespace we use getAttribute
            // because we assume its namespaced name is the same as our config.
            // To use getAttributeNS we need the local name which we don't have
            // in our config atm.


            stringValue = node.getAttribute(attributeName);
          }

          if (shouldRemoveAttribute(name, expected, propertyInfo, false)) {
            return stringValue === null ? expected : stringValue;
          } else if (stringValue === '' + expected) {
            return expected;
          } else {
            return stringValue;
          }
        }
      }
    }
    /**
     * Get the value for a attribute on a node. Only used in DEV for SSR validation.
     * The third argument is used as a hint of what the expected value is. Some
     * attributes have multiple equivalent values.
     */


    function getValueForAttribute(node, name, expected) {
      {
        if (!isAttributeNameSafe(name)) {
          return;
        }

        if (!node.hasAttribute(name)) {
          return expected === undefined ? undefined : null;
        }

        var value = node.getAttribute(name);

        if (value === '' + expected) {
          return expected;
        }

        return value;
      }
    }
    /**
     * Sets the value for a property on a node.
     *
     * @param {DOMElement} node
     * @param {string} name
     * @param {*} value
     */


    function setValueForProperty(node, name, value, isCustomComponentTag) {
      var propertyInfo = getPropertyInfo(name);

      if (shouldIgnoreAttribute(name, propertyInfo, isCustomComponentTag)) {
        return;
      }

      if (shouldRemoveAttribute(name, value, propertyInfo, isCustomComponentTag)) {
        value = null;
      } // If the prop isn't in the special list, treat it as a simple attribute.


      if (isCustomComponentTag || propertyInfo === null) {
        if (isAttributeNameSafe(name)) {
          var _attributeName = name;

          if (value === null) {
            node.removeAttribute(_attributeName);
          } else {
            setAttribute(node, _attributeName, toStringOrTrustedType(value));
          }
        }

        return;
      }

      var mustUseProperty = propertyInfo.mustUseProperty;

      if (mustUseProperty) {
        var propertyName = propertyInfo.propertyName;

        if (value === null) {
          var type = propertyInfo.type;
          node[propertyName] = type === BOOLEAN ? false : '';
        } else {
          // Contrary to `setAttribute`, object properties are properly
          // `toString`ed by IE8/9.
          node[propertyName] = value;
        }

        return;
      } // The rest are treated as attributes with special cases.


      var attributeName = propertyInfo.attributeName,
          attributeNamespace = propertyInfo.attributeNamespace;

      if (value === null) {
        node.removeAttribute(attributeName);
      } else {
        var _type = propertyInfo.type;
        var attributeValue;

        if (_type === BOOLEAN || _type === OVERLOADED_BOOLEAN && value === true) {
          // If attribute type is boolean, we know for sure it won't be an execution sink
          // and we won't require Trusted Type here.
          attributeValue = '';
        } else {
          // `setAttribute` with objects becomes only `[object]` in IE8/9,
          // ('' + value) makes it output the correct toString()-value.
          attributeValue = toStringOrTrustedType(value);

          if (propertyInfo.sanitizeURL) {
            sanitizeURL(attributeValue.toString());
          }
        }

        if (attributeNamespace) {
          setAttributeNS(node, attributeNamespace, attributeName, attributeValue);
        } else {
          setAttribute(node, attributeName, attributeValue);
        }
      }
    }

    var ReactDebugCurrentFrame$2 = null;
    var ReactControlledValuePropTypes = {
      checkPropTypes: null
    };
    {
      ReactDebugCurrentFrame$2 = ReactSharedInternals.ReactDebugCurrentFrame;
      var hasReadOnlyValue = {
        button: true,
        checkbox: true,
        image: true,
        hidden: true,
        radio: true,
        reset: true,
        submit: true
      };
      var propTypes = {
        value: function (props, propName, componentName) {
          if (hasReadOnlyValue[props.type] || props.onChange || props.readOnly || props.disabled || props[propName] == null || enableFlareAPI && props.listeners) {
            return null;
          }

          return new Error('You provided a `value` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultValue`. Otherwise, ' + 'set either `onChange` or `readOnly`.');
        },
        checked: function (props, propName, componentName) {
          if (props.onChange || props.readOnly || props.disabled || props[propName] == null || enableFlareAPI && props.listeners) {
            return null;
          }

          return new Error('You provided a `checked` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultChecked`. Otherwise, ' + 'set either `onChange` or `readOnly`.');
        }
      };
      /**
       * Provide a linked `value` attribute for controlled forms. You should not use
       * this outside of the ReactDOM controlled form components.
       */

      ReactControlledValuePropTypes.checkPropTypes = function (tagName, props) {
        checkPropTypes(propTypes, props, 'prop', tagName, ReactDebugCurrentFrame$2.getStackAddendum);
      };
    }

    function isCheckable(elem) {
      var type = elem.type;
      var nodeName = elem.nodeName;
      return nodeName && nodeName.toLowerCase() === 'input' && (type === 'checkbox' || type === 'radio');
    }

    function getTracker(node) {
      return node._valueTracker;
    }

    function detachTracker(node) {
      node._valueTracker = null;
    }

    function getValueFromNode(node) {
      var value = '';

      if (!node) {
        return value;
      }

      if (isCheckable(node)) {
        value = node.checked ? 'true' : 'false';
      } else {
        value = node.value;
      }

      return value;
    }

    function trackValueOnNode(node) {
      var valueField = isCheckable(node) ? 'checked' : 'value';
      var descriptor = Object.getOwnPropertyDescriptor(node.constructor.prototype, valueField);
      var currentValue = '' + node[valueField]; // if someone has already defined a value or Safari, then bail
      // and don't track value will cause over reporting of changes,
      // but it's better then a hard failure
      // (needed for certain tests that spyOn input values and Safari)

      if (node.hasOwnProperty(valueField) || typeof descriptor === 'undefined' || typeof descriptor.get !== 'function' || typeof descriptor.set !== 'function') {
        return;
      }

      var get = descriptor.get,
          set = descriptor.set;
      Object.defineProperty(node, valueField, {
        configurable: true,
        get: function () {
          return get.call(this);
        },
        set: function (value) {
          currentValue = '' + value;
          set.call(this, value);
        }
      }); // We could've passed this the first time
      // but it triggers a bug in IE11 and Edge 14/15.
      // Calling defineProperty() again should be equivalent.
      // https://github.com/facebook/react/issues/11768

      Object.defineProperty(node, valueField, {
        enumerable: descriptor.enumerable
      });
      var tracker = {
        getValue: function () {
          return currentValue;
        },
        setValue: function (value) {
          currentValue = '' + value;
        },
        stopTracking: function () {
          detachTracker(node);
          delete node[valueField];
        }
      };
      return tracker;
    }

    function track(node) {
      if (getTracker(node)) {
        return;
      } // TODO: Once it's just Fiber we can move this to node._wrapperState


      node._valueTracker = trackValueOnNode(node);
    }

    function updateValueIfChanged(node) {
      if (!node) {
        return false;
      }

      var tracker = getTracker(node); // if there is no tracker at this point it's unlikely
      // that trying again will succeed

      if (!tracker) {
        return true;
      }

      var lastValue = tracker.getValue();
      var nextValue = getValueFromNode(node);

      if (nextValue !== lastValue) {
        tracker.setValue(nextValue);
        return true;
      }

      return false;
    } // TODO: direct imports like some-package/src/* are bad. Fix me.


    var didWarnValueDefaultValue = false;
    var didWarnCheckedDefaultChecked = false;
    var didWarnControlledToUncontrolled = false;
    var didWarnUncontrolledToControlled = false;

    function isControlled(props) {
      var usesChecked = props.type === 'checkbox' || props.type === 'radio';
      return usesChecked ? props.checked != null : props.value != null;
    }
    /**
     * Implements an <input> host component that allows setting these optional
     * props: `checked`, `value`, `defaultChecked`, and `defaultValue`.
     *
     * If `checked` or `value` are not supplied (or null/undefined), user actions
     * that affect the checked state or value will trigger updates to the element.
     *
     * If they are supplied (and not null/undefined), the rendered element will not
     * trigger updates to the element. Instead, the props must change in order for
     * the rendered element to be updated.
     *
     * The rendered element will be initialized as unchecked (or `defaultChecked`)
     * with an empty value (or `defaultValue`).
     *
     * See http://www.w3.org/TR/2012/WD-html5-20121025/the-input-element.html
     */


    function getHostProps(element, props) {
      var node = element;
      var checked = props.checked;

      var hostProps = _assign({}, props, {
        defaultChecked: undefined,
        defaultValue: undefined,
        value: undefined,
        checked: checked != null ? checked : node._wrapperState.initialChecked
      });

      return hostProps;
    }

    function initWrapperState(element, props) {
      {
        ReactControlledValuePropTypes.checkPropTypes('input', props);

        if (props.checked !== undefined && props.defaultChecked !== undefined && !didWarnCheckedDefaultChecked) {
          warning$1(false, '%s contains an input of type %s with both checked and defaultChecked props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the checked prop, or the defaultChecked prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://fb.me/react-controlled-components', getCurrentFiberOwnerNameInDevOrNull() || 'A component', props.type);
          didWarnCheckedDefaultChecked = true;
        }

        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnValueDefaultValue) {
          warning$1(false, '%s contains an input of type %s with both value and defaultValue props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://fb.me/react-controlled-components', getCurrentFiberOwnerNameInDevOrNull() || 'A component', props.type);
          didWarnValueDefaultValue = true;
        }
      }
      var node = element;
      var defaultValue = props.defaultValue == null ? '' : props.defaultValue;
      node._wrapperState = {
        initialChecked: props.checked != null ? props.checked : props.defaultChecked,
        initialValue: getToStringValue(props.value != null ? props.value : defaultValue),
        controlled: isControlled(props)
      };
    }

    function updateChecked(element, props) {
      var node = element;
      var checked = props.checked;

      if (checked != null) {
        setValueForProperty(node, 'checked', checked, false);
      }
    }

    function updateWrapper(element, props) {
      var node = element;
      {
        var controlled = isControlled(props);

        if (!node._wrapperState.controlled && controlled && !didWarnUncontrolledToControlled) {
          warning$1(false, 'A component is changing an uncontrolled input of type %s to be controlled. ' + 'Input elements should not switch from uncontrolled to controlled (or vice versa). ' + 'Decide between using a controlled or uncontrolled input ' + 'element for the lifetime of the component. More info: https://fb.me/react-controlled-components', props.type);
          didWarnUncontrolledToControlled = true;
        }

        if (node._wrapperState.controlled && !controlled && !didWarnControlledToUncontrolled) {
          warning$1(false, 'A component is changing a controlled input of type %s to be uncontrolled. ' + 'Input elements should not switch from controlled to uncontrolled (or vice versa). ' + 'Decide between using a controlled or uncontrolled input ' + 'element for the lifetime of the component. More info: https://fb.me/react-controlled-components', props.type);
          didWarnControlledToUncontrolled = true;
        }
      }
      updateChecked(element, props);
      var value = getToStringValue(props.value);
      var type = props.type;

      if (value != null) {
        if (type === 'number') {
          if (value === 0 && node.value === '' || // We explicitly want to coerce to number here if possible.
          // eslint-disable-next-line
          node.value != value) {
            node.value = toString(value);
          }
        } else if (node.value !== toString(value)) {
          node.value = toString(value);
        }
      } else if (type === 'submit' || type === 'reset') {
        // Submit/reset inputs need the attribute removed completely to avoid
        // blank-text buttons.
        node.removeAttribute('value');
        return;
      }

      if (disableInputAttributeSyncing) {
        // When not syncing the value attribute, React only assigns a new value
        // whenever the defaultValue React prop has changed. When not present,
        // React does nothing
        if (props.hasOwnProperty('defaultValue')) {
          setDefaultValue(node, props.type, getToStringValue(props.defaultValue));
        }
      } else {
        // When syncing the value attribute, the value comes from a cascade of
        // properties:
        //  1. The value React property
        //  2. The defaultValue React property
        //  3. Otherwise there should be no change
        if (props.hasOwnProperty('value')) {
          setDefaultValue(node, props.type, value);
        } else if (props.hasOwnProperty('defaultValue')) {
          setDefaultValue(node, props.type, getToStringValue(props.defaultValue));
        }
      }

      if (disableInputAttributeSyncing) {
        // When not syncing the checked attribute, the attribute is directly
        // controllable from the defaultValue React property. It needs to be
        // updated as new props come in.
        if (props.defaultChecked == null) {
          node.removeAttribute('checked');
        } else {
          node.defaultChecked = !!props.defaultChecked;
        }
      } else {
        // When syncing the checked attribute, it only changes when it needs
        // to be removed, such as transitioning from a checkbox into a text input
        if (props.checked == null && props.defaultChecked != null) {
          node.defaultChecked = !!props.defaultChecked;
        }
      }
    }

    function postMountWrapper(element, props, isHydrating) {
      var node = element; // Do not assign value if it is already set. This prevents user text input
      // from being lost during SSR hydration.

      if (props.hasOwnProperty('value') || props.hasOwnProperty('defaultValue')) {
        var type = props.type;
        var isButton = type === 'submit' || type === 'reset'; // Avoid setting value attribute on submit/reset inputs as it overrides the
        // default value provided by the browser. See: #12872

        if (isButton && (props.value === undefined || props.value === null)) {
          return;
        }

        var initialValue = toString(node._wrapperState.initialValue); // Do not assign value if it is already set. This prevents user text input
        // from being lost during SSR hydration.

        if (!isHydrating) {
          if (disableInputAttributeSyncing) {
            var value = getToStringValue(props.value); // When not syncing the value attribute, the value property points
            // directly to the React prop. Only assign it if it exists.

            if (value != null) {
              // Always assign on buttons so that it is possible to assign an
              // empty string to clear button text.
              //
              // Otherwise, do not re-assign the value property if is empty. This
              // potentially avoids a DOM write and prevents Firefox (~60.0.1) from
              // prematurely marking required inputs as invalid. Equality is compared
              // to the current value in case the browser provided value is not an
              // empty string.
              if (isButton || value !== node.value) {
                node.value = toString(value);
              }
            }
          } else {
            // When syncing the value attribute, the value property should use
            // the wrapperState._initialValue property. This uses:
            //
            //   1. The value React property when present
            //   2. The defaultValue React property when present
            //   3. An empty string
            if (initialValue !== node.value) {
              node.value = initialValue;
            }
          }
        }

        if (disableInputAttributeSyncing) {
          // When not syncing the value attribute, assign the value attribute
          // directly from the defaultValue React property (when present)
          var defaultValue = getToStringValue(props.defaultValue);

          if (defaultValue != null) {
            node.defaultValue = toString(defaultValue);
          }
        } else {
          // Otherwise, the value attribute is synchronized to the property,
          // so we assign defaultValue to the same thing as the value property
          // assignment step above.
          node.defaultValue = initialValue;
        }
      } // Normally, we'd just do `node.checked = node.checked` upon initial mount, less this bug
      // this is needed to work around a chrome bug where setting defaultChecked
      // will sometimes influence the value of checked (even after detachment).
      // Reference: https://bugs.chromium.org/p/chromium/issues/detail?id=608416
      // We need to temporarily unset name to avoid disrupting radio button groups.


      var name = node.name;

      if (name !== '') {
        node.name = '';
      }

      if (disableInputAttributeSyncing) {
        // When not syncing the checked attribute, the checked property
        // never gets assigned. It must be manually set. We don't want
        // to do this when hydrating so that existing user input isn't
        // modified
        if (!isHydrating) {
          updateChecked(element, props);
        } // Only assign the checked attribute if it is defined. This saves
        // a DOM write when controlling the checked attribute isn't needed
        // (text inputs, submit/reset)


        if (props.hasOwnProperty('defaultChecked')) {
          node.defaultChecked = !node.defaultChecked;
          node.defaultChecked = !!props.defaultChecked;
        }
      } else {
        // When syncing the checked attribute, both the checked property and
        // attribute are assigned at the same time using defaultChecked. This uses:
        //
        //   1. The checked React property when present
        //   2. The defaultChecked React property when present
        //   3. Otherwise, false
        node.defaultChecked = !node.defaultChecked;
        node.defaultChecked = !!node._wrapperState.initialChecked;
      }

      if (name !== '') {
        node.name = name;
      }
    }

    function restoreControlledState$1(element, props) {
      var node = element;
      updateWrapper(node, props);
      updateNamedCousins(node, props);
    }

    function updateNamedCousins(rootNode, props) {
      var name = props.name;

      if (props.type === 'radio' && name != null) {
        var queryRoot = rootNode;

        while (queryRoot.parentNode) {
          queryRoot = queryRoot.parentNode;
        } // If `rootNode.form` was non-null, then we could try `form.elements`,
        // but that sometimes behaves strangely in IE8. We could also try using
        // `form.getElementsByName`, but that will only return direct children
        // and won't include inputs that use the HTML5 `form=` attribute. Since
        // the input might not even be in a form. It might not even be in the
        // document. Let's just use the local `querySelectorAll` to ensure we don't
        // miss anything.


        var group = queryRoot.querySelectorAll('input[name=' + JSON.stringify('' + name) + '][type="radio"]');

        for (var i = 0; i < group.length; i++) {
          var otherNode = group[i];

          if (otherNode === rootNode || otherNode.form !== rootNode.form) {
            continue;
          } // This will throw if radio buttons rendered by different copies of React
          // and the same name are rendered into the same form (same as #1939).
          // That's probably okay; we don't support it just as we don't support
          // mixing React radio buttons with non-React ones.


          var otherProps = getFiberCurrentPropsFromNode$1(otherNode);

          if (!otherProps) {
            {
              throw Error("ReactDOMInput: Mixing React and non-React radio inputs with the same `name` is not supported.");
            }
          } // We need update the tracked value on the named cousin since the value
          // was changed but the input saw no event or value set


          updateValueIfChanged(otherNode); // If this is a controlled radio button group, forcing the input that
          // was previously checked to update will cause it to be come re-checked
          // as appropriate.

          updateWrapper(otherNode, otherProps);
        }
      }
    } // In Chrome, assigning defaultValue to certain input types triggers input validation.
    // For number inputs, the display value loses trailing decimal points. For email inputs,
    // Chrome raises "The specified value <x> is not a valid email address".
    //
    // Here we check to see if the defaultValue has actually changed, avoiding these problems
    // when the user is inputting text
    //
    // https://github.com/facebook/react/issues/7253


    function setDefaultValue(node, type, value) {
      if ( // Focused number inputs synchronize on blur. See ChangeEventPlugin.js
      type !== 'number' || node.ownerDocument.activeElement !== node) {
        if (value == null) {
          node.defaultValue = toString(node._wrapperState.initialValue);
        } else if (node.defaultValue !== toString(value)) {
          node.defaultValue = toString(value);
        }
      }
    }

    var didWarnSelectedSetOnOption = false;
    var didWarnInvalidChild = false;

    function flattenChildren(children) {
      var content = ''; // Flatten children. We'll warn if they are invalid
      // during validateProps() which runs for hydration too.
      // Note that this would throw on non-element objects.
      // Elements are stringified (which is normally irrelevant
      // but matters for <fbt>).

      React.Children.forEach(children, function (child) {
        if (child == null) {
          return;
        }

        content += child; // Note: we don't warn about invalid children here.
        // Instead, this is done separately below so that
        // it happens during the hydration codepath too.
      });
      return content;
    }
    /**
     * Implements an <option> host component that warns when `selected` is set.
     */


    function validateProps(element, props) {
      {
        // This mirrors the codepath above, but runs for hydration too.
        // Warn about invalid children here so that client and hydration are consistent.
        // TODO: this seems like it could cause a DEV-only throw for hydration
        // if children contains a non-element object. We should try to avoid that.
        if (typeof props.children === 'object' && props.children !== null) {
          React.Children.forEach(props.children, function (child) {
            if (child == null) {
              return;
            }

            if (typeof child === 'string' || typeof child === 'number') {
              return;
            }

            if (typeof child.type !== 'string') {
              return;
            }

            if (!didWarnInvalidChild) {
              didWarnInvalidChild = true;
              warning$1(false, 'Only strings and numbers are supported as <option> children.');
            }
          });
        } // TODO: Remove support for `selected` in <option>.


        if (props.selected != null && !didWarnSelectedSetOnOption) {
          warning$1(false, 'Use the `defaultValue` or `value` props on <select> instead of ' + 'setting `selected` on <option>.');
          didWarnSelectedSetOnOption = true;
        }
      }
    }

    function postMountWrapper$1(element, props) {
      // value="" should make a value attribute (#6219)
      if (props.value != null) {
        element.setAttribute('value', toString(getToStringValue(props.value)));
      }
    }

    function getHostProps$1(element, props) {
      var hostProps = _assign({
        children: undefined
      }, props);

      var content = flattenChildren(props.children);

      if (content) {
        hostProps.children = content;
      }

      return hostProps;
    } // TODO: direct imports like some-package/src/* are bad. Fix me.


    var didWarnValueDefaultValue$1;
    {
      didWarnValueDefaultValue$1 = false;
    }

    function getDeclarationErrorAddendum() {
      var ownerName = getCurrentFiberOwnerNameInDevOrNull();

      if (ownerName) {
        return '\n\nCheck the render method of `' + ownerName + '`.';
      }

      return '';
    }

    var valuePropNames = ['value', 'defaultValue'];
    /**
     * Validation function for `value` and `defaultValue`.
     */

    function checkSelectPropTypes(props) {
      ReactControlledValuePropTypes.checkPropTypes('select', props);

      for (var i = 0; i < valuePropNames.length; i++) {
        var propName = valuePropNames[i];

        if (props[propName] == null) {
          continue;
        }

        var isArray = Array.isArray(props[propName]);

        if (props.multiple && !isArray) {
          warning$1(false, 'The `%s` prop supplied to <select> must be an array if ' + '`multiple` is true.%s', propName, getDeclarationErrorAddendum());
        } else if (!props.multiple && isArray) {
          warning$1(false, 'The `%s` prop supplied to <select> must be a scalar ' + 'value if `multiple` is false.%s', propName, getDeclarationErrorAddendum());
        }
      }
    }

    function updateOptions(node, multiple, propValue, setDefaultSelected) {
      var options = node.options;

      if (multiple) {
        var selectedValues = propValue;
        var selectedValue = {};

        for (var i = 0; i < selectedValues.length; i++) {
          // Prefix to avoid chaos with special keys.
          selectedValue['$' + selectedValues[i]] = true;
        }

        for (var _i = 0; _i < options.length; _i++) {
          var selected = selectedValue.hasOwnProperty('$' + options[_i].value);

          if (options[_i].selected !== selected) {
            options[_i].selected = selected;
          }

          if (selected && setDefaultSelected) {
            options[_i].defaultSelected = true;
          }
        }
      } else {
        // Do not set `select.value` as exact behavior isn't consistent across all
        // browsers for all cases.
        var _selectedValue = toString(getToStringValue(propValue));

        var defaultSelected = null;

        for (var _i2 = 0; _i2 < options.length; _i2++) {
          if (options[_i2].value === _selectedValue) {
            options[_i2].selected = true;

            if (setDefaultSelected) {
              options[_i2].defaultSelected = true;
            }

            return;
          }

          if (defaultSelected === null && !options[_i2].disabled) {
            defaultSelected = options[_i2];
          }
        }

        if (defaultSelected !== null) {
          defaultSelected.selected = true;
        }
      }
    }
    /**
     * Implements a <select> host component that allows optionally setting the
     * props `value` and `defaultValue`. If `multiple` is false, the prop must be a
     * stringable. If `multiple` is true, the prop must be an array of stringables.
     *
     * If `value` is not supplied (or null/undefined), user actions that change the
     * selected option will trigger updates to the rendered options.
     *
     * If it is supplied (and not null/undefined), the rendered options will not
     * update in response to user actions. Instead, the `value` prop must change in
     * order for the rendered options to update.
     *
     * If `defaultValue` is provided, any options with the supplied values will be
     * selected.
     */


    function getHostProps$2(element, props) {
      return _assign({}, props, {
        value: undefined
      });
    }

    function initWrapperState$1(element, props) {
      var node = element;
      {
        checkSelectPropTypes(props);
      }
      node._wrapperState = {
        wasMultiple: !!props.multiple
      };
      {
        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnValueDefaultValue$1) {
          warning$1(false, 'Select elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled select ' + 'element and remove one of these props. More info: ' + 'https://fb.me/react-controlled-components');
          didWarnValueDefaultValue$1 = true;
        }
      }
    }

    function postMountWrapper$2(element, props) {
      var node = element;
      node.multiple = !!props.multiple;
      var value = props.value;

      if (value != null) {
        updateOptions(node, !!props.multiple, value, false);
      } else if (props.defaultValue != null) {
        updateOptions(node, !!props.multiple, props.defaultValue, true);
      }
    }

    function postUpdateWrapper(element, props) {
      var node = element;
      var wasMultiple = node._wrapperState.wasMultiple;
      node._wrapperState.wasMultiple = !!props.multiple;
      var value = props.value;

      if (value != null) {
        updateOptions(node, !!props.multiple, value, false);
      } else if (wasMultiple !== !!props.multiple) {
        // For simplicity, reapply `defaultValue` if `multiple` is toggled.
        if (props.defaultValue != null) {
          updateOptions(node, !!props.multiple, props.defaultValue, true);
        } else {
          // Revert the select back to its default unselected state.
          updateOptions(node, !!props.multiple, props.multiple ? [] : '', false);
        }
      }
    }

    function restoreControlledState$2(element, props) {
      var node = element;
      var value = props.value;

      if (value != null) {
        updateOptions(node, !!props.multiple, value, false);
      }
    }

    var didWarnValDefaultVal = false;
    /**
     * Implements a <textarea> host component that allows setting `value`, and
     * `defaultValue`. This differs from the traditional DOM API because value is
     * usually set as PCDATA children.
     *
     * If `value` is not supplied (or null/undefined), user actions that affect the
     * value will trigger updates to the element.
     *
     * If `value` is supplied (and not null/undefined), the rendered element will
     * not trigger updates to the element. Instead, the `value` prop must change in
     * order for the rendered element to be updated.
     *
     * The rendered element will be initialized with an empty value, the prop
     * `defaultValue` if specified, or the children content (deprecated).
     */

    function getHostProps$3(element, props) {
      var node = element;

      if (!(props.dangerouslySetInnerHTML == null)) {
        {
          throw Error("`dangerouslySetInnerHTML` does not make sense on <textarea>.");
        }
      } // Always set children to the same thing. In IE9, the selection range will
      // get reset if `textContent` is mutated.  We could add a check in setTextContent
      // to only set the value if/when the value differs from the node value (which would
      // completely solve this IE9 bug), but Sebastian+Sophie seemed to like this
      // solution. The value can be a boolean or object so that's why it's forced
      // to be a string.


      var hostProps = _assign({}, props, {
        value: undefined,
        defaultValue: undefined,
        children: toString(node._wrapperState.initialValue)
      });

      return hostProps;
    }

    function initWrapperState$2(element, props) {
      var node = element;
      {
        ReactControlledValuePropTypes.checkPropTypes('textarea', props);

        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnValDefaultVal) {
          warning$1(false, '%s contains a textarea with both value and defaultValue props. ' + 'Textarea elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled textarea ' + 'and remove one of these props. More info: ' + 'https://fb.me/react-controlled-components', getCurrentFiberOwnerNameInDevOrNull() || 'A component');
          didWarnValDefaultVal = true;
        }
      }
      var initialValue = props.value; // Only bother fetching default value if we're going to use it

      if (initialValue == null) {
        var defaultValue = props.defaultValue; // TODO (yungsters): Remove support for children content in <textarea>.

        var children = props.children;

        if (children != null) {
          {
            warning$1(false, 'Use the `defaultValue` or `value` props instead of setting ' + 'children on <textarea>.');
          }

          if (!(defaultValue == null)) {
            {
              throw Error("If you supply `defaultValue` on a <textarea>, do not pass children.");
            }
          }

          if (Array.isArray(children)) {
            if (!(children.length <= 1)) {
              {
                throw Error("<textarea> can only have at most one child.");
              }
            }

            children = children[0];
          }

          defaultValue = children;
        }

        if (defaultValue == null) {
          defaultValue = '';
        }

        initialValue = defaultValue;
      }

      node._wrapperState = {
        initialValue: getToStringValue(initialValue)
      };
    }

    function updateWrapper$1(element, props) {
      var node = element;
      var value = getToStringValue(props.value);
      var defaultValue = getToStringValue(props.defaultValue);

      if (value != null) {
        // Cast `value` to a string to ensure the value is set correctly. While
        // browsers typically do this as necessary, jsdom doesn't.
        var newValue = toString(value); // To avoid side effects (such as losing text selection), only set value if changed

        if (newValue !== node.value) {
          node.value = newValue;
        }

        if (props.defaultValue == null && node.defaultValue !== newValue) {
          node.defaultValue = newValue;
        }
      }

      if (defaultValue != null) {
        node.defaultValue = toString(defaultValue);
      }
    }

    function postMountWrapper$3(element, props) {
      var node = element; // This is in postMount because we need access to the DOM node, which is not
      // available until after the component has mounted.

      var textContent = node.textContent; // Only set node.value if textContent is equal to the expected
      // initial value. In IE10/IE11 there is a bug where the placeholder attribute
      // will populate textContent as well.
      // https://developer.microsoft.com/microsoft-edge/platform/issues/101525/

      if (textContent === node._wrapperState.initialValue) {
        if (textContent !== '' && textContent !== null) {
          node.value = textContent;
        }
      }
    }

    function restoreControlledState$3(element, props) {
      // DOM component is still mounted; update
      updateWrapper$1(element, props);
    }

    var HTML_NAMESPACE$1 = 'http://www.w3.org/1999/xhtml';
    var MATH_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';
    var SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
    var Namespaces = {
      html: HTML_NAMESPACE$1,
      mathml: MATH_NAMESPACE,
      svg: SVG_NAMESPACE
    }; // Assumes there is no parent namespace.

    function getIntrinsicNamespace(type) {
      switch (type) {
        case 'svg':
          return SVG_NAMESPACE;

        case 'math':
          return MATH_NAMESPACE;

        default:
          return HTML_NAMESPACE$1;
      }
    }

    function getChildNamespace(parentNamespace, type) {
      if (parentNamespace == null || parentNamespace === HTML_NAMESPACE$1) {
        // No (or default) parent namespace: potential entry point.
        return getIntrinsicNamespace(type);
      }

      if (parentNamespace === SVG_NAMESPACE && type === 'foreignObject') {
        // We're leaving SVG.
        return HTML_NAMESPACE$1;
      } // By default, pass namespace below.


      return parentNamespace;
    }
    /* globals MSApp */

    /**
     * Create a function which has 'unsafe' privileges (required by windows8 apps)
     */


    var createMicrosoftUnsafeLocalFunction = function (func) {
      if (typeof MSApp !== 'undefined' && MSApp.execUnsafeLocalFunction) {
        return function (arg0, arg1, arg2, arg3) {
          MSApp.execUnsafeLocalFunction(function () {
            return func(arg0, arg1, arg2, arg3);
          });
        };
      } else {
        return func;
      }
    };

    var reusableSVGContainer;
    /**
     * Set the innerHTML property of a node
     *
     * @param {DOMElement} node
     * @param {string} html
     * @internal
     */

    var setInnerHTML = createMicrosoftUnsafeLocalFunction(function (node, html) {
      if (node.namespaceURI === Namespaces.svg) {
        {
          if (enableTrustedTypesIntegration) {
            // TODO: reconsider the text of this warning and when it should show
            // before enabling the feature flag.
            !(typeof trustedTypes === 'undefined') ? warning$1(false, "Using 'dangerouslySetInnerHTML' in an svg element with " + 'Trusted Types enabled in an Internet Explorer will cause ' + 'the trusted value to be converted to string. Assigning string ' + "to 'innerHTML' will throw an error if Trusted Types are enforced. " + "You can try to wrap your svg element inside a div and use 'dangerouslySetInnerHTML' " + 'on the enclosing div instead.') : void 0;
          }
        }

        if (!('innerHTML' in node)) {
          // IE does not have innerHTML for SVG nodes, so instead we inject the
          // new markup in a temp node and then move the child nodes across into
          // the target node
          reusableSVGContainer = reusableSVGContainer || document.createElement('div');
          reusableSVGContainer.innerHTML = '<svg>' + html.valueOf().toString() + '</svg>';
          var svgNode = reusableSVGContainer.firstChild;

          while (node.firstChild) {
            node.removeChild(node.firstChild);
          }

          while (svgNode.firstChild) {
            node.appendChild(svgNode.firstChild);
          }

          return;
        }
      }

      node.innerHTML = html;
    });
    /**
     * HTML nodeType values that represent the type of the node
     */

    var ELEMENT_NODE = 1;
    var TEXT_NODE = 3;
    var COMMENT_NODE = 8;
    var DOCUMENT_NODE = 9;
    var DOCUMENT_FRAGMENT_NODE = 11;
    /**
     * Set the textContent property of a node. For text updates, it's faster
     * to set the `nodeValue` of the Text node directly instead of using
     * `.textContent` which will remove the existing node and create a new one.
     *
     * @param {DOMElement} node
     * @param {string} text
     * @internal
     */

    var setTextContent = function (node, text) {
      if (text) {
        var firstChild = node.firstChild;

        if (firstChild && firstChild === node.lastChild && firstChild.nodeType === TEXT_NODE) {
          firstChild.nodeValue = text;
          return;
        }
      }

      node.textContent = text;
    }; // Do not use the below two methods directly!
    // Instead use constants exported from DOMTopLevelEventTypes in ReactDOM.
    // (It is the only module that is allowed to access these methods.)


    function unsafeCastStringToDOMTopLevelType(topLevelType) {
      return topLevelType;
    }

    function unsafeCastDOMTopLevelTypeToString(topLevelType) {
      return topLevelType;
    }
    /**
     * Generate a mapping of standard vendor prefixes using the defined style property and event name.
     *
     * @param {string} styleProp
     * @param {string} eventName
     * @returns {object}
     */


    function makePrefixMap(styleProp, eventName) {
      var prefixes = {};
      prefixes[styleProp.toLowerCase()] = eventName.toLowerCase();
      prefixes['Webkit' + styleProp] = 'webkit' + eventName;
      prefixes['Moz' + styleProp] = 'moz' + eventName;
      return prefixes;
    }
    /**
     * A list of event names to a configurable list of vendor prefixes.
     */


    var vendorPrefixes = {
      animationend: makePrefixMap('Animation', 'AnimationEnd'),
      animationiteration: makePrefixMap('Animation', 'AnimationIteration'),
      animationstart: makePrefixMap('Animation', 'AnimationStart'),
      transitionend: makePrefixMap('Transition', 'TransitionEnd')
    };
    /**
     * Event names that have already been detected and prefixed (if applicable).
     */

    var prefixedEventNames = {};
    /**
     * Element to check for prefixes on.
     */

    var style = {};
    /**
     * Bootstrap if a DOM exists.
     */

    if (canUseDOM) {
      style = document.createElement('div').style; // On some platforms, in particular some releases of Android 4.x,
      // the un-prefixed "animation" and "transition" properties are defined on the
      // style object but the events that fire will still be prefixed, so we need
      // to check if the un-prefixed events are usable, and if not remove them from the map.

      if (!('AnimationEvent' in window)) {
        delete vendorPrefixes.animationend.animation;
        delete vendorPrefixes.animationiteration.animation;
        delete vendorPrefixes.animationstart.animation;
      } // Same as above


      if (!('TransitionEvent' in window)) {
        delete vendorPrefixes.transitionend.transition;
      }
    }
    /**
     * Attempts to determine the correct vendor prefixed event name.
     *
     * @param {string} eventName
     * @returns {string}
     */


    function getVendorPrefixedEventName(eventName) {
      if (prefixedEventNames[eventName]) {
        return prefixedEventNames[eventName];
      } else if (!vendorPrefixes[eventName]) {
        return eventName;
      }

      var prefixMap = vendorPrefixes[eventName];

      for (var styleProp in prefixMap) {
        if (prefixMap.hasOwnProperty(styleProp) && styleProp in style) {
          return prefixedEventNames[eventName] = prefixMap[styleProp];
        }
      }

      return eventName;
    }
    /**
     * To identify top level events in ReactDOM, we use constants defined by this
     * module. This is the only module that uses the unsafe* methods to express
     * that the constants actually correspond to the browser event names. This lets
     * us save some bundle size by avoiding a top level type -> event name map.
     * The rest of ReactDOM code should import top level types from this file.
     */


    var TOP_ABORT = unsafeCastStringToDOMTopLevelType('abort');
    var TOP_ANIMATION_END = unsafeCastStringToDOMTopLevelType(getVendorPrefixedEventName('animationend'));
    var TOP_ANIMATION_ITERATION = unsafeCastStringToDOMTopLevelType(getVendorPrefixedEventName('animationiteration'));
    var TOP_ANIMATION_START = unsafeCastStringToDOMTopLevelType(getVendorPrefixedEventName('animationstart'));
    var TOP_BLUR = unsafeCastStringToDOMTopLevelType('blur');
    var TOP_CAN_PLAY = unsafeCastStringToDOMTopLevelType('canplay');
    var TOP_CAN_PLAY_THROUGH = unsafeCastStringToDOMTopLevelType('canplaythrough');
    var TOP_CANCEL = unsafeCastStringToDOMTopLevelType('cancel');
    var TOP_CHANGE = unsafeCastStringToDOMTopLevelType('change');
    var TOP_CLICK = unsafeCastStringToDOMTopLevelType('click');
    var TOP_CLOSE = unsafeCastStringToDOMTopLevelType('close');
    var TOP_COMPOSITION_END = unsafeCastStringToDOMTopLevelType('compositionend');
    var TOP_COMPOSITION_START = unsafeCastStringToDOMTopLevelType('compositionstart');
    var TOP_COMPOSITION_UPDATE = unsafeCastStringToDOMTopLevelType('compositionupdate');
    var TOP_CONTEXT_MENU = unsafeCastStringToDOMTopLevelType('contextmenu');
    var TOP_COPY = unsafeCastStringToDOMTopLevelType('copy');
    var TOP_CUT = unsafeCastStringToDOMTopLevelType('cut');
    var TOP_DOUBLE_CLICK = unsafeCastStringToDOMTopLevelType('dblclick');
    var TOP_AUX_CLICK = unsafeCastStringToDOMTopLevelType('auxclick');
    var TOP_DRAG = unsafeCastStringToDOMTopLevelType('drag');
    var TOP_DRAG_END = unsafeCastStringToDOMTopLevelType('dragend');
    var TOP_DRAG_ENTER = unsafeCastStringToDOMTopLevelType('dragenter');
    var TOP_DRAG_EXIT = unsafeCastStringToDOMTopLevelType('dragexit');
    var TOP_DRAG_LEAVE = unsafeCastStringToDOMTopLevelType('dragleave');
    var TOP_DRAG_OVER = unsafeCastStringToDOMTopLevelType('dragover');
    var TOP_DRAG_START = unsafeCastStringToDOMTopLevelType('dragstart');
    var TOP_DROP = unsafeCastStringToDOMTopLevelType('drop');
    var TOP_DURATION_CHANGE = unsafeCastStringToDOMTopLevelType('durationchange');
    var TOP_EMPTIED = unsafeCastStringToDOMTopLevelType('emptied');
    var TOP_ENCRYPTED = unsafeCastStringToDOMTopLevelType('encrypted');
    var TOP_ENDED = unsafeCastStringToDOMTopLevelType('ended');
    var TOP_ERROR = unsafeCastStringToDOMTopLevelType('error');
    var TOP_FOCUS = unsafeCastStringToDOMTopLevelType('focus');
    var TOP_GOT_POINTER_CAPTURE = unsafeCastStringToDOMTopLevelType('gotpointercapture');
    var TOP_INPUT = unsafeCastStringToDOMTopLevelType('input');
    var TOP_INVALID = unsafeCastStringToDOMTopLevelType('invalid');
    var TOP_KEY_DOWN = unsafeCastStringToDOMTopLevelType('keydown');
    var TOP_KEY_PRESS = unsafeCastStringToDOMTopLevelType('keypress');
    var TOP_KEY_UP = unsafeCastStringToDOMTopLevelType('keyup');
    var TOP_LOAD = unsafeCastStringToDOMTopLevelType('load');
    var TOP_LOAD_START = unsafeCastStringToDOMTopLevelType('loadstart');
    var TOP_LOADED_DATA = unsafeCastStringToDOMTopLevelType('loadeddata');
    var TOP_LOADED_METADATA = unsafeCastStringToDOMTopLevelType('loadedmetadata');
    var TOP_LOST_POINTER_CAPTURE = unsafeCastStringToDOMTopLevelType('lostpointercapture');
    var TOP_MOUSE_DOWN = unsafeCastStringToDOMTopLevelType('mousedown');
    var TOP_MOUSE_MOVE = unsafeCastStringToDOMTopLevelType('mousemove');
    var TOP_MOUSE_OUT = unsafeCastStringToDOMTopLevelType('mouseout');
    var TOP_MOUSE_OVER = unsafeCastStringToDOMTopLevelType('mouseover');
    var TOP_MOUSE_UP = unsafeCastStringToDOMTopLevelType('mouseup');
    var TOP_PASTE = unsafeCastStringToDOMTopLevelType('paste');
    var TOP_PAUSE = unsafeCastStringToDOMTopLevelType('pause');
    var TOP_PLAY = unsafeCastStringToDOMTopLevelType('play');
    var TOP_PLAYING = unsafeCastStringToDOMTopLevelType('playing');
    var TOP_POINTER_CANCEL = unsafeCastStringToDOMTopLevelType('pointercancel');
    var TOP_POINTER_DOWN = unsafeCastStringToDOMTopLevelType('pointerdown');
    var TOP_POINTER_MOVE = unsafeCastStringToDOMTopLevelType('pointermove');
    var TOP_POINTER_OUT = unsafeCastStringToDOMTopLevelType('pointerout');
    var TOP_POINTER_OVER = unsafeCastStringToDOMTopLevelType('pointerover');
    var TOP_POINTER_UP = unsafeCastStringToDOMTopLevelType('pointerup');
    var TOP_PROGRESS = unsafeCastStringToDOMTopLevelType('progress');
    var TOP_RATE_CHANGE = unsafeCastStringToDOMTopLevelType('ratechange');
    var TOP_RESET = unsafeCastStringToDOMTopLevelType('reset');
    var TOP_SCROLL = unsafeCastStringToDOMTopLevelType('scroll');
    var TOP_SEEKED = unsafeCastStringToDOMTopLevelType('seeked');
    var TOP_SEEKING = unsafeCastStringToDOMTopLevelType('seeking');
    var TOP_SELECTION_CHANGE = unsafeCastStringToDOMTopLevelType('selectionchange');
    var TOP_STALLED = unsafeCastStringToDOMTopLevelType('stalled');
    var TOP_SUBMIT = unsafeCastStringToDOMTopLevelType('submit');
    var TOP_SUSPEND = unsafeCastStringToDOMTopLevelType('suspend');
    var TOP_TEXT_INPUT = unsafeCastStringToDOMTopLevelType('textInput');
    var TOP_TIME_UPDATE = unsafeCastStringToDOMTopLevelType('timeupdate');
    var TOP_TOGGLE = unsafeCastStringToDOMTopLevelType('toggle');
    var TOP_TOUCH_CANCEL = unsafeCastStringToDOMTopLevelType('touchcancel');
    var TOP_TOUCH_END = unsafeCastStringToDOMTopLevelType('touchend');
    var TOP_TOUCH_MOVE = unsafeCastStringToDOMTopLevelType('touchmove');
    var TOP_TOUCH_START = unsafeCastStringToDOMTopLevelType('touchstart');
    var TOP_TRANSITION_END = unsafeCastStringToDOMTopLevelType(getVendorPrefixedEventName('transitionend'));
    var TOP_VOLUME_CHANGE = unsafeCastStringToDOMTopLevelType('volumechange');
    var TOP_WAITING = unsafeCastStringToDOMTopLevelType('waiting');
    var TOP_WHEEL = unsafeCastStringToDOMTopLevelType('wheel'); // List of events that need to be individually attached to media elements.
    // Note that events in this list will *not* be listened to at the top level
    // unless they're explicitly whitelisted in `ReactBrowserEventEmitter.listenTo`.

    var mediaEventTypes = [TOP_ABORT, TOP_CAN_PLAY, TOP_CAN_PLAY_THROUGH, TOP_DURATION_CHANGE, TOP_EMPTIED, TOP_ENCRYPTED, TOP_ENDED, TOP_ERROR, TOP_LOADED_DATA, TOP_LOADED_METADATA, TOP_LOAD_START, TOP_PAUSE, TOP_PLAY, TOP_PLAYING, TOP_PROGRESS, TOP_RATE_CHANGE, TOP_SEEKED, TOP_SEEKING, TOP_STALLED, TOP_SUSPEND, TOP_TIME_UPDATE, TOP_VOLUME_CHANGE, TOP_WAITING];

    function getRawEventName(topLevelType) {
      return unsafeCastDOMTopLevelTypeToString(topLevelType);
    }
    /**
     * `ReactInstanceMap` maintains a mapping from a public facing stateful
     * instance (key) and the internal representation (value). This allows public
     * methods to accept the user facing instance as an argument and map them back
     * to internal methods.
     *
     * Note that this module is currently shared and assumed to be stateless.
     * If this becomes an actual Map, that will break.
     */

    /**
     * This API should be called `delete` but we'd have to make sure to always
     * transform these to strings for IE support. When this transform is fully
     * supported we can rename it.
     */


    function get(key) {
      return key._reactInternalFiber;
    }

    function has(key) {
      return key._reactInternalFiber !== undefined;
    }

    function set(key, value) {
      key._reactInternalFiber = value;
    } // Don't change these two values. They're used by React Dev Tools.


    var NoEffect =
    /*              */
    0;
    var PerformedWork =
    /*         */
    1; // You can change the rest (and add more).

    var Placement =
    /*             */
    2;
    var Update =
    /*                */
    4;
    var PlacementAndUpdate =
    /*    */
    6;
    var Deletion =
    /*              */
    8;
    var ContentReset =
    /*          */
    16;
    var Callback =
    /*              */
    32;
    var DidCapture =
    /*            */
    64;
    var Ref =
    /*                   */
    128;
    var Snapshot =
    /*              */
    256;
    var Passive =
    /*               */
    512;
    var Hydrating =
    /*             */
    1024;
    var HydratingAndUpdate =
    /*    */
    1028; // Passive & Update & Callback & Ref & Snapshot

    var LifecycleEffectMask =
    /*   */
    932; // Union of all host effects

    var HostEffectMask =
    /*        */
    2047;
    var Incomplete =
    /*            */
    2048;
    var ShouldCapture =
    /*         */
    4096;
    var ReactCurrentOwner = ReactSharedInternals.ReactCurrentOwner;

    function getNearestMountedFiber(fiber) {
      var node = fiber;
      var nearestMounted = fiber;

      if (!fiber.alternate) {
        // If there is no alternate, this might be a new tree that isn't inserted
        // yet. If it is, then it will have a pending insertion effect on it.
        var nextNode = node;

        do {
          node = nextNode;

          if ((node.effectTag & (Placement | Hydrating)) !== NoEffect) {
            // This is an insertion or in-progress hydration. The nearest possible
            // mounted fiber is the parent but we need to continue to figure out
            // if that one is still mounted.
            nearestMounted = node.return;
          }

          nextNode = node.return;
        } while (nextNode);
      } else {
        while (node.return) {
          node = node.return;
        }
      }

      if (node.tag === HostRoot) {
        // TODO: Check if this was a nested HostRoot when used with
        // renderContainerIntoSubtree.
        return nearestMounted;
      } // If we didn't hit the root, that means that we're in an disconnected tree
      // that has been unmounted.


      return null;
    }

    function getSuspenseInstanceFromFiber(fiber) {
      if (fiber.tag === SuspenseComponent) {
        var suspenseState = fiber.memoizedState;

        if (suspenseState === null) {
          var current = fiber.alternate;

          if (current !== null) {
            suspenseState = current.memoizedState;
          }
        }

        if (suspenseState !== null) {
          return suspenseState.dehydrated;
        }
      }

      return null;
    }

    function getContainerFromFiber(fiber) {
      return fiber.tag === HostRoot ? fiber.stateNode.containerInfo : null;
    }

    function isFiberMounted(fiber) {
      return getNearestMountedFiber(fiber) === fiber;
    }

    function isMounted(component) {
      {
        var owner = ReactCurrentOwner.current;

        if (owner !== null && owner.tag === ClassComponent) {
          var ownerFiber = owner;
          var instance = ownerFiber.stateNode;
          !instance._warnedAboutRefsInRender ? warningWithoutStack$1(false, '%s is accessing isMounted inside its render() function. ' + 'render() should be a pure function of props and state. It should ' + 'never access something that requires stale data from the previous ' + 'render, such as refs. Move this logic to componentDidMount and ' + 'componentDidUpdate instead.', getComponentName(ownerFiber.type) || 'A component') : void 0;
          instance._warnedAboutRefsInRender = true;
        }
      }
      var fiber = get(component);

      if (!fiber) {
        return false;
      }

      return getNearestMountedFiber(fiber) === fiber;
    }

    function assertIsMounted(fiber) {
      if (!(getNearestMountedFiber(fiber) === fiber)) {
        {
          throw Error("Unable to find node on an unmounted component.");
        }
      }
    }

    function findCurrentFiberUsingSlowPath(fiber) {
      var alternate = fiber.alternate;

      if (!alternate) {
        // If there is no alternate, then we only need to check if it is mounted.
        var nearestMounted = getNearestMountedFiber(fiber);

        if (!(nearestMounted !== null)) {
          {
            throw Error("Unable to find node on an unmounted component.");
          }
        }

        if (nearestMounted !== fiber) {
          return null;
        }

        return fiber;
      } // If we have two possible branches, we'll walk backwards up to the root
      // to see what path the root points to. On the way we may hit one of the
      // special cases and we'll deal with them.


      var a = fiber;
      var b = alternate;

      while (true) {
        var parentA = a.return;

        if (parentA === null) {
          // We're at the root.
          break;
        }

        var parentB = parentA.alternate;

        if (parentB === null) {
          // There is no alternate. This is an unusual case. Currently, it only
          // happens when a Suspense component is hidden. An extra fragment fiber
          // is inserted in between the Suspense fiber and its children. Skip
          // over this extra fragment fiber and proceed to the next parent.
          var nextParent = parentA.return;

          if (nextParent !== null) {
            a = b = nextParent;
            continue;
          } // If there's no parent, we're at the root.


          break;
        } // If both copies of the parent fiber point to the same child, we can
        // assume that the child is current. This happens when we bailout on low
        // priority: the bailed out fiber's child reuses the current child.


        if (parentA.child === parentB.child) {
          var child = parentA.child;

          while (child) {
            if (child === a) {
              // We've determined that A is the current branch.
              assertIsMounted(parentA);
              return fiber;
            }

            if (child === b) {
              // We've determined that B is the current branch.
              assertIsMounted(parentA);
              return alternate;
            }

            child = child.sibling;
          } // We should never have an alternate for any mounting node. So the only
          // way this could possibly happen is if this was unmounted, if at all.


          {
            {
              throw Error("Unable to find node on an unmounted component.");
            }
          }
        }

        if (a.return !== b.return) {
          // The return pointer of A and the return pointer of B point to different
          // fibers. We assume that return pointers never criss-cross, so A must
          // belong to the child set of A.return, and B must belong to the child
          // set of B.return.
          a = parentA;
          b = parentB;
        } else {
          // The return pointers point to the same fiber. We'll have to use the
          // default, slow path: scan the child sets of each parent alternate to see
          // which child belongs to which set.
          //
          // Search parent A's child set
          var didFindChild = false;
          var _child = parentA.child;

          while (_child) {
            if (_child === a) {
              didFindChild = true;
              a = parentA;
              b = parentB;
              break;
            }

            if (_child === b) {
              didFindChild = true;
              b = parentA;
              a = parentB;
              break;
            }

            _child = _child.sibling;
          }

          if (!didFindChild) {
            // Search parent B's child set
            _child = parentB.child;

            while (_child) {
              if (_child === a) {
                didFindChild = true;
                a = parentB;
                b = parentA;
                break;
              }

              if (_child === b) {
                didFindChild = true;
                b = parentB;
                a = parentA;
                break;
              }

              _child = _child.sibling;
            }

            if (!didFindChild) {
              {
                throw Error("Child was not found in either parent set. This indicates a bug in React related to the return pointer. Please file an issue.");
              }
            }
          }
        }

        if (!(a.alternate === b)) {
          {
            throw Error("Return fibers should always be each others' alternates. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      } // If the root is not a host container, we're in a disconnected tree. I.e.
      // unmounted.


      if (!(a.tag === HostRoot)) {
        {
          throw Error("Unable to find node on an unmounted component.");
        }
      }

      if (a.stateNode.current === a) {
        // We've determined that A is the current branch.
        return fiber;
      } // Otherwise B has to be current branch.


      return alternate;
    }

    function findCurrentHostFiber(parent) {
      var currentParent = findCurrentFiberUsingSlowPath(parent);

      if (!currentParent) {
        return null;
      } // Next we'll drill down this component to find the first HostComponent/Text.


      var node = currentParent;

      while (true) {
        if (node.tag === HostComponent || node.tag === HostText) {
          return node;
        } else if (node.child) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === currentParent) {
          return null;
        }

        while (!node.sibling) {
          if (!node.return || node.return === currentParent) {
            return null;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      } // Flow needs the return null here, but ESLint complains about it.
      // eslint-disable-next-line no-unreachable


      return null;
    }

    function findCurrentHostFiberWithNoPortals(parent) {
      var currentParent = findCurrentFiberUsingSlowPath(parent);

      if (!currentParent) {
        return null;
      } // Next we'll drill down this component to find the first HostComponent/Text.


      var node = currentParent;

      while (true) {
        if (node.tag === HostComponent || node.tag === HostText || enableFundamentalAPI && node.tag === FundamentalComponent) {
          return node;
        } else if (node.child && node.tag !== HostPortal) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === currentParent) {
          return null;
        }

        while (!node.sibling) {
          if (!node.return || node.return === currentParent) {
            return null;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      } // Flow needs the return null here, but ESLint complains about it.
      // eslint-disable-next-line no-unreachable


      return null;
    }

    var attemptSynchronousHydration;

    function setAttemptSynchronousHydration(fn) {
      attemptSynchronousHydration = fn;
    }

    var attemptUserBlockingHydration;

    function setAttemptUserBlockingHydration(fn) {
      attemptUserBlockingHydration = fn;
    }

    var attemptContinuousHydration;

    function setAttemptContinuousHydration(fn) {
      attemptContinuousHydration = fn;
    }

    var attemptHydrationAtCurrentPriority;

    function setAttemptHydrationAtCurrentPriority(fn) {
      attemptHydrationAtCurrentPriority = fn;
    } // TODO: Upgrade this definition once we're on a newer version of Flow that
    // has this definition built-in.


    var hasScheduledReplayAttempt = false; // The queue of discrete events to be replayed.

    var queuedDiscreteEvents = []; // Indicates if any continuous event targets are non-null for early bailout.
    // if the last target was dehydrated.

    var queuedFocus = null;
    var queuedDrag = null;
    var queuedMouse = null; // For pointer events there can be one latest event per pointerId.

    var queuedPointers = new Map();
    var queuedPointerCaptures = new Map(); // We could consider replaying selectionchange and touchmoves too.

    var queuedExplicitHydrationTargets = [];

    function hasQueuedDiscreteEvents() {
      return queuedDiscreteEvents.length > 0;
    }

    var discreteReplayableEvents = [TOP_MOUSE_DOWN, TOP_MOUSE_UP, TOP_TOUCH_CANCEL, TOP_TOUCH_END, TOP_TOUCH_START, TOP_AUX_CLICK, TOP_DOUBLE_CLICK, TOP_POINTER_CANCEL, TOP_POINTER_DOWN, TOP_POINTER_UP, TOP_DRAG_END, TOP_DRAG_START, TOP_DROP, TOP_COMPOSITION_END, TOP_COMPOSITION_START, TOP_KEY_DOWN, TOP_KEY_PRESS, TOP_KEY_UP, TOP_INPUT, TOP_TEXT_INPUT, TOP_CLOSE, TOP_CANCEL, TOP_COPY, TOP_CUT, TOP_PASTE, TOP_CLICK, TOP_CHANGE, TOP_CONTEXT_MENU, TOP_RESET, TOP_SUBMIT];
    var continuousReplayableEvents = [TOP_FOCUS, TOP_BLUR, TOP_DRAG_ENTER, TOP_DRAG_LEAVE, TOP_MOUSE_OVER, TOP_MOUSE_OUT, TOP_POINTER_OVER, TOP_POINTER_OUT, TOP_GOT_POINTER_CAPTURE, TOP_LOST_POINTER_CAPTURE];

    function isReplayableDiscreteEvent(eventType) {
      return discreteReplayableEvents.indexOf(eventType) > -1;
    }

    function trapReplayableEvent(topLevelType, document, listeningSet) {
      listenToTopLevel(topLevelType, document, listeningSet);

      if (enableFlareAPI) {
        // Trap events for the responder system.
        var passiveEventKey = unsafeCastDOMTopLevelTypeToString(topLevelType) + '_passive';

        if (!listeningSet.has(passiveEventKey)) {
          trapEventForResponderEventSystem(document, topLevelType, true);
          listeningSet.add(passiveEventKey);
        } // TODO: This listens to all events as active which might have
        // undesirable effects. It's also unnecessary to have both
        // passive and active listeners. Instead, we could start with
        // a passive and upgrade it to an active one if needed.
        // For replaying purposes the active is never needed since we
        // currently don't preventDefault.


        var activeEventKey = unsafeCastDOMTopLevelTypeToString(topLevelType) + '_active';

        if (!listeningSet.has(activeEventKey)) {
          trapEventForResponderEventSystem(document, topLevelType, false);
          listeningSet.add(activeEventKey);
        }
      }
    }

    function eagerlyTrapReplayableEvents(document) {
      var listeningSet = getListeningSetForElement(document); // Discrete

      discreteReplayableEvents.forEach(function (topLevelType) {
        trapReplayableEvent(topLevelType, document, listeningSet);
      }); // Continuous

      continuousReplayableEvents.forEach(function (topLevelType) {
        trapReplayableEvent(topLevelType, document, listeningSet);
      });
    }

    function createQueuedReplayableEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent) {
      return {
        blockedOn: blockedOn,
        topLevelType: topLevelType,
        eventSystemFlags: eventSystemFlags | IS_REPLAYED,
        nativeEvent: nativeEvent
      };
    }

    function queueDiscreteEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent) {
      var queuedEvent = createQueuedReplayableEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent);
      queuedDiscreteEvents.push(queuedEvent);

      if (enableSelectiveHydration) {
        if (queuedDiscreteEvents.length === 1) {
          // If this was the first discrete event, we might be able to
          // synchronously unblock it so that preventDefault still works.
          while (queuedEvent.blockedOn !== null) {
            var _fiber = getInstanceFromNode$1(queuedEvent.blockedOn);

            if (_fiber === null) {
              break;
            }

            attemptSynchronousHydration(_fiber);

            if (queuedEvent.blockedOn === null) {
              // We got unblocked by hydration. Let's try again.
              replayUnblockedEvents(); // If we're reblocked, on an inner boundary, we might need
              // to attempt hydrating that one.

              continue;
            } else {
              // We're still blocked from hydation, we have to give up
              // and replay later.
              break;
            }
          }
        }
      }
    } // Resets the replaying for this type of continuous event to no event.


    function clearIfContinuousEvent(topLevelType, nativeEvent) {
      switch (topLevelType) {
        case TOP_FOCUS:
        case TOP_BLUR:
          queuedFocus = null;
          break;

        case TOP_DRAG_ENTER:
        case TOP_DRAG_LEAVE:
          queuedDrag = null;
          break;

        case TOP_MOUSE_OVER:
        case TOP_MOUSE_OUT:
          queuedMouse = null;
          break;

        case TOP_POINTER_OVER:
        case TOP_POINTER_OUT:
          {
            var pointerId = nativeEvent.pointerId;
            queuedPointers.delete(pointerId);
            break;
          }

        case TOP_GOT_POINTER_CAPTURE:
        case TOP_LOST_POINTER_CAPTURE:
          {
            var _pointerId = nativeEvent.pointerId;
            queuedPointerCaptures.delete(_pointerId);
            break;
          }
      }
    }

    function accumulateOrCreateContinuousQueuedReplayableEvent(existingQueuedEvent, blockedOn, topLevelType, eventSystemFlags, nativeEvent) {
      if (existingQueuedEvent === null || existingQueuedEvent.nativeEvent !== nativeEvent) {
        var queuedEvent = createQueuedReplayableEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent);

        if (blockedOn !== null) {
          var _fiber2 = getInstanceFromNode$1(blockedOn);

          if (_fiber2 !== null) {
            // Attempt to increase the priority of this target.
            attemptContinuousHydration(_fiber2);
          }
        }

        return queuedEvent;
      } // If we have already queued this exact event, then it's because
      // the different event systems have different DOM event listeners.
      // We can accumulate the flags and store a single event to be
      // replayed.


      existingQueuedEvent.eventSystemFlags |= eventSystemFlags;
      return existingQueuedEvent;
    }

    function queueIfContinuousEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent) {
      // These set relatedTarget to null because the replayed event will be treated as if we
      // moved from outside the window (no target) onto the target once it hydrates.
      // Instead of mutating we could clone the event.
      switch (topLevelType) {
        case TOP_FOCUS:
          {
            var focusEvent = nativeEvent;
            queuedFocus = accumulateOrCreateContinuousQueuedReplayableEvent(queuedFocus, blockedOn, topLevelType, eventSystemFlags, focusEvent);
            return true;
          }

        case TOP_DRAG_ENTER:
          {
            var dragEvent = nativeEvent;
            queuedDrag = accumulateOrCreateContinuousQueuedReplayableEvent(queuedDrag, blockedOn, topLevelType, eventSystemFlags, dragEvent);
            return true;
          }

        case TOP_MOUSE_OVER:
          {
            var mouseEvent = nativeEvent;
            queuedMouse = accumulateOrCreateContinuousQueuedReplayableEvent(queuedMouse, blockedOn, topLevelType, eventSystemFlags, mouseEvent);
            return true;
          }

        case TOP_POINTER_OVER:
          {
            var pointerEvent = nativeEvent;
            var pointerId = pointerEvent.pointerId;
            queuedPointers.set(pointerId, accumulateOrCreateContinuousQueuedReplayableEvent(queuedPointers.get(pointerId) || null, blockedOn, topLevelType, eventSystemFlags, pointerEvent));
            return true;
          }

        case TOP_GOT_POINTER_CAPTURE:
          {
            var _pointerEvent = nativeEvent;
            var _pointerId2 = _pointerEvent.pointerId;
            queuedPointerCaptures.set(_pointerId2, accumulateOrCreateContinuousQueuedReplayableEvent(queuedPointerCaptures.get(_pointerId2) || null, blockedOn, topLevelType, eventSystemFlags, _pointerEvent));
            return true;
          }
      }

      return false;
    } // Check if this target is unblocked. Returns true if it's unblocked.


    function attemptExplicitHydrationTarget(queuedTarget) {
      // TODO: This function shares a lot of logic with attemptToDispatchEvent.
      // Try to unify them. It's a bit tricky since it would require two return
      // values.
      var targetInst = getClosestInstanceFromNode(queuedTarget.target);

      if (targetInst !== null) {
        var nearestMounted = getNearestMountedFiber(targetInst);

        if (nearestMounted !== null) {
          var tag = nearestMounted.tag;

          if (tag === SuspenseComponent) {
            var instance = getSuspenseInstanceFromFiber(nearestMounted);

            if (instance !== null) {
              // We're blocked on hydrating this boundary.
              // Increase its priority.
              queuedTarget.blockedOn = instance;
              Scheduler.unstable_runWithPriority(queuedTarget.priority, function () {
                attemptHydrationAtCurrentPriority(nearestMounted);
              });
              return;
            }
          } else if (tag === HostRoot) {
            var root = nearestMounted.stateNode;

            if (root.hydrate) {
              queuedTarget.blockedOn = getContainerFromFiber(nearestMounted); // We don't currently have a way to increase the priority of
              // a root other than sync.

              return;
            }
          }
        }
      }

      queuedTarget.blockedOn = null;
    }

    function queueExplicitHydrationTarget(target) {
      if (enableSelectiveHydration) {
        var priority = Scheduler.unstable_getCurrentPriorityLevel();
        var queuedTarget = {
          blockedOn: null,
          target: target,
          priority: priority
        };
        var i = 0;

        for (; i < queuedExplicitHydrationTargets.length; i++) {
          if (priority <= queuedExplicitHydrationTargets[i].priority) {
            break;
          }
        }

        queuedExplicitHydrationTargets.splice(i, 0, queuedTarget);

        if (i === 0) {
          attemptExplicitHydrationTarget(queuedTarget);
        }
      }
    }

    function attemptReplayContinuousQueuedEvent(queuedEvent) {
      if (queuedEvent.blockedOn !== null) {
        return false;
      }

      var nextBlockedOn = attemptToDispatchEvent(queuedEvent.topLevelType, queuedEvent.eventSystemFlags, queuedEvent.nativeEvent);

      if (nextBlockedOn !== null) {
        // We're still blocked. Try again later.
        var _fiber3 = getInstanceFromNode$1(nextBlockedOn);

        if (_fiber3 !== null) {
          attemptContinuousHydration(_fiber3);
        }

        queuedEvent.blockedOn = nextBlockedOn;
        return false;
      }

      return true;
    }

    function attemptReplayContinuousQueuedEventInMap(queuedEvent, key, map) {
      if (attemptReplayContinuousQueuedEvent(queuedEvent)) {
        map.delete(key);
      }
    }

    function replayUnblockedEvents() {
      hasScheduledReplayAttempt = false; // First replay discrete events.

      while (queuedDiscreteEvents.length > 0) {
        var nextDiscreteEvent = queuedDiscreteEvents[0];

        if (nextDiscreteEvent.blockedOn !== null) {
          // We're still blocked.
          // Increase the priority of this boundary to unblock
          // the next discrete event.
          var _fiber4 = getInstanceFromNode$1(nextDiscreteEvent.blockedOn);

          if (_fiber4 !== null) {
            attemptUserBlockingHydration(_fiber4);
          }

          break;
        }

        var nextBlockedOn = attemptToDispatchEvent(nextDiscreteEvent.topLevelType, nextDiscreteEvent.eventSystemFlags, nextDiscreteEvent.nativeEvent);

        if (nextBlockedOn !== null) {
          // We're still blocked. Try again later.
          nextDiscreteEvent.blockedOn = nextBlockedOn;
        } else {
          // We've successfully replayed the first event. Let's try the next one.
          queuedDiscreteEvents.shift();
        }
      } // Next replay any continuous events.


      if (queuedFocus !== null && attemptReplayContinuousQueuedEvent(queuedFocus)) {
        queuedFocus = null;
      }

      if (queuedDrag !== null && attemptReplayContinuousQueuedEvent(queuedDrag)) {
        queuedDrag = null;
      }

      if (queuedMouse !== null && attemptReplayContinuousQueuedEvent(queuedMouse)) {
        queuedMouse = null;
      }

      queuedPointers.forEach(attemptReplayContinuousQueuedEventInMap);
      queuedPointerCaptures.forEach(attemptReplayContinuousQueuedEventInMap);
    }

    function scheduleCallbackIfUnblocked(queuedEvent, unblocked) {
      if (queuedEvent.blockedOn === unblocked) {
        queuedEvent.blockedOn = null;

        if (!hasScheduledReplayAttempt) {
          hasScheduledReplayAttempt = true; // Schedule a callback to attempt replaying as many events as are
          // now unblocked. This first might not actually be unblocked yet.
          // We could check it early to avoid scheduling an unnecessary callback.

          Scheduler.unstable_scheduleCallback(Scheduler.unstable_NormalPriority, replayUnblockedEvents);
        }
      }
    }

    function retryIfBlockedOn(unblocked) {
      // Mark anything that was blocked on this as no longer blocked
      // and eligible for a replay.
      if (queuedDiscreteEvents.length > 0) {
        scheduleCallbackIfUnblocked(queuedDiscreteEvents[0], unblocked); // This is a exponential search for each boundary that commits. I think it's
        // worth it because we expect very few discrete events to queue up and once
        // we are actually fully unblocked it will be fast to replay them.

        for (var i = 1; i < queuedDiscreteEvents.length; i++) {
          var queuedEvent = queuedDiscreteEvents[i];

          if (queuedEvent.blockedOn === unblocked) {
            queuedEvent.blockedOn = null;
          }
        }
      }

      if (queuedFocus !== null) {
        scheduleCallbackIfUnblocked(queuedFocus, unblocked);
      }

      if (queuedDrag !== null) {
        scheduleCallbackIfUnblocked(queuedDrag, unblocked);
      }

      if (queuedMouse !== null) {
        scheduleCallbackIfUnblocked(queuedMouse, unblocked);
      }

      var unblock = function (queuedEvent) {
        return scheduleCallbackIfUnblocked(queuedEvent, unblocked);
      };

      queuedPointers.forEach(unblock);
      queuedPointerCaptures.forEach(unblock);

      for (var _i = 0; _i < queuedExplicitHydrationTargets.length; _i++) {
        var queuedTarget = queuedExplicitHydrationTargets[_i];

        if (queuedTarget.blockedOn === unblocked) {
          queuedTarget.blockedOn = null;
        }
      }

      while (queuedExplicitHydrationTargets.length > 0) {
        var nextExplicitTarget = queuedExplicitHydrationTargets[0];

        if (nextExplicitTarget.blockedOn !== null) {
          // We're still blocked.
          break;
        } else {
          attemptExplicitHydrationTarget(nextExplicitTarget);

          if (nextExplicitTarget.blockedOn === null) {
            // We're unblocked.
            queuedExplicitHydrationTargets.shift();
          }
        }
      }
    }

    function addEventBubbleListener(element, eventType, listener) {
      element.addEventListener(eventType, listener, false);
    }

    function addEventCaptureListener(element, eventType, listener) {
      element.addEventListener(eventType, listener, true);
    }

    function addEventCaptureListenerWithPassiveFlag(element, eventType, listener, passive) {
      element.addEventListener(eventType, listener, {
        capture: true,
        passive: passive
      });
    }
    /**
     * Gets the target node from a native browser event by accounting for
     * inconsistencies in browser DOM APIs.
     *
     * @param {object} nativeEvent Native browser event.
     * @return {DOMEventTarget} Target node.
     */


    function getEventTarget(nativeEvent) {
      // Fallback to nativeEvent.srcElement for IE9
      // https://github.com/facebook/react/issues/12506
      var target = nativeEvent.target || nativeEvent.srcElement || window; // Normalize SVG <use> element events #4963

      if (target.correspondingUseElement) {
        target = target.correspondingUseElement;
      } // Safari may fire events on text nodes (Node.TEXT_NODE is 3).
      // @see http://www.quirksmode.org/js/events_properties.html


      return target.nodeType === TEXT_NODE ? target.parentNode : target;
    }

    function getParent(inst) {
      do {
        inst = inst.return; // TODO: If this is a HostRoot we might want to bail out.
        // That is depending on if we want nested subtrees (layers) to bubble
        // events to their parent. We could also go through parentNode on the
        // host node but that wouldn't work for React Native and doesn't let us
        // do the portal feature.
      } while (inst && inst.tag !== HostComponent);

      if (inst) {
        return inst;
      }

      return null;
    }
    /**
     * Return the lowest common ancestor of A and B, or null if they are in
     * different trees.
     */


    function getLowestCommonAncestor(instA, instB) {
      var depthA = 0;

      for (var tempA = instA; tempA; tempA = getParent(tempA)) {
        depthA++;
      }

      var depthB = 0;

      for (var tempB = instB; tempB; tempB = getParent(tempB)) {
        depthB++;
      } // If A is deeper, crawl up.


      while (depthA - depthB > 0) {
        instA = getParent(instA);
        depthA--;
      } // If B is deeper, crawl up.


      while (depthB - depthA > 0) {
        instB = getParent(instB);
        depthB--;
      } // Walk in lockstep until we find a match.


      var depth = depthA;

      while (depth--) {
        if (instA === instB || instA === instB.alternate) {
          return instA;
        }

        instA = getParent(instA);
        instB = getParent(instB);
      }

      return null;
    }
    /**
     * Return if A is an ancestor of B.
     */

    /**
     * Return the parent instance of the passed-in instance.
     */

    /**
     * Simulates the traversal of a two-phase, capture/bubble event dispatch.
     */


    function traverseTwoPhase(inst, fn, arg) {
      var path = [];

      while (inst) {
        path.push(inst);
        inst = getParent(inst);
      }

      var i;

      for (i = path.length; i-- > 0;) {
        fn(path[i], 'captured', arg);
      }

      for (i = 0; i < path.length; i++) {
        fn(path[i], 'bubbled', arg);
      }
    }
    /**
     * Traverses the ID hierarchy and invokes the supplied `cb` on any IDs that
     * should would receive a `mouseEnter` or `mouseLeave` event.
     *
     * Does not invoke the callback on the nearest common ancestor because nothing
     * "entered" or "left" that element.
     */


    function traverseEnterLeave(from, to, fn, argFrom, argTo) {
      var common = from && to ? getLowestCommonAncestor(from, to) : null;
      var pathFrom = [];

      while (true) {
        if (!from) {
          break;
        }

        if (from === common) {
          break;
        }

        var alternate = from.alternate;

        if (alternate !== null && alternate === common) {
          break;
        }

        pathFrom.push(from);
        from = getParent(from);
      }

      var pathTo = [];

      while (true) {
        if (!to) {
          break;
        }

        if (to === common) {
          break;
        }

        var _alternate = to.alternate;

        if (_alternate !== null && _alternate === common) {
          break;
        }

        pathTo.push(to);
        to = getParent(to);
      }

      for (var i = 0; i < pathFrom.length; i++) {
        fn(pathFrom[i], 'bubbled', argFrom);
      }

      for (var _i = pathTo.length; _i-- > 0;) {
        fn(pathTo[_i], 'captured', argTo);
      }
    }
    /**
     * Some event types have a notion of different registration names for different
     * "phases" of propagation. This finds listeners by a given phase.
     */


    function listenerAtPhase(inst, event, propagationPhase) {
      var registrationName = event.dispatchConfig.phasedRegistrationNames[propagationPhase];
      return getListener(inst, registrationName);
    }
    /**
     * A small set of propagation patterns, each of which will accept a small amount
     * of information, and generate a set of "dispatch ready event objects" - which
     * are sets of events that have already been annotated with a set of dispatched
     * listener functions/ids. The API is designed this way to discourage these
     * propagation strategies from actually executing the dispatches, since we
     * always want to collect the entire set of dispatches before executing even a
     * single one.
     */

    /**
     * Tags a `SyntheticEvent` with dispatched listeners. Creating this function
     * here, allows us to not have to bind or create functions for each event.
     * Mutating the event's members allows us to not have to create a wrapping
     * "dispatch" object that pairs the event with the listener.
     */


    function accumulateDirectionalDispatches(inst, phase, event) {
      {
        !inst ? warningWithoutStack$1(false, 'Dispatching inst must not be null') : void 0;
      }
      var listener = listenerAtPhase(inst, event, phase);

      if (listener) {
        event._dispatchListeners = accumulateInto(event._dispatchListeners, listener);
        event._dispatchInstances = accumulateInto(event._dispatchInstances, inst);
      }
    }
    /**
     * Collect dispatches (must be entirely collected before dispatching - see unit
     * tests). Lazily allocate the array to conserve memory.  We must loop through
     * each event and perform the traversal for each one. We cannot perform a
     * single traversal for the entire collection of events because each event may
     * have a different target.
     */


    function accumulateTwoPhaseDispatchesSingle(event) {
      if (event && event.dispatchConfig.phasedRegistrationNames) {
        traverseTwoPhase(event._targetInst, accumulateDirectionalDispatches, event);
      }
    }
    /**
     * Accumulates without regard to direction, does not look for phased
     * registration names. Same as `accumulateDirectDispatchesSingle` but without
     * requiring that the `dispatchMarker` be the same as the dispatched ID.
     */


    function accumulateDispatches(inst, ignoredDirection, event) {
      if (inst && event && event.dispatchConfig.registrationName) {
        var registrationName = event.dispatchConfig.registrationName;
        var listener = getListener(inst, registrationName);

        if (listener) {
          event._dispatchListeners = accumulateInto(event._dispatchListeners, listener);
          event._dispatchInstances = accumulateInto(event._dispatchInstances, inst);
        }
      }
    }
    /**
     * Accumulates dispatches on an `SyntheticEvent`, but only for the
     * `dispatchMarker`.
     * @param {SyntheticEvent} event
     */


    function accumulateDirectDispatchesSingle(event) {
      if (event && event.dispatchConfig.registrationName) {
        accumulateDispatches(event._targetInst, null, event);
      }
    }

    function accumulateTwoPhaseDispatches(events) {
      forEachAccumulated(events, accumulateTwoPhaseDispatchesSingle);
    }

    function accumulateEnterLeaveDispatches(leave, enter, from, to) {
      traverseEnterLeave(from, to, accumulateDispatches, leave, enter);
    }

    function accumulateDirectDispatches(events) {
      forEachAccumulated(events, accumulateDirectDispatchesSingle);
    }
    /* eslint valid-typeof: 0 */


    var EVENT_POOL_SIZE = 10;
    /**
     * @interface Event
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */

    var EventInterface = {
      type: null,
      target: null,
      // currentTarget is set when dispatching; no use in copying it here
      currentTarget: function () {
        return null;
      },
      eventPhase: null,
      bubbles: null,
      cancelable: null,
      timeStamp: function (event) {
        return event.timeStamp || Date.now();
      },
      defaultPrevented: null,
      isTrusted: null
    };

    function functionThatReturnsTrue() {
      return true;
    }

    function functionThatReturnsFalse() {
      return false;
    }
    /**
     * Synthetic events are dispatched by event plugins, typically in response to a
     * top-level event delegation handler.
     *
     * These systems should generally use pooling to reduce the frequency of garbage
     * collection. The system should check `isPersistent` to determine whether the
     * event should be released into the pool after being dispatched. Users that
     * need a persisted event should invoke `persist`.
     *
     * Synthetic events (and subclasses) implement the DOM Level 3 Events API by
     * normalizing browser quirks. Subclasses do not necessarily have to implement a
     * DOM interface; custom application-specific events can also subclass this.
     *
     * @param {object} dispatchConfig Configuration used to dispatch this event.
     * @param {*} targetInst Marker identifying the event target.
     * @param {object} nativeEvent Native browser event.
     * @param {DOMEventTarget} nativeEventTarget Target node.
     */


    function SyntheticEvent(dispatchConfig, targetInst, nativeEvent, nativeEventTarget) {
      {
        // these have a getter/setter for warnings
        delete this.nativeEvent;
        delete this.preventDefault;
        delete this.stopPropagation;
        delete this.isDefaultPrevented;
        delete this.isPropagationStopped;
      }
      this.dispatchConfig = dispatchConfig;
      this._targetInst = targetInst;
      this.nativeEvent = nativeEvent;
      var Interface = this.constructor.Interface;

      for (var propName in Interface) {
        if (!Interface.hasOwnProperty(propName)) {
          continue;
        }

        {
          delete this[propName]; // this has a getter/setter for warnings
        }
        var normalize = Interface[propName];

        if (normalize) {
          this[propName] = normalize(nativeEvent);
        } else {
          if (propName === 'target') {
            this.target = nativeEventTarget;
          } else {
            this[propName] = nativeEvent[propName];
          }
        }
      }

      var defaultPrevented = nativeEvent.defaultPrevented != null ? nativeEvent.defaultPrevented : nativeEvent.returnValue === false;

      if (defaultPrevented) {
        this.isDefaultPrevented = functionThatReturnsTrue;
      } else {
        this.isDefaultPrevented = functionThatReturnsFalse;
      }

      this.isPropagationStopped = functionThatReturnsFalse;
      return this;
    }

    _assign(SyntheticEvent.prototype, {
      preventDefault: function () {
        this.defaultPrevented = true;
        var event = this.nativeEvent;

        if (!event) {
          return;
        }

        if (event.preventDefault) {
          event.preventDefault();
        } else if (typeof event.returnValue !== 'unknown') {
          event.returnValue = false;
        }

        this.isDefaultPrevented = functionThatReturnsTrue;
      },
      stopPropagation: function () {
        var event = this.nativeEvent;

        if (!event) {
          return;
        }

        if (event.stopPropagation) {
          event.stopPropagation();
        } else if (typeof event.cancelBubble !== 'unknown') {
          // The ChangeEventPlugin registers a "propertychange" event for
          // IE. This event does not support bubbling or cancelling, and
          // any references to cancelBubble throw "Member not found".  A
          // typeof check of "unknown" circumvents this issue (and is also
          // IE specific).
          event.cancelBubble = true;
        }

        this.isPropagationStopped = functionThatReturnsTrue;
      },

      /**
       * We release all dispatched `SyntheticEvent`s after each event loop, adding
       * them back into the pool. This allows a way to hold onto a reference that
       * won't be added back into the pool.
       */
      persist: function () {
        this.isPersistent = functionThatReturnsTrue;
      },

      /**
       * Checks if this event should be released back into the pool.
       *
       * @return {boolean} True if this should not be released, false otherwise.
       */
      isPersistent: functionThatReturnsFalse,

      /**
       * `PooledClass` looks for `destructor` on each instance it releases.
       */
      destructor: function () {
        var Interface = this.constructor.Interface;

        for (var propName in Interface) {
          {
            Object.defineProperty(this, propName, getPooledWarningPropertyDefinition(propName, Interface[propName]));
          }
        }

        this.dispatchConfig = null;
        this._targetInst = null;
        this.nativeEvent = null;
        this.isDefaultPrevented = functionThatReturnsFalse;
        this.isPropagationStopped = functionThatReturnsFalse;
        this._dispatchListeners = null;
        this._dispatchInstances = null;
        {
          Object.defineProperty(this, 'nativeEvent', getPooledWarningPropertyDefinition('nativeEvent', null));
          Object.defineProperty(this, 'isDefaultPrevented', getPooledWarningPropertyDefinition('isDefaultPrevented', functionThatReturnsFalse));
          Object.defineProperty(this, 'isPropagationStopped', getPooledWarningPropertyDefinition('isPropagationStopped', functionThatReturnsFalse));
          Object.defineProperty(this, 'preventDefault', getPooledWarningPropertyDefinition('preventDefault', function () {}));
          Object.defineProperty(this, 'stopPropagation', getPooledWarningPropertyDefinition('stopPropagation', function () {}));
        }
      }
    });

    SyntheticEvent.Interface = EventInterface;
    /**
     * Helper to reduce boilerplate when creating subclasses.
     */

    SyntheticEvent.extend = function (Interface) {
      var Super = this;

      var E = function () {};

      E.prototype = Super.prototype;
      var prototype = new E();

      function Class() {
        return Super.apply(this, arguments);
      }

      _assign(prototype, Class.prototype);

      Class.prototype = prototype;
      Class.prototype.constructor = Class;
      Class.Interface = _assign({}, Super.Interface, Interface);
      Class.extend = Super.extend;
      addEventPoolingTo(Class);
      return Class;
    };

    addEventPoolingTo(SyntheticEvent);
    /**
     * Helper to nullify syntheticEvent instance properties when destructing
     *
     * @param {String} propName
     * @param {?object} getVal
     * @return {object} defineProperty object
     */

    function getPooledWarningPropertyDefinition(propName, getVal) {
      var isFunction = typeof getVal === 'function';
      return {
        configurable: true,
        set: set,
        get: get
      };

      function set(val) {
        var action = isFunction ? 'setting the method' : 'setting the property';
        warn(action, 'This is effectively a no-op');
        return val;
      }

      function get() {
        var action = isFunction ? 'accessing the method' : 'accessing the property';
        var result = isFunction ? 'This is a no-op function' : 'This is set to null';
        warn(action, result);
        return getVal;
      }

      function warn(action, result) {
        var warningCondition = false;
        !warningCondition ? warningWithoutStack$1(false, "This synthetic event is reused for performance reasons. If you're seeing this, " + "you're %s `%s` on a released/nullified synthetic event. %s. " + 'If you must keep the original synthetic event around, use event.persist(). ' + 'See https://fb.me/react-event-pooling for more information.', action, propName, result) : void 0;
      }
    }

    function getPooledEvent(dispatchConfig, targetInst, nativeEvent, nativeInst) {
      var EventConstructor = this;

      if (EventConstructor.eventPool.length) {
        var instance = EventConstructor.eventPool.pop();
        EventConstructor.call(instance, dispatchConfig, targetInst, nativeEvent, nativeInst);
        return instance;
      }

      return new EventConstructor(dispatchConfig, targetInst, nativeEvent, nativeInst);
    }

    function releasePooledEvent(event) {
      var EventConstructor = this;

      if (!(event instanceof EventConstructor)) {
        {
          throw Error("Trying to release an event instance into a pool of a different type.");
        }
      }

      event.destructor();

      if (EventConstructor.eventPool.length < EVENT_POOL_SIZE) {
        EventConstructor.eventPool.push(event);
      }
    }

    function addEventPoolingTo(EventConstructor) {
      EventConstructor.eventPool = [];
      EventConstructor.getPooled = getPooledEvent;
      EventConstructor.release = releasePooledEvent;
    }
    /**
     * @interface Event
     * @see http://www.w3.org/TR/css3-animations/#AnimationEvent-interface
     * @see https://developer.mozilla.org/en-US/docs/Web/API/AnimationEvent
     */


    var SyntheticAnimationEvent = SyntheticEvent.extend({
      animationName: null,
      elapsedTime: null,
      pseudoElement: null
    });
    /**
     * @interface Event
     * @see http://www.w3.org/TR/clipboard-apis/
     */

    var SyntheticClipboardEvent = SyntheticEvent.extend({
      clipboardData: function (event) {
        return 'clipboardData' in event ? event.clipboardData : window.clipboardData;
      }
    });
    var SyntheticUIEvent = SyntheticEvent.extend({
      view: null,
      detail: null
    });
    /**
     * @interface FocusEvent
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */

    var SyntheticFocusEvent = SyntheticUIEvent.extend({
      relatedTarget: null
    });
    /**
     * `charCode` represents the actual "character code" and is safe to use with
     * `String.fromCharCode`. As such, only keys that correspond to printable
     * characters produce a valid `charCode`, the only exception to this is Enter.
     * The Tab-key is considered non-printable and does not have a `charCode`,
     * presumably because it does not produce a tab-character in browsers.
     *
     * @param {object} nativeEvent Native browser event.
     * @return {number} Normalized `charCode` property.
     */

    function getEventCharCode(nativeEvent) {
      var charCode;
      var keyCode = nativeEvent.keyCode;

      if ('charCode' in nativeEvent) {
        charCode = nativeEvent.charCode; // FF does not set `charCode` for the Enter-key, check against `keyCode`.

        if (charCode === 0 && keyCode === 13) {
          charCode = 13;
        }
      } else {
        // IE8 does not implement `charCode`, but `keyCode` has the correct value.
        charCode = keyCode;
      } // IE and Edge (on Windows) and Chrome / Safari (on Windows and Linux)
      // report Enter as charCode 10 when ctrl is pressed.


      if (charCode === 10) {
        charCode = 13;
      } // Some non-printable keys are reported in `charCode`/`keyCode`, discard them.
      // Must not discard the (non-)printable Enter-key.


      if (charCode >= 32 || charCode === 13) {
        return charCode;
      }

      return 0;
    }
    /**
     * Normalization of deprecated HTML5 `key` values
     * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names
     */


    var normalizeKey = {
      Esc: 'Escape',
      Spacebar: ' ',
      Left: 'ArrowLeft',
      Up: 'ArrowUp',
      Right: 'ArrowRight',
      Down: 'ArrowDown',
      Del: 'Delete',
      Win: 'OS',
      Menu: 'ContextMenu',
      Apps: 'ContextMenu',
      Scroll: 'ScrollLock',
      MozPrintableKey: 'Unidentified'
    };
    /**
     * Translation from legacy `keyCode` to HTML5 `key`
     * Only special keys supported, all others depend on keyboard layout or browser
     * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names
     */

    var translateToKey = {
      '8': 'Backspace',
      '9': 'Tab',
      '12': 'Clear',
      '13': 'Enter',
      '16': 'Shift',
      '17': 'Control',
      '18': 'Alt',
      '19': 'Pause',
      '20': 'CapsLock',
      '27': 'Escape',
      '32': ' ',
      '33': 'PageUp',
      '34': 'PageDown',
      '35': 'End',
      '36': 'Home',
      '37': 'ArrowLeft',
      '38': 'ArrowUp',
      '39': 'ArrowRight',
      '40': 'ArrowDown',
      '45': 'Insert',
      '46': 'Delete',
      '112': 'F1',
      '113': 'F2',
      '114': 'F3',
      '115': 'F4',
      '116': 'F5',
      '117': 'F6',
      '118': 'F7',
      '119': 'F8',
      '120': 'F9',
      '121': 'F10',
      '122': 'F11',
      '123': 'F12',
      '144': 'NumLock',
      '145': 'ScrollLock',
      '224': 'Meta'
    };
    /**
     * @param {object} nativeEvent Native browser event.
     * @return {string} Normalized `key` property.
     */

    function getEventKey(nativeEvent) {
      if (nativeEvent.key) {
        // Normalize inconsistent values reported by browsers due to
        // implementations of a working draft specification.
        // FireFox implements `key` but returns `MozPrintableKey` for all
        // printable characters (normalized to `Unidentified`), ignore it.
        var key = normalizeKey[nativeEvent.key] || nativeEvent.key;

        if (key !== 'Unidentified') {
          return key;
        }
      } // Browser does not implement `key`, polyfill as much of it as we can.


      if (nativeEvent.type === 'keypress') {
        var charCode = getEventCharCode(nativeEvent); // The enter-key is technically both printable and non-printable and can
        // thus be captured by `keypress`, no other non-printable key should.

        return charCode === 13 ? 'Enter' : String.fromCharCode(charCode);
      }

      if (nativeEvent.type === 'keydown' || nativeEvent.type === 'keyup') {
        // While user keyboard layout determines the actual meaning of each
        // `keyCode` value, almost all function keys have a universal value.
        return translateToKey[nativeEvent.keyCode] || 'Unidentified';
      }

      return '';
    }
    /**
     * Translation from modifier key to the associated property in the event.
     * @see http://www.w3.org/TR/DOM-Level-3-Events/#keys-Modifiers
     */


    var modifierKeyToProp = {
      Alt: 'altKey',
      Control: 'ctrlKey',
      Meta: 'metaKey',
      Shift: 'shiftKey'
    }; // Older browsers (Safari <= 10, iOS Safari <= 10.2) do not support
    // getModifierState. If getModifierState is not supported, we map it to a set of
    // modifier keys exposed by the event. In this case, Lock-keys are not supported.

    function modifierStateGetter(keyArg) {
      var syntheticEvent = this;
      var nativeEvent = syntheticEvent.nativeEvent;

      if (nativeEvent.getModifierState) {
        return nativeEvent.getModifierState(keyArg);
      }

      var keyProp = modifierKeyToProp[keyArg];
      return keyProp ? !!nativeEvent[keyProp] : false;
    }

    function getEventModifierState(nativeEvent) {
      return modifierStateGetter;
    }
    /**
     * @interface KeyboardEvent
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */


    var SyntheticKeyboardEvent = SyntheticUIEvent.extend({
      key: getEventKey,
      location: null,
      ctrlKey: null,
      shiftKey: null,
      altKey: null,
      metaKey: null,
      repeat: null,
      locale: null,
      getModifierState: getEventModifierState,
      // Legacy Interface
      charCode: function (event) {
        // `charCode` is the result of a KeyPress event and represents the value of
        // the actual printable character.
        // KeyPress is deprecated, but its replacement is not yet final and not
        // implemented in any major browser. Only KeyPress has charCode.
        if (event.type === 'keypress') {
          return getEventCharCode(event);
        }

        return 0;
      },
      keyCode: function (event) {
        // `keyCode` is the result of a KeyDown/Up event and represents the value of
        // physical keyboard key.
        // The actual meaning of the value depends on the users' keyboard layout
        // which cannot be detected. Assuming that it is a US keyboard layout
        // provides a surprisingly accurate mapping for US and European users.
        // Due to this, it is left to the user to implement at this time.
        if (event.type === 'keydown' || event.type === 'keyup') {
          return event.keyCode;
        }

        return 0;
      },
      which: function (event) {
        // `which` is an alias for either `keyCode` or `charCode` depending on the
        // type of the event.
        if (event.type === 'keypress') {
          return getEventCharCode(event);
        }

        if (event.type === 'keydown' || event.type === 'keyup') {
          return event.keyCode;
        }

        return 0;
      }
    });
    var previousScreenX = 0;
    var previousScreenY = 0; // Use flags to signal movementX/Y has already been set

    var isMovementXSet = false;
    var isMovementYSet = false;
    /**
     * @interface MouseEvent
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */

    var SyntheticMouseEvent = SyntheticUIEvent.extend({
      screenX: null,
      screenY: null,
      clientX: null,
      clientY: null,
      pageX: null,
      pageY: null,
      ctrlKey: null,
      shiftKey: null,
      altKey: null,
      metaKey: null,
      getModifierState: getEventModifierState,
      button: null,
      buttons: null,
      relatedTarget: function (event) {
        return event.relatedTarget || (event.fromElement === event.srcElement ? event.toElement : event.fromElement);
      },
      movementX: function (event) {
        if ('movementX' in event) {
          return event.movementX;
        }

        var screenX = previousScreenX;
        previousScreenX = event.screenX;

        if (!isMovementXSet) {
          isMovementXSet = true;
          return 0;
        }

        return event.type === 'mousemove' ? event.screenX - screenX : 0;
      },
      movementY: function (event) {
        if ('movementY' in event) {
          return event.movementY;
        }

        var screenY = previousScreenY;
        previousScreenY = event.screenY;

        if (!isMovementYSet) {
          isMovementYSet = true;
          return 0;
        }

        return event.type === 'mousemove' ? event.screenY - screenY : 0;
      }
    });
    /**
     * @interface PointerEvent
     * @see http://www.w3.org/TR/pointerevents/
     */

    var SyntheticPointerEvent = SyntheticMouseEvent.extend({
      pointerId: null,
      width: null,
      height: null,
      pressure: null,
      tangentialPressure: null,
      tiltX: null,
      tiltY: null,
      twist: null,
      pointerType: null,
      isPrimary: null
    });
    /**
     * @interface DragEvent
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */

    var SyntheticDragEvent = SyntheticMouseEvent.extend({
      dataTransfer: null
    });
    /**
     * @interface TouchEvent
     * @see http://www.w3.org/TR/touch-events/
     */

    var SyntheticTouchEvent = SyntheticUIEvent.extend({
      touches: null,
      targetTouches: null,
      changedTouches: null,
      altKey: null,
      metaKey: null,
      ctrlKey: null,
      shiftKey: null,
      getModifierState: getEventModifierState
    });
    /**
     * @interface Event
     * @see http://www.w3.org/TR/2009/WD-css3-transitions-20090320/#transition-events-
     * @see https://developer.mozilla.org/en-US/docs/Web/API/TransitionEvent
     */

    var SyntheticTransitionEvent = SyntheticEvent.extend({
      propertyName: null,
      elapsedTime: null,
      pseudoElement: null
    });
    /**
     * @interface WheelEvent
     * @see http://www.w3.org/TR/DOM-Level-3-Events/
     */

    var SyntheticWheelEvent = SyntheticMouseEvent.extend({
      deltaX: function (event) {
        return 'deltaX' in event ? event.deltaX : // Fallback to `wheelDeltaX` for Webkit and normalize (right is positive).
        'wheelDeltaX' in event ? -event.wheelDeltaX : 0;
      },
      deltaY: function (event) {
        return 'deltaY' in event ? event.deltaY : // Fallback to `wheelDeltaY` for Webkit and normalize (down is positive).
        'wheelDeltaY' in event ? -event.wheelDeltaY : // Fallback to `wheelDelta` for IE<9 and normalize (down is positive).
        'wheelDelta' in event ? -event.wheelDelta : 0;
      },
      deltaZ: null,
      // Browsers without "deltaMode" is reporting in raw wheel delta where one
      // notch on the scroll is always +/- 120, roughly equivalent to pixels.
      // A good approximation of DOM_DELTA_LINE (1) is 5% of viewport size or
      // ~40 pixels, for DOM_DELTA_SCREEN (2) it is 87.5% of viewport size.
      deltaMode: null
    });
    /**
     * Turns
     * ['abort', ...]
     * into
     * eventTypes = {
     *   'abort': {
     *     phasedRegistrationNames: {
     *       bubbled: 'onAbort',
     *       captured: 'onAbortCapture',
     *     },
     *     dependencies: [TOP_ABORT],
     *   },
     *   ...
     * };
     * topLevelEventsToDispatchConfig = new Map([
     *   [TOP_ABORT, { sameConfig }],
     * ]);
     */

    var eventTuples = [// Discrete events
    [TOP_BLUR, 'blur', DiscreteEvent], [TOP_CANCEL, 'cancel', DiscreteEvent], [TOP_CLICK, 'click', DiscreteEvent], [TOP_CLOSE, 'close', DiscreteEvent], [TOP_CONTEXT_MENU, 'contextMenu', DiscreteEvent], [TOP_COPY, 'copy', DiscreteEvent], [TOP_CUT, 'cut', DiscreteEvent], [TOP_AUX_CLICK, 'auxClick', DiscreteEvent], [TOP_DOUBLE_CLICK, 'doubleClick', DiscreteEvent], [TOP_DRAG_END, 'dragEnd', DiscreteEvent], [TOP_DRAG_START, 'dragStart', DiscreteEvent], [TOP_DROP, 'drop', DiscreteEvent], [TOP_FOCUS, 'focus', DiscreteEvent], [TOP_INPUT, 'input', DiscreteEvent], [TOP_INVALID, 'invalid', DiscreteEvent], [TOP_KEY_DOWN, 'keyDown', DiscreteEvent], [TOP_KEY_PRESS, 'keyPress', DiscreteEvent], [TOP_KEY_UP, 'keyUp', DiscreteEvent], [TOP_MOUSE_DOWN, 'mouseDown', DiscreteEvent], [TOP_MOUSE_UP, 'mouseUp', DiscreteEvent], [TOP_PASTE, 'paste', DiscreteEvent], [TOP_PAUSE, 'pause', DiscreteEvent], [TOP_PLAY, 'play', DiscreteEvent], [TOP_POINTER_CANCEL, 'pointerCancel', DiscreteEvent], [TOP_POINTER_DOWN, 'pointerDown', DiscreteEvent], [TOP_POINTER_UP, 'pointerUp', DiscreteEvent], [TOP_RATE_CHANGE, 'rateChange', DiscreteEvent], [TOP_RESET, 'reset', DiscreteEvent], [TOP_SEEKED, 'seeked', DiscreteEvent], [TOP_SUBMIT, 'submit', DiscreteEvent], [TOP_TOUCH_CANCEL, 'touchCancel', DiscreteEvent], [TOP_TOUCH_END, 'touchEnd', DiscreteEvent], [TOP_TOUCH_START, 'touchStart', DiscreteEvent], [TOP_VOLUME_CHANGE, 'volumeChange', DiscreteEvent], // User-blocking events
    [TOP_DRAG, 'drag', UserBlockingEvent], [TOP_DRAG_ENTER, 'dragEnter', UserBlockingEvent], [TOP_DRAG_EXIT, 'dragExit', UserBlockingEvent], [TOP_DRAG_LEAVE, 'dragLeave', UserBlockingEvent], [TOP_DRAG_OVER, 'dragOver', UserBlockingEvent], [TOP_MOUSE_MOVE, 'mouseMove', UserBlockingEvent], [TOP_MOUSE_OUT, 'mouseOut', UserBlockingEvent], [TOP_MOUSE_OVER, 'mouseOver', UserBlockingEvent], [TOP_POINTER_MOVE, 'pointerMove', UserBlockingEvent], [TOP_POINTER_OUT, 'pointerOut', UserBlockingEvent], [TOP_POINTER_OVER, 'pointerOver', UserBlockingEvent], [TOP_SCROLL, 'scroll', UserBlockingEvent], [TOP_TOGGLE, 'toggle', UserBlockingEvent], [TOP_TOUCH_MOVE, 'touchMove', UserBlockingEvent], [TOP_WHEEL, 'wheel', UserBlockingEvent], // Continuous events
    [TOP_ABORT, 'abort', ContinuousEvent], [TOP_ANIMATION_END, 'animationEnd', ContinuousEvent], [TOP_ANIMATION_ITERATION, 'animationIteration', ContinuousEvent], [TOP_ANIMATION_START, 'animationStart', ContinuousEvent], [TOP_CAN_PLAY, 'canPlay', ContinuousEvent], [TOP_CAN_PLAY_THROUGH, 'canPlayThrough', ContinuousEvent], [TOP_DURATION_CHANGE, 'durationChange', ContinuousEvent], [TOP_EMPTIED, 'emptied', ContinuousEvent], [TOP_ENCRYPTED, 'encrypted', ContinuousEvent], [TOP_ENDED, 'ended', ContinuousEvent], [TOP_ERROR, 'error', ContinuousEvent], [TOP_GOT_POINTER_CAPTURE, 'gotPointerCapture', ContinuousEvent], [TOP_LOAD, 'load', ContinuousEvent], [TOP_LOADED_DATA, 'loadedData', ContinuousEvent], [TOP_LOADED_METADATA, 'loadedMetadata', ContinuousEvent], [TOP_LOAD_START, 'loadStart', ContinuousEvent], [TOP_LOST_POINTER_CAPTURE, 'lostPointerCapture', ContinuousEvent], [TOP_PLAYING, 'playing', ContinuousEvent], [TOP_PROGRESS, 'progress', ContinuousEvent], [TOP_SEEKING, 'seeking', ContinuousEvent], [TOP_STALLED, 'stalled', ContinuousEvent], [TOP_SUSPEND, 'suspend', ContinuousEvent], [TOP_TIME_UPDATE, 'timeUpdate', ContinuousEvent], [TOP_TRANSITION_END, 'transitionEnd', ContinuousEvent], [TOP_WAITING, 'waiting', ContinuousEvent]];
    var eventTypes = {};
    var topLevelEventsToDispatchConfig = {};

    for (var i = 0; i < eventTuples.length; i++) {
      var eventTuple = eventTuples[i];
      var topEvent = eventTuple[0];
      var event = eventTuple[1];
      var eventPriority = eventTuple[2];
      var capitalizedEvent = event[0].toUpperCase() + event.slice(1);
      var onEvent = 'on' + capitalizedEvent;
      var config = {
        phasedRegistrationNames: {
          bubbled: onEvent,
          captured: onEvent + 'Capture'
        },
        dependencies: [topEvent],
        eventPriority: eventPriority
      };
      eventTypes[event] = config;
      topLevelEventsToDispatchConfig[topEvent] = config;
    } // Only used in DEV for exhaustiveness validation.


    var knownHTMLTopLevelTypes = [TOP_ABORT, TOP_CANCEL, TOP_CAN_PLAY, TOP_CAN_PLAY_THROUGH, TOP_CLOSE, TOP_DURATION_CHANGE, TOP_EMPTIED, TOP_ENCRYPTED, TOP_ENDED, TOP_ERROR, TOP_INPUT, TOP_INVALID, TOP_LOAD, TOP_LOADED_DATA, TOP_LOADED_METADATA, TOP_LOAD_START, TOP_PAUSE, TOP_PLAY, TOP_PLAYING, TOP_PROGRESS, TOP_RATE_CHANGE, TOP_RESET, TOP_SEEKED, TOP_SEEKING, TOP_STALLED, TOP_SUBMIT, TOP_SUSPEND, TOP_TIME_UPDATE, TOP_TOGGLE, TOP_VOLUME_CHANGE, TOP_WAITING];
    var SimpleEventPlugin = {
      eventTypes: eventTypes,
      getEventPriority: function (topLevelType) {
        var config = topLevelEventsToDispatchConfig[topLevelType];
        return config !== undefined ? config.eventPriority : ContinuousEvent;
      },
      extractEvents: function (topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
        var dispatchConfig = topLevelEventsToDispatchConfig[topLevelType];

        if (!dispatchConfig) {
          return null;
        }

        var EventConstructor;

        switch (topLevelType) {
          case TOP_KEY_PRESS:
            // Firefox creates a keypress event for function keys too. This removes
            // the unwanted keypress events. Enter is however both printable and
            // non-printable. One would expect Tab to be as well (but it isn't).
            if (getEventCharCode(nativeEvent) === 0) {
              return null;
            }

          /* falls through */

          case TOP_KEY_DOWN:
          case TOP_KEY_UP:
            EventConstructor = SyntheticKeyboardEvent;
            break;

          case TOP_BLUR:
          case TOP_FOCUS:
            EventConstructor = SyntheticFocusEvent;
            break;

          case TOP_CLICK:
            // Firefox creates a click event on right mouse clicks. This removes the
            // unwanted click events.
            if (nativeEvent.button === 2) {
              return null;
            }

          /* falls through */

          case TOP_AUX_CLICK:
          case TOP_DOUBLE_CLICK:
          case TOP_MOUSE_DOWN:
          case TOP_MOUSE_MOVE:
          case TOP_MOUSE_UP: // TODO: Disabled elements should not respond to mouse events

          /* falls through */

          case TOP_MOUSE_OUT:
          case TOP_MOUSE_OVER:
          case TOP_CONTEXT_MENU:
            EventConstructor = SyntheticMouseEvent;
            break;

          case TOP_DRAG:
          case TOP_DRAG_END:
          case TOP_DRAG_ENTER:
          case TOP_DRAG_EXIT:
          case TOP_DRAG_LEAVE:
          case TOP_DRAG_OVER:
          case TOP_DRAG_START:
          case TOP_DROP:
            EventConstructor = SyntheticDragEvent;
            break;

          case TOP_TOUCH_CANCEL:
          case TOP_TOUCH_END:
          case TOP_TOUCH_MOVE:
          case TOP_TOUCH_START:
            EventConstructor = SyntheticTouchEvent;
            break;

          case TOP_ANIMATION_END:
          case TOP_ANIMATION_ITERATION:
          case TOP_ANIMATION_START:
            EventConstructor = SyntheticAnimationEvent;
            break;

          case TOP_TRANSITION_END:
            EventConstructor = SyntheticTransitionEvent;
            break;

          case TOP_SCROLL:
            EventConstructor = SyntheticUIEvent;
            break;

          case TOP_WHEEL:
            EventConstructor = SyntheticWheelEvent;
            break;

          case TOP_COPY:
          case TOP_CUT:
          case TOP_PASTE:
            EventConstructor = SyntheticClipboardEvent;
            break;

          case TOP_GOT_POINTER_CAPTURE:
          case TOP_LOST_POINTER_CAPTURE:
          case TOP_POINTER_CANCEL:
          case TOP_POINTER_DOWN:
          case TOP_POINTER_MOVE:
          case TOP_POINTER_OUT:
          case TOP_POINTER_OVER:
          case TOP_POINTER_UP:
            EventConstructor = SyntheticPointerEvent;
            break;

          default:
            {
              if (knownHTMLTopLevelTypes.indexOf(topLevelType) === -1) {
                warningWithoutStack$1(false, 'SimpleEventPlugin: Unhandled event type, `%s`. This warning ' + 'is likely caused by a bug in React. Please file an issue.', topLevelType);
              }
            } // HTML Events
            // @see http://www.w3.org/TR/html5/index.html#events-0

            EventConstructor = SyntheticEvent;
            break;
        }

        var event = EventConstructor.getPooled(dispatchConfig, targetInst, nativeEvent, nativeEventTarget);
        accumulateTwoPhaseDispatches(event);
        return event;
      }
    };
    var passiveBrowserEventsSupported = false; // Check if browser support events with passive listeners
    // https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Safely_detecting_option_support

    if (enableFlareAPI && canUseDOM) {
      try {
        var options = {}; // $FlowFixMe: Ignore Flow complaining about needing a value

        Object.defineProperty(options, 'passive', {
          get: function () {
            passiveBrowserEventsSupported = true;
          }
        });
        window.addEventListener('test', options, options);
        window.removeEventListener('test', options, options);
      } catch (e) {
        passiveBrowserEventsSupported = false;
      }
    } // Intentionally not named imports because Rollup would use dynamic dispatch for
    // CommonJS interop named imports.


    var UserBlockingPriority$1 = Scheduler.unstable_UserBlockingPriority;
    var runWithPriority$1 = Scheduler.unstable_runWithPriority;
    var getEventPriority = SimpleEventPlugin.getEventPriority;
    var CALLBACK_BOOKKEEPING_POOL_SIZE = 10;
    var callbackBookkeepingPool = [];
    /**
     * Find the deepest React component completely containing the root of the
     * passed-in instance (for use when entire React trees are nested within each
     * other). If React trees are not nested, returns null.
     */

    function findRootContainerNode(inst) {
      if (inst.tag === HostRoot) {
        return inst.stateNode.containerInfo;
      } // TODO: It may be a good idea to cache this to prevent unnecessary DOM
      // traversal, but caching is difficult to do correctly without using a
      // mutation observer to listen for all DOM changes.


      while (inst.return) {
        inst = inst.return;
      }

      if (inst.tag !== HostRoot) {
        // This can happen if we're in a detached tree.
        return null;
      }

      return inst.stateNode.containerInfo;
    } // Used to store ancestor hierarchy in top level callback


    function getTopLevelCallbackBookKeeping(topLevelType, nativeEvent, targetInst, eventSystemFlags) {
      if (callbackBookkeepingPool.length) {
        var instance = callbackBookkeepingPool.pop();
        instance.topLevelType = topLevelType;
        instance.eventSystemFlags = eventSystemFlags;
        instance.nativeEvent = nativeEvent;
        instance.targetInst = targetInst;
        return instance;
      }

      return {
        topLevelType: topLevelType,
        eventSystemFlags: eventSystemFlags,
        nativeEvent: nativeEvent,
        targetInst: targetInst,
        ancestors: []
      };
    }

    function releaseTopLevelCallbackBookKeeping(instance) {
      instance.topLevelType = null;
      instance.nativeEvent = null;
      instance.targetInst = null;
      instance.ancestors.length = 0;

      if (callbackBookkeepingPool.length < CALLBACK_BOOKKEEPING_POOL_SIZE) {
        callbackBookkeepingPool.push(instance);
      }
    }

    function handleTopLevel(bookKeeping) {
      var targetInst = bookKeeping.targetInst; // Loop through the hierarchy, in case there's any nested components.
      // It's important that we build the array of ancestors before calling any
      // event handlers, because event handlers can modify the DOM, leading to
      // inconsistencies with ReactMount's node cache. See #1105.

      var ancestor = targetInst;

      do {
        if (!ancestor) {
          var ancestors = bookKeeping.ancestors;
          ancestors.push(ancestor);
          break;
        }

        var root = findRootContainerNode(ancestor);

        if (!root) {
          break;
        }

        var tag = ancestor.tag;

        if (tag === HostComponent || tag === HostText) {
          bookKeeping.ancestors.push(ancestor);
        }

        ancestor = getClosestInstanceFromNode(root);
      } while (ancestor);

      for (var i = 0; i < bookKeeping.ancestors.length; i++) {
        targetInst = bookKeeping.ancestors[i];
        var eventTarget = getEventTarget(bookKeeping.nativeEvent);
        var topLevelType = bookKeeping.topLevelType;
        var nativeEvent = bookKeeping.nativeEvent;
        runExtractedPluginEventsInBatch(topLevelType, targetInst, nativeEvent, eventTarget, bookKeeping.eventSystemFlags);
      }
    } // TODO: can we stop exporting these?


    var _enabled = true;

    function setEnabled(enabled) {
      _enabled = !!enabled;
    }

    function isEnabled() {
      return _enabled;
    }

    function trapBubbledEvent(topLevelType, element) {
      trapEventForPluginEventSystem(element, topLevelType, false);
    }

    function trapCapturedEvent(topLevelType, element) {
      trapEventForPluginEventSystem(element, topLevelType, true);
    }

    function trapEventForResponderEventSystem(element, topLevelType, passive) {
      if (enableFlareAPI) {
        var rawEventName = getRawEventName(topLevelType);
        var eventFlags = RESPONDER_EVENT_SYSTEM; // If passive option is not supported, then the event will be
        // active and not passive, but we flag it as using not being
        // supported too. This way the responder event plugins know,
        // and can provide polyfills if needed.

        if (passive) {
          if (passiveBrowserEventsSupported) {
            eventFlags |= IS_PASSIVE;
          } else {
            eventFlags |= IS_ACTIVE;
            eventFlags |= PASSIVE_NOT_SUPPORTED;
            passive = false;
          }
        } else {
          eventFlags |= IS_ACTIVE;
        } // Check if interactive and wrap in discreteUpdates


        var listener = dispatchEvent.bind(null, topLevelType, eventFlags);

        if (passiveBrowserEventsSupported) {
          addEventCaptureListenerWithPassiveFlag(element, rawEventName, listener, passive);
        } else {
          addEventCaptureListener(element, rawEventName, listener);
        }
      }
    }

    function trapEventForPluginEventSystem(element, topLevelType, capture) {
      var listener;

      switch (getEventPriority(topLevelType)) {
        case DiscreteEvent:
          listener = dispatchDiscreteEvent.bind(null, topLevelType, PLUGIN_EVENT_SYSTEM);
          break;

        case UserBlockingEvent:
          listener = dispatchUserBlockingUpdate.bind(null, topLevelType, PLUGIN_EVENT_SYSTEM);
          break;

        case ContinuousEvent:
        default:
          listener = dispatchEvent.bind(null, topLevelType, PLUGIN_EVENT_SYSTEM);
          break;
      }

      var rawEventName = getRawEventName(topLevelType);

      if (capture) {
        addEventCaptureListener(element, rawEventName, listener);
      } else {
        addEventBubbleListener(element, rawEventName, listener);
      }
    }

    function dispatchDiscreteEvent(topLevelType, eventSystemFlags, nativeEvent) {
      flushDiscreteUpdatesIfNeeded(nativeEvent.timeStamp);
      discreteUpdates(dispatchEvent, topLevelType, eventSystemFlags, nativeEvent);
    }

    function dispatchUserBlockingUpdate(topLevelType, eventSystemFlags, nativeEvent) {
      runWithPriority$1(UserBlockingPriority$1, dispatchEvent.bind(null, topLevelType, eventSystemFlags, nativeEvent));
    }

    function dispatchEventForPluginEventSystem(topLevelType, eventSystemFlags, nativeEvent, targetInst) {
      var bookKeeping = getTopLevelCallbackBookKeeping(topLevelType, nativeEvent, targetInst, eventSystemFlags);

      try {
        // Event queue being processed in the same cycle allows
        // `preventDefault`.
        batchedEventUpdates(handleTopLevel, bookKeeping);
      } finally {
        releaseTopLevelCallbackBookKeeping(bookKeeping);
      }
    }

    function dispatchEvent(topLevelType, eventSystemFlags, nativeEvent) {
      if (!_enabled) {
        return;
      }

      if (hasQueuedDiscreteEvents() && isReplayableDiscreteEvent(topLevelType)) {
        // If we already have a queue of discrete events, and this is another discrete
        // event, then we can't dispatch it regardless of its target, since they
        // need to dispatch in order.
        queueDiscreteEvent(null, // Flags that we're not actually blocked on anything as far as we know.
        topLevelType, eventSystemFlags, nativeEvent);
        return;
      }

      var blockedOn = attemptToDispatchEvent(topLevelType, eventSystemFlags, nativeEvent);

      if (blockedOn === null) {
        // We successfully dispatched this event.
        clearIfContinuousEvent(topLevelType, nativeEvent);
        return;
      }

      if (isReplayableDiscreteEvent(topLevelType)) {
        // This this to be replayed later once the target is available.
        queueDiscreteEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent);
        return;
      }

      if (queueIfContinuousEvent(blockedOn, topLevelType, eventSystemFlags, nativeEvent)) {
        return;
      } // We need to clear only if we didn't queue because
      // queueing is accummulative.


      clearIfContinuousEvent(topLevelType, nativeEvent); // This is not replayable so we'll invoke it but without a target,
      // in case the event system needs to trace it.

      if (enableFlareAPI) {
        if (eventSystemFlags & PLUGIN_EVENT_SYSTEM) {
          dispatchEventForPluginEventSystem(topLevelType, eventSystemFlags, nativeEvent, null);
        }

        if (eventSystemFlags & RESPONDER_EVENT_SYSTEM) {
          // React Flare event system
          dispatchEventForResponderEventSystem(topLevelType, null, nativeEvent, getEventTarget(nativeEvent), eventSystemFlags);
        }
      } else {
        dispatchEventForPluginEventSystem(topLevelType, eventSystemFlags, nativeEvent, null);
      }
    } // Attempt dispatching an event. Returns a SuspenseInstance or Container if it's blocked.


    function attemptToDispatchEvent(topLevelType, eventSystemFlags, nativeEvent) {
      // TODO: Warn if _enabled is false.
      var nativeEventTarget = getEventTarget(nativeEvent);
      var targetInst = getClosestInstanceFromNode(nativeEventTarget);

      if (targetInst !== null) {
        var nearestMounted = getNearestMountedFiber(targetInst);

        if (nearestMounted === null) {
          // This tree has been unmounted already. Dispatch without a target.
          targetInst = null;
        } else {
          var tag = nearestMounted.tag;

          if (tag === SuspenseComponent) {
            var instance = getSuspenseInstanceFromFiber(nearestMounted);

            if (instance !== null) {
              // Queue the event to be replayed later. Abort dispatching since we
              // don't want this event dispatched twice through the event system.
              // TODO: If this is the first discrete event in the queue. Schedule an increased
              // priority for this boundary.
              return instance;
            } // This shouldn't happen, something went wrong but to avoid blocking
            // the whole system, dispatch the event without a target.
            // TODO: Warn.


            targetInst = null;
          } else if (tag === HostRoot) {
            var root = nearestMounted.stateNode;

            if (root.hydrate) {
              // If this happens during a replay something went wrong and it might block
              // the whole system.
              return getContainerFromFiber(nearestMounted);
            }

            targetInst = null;
          } else if (nearestMounted !== targetInst) {
            // If we get an event (ex: img onload) before committing that
            // component's mount, ignore it for now (that is, treat it as if it was an
            // event on a non-React tree). We might also consider queueing events and
            // dispatching them after the mount.
            targetInst = null;
          }
        }
      }

      if (enableFlareAPI) {
        if (eventSystemFlags & PLUGIN_EVENT_SYSTEM) {
          dispatchEventForPluginEventSystem(topLevelType, eventSystemFlags, nativeEvent, targetInst);
        }

        if (eventSystemFlags & RESPONDER_EVENT_SYSTEM) {
          // React Flare event system
          dispatchEventForResponderEventSystem(topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags);
        }
      } else {
        dispatchEventForPluginEventSystem(topLevelType, eventSystemFlags, nativeEvent, targetInst);
      } // We're not blocked on anything.


      return null;
    }
    /**
     * Checks if an event is supported in the current execution environment.
     *
     * NOTE: This will not work correctly for non-generic events such as `change`,
     * `reset`, `load`, `error`, and `select`.
     *
     * Borrows from Modernizr.
     *
     * @param {string} eventNameSuffix Event name, e.g. "click".
     * @return {boolean} True if the event is supported.
     * @internal
     * @license Modernizr 3.0.0pre (Custom Build) | MIT
     */


    function isEventSupported(eventNameSuffix) {
      if (!canUseDOM) {
        return false;
      }

      var eventName = 'on' + eventNameSuffix;
      var isSupported = eventName in document;

      if (!isSupported) {
        var element = document.createElement('div');
        element.setAttribute(eventName, 'return;');
        isSupported = typeof element[eventName] === 'function';
      }

      return isSupported;
    }
    /**
     * Summary of `ReactBrowserEventEmitter` event handling:
     *
     *  - Top-level delegation is used to trap most native browser events. This
     *    may only occur in the main thread and is the responsibility of
     *    ReactDOMEventListener, which is injected and can therefore support
     *    pluggable event sources. This is the only work that occurs in the main
     *    thread.
     *
     *  - We normalize and de-duplicate events to account for browser quirks. This
     *    may be done in the worker thread.
     *
     *  - Forward these native events (with the associated top-level type used to
     *    trap it) to `EventPluginHub`, which in turn will ask plugins if they want
     *    to extract any synthetic events.
     *
     *  - The `EventPluginHub` will then process each event by annotating them with
     *    "dispatches", a sequence of listeners and IDs that care about that event.
     *
     *  - The `EventPluginHub` then dispatches the events.
     *
     * Overview of React and the event system:
     *
     * +------------+    .
     * |    DOM     |    .
     * +------------+    .
     *       |           .
     *       v           .
     * +------------+    .
     * | ReactEvent |    .
     * |  Listener  |    .
     * +------------+    .                         +-----------+
     *       |           .               +--------+|SimpleEvent|
     *       |           .               |         |Plugin     |
     * +-----|------+    .               v         +-----------+
     * |     |      |    .    +--------------+                    +------------+
     * |     +-----------.--->|EventPluginHub|                    |    Event   |
     * |            |    .    |              |     +-----------+  | Propagators|
     * | ReactEvent |    .    |              |     |TapEvent   |  |------------|
     * |  Emitter   |    .    |              |<---+|Plugin     |  |other plugin|
     * |            |    .    |              |     +-----------+  |  utilities |
     * |     +-----------.--->|              |                    +------------+
     * |     |      |    .    +--------------+
     * +-----|------+    .                ^        +-----------+
     *       |           .                |        |Enter/Leave|
     *       +           .                +-------+|Plugin     |
     * +-------------+   .                         +-----------+
     * | application |   .
     * |-------------|   .
     * |             |   .
     * |             |   .
     * +-------------+   .
     *                   .
     *    React Core     .  General Purpose Event Plugin System
     */


    var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;
    var elementListeningSets = new PossiblyWeakMap();

    function getListeningSetForElement(element) {
      var listeningSet = elementListeningSets.get(element);

      if (listeningSet === undefined) {
        listeningSet = new Set();
        elementListeningSets.set(element, listeningSet);
      }

      return listeningSet;
    }
    /**
     * We listen for bubbled touch events on the document object.
     *
     * Firefox v8.01 (and possibly others) exhibited strange behavior when
     * mounting `onmousemove` events at some node that was not the document
     * element. The symptoms were that if your mouse is not moving over something
     * contained within that mount point (for example on the background) the
     * top-level listeners for `onmousemove` won't be called. However, if you
     * register the `mousemove` on the document object, then it will of course
     * catch all `mousemove`s. This along with iOS quirks, justifies restricting
     * top-level listeners to the document object only, at least for these
     * movement types of events and possibly all events.
     *
     * @see http://www.quirksmode.org/blog/archives/2010/09/click_event_del.html
     *
     * Also, `keyup`/`keypress`/`keydown` do not bubble to the window on IE, but
     * they bubble to document.
     *
     * @param {string} registrationName Name of listener (e.g. `onClick`).
     * @param {object} mountAt Container where to mount the listener
     */


    function listenTo(registrationName, mountAt) {
      var listeningSet = getListeningSetForElement(mountAt);
      var dependencies = registrationNameDependencies[registrationName];

      for (var i = 0; i < dependencies.length; i++) {
        var dependency = dependencies[i];
        listenToTopLevel(dependency, mountAt, listeningSet);
      }
    }

    function listenToTopLevel(topLevelType, mountAt, listeningSet) {
      if (!listeningSet.has(topLevelType)) {
        switch (topLevelType) {
          case TOP_SCROLL:
            trapCapturedEvent(TOP_SCROLL, mountAt);
            break;

          case TOP_FOCUS:
          case TOP_BLUR:
            trapCapturedEvent(TOP_FOCUS, mountAt);
            trapCapturedEvent(TOP_BLUR, mountAt); // We set the flag for a single dependency later in this function,
            // but this ensures we mark both as attached rather than just one.

            listeningSet.add(TOP_BLUR);
            listeningSet.add(TOP_FOCUS);
            break;

          case TOP_CANCEL:
          case TOP_CLOSE:
            if (isEventSupported(getRawEventName(topLevelType))) {
              trapCapturedEvent(topLevelType, mountAt);
            }

            break;

          case TOP_INVALID:
          case TOP_SUBMIT:
          case TOP_RESET:
            // We listen to them on the target DOM elements.
            // Some of them bubble so we don't want them to fire twice.
            break;

          default:
            // By default, listen on the top level to all non-media events.
            // Media events don't bubble so adding the listener wouldn't do anything.
            var isMediaEvent = mediaEventTypes.indexOf(topLevelType) !== -1;

            if (!isMediaEvent) {
              trapBubbledEvent(topLevelType, mountAt);
            }

            break;
        }

        listeningSet.add(topLevelType);
      }
    }

    function isListeningToAllDependencies(registrationName, mountAt) {
      var listeningSet = getListeningSetForElement(mountAt);
      var dependencies = registrationNameDependencies[registrationName];

      for (var i = 0; i < dependencies.length; i++) {
        var dependency = dependencies[i];

        if (!listeningSet.has(dependency)) {
          return false;
        }
      }

      return true;
    } // List derived from Gecko source code:
    // https://github.com/mozilla/gecko-dev/blob/4e638efc71/layout/style/test/property_database.js


    var shorthandToLonghand = {
      animation: ['animationDelay', 'animationDirection', 'animationDuration', 'animationFillMode', 'animationIterationCount', 'animationName', 'animationPlayState', 'animationTimingFunction'],
      background: ['backgroundAttachment', 'backgroundClip', 'backgroundColor', 'backgroundImage', 'backgroundOrigin', 'backgroundPositionX', 'backgroundPositionY', 'backgroundRepeat', 'backgroundSize'],
      backgroundPosition: ['backgroundPositionX', 'backgroundPositionY'],
      border: ['borderBottomColor', 'borderBottomStyle', 'borderBottomWidth', 'borderImageOutset', 'borderImageRepeat', 'borderImageSlice', 'borderImageSource', 'borderImageWidth', 'borderLeftColor', 'borderLeftStyle', 'borderLeftWidth', 'borderRightColor', 'borderRightStyle', 'borderRightWidth', 'borderTopColor', 'borderTopStyle', 'borderTopWidth'],
      borderBlockEnd: ['borderBlockEndColor', 'borderBlockEndStyle', 'borderBlockEndWidth'],
      borderBlockStart: ['borderBlockStartColor', 'borderBlockStartStyle', 'borderBlockStartWidth'],
      borderBottom: ['borderBottomColor', 'borderBottomStyle', 'borderBottomWidth'],
      borderColor: ['borderBottomColor', 'borderLeftColor', 'borderRightColor', 'borderTopColor'],
      borderImage: ['borderImageOutset', 'borderImageRepeat', 'borderImageSlice', 'borderImageSource', 'borderImageWidth'],
      borderInlineEnd: ['borderInlineEndColor', 'borderInlineEndStyle', 'borderInlineEndWidth'],
      borderInlineStart: ['borderInlineStartColor', 'borderInlineStartStyle', 'borderInlineStartWidth'],
      borderLeft: ['borderLeftColor', 'borderLeftStyle', 'borderLeftWidth'],
      borderRadius: ['borderBottomLeftRadius', 'borderBottomRightRadius', 'borderTopLeftRadius', 'borderTopRightRadius'],
      borderRight: ['borderRightColor', 'borderRightStyle', 'borderRightWidth'],
      borderStyle: ['borderBottomStyle', 'borderLeftStyle', 'borderRightStyle', 'borderTopStyle'],
      borderTop: ['borderTopColor', 'borderTopStyle', 'borderTopWidth'],
      borderWidth: ['borderBottomWidth', 'borderLeftWidth', 'borderRightWidth', 'borderTopWidth'],
      columnRule: ['columnRuleColor', 'columnRuleStyle', 'columnRuleWidth'],
      columns: ['columnCount', 'columnWidth'],
      flex: ['flexBasis', 'flexGrow', 'flexShrink'],
      flexFlow: ['flexDirection', 'flexWrap'],
      font: ['fontFamily', 'fontFeatureSettings', 'fontKerning', 'fontLanguageOverride', 'fontSize', 'fontSizeAdjust', 'fontStretch', 'fontStyle', 'fontVariant', 'fontVariantAlternates', 'fontVariantCaps', 'fontVariantEastAsian', 'fontVariantLigatures', 'fontVariantNumeric', 'fontVariantPosition', 'fontWeight', 'lineHeight'],
      fontVariant: ['fontVariantAlternates', 'fontVariantCaps', 'fontVariantEastAsian', 'fontVariantLigatures', 'fontVariantNumeric', 'fontVariantPosition'],
      gap: ['columnGap', 'rowGap'],
      grid: ['gridAutoColumns', 'gridAutoFlow', 'gridAutoRows', 'gridTemplateAreas', 'gridTemplateColumns', 'gridTemplateRows'],
      gridArea: ['gridColumnEnd', 'gridColumnStart', 'gridRowEnd', 'gridRowStart'],
      gridColumn: ['gridColumnEnd', 'gridColumnStart'],
      gridColumnGap: ['columnGap'],
      gridGap: ['columnGap', 'rowGap'],
      gridRow: ['gridRowEnd', 'gridRowStart'],
      gridRowGap: ['rowGap'],
      gridTemplate: ['gridTemplateAreas', 'gridTemplateColumns', 'gridTemplateRows'],
      listStyle: ['listStyleImage', 'listStylePosition', 'listStyleType'],
      margin: ['marginBottom', 'marginLeft', 'marginRight', 'marginTop'],
      marker: ['markerEnd', 'markerMid', 'markerStart'],
      mask: ['maskClip', 'maskComposite', 'maskImage', 'maskMode', 'maskOrigin', 'maskPositionX', 'maskPositionY', 'maskRepeat', 'maskSize'],
      maskPosition: ['maskPositionX', 'maskPositionY'],
      outline: ['outlineColor', 'outlineStyle', 'outlineWidth'],
      overflow: ['overflowX', 'overflowY'],
      padding: ['paddingBottom', 'paddingLeft', 'paddingRight', 'paddingTop'],
      placeContent: ['alignContent', 'justifyContent'],
      placeItems: ['alignItems', 'justifyItems'],
      placeSelf: ['alignSelf', 'justifySelf'],
      textDecoration: ['textDecorationColor', 'textDecorationLine', 'textDecorationStyle'],
      textEmphasis: ['textEmphasisColor', 'textEmphasisStyle'],
      transition: ['transitionDelay', 'transitionDuration', 'transitionProperty', 'transitionTimingFunction'],
      wordWrap: ['overflowWrap']
    };
    /**
     * CSS properties which accept numbers but are not in units of "px".
     */

    var isUnitlessNumber = {
      animationIterationCount: true,
      borderImageOutset: true,
      borderImageSlice: true,
      borderImageWidth: true,
      boxFlex: true,
      boxFlexGroup: true,
      boxOrdinalGroup: true,
      columnCount: true,
      columns: true,
      flex: true,
      flexGrow: true,
      flexPositive: true,
      flexShrink: true,
      flexNegative: true,
      flexOrder: true,
      gridArea: true,
      gridRow: true,
      gridRowEnd: true,
      gridRowSpan: true,
      gridRowStart: true,
      gridColumn: true,
      gridColumnEnd: true,
      gridColumnSpan: true,
      gridColumnStart: true,
      fontWeight: true,
      lineClamp: true,
      lineHeight: true,
      opacity: true,
      order: true,
      orphans: true,
      tabSize: true,
      widows: true,
      zIndex: true,
      zoom: true,
      // SVG-related properties
      fillOpacity: true,
      floodOpacity: true,
      stopOpacity: true,
      strokeDasharray: true,
      strokeDashoffset: true,
      strokeMiterlimit: true,
      strokeOpacity: true,
      strokeWidth: true
    };
    /**
     * @param {string} prefix vendor-specific prefix, eg: Webkit
     * @param {string} key style name, eg: transitionDuration
     * @return {string} style name prefixed with `prefix`, properly camelCased, eg:
     * WebkitTransitionDuration
     */

    function prefixKey(prefix, key) {
      return prefix + key.charAt(0).toUpperCase() + key.substring(1);
    }
    /**
     * Support style names that may come passed in prefixed by adding permutations
     * of vendor prefixes.
     */


    var prefixes = ['Webkit', 'ms', 'Moz', 'O']; // Using Object.keys here, or else the vanilla for-in loop makes IE8 go into an
    // infinite loop, because it iterates over the newly added props too.

    Object.keys(isUnitlessNumber).forEach(function (prop) {
      prefixes.forEach(function (prefix) {
        isUnitlessNumber[prefixKey(prefix, prop)] = isUnitlessNumber[prop];
      });
    });
    /**
     * Convert a value into the proper css writable value. The style name `name`
     * should be logical (no hyphens), as specified
     * in `CSSProperty.isUnitlessNumber`.
     *
     * @param {string} name CSS property name such as `topMargin`.
     * @param {*} value CSS property value such as `10px`.
     * @return {string} Normalized style value with dimensions applied.
     */

    function dangerousStyleValue(name, value, isCustomProperty) {
      // Note that we've removed escapeTextForBrowser() calls here since the
      // whole string will be escaped when the attribute is injected into
      // the markup. If you provide unsafe user data here they can inject
      // arbitrary CSS which may be problematic (I couldn't repro this):
      // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet
      // http://www.thespanner.co.uk/2007/11/26/ultimate-xss-css-injection/
      // This is not an XSS hole but instead a potential CSS injection issue
      // which has lead to a greater discussion about how we're going to
      // trust URLs moving forward. See #2115901
      var isEmpty = value == null || typeof value === 'boolean' || value === '';

      if (isEmpty) {
        return '';
      }

      if (!isCustomProperty && typeof value === 'number' && value !== 0 && !(isUnitlessNumber.hasOwnProperty(name) && isUnitlessNumber[name])) {
        return value + 'px'; // Presumes implicit 'px' suffix for unitless numbers
      }

      return ('' + value).trim();
    }

    var uppercasePattern = /([A-Z])/g;
    var msPattern = /^ms-/;
    /**
     * Hyphenates a camelcased CSS property name, for example:
     *
     *   > hyphenateStyleName('backgroundColor')
     *   < "background-color"
     *   > hyphenateStyleName('MozTransition')
     *   < "-moz-transition"
     *   > hyphenateStyleName('msTransition')
     *   < "-ms-transition"
     *
     * As Modernizr suggests (http://modernizr.com/docs/#prefixed), an `ms` prefix
     * is converted to `-ms-`.
     */

    function hyphenateStyleName(name) {
      return name.replace(uppercasePattern, '-$1').toLowerCase().replace(msPattern, '-ms-');
    }

    var warnValidStyle = function () {};

    {
      // 'msTransform' is correct, but the other prefixes should be capitalized
      var badVendoredStyleNamePattern = /^(?:webkit|moz|o)[A-Z]/;
      var msPattern$1 = /^-ms-/;
      var hyphenPattern = /-(.)/g; // style values shouldn't contain a semicolon

      var badStyleValueWithSemicolonPattern = /;\s*$/;
      var warnedStyleNames = {};
      var warnedStyleValues = {};
      var warnedForNaNValue = false;
      var warnedForInfinityValue = false;

      var camelize = function (string) {
        return string.replace(hyphenPattern, function (_, character) {
          return character.toUpperCase();
        });
      };

      var warnHyphenatedStyleName = function (name) {
        if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {
          return;
        }

        warnedStyleNames[name] = true;
        warning$1(false, 'Unsupported style property %s. Did you mean %s?', name, // As Andi Smith suggests
        // (http://www.andismith.com/blog/2012/02/modernizr-prefixed/), an `-ms` prefix
        // is converted to lowercase `ms`.
        camelize(name.replace(msPattern$1, 'ms-')));
      };

      var warnBadVendoredStyleName = function (name) {
        if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {
          return;
        }

        warnedStyleNames[name] = true;
        warning$1(false, 'Unsupported vendor-prefixed style property %s. Did you mean %s?', name, name.charAt(0).toUpperCase() + name.slice(1));
      };

      var warnStyleValueWithSemicolon = function (name, value) {
        if (warnedStyleValues.hasOwnProperty(value) && warnedStyleValues[value]) {
          return;
        }

        warnedStyleValues[value] = true;
        warning$1(false, "Style property values shouldn't contain a semicolon. " + 'Try "%s: %s" instead.', name, value.replace(badStyleValueWithSemicolonPattern, ''));
      };

      var warnStyleValueIsNaN = function (name, value) {
        if (warnedForNaNValue) {
          return;
        }

        warnedForNaNValue = true;
        warning$1(false, '`NaN` is an invalid value for the `%s` css style property.', name);
      };

      var warnStyleValueIsInfinity = function (name, value) {
        if (warnedForInfinityValue) {
          return;
        }

        warnedForInfinityValue = true;
        warning$1(false, '`Infinity` is an invalid value for the `%s` css style property.', name);
      };

      warnValidStyle = function (name, value) {
        if (name.indexOf('-') > -1) {
          warnHyphenatedStyleName(name);
        } else if (badVendoredStyleNamePattern.test(name)) {
          warnBadVendoredStyleName(name);
        } else if (badStyleValueWithSemicolonPattern.test(value)) {
          warnStyleValueWithSemicolon(name, value);
        }

        if (typeof value === 'number') {
          if (isNaN(value)) {
            warnStyleValueIsNaN(name, value);
          } else if (!isFinite(value)) {
            warnStyleValueIsInfinity(name, value);
          }
        }
      };
    }
    var warnValidStyle$1 = warnValidStyle;
    /**
     * Operations for dealing with CSS properties.
     */

    /**
     * This creates a string that is expected to be equivalent to the style
     * attribute generated by server-side rendering. It by-passes warnings and
     * security checks so it's not safe to use this value for anything other than
     * comparison. It is only used in DEV for SSR validation.
     */

    function createDangerousStringForStyles(styles) {
      {
        var serialized = '';
        var delimiter = '';

        for (var styleName in styles) {
          if (!styles.hasOwnProperty(styleName)) {
            continue;
          }

          var styleValue = styles[styleName];

          if (styleValue != null) {
            var isCustomProperty = styleName.indexOf('--') === 0;
            serialized += delimiter + (isCustomProperty ? styleName : hyphenateStyleName(styleName)) + ':';
            serialized += dangerousStyleValue(styleName, styleValue, isCustomProperty);
            delimiter = ';';
          }
        }

        return serialized || null;
      }
    }
    /**
     * Sets the value for multiple styles on a node.  If a value is specified as
     * '' (empty string), the corresponding style property will be unset.
     *
     * @param {DOMElement} node
     * @param {object} styles
     */


    function setValueForStyles(node, styles) {
      var style = node.style;

      for (var styleName in styles) {
        if (!styles.hasOwnProperty(styleName)) {
          continue;
        }

        var isCustomProperty = styleName.indexOf('--') === 0;
        {
          if (!isCustomProperty) {
            warnValidStyle$1(styleName, styles[styleName]);
          }
        }
        var styleValue = dangerousStyleValue(styleName, styles[styleName], isCustomProperty);

        if (styleName === 'float') {
          styleName = 'cssFloat';
        }

        if (isCustomProperty) {
          style.setProperty(styleName, styleValue);
        } else {
          style[styleName] = styleValue;
        }
      }
    }

    function isValueEmpty(value) {
      return value == null || typeof value === 'boolean' || value === '';
    }
    /**
     * Given {color: 'red', overflow: 'hidden'} returns {
     *   color: 'color',
     *   overflowX: 'overflow',
     *   overflowY: 'overflow',
     * }. This can be read as "the overflowY property was set by the overflow
     * shorthand". That is, the values are the property that each was derived from.
     */


    function expandShorthandMap(styles) {
      var expanded = {};

      for (var key in styles) {
        var longhands = shorthandToLonghand[key] || [key];

        for (var i = 0; i < longhands.length; i++) {
          expanded[longhands[i]] = key;
        }
      }

      return expanded;
    }
    /**
     * When mixing shorthand and longhand property names, we warn during updates if
     * we expect an incorrect result to occur. In particular, we warn for:
     *
     * Updating a shorthand property (longhand gets overwritten):
     *   {font: 'foo', fontVariant: 'bar'} -> {font: 'baz', fontVariant: 'bar'}
     *   becomes .style.font = 'baz'
     * Removing a shorthand property (longhand gets lost too):
     *   {font: 'foo', fontVariant: 'bar'} -> {fontVariant: 'bar'}
     *   becomes .style.font = ''
     * Removing a longhand property (should revert to shorthand; doesn't):
     *   {font: 'foo', fontVariant: 'bar'} -> {font: 'foo'}
     *   becomes .style.fontVariant = ''
     */


    function validateShorthandPropertyCollisionInDev(styleUpdates, nextStyles) {
      if (!warnAboutShorthandPropertyCollision) {
        return;
      }

      if (!nextStyles) {
        return;
      }

      var expandedUpdates = expandShorthandMap(styleUpdates);
      var expandedStyles = expandShorthandMap(nextStyles);
      var warnedAbout = {};

      for (var key in expandedUpdates) {
        var originalKey = expandedUpdates[key];
        var correctOriginalKey = expandedStyles[key];

        if (correctOriginalKey && originalKey !== correctOriginalKey) {
          var warningKey = originalKey + ',' + correctOriginalKey;

          if (warnedAbout[warningKey]) {
            continue;
          }

          warnedAbout[warningKey] = true;
          warning$1(false, '%s a style property during rerender (%s) when a ' + 'conflicting property is set (%s) can lead to styling bugs. To ' + "avoid this, don't mix shorthand and non-shorthand properties " + 'for the same value; instead, replace the shorthand with ' + 'separate values.', isValueEmpty(styleUpdates[originalKey]) ? 'Removing' : 'Updating', originalKey, correctOriginalKey);
        }
      }
    } // For HTML, certain tags should omit their close tag. We keep a whitelist for
    // those special-case tags.


    var omittedCloseTags = {
      area: true,
      base: true,
      br: true,
      col: true,
      embed: true,
      hr: true,
      img: true,
      input: true,
      keygen: true,
      link: true,
      meta: true,
      param: true,
      source: true,
      track: true,
      wbr: true // NOTE: menuitem's close tag should be omitted, but that causes problems.

    }; // `omittedCloseTags` except that `menuitem` should still have its closing tag.

    var voidElementTags = _assign({
      menuitem: true
    }, omittedCloseTags); // or add stack by default to invariants where possible.


    var HTML$1 = '__html';
    var ReactDebugCurrentFrame$3 = null;
    {
      ReactDebugCurrentFrame$3 = ReactSharedInternals.ReactDebugCurrentFrame;
    }

    function assertValidProps(tag, props) {
      if (!props) {
        return;
      } // Note the use of `==` which checks for null or undefined.


      if (voidElementTags[tag]) {
        if (!(props.children == null && props.dangerouslySetInnerHTML == null)) {
          {
            throw Error(tag + " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`." + ReactDebugCurrentFrame$3.getStackAddendum());
          }
        }
      }

      if (props.dangerouslySetInnerHTML != null) {
        if (!(props.children == null)) {
          {
            throw Error("Can only set one of `children` or `props.dangerouslySetInnerHTML`.");
          }
        }

        if (!(typeof props.dangerouslySetInnerHTML === 'object' && HTML$1 in props.dangerouslySetInnerHTML)) {
          {
            throw Error("`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://fb.me/react-invariant-dangerously-set-inner-html for more information.");
          }
        }
      }

      {
        !(props.suppressContentEditableWarning || !props.contentEditable || props.children == null) ? warning$1(false, 'A component is `contentEditable` and contains `children` managed by ' + 'React. It is now your responsibility to guarantee that none of ' + 'those nodes are unexpectedly modified or duplicated. This is ' + 'probably not intentional.') : void 0;
      }

      if (!(props.style == null || typeof props.style === 'object')) {
        {
          throw Error("The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX." + ReactDebugCurrentFrame$3.getStackAddendum());
        }
      }
    }

    function isCustomComponent(tagName, props) {
      if (tagName.indexOf('-') === -1) {
        return typeof props.is === 'string';
      }

      switch (tagName) {
        // These are reserved SVG and MathML elements.
        // We don't mind this whitelist too much because we expect it to never grow.
        // The alternative is to track the namespace in a few places which is convoluted.
        // https://w3c.github.io/webcomponents/spec/custom/#custom-elements-core-concepts
        case 'annotation-xml':
        case 'color-profile':
        case 'font-face':
        case 'font-face-src':
        case 'font-face-uri':
        case 'font-face-format':
        case 'font-face-name':
        case 'missing-glyph':
          return false;

        default:
          return true;
      }
    } // When adding attributes to the HTML or SVG whitelist, be sure to
    // also add them to this module to ensure casing and incorrect name
    // warnings.


    var possibleStandardNames = {
      // HTML
      accept: 'accept',
      acceptcharset: 'acceptCharset',
      'accept-charset': 'acceptCharset',
      accesskey: 'accessKey',
      action: 'action',
      allowfullscreen: 'allowFullScreen',
      alt: 'alt',
      as: 'as',
      async: 'async',
      autocapitalize: 'autoCapitalize',
      autocomplete: 'autoComplete',
      autocorrect: 'autoCorrect',
      autofocus: 'autoFocus',
      autoplay: 'autoPlay',
      autosave: 'autoSave',
      capture: 'capture',
      cellpadding: 'cellPadding',
      cellspacing: 'cellSpacing',
      challenge: 'challenge',
      charset: 'charSet',
      checked: 'checked',
      children: 'children',
      cite: 'cite',
      class: 'className',
      classid: 'classID',
      classname: 'className',
      cols: 'cols',
      colspan: 'colSpan',
      content: 'content',
      contenteditable: 'contentEditable',
      contextmenu: 'contextMenu',
      controls: 'controls',
      controlslist: 'controlsList',
      coords: 'coords',
      crossorigin: 'crossOrigin',
      dangerouslysetinnerhtml: 'dangerouslySetInnerHTML',
      data: 'data',
      datetime: 'dateTime',
      default: 'default',
      defaultchecked: 'defaultChecked',
      defaultvalue: 'defaultValue',
      defer: 'defer',
      dir: 'dir',
      disabled: 'disabled',
      disablepictureinpicture: 'disablePictureInPicture',
      download: 'download',
      draggable: 'draggable',
      enctype: 'encType',
      for: 'htmlFor',
      form: 'form',
      formmethod: 'formMethod',
      formaction: 'formAction',
      formenctype: 'formEncType',
      formnovalidate: 'formNoValidate',
      formtarget: 'formTarget',
      frameborder: 'frameBorder',
      headers: 'headers',
      height: 'height',
      hidden: 'hidden',
      high: 'high',
      href: 'href',
      hreflang: 'hrefLang',
      htmlfor: 'htmlFor',
      httpequiv: 'httpEquiv',
      'http-equiv': 'httpEquiv',
      icon: 'icon',
      id: 'id',
      innerhtml: 'innerHTML',
      inputmode: 'inputMode',
      integrity: 'integrity',
      is: 'is',
      itemid: 'itemID',
      itemprop: 'itemProp',
      itemref: 'itemRef',
      itemscope: 'itemScope',
      itemtype: 'itemType',
      keyparams: 'keyParams',
      keytype: 'keyType',
      kind: 'kind',
      label: 'label',
      lang: 'lang',
      list: 'list',
      loop: 'loop',
      low: 'low',
      manifest: 'manifest',
      marginwidth: 'marginWidth',
      marginheight: 'marginHeight',
      max: 'max',
      maxlength: 'maxLength',
      media: 'media',
      mediagroup: 'mediaGroup',
      method: 'method',
      min: 'min',
      minlength: 'minLength',
      multiple: 'multiple',
      muted: 'muted',
      name: 'name',
      nomodule: 'noModule',
      nonce: 'nonce',
      novalidate: 'noValidate',
      open: 'open',
      optimum: 'optimum',
      pattern: 'pattern',
      placeholder: 'placeholder',
      playsinline: 'playsInline',
      poster: 'poster',
      preload: 'preload',
      profile: 'profile',
      radiogroup: 'radioGroup',
      readonly: 'readOnly',
      referrerpolicy: 'referrerPolicy',
      rel: 'rel',
      required: 'required',
      reversed: 'reversed',
      role: 'role',
      rows: 'rows',
      rowspan: 'rowSpan',
      sandbox: 'sandbox',
      scope: 'scope',
      scoped: 'scoped',
      scrolling: 'scrolling',
      seamless: 'seamless',
      selected: 'selected',
      shape: 'shape',
      size: 'size',
      sizes: 'sizes',
      span: 'span',
      spellcheck: 'spellCheck',
      src: 'src',
      srcdoc: 'srcDoc',
      srclang: 'srcLang',
      srcset: 'srcSet',
      start: 'start',
      step: 'step',
      style: 'style',
      summary: 'summary',
      tabindex: 'tabIndex',
      target: 'target',
      title: 'title',
      type: 'type',
      usemap: 'useMap',
      value: 'value',
      width: 'width',
      wmode: 'wmode',
      wrap: 'wrap',
      // SVG
      about: 'about',
      accentheight: 'accentHeight',
      'accent-height': 'accentHeight',
      accumulate: 'accumulate',
      additive: 'additive',
      alignmentbaseline: 'alignmentBaseline',
      'alignment-baseline': 'alignmentBaseline',
      allowreorder: 'allowReorder',
      alphabetic: 'alphabetic',
      amplitude: 'amplitude',
      arabicform: 'arabicForm',
      'arabic-form': 'arabicForm',
      ascent: 'ascent',
      attributename: 'attributeName',
      attributetype: 'attributeType',
      autoreverse: 'autoReverse',
      azimuth: 'azimuth',
      basefrequency: 'baseFrequency',
      baselineshift: 'baselineShift',
      'baseline-shift': 'baselineShift',
      baseprofile: 'baseProfile',
      bbox: 'bbox',
      begin: 'begin',
      bias: 'bias',
      by: 'by',
      calcmode: 'calcMode',
      capheight: 'capHeight',
      'cap-height': 'capHeight',
      clip: 'clip',
      clippath: 'clipPath',
      'clip-path': 'clipPath',
      clippathunits: 'clipPathUnits',
      cliprule: 'clipRule',
      'clip-rule': 'clipRule',
      color: 'color',
      colorinterpolation: 'colorInterpolation',
      'color-interpolation': 'colorInterpolation',
      colorinterpolationfilters: 'colorInterpolationFilters',
      'color-interpolation-filters': 'colorInterpolationFilters',
      colorprofile: 'colorProfile',
      'color-profile': 'colorProfile',
      colorrendering: 'colorRendering',
      'color-rendering': 'colorRendering',
      contentscripttype: 'contentScriptType',
      contentstyletype: 'contentStyleType',
      cursor: 'cursor',
      cx: 'cx',
      cy: 'cy',
      d: 'd',
      datatype: 'datatype',
      decelerate: 'decelerate',
      descent: 'descent',
      diffuseconstant: 'diffuseConstant',
      direction: 'direction',
      display: 'display',
      divisor: 'divisor',
      dominantbaseline: 'dominantBaseline',
      'dominant-baseline': 'dominantBaseline',
      dur: 'dur',
      dx: 'dx',
      dy: 'dy',
      edgemode: 'edgeMode',
      elevation: 'elevation',
      enablebackground: 'enableBackground',
      'enable-background': 'enableBackground',
      end: 'end',
      exponent: 'exponent',
      externalresourcesrequired: 'externalResourcesRequired',
      fill: 'fill',
      fillopacity: 'fillOpacity',
      'fill-opacity': 'fillOpacity',
      fillrule: 'fillRule',
      'fill-rule': 'fillRule',
      filter: 'filter',
      filterres: 'filterRes',
      filterunits: 'filterUnits',
      floodopacity: 'floodOpacity',
      'flood-opacity': 'floodOpacity',
      floodcolor: 'floodColor',
      'flood-color': 'floodColor',
      focusable: 'focusable',
      fontfamily: 'fontFamily',
      'font-family': 'fontFamily',
      fontsize: 'fontSize',
      'font-size': 'fontSize',
      fontsizeadjust: 'fontSizeAdjust',
      'font-size-adjust': 'fontSizeAdjust',
      fontstretch: 'fontStretch',
      'font-stretch': 'fontStretch',
      fontstyle: 'fontStyle',
      'font-style': 'fontStyle',
      fontvariant: 'fontVariant',
      'font-variant': 'fontVariant',
      fontweight: 'fontWeight',
      'font-weight': 'fontWeight',
      format: 'format',
      from: 'from',
      fx: 'fx',
      fy: 'fy',
      g1: 'g1',
      g2: 'g2',
      glyphname: 'glyphName',
      'glyph-name': 'glyphName',
      glyphorientationhorizontal: 'glyphOrientationHorizontal',
      'glyph-orientation-horizontal': 'glyphOrientationHorizontal',
      glyphorientationvertical: 'glyphOrientationVertical',
      'glyph-orientation-vertical': 'glyphOrientationVertical',
      glyphref: 'glyphRef',
      gradienttransform: 'gradientTransform',
      gradientunits: 'gradientUnits',
      hanging: 'hanging',
      horizadvx: 'horizAdvX',
      'horiz-adv-x': 'horizAdvX',
      horizoriginx: 'horizOriginX',
      'horiz-origin-x': 'horizOriginX',
      ideographic: 'ideographic',
      imagerendering: 'imageRendering',
      'image-rendering': 'imageRendering',
      in2: 'in2',
      in: 'in',
      inlist: 'inlist',
      intercept: 'intercept',
      k1: 'k1',
      k2: 'k2',
      k3: 'k3',
      k4: 'k4',
      k: 'k',
      kernelmatrix: 'kernelMatrix',
      kernelunitlength: 'kernelUnitLength',
      kerning: 'kerning',
      keypoints: 'keyPoints',
      keysplines: 'keySplines',
      keytimes: 'keyTimes',
      lengthadjust: 'lengthAdjust',
      letterspacing: 'letterSpacing',
      'letter-spacing': 'letterSpacing',
      lightingcolor: 'lightingColor',
      'lighting-color': 'lightingColor',
      limitingconeangle: 'limitingConeAngle',
      local: 'local',
      markerend: 'markerEnd',
      'marker-end': 'markerEnd',
      markerheight: 'markerHeight',
      markermid: 'markerMid',
      'marker-mid': 'markerMid',
      markerstart: 'markerStart',
      'marker-start': 'markerStart',
      markerunits: 'markerUnits',
      markerwidth: 'markerWidth',
      mask: 'mask',
      maskcontentunits: 'maskContentUnits',
      maskunits: 'maskUnits',
      mathematical: 'mathematical',
      mode: 'mode',
      numoctaves: 'numOctaves',
      offset: 'offset',
      opacity: 'opacity',
      operator: 'operator',
      order: 'order',
      orient: 'orient',
      orientation: 'orientation',
      origin: 'origin',
      overflow: 'overflow',
      overlineposition: 'overlinePosition',
      'overline-position': 'overlinePosition',
      overlinethickness: 'overlineThickness',
      'overline-thickness': 'overlineThickness',
      paintorder: 'paintOrder',
      'paint-order': 'paintOrder',
      panose1: 'panose1',
      'panose-1': 'panose1',
      pathlength: 'pathLength',
      patterncontentunits: 'patternContentUnits',
      patterntransform: 'patternTransform',
      patternunits: 'patternUnits',
      pointerevents: 'pointerEvents',
      'pointer-events': 'pointerEvents',
      points: 'points',
      pointsatx: 'pointsAtX',
      pointsaty: 'pointsAtY',
      pointsatz: 'pointsAtZ',
      prefix: 'prefix',
      preservealpha: 'preserveAlpha',
      preserveaspectratio: 'preserveAspectRatio',
      primitiveunits: 'primitiveUnits',
      property: 'property',
      r: 'r',
      radius: 'radius',
      refx: 'refX',
      refy: 'refY',
      renderingintent: 'renderingIntent',
      'rendering-intent': 'renderingIntent',
      repeatcount: 'repeatCount',
      repeatdur: 'repeatDur',
      requiredextensions: 'requiredExtensions',
      requiredfeatures: 'requiredFeatures',
      resource: 'resource',
      restart: 'restart',
      result: 'result',
      results: 'results',
      rotate: 'rotate',
      rx: 'rx',
      ry: 'ry',
      scale: 'scale',
      security: 'security',
      seed: 'seed',
      shaperendering: 'shapeRendering',
      'shape-rendering': 'shapeRendering',
      slope: 'slope',
      spacing: 'spacing',
      specularconstant: 'specularConstant',
      specularexponent: 'specularExponent',
      speed: 'speed',
      spreadmethod: 'spreadMethod',
      startoffset: 'startOffset',
      stddeviation: 'stdDeviation',
      stemh: 'stemh',
      stemv: 'stemv',
      stitchtiles: 'stitchTiles',
      stopcolor: 'stopColor',
      'stop-color': 'stopColor',
      stopopacity: 'stopOpacity',
      'stop-opacity': 'stopOpacity',
      strikethroughposition: 'strikethroughPosition',
      'strikethrough-position': 'strikethroughPosition',
      strikethroughthickness: 'strikethroughThickness',
      'strikethrough-thickness': 'strikethroughThickness',
      string: 'string',
      stroke: 'stroke',
      strokedasharray: 'strokeDasharray',
      'stroke-dasharray': 'strokeDasharray',
      strokedashoffset: 'strokeDashoffset',
      'stroke-dashoffset': 'strokeDashoffset',
      strokelinecap: 'strokeLinecap',
      'stroke-linecap': 'strokeLinecap',
      strokelinejoin: 'strokeLinejoin',
      'stroke-linejoin': 'strokeLinejoin',
      strokemiterlimit: 'strokeMiterlimit',
      'stroke-miterlimit': 'strokeMiterlimit',
      strokewidth: 'strokeWidth',
      'stroke-width': 'strokeWidth',
      strokeopacity: 'strokeOpacity',
      'stroke-opacity': 'strokeOpacity',
      suppresscontenteditablewarning: 'suppressContentEditableWarning',
      suppresshydrationwarning: 'suppressHydrationWarning',
      surfacescale: 'surfaceScale',
      systemlanguage: 'systemLanguage',
      tablevalues: 'tableValues',
      targetx: 'targetX',
      targety: 'targetY',
      textanchor: 'textAnchor',
      'text-anchor': 'textAnchor',
      textdecoration: 'textDecoration',
      'text-decoration': 'textDecoration',
      textlength: 'textLength',
      textrendering: 'textRendering',
      'text-rendering': 'textRendering',
      to: 'to',
      transform: 'transform',
      typeof: 'typeof',
      u1: 'u1',
      u2: 'u2',
      underlineposition: 'underlinePosition',
      'underline-position': 'underlinePosition',
      underlinethickness: 'underlineThickness',
      'underline-thickness': 'underlineThickness',
      unicode: 'unicode',
      unicodebidi: 'unicodeBidi',
      'unicode-bidi': 'unicodeBidi',
      unicoderange: 'unicodeRange',
      'unicode-range': 'unicodeRange',
      unitsperem: 'unitsPerEm',
      'units-per-em': 'unitsPerEm',
      unselectable: 'unselectable',
      valphabetic: 'vAlphabetic',
      'v-alphabetic': 'vAlphabetic',
      values: 'values',
      vectoreffect: 'vectorEffect',
      'vector-effect': 'vectorEffect',
      version: 'version',
      vertadvy: 'vertAdvY',
      'vert-adv-y': 'vertAdvY',
      vertoriginx: 'vertOriginX',
      'vert-origin-x': 'vertOriginX',
      vertoriginy: 'vertOriginY',
      'vert-origin-y': 'vertOriginY',
      vhanging: 'vHanging',
      'v-hanging': 'vHanging',
      videographic: 'vIdeographic',
      'v-ideographic': 'vIdeographic',
      viewbox: 'viewBox',
      viewtarget: 'viewTarget',
      visibility: 'visibility',
      vmathematical: 'vMathematical',
      'v-mathematical': 'vMathematical',
      vocab: 'vocab',
      widths: 'widths',
      wordspacing: 'wordSpacing',
      'word-spacing': 'wordSpacing',
      writingmode: 'writingMode',
      'writing-mode': 'writingMode',
      x1: 'x1',
      x2: 'x2',
      x: 'x',
      xchannelselector: 'xChannelSelector',
      xheight: 'xHeight',
      'x-height': 'xHeight',
      xlinkactuate: 'xlinkActuate',
      'xlink:actuate': 'xlinkActuate',
      xlinkarcrole: 'xlinkArcrole',
      'xlink:arcrole': 'xlinkArcrole',
      xlinkhref: 'xlinkHref',
      'xlink:href': 'xlinkHref',
      xlinkrole: 'xlinkRole',
      'xlink:role': 'xlinkRole',
      xlinkshow: 'xlinkShow',
      'xlink:show': 'xlinkShow',
      xlinktitle: 'xlinkTitle',
      'xlink:title': 'xlinkTitle',
      xlinktype: 'xlinkType',
      'xlink:type': 'xlinkType',
      xmlbase: 'xmlBase',
      'xml:base': 'xmlBase',
      xmllang: 'xmlLang',
      'xml:lang': 'xmlLang',
      xmlns: 'xmlns',
      'xml:space': 'xmlSpace',
      xmlnsxlink: 'xmlnsXlink',
      'xmlns:xlink': 'xmlnsXlink',
      xmlspace: 'xmlSpace',
      y1: 'y1',
      y2: 'y2',
      y: 'y',
      ychannelselector: 'yChannelSelector',
      z: 'z',
      zoomandpan: 'zoomAndPan'
    };
    var ariaProperties = {
      'aria-current': 0,
      // state
      'aria-details': 0,
      'aria-disabled': 0,
      // state
      'aria-hidden': 0,
      // state
      'aria-invalid': 0,
      // state
      'aria-keyshortcuts': 0,
      'aria-label': 0,
      'aria-roledescription': 0,
      // Widget Attributes
      'aria-autocomplete': 0,
      'aria-checked': 0,
      'aria-expanded': 0,
      'aria-haspopup': 0,
      'aria-level': 0,
      'aria-modal': 0,
      'aria-multiline': 0,
      'aria-multiselectable': 0,
      'aria-orientation': 0,
      'aria-placeholder': 0,
      'aria-pressed': 0,
      'aria-readonly': 0,
      'aria-required': 0,
      'aria-selected': 0,
      'aria-sort': 0,
      'aria-valuemax': 0,
      'aria-valuemin': 0,
      'aria-valuenow': 0,
      'aria-valuetext': 0,
      // Live Region Attributes
      'aria-atomic': 0,
      'aria-busy': 0,
      'aria-live': 0,
      'aria-relevant': 0,
      // Drag-and-Drop Attributes
      'aria-dropeffect': 0,
      'aria-grabbed': 0,
      // Relationship Attributes
      'aria-activedescendant': 0,
      'aria-colcount': 0,
      'aria-colindex': 0,
      'aria-colspan': 0,
      'aria-controls': 0,
      'aria-describedby': 0,
      'aria-errormessage': 0,
      'aria-flowto': 0,
      'aria-labelledby': 0,
      'aria-owns': 0,
      'aria-posinset': 0,
      'aria-rowcount': 0,
      'aria-rowindex': 0,
      'aria-rowspan': 0,
      'aria-setsize': 0
    };
    var warnedProperties = {};
    var rARIA = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');
    var rARIACamel = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');
    var hasOwnProperty$1 = Object.prototype.hasOwnProperty;

    function validateProperty(tagName, name) {
      if (hasOwnProperty$1.call(warnedProperties, name) && warnedProperties[name]) {
        return true;
      }

      if (rARIACamel.test(name)) {
        var ariaName = 'aria-' + name.slice(4).toLowerCase();
        var correctName = ariaProperties.hasOwnProperty(ariaName) ? ariaName : null; // If this is an aria-* attribute, but is not listed in the known DOM
        // DOM properties, then it is an invalid aria-* attribute.

        if (correctName == null) {
          warning$1(false, 'Invalid ARIA attribute `%s`. ARIA attributes follow the pattern aria-* and must be lowercase.', name);
          warnedProperties[name] = true;
          return true;
        } // aria-* attributes should be lowercase; suggest the lowercase version.


        if (name !== correctName) {
          warning$1(false, 'Invalid ARIA attribute `%s`. Did you mean `%s`?', name, correctName);
          warnedProperties[name] = true;
          return true;
        }
      }

      if (rARIA.test(name)) {
        var lowerCasedName = name.toLowerCase();
        var standardName = ariaProperties.hasOwnProperty(lowerCasedName) ? lowerCasedName : null; // If this is an aria-* attribute, but is not listed in the known DOM
        // DOM properties, then it is an invalid aria-* attribute.

        if (standardName == null) {
          warnedProperties[name] = true;
          return false;
        } // aria-* attributes should be lowercase; suggest the lowercase version.


        if (name !== standardName) {
          warning$1(false, 'Unknown ARIA attribute `%s`. Did you mean `%s`?', name, standardName);
          warnedProperties[name] = true;
          return true;
        }
      }

      return true;
    }

    function warnInvalidARIAProps(type, props) {
      var invalidProps = [];

      for (var key in props) {
        var isValid = validateProperty(type, key);

        if (!isValid) {
          invalidProps.push(key);
        }
      }

      var unknownPropString = invalidProps.map(function (prop) {
        return '`' + prop + '`';
      }).join(', ');

      if (invalidProps.length === 1) {
        warning$1(false, 'Invalid aria prop %s on <%s> tag. ' + 'For details, see https://fb.me/invalid-aria-prop', unknownPropString, type);
      } else if (invalidProps.length > 1) {
        warning$1(false, 'Invalid aria props %s on <%s> tag. ' + 'For details, see https://fb.me/invalid-aria-prop', unknownPropString, type);
      }
    }

    function validateProperties(type, props) {
      if (isCustomComponent(type, props)) {
        return;
      }

      warnInvalidARIAProps(type, props);
    }

    var didWarnValueNull = false;

    function validateProperties$1(type, props) {
      if (type !== 'input' && type !== 'textarea' && type !== 'select') {
        return;
      }

      if (props != null && props.value === null && !didWarnValueNull) {
        didWarnValueNull = true;

        if (type === 'select' && props.multiple) {
          warning$1(false, '`value` prop on `%s` should not be null. ' + 'Consider using an empty array when `multiple` is set to `true` ' + 'to clear the component or `undefined` for uncontrolled components.', type);
        } else {
          warning$1(false, '`value` prop on `%s` should not be null. ' + 'Consider using an empty string to clear the component or `undefined` ' + 'for uncontrolled components.', type);
        }
      }
    }

    var validateProperty$1 = function () {};

    {
      var warnedProperties$1 = {};
      var _hasOwnProperty = Object.prototype.hasOwnProperty;
      var EVENT_NAME_REGEX = /^on./;
      var INVALID_EVENT_NAME_REGEX = /^on[^A-Z]/;
      var rARIA$1 = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');
      var rARIACamel$1 = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');

      validateProperty$1 = function (tagName, name, value, canUseEventSystem) {
        if (_hasOwnProperty.call(warnedProperties$1, name) && warnedProperties$1[name]) {
          return true;
        }

        var lowerCasedName = name.toLowerCase();

        if (lowerCasedName === 'onfocusin' || lowerCasedName === 'onfocusout') {
          warning$1(false, 'React uses onFocus and onBlur instead of onFocusIn and onFocusOut. ' + 'All React events are normalized to bubble, so onFocusIn and onFocusOut ' + 'are not needed/supported by React.');
          warnedProperties$1[name] = true;
          return true;
        } // We can't rely on the event system being injected on the server.


        if (canUseEventSystem) {
          if (registrationNameModules.hasOwnProperty(name)) {
            return true;
          }

          var registrationName = possibleRegistrationNames.hasOwnProperty(lowerCasedName) ? possibleRegistrationNames[lowerCasedName] : null;

          if (registrationName != null) {
            warning$1(false, 'Invalid event handler property `%s`. Did you mean `%s`?', name, registrationName);
            warnedProperties$1[name] = true;
            return true;
          }

          if (EVENT_NAME_REGEX.test(name)) {
            warning$1(false, 'Unknown event handler property `%s`. It will be ignored.', name);
            warnedProperties$1[name] = true;
            return true;
          }
        } else if (EVENT_NAME_REGEX.test(name)) {
          // If no event plugins have been injected, we are in a server environment.
          // So we can't tell if the event name is correct for sure, but we can filter
          // out known bad ones like `onclick`. We can't suggest a specific replacement though.
          if (INVALID_EVENT_NAME_REGEX.test(name)) {
            warning$1(false, 'Invalid event handler property `%s`. ' + 'React events use the camelCase naming convention, for example `onClick`.', name);
          }

          warnedProperties$1[name] = true;
          return true;
        } // Let the ARIA attribute hook validate ARIA attributes


        if (rARIA$1.test(name) || rARIACamel$1.test(name)) {
          return true;
        }

        if (lowerCasedName === 'innerhtml') {
          warning$1(false, 'Directly setting property `innerHTML` is not permitted. ' + 'For more information, lookup documentation on `dangerouslySetInnerHTML`.');
          warnedProperties$1[name] = true;
          return true;
        }

        if (lowerCasedName === 'aria') {
          warning$1(false, 'The `aria` attribute is reserved for future use in React. ' + 'Pass individual `aria-` attributes instead.');
          warnedProperties$1[name] = true;
          return true;
        }

        if (lowerCasedName === 'is' && value !== null && value !== undefined && typeof value !== 'string') {
          warning$1(false, 'Received a `%s` for a string attribute `is`. If this is expected, cast ' + 'the value to a string.', typeof value);
          warnedProperties$1[name] = true;
          return true;
        }

        if (typeof value === 'number' && isNaN(value)) {
          warning$1(false, 'Received NaN for the `%s` attribute. If this is expected, cast ' + 'the value to a string.', name);
          warnedProperties$1[name] = true;
          return true;
        }

        var propertyInfo = getPropertyInfo(name);
        var isReserved = propertyInfo !== null && propertyInfo.type === RESERVED; // Known attributes should match the casing specified in the property config.

        if (possibleStandardNames.hasOwnProperty(lowerCasedName)) {
          var standardName = possibleStandardNames[lowerCasedName];

          if (standardName !== name) {
            warning$1(false, 'Invalid DOM property `%s`. Did you mean `%s`?', name, standardName);
            warnedProperties$1[name] = true;
            return true;
          }
        } else if (!isReserved && name !== lowerCasedName) {
          // Unknown attributes should have lowercase casing since that's how they
          // will be cased anyway with server rendering.
          warning$1(false, 'React does not recognize the `%s` prop on a DOM element. If you ' + 'intentionally want it to appear in the DOM as a custom ' + 'attribute, spell it as lowercase `%s` instead. ' + 'If you accidentally passed it from a parent component, remove ' + 'it from the DOM element.', name, lowerCasedName);
          warnedProperties$1[name] = true;
          return true;
        }

        if (typeof value === 'boolean' && shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {
          if (value) {
            warning$1(false, 'Received `%s` for a non-boolean attribute `%s`.\n\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s="%s" or %s={value.toString()}.', value, name, name, value, name);
          } else {
            warning$1(false, 'Received `%s` for a non-boolean attribute `%s`.\n\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s="%s" or %s={value.toString()}.\n\n' + 'If you used to conditionally omit it with %s={condition && value}, ' + 'pass %s={condition ? value : undefined} instead.', value, name, name, value, name, name, name);
          }

          warnedProperties$1[name] = true;
          return true;
        } // Now that we've validated casing, do not validate
        // data types for reserved props


        if (isReserved) {
          return true;
        } // Warn when a known attribute is a bad type


        if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {
          warnedProperties$1[name] = true;
          return false;
        } // Warn when passing the strings 'false' or 'true' into a boolean prop


        if ((value === 'false' || value === 'true') && propertyInfo !== null && propertyInfo.type === BOOLEAN) {
          warning$1(false, 'Received the string `%s` for the boolean attribute `%s`. ' + '%s ' + 'Did you mean %s={%s}?', value, name, value === 'false' ? 'The browser will interpret it as a truthy value.' : 'Although this works, it will not work as expected if you pass the string "false".', name, value);
          warnedProperties$1[name] = true;
          return true;
        }

        return true;
      };
    }

    var warnUnknownProperties = function (type, props, canUseEventSystem) {
      var unknownProps = [];

      for (var key in props) {
        var isValid = validateProperty$1(type, key, props[key], canUseEventSystem);

        if (!isValid) {
          unknownProps.push(key);
        }
      }

      var unknownPropString = unknownProps.map(function (prop) {
        return '`' + prop + '`';
      }).join(', ');

      if (unknownProps.length === 1) {
        warning$1(false, 'Invalid value for prop %s on <%s> tag. Either remove it from the element, ' + 'or pass a string or number value to keep it in the DOM. ' + 'For details, see https://fb.me/react-attribute-behavior', unknownPropString, type);
      } else if (unknownProps.length > 1) {
        warning$1(false, 'Invalid values for props %s on <%s> tag. Either remove them from the element, ' + 'or pass a string or number value to keep them in the DOM. ' + 'For details, see https://fb.me/react-attribute-behavior', unknownPropString, type);
      }
    };

    function validateProperties$2(type, props, canUseEventSystem) {
      if (isCustomComponent(type, props)) {
        return;
      }

      warnUnknownProperties(type, props, canUseEventSystem);
    } // TODO: direct imports like some-package/src/* are bad. Fix me.


    var didWarnInvalidHydration = false;
    var didWarnShadyDOM = false;
    var didWarnScriptTags = false;
    var DANGEROUSLY_SET_INNER_HTML = 'dangerouslySetInnerHTML';
    var SUPPRESS_CONTENT_EDITABLE_WARNING = 'suppressContentEditableWarning';
    var SUPPRESS_HYDRATION_WARNING$1 = 'suppressHydrationWarning';
    var AUTOFOCUS = 'autoFocus';
    var CHILDREN = 'children';
    var STYLE$1 = 'style';
    var HTML = '__html';
    var LISTENERS = 'listeners';
    var HTML_NAMESPACE = Namespaces.html;
    var warnedUnknownTags;
    var suppressHydrationWarning;
    var validatePropertiesInDevelopment;
    var warnForTextDifference;
    var warnForPropDifference;
    var warnForExtraAttributes;
    var warnForInvalidEventListener;
    var canDiffStyleForHydrationWarning;
    var normalizeMarkupForTextOrAttribute;
    var normalizeHTML;
    {
      warnedUnknownTags = {
        // Chrome is the only major browser not shipping <time>. But as of July
        // 2017 it intends to ship it due to widespread usage. We intentionally
        // *don't* warn for <time> even if it's unrecognized by Chrome because
        // it soon will be, and many apps have been using it anyway.
        time: true,
        // There are working polyfills for <dialog>. Let people use it.
        dialog: true,
        // Electron ships a custom <webview> tag to display external web content in
        // an isolated frame and process.
        // This tag is not present in non Electron environments such as JSDom which
        // is often used for testing purposes.
        // @see https://electronjs.org/docs/api/webview-tag
        webview: true
      };

      validatePropertiesInDevelopment = function (type, props) {
        validateProperties(type, props);
        validateProperties$1(type, props);
        validateProperties$2(type, props,
        /* canUseEventSystem */
        true);
      }; // IE 11 parses & normalizes the style attribute as opposed to other
      // browsers. It adds spaces and sorts the properties in some
      // non-alphabetical order. Handling that would require sorting CSS
      // properties in the client & server versions or applying
      // `expectedStyle` to a temporary DOM node to read its `style` attribute
      // normalized. Since it only affects IE, we're skipping style warnings
      // in that browser completely in favor of doing all that work.
      // See https://github.com/facebook/react/issues/11807


      canDiffStyleForHydrationWarning = canUseDOM && !document.documentMode; // HTML parsing normalizes CR and CRLF to LF.
      // It also can turn \u0000 into \uFFFD inside attributes.
      // https://www.w3.org/TR/html5/single-page.html#preprocessing-the-input-stream
      // If we have a mismatch, it might be caused by that.
      // We will still patch up in this case but not fire the warning.

      var NORMALIZE_NEWLINES_REGEX = /\r\n?/g;
      var NORMALIZE_NULL_AND_REPLACEMENT_REGEX = /\u0000|\uFFFD/g;

      normalizeMarkupForTextOrAttribute = function (markup) {
        var markupString = typeof markup === 'string' ? markup : '' + markup;
        return markupString.replace(NORMALIZE_NEWLINES_REGEX, '\n').replace(NORMALIZE_NULL_AND_REPLACEMENT_REGEX, '');
      };

      warnForTextDifference = function (serverText, clientText) {
        if (didWarnInvalidHydration) {
          return;
        }

        var normalizedClientText = normalizeMarkupForTextOrAttribute(clientText);
        var normalizedServerText = normalizeMarkupForTextOrAttribute(serverText);

        if (normalizedServerText === normalizedClientText) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Text content did not match. Server: "%s" Client: "%s"', normalizedServerText, normalizedClientText);
      };

      warnForPropDifference = function (propName, serverValue, clientValue) {
        if (didWarnInvalidHydration) {
          return;
        }

        var normalizedClientValue = normalizeMarkupForTextOrAttribute(clientValue);
        var normalizedServerValue = normalizeMarkupForTextOrAttribute(serverValue);

        if (normalizedServerValue === normalizedClientValue) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Prop `%s` did not match. Server: %s Client: %s', propName, JSON.stringify(normalizedServerValue), JSON.stringify(normalizedClientValue));
      };

      warnForExtraAttributes = function (attributeNames) {
        if (didWarnInvalidHydration) {
          return;
        }

        didWarnInvalidHydration = true;
        var names = [];
        attributeNames.forEach(function (name) {
          names.push(name);
        });
        warningWithoutStack$1(false, 'Extra attributes from the server: %s', names);
      };

      warnForInvalidEventListener = function (registrationName, listener) {
        if (listener === false) {
          warning$1(false, 'Expected `%s` listener to be a function, instead got `false`.\n\n' + 'If you used to conditionally omit it with %s={condition && value}, ' + 'pass %s={condition ? value : undefined} instead.', registrationName, registrationName, registrationName);
        } else {
          warning$1(false, 'Expected `%s` listener to be a function, instead got a value of `%s` type.', registrationName, typeof listener);
        }
      }; // Parse the HTML and read it back to normalize the HTML string so that it
      // can be used for comparison.


      normalizeHTML = function (parent, html) {
        // We could have created a separate document here to avoid
        // re-initializing custom elements if they exist. But this breaks
        // how <noscript> is being handled. So we use the same document.
        // See the discussion in https://github.com/facebook/react/pull/11157.
        var testElement = parent.namespaceURI === HTML_NAMESPACE ? parent.ownerDocument.createElement(parent.tagName) : parent.ownerDocument.createElementNS(parent.namespaceURI, parent.tagName);
        testElement.innerHTML = html;
        return testElement.innerHTML;
      };
    }

    function ensureListeningTo(rootContainerElement, registrationName) {
      var isDocumentOrFragment = rootContainerElement.nodeType === DOCUMENT_NODE || rootContainerElement.nodeType === DOCUMENT_FRAGMENT_NODE;
      var doc = isDocumentOrFragment ? rootContainerElement : rootContainerElement.ownerDocument;
      listenTo(registrationName, doc);
    }

    function getOwnerDocumentFromRootContainer(rootContainerElement) {
      return rootContainerElement.nodeType === DOCUMENT_NODE ? rootContainerElement : rootContainerElement.ownerDocument;
    }

    function noop() {}

    function trapClickOnNonInteractiveElement(node) {
      // Mobile Safari does not fire properly bubble click events on
      // non-interactive elements, which means delegated click listeners do not
      // fire. The workaround for this bug involves attaching an empty click
      // listener on the target node.
      // http://www.quirksmode.org/blog/archives/2010/09/click_event_del.html
      // Just set it using the onclick property so that we don't have to manage any
      // bookkeeping for it. Not sure if we need to clear it when the listener is
      // removed.
      // TODO: Only do this for the relevant Safaris maybe?
      node.onclick = noop;
    }

    function setInitialDOMProperties(tag, domElement, rootContainerElement, nextProps, isCustomComponentTag) {
      for (var propKey in nextProps) {
        if (!nextProps.hasOwnProperty(propKey)) {
          continue;
        }

        var nextProp = nextProps[propKey];

        if (propKey === STYLE$1) {
          {
            if (nextProp) {
              // Freeze the next style object so that we can assume it won't be
              // mutated. We have already warned for this in the past.
              Object.freeze(nextProp);
            }
          } // Relies on `updateStylesByID` not mutating `styleUpdates`.

          setValueForStyles(domElement, nextProp);
        } else if (propKey === DANGEROUSLY_SET_INNER_HTML) {
          var nextHtml = nextProp ? nextProp[HTML] : undefined;

          if (nextHtml != null) {
            setInnerHTML(domElement, nextHtml);
          }
        } else if (propKey === CHILDREN) {
          if (typeof nextProp === 'string') {
            // Avoid setting initial textContent when the text is empty. In IE11 setting
            // textContent on a <textarea> will cause the placeholder to not
            // show within the <textarea> until it has been focused and blurred again.
            // https://github.com/facebook/react/issues/6731#issuecomment-254874553
            var canSetTextContent = tag !== 'textarea' || nextProp !== '';

            if (canSetTextContent) {
              setTextContent(domElement, nextProp);
            }
          } else if (typeof nextProp === 'number') {
            setTextContent(domElement, '' + nextProp);
          }
        } else if (enableFlareAPI && propKey === LISTENERS || propKey === SUPPRESS_CONTENT_EDITABLE_WARNING || propKey === SUPPRESS_HYDRATION_WARNING$1) {// Noop
        } else if (propKey === AUTOFOCUS) {// We polyfill it separately on the client during commit.
          // We could have excluded it in the property list instead of
          // adding a special case here, but then it wouldn't be emitted
          // on server rendering (but we *do* want to emit it in SSR).
        } else if (registrationNameModules.hasOwnProperty(propKey)) {
          if (nextProp != null) {
            if (true && typeof nextProp !== 'function') {
              warnForInvalidEventListener(propKey, nextProp);
            }

            ensureListeningTo(rootContainerElement, propKey);
          }
        } else if (nextProp != null) {
          setValueForProperty(domElement, propKey, nextProp, isCustomComponentTag);
        }
      }
    }

    function updateDOMProperties(domElement, updatePayload, wasCustomComponentTag, isCustomComponentTag) {
      // TODO: Handle wasCustomComponentTag
      for (var i = 0; i < updatePayload.length; i += 2) {
        var propKey = updatePayload[i];
        var propValue = updatePayload[i + 1];

        if (propKey === STYLE$1) {
          setValueForStyles(domElement, propValue);
        } else if (propKey === DANGEROUSLY_SET_INNER_HTML) {
          setInnerHTML(domElement, propValue);
        } else if (propKey === CHILDREN) {
          setTextContent(domElement, propValue);
        } else {
          setValueForProperty(domElement, propKey, propValue, isCustomComponentTag);
        }
      }
    }

    function createElement(type, props, rootContainerElement, parentNamespace) {
      var isCustomComponentTag; // We create tags in the namespace of their parent container, except HTML
      // tags get no namespace.

      var ownerDocument = getOwnerDocumentFromRootContainer(rootContainerElement);
      var domElement;
      var namespaceURI = parentNamespace;

      if (namespaceURI === HTML_NAMESPACE) {
        namespaceURI = getIntrinsicNamespace(type);
      }

      if (namespaceURI === HTML_NAMESPACE) {
        {
          isCustomComponentTag = isCustomComponent(type, props); // Should this check be gated by parent namespace? Not sure we want to
          // allow <SVG> or <mATH>.

          !(isCustomComponentTag || type === type.toLowerCase()) ? warning$1(false, '<%s /> is using incorrect casing. ' + 'Use PascalCase for React components, ' + 'or lowercase for HTML elements.', type) : void 0;
        }

        if (type === 'script') {
          // Create the script via .innerHTML so its "parser-inserted" flag is
          // set to true and it does not execute
          var div = ownerDocument.createElement('div');
          {
            if (enableTrustedTypesIntegration && !didWarnScriptTags) {
              warning$1(false, 'Encountered a script tag while rendering React component. ' + 'Scripts inside React components are never executed when rendering ' + 'on the client. Consider using template tag instead ' + '(https://developer.mozilla.org/en-US/docs/Web/HTML/Element/template).');
              didWarnScriptTags = true;
            }
          }
          div.innerHTML = '<script><' + '/script>'; // eslint-disable-line
          // This is guaranteed to yield a script element.

          var firstChild = div.firstChild;
          domElement = div.removeChild(firstChild);
        } else if (typeof props.is === 'string') {
          // $FlowIssue `createElement` should be updated for Web Components
          domElement = ownerDocument.createElement(type, {
            is: props.is
          });
        } else {
          // Separate else branch instead of using `props.is || undefined` above because of a Firefox bug.
          // See discussion in https://github.com/facebook/react/pull/6896
          // and discussion in https://bugzilla.mozilla.org/show_bug.cgi?id=1276240
          domElement = ownerDocument.createElement(type); // Normally attributes are assigned in `setInitialDOMProperties`, however the `multiple` and `size`
          // attributes on `select`s needs to be added before `option`s are inserted.
          // This prevents:
          // - a bug where the `select` does not scroll to the correct option because singular
          //  `select` elements automatically pick the first item #13222
          // - a bug where the `select` set the first item as selected despite the `size` attribute #14239
          // See https://github.com/facebook/react/issues/13222
          // and https://github.com/facebook/react/issues/14239

          if (type === 'select') {
            var node = domElement;

            if (props.multiple) {
              node.multiple = true;
            } else if (props.size) {
              // Setting a size greater than 1 causes a select to behave like `multiple=true`, where
              // it is possible that no option is selected.
              //
              // This is only necessary when a select in "single selection mode".
              node.size = props.size;
            }
          }
        }
      } else {
        domElement = ownerDocument.createElementNS(namespaceURI, type);
      }

      {
        if (namespaceURI === HTML_NAMESPACE) {
          if (!isCustomComponentTag && Object.prototype.toString.call(domElement) === '[object HTMLUnknownElement]' && !Object.prototype.hasOwnProperty.call(warnedUnknownTags, type)) {
            warnedUnknownTags[type] = true;
            warning$1(false, 'The tag <%s> is unrecognized in this browser. ' + 'If you meant to render a React component, start its name with ' + 'an uppercase letter.', type);
          }
        }
      }
      return domElement;
    }

    function createTextNode(text, rootContainerElement) {
      return getOwnerDocumentFromRootContainer(rootContainerElement).createTextNode(text);
    }

    function setInitialProperties(domElement, tag, rawProps, rootContainerElement) {
      var isCustomComponentTag = isCustomComponent(tag, rawProps);
      {
        validatePropertiesInDevelopment(tag, rawProps);

        if (isCustomComponentTag && !didWarnShadyDOM && domElement.shadyRoot) {
          warning$1(false, '%s is using shady DOM. Using shady DOM with React can ' + 'cause things to break subtly.', getCurrentFiberOwnerNameInDevOrNull() || 'A component');
          didWarnShadyDOM = true;
        }
      } // TODO: Make sure that we check isMounted before firing any of these events.

      var props;

      switch (tag) {
        case 'iframe':
        case 'object':
        case 'embed':
          trapBubbledEvent(TOP_LOAD, domElement);
          props = rawProps;
          break;

        case 'video':
        case 'audio':
          // Create listener for each media event
          for (var i = 0; i < mediaEventTypes.length; i++) {
            trapBubbledEvent(mediaEventTypes[i], domElement);
          }

          props = rawProps;
          break;

        case 'source':
          trapBubbledEvent(TOP_ERROR, domElement);
          props = rawProps;
          break;

        case 'img':
        case 'image':
        case 'link':
          trapBubbledEvent(TOP_ERROR, domElement);
          trapBubbledEvent(TOP_LOAD, domElement);
          props = rawProps;
          break;

        case 'form':
          trapBubbledEvent(TOP_RESET, domElement);
          trapBubbledEvent(TOP_SUBMIT, domElement);
          props = rawProps;
          break;

        case 'details':
          trapBubbledEvent(TOP_TOGGLE, domElement);
          props = rawProps;
          break;

        case 'input':
          initWrapperState(domElement, rawProps);
          props = getHostProps(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;

        case 'option':
          validateProps(domElement, rawProps);
          props = getHostProps$1(domElement, rawProps);
          break;

        case 'select':
          initWrapperState$1(domElement, rawProps);
          props = getHostProps$2(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;

        case 'textarea':
          initWrapperState$2(domElement, rawProps);
          props = getHostProps$3(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;

        default:
          props = rawProps;
      }

      assertValidProps(tag, props);
      setInitialDOMProperties(tag, domElement, rootContainerElement, props, isCustomComponentTag);

      switch (tag) {
        case 'input':
          // TODO: Make sure we check if this is still unmounted or do any clean
          // up necessary since we never stop tracking anymore.
          track(domElement);
          postMountWrapper(domElement, rawProps, false);
          break;

        case 'textarea':
          // TODO: Make sure we check if this is still unmounted or do any clean
          // up necessary since we never stop tracking anymore.
          track(domElement);
          postMountWrapper$3(domElement, rawProps);
          break;

        case 'option':
          postMountWrapper$1(domElement, rawProps);
          break;

        case 'select':
          postMountWrapper$2(domElement, rawProps);
          break;

        default:
          if (typeof props.onClick === 'function') {
            // TODO: This cast may not be sound for SVG, MathML or custom elements.
            trapClickOnNonInteractiveElement(domElement);
          }

          break;
      }
    } // Calculate the diff between the two objects.


    function diffProperties(domElement, tag, lastRawProps, nextRawProps, rootContainerElement) {
      {
        validatePropertiesInDevelopment(tag, nextRawProps);
      }
      var updatePayload = null;
      var lastProps;
      var nextProps;

      switch (tag) {
        case 'input':
          lastProps = getHostProps(domElement, lastRawProps);
          nextProps = getHostProps(domElement, nextRawProps);
          updatePayload = [];
          break;

        case 'option':
          lastProps = getHostProps$1(domElement, lastRawProps);
          nextProps = getHostProps$1(domElement, nextRawProps);
          updatePayload = [];
          break;

        case 'select':
          lastProps = getHostProps$2(domElement, lastRawProps);
          nextProps = getHostProps$2(domElement, nextRawProps);
          updatePayload = [];
          break;

        case 'textarea':
          lastProps = getHostProps$3(domElement, lastRawProps);
          nextProps = getHostProps$3(domElement, nextRawProps);
          updatePayload = [];
          break;

        default:
          lastProps = lastRawProps;
          nextProps = nextRawProps;

          if (typeof lastProps.onClick !== 'function' && typeof nextProps.onClick === 'function') {
            // TODO: This cast may not be sound for SVG, MathML or custom elements.
            trapClickOnNonInteractiveElement(domElement);
          }

          break;
      }

      assertValidProps(tag, nextProps);
      var propKey;
      var styleName;
      var styleUpdates = null;

      for (propKey in lastProps) {
        if (nextProps.hasOwnProperty(propKey) || !lastProps.hasOwnProperty(propKey) || lastProps[propKey] == null) {
          continue;
        }

        if (propKey === STYLE$1) {
          var lastStyle = lastProps[propKey];

          for (styleName in lastStyle) {
            if (lastStyle.hasOwnProperty(styleName)) {
              if (!styleUpdates) {
                styleUpdates = {};
              }

              styleUpdates[styleName] = '';
            }
          }
        } else if (propKey === DANGEROUSLY_SET_INNER_HTML || propKey === CHILDREN) {// Noop. This is handled by the clear text mechanism.
        } else if (enableFlareAPI && propKey === LISTENERS || propKey === SUPPRESS_CONTENT_EDITABLE_WARNING || propKey === SUPPRESS_HYDRATION_WARNING$1) {// Noop
        } else if (propKey === AUTOFOCUS) {// Noop. It doesn't work on updates anyway.
        } else if (registrationNameModules.hasOwnProperty(propKey)) {
          // This is a special case. If any listener updates we need to ensure
          // that the "current" fiber pointer gets updated so we need a commit
          // to update this element.
          if (!updatePayload) {
            updatePayload = [];
          }
        } else {
          // For all other deleted properties we add it to the queue. We use
          // the whitelist in the commit phase instead.
          (updatePayload = updatePayload || []).push(propKey, null);
        }
      }

      for (propKey in nextProps) {
        var nextProp = nextProps[propKey];
        var lastProp = lastProps != null ? lastProps[propKey] : undefined;

        if (!nextProps.hasOwnProperty(propKey) || nextProp === lastProp || nextProp == null && lastProp == null) {
          continue;
        }

        if (propKey === STYLE$1) {
          {
            if (nextProp) {
              // Freeze the next style object so that we can assume it won't be
              // mutated. We have already warned for this in the past.
              Object.freeze(nextProp);
            }
          }

          if (lastProp) {
            // Unset styles on `lastProp` but not on `nextProp`.
            for (styleName in lastProp) {
              if (lastProp.hasOwnProperty(styleName) && (!nextProp || !nextProp.hasOwnProperty(styleName))) {
                if (!styleUpdates) {
                  styleUpdates = {};
                }

                styleUpdates[styleName] = '';
              }
            } // Update styles that changed since `lastProp`.


            for (styleName in nextProp) {
              if (nextProp.hasOwnProperty(styleName) && lastProp[styleName] !== nextProp[styleName]) {
                if (!styleUpdates) {
                  styleUpdates = {};
                }

                styleUpdates[styleName] = nextProp[styleName];
              }
            }
          } else {
            // Relies on `updateStylesByID` not mutating `styleUpdates`.
            if (!styleUpdates) {
              if (!updatePayload) {
                updatePayload = [];
              }

              updatePayload.push(propKey, styleUpdates);
            }

            styleUpdates = nextProp;
          }
        } else if (propKey === DANGEROUSLY_SET_INNER_HTML) {
          var nextHtml = nextProp ? nextProp[HTML] : undefined;
          var lastHtml = lastProp ? lastProp[HTML] : undefined;

          if (nextHtml != null) {
            if (lastHtml !== nextHtml) {
              (updatePayload = updatePayload || []).push(propKey, toStringOrTrustedType(nextHtml));
            }
          } else {// TODO: It might be too late to clear this if we have children
            // inserted already.
          }
        } else if (propKey === CHILDREN) {
          if (lastProp !== nextProp && (typeof nextProp === 'string' || typeof nextProp === 'number')) {
            (updatePayload = updatePayload || []).push(propKey, '' + nextProp);
          }
        } else if (enableFlareAPI && propKey === LISTENERS || propKey === SUPPRESS_CONTENT_EDITABLE_WARNING || propKey === SUPPRESS_HYDRATION_WARNING$1) {// Noop
        } else if (registrationNameModules.hasOwnProperty(propKey)) {
          if (nextProp != null) {
            // We eagerly listen to this even though we haven't committed yet.
            if (true && typeof nextProp !== 'function') {
              warnForInvalidEventListener(propKey, nextProp);
            }

            ensureListeningTo(rootContainerElement, propKey);
          }

          if (!updatePayload && lastProp !== nextProp) {
            // This is a special case. If any listener updates we need to ensure
            // that the "current" props pointer gets updated so we need a commit
            // to update this element.
            updatePayload = [];
          }
        } else {
          // For any other property we always add it to the queue and then we
          // filter it out using the whitelist during the commit.
          (updatePayload = updatePayload || []).push(propKey, nextProp);
        }
      }

      if (styleUpdates) {
        {
          validateShorthandPropertyCollisionInDev(styleUpdates, nextProps[STYLE$1]);
        }
        (updatePayload = updatePayload || []).push(STYLE$1, styleUpdates);
      }

      return updatePayload;
    } // Apply the diff.


    function updateProperties(domElement, updatePayload, tag, lastRawProps, nextRawProps) {
      // Update checked *before* name.
      // In the middle of an update, it is possible to have multiple checked.
      // When a checked radio tries to change name, browser makes another radio's checked false.
      if (tag === 'input' && nextRawProps.type === 'radio' && nextRawProps.name != null) {
        updateChecked(domElement, nextRawProps);
      }

      var wasCustomComponentTag = isCustomComponent(tag, lastRawProps);
      var isCustomComponentTag = isCustomComponent(tag, nextRawProps); // Apply the diff.

      updateDOMProperties(domElement, updatePayload, wasCustomComponentTag, isCustomComponentTag); // TODO: Ensure that an update gets scheduled if any of the special props
      // changed.

      switch (tag) {
        case 'input':
          // Update the wrapper around inputs *after* updating props. This has to
          // happen after `updateDOMProperties`. Otherwise HTML5 input validations
          // raise warnings and prevent the new value from being assigned.
          updateWrapper(domElement, nextRawProps);
          break;

        case 'textarea':
          updateWrapper$1(domElement, nextRawProps);
          break;

        case 'select':
          // <select> value update needs to occur after <option> children
          // reconciliation
          postUpdateWrapper(domElement, nextRawProps);
          break;
      }
    }

    function getPossibleStandardName(propName) {
      {
        var lowerCasedName = propName.toLowerCase();

        if (!possibleStandardNames.hasOwnProperty(lowerCasedName)) {
          return null;
        }

        return possibleStandardNames[lowerCasedName] || null;
      }
      return null;
    }

    function diffHydratedProperties(domElement, tag, rawProps, parentNamespace, rootContainerElement) {
      var isCustomComponentTag;
      var extraAttributeNames;
      {
        suppressHydrationWarning = rawProps[SUPPRESS_HYDRATION_WARNING$1] === true;
        isCustomComponentTag = isCustomComponent(tag, rawProps);
        validatePropertiesInDevelopment(tag, rawProps);

        if (isCustomComponentTag && !didWarnShadyDOM && domElement.shadyRoot) {
          warning$1(false, '%s is using shady DOM. Using shady DOM with React can ' + 'cause things to break subtly.', getCurrentFiberOwnerNameInDevOrNull() || 'A component');
          didWarnShadyDOM = true;
        }
      } // TODO: Make sure that we check isMounted before firing any of these events.

      switch (tag) {
        case 'iframe':
        case 'object':
        case 'embed':
          trapBubbledEvent(TOP_LOAD, domElement);
          break;

        case 'video':
        case 'audio':
          // Create listener for each media event
          for (var i = 0; i < mediaEventTypes.length; i++) {
            trapBubbledEvent(mediaEventTypes[i], domElement);
          }

          break;

        case 'source':
          trapBubbledEvent(TOP_ERROR, domElement);
          break;

        case 'img':
        case 'image':
        case 'link':
          trapBubbledEvent(TOP_ERROR, domElement);
          trapBubbledEvent(TOP_LOAD, domElement);
          break;

        case 'form':
          trapBubbledEvent(TOP_RESET, domElement);
          trapBubbledEvent(TOP_SUBMIT, domElement);
          break;

        case 'details':
          trapBubbledEvent(TOP_TOGGLE, domElement);
          break;

        case 'input':
          initWrapperState(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;

        case 'option':
          validateProps(domElement, rawProps);
          break;

        case 'select':
          initWrapperState$1(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;

        case 'textarea':
          initWrapperState$2(domElement, rawProps);
          trapBubbledEvent(TOP_INVALID, domElement); // For controlled components we always need to ensure we're listening
          // to onChange. Even if there is no listener.

          ensureListeningTo(rootContainerElement, 'onChange');
          break;
      }

      assertValidProps(tag, rawProps);
      {
        extraAttributeNames = new Set();
        var attributes = domElement.attributes;

        for (var _i = 0; _i < attributes.length; _i++) {
          var name = attributes[_i].name.toLowerCase();

          switch (name) {
            // Built-in SSR attribute is whitelisted
            case 'data-reactroot':
              break;
            // Controlled attributes are not validated
            // TODO: Only ignore them on controlled tags.

            case 'value':
              break;

            case 'checked':
              break;

            case 'selected':
              break;

            default:
              // Intentionally use the original name.
              // See discussion in https://github.com/facebook/react/pull/10676.
              extraAttributeNames.add(attributes[_i].name);
          }
        }
      }
      var updatePayload = null;

      for (var propKey in rawProps) {
        if (!rawProps.hasOwnProperty(propKey)) {
          continue;
        }

        var nextProp = rawProps[propKey];

        if (propKey === CHILDREN) {
          // For text content children we compare against textContent. This
          // might match additional HTML that is hidden when we read it using
          // textContent. E.g. "foo" will match "f<span>oo</span>" but that still
          // satisfies our requirement. Our requirement is not to produce perfect
          // HTML and attributes. Ideally we should preserve structure but it's
          // ok not to if the visible content is still enough to indicate what
          // even listeners these nodes might be wired up to.
          // TODO: Warn if there is more than a single textNode as a child.
          // TODO: Should we use domElement.firstChild.nodeValue to compare?
          if (typeof nextProp === 'string') {
            if (domElement.textContent !== nextProp) {
              if (true && !suppressHydrationWarning) {
                warnForTextDifference(domElement.textContent, nextProp);
              }

              updatePayload = [CHILDREN, nextProp];
            }
          } else if (typeof nextProp === 'number') {
            if (domElement.textContent !== '' + nextProp) {
              if (true && !suppressHydrationWarning) {
                warnForTextDifference(domElement.textContent, nextProp);
              }

              updatePayload = [CHILDREN, '' + nextProp];
            }
          }
        } else if (registrationNameModules.hasOwnProperty(propKey)) {
          if (nextProp != null) {
            if (true && typeof nextProp !== 'function') {
              warnForInvalidEventListener(propKey, nextProp);
            }

            ensureListeningTo(rootContainerElement, propKey);
          }
        } else if (true && // Convince Flow we've calculated it (it's DEV-only in this method.)
        typeof isCustomComponentTag === 'boolean') {
          // Validate that the properties correspond to their expected values.
          var serverValue = void 0;
          var propertyInfo = getPropertyInfo(propKey);

          if (suppressHydrationWarning) {// Don't bother comparing. We're ignoring all these warnings.
          } else if (enableFlareAPI && propKey === LISTENERS || propKey === SUPPRESS_CONTENT_EDITABLE_WARNING || propKey === SUPPRESS_HYDRATION_WARNING$1 || // Controlled attributes are not validated
          // TODO: Only ignore them on controlled tags.
          propKey === 'value' || propKey === 'checked' || propKey === 'selected') {// Noop
          } else if (propKey === DANGEROUSLY_SET_INNER_HTML) {
            var serverHTML = domElement.innerHTML;
            var nextHtml = nextProp ? nextProp[HTML] : undefined;
            var expectedHTML = normalizeHTML(domElement, nextHtml != null ? nextHtml : '');

            if (expectedHTML !== serverHTML) {
              warnForPropDifference(propKey, serverHTML, expectedHTML);
            }
          } else if (propKey === STYLE$1) {
            // $FlowFixMe - Should be inferred as not undefined.
            extraAttributeNames.delete(propKey);

            if (canDiffStyleForHydrationWarning) {
              var expectedStyle = createDangerousStringForStyles(nextProp);
              serverValue = domElement.getAttribute('style');

              if (expectedStyle !== serverValue) {
                warnForPropDifference(propKey, serverValue, expectedStyle);
              }
            }
          } else if (isCustomComponentTag) {
            // $FlowFixMe - Should be inferred as not undefined.
            extraAttributeNames.delete(propKey.toLowerCase());
            serverValue = getValueForAttribute(domElement, propKey, nextProp);

            if (nextProp !== serverValue) {
              warnForPropDifference(propKey, serverValue, nextProp);
            }
          } else if (!shouldIgnoreAttribute(propKey, propertyInfo, isCustomComponentTag) && !shouldRemoveAttribute(propKey, nextProp, propertyInfo, isCustomComponentTag)) {
            var isMismatchDueToBadCasing = false;

            if (propertyInfo !== null) {
              // $FlowFixMe - Should be inferred as not undefined.
              extraAttributeNames.delete(propertyInfo.attributeName);
              serverValue = getValueForProperty(domElement, propKey, nextProp, propertyInfo);
            } else {
              var ownNamespace = parentNamespace;

              if (ownNamespace === HTML_NAMESPACE) {
                ownNamespace = getIntrinsicNamespace(tag);
              }

              if (ownNamespace === HTML_NAMESPACE) {
                // $FlowFixMe - Should be inferred as not undefined.
                extraAttributeNames.delete(propKey.toLowerCase());
              } else {
                var standardName = getPossibleStandardName(propKey);

                if (standardName !== null && standardName !== propKey) {
                  // If an SVG prop is supplied with bad casing, it will
                  // be successfully parsed from HTML, but will produce a mismatch
                  // (and would be incorrectly rendered on the client).
                  // However, we already warn about bad casing elsewhere.
                  // So we'll skip the misleading extra mismatch warning in this case.
                  isMismatchDueToBadCasing = true; // $FlowFixMe - Should be inferred as not undefined.

                  extraAttributeNames.delete(standardName);
                } // $FlowFixMe - Should be inferred as not undefined.


                extraAttributeNames.delete(propKey);
              }

              serverValue = getValueForAttribute(domElement, propKey, nextProp);
            }

            if (nextProp !== serverValue && !isMismatchDueToBadCasing) {
              warnForPropDifference(propKey, serverValue, nextProp);
            }
          }
        }
      }

      {
        // $FlowFixMe - Should be inferred as not undefined.
        if (extraAttributeNames.size > 0 && !suppressHydrationWarning) {
          // $FlowFixMe - Should be inferred as not undefined.
          warnForExtraAttributes(extraAttributeNames);
        }
      }

      switch (tag) {
        case 'input':
          // TODO: Make sure we check if this is still unmounted or do any clean
          // up necessary since we never stop tracking anymore.
          track(domElement);
          postMountWrapper(domElement, rawProps, true);
          break;

        case 'textarea':
          // TODO: Make sure we check if this is still unmounted or do any clean
          // up necessary since we never stop tracking anymore.
          track(domElement);
          postMountWrapper$3(domElement, rawProps);
          break;

        case 'select':
        case 'option':
          // For input and textarea we current always set the value property at
          // post mount to force it to diverge from attributes. However, for
          // option and select we don't quite do the same thing and select
          // is not resilient to the DOM state changing so we don't do that here.
          // TODO: Consider not doing this for input and textarea.
          break;

        default:
          if (typeof rawProps.onClick === 'function') {
            // TODO: This cast may not be sound for SVG, MathML or custom elements.
            trapClickOnNonInteractiveElement(domElement);
          }

          break;
      }

      return updatePayload;
    }

    function diffHydratedText(textNode, text) {
      var isDifferent = textNode.nodeValue !== text;
      return isDifferent;
    }

    function warnForUnmatchedText(textNode, text) {
      {
        warnForTextDifference(textNode.nodeValue, text);
      }
    }

    function warnForDeletedHydratableElement(parentNode, child) {
      {
        if (didWarnInvalidHydration) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Did not expect server HTML to contain a <%s> in <%s>.', child.nodeName.toLowerCase(), parentNode.nodeName.toLowerCase());
      }
    }

    function warnForDeletedHydratableText(parentNode, child) {
      {
        if (didWarnInvalidHydration) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Did not expect server HTML to contain the text node "%s" in <%s>.', child.nodeValue, parentNode.nodeName.toLowerCase());
      }
    }

    function warnForInsertedHydratedElement(parentNode, tag, props) {
      {
        if (didWarnInvalidHydration) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Expected server HTML to contain a matching <%s> in <%s>.', tag, parentNode.nodeName.toLowerCase());
      }
    }

    function warnForInsertedHydratedText(parentNode, text) {
      {
        if (text === '') {
          // We expect to insert empty text nodes since they're not represented in
          // the HTML.
          // TODO: Remove this special case if we can just avoid inserting empty
          // text nodes.
          return;
        }

        if (didWarnInvalidHydration) {
          return;
        }

        didWarnInvalidHydration = true;
        warningWithoutStack$1(false, 'Expected server HTML to contain a matching text node for "%s" in <%s>.', text, parentNode.nodeName.toLowerCase());
      }
    }

    function restoreControlledState$$1(domElement, tag, props) {
      switch (tag) {
        case 'input':
          restoreControlledState$1(domElement, props);
          return;

        case 'textarea':
          restoreControlledState$3(domElement, props);
          return;

        case 'select':
          restoreControlledState$2(domElement, props);
          return;
      }
    }

    function listenToEventResponderEventTypes(eventTypes, element) {
      if (enableFlareAPI) {
        // Get the listening Set for this element. We use this to track
        // what events we're listening to.
        var listeningSet = getListeningSetForElement(element); // Go through each target event type of the event responder

        for (var i = 0, length = eventTypes.length; i < length; ++i) {
          var eventType = eventTypes[i];
          var isPassive = !endsWith(eventType, '_active');
          var eventKey = isPassive ? eventType + '_passive' : eventType;
          var targetEventType = isPassive ? eventType : eventType.substring(0, eventType.length - 7);

          if (!listeningSet.has(eventKey)) {
            trapEventForResponderEventSystem(element, targetEventType, isPassive);
            listeningSet.add(eventKey);
          }
        }
      }
    } // We can remove this once the event API is stable and out of a flag


    if (enableFlareAPI) {
      setListenToResponderEventTypes(listenToEventResponderEventTypes);
    }

    function getActiveElement(doc) {
      doc = doc || (typeof document !== 'undefined' ? document : undefined);

      if (typeof doc === 'undefined') {
        return null;
      }

      try {
        return doc.activeElement || doc.body;
      } catch (e) {
        return doc.body;
      }
    }
    /**
     * Given any node return the first leaf node without children.
     *
     * @param {DOMElement|DOMTextNode} node
     * @return {DOMElement|DOMTextNode}
     */


    function getLeafNode(node) {
      while (node && node.firstChild) {
        node = node.firstChild;
      }

      return node;
    }
    /**
     * Get the next sibling within a container. This will walk up the
     * DOM if a node's siblings have been exhausted.
     *
     * @param {DOMElement|DOMTextNode} node
     * @return {?DOMElement|DOMTextNode}
     */


    function getSiblingNode(node) {
      while (node) {
        if (node.nextSibling) {
          return node.nextSibling;
        }

        node = node.parentNode;
      }
    }
    /**
     * Get object describing the nodes which contain characters at offset.
     *
     * @param {DOMElement|DOMTextNode} root
     * @param {number} offset
     * @return {?object}
     */


    function getNodeForCharacterOffset(root, offset) {
      var node = getLeafNode(root);
      var nodeStart = 0;
      var nodeEnd = 0;

      while (node) {
        if (node.nodeType === TEXT_NODE) {
          nodeEnd = nodeStart + node.textContent.length;

          if (nodeStart <= offset && nodeEnd >= offset) {
            return {
              node: node,
              offset: offset - nodeStart
            };
          }

          nodeStart = nodeEnd;
        }

        node = getLeafNode(getSiblingNode(node));
      }
    }
    /**
     * @param {DOMElement} outerNode
     * @return {?object}
     */


    function getOffsets(outerNode) {
      var ownerDocument = outerNode.ownerDocument;
      var win = ownerDocument && ownerDocument.defaultView || window;
      var selection = win.getSelection && win.getSelection();

      if (!selection || selection.rangeCount === 0) {
        return null;
      }

      var anchorNode = selection.anchorNode,
          anchorOffset = selection.anchorOffset,
          focusNode = selection.focusNode,
          focusOffset = selection.focusOffset; // In Firefox, anchorNode and focusNode can be "anonymous divs", e.g. the
      // up/down buttons on an <input type="number">. Anonymous divs do not seem to
      // expose properties, triggering a "Permission denied error" if any of its
      // properties are accessed. The only seemingly possible way to avoid erroring
      // is to access a property that typically works for non-anonymous divs and
      // catch any error that may otherwise arise. See
      // https://bugzilla.mozilla.org/show_bug.cgi?id=208427

      try {
        /* eslint-disable no-unused-expressions */
        anchorNode.nodeType;
        focusNode.nodeType;
        /* eslint-enable no-unused-expressions */
      } catch (e) {
        return null;
      }

      return getModernOffsetsFromPoints(outerNode, anchorNode, anchorOffset, focusNode, focusOffset);
    }
    /**
     * Returns {start, end} where `start` is the character/codepoint index of
     * (anchorNode, anchorOffset) within the textContent of `outerNode`, and
     * `end` is the index of (focusNode, focusOffset).
     *
     * Returns null if you pass in garbage input but we should probably just crash.
     *
     * Exported only for testing.
     */


    function getModernOffsetsFromPoints(outerNode, anchorNode, anchorOffset, focusNode, focusOffset) {
      var length = 0;
      var start = -1;
      var end = -1;
      var indexWithinAnchor = 0;
      var indexWithinFocus = 0;
      var node = outerNode;
      var parentNode = null;

      outer: while (true) {
        var next = null;

        while (true) {
          if (node === anchorNode && (anchorOffset === 0 || node.nodeType === TEXT_NODE)) {
            start = length + anchorOffset;
          }

          if (node === focusNode && (focusOffset === 0 || node.nodeType === TEXT_NODE)) {
            end = length + focusOffset;
          }

          if (node.nodeType === TEXT_NODE) {
            length += node.nodeValue.length;
          }

          if ((next = node.firstChild) === null) {
            break;
          } // Moving from `node` to its first child `next`.


          parentNode = node;
          node = next;
        }

        while (true) {
          if (node === outerNode) {
            // If `outerNode` has children, this is always the second time visiting
            // it. If it has no children, this is still the first loop, and the only
            // valid selection is anchorNode and focusNode both equal to this node
            // and both offsets 0, in which case we will have handled above.
            break outer;
          }

          if (parentNode === anchorNode && ++indexWithinAnchor === anchorOffset) {
            start = length;
          }

          if (parentNode === focusNode && ++indexWithinFocus === focusOffset) {
            end = length;
          }

          if ((next = node.nextSibling) !== null) {
            break;
          }

          node = parentNode;
          parentNode = node.parentNode;
        } // Moving from `node` to its next sibling `next`.


        node = next;
      }

      if (start === -1 || end === -1) {
        // This should never happen. (Would happen if the anchor/focus nodes aren't
        // actually inside the passed-in node.)
        return null;
      }

      return {
        start: start,
        end: end
      };
    }
    /**
     * In modern non-IE browsers, we can support both forward and backward
     * selections.
     *
     * Note: IE10+ supports the Selection object, but it does not support
     * the `extend` method, which means that even in modern IE, it's not possible
     * to programmatically create a backward selection. Thus, for all IE
     * versions, we use the old IE API to create our selections.
     *
     * @param {DOMElement|DOMTextNode} node
     * @param {object} offsets
     */


    function setOffsets(node, offsets) {
      var doc = node.ownerDocument || document;
      var win = doc && doc.defaultView || window; // Edge fails with "Object expected" in some scenarios.
      // (For instance: TinyMCE editor used in a list component that supports pasting to add more,
      // fails when pasting 100+ items)

      if (!win.getSelection) {
        return;
      }

      var selection = win.getSelection();
      var length = node.textContent.length;
      var start = Math.min(offsets.start, length);
      var end = offsets.end === undefined ? start : Math.min(offsets.end, length); // IE 11 uses modern selection, but doesn't support the extend method.
      // Flip backward selections, so we can set with a single range.

      if (!selection.extend && start > end) {
        var temp = end;
        end = start;
        start = temp;
      }

      var startMarker = getNodeForCharacterOffset(node, start);
      var endMarker = getNodeForCharacterOffset(node, end);

      if (startMarker && endMarker) {
        if (selection.rangeCount === 1 && selection.anchorNode === startMarker.node && selection.anchorOffset === startMarker.offset && selection.focusNode === endMarker.node && selection.focusOffset === endMarker.offset) {
          return;
        }

        var range = doc.createRange();
        range.setStart(startMarker.node, startMarker.offset);
        selection.removeAllRanges();

        if (start > end) {
          selection.addRange(range);
          selection.extend(endMarker.node, endMarker.offset);
        } else {
          range.setEnd(endMarker.node, endMarker.offset);
          selection.addRange(range);
        }
      }
    }

    function isTextNode(node) {
      return node && node.nodeType === TEXT_NODE;
    }

    function containsNode(outerNode, innerNode) {
      if (!outerNode || !innerNode) {
        return false;
      } else if (outerNode === innerNode) {
        return true;
      } else if (isTextNode(outerNode)) {
        return false;
      } else if (isTextNode(innerNode)) {
        return containsNode(outerNode, innerNode.parentNode);
      } else if ('contains' in outerNode) {
        return outerNode.contains(innerNode);
      } else if (outerNode.compareDocumentPosition) {
        return !!(outerNode.compareDocumentPosition(innerNode) & 16);
      } else {
        return false;
      }
    }

    function isInDocument(node) {
      return node && node.ownerDocument && containsNode(node.ownerDocument.documentElement, node);
    }

    function isSameOriginFrame(iframe) {
      try {
        // Accessing the contentDocument of a HTMLIframeElement can cause the browser
        // to throw, e.g. if it has a cross-origin src attribute.
        // Safari will show an error in the console when the access results in "Blocked a frame with origin". e.g:
        // iframe.contentDocument.defaultView;
        // A safety way is to access one of the cross origin properties: Window or Location
        // Which might result in "SecurityError" DOM Exception and it is compatible to Safari.
        // https://html.spec.whatwg.org/multipage/browsers.html#integration-with-idl
        return typeof iframe.contentWindow.location.href === 'string';
      } catch (err) {
        return false;
      }
    }

    function getActiveElementDeep() {
      var win = window;
      var element = getActiveElement();

      while (element instanceof win.HTMLIFrameElement) {
        if (isSameOriginFrame(element)) {
          win = element.contentWindow;
        } else {
          return element;
        }

        element = getActiveElement(win.document);
      }

      return element;
    }
    /**
     * @ReactInputSelection: React input selection module. Based on Selection.js,
     * but modified to be suitable for react and has a couple of bug fixes (doesn't
     * assume buttons have range selections allowed).
     * Input selection module for React.
     */

    /**
     * @hasSelectionCapabilities: we get the element types that support selection
     * from https://html.spec.whatwg.org/#do-not-apply, looking at `selectionStart`
     * and `selectionEnd` rows.
     */


    function hasSelectionCapabilities(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();
      return nodeName && (nodeName === 'input' && (elem.type === 'text' || elem.type === 'search' || elem.type === 'tel' || elem.type === 'url' || elem.type === 'password') || nodeName === 'textarea' || elem.contentEditable === 'true');
    }

    function getSelectionInformation() {
      var focusedElem = getActiveElementDeep();
      return {
        focusedElem: focusedElem,
        selectionRange: hasSelectionCapabilities(focusedElem) ? getSelection(focusedElem) : null
      };
    }
    /**
     * @restoreSelection: If any selection information was potentially lost,
     * restore it. This is useful when performing operations that could remove dom
     * nodes and place them back in, resulting in focus being lost.
     */


    function restoreSelection(priorSelectionInformation) {
      var curFocusedElem = getActiveElementDeep();
      var priorFocusedElem = priorSelectionInformation.focusedElem;
      var priorSelectionRange = priorSelectionInformation.selectionRange;

      if (curFocusedElem !== priorFocusedElem && isInDocument(priorFocusedElem)) {
        if (priorSelectionRange !== null && hasSelectionCapabilities(priorFocusedElem)) {
          setSelection(priorFocusedElem, priorSelectionRange);
        } // Focusing a node can change the scroll position, which is undesirable


        var ancestors = [];
        var ancestor = priorFocusedElem;

        while (ancestor = ancestor.parentNode) {
          if (ancestor.nodeType === ELEMENT_NODE) {
            ancestors.push({
              element: ancestor,
              left: ancestor.scrollLeft,
              top: ancestor.scrollTop
            });
          }
        }

        if (typeof priorFocusedElem.focus === 'function') {
          priorFocusedElem.focus();
        }

        for (var i = 0; i < ancestors.length; i++) {
          var info = ancestors[i];
          info.element.scrollLeft = info.left;
          info.element.scrollTop = info.top;
        }
      }
    }
    /**
     * @getSelection: Gets the selection bounds of a focused textarea, input or
     * contentEditable node.
     * -@input: Look up selection bounds of this input
     * -@return {start: selectionStart, end: selectionEnd}
     */


    function getSelection(input) {
      var selection;

      if ('selectionStart' in input) {
        // Modern browser with input or textarea.
        selection = {
          start: input.selectionStart,
          end: input.selectionEnd
        };
      } else {
        // Content editable or old IE textarea.
        selection = getOffsets(input);
      }

      return selection || {
        start: 0,
        end: 0
      };
    }
    /**
     * @setSelection: Sets the selection bounds of a textarea or input and focuses
     * the input.
     * -@input     Set selection bounds of this input or textarea
     * -@offsets   Object of same form that is returned from get*
     */


    function setSelection(input, offsets) {
      var start = offsets.start,
          end = offsets.end;

      if (end === undefined) {
        end = start;
      }

      if ('selectionStart' in input) {
        input.selectionStart = start;
        input.selectionEnd = Math.min(end, input.value.length);
      } else {
        setOffsets(input, offsets);
      }
    }

    var validateDOMNesting = function () {};

    var updatedAncestorInfo = function () {};

    {
      // This validation code was written based on the HTML5 parsing spec:
      // https://html.spec.whatwg.org/multipage/syntax.html#has-an-element-in-scope
      //
      // Note: this does not catch all invalid nesting, nor does it try to (as it's
      // not clear what practical benefit doing so provides); instead, we warn only
      // for cases where the parser will give a parse tree differing from what React
      // intended. For example, <b><div></div></b> is invalid but we don't warn
      // because it still parses correctly; we do warn for other cases like nested
      // <p> tags where the beginning of the second element implicitly closes the
      // first, causing a confusing mess.
      // https://html.spec.whatwg.org/multipage/syntax.html#special
      var specialTags = ['address', 'applet', 'area', 'article', 'aside', 'base', 'basefont', 'bgsound', 'blockquote', 'body', 'br', 'button', 'caption', 'center', 'col', 'colgroup', 'dd', 'details', 'dir', 'div', 'dl', 'dt', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'frame', 'frameset', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'iframe', 'img', 'input', 'isindex', 'li', 'link', 'listing', 'main', 'marquee', 'menu', 'menuitem', 'meta', 'nav', 'noembed', 'noframes', 'noscript', 'object', 'ol', 'p', 'param', 'plaintext', 'pre', 'script', 'section', 'select', 'source', 'style', 'summary', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'title', 'tr', 'track', 'ul', 'wbr', 'xmp']; // https://html.spec.whatwg.org/multipage/syntax.html#has-an-element-in-scope

      var inScopeTags = ['applet', 'caption', 'html', 'table', 'td', 'th', 'marquee', 'object', 'template', // https://html.spec.whatwg.org/multipage/syntax.html#html-integration-point
      // TODO: Distinguish by namespace here -- for <title>, including it here
      // errs on the side of fewer warnings
      'foreignObject', 'desc', 'title']; // https://html.spec.whatwg.org/multipage/syntax.html#has-an-element-in-button-scope

      var buttonScopeTags = inScopeTags.concat(['button']); // https://html.spec.whatwg.org/multipage/syntax.html#generate-implied-end-tags

      var impliedEndTags = ['dd', 'dt', 'li', 'option', 'optgroup', 'p', 'rp', 'rt'];
      var emptyAncestorInfo = {
        current: null,
        formTag: null,
        aTagInScope: null,
        buttonTagInScope: null,
        nobrTagInScope: null,
        pTagInButtonScope: null,
        listItemTagAutoclosing: null,
        dlItemTagAutoclosing: null
      };

      updatedAncestorInfo = function (oldInfo, tag) {
        var ancestorInfo = _assign({}, oldInfo || emptyAncestorInfo);

        var info = {
          tag: tag
        };

        if (inScopeTags.indexOf(tag) !== -1) {
          ancestorInfo.aTagInScope = null;
          ancestorInfo.buttonTagInScope = null;
          ancestorInfo.nobrTagInScope = null;
        }

        if (buttonScopeTags.indexOf(tag) !== -1) {
          ancestorInfo.pTagInButtonScope = null;
        } // See rules for 'li', 'dd', 'dt' start tags in
        // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-inbody


        if (specialTags.indexOf(tag) !== -1 && tag !== 'address' && tag !== 'div' && tag !== 'p') {
          ancestorInfo.listItemTagAutoclosing = null;
          ancestorInfo.dlItemTagAutoclosing = null;
        }

        ancestorInfo.current = info;

        if (tag === 'form') {
          ancestorInfo.formTag = info;
        }

        if (tag === 'a') {
          ancestorInfo.aTagInScope = info;
        }

        if (tag === 'button') {
          ancestorInfo.buttonTagInScope = info;
        }

        if (tag === 'nobr') {
          ancestorInfo.nobrTagInScope = info;
        }

        if (tag === 'p') {
          ancestorInfo.pTagInButtonScope = info;
        }

        if (tag === 'li') {
          ancestorInfo.listItemTagAutoclosing = info;
        }

        if (tag === 'dd' || tag === 'dt') {
          ancestorInfo.dlItemTagAutoclosing = info;
        }

        return ancestorInfo;
      };
      /**
       * Returns whether
       */


      var isTagValidWithParent = function (tag, parentTag) {
        // First, let's check if we're in an unusual parsing mode...
        switch (parentTag) {
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-inselect
          case 'select':
            return tag === 'option' || tag === 'optgroup' || tag === '#text';

          case 'optgroup':
            return tag === 'option' || tag === '#text';
          // Strictly speaking, seeing an <option> doesn't mean we're in a <select>
          // but

          case 'option':
            return tag === '#text';
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-intd
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-incaption
          // No special behavior since these rules fall back to "in body" mode for
          // all except special table nodes which cause bad parsing behavior anyway.
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-intr

          case 'tr':
            return tag === 'th' || tag === 'td' || tag === 'style' || tag === 'script' || tag === 'template';
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-intbody

          case 'tbody':
          case 'thead':
          case 'tfoot':
            return tag === 'tr' || tag === 'style' || tag === 'script' || tag === 'template';
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-incolgroup

          case 'colgroup':
            return tag === 'col' || tag === 'template';
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-intable

          case 'table':
            return tag === 'caption' || tag === 'colgroup' || tag === 'tbody' || tag === 'tfoot' || tag === 'thead' || tag === 'style' || tag === 'script' || tag === 'template';
          // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-inhead

          case 'head':
            return tag === 'base' || tag === 'basefont' || tag === 'bgsound' || tag === 'link' || tag === 'meta' || tag === 'title' || tag === 'noscript' || tag === 'noframes' || tag === 'style' || tag === 'script' || tag === 'template';
          // https://html.spec.whatwg.org/multipage/semantics.html#the-html-element

          case 'html':
            return tag === 'head' || tag === 'body' || tag === 'frameset';

          case 'frameset':
            return tag === 'frame';

          case '#document':
            return tag === 'html';
        } // Probably in the "in body" parsing mode, so we outlaw only tag combos
        // where the parsing rules cause implicit opens or closes to be added.
        // https://html.spec.whatwg.org/multipage/syntax.html#parsing-main-inbody


        switch (tag) {
          case 'h1':
          case 'h2':
          case 'h3':
          case 'h4':
          case 'h5':
          case 'h6':
            return parentTag !== 'h1' && parentTag !== 'h2' && parentTag !== 'h3' && parentTag !== 'h4' && parentTag !== 'h5' && parentTag !== 'h6';

          case 'rp':
          case 'rt':
            return impliedEndTags.indexOf(parentTag) === -1;

          case 'body':
          case 'caption':
          case 'col':
          case 'colgroup':
          case 'frameset':
          case 'frame':
          case 'head':
          case 'html':
          case 'tbody':
          case 'td':
          case 'tfoot':
          case 'th':
          case 'thead':
          case 'tr':
            // These tags are only valid with a few parents that have special child
            // parsing rules -- if we're down here, then none of those matched and
            // so we allow it only if we don't know what the parent is, as all other
            // cases are invalid.
            return parentTag == null;
        }

        return true;
      };
      /**
       * Returns whether
       */


      var findInvalidAncestorForTag = function (tag, ancestorInfo) {
        switch (tag) {
          case 'address':
          case 'article':
          case 'aside':
          case 'blockquote':
          case 'center':
          case 'details':
          case 'dialog':
          case 'dir':
          case 'div':
          case 'dl':
          case 'fieldset':
          case 'figcaption':
          case 'figure':
          case 'footer':
          case 'header':
          case 'hgroup':
          case 'main':
          case 'menu':
          case 'nav':
          case 'ol':
          case 'p':
          case 'section':
          case 'summary':
          case 'ul':
          case 'pre':
          case 'listing':
          case 'table':
          case 'hr':
          case 'xmp':
          case 'h1':
          case 'h2':
          case 'h3':
          case 'h4':
          case 'h5':
          case 'h6':
            return ancestorInfo.pTagInButtonScope;

          case 'form':
            return ancestorInfo.formTag || ancestorInfo.pTagInButtonScope;

          case 'li':
            return ancestorInfo.listItemTagAutoclosing;

          case 'dd':
          case 'dt':
            return ancestorInfo.dlItemTagAutoclosing;

          case 'button':
            return ancestorInfo.buttonTagInScope;

          case 'a':
            // Spec says something about storing a list of markers, but it sounds
            // equivalent to this check.
            return ancestorInfo.aTagInScope;

          case 'nobr':
            return ancestorInfo.nobrTagInScope;
        }

        return null;
      };

      var didWarn$1 = {};

      validateDOMNesting = function (childTag, childText, ancestorInfo) {
        ancestorInfo = ancestorInfo || emptyAncestorInfo;
        var parentInfo = ancestorInfo.current;
        var parentTag = parentInfo && parentInfo.tag;

        if (childText != null) {
          !(childTag == null) ? warningWithoutStack$1(false, 'validateDOMNesting: when childText is passed, childTag should be null') : void 0;
          childTag = '#text';
        }

        var invalidParent = isTagValidWithParent(childTag, parentTag) ? null : parentInfo;
        var invalidAncestor = invalidParent ? null : findInvalidAncestorForTag(childTag, ancestorInfo);
        var invalidParentOrAncestor = invalidParent || invalidAncestor;

        if (!invalidParentOrAncestor) {
          return;
        }

        var ancestorTag = invalidParentOrAncestor.tag;
        var addendum = getCurrentFiberStackInDev();
        var warnKey = !!invalidParent + '|' + childTag + '|' + ancestorTag + '|' + addendum;

        if (didWarn$1[warnKey]) {
          return;
        }

        didWarn$1[warnKey] = true;
        var tagDisplayName = childTag;
        var whitespaceInfo = '';

        if (childTag === '#text') {
          if (/\S/.test(childText)) {
            tagDisplayName = 'Text nodes';
          } else {
            tagDisplayName = 'Whitespace text nodes';
            whitespaceInfo = " Make sure you don't have any extra whitespace between tags on " + 'each line of your source code.';
          }
        } else {
          tagDisplayName = '<' + childTag + '>';
        }

        if (invalidParent) {
          var info = '';

          if (ancestorTag === 'table' && childTag === 'tr') {
            info += ' Add a <tbody>, <thead> or <tfoot> to your code to match the DOM tree generated by ' + 'the browser.';
          }

          warningWithoutStack$1(false, 'validateDOMNesting(...): %s cannot appear as a child of <%s>.%s%s%s', tagDisplayName, ancestorTag, whitespaceInfo, info, addendum);
        } else {
          warningWithoutStack$1(false, 'validateDOMNesting(...): %s cannot appear as a descendant of ' + '<%s>.%s', tagDisplayName, ancestorTag, addendum);
        }
      };
    } // can re-export everything from this module.

    function shim() {
      {
        {
          throw Error("The current renderer does not support persistence. This error is likely caused by a bug in React. Please file an issue.");
        }
      }
    } // Persistence (when unsupported)


    var supportsPersistence = false;
    var cloneInstance = shim;
    var cloneFundamentalInstance = shim;
    var createContainerChildSet = shim;
    var appendChildToContainerChildSet = shim;
    var finalizeContainerChildren = shim;
    var replaceContainerChildren = shim;
    var cloneHiddenInstance = shim;
    var cloneHiddenTextInstance = shim;
    var SUPPRESS_HYDRATION_WARNING;
    {
      SUPPRESS_HYDRATION_WARNING = 'suppressHydrationWarning';
    }
    var SUSPENSE_START_DATA = '$';
    var SUSPENSE_END_DATA = '/$';
    var SUSPENSE_PENDING_START_DATA = '$?';
    var SUSPENSE_FALLBACK_START_DATA = '$!';
    var STYLE = 'style';
    var eventsEnabled = null;
    var selectionInformation = null;

    function shouldAutoFocusHostComponent(type, props) {
      switch (type) {
        case 'button':
        case 'input':
        case 'select':
        case 'textarea':
          return !!props.autoFocus;
      }

      return false;
    }

    function getRootHostContext(rootContainerInstance) {
      var type;
      var namespace;
      var nodeType = rootContainerInstance.nodeType;

      switch (nodeType) {
        case DOCUMENT_NODE:
        case DOCUMENT_FRAGMENT_NODE:
          {
            type = nodeType === DOCUMENT_NODE ? '#document' : '#fragment';
            var root = rootContainerInstance.documentElement;
            namespace = root ? root.namespaceURI : getChildNamespace(null, '');
            break;
          }

        default:
          {
            var container = nodeType === COMMENT_NODE ? rootContainerInstance.parentNode : rootContainerInstance;
            var ownNamespace = container.namespaceURI || null;
            type = container.tagName;
            namespace = getChildNamespace(ownNamespace, type);
            break;
          }
      }

      {
        var validatedTag = type.toLowerCase();
        var ancestorInfo = updatedAncestorInfo(null, validatedTag);
        return {
          namespace: namespace,
          ancestorInfo: ancestorInfo
        };
      }
      return namespace;
    }

    function getChildHostContext(parentHostContext, type, rootContainerInstance) {
      {
        var parentHostContextDev = parentHostContext;
        var namespace = getChildNamespace(parentHostContextDev.namespace, type);
        var ancestorInfo = updatedAncestorInfo(parentHostContextDev.ancestorInfo, type);
        return {
          namespace: namespace,
          ancestorInfo: ancestorInfo
        };
      }
      var parentNamespace = parentHostContext;
      return getChildNamespace(parentNamespace, type);
    }

    function getPublicInstance(instance) {
      return instance;
    }

    function prepareForCommit(containerInfo) {
      eventsEnabled = isEnabled();
      selectionInformation = getSelectionInformation();
      setEnabled(false);
    }

    function resetAfterCommit(containerInfo) {
      restoreSelection(selectionInformation);
      selectionInformation = null;
      setEnabled(eventsEnabled);
      eventsEnabled = null;
    }

    function createInstance(type, props, rootContainerInstance, hostContext, internalInstanceHandle) {
      var parentNamespace;
      {
        // TODO: take namespace into account when validating.
        var hostContextDev = hostContext;
        validateDOMNesting(type, null, hostContextDev.ancestorInfo);

        if (typeof props.children === 'string' || typeof props.children === 'number') {
          var string = '' + props.children;
          var ownAncestorInfo = updatedAncestorInfo(hostContextDev.ancestorInfo, type);
          validateDOMNesting(null, string, ownAncestorInfo);
        }

        parentNamespace = hostContextDev.namespace;
      }
      var domElement = createElement(type, props, rootContainerInstance, parentNamespace);
      precacheFiberNode(internalInstanceHandle, domElement);
      updateFiberProps(domElement, props);
      return domElement;
    }

    function appendInitialChild(parentInstance, child) {
      parentInstance.appendChild(child);
    }

    function finalizeInitialChildren(domElement, type, props, rootContainerInstance, hostContext) {
      setInitialProperties(domElement, type, props, rootContainerInstance);
      return shouldAutoFocusHostComponent(type, props);
    }

    function prepareUpdate(domElement, type, oldProps, newProps, rootContainerInstance, hostContext) {
      {
        var hostContextDev = hostContext;

        if (typeof newProps.children !== typeof oldProps.children && (typeof newProps.children === 'string' || typeof newProps.children === 'number')) {
          var string = '' + newProps.children;
          var ownAncestorInfo = updatedAncestorInfo(hostContextDev.ancestorInfo, type);
          validateDOMNesting(null, string, ownAncestorInfo);
        }
      }
      return diffProperties(domElement, type, oldProps, newProps, rootContainerInstance);
    }

    function shouldSetTextContent(type, props) {
      return type === 'textarea' || type === 'option' || type === 'noscript' || typeof props.children === 'string' || typeof props.children === 'number' || typeof props.dangerouslySetInnerHTML === 'object' && props.dangerouslySetInnerHTML !== null && props.dangerouslySetInnerHTML.__html != null;
    }

    function shouldDeprioritizeSubtree(type, props) {
      return !!props.hidden;
    }

    function createTextInstance(text, rootContainerInstance, hostContext, internalInstanceHandle) {
      {
        var hostContextDev = hostContext;
        validateDOMNesting(null, text, hostContextDev.ancestorInfo);
      }
      var textNode = createTextNode(text, rootContainerInstance);
      precacheFiberNode(internalInstanceHandle, textNode);
      return textNode;
    }

    var isPrimaryRenderer = true;
    var warnsIfNotActing = true; // This initialization code may run even on server environments
    // if a component just imports ReactDOM (e.g. for findDOMNode).
    // Some environments might not have setTimeout or clearTimeout.

    var scheduleTimeout = typeof setTimeout === 'function' ? setTimeout : undefined;
    var cancelTimeout = typeof clearTimeout === 'function' ? clearTimeout : undefined;
    var noTimeout = -1; // -------------------
    //     Mutation
    // -------------------

    var supportsMutation = true;

    function commitMount(domElement, type, newProps, internalInstanceHandle) {
      // Despite the naming that might imply otherwise, this method only
      // fires if there is an `Update` effect scheduled during mounting.
      // This happens if `finalizeInitialChildren` returns `true` (which it
      // does to implement the `autoFocus` attribute on the client). But
      // there are also other cases when this might happen (such as patching
      // up text content during hydration mismatch). So we'll check this again.
      if (shouldAutoFocusHostComponent(type, newProps)) {
        domElement.focus();
      }
    }

    function commitUpdate(domElement, updatePayload, type, oldProps, newProps, internalInstanceHandle) {
      // Update the props handle so that we know which props are the ones with
      // with current event handlers.
      updateFiberProps(domElement, newProps); // Apply the diff to the DOM node.

      updateProperties(domElement, updatePayload, type, oldProps, newProps);
    }

    function resetTextContent(domElement) {
      setTextContent(domElement, '');
    }

    function commitTextUpdate(textInstance, oldText, newText) {
      textInstance.nodeValue = newText;
    }

    function appendChild(parentInstance, child) {
      parentInstance.appendChild(child);
    }

    function appendChildToContainer(container, child) {
      var parentNode;

      if (container.nodeType === COMMENT_NODE) {
        parentNode = container.parentNode;
        parentNode.insertBefore(child, container);
      } else {
        parentNode = container;
        parentNode.appendChild(child);
      } // This container might be used for a portal.
      // If something inside a portal is clicked, that click should bubble
      // through the React tree. However, on Mobile Safari the click would
      // never bubble through the *DOM* tree unless an ancestor with onclick
      // event exists. So we wouldn't see it and dispatch it.
      // This is why we ensure that non React root containers have inline onclick
      // defined.
      // https://github.com/facebook/react/issues/11918


      var reactRootContainer = container._reactRootContainer;

      if ((reactRootContainer === null || reactRootContainer === undefined) && parentNode.onclick === null) {
        // TODO: This cast may not be sound for SVG, MathML or custom elements.
        trapClickOnNonInteractiveElement(parentNode);
      }
    }

    function insertBefore(parentInstance, child, beforeChild) {
      parentInstance.insertBefore(child, beforeChild);
    }

    function insertInContainerBefore(container, child, beforeChild) {
      if (container.nodeType === COMMENT_NODE) {
        container.parentNode.insertBefore(child, beforeChild);
      } else {
        container.insertBefore(child, beforeChild);
      }
    } // This is a specific event for the React Flare
    // event system, so event responders can act
    // accordingly to a DOM node being unmounted that
    // previously had active document focus.


    function dispatchDetachedVisibleNodeEvent(child) {
      if (enableFlareAPI && selectionInformation && child === selectionInformation.focusedElem) {
        var targetFiber = getClosestInstanceFromNode(child); // Simlulate a blur event to the React Flare responder system.

        dispatchEventForResponderEventSystem('detachedvisiblenode', targetFiber, {
          target: child,
          timeStamp: Date.now()
        }, child, RESPONDER_EVENT_SYSTEM | IS_PASSIVE);
      }
    }

    function removeChild(parentInstance, child) {
      dispatchDetachedVisibleNodeEvent(child);
      parentInstance.removeChild(child);
    }

    function removeChildFromContainer(container, child) {
      if (container.nodeType === COMMENT_NODE) {
        container.parentNode.removeChild(child);
      } else {
        dispatchDetachedVisibleNodeEvent(child);
        container.removeChild(child);
      }
    }

    function clearSuspenseBoundary(parentInstance, suspenseInstance) {
      var node = suspenseInstance; // Delete all nodes within this suspense boundary.
      // There might be nested nodes so we need to keep track of how
      // deep we are and only break out when we're back on top.

      var depth = 0;

      do {
        var nextNode = node.nextSibling;
        parentInstance.removeChild(node);

        if (nextNode && nextNode.nodeType === COMMENT_NODE) {
          var data = nextNode.data;

          if (data === SUSPENSE_END_DATA) {
            if (depth === 0) {
              parentInstance.removeChild(nextNode); // Retry if any event replaying was blocked on this.

              retryIfBlockedOn(suspenseInstance);
              return;
            } else {
              depth--;
            }
          } else if (data === SUSPENSE_START_DATA || data === SUSPENSE_PENDING_START_DATA || data === SUSPENSE_FALLBACK_START_DATA) {
            depth++;
          }
        }

        node = nextNode;
      } while (node); // TODO: Warn, we didn't find the end comment boundary.
      // Retry if any event replaying was blocked on this.


      retryIfBlockedOn(suspenseInstance);
    }

    function clearSuspenseBoundaryFromContainer(container, suspenseInstance) {
      if (container.nodeType === COMMENT_NODE) {
        clearSuspenseBoundary(container.parentNode, suspenseInstance);
      } else if (container.nodeType === ELEMENT_NODE) {
        clearSuspenseBoundary(container, suspenseInstance);
      } else {} // Document nodes should never contain suspense boundaries.
      // Retry if any event replaying was blocked on this.


      retryIfBlockedOn(container);
    }

    function hideInstance(instance) {
      // TODO: Does this work for all element types? What about MathML? Should we
      // pass host context to this method?
      instance = instance;
      var style = instance.style;

      if (typeof style.setProperty === 'function') {
        style.setProperty('display', 'none', 'important');
      } else {
        style.display = 'none';
      }
    }

    function hideTextInstance(textInstance) {
      textInstance.nodeValue = '';
    }

    function unhideInstance(instance, props) {
      instance = instance;
      var styleProp = props[STYLE];
      var display = styleProp !== undefined && styleProp !== null && styleProp.hasOwnProperty('display') ? styleProp.display : null;
      instance.style.display = dangerousStyleValue('display', display);
    }

    function unhideTextInstance(textInstance, text) {
      textInstance.nodeValue = text;
    } // -------------------
    //     Hydration
    // -------------------


    var supportsHydration = true;

    function canHydrateInstance(instance, type, props) {
      if (instance.nodeType !== ELEMENT_NODE || type.toLowerCase() !== instance.nodeName.toLowerCase()) {
        return null;
      } // This has now been refined to an element node.


      return instance;
    }

    function canHydrateTextInstance(instance, text) {
      if (text === '' || instance.nodeType !== TEXT_NODE) {
        // Empty strings are not parsed by HTML so there won't be a correct match here.
        return null;
      } // This has now been refined to a text node.


      return instance;
    }

    function canHydrateSuspenseInstance(instance) {
      if (instance.nodeType !== COMMENT_NODE) {
        // Empty strings are not parsed by HTML so there won't be a correct match here.
        return null;
      } // This has now been refined to a suspense node.


      return instance;
    }

    function isSuspenseInstancePending(instance) {
      return instance.data === SUSPENSE_PENDING_START_DATA;
    }

    function isSuspenseInstanceFallback(instance) {
      return instance.data === SUSPENSE_FALLBACK_START_DATA;
    }

    function registerSuspenseInstanceRetry(instance, callback) {
      instance._reactRetry = callback;
    }

    function getNextHydratable(node) {
      // Skip non-hydratable nodes.
      for (; node != null; node = node.nextSibling) {
        var nodeType = node.nodeType;

        if (nodeType === ELEMENT_NODE || nodeType === TEXT_NODE) {
          break;
        }

        if (enableSuspenseServerRenderer) {
          if (nodeType === COMMENT_NODE) {
            var nodeData = node.data;

            if (nodeData === SUSPENSE_START_DATA || nodeData === SUSPENSE_FALLBACK_START_DATA || nodeData === SUSPENSE_PENDING_START_DATA) {
              break;
            }
          }
        }
      }

      return node;
    }

    function getNextHydratableSibling(instance) {
      return getNextHydratable(instance.nextSibling);
    }

    function getFirstHydratableChild(parentInstance) {
      return getNextHydratable(parentInstance.firstChild);
    }

    function hydrateInstance(instance, type, props, rootContainerInstance, hostContext, internalInstanceHandle) {
      precacheFiberNode(internalInstanceHandle, instance); // TODO: Possibly defer this until the commit phase where all the events
      // get attached.

      updateFiberProps(instance, props);
      var parentNamespace;
      {
        var hostContextDev = hostContext;
        parentNamespace = hostContextDev.namespace;
      }
      return diffHydratedProperties(instance, type, props, parentNamespace, rootContainerInstance);
    }

    function hydrateTextInstance(textInstance, text, internalInstanceHandle) {
      precacheFiberNode(internalInstanceHandle, textInstance);
      return diffHydratedText(textInstance, text);
    }

    function hydrateSuspenseInstance(suspenseInstance, internalInstanceHandle) {
      precacheFiberNode(internalInstanceHandle, suspenseInstance);
    }

    function getNextHydratableInstanceAfterSuspenseInstance(suspenseInstance) {
      var node = suspenseInstance.nextSibling; // Skip past all nodes within this suspense boundary.
      // There might be nested nodes so we need to keep track of how
      // deep we are and only break out when we're back on top.

      var depth = 0;

      while (node) {
        if (node.nodeType === COMMENT_NODE) {
          var data = node.data;

          if (data === SUSPENSE_END_DATA) {
            if (depth === 0) {
              return getNextHydratableSibling(node);
            } else {
              depth--;
            }
          } else if (data === SUSPENSE_START_DATA || data === SUSPENSE_FALLBACK_START_DATA || data === SUSPENSE_PENDING_START_DATA) {
            depth++;
          }
        }

        node = node.nextSibling;
      } // TODO: Warn, we didn't find the end comment boundary.


      return null;
    } // Returns the SuspenseInstance if this node is a direct child of a
    // SuspenseInstance. I.e. if its previous sibling is a Comment with
    // SUSPENSE_x_START_DATA. Otherwise, null.


    function getParentSuspenseInstance(targetInstance) {
      var node = targetInstance.previousSibling; // Skip past all nodes within this suspense boundary.
      // There might be nested nodes so we need to keep track of how
      // deep we are and only break out when we're back on top.

      var depth = 0;

      while (node) {
        if (node.nodeType === COMMENT_NODE) {
          var data = node.data;

          if (data === SUSPENSE_START_DATA || data === SUSPENSE_FALLBACK_START_DATA || data === SUSPENSE_PENDING_START_DATA) {
            if (depth === 0) {
              return node;
            } else {
              depth--;
            }
          } else if (data === SUSPENSE_END_DATA) {
            depth++;
          }
        }

        node = node.previousSibling;
      }

      return null;
    }

    function commitHydratedContainer(container) {
      // Retry if any event replaying was blocked on this.
      retryIfBlockedOn(container);
    }

    function commitHydratedSuspenseInstance(suspenseInstance) {
      // Retry if any event replaying was blocked on this.
      retryIfBlockedOn(suspenseInstance);
    }

    function didNotMatchHydratedContainerTextInstance(parentContainer, textInstance, text) {
      {
        warnForUnmatchedText(textInstance, text);
      }
    }

    function didNotMatchHydratedTextInstance(parentType, parentProps, parentInstance, textInstance, text) {
      if (true && parentProps[SUPPRESS_HYDRATION_WARNING] !== true) {
        warnForUnmatchedText(textInstance, text);
      }
    }

    function didNotHydrateContainerInstance(parentContainer, instance) {
      {
        if (instance.nodeType === ELEMENT_NODE) {
          warnForDeletedHydratableElement(parentContainer, instance);
        } else if (instance.nodeType === COMMENT_NODE) {// TODO: warnForDeletedHydratableSuspenseBoundary
        } else {
          warnForDeletedHydratableText(parentContainer, instance);
        }
      }
    }

    function didNotHydrateInstance(parentType, parentProps, parentInstance, instance) {
      if (true && parentProps[SUPPRESS_HYDRATION_WARNING] !== true) {
        if (instance.nodeType === ELEMENT_NODE) {
          warnForDeletedHydratableElement(parentInstance, instance);
        } else if (instance.nodeType === COMMENT_NODE) {// TODO: warnForDeletedHydratableSuspenseBoundary
        } else {
          warnForDeletedHydratableText(parentInstance, instance);
        }
      }
    }

    function didNotFindHydratableContainerInstance(parentContainer, type, props) {
      {
        warnForInsertedHydratedElement(parentContainer, type, props);
      }
    }

    function didNotFindHydratableContainerTextInstance(parentContainer, text) {
      {
        warnForInsertedHydratedText(parentContainer, text);
      }
    }

    function didNotFindHydratableInstance(parentType, parentProps, parentInstance, type, props) {
      if (true && parentProps[SUPPRESS_HYDRATION_WARNING] !== true) {
        warnForInsertedHydratedElement(parentInstance, type, props);
      }
    }

    function didNotFindHydratableTextInstance(parentType, parentProps, parentInstance, text) {
      if (true && parentProps[SUPPRESS_HYDRATION_WARNING] !== true) {
        warnForInsertedHydratedText(parentInstance, text);
      }
    }

    function didNotFindHydratableSuspenseInstance(parentType, parentProps, parentInstance) {
      if (true && parentProps[SUPPRESS_HYDRATION_WARNING] !== true) {// TODO: warnForInsertedHydratedSuspense(parentInstance);
      }
    }

    function mountResponderInstance(responder, responderInstance, responderProps, responderState, instance) {
      // Listen to events
      var doc = instance.ownerDocument;
      var _ref = responder,
          rootEventTypes = _ref.rootEventTypes,
          targetEventTypes = _ref.targetEventTypes;

      if (targetEventTypes !== null) {
        listenToEventResponderEventTypes(targetEventTypes, doc);
      }

      if (rootEventTypes !== null) {
        addRootEventTypesForResponderInstance(responderInstance, rootEventTypes);
        listenToEventResponderEventTypes(rootEventTypes, doc);
      }

      mountEventResponder(responder, responderInstance, responderProps, responderState);
      return responderInstance;
    }

    function unmountResponderInstance(responderInstance) {
      if (enableFlareAPI) {
        // TODO stop listening to targetEventTypes
        unmountEventResponder(responderInstance);
      }
    }

    function getFundamentalComponentInstance(fundamentalInstance) {
      if (enableFundamentalAPI) {
        var currentFiber = fundamentalInstance.currentFiber,
            impl = fundamentalInstance.impl,
            props = fundamentalInstance.props,
            state = fundamentalInstance.state;
        var instance = impl.getInstance(null, props, state);
        precacheFiberNode(currentFiber, instance);
        return instance;
      } // Because of the flag above, this gets around the Flow error;


      return null;
    }

    function mountFundamentalComponent(fundamentalInstance) {
      if (enableFundamentalAPI) {
        var impl = fundamentalInstance.impl,
            instance = fundamentalInstance.instance,
            props = fundamentalInstance.props,
            state = fundamentalInstance.state;
        var onMount = impl.onMount;

        if (onMount !== undefined) {
          onMount(null, instance, props, state);
        }
      }
    }

    function shouldUpdateFundamentalComponent(fundamentalInstance) {
      if (enableFundamentalAPI) {
        var impl = fundamentalInstance.impl,
            prevProps = fundamentalInstance.prevProps,
            props = fundamentalInstance.props,
            state = fundamentalInstance.state;
        var shouldUpdate = impl.shouldUpdate;

        if (shouldUpdate !== undefined) {
          return shouldUpdate(null, prevProps, props, state);
        }
      }

      return true;
    }

    function updateFundamentalComponent(fundamentalInstance) {
      if (enableFundamentalAPI) {
        var impl = fundamentalInstance.impl,
            instance = fundamentalInstance.instance,
            prevProps = fundamentalInstance.prevProps,
            props = fundamentalInstance.props,
            state = fundamentalInstance.state;
        var onUpdate = impl.onUpdate;

        if (onUpdate !== undefined) {
          onUpdate(null, instance, prevProps, props, state);
        }
      }
    }

    function unmountFundamentalComponent(fundamentalInstance) {
      if (enableFundamentalAPI) {
        var impl = fundamentalInstance.impl,
            instance = fundamentalInstance.instance,
            props = fundamentalInstance.props,
            state = fundamentalInstance.state;
        var onUnmount = impl.onUnmount;

        if (onUnmount !== undefined) {
          onUnmount(null, instance, props, state);
        }
      }
    }

    function getInstanceFromNode$2(node) {
      return getClosestInstanceFromNode(node) || null;
    }

    var randomKey = Math.random().toString(36).slice(2);
    var internalInstanceKey = '__reactInternalInstance$' + randomKey;
    var internalEventHandlersKey = '__reactEventHandlers$' + randomKey;
    var internalContainerInstanceKey = '__reactContainere$' + randomKey;

    function precacheFiberNode(hostInst, node) {
      node[internalInstanceKey] = hostInst;
    }

    function markContainerAsRoot(hostRoot, node) {
      node[internalContainerInstanceKey] = hostRoot;
    }

    function unmarkContainerAsRoot(node) {
      node[internalContainerInstanceKey] = null;
    }

    function isContainerMarkedAsRoot(node) {
      return !!node[internalContainerInstanceKey];
    } // Given a DOM node, return the closest HostComponent or HostText fiber ancestor.
    // If the target node is part of a hydrated or not yet rendered subtree, then
    // this may also return a SuspenseComponent or HostRoot to indicate that.
    // Conceptually the HostRoot fiber is a child of the Container node. So if you
    // pass the Container node as the targetNode, you will not actually get the
    // HostRoot back. To get to the HostRoot, you need to pass a child of it.
    // The same thing applies to Suspense boundaries.


    function getClosestInstanceFromNode(targetNode) {
      var targetInst = targetNode[internalInstanceKey];

      if (targetInst) {
        // Don't return HostRoot or SuspenseComponent here.
        return targetInst;
      } // If the direct event target isn't a React owned DOM node, we need to look
      // to see if one of its parents is a React owned DOM node.


      var parentNode = targetNode.parentNode;

      while (parentNode) {
        // We'll check if this is a container root that could include
        // React nodes in the future. We need to check this first because
        // if we're a child of a dehydrated container, we need to first
        // find that inner container before moving on to finding the parent
        // instance. Note that we don't check this field on  the targetNode
        // itself because the fibers are conceptually between the container
        // node and the first child. It isn't surrounding the container node.
        // If it's not a container, we check if it's an instance.
        targetInst = parentNode[internalContainerInstanceKey] || parentNode[internalInstanceKey];

        if (targetInst) {
          // Since this wasn't the direct target of the event, we might have
          // stepped past dehydrated DOM nodes to get here. However they could
          // also have been non-React nodes. We need to answer which one.
          // If we the instance doesn't have any children, then there can't be
          // a nested suspense boundary within it. So we can use this as a fast
          // bailout. Most of the time, when people add non-React children to
          // the tree, it is using a ref to a child-less DOM node.
          // Normally we'd only need to check one of the fibers because if it
          // has ever gone from having children to deleting them or vice versa
          // it would have deleted the dehydrated boundary nested inside already.
          // However, since the HostRoot starts out with an alternate it might
          // have one on the alternate so we need to check in case this was a
          // root.
          var alternate = targetInst.alternate;

          if (targetInst.child !== null || alternate !== null && alternate.child !== null) {
            // Next we need to figure out if the node that skipped past is
            // nested within a dehydrated boundary and if so, which one.
            var suspenseInstance = getParentSuspenseInstance(targetNode);

            while (suspenseInstance !== null) {
              // We found a suspense instance. That means that we haven't
              // hydrated it yet. Even though we leave the comments in the
              // DOM after hydrating, and there are boundaries in the DOM
              // that could already be hydrated, we wouldn't have found them
              // through this pass since if the target is hydrated it would
              // have had an internalInstanceKey on it.
              // Let's get the fiber associated with the SuspenseComponent
              // as the deepest instance.
              var targetSuspenseInst = suspenseInstance[internalInstanceKey];

              if (targetSuspenseInst) {
                return targetSuspenseInst;
              } // If we don't find a Fiber on the comment, it might be because
              // we haven't gotten to hydrate it yet. There might still be a
              // parent boundary that hasn't above this one so we need to find
              // the outer most that is known.


              suspenseInstance = getParentSuspenseInstance(suspenseInstance); // If we don't find one, then that should mean that the parent
              // host component also hasn't hydrated yet. We can return it
              // below since it will bail out on the isMounted check later.
            }
          }

          return targetInst;
        }

        targetNode = parentNode;
        parentNode = targetNode.parentNode;
      }

      return null;
    }
    /**
     * Given a DOM node, return the ReactDOMComponent or ReactDOMTextComponent
     * instance, or null if the node was not rendered by this React.
     */


    function getInstanceFromNode$1(node) {
      var inst = node[internalInstanceKey] || node[internalContainerInstanceKey];

      if (inst) {
        if (inst.tag === HostComponent || inst.tag === HostText || inst.tag === SuspenseComponent || inst.tag === HostRoot) {
          return inst;
        } else {
          return null;
        }
      }

      return null;
    }
    /**
     * Given a ReactDOMComponent or ReactDOMTextComponent, return the corresponding
     * DOM node.
     */


    function getNodeFromInstance$1(inst) {
      if (inst.tag === HostComponent || inst.tag === HostText) {
        // In Fiber this, is just the state node right now. We assume it will be
        // a host component or host text.
        return inst.stateNode;
      } // Without this first invariant, passing a non-DOM-component triggers the next
      // invariant for a missing parent, which is super confusing.


      {
        {
          throw Error("getNodeFromInstance: Invalid argument.");
        }
      }
    }

    function getFiberCurrentPropsFromNode$1(node) {
      return node[internalEventHandlersKey] || null;
    }

    function updateFiberProps(node, props) {
      node[internalEventHandlersKey] = props;
    }
    /**
     * These variables store information about text content of a target node,
     * allowing comparison of content before and after a given event.
     *
     * Identify the node where selection currently begins, then observe
     * both its text content and its current position in the DOM. Since the
     * browser may natively replace the target node during composition, we can
     * use its position to find its replacement.
     *
     *
     */


    var root = null;
    var startText = null;
    var fallbackText = null;

    function initialize(nativeEventTarget) {
      root = nativeEventTarget;
      startText = getText();
      return true;
    }

    function reset() {
      root = null;
      startText = null;
      fallbackText = null;
    }

    function getData() {
      if (fallbackText) {
        return fallbackText;
      }

      var start;
      var startValue = startText;
      var startLength = startValue.length;
      var end;
      var endValue = getText();
      var endLength = endValue.length;

      for (start = 0; start < startLength; start++) {
        if (startValue[start] !== endValue[start]) {
          break;
        }
      }

      var minEnd = startLength - start;

      for (end = 1; end <= minEnd; end++) {
        if (startValue[startLength - end] !== endValue[endLength - end]) {
          break;
        }
      }

      var sliceTail = end > 1 ? 1 - end : undefined;
      fallbackText = endValue.slice(start, sliceTail);
      return fallbackText;
    }

    function getText() {
      if ('value' in root) {
        return root.value;
      }

      return root.textContent;
    }
    /**
     * @interface Event
     * @see http://www.w3.org/TR/DOM-Level-3-Events/#events-compositionevents
     */


    var SyntheticCompositionEvent = SyntheticEvent.extend({
      data: null
    });
    /**
     * @interface Event
     * @see http://www.w3.org/TR/2013/WD-DOM-Level-3-Events-20131105
     *      /#events-inputevents
     */

    var SyntheticInputEvent = SyntheticEvent.extend({
      data: null
    });
    var END_KEYCODES = [9, 13, 27, 32]; // Tab, Return, Esc, Space

    var START_KEYCODE = 229;
    var canUseCompositionEvent = canUseDOM && 'CompositionEvent' in window;
    var documentMode = null;

    if (canUseDOM && 'documentMode' in document) {
      documentMode = document.documentMode;
    } // Webkit offers a very useful `textInput` event that can be used to
    // directly represent `beforeInput`. The IE `textinput` event is not as
    // useful, so we don't use it.


    var canUseTextInputEvent = canUseDOM && 'TextEvent' in window && !documentMode; // In IE9+, we have access to composition events, but the data supplied
    // by the native compositionend event may be incorrect. Japanese ideographic
    // spaces, for instance (\u3000) are not recorded correctly.

    var useFallbackCompositionData = canUseDOM && (!canUseCompositionEvent || documentMode && documentMode > 8 && documentMode <= 11);
    var SPACEBAR_CODE = 32;
    var SPACEBAR_CHAR = String.fromCharCode(SPACEBAR_CODE); // Events and their corresponding property names.

    var eventTypes$1 = {
      beforeInput: {
        phasedRegistrationNames: {
          bubbled: 'onBeforeInput',
          captured: 'onBeforeInputCapture'
        },
        dependencies: [TOP_COMPOSITION_END, TOP_KEY_PRESS, TOP_TEXT_INPUT, TOP_PASTE]
      },
      compositionEnd: {
        phasedRegistrationNames: {
          bubbled: 'onCompositionEnd',
          captured: 'onCompositionEndCapture'
        },
        dependencies: [TOP_BLUR, TOP_COMPOSITION_END, TOP_KEY_DOWN, TOP_KEY_PRESS, TOP_KEY_UP, TOP_MOUSE_DOWN]
      },
      compositionStart: {
        phasedRegistrationNames: {
          bubbled: 'onCompositionStart',
          captured: 'onCompositionStartCapture'
        },
        dependencies: [TOP_BLUR, TOP_COMPOSITION_START, TOP_KEY_DOWN, TOP_KEY_PRESS, TOP_KEY_UP, TOP_MOUSE_DOWN]
      },
      compositionUpdate: {
        phasedRegistrationNames: {
          bubbled: 'onCompositionUpdate',
          captured: 'onCompositionUpdateCapture'
        },
        dependencies: [TOP_BLUR, TOP_COMPOSITION_UPDATE, TOP_KEY_DOWN, TOP_KEY_PRESS, TOP_KEY_UP, TOP_MOUSE_DOWN]
      }
    }; // Track whether we've ever handled a keypress on the space key.

    var hasSpaceKeypress = false;
    /**
     * Return whether a native keypress event is assumed to be a command.
     * This is required because Firefox fires `keypress` events for key commands
     * (cut, copy, select-all, etc.) even though no character is inserted.
     */

    function isKeypressCommand(nativeEvent) {
      return (nativeEvent.ctrlKey || nativeEvent.altKey || nativeEvent.metaKey) && // ctrlKey && altKey is equivalent to AltGr, and is not a command.
      !(nativeEvent.ctrlKey && nativeEvent.altKey);
    }
    /**
     * Translate native top level events into event types.
     *
     * @param {string} topLevelType
     * @return {object}
     */


    function getCompositionEventType(topLevelType) {
      switch (topLevelType) {
        case TOP_COMPOSITION_START:
          return eventTypes$1.compositionStart;

        case TOP_COMPOSITION_END:
          return eventTypes$1.compositionEnd;

        case TOP_COMPOSITION_UPDATE:
          return eventTypes$1.compositionUpdate;
      }
    }
    /**
     * Does our fallback best-guess model think this event signifies that
     * composition has begun?
     *
     * @param {string} topLevelType
     * @param {object} nativeEvent
     * @return {boolean}
     */


    function isFallbackCompositionStart(topLevelType, nativeEvent) {
      return topLevelType === TOP_KEY_DOWN && nativeEvent.keyCode === START_KEYCODE;
    }
    /**
     * Does our fallback mode think that this event is the end of composition?
     *
     * @param {string} topLevelType
     * @param {object} nativeEvent
     * @return {boolean}
     */


    function isFallbackCompositionEnd(topLevelType, nativeEvent) {
      switch (topLevelType) {
        case TOP_KEY_UP:
          // Command keys insert or clear IME input.
          return END_KEYCODES.indexOf(nativeEvent.keyCode) !== -1;

        case TOP_KEY_DOWN:
          // Expect IME keyCode on each keydown. If we get any other
          // code we must have exited earlier.
          return nativeEvent.keyCode !== START_KEYCODE;

        case TOP_KEY_PRESS:
        case TOP_MOUSE_DOWN:
        case TOP_BLUR:
          // Events are not possible without cancelling IME.
          return true;

        default:
          return false;
      }
    }
    /**
     * Google Input Tools provides composition data via a CustomEvent,
     * with the `data` property populated in the `detail` object. If this
     * is available on the event object, use it. If not, this is a plain
     * composition event and we have nothing special to extract.
     *
     * @param {object} nativeEvent
     * @return {?string}
     */


    function getDataFromCustomEvent(nativeEvent) {
      var detail = nativeEvent.detail;

      if (typeof detail === 'object' && 'data' in detail) {
        return detail.data;
      }

      return null;
    }
    /**
     * Check if a composition event was triggered by Korean IME.
     * Our fallback mode does not work well with IE's Korean IME,
     * so just use native composition events when Korean IME is used.
     * Although CompositionEvent.locale property is deprecated,
     * it is available in IE, where our fallback mode is enabled.
     *
     * @param {object} nativeEvent
     * @return {boolean}
     */


    function isUsingKoreanIME(nativeEvent) {
      return nativeEvent.locale === 'ko';
    } // Track the current IME composition status, if any.


    var isComposing = false;
    /**
     * @return {?object} A SyntheticCompositionEvent.
     */

    function extractCompositionEvent(topLevelType, targetInst, nativeEvent, nativeEventTarget) {
      var eventType;
      var fallbackData;

      if (canUseCompositionEvent) {
        eventType = getCompositionEventType(topLevelType);
      } else if (!isComposing) {
        if (isFallbackCompositionStart(topLevelType, nativeEvent)) {
          eventType = eventTypes$1.compositionStart;
        }
      } else if (isFallbackCompositionEnd(topLevelType, nativeEvent)) {
        eventType = eventTypes$1.compositionEnd;
      }

      if (!eventType) {
        return null;
      }

      if (useFallbackCompositionData && !isUsingKoreanIME(nativeEvent)) {
        // The current composition is stored statically and must not be
        // overwritten while composition continues.
        if (!isComposing && eventType === eventTypes$1.compositionStart) {
          isComposing = initialize(nativeEventTarget);
        } else if (eventType === eventTypes$1.compositionEnd) {
          if (isComposing) {
            fallbackData = getData();
          }
        }
      }

      var event = SyntheticCompositionEvent.getPooled(eventType, targetInst, nativeEvent, nativeEventTarget);

      if (fallbackData) {
        // Inject data generated from fallback path into the synthetic event.
        // This matches the property of native CompositionEventInterface.
        event.data = fallbackData;
      } else {
        var customData = getDataFromCustomEvent(nativeEvent);

        if (customData !== null) {
          event.data = customData;
        }
      }

      accumulateTwoPhaseDispatches(event);
      return event;
    }
    /**
     * @param {TopLevelType} topLevelType Number from `TopLevelType`.
     * @param {object} nativeEvent Native browser event.
     * @return {?string} The string corresponding to this `beforeInput` event.
     */


    function getNativeBeforeInputChars(topLevelType, nativeEvent) {
      switch (topLevelType) {
        case TOP_COMPOSITION_END:
          return getDataFromCustomEvent(nativeEvent);

        case TOP_KEY_PRESS:
          /**
           * If native `textInput` events are available, our goal is to make
           * use of them. However, there is a special case: the spacebar key.
           * In Webkit, preventing default on a spacebar `textInput` event
           * cancels character insertion, but it *also* causes the browser
           * to fall back to its default spacebar behavior of scrolling the
           * page.
           *
           * Tracking at:
           * https://code.google.com/p/chromium/issues/detail?id=355103
           *
           * To avoid this issue, use the keypress event as if no `textInput`
           * event is available.
           */
          var which = nativeEvent.which;

          if (which !== SPACEBAR_CODE) {
            return null;
          }

          hasSpaceKeypress = true;
          return SPACEBAR_CHAR;

        case TOP_TEXT_INPUT:
          // Record the characters to be added to the DOM.
          var chars = nativeEvent.data; // If it's a spacebar character, assume that we have already handled
          // it at the keypress level and bail immediately. Android Chrome
          // doesn't give us keycodes, so we need to ignore it.

          if (chars === SPACEBAR_CHAR && hasSpaceKeypress) {
            return null;
          }

          return chars;

        default:
          // For other native event types, do nothing.
          return null;
      }
    }
    /**
     * For browsers that do not provide the `textInput` event, extract the
     * appropriate string to use for SyntheticInputEvent.
     *
     * @param {number} topLevelType Number from `TopLevelEventTypes`.
     * @param {object} nativeEvent Native browser event.
     * @return {?string} The fallback string for this `beforeInput` event.
     */


    function getFallbackBeforeInputChars(topLevelType, nativeEvent) {
      // If we are currently composing (IME) and using a fallback to do so,
      // try to extract the composed characters from the fallback object.
      // If composition event is available, we extract a string only at
      // compositionevent, otherwise extract it at fallback events.
      if (isComposing) {
        if (topLevelType === TOP_COMPOSITION_END || !canUseCompositionEvent && isFallbackCompositionEnd(topLevelType, nativeEvent)) {
          var chars = getData();
          reset();
          isComposing = false;
          return chars;
        }

        return null;
      }

      switch (topLevelType) {
        case TOP_PASTE:
          // If a paste event occurs after a keypress, throw out the input
          // chars. Paste events should not lead to BeforeInput events.
          return null;

        case TOP_KEY_PRESS:
          /**
           * As of v27, Firefox may fire keypress events even when no character
           * will be inserted. A few possibilities:
           *
           * - `which` is `0`. Arrow keys, Esc key, etc.
           *
           * - `which` is the pressed key code, but no char is available.
           *   Ex: 'AltGr + d` in Polish. There is no modified character for
           *   this key combination and no character is inserted into the
           *   document, but FF fires the keypress for char code `100` anyway.
           *   No `input` event will occur.
           *
           * - `which` is the pressed key code, but a command combination is
           *   being used. Ex: `Cmd+C`. No character is inserted, and no
           *   `input` event will occur.
           */
          if (!isKeypressCommand(nativeEvent)) {
            // IE fires the `keypress` event when a user types an emoji via
            // Touch keyboard of Windows.  In such a case, the `char` property
            // holds an emoji character like `\uD83D\uDE0A`.  Because its length
            // is 2, the property `which` does not represent an emoji correctly.
            // In such a case, we directly return the `char` property instead of
            // using `which`.
            if (nativeEvent.char && nativeEvent.char.length > 1) {
              return nativeEvent.char;
            } else if (nativeEvent.which) {
              return String.fromCharCode(nativeEvent.which);
            }
          }

          return null;

        case TOP_COMPOSITION_END:
          return useFallbackCompositionData && !isUsingKoreanIME(nativeEvent) ? null : nativeEvent.data;

        default:
          return null;
      }
    }
    /**
     * Extract a SyntheticInputEvent for `beforeInput`, based on either native
     * `textInput` or fallback behavior.
     *
     * @return {?object} A SyntheticInputEvent.
     */


    function extractBeforeInputEvent(topLevelType, targetInst, nativeEvent, nativeEventTarget) {
      var chars;

      if (canUseTextInputEvent) {
        chars = getNativeBeforeInputChars(topLevelType, nativeEvent);
      } else {
        chars = getFallbackBeforeInputChars(topLevelType, nativeEvent);
      } // If no characters are being inserted, no BeforeInput event should
      // be fired.


      if (!chars) {
        return null;
      }

      var event = SyntheticInputEvent.getPooled(eventTypes$1.beforeInput, targetInst, nativeEvent, nativeEventTarget);
      event.data = chars;
      accumulateTwoPhaseDispatches(event);
      return event;
    }
    /**
     * Create an `onBeforeInput` event to match
     * http://www.w3.org/TR/2013/WD-DOM-Level-3-Events-20131105/#events-inputevents.
     *
     * This event plugin is based on the native `textInput` event
     * available in Chrome, Safari, Opera, and IE. This event fires after
     * `onKeyPress` and `onCompositionEnd`, but before `onInput`.
     *
     * `beforeInput` is spec'd but not implemented in any browsers, and
     * the `input` event does not provide any useful information about what has
     * actually been added, contrary to the spec. Thus, `textInput` is the best
     * available event to identify the characters that have actually been inserted
     * into the target node.
     *
     * This plugin is also responsible for emitting `composition` events, thus
     * allowing us to share composition fallback code for both `beforeInput` and
     * `composition` event types.
     */


    var BeforeInputEventPlugin = {
      eventTypes: eventTypes$1,
      extractEvents: function (topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
        var composition = extractCompositionEvent(topLevelType, targetInst, nativeEvent, nativeEventTarget);
        var beforeInput = extractBeforeInputEvent(topLevelType, targetInst, nativeEvent, nativeEventTarget);

        if (composition === null) {
          return beforeInput;
        }

        if (beforeInput === null) {
          return composition;
        }

        return [composition, beforeInput];
      }
    };
    /**
     * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-input-element.html#input-type-attr-summary
     */

    var supportedInputTypes = {
      color: true,
      date: true,
      datetime: true,
      'datetime-local': true,
      email: true,
      month: true,
      number: true,
      password: true,
      range: true,
      search: true,
      tel: true,
      text: true,
      time: true,
      url: true,
      week: true
    };

    function isTextInputElement(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();

      if (nodeName === 'input') {
        return !!supportedInputTypes[elem.type];
      }

      if (nodeName === 'textarea') {
        return true;
      }

      return false;
    }

    var eventTypes$2 = {
      change: {
        phasedRegistrationNames: {
          bubbled: 'onChange',
          captured: 'onChangeCapture'
        },
        dependencies: [TOP_BLUR, TOP_CHANGE, TOP_CLICK, TOP_FOCUS, TOP_INPUT, TOP_KEY_DOWN, TOP_KEY_UP, TOP_SELECTION_CHANGE]
      }
    };

    function createAndAccumulateChangeEvent(inst, nativeEvent, target) {
      var event = SyntheticEvent.getPooled(eventTypes$2.change, inst, nativeEvent, target);
      event.type = 'change'; // Flag this event loop as needing state restore.

      enqueueStateRestore(target);
      accumulateTwoPhaseDispatches(event);
      return event;
    }
    /**
     * For IE shims
     */


    var activeElement = null;
    var activeElementInst = null;
    /**
     * SECTION: handle `change` event
     */

    function shouldUseChangeEvent(elem) {
      var nodeName = elem.nodeName && elem.nodeName.toLowerCase();
      return nodeName === 'select' || nodeName === 'input' && elem.type === 'file';
    }

    function manualDispatchChangeEvent(nativeEvent) {
      var event = createAndAccumulateChangeEvent(activeElementInst, nativeEvent, getEventTarget(nativeEvent)); // If change and propertychange bubbled, we'd just bind to it like all the
      // other events and have it go through ReactBrowserEventEmitter. Since it
      // doesn't, we manually listen for the events and so we have to enqueue and
      // process the abstract event manually.
      //
      // Batching is necessary here in order to ensure that all event handlers run
      // before the next rerender (including event handlers attached to ancestor
      // elements instead of directly on the input). Without this, controlled
      // components don't work properly in conjunction with event bubbling because
      // the component is rerendered and the value reverted before all the event
      // handlers can run. See https://github.com/facebook/react/issues/708.

      batchedUpdates(runEventInBatch, event);
    }

    function runEventInBatch(event) {
      runEventsInBatch(event);
    }

    function getInstIfValueChanged(targetInst) {
      var targetNode = getNodeFromInstance$1(targetInst);

      if (updateValueIfChanged(targetNode)) {
        return targetInst;
      }
    }

    function getTargetInstForChangeEvent(topLevelType, targetInst) {
      if (topLevelType === TOP_CHANGE) {
        return targetInst;
      }
    }
    /**
     * SECTION: handle `input` event
     */


    var isInputEventSupported = false;

    if (canUseDOM) {
      // IE9 claims to support the input event but fails to trigger it when
      // deleting text, so we ignore its input events.
      isInputEventSupported = isEventSupported('input') && (!document.documentMode || document.documentMode > 9);
    }
    /**
     * (For IE <=9) Starts tracking propertychange events on the passed-in element
     * and override the value property so that we can distinguish user events from
     * value changes in JS.
     */


    function startWatchingForValueChange(target, targetInst) {
      activeElement = target;
      activeElementInst = targetInst;
      activeElement.attachEvent('onpropertychange', handlePropertyChange);
    }
    /**
     * (For IE <=9) Removes the event listeners from the currently-tracked element,
     * if any exists.
     */


    function stopWatchingForValueChange() {
      if (!activeElement) {
        return;
      }

      activeElement.detachEvent('onpropertychange', handlePropertyChange);
      activeElement = null;
      activeElementInst = null;
    }
    /**
     * (For IE <=9) Handles a propertychange event, sending a `change` event if
     * the value of the active element has changed.
     */


    function handlePropertyChange(nativeEvent) {
      if (nativeEvent.propertyName !== 'value') {
        return;
      }

      if (getInstIfValueChanged(activeElementInst)) {
        manualDispatchChangeEvent(nativeEvent);
      }
    }

    function handleEventsForInputEventPolyfill(topLevelType, target, targetInst) {
      if (topLevelType === TOP_FOCUS) {
        // In IE9, propertychange fires for most input events but is buggy and
        // doesn't fire when text is deleted, but conveniently, selectionchange
        // appears to fire in all of the remaining cases so we catch those and
        // forward the event if the value has changed
        // In either case, we don't want to call the event handler if the value
        // is changed from JS so we redefine a setter for `.value` that updates
        // our activeElementValue variable, allowing us to ignore those changes
        //
        // stopWatching() should be a noop here but we call it just in case we
        // missed a blur event somehow.
        stopWatchingForValueChange();
        startWatchingForValueChange(target, targetInst);
      } else if (topLevelType === TOP_BLUR) {
        stopWatchingForValueChange();
      }
    } // For IE8 and IE9.


    function getTargetInstForInputEventPolyfill(topLevelType, targetInst) {
      if (topLevelType === TOP_SELECTION_CHANGE || topLevelType === TOP_KEY_UP || topLevelType === TOP_KEY_DOWN) {
        // On the selectionchange event, the target is just document which isn't
        // helpful for us so just check activeElement instead.
        //
        // 99% of the time, keydown and keyup aren't necessary. IE8 fails to fire
        // propertychange on the first input event after setting `value` from a
        // script and fires only keydown, keypress, keyup. Catching keyup usually
        // gets it and catching keydown lets us fire an event for the first
        // keystroke if user does a key repeat (it'll be a little delayed: right
        // before the second keystroke). Other input methods (e.g., paste) seem to
        // fire selectionchange normally.
        return getInstIfValueChanged(activeElementInst);
      }
    }
    /**
     * SECTION: handle `click` event
     */


    function shouldUseClickEvent(elem) {
      // Use the `click` event to detect changes to checkbox and radio inputs.
      // This approach works across all browsers, whereas `change` does not fire
      // until `blur` in IE8.
      var nodeName = elem.nodeName;
      return nodeName && nodeName.toLowerCase() === 'input' && (elem.type === 'checkbox' || elem.type === 'radio');
    }

    function getTargetInstForClickEvent(topLevelType, targetInst) {
      if (topLevelType === TOP_CLICK) {
        return getInstIfValueChanged(targetInst);
      }
    }

    function getTargetInstForInputOrChangeEvent(topLevelType, targetInst) {
      if (topLevelType === TOP_INPUT || topLevelType === TOP_CHANGE) {
        return getInstIfValueChanged(targetInst);
      }
    }

    function handleControlledInputBlur(node) {
      var state = node._wrapperState;

      if (!state || !state.controlled || node.type !== 'number') {
        return;
      }

      if (!disableInputAttributeSyncing) {
        // If controlled, assign the value attribute to the current value on blur
        setDefaultValue(node, 'number', node.value);
      }
    }
    /**
     * This plugin creates an `onChange` event that normalizes change events
     * across form elements. This event fires at a time when it's possible to
     * change the element's value without seeing a flicker.
     *
     * Supported elements are:
     * - input (see `isTextInputElement`)
     * - textarea
     * - select
     */


    var ChangeEventPlugin = {
      eventTypes: eventTypes$2,
      _isInputEventSupported: isInputEventSupported,
      extractEvents: function (topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
        var targetNode = targetInst ? getNodeFromInstance$1(targetInst) : window;
        var getTargetInstFunc, handleEventFunc;

        if (shouldUseChangeEvent(targetNode)) {
          getTargetInstFunc = getTargetInstForChangeEvent;
        } else if (isTextInputElement(targetNode)) {
          if (isInputEventSupported) {
            getTargetInstFunc = getTargetInstForInputOrChangeEvent;
          } else {
            getTargetInstFunc = getTargetInstForInputEventPolyfill;
            handleEventFunc = handleEventsForInputEventPolyfill;
          }
        } else if (shouldUseClickEvent(targetNode)) {
          getTargetInstFunc = getTargetInstForClickEvent;
        }

        if (getTargetInstFunc) {
          var inst = getTargetInstFunc(topLevelType, targetInst);

          if (inst) {
            var event = createAndAccumulateChangeEvent(inst, nativeEvent, nativeEventTarget);
            return event;
          }
        }

        if (handleEventFunc) {
          handleEventFunc(topLevelType, targetNode, targetInst);
        } // When blurring, set the value attribute for number inputs


        if (topLevelType === TOP_BLUR) {
          handleControlledInputBlur(targetNode);
        }
      }
    };
    /**
     * Module that is injectable into `EventPluginHub`, that specifies a
     * deterministic ordering of `EventPlugin`s. A convenient way to reason about
     * plugins, without having to package every one of them. This is better than
     * having plugins be ordered in the same order that they are injected because
     * that ordering would be influenced by the packaging order.
     * `ResponderEventPlugin` must occur before `SimpleEventPlugin` so that
     * preventing default on events is convenient in `SimpleEventPlugin` handlers.
     */

    var DOMEventPluginOrder = ['ResponderEventPlugin', 'SimpleEventPlugin', 'EnterLeaveEventPlugin', 'ChangeEventPlugin', 'SelectEventPlugin', 'BeforeInputEventPlugin'];
    var eventTypes$3 = {
      mouseEnter: {
        registrationName: 'onMouseEnter',
        dependencies: [TOP_MOUSE_OUT, TOP_MOUSE_OVER]
      },
      mouseLeave: {
        registrationName: 'onMouseLeave',
        dependencies: [TOP_MOUSE_OUT, TOP_MOUSE_OVER]
      },
      pointerEnter: {
        registrationName: 'onPointerEnter',
        dependencies: [TOP_POINTER_OUT, TOP_POINTER_OVER]
      },
      pointerLeave: {
        registrationName: 'onPointerLeave',
        dependencies: [TOP_POINTER_OUT, TOP_POINTER_OVER]
      }
    }; // We track the lastNativeEvent to ensure that when we encounter
    // cases where we process the same nativeEvent multiple times,
    // which can happen when have multiple ancestors, that we don't
    // duplicate enter

    var lastNativeEvent;
    var EnterLeaveEventPlugin = {
      eventTypes: eventTypes$3,

      /**
       * For almost every interaction we care about, there will be both a top-level
       * `mouseover` and `mouseout` event that occurs. Only use `mouseout` so that
       * we do not extract duplicate events. However, moving the mouse into the
       * browser from outside will not fire a `mouseout` event. In this case, we use
       * the `mouseover` top-level event.
       */
      extractEvents: function (topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
        var isOverEvent = topLevelType === TOP_MOUSE_OVER || topLevelType === TOP_POINTER_OVER;
        var isOutEvent = topLevelType === TOP_MOUSE_OUT || topLevelType === TOP_POINTER_OUT;

        if (isOverEvent && (eventSystemFlags & IS_REPLAYED) === 0 && (nativeEvent.relatedTarget || nativeEvent.fromElement)) {
          // If this is an over event with a target, then we've already dispatched
          // the event in the out event of the other target. If this is replayed,
          // then it's because we couldn't dispatch against this target previously
          // so we have to do it now instead.
          return null;
        }

        if (!isOutEvent && !isOverEvent) {
          // Must not be a mouse or pointer in or out - ignoring.
          return null;
        }

        var win;

        if (nativeEventTarget.window === nativeEventTarget) {
          // `nativeEventTarget` is probably a window object.
          win = nativeEventTarget;
        } else {
          // TODO: Figure out why `ownerDocument` is sometimes undefined in IE8.
          var doc = nativeEventTarget.ownerDocument;

          if (doc) {
            win = doc.defaultView || doc.parentWindow;
          } else {
            win = window;
          }
        }

        var from;
        var to;

        if (isOutEvent) {
          from = targetInst;
          var related = nativeEvent.relatedTarget || nativeEvent.toElement;
          to = related ? getClosestInstanceFromNode(related) : null;

          if (to !== null) {
            var nearestMounted = getNearestMountedFiber(to);

            if (to !== nearestMounted || to.tag !== HostComponent && to.tag !== HostText) {
              to = null;
            }
          }
        } else {
          // Moving to a node from outside the window.
          from = null;
          to = targetInst;
        }

        if (from === to) {
          // Nothing pertains to our managed components.
          return null;
        }

        var eventInterface, leaveEventType, enterEventType, eventTypePrefix;

        if (topLevelType === TOP_MOUSE_OUT || topLevelType === TOP_MOUSE_OVER) {
          eventInterface = SyntheticMouseEvent;
          leaveEventType = eventTypes$3.mouseLeave;
          enterEventType = eventTypes$3.mouseEnter;
          eventTypePrefix = 'mouse';
        } else if (topLevelType === TOP_POINTER_OUT || topLevelType === TOP_POINTER_OVER) {
          eventInterface = SyntheticPointerEvent;
          leaveEventType = eventTypes$3.pointerLeave;
          enterEventType = eventTypes$3.pointerEnter;
          eventTypePrefix = 'pointer';
        }

        var fromNode = from == null ? win : getNodeFromInstance$1(from);
        var toNode = to == null ? win : getNodeFromInstance$1(to);
        var leave = eventInterface.getPooled(leaveEventType, from, nativeEvent, nativeEventTarget);
        leave.type = eventTypePrefix + 'leave';
        leave.target = fromNode;
        leave.relatedTarget = toNode;
        var enter = eventInterface.getPooled(enterEventType, to, nativeEvent, nativeEventTarget);
        enter.type = eventTypePrefix + 'enter';
        enter.target = toNode;
        enter.relatedTarget = fromNode;
        accumulateEnterLeaveDispatches(leave, enter, from, to);

        if (nativeEvent === lastNativeEvent) {
          lastNativeEvent = null;
          return [leave];
        }

        lastNativeEvent = nativeEvent;
        return [leave, enter];
      }
    };
    /**
     * inlined Object.is polyfill to avoid requiring consumers ship their own
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
     */

    function is(x, y) {
      return x === y && (x !== 0 || 1 / x === 1 / y) || x !== x && y !== y // eslint-disable-line no-self-compare
      ;
    }

    var is$1 = typeof Object.is === 'function' ? Object.is : is;
    var hasOwnProperty$2 = Object.prototype.hasOwnProperty;
    /**
     * Performs equality by iterating through keys on an object and returning false
     * when any key has values which are not strictly equal between the arguments.
     * Returns true when the values of all keys are strictly equal.
     */

    function shallowEqual(objA, objB) {
      if (is$1(objA, objB)) {
        return true;
      }

      if (typeof objA !== 'object' || objA === null || typeof objB !== 'object' || objB === null) {
        return false;
      }

      var keysA = Object.keys(objA);
      var keysB = Object.keys(objB);

      if (keysA.length !== keysB.length) {
        return false;
      } // Test for A's keys different from B.


      for (var i = 0; i < keysA.length; i++) {
        if (!hasOwnProperty$2.call(objB, keysA[i]) || !is$1(objA[keysA[i]], objB[keysA[i]])) {
          return false;
        }
      }

      return true;
    }

    var skipSelectionChangeEvent = canUseDOM && 'documentMode' in document && document.documentMode <= 11;
    var eventTypes$4 = {
      select: {
        phasedRegistrationNames: {
          bubbled: 'onSelect',
          captured: 'onSelectCapture'
        },
        dependencies: [TOP_BLUR, TOP_CONTEXT_MENU, TOP_DRAG_END, TOP_FOCUS, TOP_KEY_DOWN, TOP_KEY_UP, TOP_MOUSE_DOWN, TOP_MOUSE_UP, TOP_SELECTION_CHANGE]
      }
    };
    var activeElement$1 = null;
    var activeElementInst$1 = null;
    var lastSelection = null;
    var mouseDown = false;
    /**
     * Get an object which is a unique representation of the current selection.
     *
     * The return value will not be consistent across nodes or browsers, but
     * two identical selections on the same node will return identical objects.
     *
     * @param {DOMElement} node
     * @return {object}
     */

    function getSelection$1(node) {
      if ('selectionStart' in node && hasSelectionCapabilities(node)) {
        return {
          start: node.selectionStart,
          end: node.selectionEnd
        };
      } else {
        var win = node.ownerDocument && node.ownerDocument.defaultView || window;
        var selection = win.getSelection();
        return {
          anchorNode: selection.anchorNode,
          anchorOffset: selection.anchorOffset,
          focusNode: selection.focusNode,
          focusOffset: selection.focusOffset
        };
      }
    }
    /**
     * Get document associated with the event target.
     *
     * @param {object} nativeEventTarget
     * @return {Document}
     */


    function getEventTargetDocument(eventTarget) {
      return eventTarget.window === eventTarget ? eventTarget.document : eventTarget.nodeType === DOCUMENT_NODE ? eventTarget : eventTarget.ownerDocument;
    }
    /**
     * Poll selection to see whether it's changed.
     *
     * @param {object} nativeEvent
     * @param {object} nativeEventTarget
     * @return {?SyntheticEvent}
     */


    function constructSelectEvent(nativeEvent, nativeEventTarget) {
      // Ensure we have the right element, and that the user is not dragging a
      // selection (this matches native `select` event behavior). In HTML5, select
      // fires only on input and textarea thus if there's no focused element we
      // won't dispatch.
      var doc = getEventTargetDocument(nativeEventTarget);

      if (mouseDown || activeElement$1 == null || activeElement$1 !== getActiveElement(doc)) {
        return null;
      } // Only fire when selection has actually changed.


      var currentSelection = getSelection$1(activeElement$1);

      if (!lastSelection || !shallowEqual(lastSelection, currentSelection)) {
        lastSelection = currentSelection;
        var syntheticEvent = SyntheticEvent.getPooled(eventTypes$4.select, activeElementInst$1, nativeEvent, nativeEventTarget);
        syntheticEvent.type = 'select';
        syntheticEvent.target = activeElement$1;
        accumulateTwoPhaseDispatches(syntheticEvent);
        return syntheticEvent;
      }

      return null;
    }
    /**
     * This plugin creates an `onSelect` event that normalizes select events
     * across form elements.
     *
     * Supported elements are:
     * - input (see `isTextInputElement`)
     * - textarea
     * - contentEditable
     *
     * This differs from native browser implementations in the following ways:
     * - Fires on contentEditable fields as well as inputs.
     * - Fires for collapsed selection.
     * - Fires after user input.
     */


    var SelectEventPlugin = {
      eventTypes: eventTypes$4,
      extractEvents: function (topLevelType, targetInst, nativeEvent, nativeEventTarget, eventSystemFlags) {
        var doc = getEventTargetDocument(nativeEventTarget); // Track whether all listeners exists for this plugin. If none exist, we do
        // not extract events. See #3639.

        if (!doc || !isListeningToAllDependencies('onSelect', doc)) {
          return null;
        }

        var targetNode = targetInst ? getNodeFromInstance$1(targetInst) : window;

        switch (topLevelType) {
          // Track the input node that has focus.
          case TOP_FOCUS:
            if (isTextInputElement(targetNode) || targetNode.contentEditable === 'true') {
              activeElement$1 = targetNode;
              activeElementInst$1 = targetInst;
              lastSelection = null;
            }

            break;

          case TOP_BLUR:
            activeElement$1 = null;
            activeElementInst$1 = null;
            lastSelection = null;
            break;
          // Don't fire the event while the user is dragging. This matches the
          // semantics of the native select event.

          case TOP_MOUSE_DOWN:
            mouseDown = true;
            break;

          case TOP_CONTEXT_MENU:
          case TOP_MOUSE_UP:
          case TOP_DRAG_END:
            mouseDown = false;
            return constructSelectEvent(nativeEvent, nativeEventTarget);
          // Chrome and IE fire non-standard event when selection is changed (and
          // sometimes when it hasn't). IE's event fires out of order with respect
          // to key and input events on deletion, so we discard it.
          //
          // Firefox doesn't support selectionchange, so check selection status
          // after each key entry. The selection changes after keydown and before
          // keyup, but we check on keydown as well in the case of holding down a
          // key, when multiple keydown events are fired but only one keyup is.
          // This is also our approach for IE handling, for the reason above.

          case TOP_SELECTION_CHANGE:
            if (skipSelectionChangeEvent) {
              break;
            }

          // falls through

          case TOP_KEY_DOWN:
          case TOP_KEY_UP:
            return constructSelectEvent(nativeEvent, nativeEventTarget);
        }

        return null;
      }
    };
    /**
     * Inject modules for resolving DOM hierarchy and plugin ordering.
     */

    injection.injectEventPluginOrder(DOMEventPluginOrder);
    setComponentTree(getFiberCurrentPropsFromNode$1, getInstanceFromNode$1, getNodeFromInstance$1);
    /**
     * Some important event plugins included by default (without having to require
     * them).
     */

    injection.injectEventPluginsByName({
      SimpleEventPlugin: SimpleEventPlugin,
      EnterLeaveEventPlugin: EnterLeaveEventPlugin,
      ChangeEventPlugin: ChangeEventPlugin,
      SelectEventPlugin: SelectEventPlugin,
      BeforeInputEventPlugin: BeforeInputEventPlugin
    }); // Prefix measurements so that it's possible to filter them.
    // Longer prefixes are hard to read in DevTools.

    var reactEmoji = "\u269B";
    var warningEmoji = "\u26D4";
    var supportsUserTiming = typeof performance !== 'undefined' && typeof performance.mark === 'function' && typeof performance.clearMarks === 'function' && typeof performance.measure === 'function' && typeof performance.clearMeasures === 'function'; // Keep track of current fiber so that we know the path to unwind on pause.
    // TODO: this looks the same as nextUnitOfWork in scheduler. Can we unify them?

    var currentFiber = null; // If we're in the middle of user code, which fiber and method is it?
    // Reusing `currentFiber` would be confusing for this because user code fiber
    // can change during commit phase too, but we don't need to unwind it (since
    // lifecycles in the commit phase don't resemble a tree).

    var currentPhase = null;
    var currentPhaseFiber = null; // Did lifecycle hook schedule an update? This is often a performance problem,
    // so we will keep track of it, and include it in the report.
    // Track commits caused by cascading updates.

    var isCommitting = false;
    var hasScheduledUpdateInCurrentCommit = false;
    var hasScheduledUpdateInCurrentPhase = false;
    var commitCountInCurrentWorkLoop = 0;
    var effectCountInCurrentCommit = 0; // to avoid stretch the commit phase with measurement overhead.

    var labelsInCurrentCommit = new Set();

    var formatMarkName = function (markName) {
      return reactEmoji + " " + markName;
    };

    var formatLabel = function (label, warning) {
      var prefix = warning ? warningEmoji + " " : reactEmoji + " ";
      var suffix = warning ? " Warning: " + warning : '';
      return "" + prefix + label + suffix;
    };

    var beginMark = function (markName) {
      performance.mark(formatMarkName(markName));
    };

    var clearMark = function (markName) {
      performance.clearMarks(formatMarkName(markName));
    };

    var endMark = function (label, markName, warning) {
      var formattedMarkName = formatMarkName(markName);
      var formattedLabel = formatLabel(label, warning);

      try {
        performance.measure(formattedLabel, formattedMarkName);
      } catch (err) {} // If previous mark was missing for some reason, this will throw.
      // This could only happen if React crashed in an unexpected place earlier.
      // Don't pile on with more errors.
      // Clear marks immediately to avoid growing buffer.


      performance.clearMarks(formattedMarkName);
      performance.clearMeasures(formattedLabel);
    };

    var getFiberMarkName = function (label, debugID) {
      return label + " (#" + debugID + ")";
    };

    var getFiberLabel = function (componentName, isMounted, phase) {
      if (phase === null) {
        // These are composite component total time measurements.
        return componentName + " [" + (isMounted ? 'update' : 'mount') + "]";
      } else {
        // Composite component methods.
        return componentName + "." + phase;
      }
    };

    var beginFiberMark = function (fiber, phase) {
      var componentName = getComponentName(fiber.type) || 'Unknown';
      var debugID = fiber._debugID;
      var isMounted = fiber.alternate !== null;
      var label = getFiberLabel(componentName, isMounted, phase);

      if (isCommitting && labelsInCurrentCommit.has(label)) {
        // During the commit phase, we don't show duplicate labels because
        // there is a fixed overhead for every measurement, and we don't
        // want to stretch the commit phase beyond necessary.
        return false;
      }

      labelsInCurrentCommit.add(label);
      var markName = getFiberMarkName(label, debugID);
      beginMark(markName);
      return true;
    };

    var clearFiberMark = function (fiber, phase) {
      var componentName = getComponentName(fiber.type) || 'Unknown';
      var debugID = fiber._debugID;
      var isMounted = fiber.alternate !== null;
      var label = getFiberLabel(componentName, isMounted, phase);
      var markName = getFiberMarkName(label, debugID);
      clearMark(markName);
    };

    var endFiberMark = function (fiber, phase, warning) {
      var componentName = getComponentName(fiber.type) || 'Unknown';
      var debugID = fiber._debugID;
      var isMounted = fiber.alternate !== null;
      var label = getFiberLabel(componentName, isMounted, phase);
      var markName = getFiberMarkName(label, debugID);
      endMark(label, markName, warning);
    };

    var shouldIgnoreFiber = function (fiber) {
      // Host components should be skipped in the timeline.
      // We could check typeof fiber.type, but does this work with RN?
      switch (fiber.tag) {
        case HostRoot:
        case HostComponent:
        case HostText:
        case HostPortal:
        case Fragment:
        case ContextProvider:
        case ContextConsumer:
        case Mode:
          return true;

        default:
          return false;
      }
    };

    var clearPendingPhaseMeasurement = function () {
      if (currentPhase !== null && currentPhaseFiber !== null) {
        clearFiberMark(currentPhaseFiber, currentPhase);
      }

      currentPhaseFiber = null;
      currentPhase = null;
      hasScheduledUpdateInCurrentPhase = false;
    };

    var pauseTimers = function () {
      // Stops all currently active measurements so that they can be resumed
      // if we continue in a later deferred loop from the same unit of work.
      var fiber = currentFiber;

      while (fiber) {
        if (fiber._debugIsCurrentlyTiming) {
          endFiberMark(fiber, null, null);
        }

        fiber = fiber.return;
      }
    };

    var resumeTimersRecursively = function (fiber) {
      if (fiber.return !== null) {
        resumeTimersRecursively(fiber.return);
      }

      if (fiber._debugIsCurrentlyTiming) {
        beginFiberMark(fiber, null);
      }
    };

    var resumeTimers = function () {
      // Resumes all measurements that were active during the last deferred loop.
      if (currentFiber !== null) {
        resumeTimersRecursively(currentFiber);
      }
    };

    function recordEffect() {
      if (enableUserTimingAPI) {
        effectCountInCurrentCommit++;
      }
    }

    function recordScheduleUpdate() {
      if (enableUserTimingAPI) {
        if (isCommitting) {
          hasScheduledUpdateInCurrentCommit = true;
        }

        if (currentPhase !== null && currentPhase !== 'componentWillMount' && currentPhase !== 'componentWillReceiveProps') {
          hasScheduledUpdateInCurrentPhase = true;
        }
      }
    }

    function startWorkTimer(fiber) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming || shouldIgnoreFiber(fiber)) {
          return;
        } // If we pause, this is the fiber to unwind from.


        currentFiber = fiber;

        if (!beginFiberMark(fiber, null)) {
          return;
        }

        fiber._debugIsCurrentlyTiming = true;
      }
    }

    function cancelWorkTimer(fiber) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming || shouldIgnoreFiber(fiber)) {
          return;
        } // Remember we shouldn't complete measurement for this fiber.
        // Otherwise flamechart will be deep even for small updates.


        fiber._debugIsCurrentlyTiming = false;
        clearFiberMark(fiber, null);
      }
    }

    function stopWorkTimer(fiber) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming || shouldIgnoreFiber(fiber)) {
          return;
        } // If we pause, its parent is the fiber to unwind from.


        currentFiber = fiber.return;

        if (!fiber._debugIsCurrentlyTiming) {
          return;
        }

        fiber._debugIsCurrentlyTiming = false;
        endFiberMark(fiber, null, null);
      }
    }

    function stopFailedWorkTimer(fiber) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming || shouldIgnoreFiber(fiber)) {
          return;
        } // If we pause, its parent is the fiber to unwind from.


        currentFiber = fiber.return;

        if (!fiber._debugIsCurrentlyTiming) {
          return;
        }

        fiber._debugIsCurrentlyTiming = false;
        var warning = fiber.tag === SuspenseComponent ? 'Rendering was suspended' : 'An error was thrown inside this error boundary';
        endFiberMark(fiber, null, warning);
      }
    }

    function startPhaseTimer(fiber, phase) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        clearPendingPhaseMeasurement();

        if (!beginFiberMark(fiber, phase)) {
          return;
        }

        currentPhaseFiber = fiber;
        currentPhase = phase;
      }
    }

    function stopPhaseTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        if (currentPhase !== null && currentPhaseFiber !== null) {
          var warning = hasScheduledUpdateInCurrentPhase ? 'Scheduled a cascading update' : null;
          endFiberMark(currentPhaseFiber, currentPhase, warning);
        }

        currentPhase = null;
        currentPhaseFiber = null;
      }
    }

    function startWorkLoopTimer(nextUnitOfWork) {
      if (enableUserTimingAPI) {
        currentFiber = nextUnitOfWork;

        if (!supportsUserTiming) {
          return;
        }

        commitCountInCurrentWorkLoop = 0; // This is top level call.
        // Any other measurements are performed within.

        beginMark('(React Tree Reconciliation)'); // Resume any measurements that were in progress during the last loop.

        resumeTimers();
      }
    }

    function stopWorkLoopTimer(interruptedBy, didCompleteRoot) {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        var warning = null;

        if (interruptedBy !== null) {
          if (interruptedBy.tag === HostRoot) {
            warning = 'A top-level update interrupted the previous render';
          } else {
            var componentName = getComponentName(interruptedBy.type) || 'Unknown';
            warning = "An update to " + componentName + " interrupted the previous render";
          }
        } else if (commitCountInCurrentWorkLoop > 1) {
          warning = 'There were cascading updates';
        }

        commitCountInCurrentWorkLoop = 0;
        var label = didCompleteRoot ? '(React Tree Reconciliation: Completed Root)' : '(React Tree Reconciliation: Yielded)'; // Pause any measurements until the next loop.

        pauseTimers();
        endMark(label, '(React Tree Reconciliation)', warning);
      }
    }

    function startCommitTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        isCommitting = true;
        hasScheduledUpdateInCurrentCommit = false;
        labelsInCurrentCommit.clear();
        beginMark('(Committing Changes)');
      }
    }

    function stopCommitTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        var warning = null;

        if (hasScheduledUpdateInCurrentCommit) {
          warning = 'Lifecycle hook scheduled a cascading update';
        } else if (commitCountInCurrentWorkLoop > 0) {
          warning = 'Caused by a cascading update in earlier commit';
        }

        hasScheduledUpdateInCurrentCommit = false;
        commitCountInCurrentWorkLoop++;
        isCommitting = false;
        labelsInCurrentCommit.clear();
        endMark('(Committing Changes)', '(Committing Changes)', warning);
      }
    }

    function startCommitSnapshotEffectsTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        effectCountInCurrentCommit = 0;
        beginMark('(Committing Snapshot Effects)');
      }
    }

    function stopCommitSnapshotEffectsTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        var count = effectCountInCurrentCommit;
        effectCountInCurrentCommit = 0;
        endMark("(Committing Snapshot Effects: " + count + " Total)", '(Committing Snapshot Effects)', null);
      }
    }

    function startCommitHostEffectsTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        effectCountInCurrentCommit = 0;
        beginMark('(Committing Host Effects)');
      }
    }

    function stopCommitHostEffectsTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        var count = effectCountInCurrentCommit;
        effectCountInCurrentCommit = 0;
        endMark("(Committing Host Effects: " + count + " Total)", '(Committing Host Effects)', null);
      }
    }

    function startCommitLifeCyclesTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        effectCountInCurrentCommit = 0;
        beginMark('(Calling Lifecycle Methods)');
      }
    }

    function stopCommitLifeCyclesTimer() {
      if (enableUserTimingAPI) {
        if (!supportsUserTiming) {
          return;
        }

        var count = effectCountInCurrentCommit;
        effectCountInCurrentCommit = 0;
        endMark("(Calling Lifecycle Methods: " + count + " Total)", '(Calling Lifecycle Methods)', null);
      }
    }

    var valueStack = [];
    var fiberStack;
    {
      fiberStack = [];
    }
    var index = -1;

    function createCursor(defaultValue) {
      return {
        current: defaultValue
      };
    }

    function pop(cursor, fiber) {
      if (index < 0) {
        {
          warningWithoutStack$1(false, 'Unexpected pop.');
        }
        return;
      }

      {
        if (fiber !== fiberStack[index]) {
          warningWithoutStack$1(false, 'Unexpected Fiber popped.');
        }
      }
      cursor.current = valueStack[index];
      valueStack[index] = null;
      {
        fiberStack[index] = null;
      }
      index--;
    }

    function push(cursor, value, fiber) {
      index++;
      valueStack[index] = cursor.current;
      {
        fiberStack[index] = fiber;
      }
      cursor.current = value;
    }

    var warnedAboutMissingGetChildContext;
    {
      warnedAboutMissingGetChildContext = {};
    }
    var emptyContextObject = {};
    {
      Object.freeze(emptyContextObject);
    } // A cursor to the current merged context object on the stack.

    var contextStackCursor = createCursor(emptyContextObject); // A cursor to a boolean indicating whether the context has changed.

    var didPerformWorkStackCursor = createCursor(false); // Keep track of the previous context object that was on the stack.
    // We use this to get access to the parent context after we have already
    // pushed the next context provider, and now need to merge their contexts.

    var previousContext = emptyContextObject;

    function getUnmaskedContext(workInProgress, Component, didPushOwnContextIfProvider) {
      if (disableLegacyContext) {
        return emptyContextObject;
      } else {
        if (didPushOwnContextIfProvider && isContextProvider(Component)) {
          // If the fiber is a context provider itself, when we read its context
          // we may have already pushed its own child context on the stack. A context
          // provider should not "see" its own child context. Therefore we read the
          // previous (parent) context instead for a context provider.
          return previousContext;
        }

        return contextStackCursor.current;
      }
    }

    function cacheContext(workInProgress, unmaskedContext, maskedContext) {
      if (disableLegacyContext) {
        return;
      } else {
        var instance = workInProgress.stateNode;
        instance.__reactInternalMemoizedUnmaskedChildContext = unmaskedContext;
        instance.__reactInternalMemoizedMaskedChildContext = maskedContext;
      }
    }

    function getMaskedContext(workInProgress, unmaskedContext) {
      if (disableLegacyContext) {
        return emptyContextObject;
      } else {
        var type = workInProgress.type;
        var contextTypes = type.contextTypes;

        if (!contextTypes) {
          return emptyContextObject;
        } // Avoid recreating masked context unless unmasked context has changed.
        // Failing to do this will result in unnecessary calls to componentWillReceiveProps.
        // This may trigger infinite loops if componentWillReceiveProps calls setState.


        var instance = workInProgress.stateNode;

        if (instance && instance.__reactInternalMemoizedUnmaskedChildContext === unmaskedContext) {
          return instance.__reactInternalMemoizedMaskedChildContext;
        }

        var context = {};

        for (var key in contextTypes) {
          context[key] = unmaskedContext[key];
        }

        {
          var name = getComponentName(type) || 'Unknown';
          checkPropTypes(contextTypes, context, 'context', name, getCurrentFiberStackInDev);
        } // Cache unmasked context so we can avoid recreating masked context unless necessary.
        // Context is created before the class component is instantiated so check for instance.

        if (instance) {
          cacheContext(workInProgress, unmaskedContext, context);
        }

        return context;
      }
    }

    function hasContextChanged() {
      if (disableLegacyContext) {
        return false;
      } else {
        return didPerformWorkStackCursor.current;
      }
    }

    function isContextProvider(type) {
      if (disableLegacyContext) {
        return false;
      } else {
        var childContextTypes = type.childContextTypes;
        return childContextTypes !== null && childContextTypes !== undefined;
      }
    }

    function popContext(fiber) {
      if (disableLegacyContext) {
        return;
      } else {
        pop(didPerformWorkStackCursor, fiber);
        pop(contextStackCursor, fiber);
      }
    }

    function popTopLevelContextObject(fiber) {
      if (disableLegacyContext) {
        return;
      } else {
        pop(didPerformWorkStackCursor, fiber);
        pop(contextStackCursor, fiber);
      }
    }

    function pushTopLevelContextObject(fiber, context, didChange) {
      if (disableLegacyContext) {
        return;
      } else {
        if (!(contextStackCursor.current === emptyContextObject)) {
          {
            throw Error("Unexpected context found on stack. This error is likely caused by a bug in React. Please file an issue.");
          }
        }

        push(contextStackCursor, context, fiber);
        push(didPerformWorkStackCursor, didChange, fiber);
      }
    }

    function processChildContext(fiber, type, parentContext) {
      if (disableLegacyContext) {
        return parentContext;
      } else {
        var instance = fiber.stateNode;
        var childContextTypes = type.childContextTypes; // TODO (bvaughn) Replace this behavior with an invariant() in the future.
        // It has only been added in Fiber to match the (unintentional) behavior in Stack.

        if (typeof instance.getChildContext !== 'function') {
          {
            var componentName = getComponentName(type) || 'Unknown';

            if (!warnedAboutMissingGetChildContext[componentName]) {
              warnedAboutMissingGetChildContext[componentName] = true;
              warningWithoutStack$1(false, '%s.childContextTypes is specified but there is no getChildContext() method ' + 'on the instance. You can either define getChildContext() on %s or remove ' + 'childContextTypes from it.', componentName, componentName);
            }
          }
          return parentContext;
        }

        var childContext;
        {
          setCurrentPhase('getChildContext');
        }
        startPhaseTimer(fiber, 'getChildContext');
        childContext = instance.getChildContext();
        stopPhaseTimer();
        {
          setCurrentPhase(null);
        }

        for (var contextKey in childContext) {
          if (!(contextKey in childContextTypes)) {
            {
              throw Error((getComponentName(type) || 'Unknown') + ".getChildContext(): key \"" + contextKey + "\" is not defined in childContextTypes.");
            }
          }
        }

        {
          var name = getComponentName(type) || 'Unknown';
          checkPropTypes(childContextTypes, childContext, 'child context', name, // In practice, there is one case in which we won't get a stack. It's when
          // somebody calls unstable_renderSubtreeIntoContainer() and we process
          // context from the parent component instance. The stack will be missing
          // because it's outside of the reconciliation, and so the pointer has not
          // been set. This is rare and doesn't matter. We'll also remove that API.
          getCurrentFiberStackInDev);
        }
        return _assign({}, parentContext, {}, childContext);
      }
    }

    function pushContextProvider(workInProgress) {
      if (disableLegacyContext) {
        return false;
      } else {
        var instance = workInProgress.stateNode; // We push the context as early as possible to ensure stack integrity.
        // If the instance does not exist yet, we will push null at first,
        // and replace it on the stack later when invalidating the context.

        var memoizedMergedChildContext = instance && instance.__reactInternalMemoizedMergedChildContext || emptyContextObject; // Remember the parent context so we can merge with it later.
        // Inherit the parent's did-perform-work value to avoid inadvertently blocking updates.

        previousContext = contextStackCursor.current;
        push(contextStackCursor, memoizedMergedChildContext, workInProgress);
        push(didPerformWorkStackCursor, didPerformWorkStackCursor.current, workInProgress);
        return true;
      }
    }

    function invalidateContextProvider(workInProgress, type, didChange) {
      if (disableLegacyContext) {
        return;
      } else {
        var instance = workInProgress.stateNode;

        if (!instance) {
          {
            throw Error("Expected to have an instance by this point. This error is likely caused by a bug in React. Please file an issue.");
          }
        }

        if (didChange) {
          // Merge parent and own context.
          // Skip this if we're not updating due to sCU.
          // This avoids unnecessarily recomputing memoized values.
          var mergedContext = processChildContext(workInProgress, type, previousContext);
          instance.__reactInternalMemoizedMergedChildContext = mergedContext; // Replace the old (or empty) context with the new one.
          // It is important to unwind the context in the reverse order.

          pop(didPerformWorkStackCursor, workInProgress);
          pop(contextStackCursor, workInProgress); // Now push the new context and mark that it has changed.

          push(contextStackCursor, mergedContext, workInProgress);
          push(didPerformWorkStackCursor, didChange, workInProgress);
        } else {
          pop(didPerformWorkStackCursor, workInProgress);
          push(didPerformWorkStackCursor, didChange, workInProgress);
        }
      }
    }

    function findCurrentUnmaskedContext(fiber) {
      if (disableLegacyContext) {
        return emptyContextObject;
      } else {
        // Currently this is only used with renderSubtreeIntoContainer; not sure if it
        // makes sense elsewhere
        if (!(isFiberMounted(fiber) && fiber.tag === ClassComponent)) {
          {
            throw Error("Expected subtree parent to be a mounted class component. This error is likely caused by a bug in React. Please file an issue.");
          }
        }

        var node = fiber;

        do {
          switch (node.tag) {
            case HostRoot:
              return node.stateNode.context;

            case ClassComponent:
              {
                var Component = node.type;

                if (isContextProvider(Component)) {
                  return node.stateNode.__reactInternalMemoizedMergedChildContext;
                }

                break;
              }
          }

          node = node.return;
        } while (node !== null);

        {
          {
            throw Error("Found unexpected detached subtree parent. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }
    }

    var LegacyRoot = 0;
    var BlockingRoot = 1;
    var ConcurrentRoot = 2; // Intentionally not named imports because Rollup would use dynamic dispatch for
    // CommonJS interop named imports.

    var Scheduler_runWithPriority = Scheduler.unstable_runWithPriority;
    var Scheduler_scheduleCallback = Scheduler.unstable_scheduleCallback;
    var Scheduler_cancelCallback = Scheduler.unstable_cancelCallback;
    var Scheduler_shouldYield = Scheduler.unstable_shouldYield;
    var Scheduler_requestPaint = Scheduler.unstable_requestPaint;
    var Scheduler_now = Scheduler.unstable_now;
    var Scheduler_getCurrentPriorityLevel = Scheduler.unstable_getCurrentPriorityLevel;
    var Scheduler_ImmediatePriority = Scheduler.unstable_ImmediatePriority;
    var Scheduler_UserBlockingPriority = Scheduler.unstable_UserBlockingPriority;
    var Scheduler_NormalPriority = Scheduler.unstable_NormalPriority;
    var Scheduler_LowPriority = Scheduler.unstable_LowPriority;
    var Scheduler_IdlePriority = Scheduler.unstable_IdlePriority;

    if (enableSchedulerTracing) {
      // Provide explicit error message when production+profiling bundle of e.g.
      // react-dom is used with production (non-profiling) bundle of
      // scheduler/tracing
      if (!(tracing.__interactionsRef != null && tracing.__interactionsRef.current != null)) {
        {
          throw Error("It is not supported to run the profiling version of a renderer (for example, `react-dom/profiling`) without also replacing the `scheduler/tracing` module with `scheduler/tracing-profiling`. Your bundler might have a setting for aliasing both modules. Learn more at http://fb.me/react-profiling");
        }
      }
    }

    var fakeCallbackNode = {}; // Except for NoPriority, these correspond to Scheduler priorities. We use
    // ascending numbers so we can compare them like numbers. They start at 90 to
    // avoid clashing with Scheduler's priorities.

    var ImmediatePriority = 99;
    var UserBlockingPriority$2 = 98;
    var NormalPriority = 97;
    var LowPriority = 96;
    var IdlePriority = 95; // NoPriority is the absence of priority. Also React-only.

    var NoPriority = 90;
    var shouldYield = Scheduler_shouldYield;
    var requestPaint = // Fall back gracefully if we're running an older version of Scheduler.
    Scheduler_requestPaint !== undefined ? Scheduler_requestPaint : function () {};
    var syncQueue = null;
    var immediateQueueCallbackNode = null;
    var isFlushingSyncQueue = false;
    var initialTimeMs = Scheduler_now(); // If the initial timestamp is reasonably small, use Scheduler's `now` directly.
    // This will be the case for modern browsers that support `performance.now`. In
    // older browsers, Scheduler falls back to `Date.now`, which returns a Unix
    // timestamp. In that case, subtract the module initialization time to simulate
    // the behavior of performance.now and keep our times small enough to fit
    // within 32 bits.
    // TODO: Consider lifting this into Scheduler.

    var now = initialTimeMs < 10000 ? Scheduler_now : function () {
      return Scheduler_now() - initialTimeMs;
    };

    function getCurrentPriorityLevel() {
      switch (Scheduler_getCurrentPriorityLevel()) {
        case Scheduler_ImmediatePriority:
          return ImmediatePriority;

        case Scheduler_UserBlockingPriority:
          return UserBlockingPriority$2;

        case Scheduler_NormalPriority:
          return NormalPriority;

        case Scheduler_LowPriority:
          return LowPriority;

        case Scheduler_IdlePriority:
          return IdlePriority;

        default:
          {
            {
              throw Error("Unknown priority level.");
            }
          }
      }
    }

    function reactPriorityToSchedulerPriority(reactPriorityLevel) {
      switch (reactPriorityLevel) {
        case ImmediatePriority:
          return Scheduler_ImmediatePriority;

        case UserBlockingPriority$2:
          return Scheduler_UserBlockingPriority;

        case NormalPriority:
          return Scheduler_NormalPriority;

        case LowPriority:
          return Scheduler_LowPriority;

        case IdlePriority:
          return Scheduler_IdlePriority;

        default:
          {
            {
              throw Error("Unknown priority level.");
            }
          }
      }
    }

    function runWithPriority$2(reactPriorityLevel, fn) {
      var priorityLevel = reactPriorityToSchedulerPriority(reactPriorityLevel);
      return Scheduler_runWithPriority(priorityLevel, fn);
    }

    function scheduleCallback(reactPriorityLevel, callback, options) {
      var priorityLevel = reactPriorityToSchedulerPriority(reactPriorityLevel);
      return Scheduler_scheduleCallback(priorityLevel, callback, options);
    }

    function scheduleSyncCallback(callback) {
      // Push this callback into an internal queue. We'll flush these either in
      // the next tick, or earlier if something calls `flushSyncCallbackQueue`.
      if (syncQueue === null) {
        syncQueue = [callback]; // Flush the queue in the next tick, at the earliest.

        immediateQueueCallbackNode = Scheduler_scheduleCallback(Scheduler_ImmediatePriority, flushSyncCallbackQueueImpl);
      } else {
        // Push onto existing queue. Don't need to schedule a callback because
        // we already scheduled one when we created the queue.
        syncQueue.push(callback);
      }

      return fakeCallbackNode;
    }

    function cancelCallback(callbackNode) {
      if (callbackNode !== fakeCallbackNode) {
        Scheduler_cancelCallback(callbackNode);
      }
    }

    function flushSyncCallbackQueue() {
      if (immediateQueueCallbackNode !== null) {
        var node = immediateQueueCallbackNode;
        immediateQueueCallbackNode = null;
        Scheduler_cancelCallback(node);
      }

      flushSyncCallbackQueueImpl();
    }

    function flushSyncCallbackQueueImpl() {
      if (!isFlushingSyncQueue && syncQueue !== null) {
        // Prevent re-entrancy.
        isFlushingSyncQueue = true;
        var i = 0;

        try {
          var _isSync = true;
          var queue = syncQueue;
          runWithPriority$2(ImmediatePriority, function () {
            for (; i < queue.length; i++) {
              var callback = queue[i];

              do {
                callback = callback(_isSync);
              } while (callback !== null);
            }
          });
          syncQueue = null;
        } catch (error) {
          // If something throws, leave the remaining callbacks on the queue.
          if (syncQueue !== null) {
            syncQueue = syncQueue.slice(i + 1);
          } // Resume flushing in the next tick


          Scheduler_scheduleCallback(Scheduler_ImmediatePriority, flushSyncCallbackQueue);
          throw error;
        } finally {
          isFlushingSyncQueue = false;
        }
      }
    }

    var NoMode = 0;
    var StrictMode = 1; // TODO: Remove BlockingMode and ConcurrentMode by reading from the root
    // tag instead

    var BlockingMode = 2;
    var ConcurrentMode = 4;
    var ProfileMode = 8; // Max 31 bit integer. The max integer size in V8 for 32-bit systems.
    // Math.pow(2, 30) - 1
    // 0b111111111111111111111111111111

    var MAX_SIGNED_31_BIT_INT = 1073741823;
    var NoWork = 0; // TODO: Think of a better name for Never. The key difference with Idle is that
    // Never work can be committed in an inconsistent state without tearing the UI.
    // The main example is offscreen content, like a hidden subtree. So one possible
    // name is Offscreen. However, it also includes dehydrated Suspense boundaries,
    // which are inconsistent in the sense that they haven't finished yet, but
    // aren't visibly inconsistent because the server rendered HTML matches what the
    // hydrated tree would look like.

    var Never = 1; // Idle is slightly higher priority than Never. It must completely finish in
    // order to be consistent.

    var Idle = 2; // Continuous Hydration is a moving priority. It is slightly higher than Idle
    // and is used to increase priority of hover targets. It is increasing with
    // each usage so that last always wins.

    var ContinuousHydration = 3;
    var Sync = MAX_SIGNED_31_BIT_INT;
    var Batched = Sync - 1;
    var UNIT_SIZE = 10;
    var MAGIC_NUMBER_OFFSET = Batched - 1; // 1 unit of expiration time represents 10ms.

    function msToExpirationTime(ms) {
      // Always add an offset so that we don't clash with the magic number for NoWork.
      return MAGIC_NUMBER_OFFSET - (ms / UNIT_SIZE | 0);
    }

    function expirationTimeToMs(expirationTime) {
      return (MAGIC_NUMBER_OFFSET - expirationTime) * UNIT_SIZE;
    }

    function ceiling(num, precision) {
      return ((num / precision | 0) + 1) * precision;
    }

    function computeExpirationBucket(currentTime, expirationInMs, bucketSizeMs) {
      return MAGIC_NUMBER_OFFSET - ceiling(MAGIC_NUMBER_OFFSET - currentTime + expirationInMs / UNIT_SIZE, bucketSizeMs / UNIT_SIZE);
    } // TODO: This corresponds to Scheduler's NormalPriority, not LowPriority. Update
    // the names to reflect.


    var LOW_PRIORITY_EXPIRATION = 5000;
    var LOW_PRIORITY_BATCH_SIZE = 250;

    function computeAsyncExpiration(currentTime) {
      return computeExpirationBucket(currentTime, LOW_PRIORITY_EXPIRATION, LOW_PRIORITY_BATCH_SIZE);
    }

    function computeSuspenseExpiration(currentTime, timeoutMs) {
      // TODO: Should we warn if timeoutMs is lower than the normal pri expiration time?
      return computeExpirationBucket(currentTime, timeoutMs, LOW_PRIORITY_BATCH_SIZE);
    } // We intentionally set a higher expiration time for interactive updates in
    // dev than in production.
    //
    // If the main thread is being blocked so long that you hit the expiration,
    // it's a problem that could be solved with better scheduling.
    //
    // People will be more likely to notice this and fix it with the long
    // expiration time in development.
    //
    // In production we opt for better UX at the risk of masking scheduling
    // problems, by expiring fast.


    var HIGH_PRIORITY_EXPIRATION = 500;
    var HIGH_PRIORITY_BATCH_SIZE = 100;

    function computeInteractiveExpiration(currentTime) {
      return computeExpirationBucket(currentTime, HIGH_PRIORITY_EXPIRATION, HIGH_PRIORITY_BATCH_SIZE);
    }

    function computeContinuousHydrationExpiration(currentTime) {
      // Each time we ask for a new one of these we increase the priority.
      // This ensures that the last one always wins since we can't deprioritize
      // once we've scheduled work already.
      return ContinuousHydration++;
    }

    function inferPriorityFromExpirationTime(currentTime, expirationTime) {
      if (expirationTime === Sync) {
        return ImmediatePriority;
      }

      if (expirationTime === Never || expirationTime === Idle) {
        return IdlePriority;
      }

      var msUntil = expirationTimeToMs(expirationTime) - expirationTimeToMs(currentTime);

      if (msUntil <= 0) {
        return ImmediatePriority;
      }

      if (msUntil <= HIGH_PRIORITY_EXPIRATION + HIGH_PRIORITY_BATCH_SIZE) {
        return UserBlockingPriority$2;
      }

      if (msUntil <= LOW_PRIORITY_EXPIRATION + LOW_PRIORITY_BATCH_SIZE) {
        return NormalPriority;
      } // TODO: Handle LowPriority
      // Assume anything lower has idle priority


      return IdlePriority;
    }
    /**
     * Forked from fbjs/warning:
     * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
     *
     * Only change is we use console.warn instead of console.error,
     * and do nothing when 'console' is not supported.
     * This really simplifies the code.
     * ---
     * Similar to invariant but only logs a warning if the condition is not met.
     * This can be used to log issues in development environments in critical
     * paths. Removing the logging code for production environments will keep the
     * same logic and follow the same code paths.
     */


    var lowPriorityWarningWithoutStack = function () {};

    {
      var printWarning = function (format) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        var argIndex = 0;
        var message = 'Warning: ' + format.replace(/%s/g, function () {
          return args[argIndex++];
        });

        if (typeof console !== 'undefined') {
          console.warn(message);
        }

        try {
          // --- Welcome to debugging React ---
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch (x) {}
      };

      lowPriorityWarningWithoutStack = function (condition, format) {
        if (format === undefined) {
          throw new Error('`lowPriorityWarningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
        }

        if (!condition) {
          for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
            args[_key2 - 2] = arguments[_key2];
          }

          printWarning.apply(void 0, [format].concat(args));
        }
      };
    }
    var lowPriorityWarningWithoutStack$1 = lowPriorityWarningWithoutStack;
    var ReactStrictModeWarnings = {
      recordUnsafeLifecycleWarnings: function (fiber, instance) {},
      flushPendingUnsafeLifecycleWarnings: function () {},
      recordLegacyContextWarning: function (fiber, instance) {},
      flushLegacyContextWarning: function () {},
      discardPendingWarnings: function () {}
    };
    {
      var findStrictRoot = function (fiber) {
        var maybeStrictRoot = null;
        var node = fiber;

        while (node !== null) {
          if (node.mode & StrictMode) {
            maybeStrictRoot = node;
          }

          node = node.return;
        }

        return maybeStrictRoot;
      };

      var setToSortedString = function (set) {
        var array = [];
        set.forEach(function (value) {
          array.push(value);
        });
        return array.sort().join(', ');
      };

      var pendingComponentWillMountWarnings = [];
      var pendingUNSAFE_ComponentWillMountWarnings = [];
      var pendingComponentWillReceivePropsWarnings = [];
      var pendingUNSAFE_ComponentWillReceivePropsWarnings = [];
      var pendingComponentWillUpdateWarnings = [];
      var pendingUNSAFE_ComponentWillUpdateWarnings = []; // Tracks components we have already warned about.

      var didWarnAboutUnsafeLifecycles = new Set();

      ReactStrictModeWarnings.recordUnsafeLifecycleWarnings = function (fiber, instance) {
        // Dedup strategy: Warn once per component.
        if (didWarnAboutUnsafeLifecycles.has(fiber.type)) {
          return;
        }

        if (typeof instance.componentWillMount === 'function' && // Don't warn about react-lifecycles-compat polyfilled components.
        instance.componentWillMount.__suppressDeprecationWarning !== true) {
          pendingComponentWillMountWarnings.push(fiber);
        }

        if (fiber.mode & StrictMode && typeof instance.UNSAFE_componentWillMount === 'function') {
          pendingUNSAFE_ComponentWillMountWarnings.push(fiber);
        }

        if (typeof instance.componentWillReceiveProps === 'function' && instance.componentWillReceiveProps.__suppressDeprecationWarning !== true) {
          pendingComponentWillReceivePropsWarnings.push(fiber);
        }

        if (fiber.mode & StrictMode && typeof instance.UNSAFE_componentWillReceiveProps === 'function') {
          pendingUNSAFE_ComponentWillReceivePropsWarnings.push(fiber);
        }

        if (typeof instance.componentWillUpdate === 'function' && instance.componentWillUpdate.__suppressDeprecationWarning !== true) {
          pendingComponentWillUpdateWarnings.push(fiber);
        }

        if (fiber.mode & StrictMode && typeof instance.UNSAFE_componentWillUpdate === 'function') {
          pendingUNSAFE_ComponentWillUpdateWarnings.push(fiber);
        }
      };

      ReactStrictModeWarnings.flushPendingUnsafeLifecycleWarnings = function () {
        // We do an initial pass to gather component names
        var componentWillMountUniqueNames = new Set();

        if (pendingComponentWillMountWarnings.length > 0) {
          pendingComponentWillMountWarnings.forEach(function (fiber) {
            componentWillMountUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingComponentWillMountWarnings = [];
        }

        var UNSAFE_componentWillMountUniqueNames = new Set();

        if (pendingUNSAFE_ComponentWillMountWarnings.length > 0) {
          pendingUNSAFE_ComponentWillMountWarnings.forEach(function (fiber) {
            UNSAFE_componentWillMountUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingUNSAFE_ComponentWillMountWarnings = [];
        }

        var componentWillReceivePropsUniqueNames = new Set();

        if (pendingComponentWillReceivePropsWarnings.length > 0) {
          pendingComponentWillReceivePropsWarnings.forEach(function (fiber) {
            componentWillReceivePropsUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingComponentWillReceivePropsWarnings = [];
        }

        var UNSAFE_componentWillReceivePropsUniqueNames = new Set();

        if (pendingUNSAFE_ComponentWillReceivePropsWarnings.length > 0) {
          pendingUNSAFE_ComponentWillReceivePropsWarnings.forEach(function (fiber) {
            UNSAFE_componentWillReceivePropsUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingUNSAFE_ComponentWillReceivePropsWarnings = [];
        }

        var componentWillUpdateUniqueNames = new Set();

        if (pendingComponentWillUpdateWarnings.length > 0) {
          pendingComponentWillUpdateWarnings.forEach(function (fiber) {
            componentWillUpdateUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingComponentWillUpdateWarnings = [];
        }

        var UNSAFE_componentWillUpdateUniqueNames = new Set();

        if (pendingUNSAFE_ComponentWillUpdateWarnings.length > 0) {
          pendingUNSAFE_ComponentWillUpdateWarnings.forEach(function (fiber) {
            UNSAFE_componentWillUpdateUniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutUnsafeLifecycles.add(fiber.type);
          });
          pendingUNSAFE_ComponentWillUpdateWarnings = [];
        } // Finally, we flush all the warnings
        // UNSAFE_ ones before the deprecated ones, since they'll be 'louder'


        if (UNSAFE_componentWillMountUniqueNames.size > 0) {
          var sortedNames = setToSortedString(UNSAFE_componentWillMountUniqueNames);
          warningWithoutStack$1(false, 'Using UNSAFE_componentWillMount in strict mode is not recommended and may indicate bugs in your code. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move code with side effects to componentDidMount, and set initial state in the constructor.\n' + '\nPlease update the following components: %s', sortedNames);
        }

        if (UNSAFE_componentWillReceivePropsUniqueNames.size > 0) {
          var _sortedNames = setToSortedString(UNSAFE_componentWillReceivePropsUniqueNames);

          warningWithoutStack$1(false, 'Using UNSAFE_componentWillReceiveProps in strict mode is not recommended ' + 'and may indicate bugs in your code. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move data fetching code or side effects to componentDidUpdate.\n' + "* If you're updating state whenever props change, " + 'refactor your code to use memoization techniques or move it to ' + 'static getDerivedStateFromProps. Learn more at: https://fb.me/react-derived-state\n' + '\nPlease update the following components: %s', _sortedNames);
        }

        if (UNSAFE_componentWillUpdateUniqueNames.size > 0) {
          var _sortedNames2 = setToSortedString(UNSAFE_componentWillUpdateUniqueNames);

          warningWithoutStack$1(false, 'Using UNSAFE_componentWillUpdate in strict mode is not recommended ' + 'and may indicate bugs in your code. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move data fetching code or side effects to componentDidUpdate.\n' + '\nPlease update the following components: %s', _sortedNames2);
        }

        if (componentWillMountUniqueNames.size > 0) {
          var _sortedNames3 = setToSortedString(componentWillMountUniqueNames);

          lowPriorityWarningWithoutStack$1(false, 'componentWillMount has been renamed, and is not recommended for use. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move code with side effects to componentDidMount, and set initial state in the constructor.\n' + '* Rename componentWillMount to UNSAFE_componentWillMount to suppress ' + 'this warning in non-strict mode. In React 17.x, only the UNSAFE_ name will work. ' + 'To rename all deprecated lifecycles to their new names, you can run ' + '`npx react-codemod rename-unsafe-lifecycles` in your project source folder.\n' + '\nPlease update the following components: %s', _sortedNames3);
        }

        if (componentWillReceivePropsUniqueNames.size > 0) {
          var _sortedNames4 = setToSortedString(componentWillReceivePropsUniqueNames);

          lowPriorityWarningWithoutStack$1(false, 'componentWillReceiveProps has been renamed, and is not recommended for use. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move data fetching code or side effects to componentDidUpdate.\n' + "* If you're updating state whenever props change, refactor your " + 'code to use memoization techniques or move it to ' + 'static getDerivedStateFromProps. Learn more at: https://fb.me/react-derived-state\n' + '* Rename componentWillReceiveProps to UNSAFE_componentWillReceiveProps to suppress ' + 'this warning in non-strict mode. In React 17.x, only the UNSAFE_ name will work. ' + 'To rename all deprecated lifecycles to their new names, you can run ' + '`npx react-codemod rename-unsafe-lifecycles` in your project source folder.\n' + '\nPlease update the following components: %s', _sortedNames4);
        }

        if (componentWillUpdateUniqueNames.size > 0) {
          var _sortedNames5 = setToSortedString(componentWillUpdateUniqueNames);

          lowPriorityWarningWithoutStack$1(false, 'componentWillUpdate has been renamed, and is not recommended for use. ' + 'See https://fb.me/react-unsafe-component-lifecycles for details.\n\n' + '* Move data fetching code or side effects to componentDidUpdate.\n' + '* Rename componentWillUpdate to UNSAFE_componentWillUpdate to suppress ' + 'this warning in non-strict mode. In React 17.x, only the UNSAFE_ name will work. ' + 'To rename all deprecated lifecycles to their new names, you can run ' + '`npx react-codemod rename-unsafe-lifecycles` in your project source folder.\n' + '\nPlease update the following components: %s', _sortedNames5);
        }
      };

      var pendingLegacyContextWarning = new Map(); // Tracks components we have already warned about.

      var didWarnAboutLegacyContext = new Set();

      ReactStrictModeWarnings.recordLegacyContextWarning = function (fiber, instance) {
        var strictRoot = findStrictRoot(fiber);

        if (strictRoot === null) {
          warningWithoutStack$1(false, 'Expected to find a StrictMode component in a strict mode tree. ' + 'This error is likely caused by a bug in React. Please file an issue.');
          return;
        } // Dedup strategy: Warn once per component.


        if (didWarnAboutLegacyContext.has(fiber.type)) {
          return;
        }

        var warningsForRoot = pendingLegacyContextWarning.get(strictRoot);

        if (fiber.type.contextTypes != null || fiber.type.childContextTypes != null || instance !== null && typeof instance.getChildContext === 'function') {
          if (warningsForRoot === undefined) {
            warningsForRoot = [];
            pendingLegacyContextWarning.set(strictRoot, warningsForRoot);
          }

          warningsForRoot.push(fiber);
        }
      };

      ReactStrictModeWarnings.flushLegacyContextWarning = function () {
        pendingLegacyContextWarning.forEach(function (fiberArray, strictRoot) {
          var uniqueNames = new Set();
          fiberArray.forEach(function (fiber) {
            uniqueNames.add(getComponentName(fiber.type) || 'Component');
            didWarnAboutLegacyContext.add(fiber.type);
          });
          var sortedNames = setToSortedString(uniqueNames);
          var strictRootComponentStack = getStackByFiberInDevAndProd(strictRoot);
          warningWithoutStack$1(false, 'Legacy context API has been detected within a strict-mode tree.' + '\n\nThe old API will be supported in all 16.x releases, but applications ' + 'using it should migrate to the new version.' + '\n\nPlease update the following components: %s' + '\n\nLearn more about this warning here: https://fb.me/react-legacy-context' + '%s', sortedNames, strictRootComponentStack);
        });
      };

      ReactStrictModeWarnings.discardPendingWarnings = function () {
        pendingComponentWillMountWarnings = [];
        pendingUNSAFE_ComponentWillMountWarnings = [];
        pendingComponentWillReceivePropsWarnings = [];
        pendingUNSAFE_ComponentWillReceivePropsWarnings = [];
        pendingComponentWillUpdateWarnings = [];
        pendingUNSAFE_ComponentWillUpdateWarnings = [];
        pendingLegacyContextWarning = new Map();
      };
    }
    var resolveFamily = null; // $FlowFixMe Flow gets confused by a WeakSet feature check below.

    var failedBoundaries = null;

    var setRefreshHandler = function (handler) {
      {
        resolveFamily = handler;
      }
    };

    function resolveFunctionForHotReloading(type) {
      {
        if (resolveFamily === null) {
          // Hot reloading is disabled.
          return type;
        }

        var family = resolveFamily(type);

        if (family === undefined) {
          return type;
        } // Use the latest known implementation.


        return family.current;
      }
    }

    function resolveClassForHotReloading(type) {
      // No implementation differences.
      return resolveFunctionForHotReloading(type);
    }

    function resolveForwardRefForHotReloading(type) {
      {
        if (resolveFamily === null) {
          // Hot reloading is disabled.
          return type;
        }

        var family = resolveFamily(type);

        if (family === undefined) {
          // Check if we're dealing with a real forwardRef. Don't want to crash early.
          if (type !== null && type !== undefined && typeof type.render === 'function') {
            // ForwardRef is special because its resolved .type is an object,
            // but it's possible that we only have its inner render function in the map.
            // If that inner render function is different, we'll build a new forwardRef type.
            var currentRender = resolveFunctionForHotReloading(type.render);

            if (type.render !== currentRender) {
              var syntheticType = {
                $$typeof: REACT_FORWARD_REF_TYPE,
                render: currentRender
              };

              if (type.displayName !== undefined) {
                syntheticType.displayName = type.displayName;
              }

              return syntheticType;
            }
          }

          return type;
        } // Use the latest known implementation.


        return family.current;
      }
    }

    function isCompatibleFamilyForHotReloading(fiber, element) {
      {
        if (resolveFamily === null) {
          // Hot reloading is disabled.
          return false;
        }

        var prevType = fiber.elementType;
        var nextType = element.type; // If we got here, we know types aren't === equal.

        var needsCompareFamilies = false;
        var $$typeofNextType = typeof nextType === 'object' && nextType !== null ? nextType.$$typeof : null;

        switch (fiber.tag) {
          case ClassComponent:
            {
              if (typeof nextType === 'function') {
                needsCompareFamilies = true;
              }

              break;
            }

          case FunctionComponent:
            {
              if (typeof nextType === 'function') {
                needsCompareFamilies = true;
              } else if ($$typeofNextType === REACT_LAZY_TYPE) {
                // We don't know the inner type yet.
                // We're going to assume that the lazy inner type is stable,
                // and so it is sufficient to avoid reconciling it away.
                // We're not going to unwrap or actually use the new lazy type.
                needsCompareFamilies = true;
              }

              break;
            }

          case ForwardRef:
            {
              if ($$typeofNextType === REACT_FORWARD_REF_TYPE) {
                needsCompareFamilies = true;
              } else if ($$typeofNextType === REACT_LAZY_TYPE) {
                needsCompareFamilies = true;
              }

              break;
            }

          case MemoComponent:
          case SimpleMemoComponent:
            {
              if ($$typeofNextType === REACT_MEMO_TYPE) {
                // TODO: if it was but can no longer be simple,
                // we shouldn't set this.
                needsCompareFamilies = true;
              } else if ($$typeofNextType === REACT_LAZY_TYPE) {
                needsCompareFamilies = true;
              }

              break;
            }

          default:
            return false;
        } // Check if both types have a family and it's the same one.


        if (needsCompareFamilies) {
          // Note: memo() and forwardRef() we'll compare outer rather than inner type.
          // This means both of them need to be registered to preserve state.
          // If we unwrapped and compared the inner types for wrappers instead,
          // then we would risk falsely saying two separate memo(Foo)
          // calls are equivalent because they wrap the same Foo function.
          var prevFamily = resolveFamily(prevType);

          if (prevFamily !== undefined && prevFamily === resolveFamily(nextType)) {
            return true;
          }
        }

        return false;
      }
    }

    function markFailedErrorBoundaryForHotReloading(fiber) {
      {
        if (resolveFamily === null) {
          // Hot reloading is disabled.
          return;
        }

        if (typeof WeakSet !== 'function') {
          return;
        }

        if (failedBoundaries === null) {
          failedBoundaries = new WeakSet();
        }

        failedBoundaries.add(fiber);
      }
    }

    var scheduleRefresh = function (root, update) {
      {
        if (resolveFamily === null) {
          // Hot reloading is disabled.
          return;
        }

        var staleFamilies = update.staleFamilies,
            updatedFamilies = update.updatedFamilies;
        flushPassiveEffects();
        flushSync(function () {
          scheduleFibersWithFamiliesRecursively(root.current, updatedFamilies, staleFamilies);
        });
      }
    };

    var scheduleRoot = function (root, element) {
      {
        if (root.context !== emptyContextObject) {
          // Super edge case: root has a legacy _renderSubtree context
          // but we don't know the parentComponent so we can't pass it.
          // Just ignore. We'll delete this with _renderSubtree code path later.
          return;
        }

        flushPassiveEffects();
        syncUpdates(function () {
          updateContainer(element, root, null, null);
        });
      }
    };

    function scheduleFibersWithFamiliesRecursively(fiber, updatedFamilies, staleFamilies) {
      {
        var alternate = fiber.alternate,
            child = fiber.child,
            sibling = fiber.sibling,
            tag = fiber.tag,
            type = fiber.type;
        var candidateType = null;

        switch (tag) {
          case FunctionComponent:
          case SimpleMemoComponent:
          case ClassComponent:
            candidateType = type;
            break;

          case ForwardRef:
            candidateType = type.render;
            break;

          default:
            break;
        }

        if (resolveFamily === null) {
          throw new Error('Expected resolveFamily to be set during hot reload.');
        }

        var needsRender = false;
        var needsRemount = false;

        if (candidateType !== null) {
          var family = resolveFamily(candidateType);

          if (family !== undefined) {
            if (staleFamilies.has(family)) {
              needsRemount = true;
            } else if (updatedFamilies.has(family)) {
              if (tag === ClassComponent) {
                needsRemount = true;
              } else {
                needsRender = true;
              }
            }
          }
        }

        if (failedBoundaries !== null) {
          if (failedBoundaries.has(fiber) || alternate !== null && failedBoundaries.has(alternate)) {
            needsRemount = true;
          }
        }

        if (needsRemount) {
          fiber._debugNeedsRemount = true;
        }

        if (needsRemount || needsRender) {
          scheduleWork(fiber, Sync);
        }

        if (child !== null && !needsRemount) {
          scheduleFibersWithFamiliesRecursively(child, updatedFamilies, staleFamilies);
        }

        if (sibling !== null) {
          scheduleFibersWithFamiliesRecursively(sibling, updatedFamilies, staleFamilies);
        }
      }
    }

    var findHostInstancesForRefresh = function (root, families) {
      {
        var hostInstances = new Set();
        var types = new Set(families.map(function (family) {
          return family.current;
        }));
        findHostInstancesForMatchingFibersRecursively(root.current, types, hostInstances);
        return hostInstances;
      }
    };

    function findHostInstancesForMatchingFibersRecursively(fiber, types, hostInstances) {
      {
        var child = fiber.child,
            sibling = fiber.sibling,
            tag = fiber.tag,
            type = fiber.type;
        var candidateType = null;

        switch (tag) {
          case FunctionComponent:
          case SimpleMemoComponent:
          case ClassComponent:
            candidateType = type;
            break;

          case ForwardRef:
            candidateType = type.render;
            break;

          default:
            break;
        }

        var didMatch = false;

        if (candidateType !== null) {
          if (types.has(candidateType)) {
            didMatch = true;
          }
        }

        if (didMatch) {
          // We have a match. This only drills down to the closest host components.
          // There's no need to search deeper because for the purpose of giving
          // visual feedback, "flashing" outermost parent rectangles is sufficient.
          findHostInstancesForFiberShallowly(fiber, hostInstances);
        } else {
          // If there's no match, maybe there will be one further down in the child tree.
          if (child !== null) {
            findHostInstancesForMatchingFibersRecursively(child, types, hostInstances);
          }
        }

        if (sibling !== null) {
          findHostInstancesForMatchingFibersRecursively(sibling, types, hostInstances);
        }
      }
    }

    function findHostInstancesForFiberShallowly(fiber, hostInstances) {
      {
        var foundHostInstances = findChildHostInstancesForFiberShallowly(fiber, hostInstances);

        if (foundHostInstances) {
          return;
        } // If we didn't find any host children, fallback to closest host parent.


        var node = fiber;

        while (true) {
          switch (node.tag) {
            case HostComponent:
              hostInstances.add(node.stateNode);
              return;

            case HostPortal:
              hostInstances.add(node.stateNode.containerInfo);
              return;

            case HostRoot:
              hostInstances.add(node.stateNode.containerInfo);
              return;
          }

          if (node.return === null) {
            throw new Error('Expected to reach root first.');
          }

          node = node.return;
        }
      }
    }

    function findChildHostInstancesForFiberShallowly(fiber, hostInstances) {
      {
        var node = fiber;
        var foundHostInstances = false;

        while (true) {
          if (node.tag === HostComponent) {
            // We got a match.
            foundHostInstances = true;
            hostInstances.add(node.stateNode); // There may still be more, so keep searching.
          } else if (node.child !== null) {
            node.child.return = node;
            node = node.child;
            continue;
          }

          if (node === fiber) {
            return foundHostInstances;
          }

          while (node.sibling === null) {
            if (node.return === null || node.return === fiber) {
              return foundHostInstances;
            }

            node = node.return;
          }

          node.sibling.return = node.return;
          node = node.sibling;
        }
      }
      return false;
    }

    function resolveDefaultProps(Component, baseProps) {
      if (Component && Component.defaultProps) {
        // Resolve default props. Taken from ReactElement
        var props = _assign({}, baseProps);

        var defaultProps = Component.defaultProps;

        for (var propName in defaultProps) {
          if (props[propName] === undefined) {
            props[propName] = defaultProps[propName];
          }
        }

        return props;
      }

      return baseProps;
    }

    function readLazyComponentType(lazyComponent) {
      initializeLazyComponentType(lazyComponent);

      if (lazyComponent._status !== Resolved) {
        throw lazyComponent._result;
      }

      return lazyComponent._result;
    }

    var valueCursor = createCursor(null);
    var rendererSigil;
    {
      // Use this to detect multiple renderers using the same context
      rendererSigil = {};
    }
    var currentlyRenderingFiber = null;
    var lastContextDependency = null;
    var lastContextWithAllBitsObserved = null;
    var isDisallowedContextReadInDEV = false;

    function resetContextDependencies() {
      // This is called right before React yields execution, to ensure `readContext`
      // cannot be called outside the render phase.
      currentlyRenderingFiber = null;
      lastContextDependency = null;
      lastContextWithAllBitsObserved = null;
      {
        isDisallowedContextReadInDEV = false;
      }
    }

    function enterDisallowedContextReadInDEV() {
      {
        isDisallowedContextReadInDEV = true;
      }
    }

    function exitDisallowedContextReadInDEV() {
      {
        isDisallowedContextReadInDEV = false;
      }
    }

    function pushProvider(providerFiber, nextValue) {
      var context = providerFiber.type._context;

      if (isPrimaryRenderer) {
        push(valueCursor, context._currentValue, providerFiber);
        context._currentValue = nextValue;
        {
          !(context._currentRenderer === undefined || context._currentRenderer === null || context._currentRenderer === rendererSigil) ? warningWithoutStack$1(false, 'Detected multiple renderers concurrently rendering the ' + 'same context provider. This is currently unsupported.') : void 0;
          context._currentRenderer = rendererSigil;
        }
      } else {
        push(valueCursor, context._currentValue2, providerFiber);
        context._currentValue2 = nextValue;
        {
          !(context._currentRenderer2 === undefined || context._currentRenderer2 === null || context._currentRenderer2 === rendererSigil) ? warningWithoutStack$1(false, 'Detected multiple renderers concurrently rendering the ' + 'same context provider. This is currently unsupported.') : void 0;
          context._currentRenderer2 = rendererSigil;
        }
      }
    }

    function popProvider(providerFiber) {
      var currentValue = valueCursor.current;
      pop(valueCursor, providerFiber);
      var context = providerFiber.type._context;

      if (isPrimaryRenderer) {
        context._currentValue = currentValue;
      } else {
        context._currentValue2 = currentValue;
      }
    }

    function calculateChangedBits(context, newValue, oldValue) {
      if (is$1(oldValue, newValue)) {
        // No change
        return 0;
      } else {
        var changedBits = typeof context._calculateChangedBits === 'function' ? context._calculateChangedBits(oldValue, newValue) : MAX_SIGNED_31_BIT_INT;
        {
          !((changedBits & MAX_SIGNED_31_BIT_INT) === changedBits) ? warning$1(false, 'calculateChangedBits: Expected the return value to be a ' + '31-bit integer. Instead received: %s', changedBits) : void 0;
        }
        return changedBits | 0;
      }
    }

    function scheduleWorkOnParentPath(parent, renderExpirationTime) {
      // Update the child expiration time of all the ancestors, including
      // the alternates.
      var node = parent;

      while (node !== null) {
        var alternate = node.alternate;

        if (node.childExpirationTime < renderExpirationTime) {
          node.childExpirationTime = renderExpirationTime;

          if (alternate !== null && alternate.childExpirationTime < renderExpirationTime) {
            alternate.childExpirationTime = renderExpirationTime;
          }
        } else if (alternate !== null && alternate.childExpirationTime < renderExpirationTime) {
          alternate.childExpirationTime = renderExpirationTime;
        } else {
          // Neither alternate was updated, which means the rest of the
          // ancestor path already has sufficient priority.
          break;
        }

        node = node.return;
      }
    }

    function propagateContextChange(workInProgress, context, changedBits, renderExpirationTime) {
      var fiber = workInProgress.child;

      if (fiber !== null) {
        // Set the return pointer of the child to the work-in-progress fiber.
        fiber.return = workInProgress;
      }

      while (fiber !== null) {
        var nextFiber = void 0; // Visit this fiber.

        var list = fiber.dependencies;

        if (list !== null) {
          nextFiber = fiber.child;
          var dependency = list.firstContext;

          while (dependency !== null) {
            // Check if the context matches.
            if (dependency.context === context && (dependency.observedBits & changedBits) !== 0) {
              // Match! Schedule an update on this fiber.
              if (fiber.tag === ClassComponent) {
                // Schedule a force update on the work-in-progress.
                var update = createUpdate(renderExpirationTime, null);
                update.tag = ForceUpdate; // TODO: Because we don't have a work-in-progress, this will add the
                // update to the current fiber, too, which means it will persist even if
                // this render is thrown away. Since it's a race condition, not sure it's
                // worth fixing.

                enqueueUpdate(fiber, update);
              }

              if (fiber.expirationTime < renderExpirationTime) {
                fiber.expirationTime = renderExpirationTime;
              }

              var alternate = fiber.alternate;

              if (alternate !== null && alternate.expirationTime < renderExpirationTime) {
                alternate.expirationTime = renderExpirationTime;
              }

              scheduleWorkOnParentPath(fiber.return, renderExpirationTime); // Mark the expiration time on the list, too.

              if (list.expirationTime < renderExpirationTime) {
                list.expirationTime = renderExpirationTime;
              } // Since we already found a match, we can stop traversing the
              // dependency list.


              break;
            }

            dependency = dependency.next;
          }
        } else if (fiber.tag === ContextProvider) {
          // Don't scan deeper if this is a matching provider
          nextFiber = fiber.type === workInProgress.type ? null : fiber.child;
        } else if (enableSuspenseServerRenderer && fiber.tag === DehydratedFragment) {
          // If a dehydrated suspense bounudary is in this subtree, we don't know
          // if it will have any context consumers in it. The best we can do is
          // mark it as having updates.
          var parentSuspense = fiber.return;

          if (!(parentSuspense !== null)) {
            {
              throw Error("We just came from a parent so we must have had a parent. This is a bug in React.");
            }
          }

          if (parentSuspense.expirationTime < renderExpirationTime) {
            parentSuspense.expirationTime = renderExpirationTime;
          }

          var _alternate = parentSuspense.alternate;

          if (_alternate !== null && _alternate.expirationTime < renderExpirationTime) {
            _alternate.expirationTime = renderExpirationTime;
          } // This is intentionally passing this fiber as the parent
          // because we want to schedule this fiber as having work
          // on its children. We'll use the childExpirationTime on
          // this fiber to indicate that a context has changed.


          scheduleWorkOnParentPath(parentSuspense, renderExpirationTime);
          nextFiber = fiber.sibling;
        } else {
          // Traverse down.
          nextFiber = fiber.child;
        }

        if (nextFiber !== null) {
          // Set the return pointer of the child to the work-in-progress fiber.
          nextFiber.return = fiber;
        } else {
          // No child. Traverse to next sibling.
          nextFiber = fiber;

          while (nextFiber !== null) {
            if (nextFiber === workInProgress) {
              // We're back to the root of this subtree. Exit.
              nextFiber = null;
              break;
            }

            var sibling = nextFiber.sibling;

            if (sibling !== null) {
              // Set the return pointer of the sibling to the work-in-progress fiber.
              sibling.return = nextFiber.return;
              nextFiber = sibling;
              break;
            } // No more siblings. Traverse up.


            nextFiber = nextFiber.return;
          }
        }

        fiber = nextFiber;
      }
    }

    function prepareToReadContext(workInProgress, renderExpirationTime) {
      currentlyRenderingFiber = workInProgress;
      lastContextDependency = null;
      lastContextWithAllBitsObserved = null;
      var dependencies = workInProgress.dependencies;

      if (dependencies !== null) {
        var firstContext = dependencies.firstContext;

        if (firstContext !== null) {
          if (dependencies.expirationTime >= renderExpirationTime) {
            // Context list has a pending update. Mark that this fiber performed work.
            markWorkInProgressReceivedUpdate();
          } // Reset the work-in-progress list


          dependencies.firstContext = null;
        }
      }
    }

    function readContext(context, observedBits) {
      {
        // This warning would fire if you read context inside a Hook like useMemo.
        // Unlike the class check below, it's not enforced in production for perf.
        !!isDisallowedContextReadInDEV ? warning$1(false, 'Context can only be read while React is rendering. ' + 'In classes, you can read it in the render method or getDerivedStateFromProps. ' + 'In function components, you can read it directly in the function body, but not ' + 'inside Hooks like useReducer() or useMemo().') : void 0;
      }

      if (lastContextWithAllBitsObserved === context) {// Nothing to do. We already observe everything in this context.
      } else if (observedBits === false || observedBits === 0) {// Do not observe any updates.
      } else {
        var resolvedObservedBits; // Avoid deopting on observable arguments or heterogeneous types.

        if (typeof observedBits !== 'number' || observedBits === MAX_SIGNED_31_BIT_INT) {
          // Observe all updates.
          lastContextWithAllBitsObserved = context;
          resolvedObservedBits = MAX_SIGNED_31_BIT_INT;
        } else {
          resolvedObservedBits = observedBits;
        }

        var contextItem = {
          context: context,
          observedBits: resolvedObservedBits,
          next: null
        };

        if (lastContextDependency === null) {
          if (!(currentlyRenderingFiber !== null)) {
            {
              throw Error("Context can only be read while React is rendering. In classes, you can read it in the render method or getDerivedStateFromProps. In function components, you can read it directly in the function body, but not inside Hooks like useReducer() or useMemo().");
            }
          } // This is the first dependency for this component. Create a new list.


          lastContextDependency = contextItem;
          currentlyRenderingFiber.dependencies = {
            expirationTime: NoWork,
            firstContext: contextItem,
            responders: null
          };
        } else {
          // Append a new context item.
          lastContextDependency = lastContextDependency.next = contextItem;
        }
      }

      return isPrimaryRenderer ? context._currentValue : context._currentValue2;
    } // UpdateQueue is a linked list of prioritized updates.
    //
    // Like fibers, update queues come in pairs: a current queue, which represents
    // the visible state of the screen, and a work-in-progress queue, which can be
    // mutated and processed asynchronously before it is committed — a form of
    // double buffering. If a work-in-progress render is discarded before finishing,
    // we create a new work-in-progress by cloning the current queue.
    //
    // Both queues share a persistent, singly-linked list structure. To schedule an
    // update, we append it to the end of both queues. Each queue maintains a
    // pointer to first update in the persistent list that hasn't been processed.
    // The work-in-progress pointer always has a position equal to or greater than
    // the current queue, since we always work on that one. The current queue's
    // pointer is only updated during the commit phase, when we swap in the
    // work-in-progress.
    //
    // For example:
    //
    //   Current pointer:           A - B - C - D - E - F
    //   Work-in-progress pointer:              D - E - F
    //                                          ^
    //                                          The work-in-progress queue has
    //                                          processed more updates than current.
    //
    // The reason we append to both queues is because otherwise we might drop
    // updates without ever processing them. For example, if we only add updates to
    // the work-in-progress queue, some updates could be lost whenever a work-in
    // -progress render restarts by cloning from current. Similarly, if we only add
    // updates to the current queue, the updates will be lost whenever an already
    // in-progress queue commits and swaps with the current queue. However, by
    // adding to both queues, we guarantee that the update will be part of the next
    // work-in-progress. (And because the work-in-progress queue becomes the
    // current queue once it commits, there's no danger of applying the same
    // update twice.)
    //
    // Prioritization
    // --------------
    //
    // Updates are not sorted by priority, but by insertion; new updates are always
    // appended to the end of the list.
    //
    // The priority is still important, though. When processing the update queue
    // during the render phase, only the updates with sufficient priority are
    // included in the result. If we skip an update because it has insufficient
    // priority, it remains in the queue to be processed later, during a lower
    // priority render. Crucially, all updates subsequent to a skipped update also
    // remain in the queue *regardless of their priority*. That means high priority
    // updates are sometimes processed twice, at two separate priorities. We also
    // keep track of a base state, that represents the state before the first
    // update in the queue is applied.
    //
    // For example:
    //
    //   Given a base state of '', and the following queue of updates
    //
    //     A1 - B2 - C1 - D2
    //
    //   where the number indicates the priority, and the update is applied to the
    //   previous state by appending a letter, React will process these updates as
    //   two separate renders, one per distinct priority level:
    //
    //   First render, at priority 1:
    //     Base state: ''
    //     Updates: [A1, C1]
    //     Result state: 'AC'
    //
    //   Second render, at priority 2:
    //     Base state: 'A'            <-  The base state does not include C1,
    //                                    because B2 was skipped.
    //     Updates: [B2, C1, D2]      <-  C1 was rebased on top of B2
    //     Result state: 'ABCD'
    //
    // Because we process updates in insertion order, and rebase high priority
    // updates when preceding updates are skipped, the final result is deterministic
    // regardless of priority. Intermediate state may vary according to system
    // resources, but the final state is always the same.


    var UpdateState = 0;
    var ReplaceState = 1;
    var ForceUpdate = 2;
    var CaptureUpdate = 3; // Global state that is reset at the beginning of calling `processUpdateQueue`.
    // It should only be read right after calling `processUpdateQueue`, via
    // `checkHasForceUpdateAfterProcessing`.

    var hasForceUpdate = false;
    var didWarnUpdateInsideUpdate;
    var currentlyProcessingQueue;
    {
      didWarnUpdateInsideUpdate = false;
      currentlyProcessingQueue = null;
    }

    function createUpdateQueue(baseState) {
      var queue = {
        baseState: baseState,
        firstUpdate: null,
        lastUpdate: null,
        firstCapturedUpdate: null,
        lastCapturedUpdate: null,
        firstEffect: null,
        lastEffect: null,
        firstCapturedEffect: null,
        lastCapturedEffect: null
      };
      return queue;
    }

    function cloneUpdateQueue(currentQueue) {
      var queue = {
        baseState: currentQueue.baseState,
        firstUpdate: currentQueue.firstUpdate,
        lastUpdate: currentQueue.lastUpdate,
        // TODO: With resuming, if we bail out and resuse the child tree, we should
        // keep these effects.
        firstCapturedUpdate: null,
        lastCapturedUpdate: null,
        firstEffect: null,
        lastEffect: null,
        firstCapturedEffect: null,
        lastCapturedEffect: null
      };
      return queue;
    }

    function createUpdate(expirationTime, suspenseConfig) {
      var update = {
        expirationTime: expirationTime,
        suspenseConfig: suspenseConfig,
        tag: UpdateState,
        payload: null,
        callback: null,
        next: null,
        nextEffect: null
      };
      {
        update.priority = getCurrentPriorityLevel();
      }
      return update;
    }

    function appendUpdateToQueue(queue, update) {
      // Append the update to the end of the list.
      if (queue.lastUpdate === null) {
        // Queue is empty
        queue.firstUpdate = queue.lastUpdate = update;
      } else {
        queue.lastUpdate.next = update;
        queue.lastUpdate = update;
      }
    }

    function enqueueUpdate(fiber, update) {
      // Update queues are created lazily.
      var alternate = fiber.alternate;
      var queue1;
      var queue2;

      if (alternate === null) {
        // There's only one fiber.
        queue1 = fiber.updateQueue;
        queue2 = null;

        if (queue1 === null) {
          queue1 = fiber.updateQueue = createUpdateQueue(fiber.memoizedState);
        }
      } else {
        // There are two owners.
        queue1 = fiber.updateQueue;
        queue2 = alternate.updateQueue;

        if (queue1 === null) {
          if (queue2 === null) {
            // Neither fiber has an update queue. Create new ones.
            queue1 = fiber.updateQueue = createUpdateQueue(fiber.memoizedState);
            queue2 = alternate.updateQueue = createUpdateQueue(alternate.memoizedState);
          } else {
            // Only one fiber has an update queue. Clone to create a new one.
            queue1 = fiber.updateQueue = cloneUpdateQueue(queue2);
          }
        } else {
          if (queue2 === null) {
            // Only one fiber has an update queue. Clone to create a new one.
            queue2 = alternate.updateQueue = cloneUpdateQueue(queue1);
          } else {// Both owners have an update queue.
          }
        }
      }

      if (queue2 === null || queue1 === queue2) {
        // There's only a single queue.
        appendUpdateToQueue(queue1, update);
      } else {
        // There are two queues. We need to append the update to both queues,
        // while accounting for the persistent structure of the list — we don't
        // want the same update to be added multiple times.
        if (queue1.lastUpdate === null || queue2.lastUpdate === null) {
          // One of the queues is not empty. We must add the update to both queues.
          appendUpdateToQueue(queue1, update);
          appendUpdateToQueue(queue2, update);
        } else {
          // Both queues are non-empty. The last update is the same in both lists,
          // because of structural sharing. So, only append to one of the lists.
          appendUpdateToQueue(queue1, update); // But we still need to update the `lastUpdate` pointer of queue2.

          queue2.lastUpdate = update;
        }
      }

      {
        if (fiber.tag === ClassComponent && (currentlyProcessingQueue === queue1 || queue2 !== null && currentlyProcessingQueue === queue2) && !didWarnUpdateInsideUpdate) {
          warningWithoutStack$1(false, 'An update (setState, replaceState, or forceUpdate) was scheduled ' + 'from inside an update function. Update functions should be pure, ' + 'with zero side-effects. Consider using componentDidUpdate or a ' + 'callback.');
          didWarnUpdateInsideUpdate = true;
        }
      }
    }

    function enqueueCapturedUpdate(workInProgress, update) {
      // Captured updates go into a separate list, and only on the work-in-
      // progress queue.
      var workInProgressQueue = workInProgress.updateQueue;

      if (workInProgressQueue === null) {
        workInProgressQueue = workInProgress.updateQueue = createUpdateQueue(workInProgress.memoizedState);
      } else {
        // TODO: I put this here rather than createWorkInProgress so that we don't
        // clone the queue unnecessarily. There's probably a better way to
        // structure this.
        workInProgressQueue = ensureWorkInProgressQueueIsAClone(workInProgress, workInProgressQueue);
      } // Append the update to the end of the list.


      if (workInProgressQueue.lastCapturedUpdate === null) {
        // This is the first render phase update
        workInProgressQueue.firstCapturedUpdate = workInProgressQueue.lastCapturedUpdate = update;
      } else {
        workInProgressQueue.lastCapturedUpdate.next = update;
        workInProgressQueue.lastCapturedUpdate = update;
      }
    }

    function ensureWorkInProgressQueueIsAClone(workInProgress, queue) {
      var current = workInProgress.alternate;

      if (current !== null) {
        // If the work-in-progress queue is equal to the current queue,
        // we need to clone it first.
        if (queue === current.updateQueue) {
          queue = workInProgress.updateQueue = cloneUpdateQueue(queue);
        }
      }

      return queue;
    }

    function getStateFromUpdate(workInProgress, queue, update, prevState, nextProps, instance) {
      switch (update.tag) {
        case ReplaceState:
          {
            var payload = update.payload;

            if (typeof payload === 'function') {
              // Updater function
              {
                enterDisallowedContextReadInDEV();

                if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
                  payload.call(instance, prevState, nextProps);
                }
              }
              var nextState = payload.call(instance, prevState, nextProps);
              {
                exitDisallowedContextReadInDEV();
              }
              return nextState;
            } // State object


            return payload;
          }

        case CaptureUpdate:
          {
            workInProgress.effectTag = workInProgress.effectTag & ~ShouldCapture | DidCapture;
          }
        // Intentional fallthrough

        case UpdateState:
          {
            var _payload = update.payload;
            var partialState;

            if (typeof _payload === 'function') {
              // Updater function
              {
                enterDisallowedContextReadInDEV();

                if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
                  _payload.call(instance, prevState, nextProps);
                }
              }
              partialState = _payload.call(instance, prevState, nextProps);
              {
                exitDisallowedContextReadInDEV();
              }
            } else {
              // Partial state object
              partialState = _payload;
            }

            if (partialState === null || partialState === undefined) {
              // Null and undefined are treated as no-ops.
              return prevState;
            } // Merge the partial state and the previous state.


            return _assign({}, prevState, partialState);
          }

        case ForceUpdate:
          {
            hasForceUpdate = true;
            return prevState;
          }
      }

      return prevState;
    }

    function processUpdateQueue(workInProgress, queue, props, instance, renderExpirationTime) {
      hasForceUpdate = false;
      queue = ensureWorkInProgressQueueIsAClone(workInProgress, queue);
      {
        currentlyProcessingQueue = queue;
      } // These values may change as we process the queue.

      var newBaseState = queue.baseState;
      var newFirstUpdate = null;
      var newExpirationTime = NoWork; // Iterate through the list of updates to compute the result.

      var update = queue.firstUpdate;
      var resultState = newBaseState;

      while (update !== null) {
        var updateExpirationTime = update.expirationTime;

        if (updateExpirationTime < renderExpirationTime) {
          // This update does not have sufficient priority. Skip it.
          if (newFirstUpdate === null) {
            // This is the first skipped update. It will be the first update in
            // the new list.
            newFirstUpdate = update; // Since this is the first update that was skipped, the current result
            // is the new base state.

            newBaseState = resultState;
          } // Since this update will remain in the list, update the remaining
          // expiration time.


          if (newExpirationTime < updateExpirationTime) {
            newExpirationTime = updateExpirationTime;
          }
        } else {
          // This update does have sufficient priority.
          // Mark the event time of this update as relevant to this render pass.
          // TODO: This should ideally use the true event time of this update rather than
          // its priority which is a derived and not reverseable value.
          // TODO: We should skip this update if it was already committed but currently
          // we have no way of detecting the difference between a committed and suspended
          // update here.
          markRenderEventTimeAndConfig(updateExpirationTime, update.suspenseConfig); // Process it and compute a new result.

          resultState = getStateFromUpdate(workInProgress, queue, update, resultState, props, instance);
          var callback = update.callback;

          if (callback !== null) {
            workInProgress.effectTag |= Callback; // Set this to null, in case it was mutated during an aborted render.

            update.nextEffect = null;

            if (queue.lastEffect === null) {
              queue.firstEffect = queue.lastEffect = update;
            } else {
              queue.lastEffect.nextEffect = update;
              queue.lastEffect = update;
            }
          }
        } // Continue to the next update.


        update = update.next;
      } // Separately, iterate though the list of captured updates.


      var newFirstCapturedUpdate = null;
      update = queue.firstCapturedUpdate;

      while (update !== null) {
        var _updateExpirationTime = update.expirationTime;

        if (_updateExpirationTime < renderExpirationTime) {
          // This update does not have sufficient priority. Skip it.
          if (newFirstCapturedUpdate === null) {
            // This is the first skipped captured update. It will be the first
            // update in the new list.
            newFirstCapturedUpdate = update; // If this is the first update that was skipped, the current result is
            // the new base state.

            if (newFirstUpdate === null) {
              newBaseState = resultState;
            }
          } // Since this update will remain in the list, update the remaining
          // expiration time.


          if (newExpirationTime < _updateExpirationTime) {
            newExpirationTime = _updateExpirationTime;
          }
        } else {
          // This update does have sufficient priority. Process it and compute
          // a new result.
          resultState = getStateFromUpdate(workInProgress, queue, update, resultState, props, instance);
          var _callback = update.callback;

          if (_callback !== null) {
            workInProgress.effectTag |= Callback; // Set this to null, in case it was mutated during an aborted render.

            update.nextEffect = null;

            if (queue.lastCapturedEffect === null) {
              queue.firstCapturedEffect = queue.lastCapturedEffect = update;
            } else {
              queue.lastCapturedEffect.nextEffect = update;
              queue.lastCapturedEffect = update;
            }
          }
        }

        update = update.next;
      }

      if (newFirstUpdate === null) {
        queue.lastUpdate = null;
      }

      if (newFirstCapturedUpdate === null) {
        queue.lastCapturedUpdate = null;
      } else {
        workInProgress.effectTag |= Callback;
      }

      if (newFirstUpdate === null && newFirstCapturedUpdate === null) {
        // We processed every update, without skipping. That means the new base
        // state is the same as the result state.
        newBaseState = resultState;
      }

      queue.baseState = newBaseState;
      queue.firstUpdate = newFirstUpdate;
      queue.firstCapturedUpdate = newFirstCapturedUpdate; // Set the remaining expiration time to be whatever is remaining in the queue.
      // This should be fine because the only two other things that contribute to
      // expiration time are props and context. We're already in the middle of the
      // begin phase by the time we start processing the queue, so we've already
      // dealt with the props. Context in components that specify
      // shouldComponentUpdate is tricky; but we'll have to account for
      // that regardless.

      markUnprocessedUpdateTime(newExpirationTime);
      workInProgress.expirationTime = newExpirationTime;
      workInProgress.memoizedState = resultState;
      {
        currentlyProcessingQueue = null;
      }
    }

    function callCallback(callback, context) {
      if (!(typeof callback === 'function')) {
        {
          throw Error("Invalid argument passed as callback. Expected a function. Instead received: " + callback);
        }
      }

      callback.call(context);
    }

    function resetHasForceUpdateBeforeProcessing() {
      hasForceUpdate = false;
    }

    function checkHasForceUpdateAfterProcessing() {
      return hasForceUpdate;
    }

    function commitUpdateQueue(finishedWork, finishedQueue, instance, renderExpirationTime) {
      // If the finished render included captured updates, and there are still
      // lower priority updates left over, we need to keep the captured updates
      // in the queue so that they are rebased and not dropped once we process the
      // queue again at the lower priority.
      if (finishedQueue.firstCapturedUpdate !== null) {
        // Join the captured update list to the end of the normal list.
        if (finishedQueue.lastUpdate !== null) {
          finishedQueue.lastUpdate.next = finishedQueue.firstCapturedUpdate;
          finishedQueue.lastUpdate = finishedQueue.lastCapturedUpdate;
        } // Clear the list of captured updates.


        finishedQueue.firstCapturedUpdate = finishedQueue.lastCapturedUpdate = null;
      } // Commit the effects


      commitUpdateEffects(finishedQueue.firstEffect, instance);
      finishedQueue.firstEffect = finishedQueue.lastEffect = null;
      commitUpdateEffects(finishedQueue.firstCapturedEffect, instance);
      finishedQueue.firstCapturedEffect = finishedQueue.lastCapturedEffect = null;
    }

    function commitUpdateEffects(effect, instance) {
      while (effect !== null) {
        var callback = effect.callback;

        if (callback !== null) {
          effect.callback = null;
          callCallback(callback, instance);
        }

        effect = effect.nextEffect;
      }
    }

    var ReactCurrentBatchConfig = ReactSharedInternals.ReactCurrentBatchConfig;

    function requestCurrentSuspenseConfig() {
      return ReactCurrentBatchConfig.suspense;
    }

    var fakeInternalInstance = {};
    var isArray$1 = Array.isArray; // React.Component uses a shared frozen object by default.
    // We'll use it to determine whether we need to initialize legacy refs.

    var emptyRefsObject = new React.Component().refs;
    var didWarnAboutStateAssignmentForComponent;
    var didWarnAboutUninitializedState;
    var didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate;
    var didWarnAboutLegacyLifecyclesAndDerivedState;
    var didWarnAboutUndefinedDerivedState;
    var warnOnUndefinedDerivedState;
    var warnOnInvalidCallback$1;
    var didWarnAboutDirectlyAssigningPropsToState;
    var didWarnAboutContextTypeAndContextTypes;
    var didWarnAboutInvalidateContextType;
    {
      didWarnAboutStateAssignmentForComponent = new Set();
      didWarnAboutUninitializedState = new Set();
      didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate = new Set();
      didWarnAboutLegacyLifecyclesAndDerivedState = new Set();
      didWarnAboutDirectlyAssigningPropsToState = new Set();
      didWarnAboutUndefinedDerivedState = new Set();
      didWarnAboutContextTypeAndContextTypes = new Set();
      didWarnAboutInvalidateContextType = new Set();
      var didWarnOnInvalidCallback = new Set();

      warnOnInvalidCallback$1 = function (callback, callerName) {
        if (callback === null || typeof callback === 'function') {
          return;
        }

        var key = callerName + "_" + callback;

        if (!didWarnOnInvalidCallback.has(key)) {
          didWarnOnInvalidCallback.add(key);
          warningWithoutStack$1(false, '%s(...): Expected the last optional `callback` argument to be a ' + 'function. Instead received: %s.', callerName, callback);
        }
      };

      warnOnUndefinedDerivedState = function (type, partialState) {
        if (partialState === undefined) {
          var componentName = getComponentName(type) || 'Component';

          if (!didWarnAboutUndefinedDerivedState.has(componentName)) {
            didWarnAboutUndefinedDerivedState.add(componentName);
            warningWithoutStack$1(false, '%s.getDerivedStateFromProps(): A valid state object (or null) must be returned. ' + 'You have returned undefined.', componentName);
          }
        }
      }; // This is so gross but it's at least non-critical and can be removed if
      // it causes problems. This is meant to give a nicer error message for
      // ReactDOM15.unstable_renderSubtreeIntoContainer(reactDOM16Component,
      // ...)) which otherwise throws a "_processChildContext is not a function"
      // exception.


      Object.defineProperty(fakeInternalInstance, '_processChildContext', {
        enumerable: false,
        value: function () {
          {
            {
              throw Error("_processChildContext is not available in React 16+. This likely means you have multiple copies of React and are attempting to nest a React 15 tree inside a React 16 tree using unstable_renderSubtreeIntoContainer, which isn't supported. Try to make sure you have only one copy of React (and ideally, switch to ReactDOM.createPortal).");
            }
          }
        }
      });
      Object.freeze(fakeInternalInstance);
    }

    function applyDerivedStateFromProps(workInProgress, ctor, getDerivedStateFromProps, nextProps) {
      var prevState = workInProgress.memoizedState;
      {
        if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
          // Invoke the function an extra time to help detect side-effects.
          getDerivedStateFromProps(nextProps, prevState);
        }
      }
      var partialState = getDerivedStateFromProps(nextProps, prevState);
      {
        warnOnUndefinedDerivedState(ctor, partialState);
      } // Merge the partial state and the previous state.

      var memoizedState = partialState === null || partialState === undefined ? prevState : _assign({}, prevState, partialState);
      workInProgress.memoizedState = memoizedState; // Once the update queue is empty, persist the derived state onto the
      // base state.

      var updateQueue = workInProgress.updateQueue;

      if (updateQueue !== null && workInProgress.expirationTime === NoWork) {
        updateQueue.baseState = memoizedState;
      }
    }

    var classComponentUpdater = {
      isMounted: isMounted,
      enqueueSetState: function (inst, payload, callback) {
        var fiber = get(inst);
        var currentTime = requestCurrentTimeForUpdate();
        var suspenseConfig = requestCurrentSuspenseConfig();
        var expirationTime = computeExpirationForFiber(currentTime, fiber, suspenseConfig);
        var update = createUpdate(expirationTime, suspenseConfig);
        update.payload = payload;

        if (callback !== undefined && callback !== null) {
          {
            warnOnInvalidCallback$1(callback, 'setState');
          }
          update.callback = callback;
        }

        enqueueUpdate(fiber, update);
        scheduleWork(fiber, expirationTime);
      },
      enqueueReplaceState: function (inst, payload, callback) {
        var fiber = get(inst);
        var currentTime = requestCurrentTimeForUpdate();
        var suspenseConfig = requestCurrentSuspenseConfig();
        var expirationTime = computeExpirationForFiber(currentTime, fiber, suspenseConfig);
        var update = createUpdate(expirationTime, suspenseConfig);
        update.tag = ReplaceState;
        update.payload = payload;

        if (callback !== undefined && callback !== null) {
          {
            warnOnInvalidCallback$1(callback, 'replaceState');
          }
          update.callback = callback;
        }

        enqueueUpdate(fiber, update);
        scheduleWork(fiber, expirationTime);
      },
      enqueueForceUpdate: function (inst, callback) {
        var fiber = get(inst);
        var currentTime = requestCurrentTimeForUpdate();
        var suspenseConfig = requestCurrentSuspenseConfig();
        var expirationTime = computeExpirationForFiber(currentTime, fiber, suspenseConfig);
        var update = createUpdate(expirationTime, suspenseConfig);
        update.tag = ForceUpdate;

        if (callback !== undefined && callback !== null) {
          {
            warnOnInvalidCallback$1(callback, 'forceUpdate');
          }
          update.callback = callback;
        }

        enqueueUpdate(fiber, update);
        scheduleWork(fiber, expirationTime);
      }
    };

    function checkShouldComponentUpdate(workInProgress, ctor, oldProps, newProps, oldState, newState, nextContext) {
      var instance = workInProgress.stateNode;

      if (typeof instance.shouldComponentUpdate === 'function') {
        startPhaseTimer(workInProgress, 'shouldComponentUpdate');
        var shouldUpdate = instance.shouldComponentUpdate(newProps, newState, nextContext);
        stopPhaseTimer();
        {
          !(shouldUpdate !== undefined) ? warningWithoutStack$1(false, '%s.shouldComponentUpdate(): Returned undefined instead of a ' + 'boolean value. Make sure to return true or false.', getComponentName(ctor) || 'Component') : void 0;
        }
        return shouldUpdate;
      }

      if (ctor.prototype && ctor.prototype.isPureReactComponent) {
        return !shallowEqual(oldProps, newProps) || !shallowEqual(oldState, newState);
      }

      return true;
    }

    function checkClassInstance(workInProgress, ctor, newProps) {
      var instance = workInProgress.stateNode;
      {
        var name = getComponentName(ctor) || 'Component';
        var renderPresent = instance.render;

        if (!renderPresent) {
          if (ctor.prototype && typeof ctor.prototype.render === 'function') {
            warningWithoutStack$1(false, '%s(...): No `render` method found on the returned component ' + 'instance: did you accidentally return an object from the constructor?', name);
          } else {
            warningWithoutStack$1(false, '%s(...): No `render` method found on the returned component ' + 'instance: you may have forgotten to define `render`.', name);
          }
        }

        var noGetInitialStateOnES6 = !instance.getInitialState || instance.getInitialState.isReactClassApproved || instance.state;
        !noGetInitialStateOnES6 ? warningWithoutStack$1(false, 'getInitialState was defined on %s, a plain JavaScript class. ' + 'This is only supported for classes created using React.createClass. ' + 'Did you mean to define a state property instead?', name) : void 0;
        var noGetDefaultPropsOnES6 = !instance.getDefaultProps || instance.getDefaultProps.isReactClassApproved;
        !noGetDefaultPropsOnES6 ? warningWithoutStack$1(false, 'getDefaultProps was defined on %s, a plain JavaScript class. ' + 'This is only supported for classes created using React.createClass. ' + 'Use a static property to define defaultProps instead.', name) : void 0;
        var noInstancePropTypes = !instance.propTypes;
        !noInstancePropTypes ? warningWithoutStack$1(false, 'propTypes was defined as an instance property on %s. Use a static ' + 'property to define propTypes instead.', name) : void 0;
        var noInstanceContextType = !instance.contextType;
        !noInstanceContextType ? warningWithoutStack$1(false, 'contextType was defined as an instance property on %s. Use a static ' + 'property to define contextType instead.', name) : void 0;

        if (disableLegacyContext) {
          if (ctor.childContextTypes) {
            warningWithoutStack$1(false, '%s uses the legacy childContextTypes API which is no longer supported. ' + 'Use React.createContext() instead.', name);
          }

          if (ctor.contextTypes) {
            warningWithoutStack$1(false, '%s uses the legacy contextTypes API which is no longer supported. ' + 'Use React.createContext() with static contextType instead.', name);
          }
        } else {
          var noInstanceContextTypes = !instance.contextTypes;
          !noInstanceContextTypes ? warningWithoutStack$1(false, 'contextTypes was defined as an instance property on %s. Use a static ' + 'property to define contextTypes instead.', name) : void 0;

          if (ctor.contextType && ctor.contextTypes && !didWarnAboutContextTypeAndContextTypes.has(ctor)) {
            didWarnAboutContextTypeAndContextTypes.add(ctor);
            warningWithoutStack$1(false, '%s declares both contextTypes and contextType static properties. ' + 'The legacy contextTypes property will be ignored.', name);
          }
        }

        var noComponentShouldUpdate = typeof instance.componentShouldUpdate !== 'function';
        !noComponentShouldUpdate ? warningWithoutStack$1(false, '%s has a method called ' + 'componentShouldUpdate(). Did you mean shouldComponentUpdate()? ' + 'The name is phrased as a question because the function is ' + 'expected to return a value.', name) : void 0;

        if (ctor.prototype && ctor.prototype.isPureReactComponent && typeof instance.shouldComponentUpdate !== 'undefined') {
          warningWithoutStack$1(false, '%s has a method called shouldComponentUpdate(). ' + 'shouldComponentUpdate should not be used when extending React.PureComponent. ' + 'Please extend React.Component if shouldComponentUpdate is used.', getComponentName(ctor) || 'A pure component');
        }

        var noComponentDidUnmount = typeof instance.componentDidUnmount !== 'function';
        !noComponentDidUnmount ? warningWithoutStack$1(false, '%s has a method called ' + 'componentDidUnmount(). But there is no such lifecycle method. ' + 'Did you mean componentWillUnmount()?', name) : void 0;
        var noComponentDidReceiveProps = typeof instance.componentDidReceiveProps !== 'function';
        !noComponentDidReceiveProps ? warningWithoutStack$1(false, '%s has a method called ' + 'componentDidReceiveProps(). But there is no such lifecycle method. ' + 'If you meant to update the state in response to changing props, ' + 'use componentWillReceiveProps(). If you meant to fetch data or ' + 'run side-effects or mutations after React has updated the UI, use componentDidUpdate().', name) : void 0;
        var noComponentWillRecieveProps = typeof instance.componentWillRecieveProps !== 'function';
        !noComponentWillRecieveProps ? warningWithoutStack$1(false, '%s has a method called ' + 'componentWillRecieveProps(). Did you mean componentWillReceiveProps()?', name) : void 0;
        var noUnsafeComponentWillRecieveProps = typeof instance.UNSAFE_componentWillRecieveProps !== 'function';
        !noUnsafeComponentWillRecieveProps ? warningWithoutStack$1(false, '%s has a method called ' + 'UNSAFE_componentWillRecieveProps(). Did you mean UNSAFE_componentWillReceiveProps()?', name) : void 0;
        var hasMutatedProps = instance.props !== newProps;
        !(instance.props === undefined || !hasMutatedProps) ? warningWithoutStack$1(false, '%s(...): When calling super() in `%s`, make sure to pass ' + "up the same props that your component's constructor was passed.", name, name) : void 0;
        var noInstanceDefaultProps = !instance.defaultProps;
        !noInstanceDefaultProps ? warningWithoutStack$1(false, 'Setting defaultProps as an instance property on %s is not supported and will be ignored.' + ' Instead, define defaultProps as a static property on %s.', name, name) : void 0;

        if (typeof instance.getSnapshotBeforeUpdate === 'function' && typeof instance.componentDidUpdate !== 'function' && !didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate.has(ctor)) {
          didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate.add(ctor);
          warningWithoutStack$1(false, '%s: getSnapshotBeforeUpdate() should be used with componentDidUpdate(). ' + 'This component defines getSnapshotBeforeUpdate() only.', getComponentName(ctor));
        }

        var noInstanceGetDerivedStateFromProps = typeof instance.getDerivedStateFromProps !== 'function';
        !noInstanceGetDerivedStateFromProps ? warningWithoutStack$1(false, '%s: getDerivedStateFromProps() is defined as an instance method ' + 'and will be ignored. Instead, declare it as a static method.', name) : void 0;
        var noInstanceGetDerivedStateFromCatch = typeof instance.getDerivedStateFromError !== 'function';
        !noInstanceGetDerivedStateFromCatch ? warningWithoutStack$1(false, '%s: getDerivedStateFromError() is defined as an instance method ' + 'and will be ignored. Instead, declare it as a static method.', name) : void 0;
        var noStaticGetSnapshotBeforeUpdate = typeof ctor.getSnapshotBeforeUpdate !== 'function';
        !noStaticGetSnapshotBeforeUpdate ? warningWithoutStack$1(false, '%s: getSnapshotBeforeUpdate() is defined as a static method ' + 'and will be ignored. Instead, declare it as an instance method.', name) : void 0;
        var _state = instance.state;

        if (_state && (typeof _state !== 'object' || isArray$1(_state))) {
          warningWithoutStack$1(false, '%s.state: must be set to an object or null', name);
        }

        if (typeof instance.getChildContext === 'function') {
          !(typeof ctor.childContextTypes === 'object') ? warningWithoutStack$1(false, '%s.getChildContext(): childContextTypes must be defined in order to ' + 'use getChildContext().', name) : void 0;
        }
      }
    }

    function adoptClassInstance(workInProgress, instance) {
      instance.updater = classComponentUpdater;
      workInProgress.stateNode = instance; // The instance needs access to the fiber so that it can schedule updates

      set(instance, workInProgress);
      {
        instance._reactInternalInstance = fakeInternalInstance;
      }
    }

    function constructClassInstance(workInProgress, ctor, props, renderExpirationTime) {
      var isLegacyContextConsumer = false;
      var unmaskedContext = emptyContextObject;
      var context = emptyContextObject;
      var contextType = ctor.contextType;
      {
        if ('contextType' in ctor) {
          var isValid = // Allow null for conditional declaration
          contextType === null || contextType !== undefined && contextType.$$typeof === REACT_CONTEXT_TYPE && contextType._context === undefined; // Not a <Context.Consumer>

          if (!isValid && !didWarnAboutInvalidateContextType.has(ctor)) {
            didWarnAboutInvalidateContextType.add(ctor);
            var addendum = '';

            if (contextType === undefined) {
              addendum = ' However, it is set to undefined. ' + 'This can be caused by a typo or by mixing up named and default imports. ' + 'This can also happen due to a circular dependency, so ' + 'try moving the createContext() call to a separate file.';
            } else if (typeof contextType !== 'object') {
              addendum = ' However, it is set to a ' + typeof contextType + '.';
            } else if (contextType.$$typeof === REACT_PROVIDER_TYPE) {
              addendum = ' Did you accidentally pass the Context.Provider instead?';
            } else if (contextType._context !== undefined) {
              // <Context.Consumer>
              addendum = ' Did you accidentally pass the Context.Consumer instead?';
            } else {
              addendum = ' However, it is set to an object with keys {' + Object.keys(contextType).join(', ') + '}.';
            }

            warningWithoutStack$1(false, '%s defines an invalid contextType. ' + 'contextType should point to the Context object returned by React.createContext().%s', getComponentName(ctor) || 'Component', addendum);
          }
        }
      }

      if (typeof contextType === 'object' && contextType !== null) {
        context = readContext(contextType);
      } else if (!disableLegacyContext) {
        unmaskedContext = getUnmaskedContext(workInProgress, ctor, true);
        var contextTypes = ctor.contextTypes;
        isLegacyContextConsumer = contextTypes !== null && contextTypes !== undefined;
        context = isLegacyContextConsumer ? getMaskedContext(workInProgress, unmaskedContext) : emptyContextObject;
      } // Instantiate twice to help detect side-effects.


      {
        if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
          new ctor(props, context); // eslint-disable-line no-new
        }
      }
      var instance = new ctor(props, context);
      var state = workInProgress.memoizedState = instance.state !== null && instance.state !== undefined ? instance.state : null;
      adoptClassInstance(workInProgress, instance);
      {
        if (typeof ctor.getDerivedStateFromProps === 'function' && state === null) {
          var componentName = getComponentName(ctor) || 'Component';

          if (!didWarnAboutUninitializedState.has(componentName)) {
            didWarnAboutUninitializedState.add(componentName);
            warningWithoutStack$1(false, '`%s` uses `getDerivedStateFromProps` but its initial state is ' + '%s. This is not recommended. Instead, define the initial state by ' + 'assigning an object to `this.state` in the constructor of `%s`. ' + 'This ensures that `getDerivedStateFromProps` arguments have a consistent shape.', componentName, instance.state === null ? 'null' : 'undefined', componentName);
          }
        } // If new component APIs are defined, "unsafe" lifecycles won't be called.
        // Warn about these lifecycles if they are present.
        // Don't warn about react-lifecycles-compat polyfilled methods though.


        if (typeof ctor.getDerivedStateFromProps === 'function' || typeof instance.getSnapshotBeforeUpdate === 'function') {
          var foundWillMountName = null;
          var foundWillReceivePropsName = null;
          var foundWillUpdateName = null;

          if (typeof instance.componentWillMount === 'function' && instance.componentWillMount.__suppressDeprecationWarning !== true) {
            foundWillMountName = 'componentWillMount';
          } else if (typeof instance.UNSAFE_componentWillMount === 'function') {
            foundWillMountName = 'UNSAFE_componentWillMount';
          }

          if (typeof instance.componentWillReceiveProps === 'function' && instance.componentWillReceiveProps.__suppressDeprecationWarning !== true) {
            foundWillReceivePropsName = 'componentWillReceiveProps';
          } else if (typeof instance.UNSAFE_componentWillReceiveProps === 'function') {
            foundWillReceivePropsName = 'UNSAFE_componentWillReceiveProps';
          }

          if (typeof instance.componentWillUpdate === 'function' && instance.componentWillUpdate.__suppressDeprecationWarning !== true) {
            foundWillUpdateName = 'componentWillUpdate';
          } else if (typeof instance.UNSAFE_componentWillUpdate === 'function') {
            foundWillUpdateName = 'UNSAFE_componentWillUpdate';
          }

          if (foundWillMountName !== null || foundWillReceivePropsName !== null || foundWillUpdateName !== null) {
            var _componentName = getComponentName(ctor) || 'Component';

            var newApiName = typeof ctor.getDerivedStateFromProps === 'function' ? 'getDerivedStateFromProps()' : 'getSnapshotBeforeUpdate()';

            if (!didWarnAboutLegacyLifecyclesAndDerivedState.has(_componentName)) {
              didWarnAboutLegacyLifecyclesAndDerivedState.add(_componentName);
              warningWithoutStack$1(false, 'Unsafe legacy lifecycles will not be called for components using new component APIs.\n\n' + '%s uses %s but also contains the following legacy lifecycles:%s%s%s\n\n' + 'The above lifecycles should be removed. Learn more about this warning here:\n' + 'https://fb.me/react-unsafe-component-lifecycles', _componentName, newApiName, foundWillMountName !== null ? "\n  " + foundWillMountName : '', foundWillReceivePropsName !== null ? "\n  " + foundWillReceivePropsName : '', foundWillUpdateName !== null ? "\n  " + foundWillUpdateName : '');
            }
          }
        }
      } // Cache unmasked context so we can avoid recreating masked context unless necessary.
      // ReactFiberContext usually updates this cache but can't for newly-created instances.

      if (isLegacyContextConsumer) {
        cacheContext(workInProgress, unmaskedContext, context);
      }

      return instance;
    }

    function callComponentWillMount(workInProgress, instance) {
      startPhaseTimer(workInProgress, 'componentWillMount');
      var oldState = instance.state;

      if (typeof instance.componentWillMount === 'function') {
        instance.componentWillMount();
      }

      if (typeof instance.UNSAFE_componentWillMount === 'function') {
        instance.UNSAFE_componentWillMount();
      }

      stopPhaseTimer();

      if (oldState !== instance.state) {
        {
          warningWithoutStack$1(false, '%s.componentWillMount(): Assigning directly to this.state is ' + "deprecated (except inside a component's " + 'constructor). Use setState instead.', getComponentName(workInProgress.type) || 'Component');
        }
        classComponentUpdater.enqueueReplaceState(instance, instance.state, null);
      }
    }

    function callComponentWillReceiveProps(workInProgress, instance, newProps, nextContext) {
      var oldState = instance.state;
      startPhaseTimer(workInProgress, 'componentWillReceiveProps');

      if (typeof instance.componentWillReceiveProps === 'function') {
        instance.componentWillReceiveProps(newProps, nextContext);
      }

      if (typeof instance.UNSAFE_componentWillReceiveProps === 'function') {
        instance.UNSAFE_componentWillReceiveProps(newProps, nextContext);
      }

      stopPhaseTimer();

      if (instance.state !== oldState) {
        {
          var componentName = getComponentName(workInProgress.type) || 'Component';

          if (!didWarnAboutStateAssignmentForComponent.has(componentName)) {
            didWarnAboutStateAssignmentForComponent.add(componentName);
            warningWithoutStack$1(false, '%s.componentWillReceiveProps(): Assigning directly to ' + "this.state is deprecated (except inside a component's " + 'constructor). Use setState instead.', componentName);
          }
        }
        classComponentUpdater.enqueueReplaceState(instance, instance.state, null);
      }
    } // Invokes the mount life-cycles on a previously never rendered instance.


    function mountClassInstance(workInProgress, ctor, newProps, renderExpirationTime) {
      {
        checkClassInstance(workInProgress, ctor, newProps);
      }
      var instance = workInProgress.stateNode;
      instance.props = newProps;
      instance.state = workInProgress.memoizedState;
      instance.refs = emptyRefsObject;
      var contextType = ctor.contextType;

      if (typeof contextType === 'object' && contextType !== null) {
        instance.context = readContext(contextType);
      } else if (disableLegacyContext) {
        instance.context = emptyContextObject;
      } else {
        var unmaskedContext = getUnmaskedContext(workInProgress, ctor, true);
        instance.context = getMaskedContext(workInProgress, unmaskedContext);
      }

      {
        if (instance.state === newProps) {
          var componentName = getComponentName(ctor) || 'Component';

          if (!didWarnAboutDirectlyAssigningPropsToState.has(componentName)) {
            didWarnAboutDirectlyAssigningPropsToState.add(componentName);
            warningWithoutStack$1(false, '%s: It is not recommended to assign props directly to state ' + "because updates to props won't be reflected in state. " + 'In most cases, it is better to use props directly.', componentName);
          }
        }

        if (workInProgress.mode & StrictMode) {
          ReactStrictModeWarnings.recordLegacyContextWarning(workInProgress, instance);
        }

        if (warnAboutDeprecatedLifecycles) {
          ReactStrictModeWarnings.recordUnsafeLifecycleWarnings(workInProgress, instance);
        }
      }
      var updateQueue = workInProgress.updateQueue;

      if (updateQueue !== null) {
        processUpdateQueue(workInProgress, updateQueue, newProps, instance, renderExpirationTime);
        instance.state = workInProgress.memoizedState;
      }

      var getDerivedStateFromProps = ctor.getDerivedStateFromProps;

      if (typeof getDerivedStateFromProps === 'function') {
        applyDerivedStateFromProps(workInProgress, ctor, getDerivedStateFromProps, newProps);
        instance.state = workInProgress.memoizedState;
      } // In order to support react-lifecycles-compat polyfilled components,
      // Unsafe lifecycles should not be invoked for components using the new APIs.


      if (typeof ctor.getDerivedStateFromProps !== 'function' && typeof instance.getSnapshotBeforeUpdate !== 'function' && (typeof instance.UNSAFE_componentWillMount === 'function' || typeof instance.componentWillMount === 'function')) {
        callComponentWillMount(workInProgress, instance); // If we had additional state updates during this life-cycle, let's
        // process them now.

        updateQueue = workInProgress.updateQueue;

        if (updateQueue !== null) {
          processUpdateQueue(workInProgress, updateQueue, newProps, instance, renderExpirationTime);
          instance.state = workInProgress.memoizedState;
        }
      }

      if (typeof instance.componentDidMount === 'function') {
        workInProgress.effectTag |= Update;
      }
    }

    function resumeMountClassInstance(workInProgress, ctor, newProps, renderExpirationTime) {
      var instance = workInProgress.stateNode;
      var oldProps = workInProgress.memoizedProps;
      instance.props = oldProps;
      var oldContext = instance.context;
      var contextType = ctor.contextType;
      var nextContext = emptyContextObject;

      if (typeof contextType === 'object' && contextType !== null) {
        nextContext = readContext(contextType);
      } else if (!disableLegacyContext) {
        var nextLegacyUnmaskedContext = getUnmaskedContext(workInProgress, ctor, true);
        nextContext = getMaskedContext(workInProgress, nextLegacyUnmaskedContext);
      }

      var getDerivedStateFromProps = ctor.getDerivedStateFromProps;
      var hasNewLifecycles = typeof getDerivedStateFromProps === 'function' || typeof instance.getSnapshotBeforeUpdate === 'function'; // Note: During these life-cycles, instance.props/instance.state are what
      // ever the previously attempted to render - not the "current". However,
      // during componentDidUpdate we pass the "current" props.
      // In order to support react-lifecycles-compat polyfilled components,
      // Unsafe lifecycles should not be invoked for components using the new APIs.

      if (!hasNewLifecycles && (typeof instance.UNSAFE_componentWillReceiveProps === 'function' || typeof instance.componentWillReceiveProps === 'function')) {
        if (oldProps !== newProps || oldContext !== nextContext) {
          callComponentWillReceiveProps(workInProgress, instance, newProps, nextContext);
        }
      }

      resetHasForceUpdateBeforeProcessing();
      var oldState = workInProgress.memoizedState;
      var newState = instance.state = oldState;
      var updateQueue = workInProgress.updateQueue;

      if (updateQueue !== null) {
        processUpdateQueue(workInProgress, updateQueue, newProps, instance, renderExpirationTime);
        newState = workInProgress.memoizedState;
      }

      if (oldProps === newProps && oldState === newState && !hasContextChanged() && !checkHasForceUpdateAfterProcessing()) {
        // If an update was already in progress, we should schedule an Update
        // effect even though we're bailing out, so that cWU/cDU are called.
        if (typeof instance.componentDidMount === 'function') {
          workInProgress.effectTag |= Update;
        }

        return false;
      }

      if (typeof getDerivedStateFromProps === 'function') {
        applyDerivedStateFromProps(workInProgress, ctor, getDerivedStateFromProps, newProps);
        newState = workInProgress.memoizedState;
      }

      var shouldUpdate = checkHasForceUpdateAfterProcessing() || checkShouldComponentUpdate(workInProgress, ctor, oldProps, newProps, oldState, newState, nextContext);

      if (shouldUpdate) {
        // In order to support react-lifecycles-compat polyfilled components,
        // Unsafe lifecycles should not be invoked for components using the new APIs.
        if (!hasNewLifecycles && (typeof instance.UNSAFE_componentWillMount === 'function' || typeof instance.componentWillMount === 'function')) {
          startPhaseTimer(workInProgress, 'componentWillMount');

          if (typeof instance.componentWillMount === 'function') {
            instance.componentWillMount();
          }

          if (typeof instance.UNSAFE_componentWillMount === 'function') {
            instance.UNSAFE_componentWillMount();
          }

          stopPhaseTimer();
        }

        if (typeof instance.componentDidMount === 'function') {
          workInProgress.effectTag |= Update;
        }
      } else {
        // If an update was already in progress, we should schedule an Update
        // effect even though we're bailing out, so that cWU/cDU are called.
        if (typeof instance.componentDidMount === 'function') {
          workInProgress.effectTag |= Update;
        } // If shouldComponentUpdate returned false, we should still update the
        // memoized state to indicate that this work can be reused.


        workInProgress.memoizedProps = newProps;
        workInProgress.memoizedState = newState;
      } // Update the existing instance's state, props, and context pointers even
      // if shouldComponentUpdate returns false.


      instance.props = newProps;
      instance.state = newState;
      instance.context = nextContext;
      return shouldUpdate;
    } // Invokes the update life-cycles and returns false if it shouldn't rerender.


    function updateClassInstance(current, workInProgress, ctor, newProps, renderExpirationTime) {
      var instance = workInProgress.stateNode;
      var oldProps = workInProgress.memoizedProps;
      instance.props = workInProgress.type === workInProgress.elementType ? oldProps : resolveDefaultProps(workInProgress.type, oldProps);
      var oldContext = instance.context;
      var contextType = ctor.contextType;
      var nextContext = emptyContextObject;

      if (typeof contextType === 'object' && contextType !== null) {
        nextContext = readContext(contextType);
      } else if (!disableLegacyContext) {
        var nextUnmaskedContext = getUnmaskedContext(workInProgress, ctor, true);
        nextContext = getMaskedContext(workInProgress, nextUnmaskedContext);
      }

      var getDerivedStateFromProps = ctor.getDerivedStateFromProps;
      var hasNewLifecycles = typeof getDerivedStateFromProps === 'function' || typeof instance.getSnapshotBeforeUpdate === 'function'; // Note: During these life-cycles, instance.props/instance.state are what
      // ever the previously attempted to render - not the "current". However,
      // during componentDidUpdate we pass the "current" props.
      // In order to support react-lifecycles-compat polyfilled components,
      // Unsafe lifecycles should not be invoked for components using the new APIs.

      if (!hasNewLifecycles && (typeof instance.UNSAFE_componentWillReceiveProps === 'function' || typeof instance.componentWillReceiveProps === 'function')) {
        if (oldProps !== newProps || oldContext !== nextContext) {
          callComponentWillReceiveProps(workInProgress, instance, newProps, nextContext);
        }
      }

      resetHasForceUpdateBeforeProcessing();
      var oldState = workInProgress.memoizedState;
      var newState = instance.state = oldState;
      var updateQueue = workInProgress.updateQueue;

      if (updateQueue !== null) {
        processUpdateQueue(workInProgress, updateQueue, newProps, instance, renderExpirationTime);
        newState = workInProgress.memoizedState;
      }

      if (oldProps === newProps && oldState === newState && !hasContextChanged() && !checkHasForceUpdateAfterProcessing()) {
        // If an update was already in progress, we should schedule an Update
        // effect even though we're bailing out, so that cWU/cDU are called.
        if (typeof instance.componentDidUpdate === 'function') {
          if (oldProps !== current.memoizedProps || oldState !== current.memoizedState) {
            workInProgress.effectTag |= Update;
          }
        }

        if (typeof instance.getSnapshotBeforeUpdate === 'function') {
          if (oldProps !== current.memoizedProps || oldState !== current.memoizedState) {
            workInProgress.effectTag |= Snapshot;
          }
        }

        return false;
      }

      if (typeof getDerivedStateFromProps === 'function') {
        applyDerivedStateFromProps(workInProgress, ctor, getDerivedStateFromProps, newProps);
        newState = workInProgress.memoizedState;
      }

      var shouldUpdate = checkHasForceUpdateAfterProcessing() || checkShouldComponentUpdate(workInProgress, ctor, oldProps, newProps, oldState, newState, nextContext);

      if (shouldUpdate) {
        // In order to support react-lifecycles-compat polyfilled components,
        // Unsafe lifecycles should not be invoked for components using the new APIs.
        if (!hasNewLifecycles && (typeof instance.UNSAFE_componentWillUpdate === 'function' || typeof instance.componentWillUpdate === 'function')) {
          startPhaseTimer(workInProgress, 'componentWillUpdate');

          if (typeof instance.componentWillUpdate === 'function') {
            instance.componentWillUpdate(newProps, newState, nextContext);
          }

          if (typeof instance.UNSAFE_componentWillUpdate === 'function') {
            instance.UNSAFE_componentWillUpdate(newProps, newState, nextContext);
          }

          stopPhaseTimer();
        }

        if (typeof instance.componentDidUpdate === 'function') {
          workInProgress.effectTag |= Update;
        }

        if (typeof instance.getSnapshotBeforeUpdate === 'function') {
          workInProgress.effectTag |= Snapshot;
        }
      } else {
        // If an update was already in progress, we should schedule an Update
        // effect even though we're bailing out, so that cWU/cDU are called.
        if (typeof instance.componentDidUpdate === 'function') {
          if (oldProps !== current.memoizedProps || oldState !== current.memoizedState) {
            workInProgress.effectTag |= Update;
          }
        }

        if (typeof instance.getSnapshotBeforeUpdate === 'function') {
          if (oldProps !== current.memoizedProps || oldState !== current.memoizedState) {
            workInProgress.effectTag |= Snapshot;
          }
        } // If shouldComponentUpdate returned false, we should still update the
        // memoized props/state to indicate that this work can be reused.


        workInProgress.memoizedProps = newProps;
        workInProgress.memoizedState = newState;
      } // Update the existing instance's state, props, and context pointers even
      // if shouldComponentUpdate returns false.


      instance.props = newProps;
      instance.state = newState;
      instance.context = nextContext;
      return shouldUpdate;
    }

    var didWarnAboutMaps;
    var didWarnAboutGenerators;
    var didWarnAboutStringRefs;
    var ownerHasKeyUseWarning;
    var ownerHasFunctionTypeWarning;

    var warnForMissingKey = function (child) {};

    {
      didWarnAboutMaps = false;
      didWarnAboutGenerators = false;
      didWarnAboutStringRefs = {};
      /**
       * Warn if there's no key explicitly set on dynamic arrays of children or
       * object keys are not valid. This allows us to keep track of children between
       * updates.
       */

      ownerHasKeyUseWarning = {};
      ownerHasFunctionTypeWarning = {};

      warnForMissingKey = function (child) {
        if (child === null || typeof child !== 'object') {
          return;
        }

        if (!child._store || child._store.validated || child.key != null) {
          return;
        }

        if (!(typeof child._store === 'object')) {
          {
            throw Error("React Component in warnForMissingKey should have a _store. This error is likely caused by a bug in React. Please file an issue.");
          }
        }

        child._store.validated = true;
        var currentComponentErrorInfo = 'Each child in a list should have a unique ' + '"key" prop. See https://fb.me/react-warning-keys for ' + 'more information.' + getCurrentFiberStackInDev();

        if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
          return;
        }

        ownerHasKeyUseWarning[currentComponentErrorInfo] = true;
        warning$1(false, 'Each child in a list should have a unique ' + '"key" prop. See https://fb.me/react-warning-keys for ' + 'more information.');
      };
    }
    var isArray = Array.isArray;

    function coerceRef(returnFiber, current$$1, element) {
      var mixedRef = element.ref;

      if (mixedRef !== null && typeof mixedRef !== 'function' && typeof mixedRef !== 'object') {
        {
          // TODO: Clean this up once we turn on the string ref warning for
          // everyone, because the strict mode case will no longer be relevant
          if (returnFiber.mode & StrictMode || warnAboutStringRefs) {
            var componentName = getComponentName(returnFiber.type) || 'Component';

            if (!didWarnAboutStringRefs[componentName]) {
              if (warnAboutStringRefs) {
                warningWithoutStack$1(false, 'Component "%s" contains the string ref "%s". Support for string refs ' + 'will be removed in a future major release. We recommend using ' + 'useRef() or createRef() instead. ' + 'Learn more about using refs safely here: ' + 'https://fb.me/react-strict-mode-string-ref%s', componentName, mixedRef, getStackByFiberInDevAndProd(returnFiber));
              } else {
                warningWithoutStack$1(false, 'A string ref, "%s", has been found within a strict mode tree. ' + 'String refs are a source of potential bugs and should be avoided. ' + 'We recommend using useRef() or createRef() instead. ' + 'Learn more about using refs safely here: ' + 'https://fb.me/react-strict-mode-string-ref%s', mixedRef, getStackByFiberInDevAndProd(returnFiber));
              }

              didWarnAboutStringRefs[componentName] = true;
            }
          }
        }

        if (element._owner) {
          var owner = element._owner;
          var inst;

          if (owner) {
            var ownerFiber = owner;

            if (!(ownerFiber.tag === ClassComponent)) {
              {
                throw Error("Function components cannot have refs. Did you mean to use React.forwardRef()?");
              }
            }

            inst = ownerFiber.stateNode;
          }

          if (!inst) {
            {
              throw Error("Missing owner for string ref " + mixedRef + ". This error is likely caused by a bug in React. Please file an issue.");
            }
          }

          var stringRef = '' + mixedRef; // Check if previous string ref matches new string ref

          if (current$$1 !== null && current$$1.ref !== null && typeof current$$1.ref === 'function' && current$$1.ref._stringRef === stringRef) {
            return current$$1.ref;
          }

          var ref = function (value) {
            var refs = inst.refs;

            if (refs === emptyRefsObject) {
              // This is a lazy pooled frozen object, so we need to initialize.
              refs = inst.refs = {};
            }

            if (value === null) {
              delete refs[stringRef];
            } else {
              refs[stringRef] = value;
            }
          };

          ref._stringRef = stringRef;
          return ref;
        } else {
          if (!(typeof mixedRef === 'string')) {
            {
              throw Error("Expected ref to be a function, a string, an object returned by React.createRef(), or null.");
            }
          }

          if (!element._owner) {
            {
              throw Error("Element ref was specified as a string (" + mixedRef + ") but no owner was set. This could happen for one of the following reasons:\n1. You may be adding a ref to a function component\n2. You may be adding a ref to a component that was not created inside a component's render method\n3. You have multiple copies of React loaded\nSee https://fb.me/react-refs-must-have-owner for more information.");
            }
          }
        }
      }

      return mixedRef;
    }

    function throwOnInvalidObjectType(returnFiber, newChild) {
      if (returnFiber.type !== 'textarea') {
        var addendum = '';
        {
          addendum = ' If you meant to render a collection of children, use an array ' + 'instead.' + getCurrentFiberStackInDev();
        }
        {
          {
            throw Error("Objects are not valid as a React child (found: " + (Object.prototype.toString.call(newChild) === '[object Object]' ? 'object with keys {' + Object.keys(newChild).join(', ') + '}' : newChild) + ")." + addendum);
          }
        }
      }
    }

    function warnOnFunctionType() {
      var currentComponentErrorInfo = 'Functions are not valid as a React child. This may happen if ' + 'you return a Component instead of <Component /> from render. ' + 'Or maybe you meant to call this function rather than return it.' + getCurrentFiberStackInDev();

      if (ownerHasFunctionTypeWarning[currentComponentErrorInfo]) {
        return;
      }

      ownerHasFunctionTypeWarning[currentComponentErrorInfo] = true;
      warning$1(false, 'Functions are not valid as a React child. This may happen if ' + 'you return a Component instead of <Component /> from render. ' + 'Or maybe you meant to call this function rather than return it.');
    } // This wrapper function exists because I expect to clone the code in each path
    // to be able to optimize each path individually by branching early. This needs
    // a compiler or we can do it manually. Helpers that don't need this branching
    // live outside of this function.


    function ChildReconciler(shouldTrackSideEffects) {
      function deleteChild(returnFiber, childToDelete) {
        if (!shouldTrackSideEffects) {
          // Noop.
          return;
        } // Deletions are added in reversed order so we add it to the front.
        // At this point, the return fiber's effect list is empty except for
        // deletions, so we can just append the deletion to the list. The remaining
        // effects aren't added until the complete phase. Once we implement
        // resuming, this may not be true.


        var last = returnFiber.lastEffect;

        if (last !== null) {
          last.nextEffect = childToDelete;
          returnFiber.lastEffect = childToDelete;
        } else {
          returnFiber.firstEffect = returnFiber.lastEffect = childToDelete;
        }

        childToDelete.nextEffect = null;
        childToDelete.effectTag = Deletion;
      }

      function deleteRemainingChildren(returnFiber, currentFirstChild) {
        if (!shouldTrackSideEffects) {
          // Noop.
          return null;
        } // TODO: For the shouldClone case, this could be micro-optimized a bit by
        // assuming that after the first child we've already added everything.


        var childToDelete = currentFirstChild;

        while (childToDelete !== null) {
          deleteChild(returnFiber, childToDelete);
          childToDelete = childToDelete.sibling;
        }

        return null;
      }

      function mapRemainingChildren(returnFiber, currentFirstChild) {
        // Add the remaining children to a temporary map so that we can find them by
        // keys quickly. Implicit (null) keys get added to this set with their index
        // instead.
        var existingChildren = new Map();
        var existingChild = currentFirstChild;

        while (existingChild !== null) {
          if (existingChild.key !== null) {
            existingChildren.set(existingChild.key, existingChild);
          } else {
            existingChildren.set(existingChild.index, existingChild);
          }

          existingChild = existingChild.sibling;
        }

        return existingChildren;
      }

      function useFiber(fiber, pendingProps, expirationTime) {
        // We currently set sibling to null and index to 0 here because it is easy
        // to forget to do before returning it. E.g. for the single child case.
        var clone = createWorkInProgress(fiber, pendingProps, expirationTime);
        clone.index = 0;
        clone.sibling = null;
        return clone;
      }

      function placeChild(newFiber, lastPlacedIndex, newIndex) {
        newFiber.index = newIndex;

        if (!shouldTrackSideEffects) {
          // Noop.
          return lastPlacedIndex;
        }

        var current$$1 = newFiber.alternate;

        if (current$$1 !== null) {
          var oldIndex = current$$1.index;

          if (oldIndex < lastPlacedIndex) {
            // This is a move.
            newFiber.effectTag = Placement;
            return lastPlacedIndex;
          } else {
            // This item can stay in place.
            return oldIndex;
          }
        } else {
          // This is an insertion.
          newFiber.effectTag = Placement;
          return lastPlacedIndex;
        }
      }

      function placeSingleChild(newFiber) {
        // This is simpler for the single child case. We only need to do a
        // placement for inserting new children.
        if (shouldTrackSideEffects && newFiber.alternate === null) {
          newFiber.effectTag = Placement;
        }

        return newFiber;
      }

      function updateTextNode(returnFiber, current$$1, textContent, expirationTime) {
        if (current$$1 === null || current$$1.tag !== HostText) {
          // Insert
          var created = createFiberFromText(textContent, returnFiber.mode, expirationTime);
          created.return = returnFiber;
          return created;
        } else {
          // Update
          var existing = useFiber(current$$1, textContent, expirationTime);
          existing.return = returnFiber;
          return existing;
        }
      }

      function updateElement(returnFiber, current$$1, element, expirationTime) {
        if (current$$1 !== null && (current$$1.elementType === element.type || // Keep this check inline so it only runs on the false path:
        isCompatibleFamilyForHotReloading(current$$1, element))) {
          // Move based on index
          var existing = useFiber(current$$1, element.props, expirationTime);
          existing.ref = coerceRef(returnFiber, current$$1, element);
          existing.return = returnFiber;
          {
            existing._debugSource = element._source;
            existing._debugOwner = element._owner;
          }
          return existing;
        } else {
          // Insert
          var created = createFiberFromElement(element, returnFiber.mode, expirationTime);
          created.ref = coerceRef(returnFiber, current$$1, element);
          created.return = returnFiber;
          return created;
        }
      }

      function updatePortal(returnFiber, current$$1, portal, expirationTime) {
        if (current$$1 === null || current$$1.tag !== HostPortal || current$$1.stateNode.containerInfo !== portal.containerInfo || current$$1.stateNode.implementation !== portal.implementation) {
          // Insert
          var created = createFiberFromPortal(portal, returnFiber.mode, expirationTime);
          created.return = returnFiber;
          return created;
        } else {
          // Update
          var existing = useFiber(current$$1, portal.children || [], expirationTime);
          existing.return = returnFiber;
          return existing;
        }
      }

      function updateFragment(returnFiber, current$$1, fragment, expirationTime, key) {
        if (current$$1 === null || current$$1.tag !== Fragment) {
          // Insert
          var created = createFiberFromFragment(fragment, returnFiber.mode, expirationTime, key);
          created.return = returnFiber;
          return created;
        } else {
          // Update
          var existing = useFiber(current$$1, fragment, expirationTime);
          existing.return = returnFiber;
          return existing;
        }
      }

      function createChild(returnFiber, newChild, expirationTime) {
        if (typeof newChild === 'string' || typeof newChild === 'number') {
          // Text nodes don't have keys. If the previous node is implicitly keyed
          // we can continue to replace it without aborting even if it is not a text
          // node.
          var created = createFiberFromText('' + newChild, returnFiber.mode, expirationTime);
          created.return = returnFiber;
          return created;
        }

        if (typeof newChild === 'object' && newChild !== null) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              {
                var _created = createFiberFromElement(newChild, returnFiber.mode, expirationTime);

                _created.ref = coerceRef(returnFiber, null, newChild);
                _created.return = returnFiber;
                return _created;
              }

            case REACT_PORTAL_TYPE:
              {
                var _created2 = createFiberFromPortal(newChild, returnFiber.mode, expirationTime);

                _created2.return = returnFiber;
                return _created2;
              }
          }

          if (isArray(newChild) || getIteratorFn(newChild)) {
            var _created3 = createFiberFromFragment(newChild, returnFiber.mode, expirationTime, null);

            _created3.return = returnFiber;
            return _created3;
          }

          throwOnInvalidObjectType(returnFiber, newChild);
        }

        {
          if (typeof newChild === 'function') {
            warnOnFunctionType();
          }
        }
        return null;
      }

      function updateSlot(returnFiber, oldFiber, newChild, expirationTime) {
        // Update the fiber if the keys match, otherwise return null.
        var key = oldFiber !== null ? oldFiber.key : null;

        if (typeof newChild === 'string' || typeof newChild === 'number') {
          // Text nodes don't have keys. If the previous node is implicitly keyed
          // we can continue to replace it without aborting even if it is not a text
          // node.
          if (key !== null) {
            return null;
          }

          return updateTextNode(returnFiber, oldFiber, '' + newChild, expirationTime);
        }

        if (typeof newChild === 'object' && newChild !== null) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              {
                if (newChild.key === key) {
                  if (newChild.type === REACT_FRAGMENT_TYPE) {
                    return updateFragment(returnFiber, oldFiber, newChild.props.children, expirationTime, key);
                  }

                  return updateElement(returnFiber, oldFiber, newChild, expirationTime);
                } else {
                  return null;
                }
              }

            case REACT_PORTAL_TYPE:
              {
                if (newChild.key === key) {
                  return updatePortal(returnFiber, oldFiber, newChild, expirationTime);
                } else {
                  return null;
                }
              }
          }

          if (isArray(newChild) || getIteratorFn(newChild)) {
            if (key !== null) {
              return null;
            }

            return updateFragment(returnFiber, oldFiber, newChild, expirationTime, null);
          }

          throwOnInvalidObjectType(returnFiber, newChild);
        }

        {
          if (typeof newChild === 'function') {
            warnOnFunctionType();
          }
        }
        return null;
      }

      function updateFromMap(existingChildren, returnFiber, newIdx, newChild, expirationTime) {
        if (typeof newChild === 'string' || typeof newChild === 'number') {
          // Text nodes don't have keys, so we neither have to check the old nor
          // new node for the key. If both are text nodes, they match.
          var matchedFiber = existingChildren.get(newIdx) || null;
          return updateTextNode(returnFiber, matchedFiber, '' + newChild, expirationTime);
        }

        if (typeof newChild === 'object' && newChild !== null) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              {
                var _matchedFiber = existingChildren.get(newChild.key === null ? newIdx : newChild.key) || null;

                if (newChild.type === REACT_FRAGMENT_TYPE) {
                  return updateFragment(returnFiber, _matchedFiber, newChild.props.children, expirationTime, newChild.key);
                }

                return updateElement(returnFiber, _matchedFiber, newChild, expirationTime);
              }

            case REACT_PORTAL_TYPE:
              {
                var _matchedFiber2 = existingChildren.get(newChild.key === null ? newIdx : newChild.key) || null;

                return updatePortal(returnFiber, _matchedFiber2, newChild, expirationTime);
              }
          }

          if (isArray(newChild) || getIteratorFn(newChild)) {
            var _matchedFiber3 = existingChildren.get(newIdx) || null;

            return updateFragment(returnFiber, _matchedFiber3, newChild, expirationTime, null);
          }

          throwOnInvalidObjectType(returnFiber, newChild);
        }

        {
          if (typeof newChild === 'function') {
            warnOnFunctionType();
          }
        }
        return null;
      }
      /**
       * Warns if there is a duplicate or missing key
       */


      function warnOnInvalidKey(child, knownKeys) {
        {
          if (typeof child !== 'object' || child === null) {
            return knownKeys;
          }

          switch (child.$$typeof) {
            case REACT_ELEMENT_TYPE:
            case REACT_PORTAL_TYPE:
              warnForMissingKey(child);
              var key = child.key;

              if (typeof key !== 'string') {
                break;
              }

              if (knownKeys === null) {
                knownKeys = new Set();
                knownKeys.add(key);
                break;
              }

              if (!knownKeys.has(key)) {
                knownKeys.add(key);
                break;
              }

              warning$1(false, 'Encountered two children with the same key, `%s`. ' + 'Keys should be unique so that components maintain their identity ' + 'across updates. Non-unique keys may cause children to be ' + 'duplicated and/or omitted — the behavior is unsupported and ' + 'could change in a future version.', key);
              break;

            default:
              break;
          }
        }
        return knownKeys;
      }

      function reconcileChildrenArray(returnFiber, currentFirstChild, newChildren, expirationTime) {
        // This algorithm can't optimize by searching from both ends since we
        // don't have backpointers on fibers. I'm trying to see how far we can get
        // with that model. If it ends up not being worth the tradeoffs, we can
        // add it later.
        // Even with a two ended optimization, we'd want to optimize for the case
        // where there are few changes and brute force the comparison instead of
        // going for the Map. It'd like to explore hitting that path first in
        // forward-only mode and only go for the Map once we notice that we need
        // lots of look ahead. This doesn't handle reversal as well as two ended
        // search but that's unusual. Besides, for the two ended optimization to
        // work on Iterables, we'd need to copy the whole set.
        // In this first iteration, we'll just live with hitting the bad case
        // (adding everything to a Map) in for every insert/move.
        // If you change this code, also update reconcileChildrenIterator() which
        // uses the same algorithm.
        {
          // First, validate keys.
          var knownKeys = null;

          for (var i = 0; i < newChildren.length; i++) {
            var child = newChildren[i];
            knownKeys = warnOnInvalidKey(child, knownKeys);
          }
        }
        var resultingFirstChild = null;
        var previousNewFiber = null;
        var oldFiber = currentFirstChild;
        var lastPlacedIndex = 0;
        var newIdx = 0;
        var nextOldFiber = null;

        for (; oldFiber !== null && newIdx < newChildren.length; newIdx++) {
          if (oldFiber.index > newIdx) {
            nextOldFiber = oldFiber;
            oldFiber = null;
          } else {
            nextOldFiber = oldFiber.sibling;
          }

          var newFiber = updateSlot(returnFiber, oldFiber, newChildren[newIdx], expirationTime);

          if (newFiber === null) {
            // TODO: This breaks on empty slots like null children. That's
            // unfortunate because it triggers the slow path all the time. We need
            // a better way to communicate whether this was a miss or null,
            // boolean, undefined, etc.
            if (oldFiber === null) {
              oldFiber = nextOldFiber;
            }

            break;
          }

          if (shouldTrackSideEffects) {
            if (oldFiber && newFiber.alternate === null) {
              // We matched the slot, but we didn't reuse the existing fiber, so we
              // need to delete the existing child.
              deleteChild(returnFiber, oldFiber);
            }
          }

          lastPlacedIndex = placeChild(newFiber, lastPlacedIndex, newIdx);

          if (previousNewFiber === null) {
            // TODO: Move out of the loop. This only happens for the first run.
            resultingFirstChild = newFiber;
          } else {
            // TODO: Defer siblings if we're not at the right index for this slot.
            // I.e. if we had null values before, then we want to defer this
            // for each null value. However, we also don't want to call updateSlot
            // with the previous one.
            previousNewFiber.sibling = newFiber;
          }

          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }

        if (newIdx === newChildren.length) {
          // We've reached the end of the new children. We can delete the rest.
          deleteRemainingChildren(returnFiber, oldFiber);
          return resultingFirstChild;
        }

        if (oldFiber === null) {
          // If we don't have any more existing children we can choose a fast path
          // since the rest will all be insertions.
          for (; newIdx < newChildren.length; newIdx++) {
            var _newFiber = createChild(returnFiber, newChildren[newIdx], expirationTime);

            if (_newFiber === null) {
              continue;
            }

            lastPlacedIndex = placeChild(_newFiber, lastPlacedIndex, newIdx);

            if (previousNewFiber === null) {
              // TODO: Move out of the loop. This only happens for the first run.
              resultingFirstChild = _newFiber;
            } else {
              previousNewFiber.sibling = _newFiber;
            }

            previousNewFiber = _newFiber;
          }

          return resultingFirstChild;
        } // Add all children to a key map for quick lookups.


        var existingChildren = mapRemainingChildren(returnFiber, oldFiber); // Keep scanning and use the map to restore deleted items as moves.

        for (; newIdx < newChildren.length; newIdx++) {
          var _newFiber2 = updateFromMap(existingChildren, returnFiber, newIdx, newChildren[newIdx], expirationTime);

          if (_newFiber2 !== null) {
            if (shouldTrackSideEffects) {
              if (_newFiber2.alternate !== null) {
                // The new fiber is a work in progress, but if there exists a
                // current, that means that we reused the fiber. We need to delete
                // it from the child list so that we don't add it to the deletion
                // list.
                existingChildren.delete(_newFiber2.key === null ? newIdx : _newFiber2.key);
              }
            }

            lastPlacedIndex = placeChild(_newFiber2, lastPlacedIndex, newIdx);

            if (previousNewFiber === null) {
              resultingFirstChild = _newFiber2;
            } else {
              previousNewFiber.sibling = _newFiber2;
            }

            previousNewFiber = _newFiber2;
          }
        }

        if (shouldTrackSideEffects) {
          // Any existing children that weren't consumed above were deleted. We need
          // to add them to the deletion list.
          existingChildren.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        }

        return resultingFirstChild;
      }

      function reconcileChildrenIterator(returnFiber, currentFirstChild, newChildrenIterable, expirationTime) {
        // This is the same implementation as reconcileChildrenArray(),
        // but using the iterator instead.
        var iteratorFn = getIteratorFn(newChildrenIterable);

        if (!(typeof iteratorFn === 'function')) {
          {
            throw Error("An object is not an iterable. This error is likely caused by a bug in React. Please file an issue.");
          }
        }

        {
          // We don't support rendering Generators because it's a mutation.
          // See https://github.com/facebook/react/issues/12995
          if (typeof Symbol === 'function' && // $FlowFixMe Flow doesn't know about toStringTag
          newChildrenIterable[Symbol.toStringTag] === 'Generator') {
            !didWarnAboutGenerators ? warning$1(false, 'Using Generators as children is unsupported and will likely yield ' + 'unexpected results because enumerating a generator mutates it. ' + 'You may convert it to an array with `Array.from()` or the ' + '`[...spread]` operator before rendering. Keep in mind ' + 'you might need to polyfill these features for older browsers.') : void 0;
            didWarnAboutGenerators = true;
          } // Warn about using Maps as children


          if (newChildrenIterable.entries === iteratorFn) {
            !didWarnAboutMaps ? warning$1(false, 'Using Maps as children is unsupported and will likely yield ' + 'unexpected results. Convert it to a sequence/iterable of keyed ' + 'ReactElements instead.') : void 0;
            didWarnAboutMaps = true;
          } // First, validate keys.
          // We'll get a different iterator later for the main pass.


          var _newChildren = iteratorFn.call(newChildrenIterable);

          if (_newChildren) {
            var knownKeys = null;

            var _step = _newChildren.next();

            for (; !_step.done; _step = _newChildren.next()) {
              var child = _step.value;
              knownKeys = warnOnInvalidKey(child, knownKeys);
            }
          }
        }
        var newChildren = iteratorFn.call(newChildrenIterable);

        if (!(newChildren != null)) {
          {
            throw Error("An iterable object provided no iterator.");
          }
        }

        var resultingFirstChild = null;
        var previousNewFiber = null;
        var oldFiber = currentFirstChild;
        var lastPlacedIndex = 0;
        var newIdx = 0;
        var nextOldFiber = null;
        var step = newChildren.next();

        for (; oldFiber !== null && !step.done; newIdx++, step = newChildren.next()) {
          if (oldFiber.index > newIdx) {
            nextOldFiber = oldFiber;
            oldFiber = null;
          } else {
            nextOldFiber = oldFiber.sibling;
          }

          var newFiber = updateSlot(returnFiber, oldFiber, step.value, expirationTime);

          if (newFiber === null) {
            // TODO: This breaks on empty slots like null children. That's
            // unfortunate because it triggers the slow path all the time. We need
            // a better way to communicate whether this was a miss or null,
            // boolean, undefined, etc.
            if (oldFiber === null) {
              oldFiber = nextOldFiber;
            }

            break;
          }

          if (shouldTrackSideEffects) {
            if (oldFiber && newFiber.alternate === null) {
              // We matched the slot, but we didn't reuse the existing fiber, so we
              // need to delete the existing child.
              deleteChild(returnFiber, oldFiber);
            }
          }

          lastPlacedIndex = placeChild(newFiber, lastPlacedIndex, newIdx);

          if (previousNewFiber === null) {
            // TODO: Move out of the loop. This only happens for the first run.
            resultingFirstChild = newFiber;
          } else {
            // TODO: Defer siblings if we're not at the right index for this slot.
            // I.e. if we had null values before, then we want to defer this
            // for each null value. However, we also don't want to call updateSlot
            // with the previous one.
            previousNewFiber.sibling = newFiber;
          }

          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }

        if (step.done) {
          // We've reached the end of the new children. We can delete the rest.
          deleteRemainingChildren(returnFiber, oldFiber);
          return resultingFirstChild;
        }

        if (oldFiber === null) {
          // If we don't have any more existing children we can choose a fast path
          // since the rest will all be insertions.
          for (; !step.done; newIdx++, step = newChildren.next()) {
            var _newFiber3 = createChild(returnFiber, step.value, expirationTime);

            if (_newFiber3 === null) {
              continue;
            }

            lastPlacedIndex = placeChild(_newFiber3, lastPlacedIndex, newIdx);

            if (previousNewFiber === null) {
              // TODO: Move out of the loop. This only happens for the first run.
              resultingFirstChild = _newFiber3;
            } else {
              previousNewFiber.sibling = _newFiber3;
            }

            previousNewFiber = _newFiber3;
          }

          return resultingFirstChild;
        } // Add all children to a key map for quick lookups.


        var existingChildren = mapRemainingChildren(returnFiber, oldFiber); // Keep scanning and use the map to restore deleted items as moves.

        for (; !step.done; newIdx++, step = newChildren.next()) {
          var _newFiber4 = updateFromMap(existingChildren, returnFiber, newIdx, step.value, expirationTime);

          if (_newFiber4 !== null) {
            if (shouldTrackSideEffects) {
              if (_newFiber4.alternate !== null) {
                // The new fiber is a work in progress, but if there exists a
                // current, that means that we reused the fiber. We need to delete
                // it from the child list so that we don't add it to the deletion
                // list.
                existingChildren.delete(_newFiber4.key === null ? newIdx : _newFiber4.key);
              }
            }

            lastPlacedIndex = placeChild(_newFiber4, lastPlacedIndex, newIdx);

            if (previousNewFiber === null) {
              resultingFirstChild = _newFiber4;
            } else {
              previousNewFiber.sibling = _newFiber4;
            }

            previousNewFiber = _newFiber4;
          }
        }

        if (shouldTrackSideEffects) {
          // Any existing children that weren't consumed above were deleted. We need
          // to add them to the deletion list.
          existingChildren.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        }

        return resultingFirstChild;
      }

      function reconcileSingleTextNode(returnFiber, currentFirstChild, textContent, expirationTime) {
        // There's no need to check for keys on text nodes since we don't have a
        // way to define them.
        if (currentFirstChild !== null && currentFirstChild.tag === HostText) {
          // We already have an existing node so let's just update it and delete
          // the rest.
          deleteRemainingChildren(returnFiber, currentFirstChild.sibling);
          var existing = useFiber(currentFirstChild, textContent, expirationTime);
          existing.return = returnFiber;
          return existing;
        } // The existing first child is not a text node so we need to create one
        // and delete the existing ones.


        deleteRemainingChildren(returnFiber, currentFirstChild);
        var created = createFiberFromText(textContent, returnFiber.mode, expirationTime);
        created.return = returnFiber;
        return created;
      }

      function reconcileSingleElement(returnFiber, currentFirstChild, element, expirationTime) {
        var key = element.key;
        var child = currentFirstChild;

        while (child !== null) {
          // TODO: If key === null and child.key === null, then this only applies to
          // the first item in the list.
          if (child.key === key) {
            if (child.tag === Fragment ? element.type === REACT_FRAGMENT_TYPE : child.elementType === element.type || // Keep this check inline so it only runs on the false path:
            isCompatibleFamilyForHotReloading(child, element)) {
              deleteRemainingChildren(returnFiber, child.sibling);
              var existing = useFiber(child, element.type === REACT_FRAGMENT_TYPE ? element.props.children : element.props, expirationTime);
              existing.ref = coerceRef(returnFiber, child, element);
              existing.return = returnFiber;
              {
                existing._debugSource = element._source;
                existing._debugOwner = element._owner;
              }
              return existing;
            } else {
              deleteRemainingChildren(returnFiber, child);
              break;
            }
          } else {
            deleteChild(returnFiber, child);
          }

          child = child.sibling;
        }

        if (element.type === REACT_FRAGMENT_TYPE) {
          var created = createFiberFromFragment(element.props.children, returnFiber.mode, expirationTime, element.key);
          created.return = returnFiber;
          return created;
        } else {
          var _created4 = createFiberFromElement(element, returnFiber.mode, expirationTime);

          _created4.ref = coerceRef(returnFiber, currentFirstChild, element);
          _created4.return = returnFiber;
          return _created4;
        }
      }

      function reconcileSinglePortal(returnFiber, currentFirstChild, portal, expirationTime) {
        var key = portal.key;
        var child = currentFirstChild;

        while (child !== null) {
          // TODO: If key === null and child.key === null, then this only applies to
          // the first item in the list.
          if (child.key === key) {
            if (child.tag === HostPortal && child.stateNode.containerInfo === portal.containerInfo && child.stateNode.implementation === portal.implementation) {
              deleteRemainingChildren(returnFiber, child.sibling);
              var existing = useFiber(child, portal.children || [], expirationTime);
              existing.return = returnFiber;
              return existing;
            } else {
              deleteRemainingChildren(returnFiber, child);
              break;
            }
          } else {
            deleteChild(returnFiber, child);
          }

          child = child.sibling;
        }

        var created = createFiberFromPortal(portal, returnFiber.mode, expirationTime);
        created.return = returnFiber;
        return created;
      } // This API will tag the children with the side-effect of the reconciliation
      // itself. They will be added to the side-effect list as we pass through the
      // children and the parent.


      function reconcileChildFibers(returnFiber, currentFirstChild, newChild, expirationTime) {
        // This function is not recursive.
        // If the top level item is an array, we treat it as a set of children,
        // not as a fragment. Nested arrays on the other hand will be treated as
        // fragment nodes. Recursion happens at the normal flow.
        // Handle top level unkeyed fragments as if they were arrays.
        // This leads to an ambiguity between <>{[...]}</> and <>...</>.
        // We treat the ambiguous cases above the same.
        var isUnkeyedTopLevelFragment = typeof newChild === 'object' && newChild !== null && newChild.type === REACT_FRAGMENT_TYPE && newChild.key === null;

        if (isUnkeyedTopLevelFragment) {
          newChild = newChild.props.children;
        } // Handle object types


        var isObject = typeof newChild === 'object' && newChild !== null;

        if (isObject) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return placeSingleChild(reconcileSingleElement(returnFiber, currentFirstChild, newChild, expirationTime));

            case REACT_PORTAL_TYPE:
              return placeSingleChild(reconcileSinglePortal(returnFiber, currentFirstChild, newChild, expirationTime));
          }
        }

        if (typeof newChild === 'string' || typeof newChild === 'number') {
          return placeSingleChild(reconcileSingleTextNode(returnFiber, currentFirstChild, '' + newChild, expirationTime));
        }

        if (isArray(newChild)) {
          return reconcileChildrenArray(returnFiber, currentFirstChild, newChild, expirationTime);
        }

        if (getIteratorFn(newChild)) {
          return reconcileChildrenIterator(returnFiber, currentFirstChild, newChild, expirationTime);
        }

        if (isObject) {
          throwOnInvalidObjectType(returnFiber, newChild);
        }

        {
          if (typeof newChild === 'function') {
            warnOnFunctionType();
          }
        }

        if (typeof newChild === 'undefined' && !isUnkeyedTopLevelFragment) {
          // If the new child is undefined, and the return fiber is a composite
          // component, throw an error. If Fiber return types are disabled,
          // we already threw above.
          switch (returnFiber.tag) {
            case ClassComponent:
              {
                {
                  var instance = returnFiber.stateNode;

                  if (instance.render._isMockFunction) {
                    // We allow auto-mocks to proceed as if they're returning null.
                    break;
                  }
                }
              }
            // Intentionally fall through to the next case, which handles both
            // functions and classes
            // eslint-disable-next-lined no-fallthrough

            case FunctionComponent:
              {
                var Component = returnFiber.type;
                {
                  {
                    throw Error((Component.displayName || Component.name || 'Component') + "(...): Nothing was returned from render. This usually means a return statement is missing. Or, to render nothing, return null.");
                  }
                }
              }
          }
        } // Remaining cases are all treated as empty.


        return deleteRemainingChildren(returnFiber, currentFirstChild);
      }

      return reconcileChildFibers;
    }

    var reconcileChildFibers = ChildReconciler(true);
    var mountChildFibers = ChildReconciler(false);

    function cloneChildFibers(current$$1, workInProgress) {
      if (!(current$$1 === null || workInProgress.child === current$$1.child)) {
        {
          throw Error("Resuming work not yet implemented.");
        }
      }

      if (workInProgress.child === null) {
        return;
      }

      var currentChild = workInProgress.child;
      var newChild = createWorkInProgress(currentChild, currentChild.pendingProps, currentChild.expirationTime);
      workInProgress.child = newChild;
      newChild.return = workInProgress;

      while (currentChild.sibling !== null) {
        currentChild = currentChild.sibling;
        newChild = newChild.sibling = createWorkInProgress(currentChild, currentChild.pendingProps, currentChild.expirationTime);
        newChild.return = workInProgress;
      }

      newChild.sibling = null;
    } // Reset a workInProgress child set to prepare it for a second pass.


    function resetChildFibers(workInProgress, renderExpirationTime) {
      var child = workInProgress.child;

      while (child !== null) {
        resetWorkInProgress(child, renderExpirationTime);
        child = child.sibling;
      }
    }

    var NO_CONTEXT = {};
    var contextStackCursor$1 = createCursor(NO_CONTEXT);
    var contextFiberStackCursor = createCursor(NO_CONTEXT);
    var rootInstanceStackCursor = createCursor(NO_CONTEXT);

    function requiredContext(c) {
      if (!(c !== NO_CONTEXT)) {
        {
          throw Error("Expected host context to exist. This error is likely caused by a bug in React. Please file an issue.");
        }
      }

      return c;
    }

    function getRootHostContainer() {
      var rootInstance = requiredContext(rootInstanceStackCursor.current);
      return rootInstance;
    }

    function pushHostContainer(fiber, nextRootInstance) {
      // Push current root instance onto the stack;
      // This allows us to reset root when portals are popped.
      push(rootInstanceStackCursor, nextRootInstance, fiber); // Track the context and the Fiber that provided it.
      // This enables us to pop only Fibers that provide unique contexts.

      push(contextFiberStackCursor, fiber, fiber); // Finally, we need to push the host context to the stack.
      // However, we can't just call getRootHostContext() and push it because
      // we'd have a different number of entries on the stack depending on
      // whether getRootHostContext() throws somewhere in renderer code or not.
      // So we push an empty value first. This lets us safely unwind on errors.

      push(contextStackCursor$1, NO_CONTEXT, fiber);
      var nextRootContext = getRootHostContext(nextRootInstance); // Now that we know this function doesn't throw, replace it.

      pop(contextStackCursor$1, fiber);
      push(contextStackCursor$1, nextRootContext, fiber);
    }

    function popHostContainer(fiber) {
      pop(contextStackCursor$1, fiber);
      pop(contextFiberStackCursor, fiber);
      pop(rootInstanceStackCursor, fiber);
    }

    function getHostContext() {
      var context = requiredContext(contextStackCursor$1.current);
      return context;
    }

    function pushHostContext(fiber) {
      var rootInstance = requiredContext(rootInstanceStackCursor.current);
      var context = requiredContext(contextStackCursor$1.current);
      var nextContext = getChildHostContext(context, fiber.type, rootInstance); // Don't push this Fiber's context unless it's unique.

      if (context === nextContext) {
        return;
      } // Track the context and the Fiber that provided it.
      // This enables us to pop only Fibers that provide unique contexts.


      push(contextFiberStackCursor, fiber, fiber);
      push(contextStackCursor$1, nextContext, fiber);
    }

    function popHostContext(fiber) {
      // Do not pop unless this Fiber provided the current context.
      // pushHostContext() only pushes Fibers that provide unique contexts.
      if (contextFiberStackCursor.current !== fiber) {
        return;
      }

      pop(contextStackCursor$1, fiber);
      pop(contextFiberStackCursor, fiber);
    }

    var DefaultSuspenseContext = 0; // The Suspense Context is split into two parts. The lower bits is
    // inherited deeply down the subtree. The upper bits only affect
    // this immediate suspense boundary and gets reset each new
    // boundary or suspense list.

    var SubtreeSuspenseContextMask = 1; // Subtree Flags:
    // InvisibleParentSuspenseContext indicates that one of our parent Suspense
    // boundaries is not currently showing visible main content.
    // Either because it is already showing a fallback or is not mounted at all.
    // We can use this to determine if it is desirable to trigger a fallback at
    // the parent. If not, then we might need to trigger undesirable boundaries
    // and/or suspend the commit to avoid hiding the parent content.

    var InvisibleParentSuspenseContext = 1; // Shallow Flags:
    // ForceSuspenseFallback can be used by SuspenseList to force newly added
    // items into their fallback state during one of the render passes.

    var ForceSuspenseFallback = 2;
    var suspenseStackCursor = createCursor(DefaultSuspenseContext);

    function hasSuspenseContext(parentContext, flag) {
      return (parentContext & flag) !== 0;
    }

    function setDefaultShallowSuspenseContext(parentContext) {
      return parentContext & SubtreeSuspenseContextMask;
    }

    function setShallowSuspenseContext(parentContext, shallowContext) {
      return parentContext & SubtreeSuspenseContextMask | shallowContext;
    }

    function addSubtreeSuspenseContext(parentContext, subtreeContext) {
      return parentContext | subtreeContext;
    }

    function pushSuspenseContext(fiber, newContext) {
      push(suspenseStackCursor, newContext, fiber);
    }

    function popSuspenseContext(fiber) {
      pop(suspenseStackCursor, fiber);
    }

    function shouldCaptureSuspense(workInProgress, hasInvisibleParent) {
      // If it was the primary children that just suspended, capture and render the
      // fallback. Otherwise, don't capture and bubble to the next boundary.
      var nextState = workInProgress.memoizedState;

      if (nextState !== null) {
        if (nextState.dehydrated !== null) {
          // A dehydrated boundary always captures.
          return true;
        }

        return false;
      }

      var props = workInProgress.memoizedProps; // In order to capture, the Suspense component must have a fallback prop.

      if (props.fallback === undefined) {
        return false;
      } // Regular boundaries always capture.


      if (props.unstable_avoidThisFallback !== true) {
        return true;
      } // If it's a boundary we should avoid, then we prefer to bubble up to the
      // parent boundary if it is currently invisible.


      if (hasInvisibleParent) {
        return false;
      } // If the parent is not able to handle it, we must handle it.


      return true;
    }

    function findFirstSuspended(row) {
      var node = row;

      while (node !== null) {
        if (node.tag === SuspenseComponent) {
          var state = node.memoizedState;

          if (state !== null) {
            var dehydrated = state.dehydrated;

            if (dehydrated === null || isSuspenseInstancePending(dehydrated) || isSuspenseInstanceFallback(dehydrated)) {
              return node;
            }
          }
        } else if (node.tag === SuspenseListComponent && // revealOrder undefined can't be trusted because it don't
        // keep track of whether it suspended or not.
        node.memoizedProps.revealOrder !== undefined) {
          var didSuspend = (node.effectTag & DidCapture) !== NoEffect;

          if (didSuspend) {
            return node;
          }
        } else if (node.child !== null) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === row) {
          return null;
        }

        while (node.sibling === null) {
          if (node.return === null || node.return === row) {
            return null;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      }

      return null;
    }

    var emptyObject = {};
    var isArray$2 = Array.isArray;

    function createResponderInstance(responder, responderProps, responderState, fiber) {
      return {
        fiber: fiber,
        props: responderProps,
        responder: responder,
        rootEventTypes: null,
        state: responderState
      };
    }

    function mountEventResponder$1(responder, responderProps, fiber, respondersMap, rootContainerInstance) {
      var responderState = emptyObject;
      var getInitialState = responder.getInitialState;

      if (getInitialState !== null) {
        responderState = getInitialState(responderProps);
      }

      var responderInstance = createResponderInstance(responder, responderProps, responderState, fiber);

      if (!rootContainerInstance) {
        var node = fiber;

        while (node !== null) {
          var tag = node.tag;

          if (tag === HostComponent) {
            rootContainerInstance = node.stateNode;
            break;
          } else if (tag === HostRoot) {
            rootContainerInstance = node.stateNode.containerInfo;
            break;
          }

          node = node.return;
        }
      }

      mountResponderInstance(responder, responderInstance, responderProps, responderState, rootContainerInstance);
      respondersMap.set(responder, responderInstance);
    }

    function updateEventListener(listener, fiber, visistedResponders, respondersMap, rootContainerInstance) {
      var responder;
      var props;

      if (listener) {
        responder = listener.responder;
        props = listener.props;
      }

      if (!(responder && responder.$$typeof === REACT_RESPONDER_TYPE)) {
        {
          throw Error("An invalid value was used as an event listener. Expect one or many event listeners created via React.unstable_useResponder().");
        }
      }

      var listenerProps = props;

      if (visistedResponders.has(responder)) {
        // show warning
        {
          warning$1(false, 'Duplicate event responder "%s" found in event listeners. ' + 'Event listeners passed to elements cannot use the same event responder more than once.', responder.displayName);
        }
        return;
      }

      visistedResponders.add(responder);
      var responderInstance = respondersMap.get(responder);

      if (responderInstance === undefined) {
        // Mount (happens in either complete or commit phase)
        mountEventResponder$1(responder, listenerProps, fiber, respondersMap, rootContainerInstance);
      } else {
        // Update (happens during commit phase only)
        responderInstance.props = listenerProps;
        responderInstance.fiber = fiber;
      }
    }

    function updateEventListeners(listeners, fiber, rootContainerInstance) {
      var visistedResponders = new Set();
      var dependencies = fiber.dependencies;

      if (listeners != null) {
        if (dependencies === null) {
          dependencies = fiber.dependencies = {
            expirationTime: NoWork,
            firstContext: null,
            responders: new Map()
          };
        }

        var respondersMap = dependencies.responders;

        if (respondersMap === null) {
          respondersMap = new Map();
        }

        if (isArray$2(listeners)) {
          for (var i = 0, length = listeners.length; i < length; i++) {
            var listener = listeners[i];
            updateEventListener(listener, fiber, visistedResponders, respondersMap, rootContainerInstance);
          }
        } else {
          updateEventListener(listeners, fiber, visistedResponders, respondersMap, rootContainerInstance);
        }
      }

      if (dependencies !== null) {
        var _respondersMap = dependencies.responders;

        if (_respondersMap !== null) {
          // Unmount
          var mountedResponders = Array.from(_respondersMap.keys());

          for (var _i = 0, _length = mountedResponders.length; _i < _length; _i++) {
            var mountedResponder = mountedResponders[_i];

            if (!visistedResponders.has(mountedResponder)) {
              var responderInstance = _respondersMap.get(mountedResponder);

              unmountResponderInstance(responderInstance);

              _respondersMap.delete(mountedResponder);
            }
          }
        }
      }
    }

    function createResponderListener(responder, props) {
      var eventResponderListener = {
        responder: responder,
        props: props
      };
      {
        Object.freeze(eventResponderListener);
      }
      return eventResponderListener;
    }

    var NoEffect$1 =
    /*             */
    0;
    var UnmountSnapshot =
    /*      */
    2;
    var UnmountMutation =
    /*      */
    4;
    var MountMutation =
    /*        */
    8;
    var UnmountLayout =
    /*        */
    16;
    var MountLayout =
    /*          */
    32;
    var MountPassive =
    /*         */
    64;
    var UnmountPassive =
    /*       */
    128;
    var ReactCurrentDispatcher$1 = ReactSharedInternals.ReactCurrentDispatcher;
    var ReactCurrentBatchConfig$1 = ReactSharedInternals.ReactCurrentBatchConfig;
    var didWarnAboutMismatchedHooksForComponent;
    {
      didWarnAboutMismatchedHooksForComponent = new Set();
    } // These are set right before calling the component.

    var renderExpirationTime$1 = NoWork; // The work-in-progress fiber. I've named it differently to distinguish it from
    // the work-in-progress hook.

    var currentlyRenderingFiber$1 = null; // Hooks are stored as a linked list on the fiber's memoizedState field. The
    // current hook list is the list that belongs to the current fiber. The
    // work-in-progress hook list is a new list that will be added to the
    // work-in-progress fiber.

    var currentHook = null;
    var nextCurrentHook = null;
    var firstWorkInProgressHook = null;
    var workInProgressHook = null;
    var nextWorkInProgressHook = null;
    var remainingExpirationTime = NoWork;
    var componentUpdateQueue = null;
    var sideEffectTag = 0; // Updates scheduled during render will trigger an immediate re-render at the
    // end of the current pass. We can't store these updates on the normal queue,
    // because if the work is aborted, they should be discarded. Because this is
    // a relatively rare case, we also don't want to add an additional field to
    // either the hook or queue object types. So we store them in a lazily create
    // map of queue -> render-phase updates, which are discarded once the component
    // completes without re-rendering.
    // Whether an update was scheduled during the currently executing render pass.

    var didScheduleRenderPhaseUpdate = false; // Lazily created map of render-phase updates

    var renderPhaseUpdates = null; // Counter to prevent infinite loops.

    var numberOfReRenders = 0;
    var RE_RENDER_LIMIT = 25; // In DEV, this is the name of the currently executing primitive hook

    var currentHookNameInDev = null; // In DEV, this list ensures that hooks are called in the same order between renders.
    // The list stores the order of hooks used during the initial render (mount).
    // Subsequent renders (updates) reference this list.

    var hookTypesDev = null;
    var hookTypesUpdateIndexDev = -1; // In DEV, this tracks whether currently rendering component needs to ignore
    // the dependencies for Hooks that need them (e.g. useEffect or useMemo).
    // When true, such Hooks will always be "remounted". Only used during hot reload.

    var ignorePreviousDependencies = false;

    function mountHookTypesDev() {
      {
        var hookName = currentHookNameInDev;

        if (hookTypesDev === null) {
          hookTypesDev = [hookName];
        } else {
          hookTypesDev.push(hookName);
        }
      }
    }

    function updateHookTypesDev() {
      {
        var hookName = currentHookNameInDev;

        if (hookTypesDev !== null) {
          hookTypesUpdateIndexDev++;

          if (hookTypesDev[hookTypesUpdateIndexDev] !== hookName) {
            warnOnHookMismatchInDev(hookName);
          }
        }
      }
    }

    function checkDepsAreArrayDev(deps) {
      {
        if (deps !== undefined && deps !== null && !Array.isArray(deps)) {
          // Verify deps, but only on mount to avoid extra checks.
          // It's unlikely their type would change as usually you define them inline.
          warning$1(false, '%s received a final argument that is not an array (instead, received `%s`). When ' + 'specified, the final argument must be an array.', currentHookNameInDev, typeof deps);
        }
      }
    }

    function warnOnHookMismatchInDev(currentHookName) {
      {
        var componentName = getComponentName(currentlyRenderingFiber$1.type);

        if (!didWarnAboutMismatchedHooksForComponent.has(componentName)) {
          didWarnAboutMismatchedHooksForComponent.add(componentName);

          if (hookTypesDev !== null) {
            var table = '';
            var secondColumnStart = 30;

            for (var i = 0; i <= hookTypesUpdateIndexDev; i++) {
              var oldHookName = hookTypesDev[i];
              var newHookName = i === hookTypesUpdateIndexDev ? currentHookName : oldHookName;
              var row = i + 1 + ". " + oldHookName; // Extra space so second column lines up
              // lol @ IE not supporting String#repeat

              while (row.length < secondColumnStart) {
                row += ' ';
              }

              row += newHookName + '\n';
              table += row;
            }

            warning$1(false, 'React has detected a change in the order of Hooks called by %s. ' + 'This will lead to bugs and errors if not fixed. ' + 'For more information, read the Rules of Hooks: https://fb.me/rules-of-hooks\n\n' + '   Previous render            Next render\n' + '   ------------------------------------------------------\n' + '%s' + '   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n', componentName, table);
          }
        }
      }
    }

    function throwInvalidHookError() {
      {
        {
          throw Error("Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\n1. You might have mismatching versions of React and the renderer (such as React DOM)\n2. You might be breaking the Rules of Hooks\n3. You might have more than one copy of React in the same app\nSee https://fb.me/react-invalid-hook-call for tips about how to debug and fix this problem.");
        }
      }
    }

    function areHookInputsEqual(nextDeps, prevDeps) {
      {
        if (ignorePreviousDependencies) {
          // Only true when this component is being hot reloaded.
          return false;
        }
      }

      if (prevDeps === null) {
        {
          warning$1(false, '%s received a final argument during this render, but not during ' + 'the previous render. Even though the final argument is optional, ' + 'its type cannot change between renders.', currentHookNameInDev);
        }
        return false;
      }

      {
        // Don't bother comparing lengths in prod because these arrays should be
        // passed inline.
        if (nextDeps.length !== prevDeps.length) {
          warning$1(false, 'The final argument passed to %s changed size between renders. The ' + 'order and size of this array must remain constant.\n\n' + 'Previous: %s\n' + 'Incoming: %s', currentHookNameInDev, "[" + prevDeps.join(', ') + "]", "[" + nextDeps.join(', ') + "]");
        }
      }

      for (var i = 0; i < prevDeps.length && i < nextDeps.length; i++) {
        if (is$1(nextDeps[i], prevDeps[i])) {
          continue;
        }

        return false;
      }

      return true;
    }

    function renderWithHooks(current, workInProgress, Component, props, refOrContext, nextRenderExpirationTime) {
      renderExpirationTime$1 = nextRenderExpirationTime;
      currentlyRenderingFiber$1 = workInProgress;
      nextCurrentHook = current !== null ? current.memoizedState : null;
      {
        hookTypesDev = current !== null ? current._debugHookTypes : null;
        hookTypesUpdateIndexDev = -1; // Used for hot reloading:

        ignorePreviousDependencies = current !== null && current.type !== workInProgress.type;
      } // The following should have already been reset
      // currentHook = null;
      // workInProgressHook = null;
      // remainingExpirationTime = NoWork;
      // componentUpdateQueue = null;
      // didScheduleRenderPhaseUpdate = false;
      // renderPhaseUpdates = null;
      // numberOfReRenders = 0;
      // sideEffectTag = 0;
      // TODO Warn if no hooks are used at all during mount, then some are used during update.
      // Currently we will identify the update render as a mount because nextCurrentHook === null.
      // This is tricky because it's valid for certain types of components (e.g. React.lazy)
      // Using nextCurrentHook to differentiate between mount/update only works if at least one stateful hook is used.
      // Non-stateful hooks (e.g. context) don't get added to memoizedState,
      // so nextCurrentHook would be null during updates and mounts.

      {
        if (nextCurrentHook !== null) {
          ReactCurrentDispatcher$1.current = HooksDispatcherOnUpdateInDEV;
        } else if (hookTypesDev !== null) {
          // This dispatcher handles an edge case where a component is updating,
          // but no stateful hooks have been used.
          // We want to match the production code behavior (which will use HooksDispatcherOnMount),
          // but with the extra DEV validation to ensure hooks ordering hasn't changed.
          // This dispatcher does that.
          ReactCurrentDispatcher$1.current = HooksDispatcherOnMountWithHookTypesInDEV;
        } else {
          ReactCurrentDispatcher$1.current = HooksDispatcherOnMountInDEV;
        }
      }
      var children = Component(props, refOrContext);

      if (didScheduleRenderPhaseUpdate) {
        do {
          didScheduleRenderPhaseUpdate = false;
          numberOfReRenders += 1;
          {
            // Even when hot reloading, allow dependencies to stabilize
            // after first render to prevent infinite render phase updates.
            ignorePreviousDependencies = false;
          } // Start over from the beginning of the list

          nextCurrentHook = current !== null ? current.memoizedState : null;
          nextWorkInProgressHook = firstWorkInProgressHook;
          currentHook = null;
          workInProgressHook = null;
          componentUpdateQueue = null;
          {
            // Also validate hook order for cascading updates.
            hookTypesUpdateIndexDev = -1;
          }
          ReactCurrentDispatcher$1.current = HooksDispatcherOnUpdateInDEV;
          children = Component(props, refOrContext);
        } while (didScheduleRenderPhaseUpdate);

        renderPhaseUpdates = null;
        numberOfReRenders = 0;
      } // We can assume the previous dispatcher is always this one, since we set it
      // at the beginning of the render phase and there's no re-entrancy.


      ReactCurrentDispatcher$1.current = ContextOnlyDispatcher;
      var renderedWork = currentlyRenderingFiber$1;
      renderedWork.memoizedState = firstWorkInProgressHook;
      renderedWork.expirationTime = remainingExpirationTime;
      renderedWork.updateQueue = componentUpdateQueue;
      renderedWork.effectTag |= sideEffectTag;
      {
        renderedWork._debugHookTypes = hookTypesDev;
      } // This check uses currentHook so that it works the same in DEV and prod bundles.
      // hookTypesDev could catch more cases (e.g. context) but only in DEV bundles.

      var didRenderTooFewHooks = currentHook !== null && currentHook.next !== null;
      renderExpirationTime$1 = NoWork;
      currentlyRenderingFiber$1 = null;
      currentHook = null;
      nextCurrentHook = null;
      firstWorkInProgressHook = null;
      workInProgressHook = null;
      nextWorkInProgressHook = null;
      {
        currentHookNameInDev = null;
        hookTypesDev = null;
        hookTypesUpdateIndexDev = -1;
      }
      remainingExpirationTime = NoWork;
      componentUpdateQueue = null;
      sideEffectTag = 0; // These were reset above
      // didScheduleRenderPhaseUpdate = false;
      // renderPhaseUpdates = null;
      // numberOfReRenders = 0;

      if (!!didRenderTooFewHooks) {
        {
          throw Error("Rendered fewer hooks than expected. This may be caused by an accidental early return statement.");
        }
      }

      return children;
    }

    function bailoutHooks(current, workInProgress, expirationTime) {
      workInProgress.updateQueue = current.updateQueue;
      workInProgress.effectTag &= ~(Passive | Update);

      if (current.expirationTime <= expirationTime) {
        current.expirationTime = NoWork;
      }
    }

    function resetHooks() {
      // We can assume the previous dispatcher is always this one, since we set it
      // at the beginning of the render phase and there's no re-entrancy.
      ReactCurrentDispatcher$1.current = ContextOnlyDispatcher; // This is used to reset the state of this module when a component throws.
      // It's also called inside mountIndeterminateComponent if we determine the
      // component is a module-style component.

      renderExpirationTime$1 = NoWork;
      currentlyRenderingFiber$1 = null;
      currentHook = null;
      nextCurrentHook = null;
      firstWorkInProgressHook = null;
      workInProgressHook = null;
      nextWorkInProgressHook = null;
      {
        hookTypesDev = null;
        hookTypesUpdateIndexDev = -1;
        currentHookNameInDev = null;
      }
      remainingExpirationTime = NoWork;
      componentUpdateQueue = null;
      sideEffectTag = 0;
      didScheduleRenderPhaseUpdate = false;
      renderPhaseUpdates = null;
      numberOfReRenders = 0;
    }

    function mountWorkInProgressHook() {
      var hook = {
        memoizedState: null,
        baseState: null,
        queue: null,
        baseUpdate: null,
        next: null
      };

      if (workInProgressHook === null) {
        // This is the first hook in the list
        firstWorkInProgressHook = workInProgressHook = hook;
      } else {
        // Append to the end of the list
        workInProgressHook = workInProgressHook.next = hook;
      }

      return workInProgressHook;
    }

    function updateWorkInProgressHook() {
      // This function is used both for updates and for re-renders triggered by a
      // render phase update. It assumes there is either a current hook we can
      // clone, or a work-in-progress hook from a previous render pass that we can
      // use as a base. When we reach the end of the base list, we must switch to
      // the dispatcher used for mounts.
      if (nextWorkInProgressHook !== null) {
        // There's already a work-in-progress. Reuse it.
        workInProgressHook = nextWorkInProgressHook;
        nextWorkInProgressHook = workInProgressHook.next;
        currentHook = nextCurrentHook;
        nextCurrentHook = currentHook !== null ? currentHook.next : null;
      } else {
        // Clone from the current hook.
        if (!(nextCurrentHook !== null)) {
          {
            throw Error("Rendered more hooks than during the previous render.");
          }
        }

        currentHook = nextCurrentHook;
        var newHook = {
          memoizedState: currentHook.memoizedState,
          baseState: currentHook.baseState,
          queue: currentHook.queue,
          baseUpdate: currentHook.baseUpdate,
          next: null
        };

        if (workInProgressHook === null) {
          // This is the first hook in the list.
          workInProgressHook = firstWorkInProgressHook = newHook;
        } else {
          // Append to the end of the list.
          workInProgressHook = workInProgressHook.next = newHook;
        }

        nextCurrentHook = currentHook.next;
      }

      return workInProgressHook;
    }

    function createFunctionComponentUpdateQueue() {
      return {
        lastEffect: null
      };
    }

    function basicStateReducer(state, action) {
      return typeof action === 'function' ? action(state) : action;
    }

    function mountReducer(reducer, initialArg, init) {
      var hook = mountWorkInProgressHook();
      var initialState;

      if (init !== undefined) {
        initialState = init(initialArg);
      } else {
        initialState = initialArg;
      }

      hook.memoizedState = hook.baseState = initialState;
      var queue = hook.queue = {
        last: null,
        dispatch: null,
        lastRenderedReducer: reducer,
        lastRenderedState: initialState
      };
      var dispatch = queue.dispatch = dispatchAction.bind(null, // Flow doesn't know this is non-null, but we do.
      currentlyRenderingFiber$1, queue);
      return [hook.memoizedState, dispatch];
    }

    function updateReducer(reducer, initialArg, init) {
      var hook = updateWorkInProgressHook();
      var queue = hook.queue;

      if (!(queue !== null)) {
        {
          throw Error("Should have a queue. This is likely a bug in React. Please file an issue.");
        }
      }

      queue.lastRenderedReducer = reducer;

      if (numberOfReRenders > 0) {
        // This is a re-render. Apply the new render phase updates to the previous
        // work-in-progress hook.
        var _dispatch = queue.dispatch;

        if (renderPhaseUpdates !== null) {
          // Render phase updates are stored in a map of queue -> linked list
          var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);

          if (firstRenderPhaseUpdate !== undefined) {
            renderPhaseUpdates.delete(queue);
            var newState = hook.memoizedState;
            var update = firstRenderPhaseUpdate;

            do {
              // Process this render phase update. We don't have to check the
              // priority because it will always be the same as the current
              // render's.
              var action = update.action;
              newState = reducer(newState, action);
              update = update.next;
            } while (update !== null); // Mark that the fiber performed work, but only if the new state is
            // different from the current state.


            if (!is$1(newState, hook.memoizedState)) {
              markWorkInProgressReceivedUpdate();
            }

            hook.memoizedState = newState; // Don't persist the state accumulated from the render phase updates to
            // the base state unless the queue is empty.
            // TODO: Not sure if this is the desired semantics, but it's what we
            // do for gDSFP. I can't remember why.

            if (hook.baseUpdate === queue.last) {
              hook.baseState = newState;
            }

            queue.lastRenderedState = newState;
            return [newState, _dispatch];
          }
        }

        return [hook.memoizedState, _dispatch];
      } // The last update in the entire queue


      var last = queue.last; // The last update that is part of the base state.

      var baseUpdate = hook.baseUpdate;
      var baseState = hook.baseState; // Find the first unprocessed update.

      var first;

      if (baseUpdate !== null) {
        if (last !== null) {
          // For the first update, the queue is a circular linked list where
          // `queue.last.next = queue.first`. Once the first update commits, and
          // the `baseUpdate` is no longer empty, we can unravel the list.
          last.next = null;
        }

        first = baseUpdate.next;
      } else {
        first = last !== null ? last.next : null;
      }

      if (first !== null) {
        var _newState = baseState;
        var newBaseState = null;
        var newBaseUpdate = null;
        var prevUpdate = baseUpdate;
        var _update = first;
        var didSkip = false;

        do {
          var updateExpirationTime = _update.expirationTime;

          if (updateExpirationTime < renderExpirationTime$1) {
            // Priority is insufficient. Skip this update. If this is the first
            // skipped update, the previous update/state is the new base
            // update/state.
            if (!didSkip) {
              didSkip = true;
              newBaseUpdate = prevUpdate;
              newBaseState = _newState;
            } // Update the remaining priority in the queue.


            if (updateExpirationTime > remainingExpirationTime) {
              remainingExpirationTime = updateExpirationTime;
              markUnprocessedUpdateTime(remainingExpirationTime);
            }
          } else {
            // This update does have sufficient priority.
            // Mark the event time of this update as relevant to this render pass.
            // TODO: This should ideally use the true event time of this update rather than
            // its priority which is a derived and not reverseable value.
            // TODO: We should skip this update if it was already committed but currently
            // we have no way of detecting the difference between a committed and suspended
            // update here.
            markRenderEventTimeAndConfig(updateExpirationTime, _update.suspenseConfig); // Process this update.

            if (_update.eagerReducer === reducer) {
              // If this update was processed eagerly, and its reducer matches the
              // current reducer, we can use the eagerly computed state.
              _newState = _update.eagerState;
            } else {
              var _action = _update.action;
              _newState = reducer(_newState, _action);
            }
          }

          prevUpdate = _update;
          _update = _update.next;
        } while (_update !== null && _update !== first);

        if (!didSkip) {
          newBaseUpdate = prevUpdate;
          newBaseState = _newState;
        } // Mark that the fiber performed work, but only if the new state is
        // different from the current state.


        if (!is$1(_newState, hook.memoizedState)) {
          markWorkInProgressReceivedUpdate();
        }

        hook.memoizedState = _newState;
        hook.baseUpdate = newBaseUpdate;
        hook.baseState = newBaseState;
        queue.lastRenderedState = _newState;
      }

      var dispatch = queue.dispatch;
      return [hook.memoizedState, dispatch];
    }

    function mountState(initialState) {
      var hook = mountWorkInProgressHook();

      if (typeof initialState === 'function') {
        initialState = initialState();
      }

      hook.memoizedState = hook.baseState = initialState;
      var queue = hook.queue = {
        last: null,
        dispatch: null,
        lastRenderedReducer: basicStateReducer,
        lastRenderedState: initialState
      };
      var dispatch = queue.dispatch = dispatchAction.bind(null, // Flow doesn't know this is non-null, but we do.
      currentlyRenderingFiber$1, queue);
      return [hook.memoizedState, dispatch];
    }

    function updateState(initialState) {
      return updateReducer(basicStateReducer, initialState);
    }

    function pushEffect(tag, create, destroy, deps) {
      var effect = {
        tag: tag,
        create: create,
        destroy: destroy,
        deps: deps,
        // Circular
        next: null
      };

      if (componentUpdateQueue === null) {
        componentUpdateQueue = createFunctionComponentUpdateQueue();
        componentUpdateQueue.lastEffect = effect.next = effect;
      } else {
        var lastEffect = componentUpdateQueue.lastEffect;

        if (lastEffect === null) {
          componentUpdateQueue.lastEffect = effect.next = effect;
        } else {
          var firstEffect = lastEffect.next;
          lastEffect.next = effect;
          effect.next = firstEffect;
          componentUpdateQueue.lastEffect = effect;
        }
      }

      return effect;
    }

    function mountRef(initialValue) {
      var hook = mountWorkInProgressHook();
      var ref = {
        current: initialValue
      };
      {
        Object.seal(ref);
      }
      hook.memoizedState = ref;
      return ref;
    }

    function updateRef(initialValue) {
      var hook = updateWorkInProgressHook();
      return hook.memoizedState;
    }

    function mountEffectImpl(fiberEffectTag, hookEffectTag, create, deps) {
      var hook = mountWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      sideEffectTag |= fiberEffectTag;
      hook.memoizedState = pushEffect(hookEffectTag, create, undefined, nextDeps);
    }

    function updateEffectImpl(fiberEffectTag, hookEffectTag, create, deps) {
      var hook = updateWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      var destroy = undefined;

      if (currentHook !== null) {
        var prevEffect = currentHook.memoizedState;
        destroy = prevEffect.destroy;

        if (nextDeps !== null) {
          var prevDeps = prevEffect.deps;

          if (areHookInputsEqual(nextDeps, prevDeps)) {
            pushEffect(NoEffect$1, create, destroy, nextDeps);
            return;
          }
        }
      }

      sideEffectTag |= fiberEffectTag;
      hook.memoizedState = pushEffect(hookEffectTag, create, destroy, nextDeps);
    }

    function mountEffect(create, deps) {
      {
        // $FlowExpectedError - jest isn't a global, and isn't recognized outside of tests
        if ('undefined' !== typeof jest) {
          warnIfNotCurrentlyActingEffectsInDEV(currentlyRenderingFiber$1);
        }
      }
      return mountEffectImpl(Update | Passive, UnmountPassive | MountPassive, create, deps);
    }

    function updateEffect(create, deps) {
      {
        // $FlowExpectedError - jest isn't a global, and isn't recognized outside of tests
        if ('undefined' !== typeof jest) {
          warnIfNotCurrentlyActingEffectsInDEV(currentlyRenderingFiber$1);
        }
      }
      return updateEffectImpl(Update | Passive, UnmountPassive | MountPassive, create, deps);
    }

    function mountLayoutEffect(create, deps) {
      return mountEffectImpl(Update, UnmountMutation | MountLayout, create, deps);
    }

    function updateLayoutEffect(create, deps) {
      return updateEffectImpl(Update, UnmountMutation | MountLayout, create, deps);
    }

    function imperativeHandleEffect(create, ref) {
      if (typeof ref === 'function') {
        var refCallback = ref;

        var _inst = create();

        refCallback(_inst);
        return function () {
          refCallback(null);
        };
      } else if (ref !== null && ref !== undefined) {
        var refObject = ref;
        {
          !refObject.hasOwnProperty('current') ? warning$1(false, 'Expected useImperativeHandle() first argument to either be a ' + 'ref callback or React.createRef() object. Instead received: %s.', 'an object with keys {' + Object.keys(refObject).join(', ') + '}') : void 0;
        }

        var _inst2 = create();

        refObject.current = _inst2;
        return function () {
          refObject.current = null;
        };
      }
    }

    function mountImperativeHandle(ref, create, deps) {
      {
        !(typeof create === 'function') ? warning$1(false, 'Expected useImperativeHandle() second argument to be a function ' + 'that creates a handle. Instead received: %s.', create !== null ? typeof create : 'null') : void 0;
      } // TODO: If deps are provided, should we skip comparing the ref itself?

      var effectDeps = deps !== null && deps !== undefined ? deps.concat([ref]) : null;
      return mountEffectImpl(Update, UnmountMutation | MountLayout, imperativeHandleEffect.bind(null, create, ref), effectDeps);
    }

    function updateImperativeHandle(ref, create, deps) {
      {
        !(typeof create === 'function') ? warning$1(false, 'Expected useImperativeHandle() second argument to be a function ' + 'that creates a handle. Instead received: %s.', create !== null ? typeof create : 'null') : void 0;
      } // TODO: If deps are provided, should we skip comparing the ref itself?

      var effectDeps = deps !== null && deps !== undefined ? deps.concat([ref]) : null;
      return updateEffectImpl(Update, UnmountMutation | MountLayout, imperativeHandleEffect.bind(null, create, ref), effectDeps);
    }

    function mountDebugValue(value, formatterFn) {// This hook is normally a no-op.
      // The react-debug-hooks package injects its own implementation
      // so that e.g. DevTools can display custom hook values.
    }

    var updateDebugValue = mountDebugValue;

    function mountCallback(callback, deps) {
      var hook = mountWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      hook.memoizedState = [callback, nextDeps];
      return callback;
    }

    function updateCallback(callback, deps) {
      var hook = updateWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      var prevState = hook.memoizedState;

      if (prevState !== null) {
        if (nextDeps !== null) {
          var prevDeps = prevState[1];

          if (areHookInputsEqual(nextDeps, prevDeps)) {
            return prevState[0];
          }
        }
      }

      hook.memoizedState = [callback, nextDeps];
      return callback;
    }

    function mountMemo(nextCreate, deps) {
      var hook = mountWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      var nextValue = nextCreate();
      hook.memoizedState = [nextValue, nextDeps];
      return nextValue;
    }

    function updateMemo(nextCreate, deps) {
      var hook = updateWorkInProgressHook();
      var nextDeps = deps === undefined ? null : deps;
      var prevState = hook.memoizedState;

      if (prevState !== null) {
        // Assume these are defined. If they're not, areHookInputsEqual will warn.
        if (nextDeps !== null) {
          var prevDeps = prevState[1];

          if (areHookInputsEqual(nextDeps, prevDeps)) {
            return prevState[0];
          }
        }
      }

      var nextValue = nextCreate();
      hook.memoizedState = [nextValue, nextDeps];
      return nextValue;
    }

    function mountDeferredValue(value, config) {
      var _mountState = mountState(value),
          prevValue = _mountState[0],
          setValue = _mountState[1];

      mountEffect(function () {
        Scheduler.unstable_next(function () {
          var previousConfig = ReactCurrentBatchConfig$1.suspense;
          ReactCurrentBatchConfig$1.suspense = config === undefined ? null : config;

          try {
            setValue(value);
          } finally {
            ReactCurrentBatchConfig$1.suspense = previousConfig;
          }
        });
      }, [value, config]);
      return prevValue;
    }

    function updateDeferredValue(value, config) {
      var _updateState = updateState(value),
          prevValue = _updateState[0],
          setValue = _updateState[1];

      updateEffect(function () {
        Scheduler.unstable_next(function () {
          var previousConfig = ReactCurrentBatchConfig$1.suspense;
          ReactCurrentBatchConfig$1.suspense = config === undefined ? null : config;

          try {
            setValue(value);
          } finally {
            ReactCurrentBatchConfig$1.suspense = previousConfig;
          }
        });
      }, [value, config]);
      return prevValue;
    }

    function mountTransition(config) {
      var _mountState2 = mountState(false),
          isPending = _mountState2[0],
          setPending = _mountState2[1];

      var startTransition = mountCallback(function (callback) {
        setPending(true);
        Scheduler.unstable_next(function () {
          var previousConfig = ReactCurrentBatchConfig$1.suspense;
          ReactCurrentBatchConfig$1.suspense = config === undefined ? null : config;

          try {
            setPending(false);
            callback();
          } finally {
            ReactCurrentBatchConfig$1.suspense = previousConfig;
          }
        });
      }, [config, isPending]);
      return [startTransition, isPending];
    }

    function updateTransition(config) {
      var _updateState2 = updateState(false),
          isPending = _updateState2[0],
          setPending = _updateState2[1];

      var startTransition = updateCallback(function (callback) {
        setPending(true);
        Scheduler.unstable_next(function () {
          var previousConfig = ReactCurrentBatchConfig$1.suspense;
          ReactCurrentBatchConfig$1.suspense = config === undefined ? null : config;

          try {
            setPending(false);
            callback();
          } finally {
            ReactCurrentBatchConfig$1.suspense = previousConfig;
          }
        });
      }, [config, isPending]);
      return [startTransition, isPending];
    }

    function dispatchAction(fiber, queue, action) {
      if (!(numberOfReRenders < RE_RENDER_LIMIT)) {
        {
          throw Error("Too many re-renders. React limits the number of renders to prevent an infinite loop.");
        }
      }

      {
        !(typeof arguments[3] !== 'function') ? warning$1(false, "State updates from the useState() and useReducer() Hooks don't support the " + 'second callback argument. To execute a side effect after ' + 'rendering, declare it in the component body with useEffect().') : void 0;
      }
      var alternate = fiber.alternate;

      if (fiber === currentlyRenderingFiber$1 || alternate !== null && alternate === currentlyRenderingFiber$1) {
        // This is a render phase update. Stash it in a lazily-created map of
        // queue -> linked list of updates. After this render pass, we'll restart
        // and apply the stashed updates on top of the work-in-progress hook.
        didScheduleRenderPhaseUpdate = true;
        var update = {
          expirationTime: renderExpirationTime$1,
          suspenseConfig: null,
          action: action,
          eagerReducer: null,
          eagerState: null,
          next: null
        };
        {
          update.priority = getCurrentPriorityLevel();
        }

        if (renderPhaseUpdates === null) {
          renderPhaseUpdates = new Map();
        }

        var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);

        if (firstRenderPhaseUpdate === undefined) {
          renderPhaseUpdates.set(queue, update);
        } else {
          // Append the update to the end of the list.
          var lastRenderPhaseUpdate = firstRenderPhaseUpdate;

          while (lastRenderPhaseUpdate.next !== null) {
            lastRenderPhaseUpdate = lastRenderPhaseUpdate.next;
          }

          lastRenderPhaseUpdate.next = update;
        }
      } else {
        var currentTime = requestCurrentTimeForUpdate();
        var suspenseConfig = requestCurrentSuspenseConfig();
        var expirationTime = computeExpirationForFiber(currentTime, fiber, suspenseConfig);
        var _update2 = {
          expirationTime: expirationTime,
          suspenseConfig: suspenseConfig,
          action: action,
          eagerReducer: null,
          eagerState: null,
          next: null
        };
        {
          _update2.priority = getCurrentPriorityLevel();
        } // Append the update to the end of the list.

        var last = queue.last;

        if (last === null) {
          // This is the first update. Create a circular list.
          _update2.next = _update2;
        } else {
          var first = last.next;

          if (first !== null) {
            // Still circular.
            _update2.next = first;
          }

          last.next = _update2;
        }

        queue.last = _update2;

        if (fiber.expirationTime === NoWork && (alternate === null || alternate.expirationTime === NoWork)) {
          // The queue is currently empty, which means we can eagerly compute the
          // next state before entering the render phase. If the new state is the
          // same as the current state, we may be able to bail out entirely.
          var lastRenderedReducer = queue.lastRenderedReducer;

          if (lastRenderedReducer !== null) {
            var prevDispatcher;
            {
              prevDispatcher = ReactCurrentDispatcher$1.current;
              ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;
            }

            try {
              var currentState = queue.lastRenderedState;
              var eagerState = lastRenderedReducer(currentState, action); // Stash the eagerly computed state, and the reducer used to compute
              // it, on the update object. If the reducer hasn't changed by the
              // time we enter the render phase, then the eager state can be used
              // without calling the reducer again.

              _update2.eagerReducer = lastRenderedReducer;
              _update2.eagerState = eagerState;

              if (is$1(eagerState, currentState)) {
                // Fast path. We can bail out without scheduling React to re-render.
                // It's still possible that we'll need to rebase this update later,
                // if the component re-renders for a different reason and by that
                // time the reducer has changed.
                return;
              }
            } catch (error) {// Suppress the error. It will throw again in the render phase.
            } finally {
              {
                ReactCurrentDispatcher$1.current = prevDispatcher;
              }
            }
          }
        }

        {
          // $FlowExpectedError - jest isn't a global, and isn't recognized outside of tests
          if ('undefined' !== typeof jest) {
            warnIfNotScopedWithMatchingAct(fiber);
            warnIfNotCurrentlyActingUpdatesInDev(fiber);
          }
        }
        scheduleWork(fiber, expirationTime);
      }
    }

    var ContextOnlyDispatcher = {
      readContext: readContext,
      useCallback: throwInvalidHookError,
      useContext: throwInvalidHookError,
      useEffect: throwInvalidHookError,
      useImperativeHandle: throwInvalidHookError,
      useLayoutEffect: throwInvalidHookError,
      useMemo: throwInvalidHookError,
      useReducer: throwInvalidHookError,
      useRef: throwInvalidHookError,
      useState: throwInvalidHookError,
      useDebugValue: throwInvalidHookError,
      useResponder: throwInvalidHookError,
      useDeferredValue: throwInvalidHookError,
      useTransition: throwInvalidHookError
    };
    var HooksDispatcherOnMountInDEV = null;
    var HooksDispatcherOnMountWithHookTypesInDEV = null;
    var HooksDispatcherOnUpdateInDEV = null;
    var InvalidNestedHooksDispatcherOnMountInDEV = null;
    var InvalidNestedHooksDispatcherOnUpdateInDEV = null;
    {
      var warnInvalidContextAccess = function () {
        warning$1(false, 'Context can only be read while React is rendering. ' + 'In classes, you can read it in the render method or getDerivedStateFromProps. ' + 'In function components, you can read it directly in the function body, but not ' + 'inside Hooks like useReducer() or useMemo().');
      };

      var warnInvalidHookAccess = function () {
        warning$1(false, 'Do not call Hooks inside useEffect(...), useMemo(...), or other built-in Hooks. ' + 'You can only call Hooks at the top level of your React function. ' + 'For more information, see ' + 'https://fb.me/rules-of-hooks');
      };

      HooksDispatcherOnMountInDEV = {
        readContext: function (context, observedBits) {
          return readContext(context, observedBits);
        },
        useCallback: function (callback, deps) {
          currentHookNameInDev = 'useCallback';
          mountHookTypesDev();
          checkDepsAreArrayDev(deps);
          return mountCallback(callback, deps);
        },
        useContext: function (context, observedBits) {
          currentHookNameInDev = 'useContext';
          mountHookTypesDev();
          return readContext(context, observedBits);
        },
        useEffect: function (create, deps) {
          currentHookNameInDev = 'useEffect';
          mountHookTypesDev();
          checkDepsAreArrayDev(deps);
          return mountEffect(create, deps);
        },
        useImperativeHandle: function (ref, create, deps) {
          currentHookNameInDev = 'useImperativeHandle';
          mountHookTypesDev();
          checkDepsAreArrayDev(deps);
          return mountImperativeHandle(ref, create, deps);
        },
        useLayoutEffect: function (create, deps) {
          currentHookNameInDev = 'useLayoutEffect';
          mountHookTypesDev();
          checkDepsAreArrayDev(deps);
          return mountLayoutEffect(create, deps);
        },
        useMemo: function (create, deps) {
          currentHookNameInDev = 'useMemo';
          mountHookTypesDev();
          checkDepsAreArrayDev(deps);
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountMemo(create, deps);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useReducer: function (reducer, initialArg, init) {
          currentHookNameInDev = 'useReducer';
          mountHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountReducer(reducer, initialArg, init);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useRef: function (initialValue) {
          currentHookNameInDev = 'useRef';
          mountHookTypesDev();
          return mountRef(initialValue);
        },
        useState: function (initialState) {
          currentHookNameInDev = 'useState';
          mountHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountState(initialState);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useDebugValue: function (value, formatterFn) {
          currentHookNameInDev = 'useDebugValue';
          mountHookTypesDev();
          return mountDebugValue(value, formatterFn);
        },
        useResponder: function (responder, props) {
          currentHookNameInDev = 'useResponder';
          mountHookTypesDev();
          return createResponderListener(responder, props);
        },
        useDeferredValue: function (value, config) {
          currentHookNameInDev = 'useDeferredValue';
          mountHookTypesDev();
          return mountDeferredValue(value, config);
        },
        useTransition: function (config) {
          currentHookNameInDev = 'useTransition';
          mountHookTypesDev();
          return mountTransition(config);
        }
      };
      HooksDispatcherOnMountWithHookTypesInDEV = {
        readContext: function (context, observedBits) {
          return readContext(context, observedBits);
        },
        useCallback: function (callback, deps) {
          currentHookNameInDev = 'useCallback';
          updateHookTypesDev();
          return mountCallback(callback, deps);
        },
        useContext: function (context, observedBits) {
          currentHookNameInDev = 'useContext';
          updateHookTypesDev();
          return readContext(context, observedBits);
        },
        useEffect: function (create, deps) {
          currentHookNameInDev = 'useEffect';
          updateHookTypesDev();
          return mountEffect(create, deps);
        },
        useImperativeHandle: function (ref, create, deps) {
          currentHookNameInDev = 'useImperativeHandle';
          updateHookTypesDev();
          return mountImperativeHandle(ref, create, deps);
        },
        useLayoutEffect: function (create, deps) {
          currentHookNameInDev = 'useLayoutEffect';
          updateHookTypesDev();
          return mountLayoutEffect(create, deps);
        },
        useMemo: function (create, deps) {
          currentHookNameInDev = 'useMemo';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountMemo(create, deps);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useReducer: function (reducer, initialArg, init) {
          currentHookNameInDev = 'useReducer';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountReducer(reducer, initialArg, init);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useRef: function (initialValue) {
          currentHookNameInDev = 'useRef';
          updateHookTypesDev();
          return mountRef(initialValue);
        },
        useState: function (initialState) {
          currentHookNameInDev = 'useState';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountState(initialState);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useDebugValue: function (value, formatterFn) {
          currentHookNameInDev = 'useDebugValue';
          updateHookTypesDev();
          return mountDebugValue(value, formatterFn);
        },
        useResponder: function (responder, props) {
          currentHookNameInDev = 'useResponder';
          updateHookTypesDev();
          return createResponderListener(responder, props);
        },
        useDeferredValue: function (value, config) {
          currentHookNameInDev = 'useDeferredValue';
          updateHookTypesDev();
          return mountDeferredValue(value, config);
        },
        useTransition: function (config) {
          currentHookNameInDev = 'useTransition';
          updateHookTypesDev();
          return mountTransition(config);
        }
      };
      HooksDispatcherOnUpdateInDEV = {
        readContext: function (context, observedBits) {
          return readContext(context, observedBits);
        },
        useCallback: function (callback, deps) {
          currentHookNameInDev = 'useCallback';
          updateHookTypesDev();
          return updateCallback(callback, deps);
        },
        useContext: function (context, observedBits) {
          currentHookNameInDev = 'useContext';
          updateHookTypesDev();
          return readContext(context, observedBits);
        },
        useEffect: function (create, deps) {
          currentHookNameInDev = 'useEffect';
          updateHookTypesDev();
          return updateEffect(create, deps);
        },
        useImperativeHandle: function (ref, create, deps) {
          currentHookNameInDev = 'useImperativeHandle';
          updateHookTypesDev();
          return updateImperativeHandle(ref, create, deps);
        },
        useLayoutEffect: function (create, deps) {
          currentHookNameInDev = 'useLayoutEffect';
          updateHookTypesDev();
          return updateLayoutEffect(create, deps);
        },
        useMemo: function (create, deps) {
          currentHookNameInDev = 'useMemo';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateMemo(create, deps);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useReducer: function (reducer, initialArg, init) {
          currentHookNameInDev = 'useReducer';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateReducer(reducer, initialArg, init);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useRef: function (initialValue) {
          currentHookNameInDev = 'useRef';
          updateHookTypesDev();
          return updateRef(initialValue);
        },
        useState: function (initialState) {
          currentHookNameInDev = 'useState';
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateState(initialState);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useDebugValue: function (value, formatterFn) {
          currentHookNameInDev = 'useDebugValue';
          updateHookTypesDev();
          return updateDebugValue(value, formatterFn);
        },
        useResponder: function (responder, props) {
          currentHookNameInDev = 'useResponder';
          updateHookTypesDev();
          return createResponderListener(responder, props);
        },
        useDeferredValue: function (value, config) {
          currentHookNameInDev = 'useDeferredValue';
          updateHookTypesDev();
          return updateDeferredValue(value, config);
        },
        useTransition: function (config) {
          currentHookNameInDev = 'useTransition';
          updateHookTypesDev();
          return updateTransition(config);
        }
      };
      InvalidNestedHooksDispatcherOnMountInDEV = {
        readContext: function (context, observedBits) {
          warnInvalidContextAccess();
          return readContext(context, observedBits);
        },
        useCallback: function (callback, deps) {
          currentHookNameInDev = 'useCallback';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountCallback(callback, deps);
        },
        useContext: function (context, observedBits) {
          currentHookNameInDev = 'useContext';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return readContext(context, observedBits);
        },
        useEffect: function (create, deps) {
          currentHookNameInDev = 'useEffect';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountEffect(create, deps);
        },
        useImperativeHandle: function (ref, create, deps) {
          currentHookNameInDev = 'useImperativeHandle';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountImperativeHandle(ref, create, deps);
        },
        useLayoutEffect: function (create, deps) {
          currentHookNameInDev = 'useLayoutEffect';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountLayoutEffect(create, deps);
        },
        useMemo: function (create, deps) {
          currentHookNameInDev = 'useMemo';
          warnInvalidHookAccess();
          mountHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountMemo(create, deps);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useReducer: function (reducer, initialArg, init) {
          currentHookNameInDev = 'useReducer';
          warnInvalidHookAccess();
          mountHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountReducer(reducer, initialArg, init);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useRef: function (initialValue) {
          currentHookNameInDev = 'useRef';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountRef(initialValue);
        },
        useState: function (initialState) {
          currentHookNameInDev = 'useState';
          warnInvalidHookAccess();
          mountHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnMountInDEV;

          try {
            return mountState(initialState);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useDebugValue: function (value, formatterFn) {
          currentHookNameInDev = 'useDebugValue';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountDebugValue(value, formatterFn);
        },
        useResponder: function (responder, props) {
          currentHookNameInDev = 'useResponder';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return createResponderListener(responder, props);
        },
        useDeferredValue: function (value, config) {
          currentHookNameInDev = 'useDeferredValue';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountDeferredValue(value, config);
        },
        useTransition: function (config) {
          currentHookNameInDev = 'useTransition';
          warnInvalidHookAccess();
          mountHookTypesDev();
          return mountTransition(config);
        }
      };
      InvalidNestedHooksDispatcherOnUpdateInDEV = {
        readContext: function (context, observedBits) {
          warnInvalidContextAccess();
          return readContext(context, observedBits);
        },
        useCallback: function (callback, deps) {
          currentHookNameInDev = 'useCallback';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateCallback(callback, deps);
        },
        useContext: function (context, observedBits) {
          currentHookNameInDev = 'useContext';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return readContext(context, observedBits);
        },
        useEffect: function (create, deps) {
          currentHookNameInDev = 'useEffect';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateEffect(create, deps);
        },
        useImperativeHandle: function (ref, create, deps) {
          currentHookNameInDev = 'useImperativeHandle';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateImperativeHandle(ref, create, deps);
        },
        useLayoutEffect: function (create, deps) {
          currentHookNameInDev = 'useLayoutEffect';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateLayoutEffect(create, deps);
        },
        useMemo: function (create, deps) {
          currentHookNameInDev = 'useMemo';
          warnInvalidHookAccess();
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateMemo(create, deps);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useReducer: function (reducer, initialArg, init) {
          currentHookNameInDev = 'useReducer';
          warnInvalidHookAccess();
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateReducer(reducer, initialArg, init);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useRef: function (initialValue) {
          currentHookNameInDev = 'useRef';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateRef(initialValue);
        },
        useState: function (initialState) {
          currentHookNameInDev = 'useState';
          warnInvalidHookAccess();
          updateHookTypesDev();
          var prevDispatcher = ReactCurrentDispatcher$1.current;
          ReactCurrentDispatcher$1.current = InvalidNestedHooksDispatcherOnUpdateInDEV;

          try {
            return updateState(initialState);
          } finally {
            ReactCurrentDispatcher$1.current = prevDispatcher;
          }
        },
        useDebugValue: function (value, formatterFn) {
          currentHookNameInDev = 'useDebugValue';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateDebugValue(value, formatterFn);
        },
        useResponder: function (responder, props) {
          currentHookNameInDev = 'useResponder';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return createResponderListener(responder, props);
        },
        useDeferredValue: function (value, config) {
          currentHookNameInDev = 'useDeferredValue';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateDeferredValue(value, config);
        },
        useTransition: function (config) {
          currentHookNameInDev = 'useTransition';
          warnInvalidHookAccess();
          updateHookTypesDev();
          return updateTransition(config);
        }
      };
    } // CommonJS interop named imports.

    var now$1 = Scheduler.unstable_now;
    var commitTime = 0;
    var profilerStartTime = -1;

    function getCommitTime() {
      return commitTime;
    }

    function recordCommitTime() {
      if (!enableProfilerTimer) {
        return;
      }

      commitTime = now$1();
    }

    function startProfilerTimer(fiber) {
      if (!enableProfilerTimer) {
        return;
      }

      profilerStartTime = now$1();

      if (fiber.actualStartTime < 0) {
        fiber.actualStartTime = now$1();
      }
    }

    function stopProfilerTimerIfRunning(fiber) {
      if (!enableProfilerTimer) {
        return;
      }

      profilerStartTime = -1;
    }

    function stopProfilerTimerIfRunningAndRecordDelta(fiber, overrideBaseTime) {
      if (!enableProfilerTimer) {
        return;
      }

      if (profilerStartTime >= 0) {
        var elapsedTime = now$1() - profilerStartTime;
        fiber.actualDuration += elapsedTime;

        if (overrideBaseTime) {
          fiber.selfBaseDuration = elapsedTime;
        }

        profilerStartTime = -1;
      }
    } // This may have been an insertion or a hydration.


    var hydrationParentFiber = null;
    var nextHydratableInstance = null;
    var isHydrating = false;

    function warnIfHydrating() {
      {
        !!isHydrating ? warning$1(false, 'We should not be hydrating here. This is a bug in React. Please file a bug.') : void 0;
      }
    }

    function enterHydrationState(fiber) {
      if (!supportsHydration) {
        return false;
      }

      var parentInstance = fiber.stateNode.containerInfo;
      nextHydratableInstance = getFirstHydratableChild(parentInstance);
      hydrationParentFiber = fiber;
      isHydrating = true;
      return true;
    }

    function reenterHydrationStateFromDehydratedSuspenseInstance(fiber, suspenseInstance) {
      if (!supportsHydration) {
        return false;
      }

      nextHydratableInstance = getNextHydratableSibling(suspenseInstance);
      popToNextHostParent(fiber);
      isHydrating = true;
      return true;
    }

    function deleteHydratableInstance(returnFiber, instance) {
      {
        switch (returnFiber.tag) {
          case HostRoot:
            didNotHydrateContainerInstance(returnFiber.stateNode.containerInfo, instance);
            break;

          case HostComponent:
            didNotHydrateInstance(returnFiber.type, returnFiber.memoizedProps, returnFiber.stateNode, instance);
            break;
        }
      }
      var childToDelete = createFiberFromHostInstanceForDeletion();
      childToDelete.stateNode = instance;
      childToDelete.return = returnFiber;
      childToDelete.effectTag = Deletion; // This might seem like it belongs on progressedFirstDeletion. However,
      // these children are not part of the reconciliation list of children.
      // Even if we abort and rereconcile the children, that will try to hydrate
      // again and the nodes are still in the host tree so these will be
      // recreated.

      if (returnFiber.lastEffect !== null) {
        returnFiber.lastEffect.nextEffect = childToDelete;
        returnFiber.lastEffect = childToDelete;
      } else {
        returnFiber.firstEffect = returnFiber.lastEffect = childToDelete;
      }
    }

    function insertNonHydratedInstance(returnFiber, fiber) {
      fiber.effectTag = fiber.effectTag & ~Hydrating | Placement;
      {
        switch (returnFiber.tag) {
          case HostRoot:
            {
              var parentContainer = returnFiber.stateNode.containerInfo;

              switch (fiber.tag) {
                case HostComponent:
                  var type = fiber.type;
                  var props = fiber.pendingProps;
                  didNotFindHydratableContainerInstance(parentContainer, type, props);
                  break;

                case HostText:
                  var text = fiber.pendingProps;
                  didNotFindHydratableContainerTextInstance(parentContainer, text);
                  break;

                case SuspenseComponent:
                  break;
              }

              break;
            }

          case HostComponent:
            {
              var parentType = returnFiber.type;
              var parentProps = returnFiber.memoizedProps;
              var parentInstance = returnFiber.stateNode;

              switch (fiber.tag) {
                case HostComponent:
                  var _type = fiber.type;
                  var _props = fiber.pendingProps;
                  didNotFindHydratableInstance(parentType, parentProps, parentInstance, _type, _props);
                  break;

                case HostText:
                  var _text = fiber.pendingProps;
                  didNotFindHydratableTextInstance(parentType, parentProps, parentInstance, _text);
                  break;

                case SuspenseComponent:
                  didNotFindHydratableSuspenseInstance(parentType, parentProps, parentInstance);
                  break;
              }

              break;
            }

          default:
            return;
        }
      }
    }

    function tryHydrate(fiber, nextInstance) {
      switch (fiber.tag) {
        case HostComponent:
          {
            var type = fiber.type;
            var props = fiber.pendingProps;
            var instance = canHydrateInstance(nextInstance, type, props);

            if (instance !== null) {
              fiber.stateNode = instance;
              return true;
            }

            return false;
          }

        case HostText:
          {
            var text = fiber.pendingProps;
            var textInstance = canHydrateTextInstance(nextInstance, text);

            if (textInstance !== null) {
              fiber.stateNode = textInstance;
              return true;
            }

            return false;
          }

        case SuspenseComponent:
          {
            if (enableSuspenseServerRenderer) {
              var suspenseInstance = canHydrateSuspenseInstance(nextInstance);

              if (suspenseInstance !== null) {
                var suspenseState = {
                  dehydrated: suspenseInstance,
                  retryTime: Never
                };
                fiber.memoizedState = suspenseState; // Store the dehydrated fragment as a child fiber.
                // This simplifies the code for getHostSibling and deleting nodes,
                // since it doesn't have to consider all Suspense boundaries and
                // check if they're dehydrated ones or not.

                var dehydratedFragment = createFiberFromDehydratedFragment(suspenseInstance);
                dehydratedFragment.return = fiber;
                fiber.child = dehydratedFragment;
                return true;
              }
            }

            return false;
          }

        default:
          return false;
      }
    }

    function tryToClaimNextHydratableInstance(fiber) {
      if (!isHydrating) {
        return;
      }

      var nextInstance = nextHydratableInstance;

      if (!nextInstance) {
        // Nothing to hydrate. Make it an insertion.
        insertNonHydratedInstance(hydrationParentFiber, fiber);
        isHydrating = false;
        hydrationParentFiber = fiber;
        return;
      }

      var firstAttemptedInstance = nextInstance;

      if (!tryHydrate(fiber, nextInstance)) {
        // If we can't hydrate this instance let's try the next one.
        // We use this as a heuristic. It's based on intuition and not data so it
        // might be flawed or unnecessary.
        nextInstance = getNextHydratableSibling(firstAttemptedInstance);

        if (!nextInstance || !tryHydrate(fiber, nextInstance)) {
          // Nothing to hydrate. Make it an insertion.
          insertNonHydratedInstance(hydrationParentFiber, fiber);
          isHydrating = false;
          hydrationParentFiber = fiber;
          return;
        } // We matched the next one, we'll now assume that the first one was
        // superfluous and we'll delete it. Since we can't eagerly delete it
        // we'll have to schedule a deletion. To do that, this node needs a dummy
        // fiber associated with it.


        deleteHydratableInstance(hydrationParentFiber, firstAttemptedInstance);
      }

      hydrationParentFiber = fiber;
      nextHydratableInstance = getFirstHydratableChild(nextInstance);
    }

    function prepareToHydrateHostInstance(fiber, rootContainerInstance, hostContext) {
      if (!supportsHydration) {
        {
          {
            throw Error("Expected prepareToHydrateHostInstance() to never be called. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }

      var instance = fiber.stateNode;
      var updatePayload = hydrateInstance(instance, fiber.type, fiber.memoizedProps, rootContainerInstance, hostContext, fiber); // TODO: Type this specific to this type of component.

      fiber.updateQueue = updatePayload; // If the update payload indicates that there is a change or if there
      // is a new ref we mark this as an update.

      if (updatePayload !== null) {
        return true;
      }

      return false;
    }

    function prepareToHydrateHostTextInstance(fiber) {
      if (!supportsHydration) {
        {
          {
            throw Error("Expected prepareToHydrateHostTextInstance() to never be called. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }

      var textInstance = fiber.stateNode;
      var textContent = fiber.memoizedProps;
      var shouldUpdate = hydrateTextInstance(textInstance, textContent, fiber);
      {
        if (shouldUpdate) {
          // We assume that prepareToHydrateHostTextInstance is called in a context where the
          // hydration parent is the parent host component of this host text.
          var returnFiber = hydrationParentFiber;

          if (returnFiber !== null) {
            switch (returnFiber.tag) {
              case HostRoot:
                {
                  var parentContainer = returnFiber.stateNode.containerInfo;
                  didNotMatchHydratedContainerTextInstance(parentContainer, textInstance, textContent);
                  break;
                }

              case HostComponent:
                {
                  var parentType = returnFiber.type;
                  var parentProps = returnFiber.memoizedProps;
                  var parentInstance = returnFiber.stateNode;
                  didNotMatchHydratedTextInstance(parentType, parentProps, parentInstance, textInstance, textContent);
                  break;
                }
            }
          }
        }
      }
      return shouldUpdate;
    }

    function prepareToHydrateHostSuspenseInstance(fiber) {
      if (!supportsHydration) {
        {
          {
            throw Error("Expected prepareToHydrateHostSuspenseInstance() to never be called. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }

      var suspenseState = fiber.memoizedState;
      var suspenseInstance = suspenseState !== null ? suspenseState.dehydrated : null;

      if (!suspenseInstance) {
        {
          throw Error("Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue.");
        }
      }

      hydrateSuspenseInstance(suspenseInstance, fiber);
    }

    function skipPastDehydratedSuspenseInstance(fiber) {
      if (!supportsHydration) {
        {
          {
            throw Error("Expected skipPastDehydratedSuspenseInstance() to never be called. This error is likely caused by a bug in React. Please file an issue.");
          }
        }
      }

      var suspenseState = fiber.memoizedState;
      var suspenseInstance = suspenseState !== null ? suspenseState.dehydrated : null;

      if (!suspenseInstance) {
        {
          throw Error("Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue.");
        }
      }

      return getNextHydratableInstanceAfterSuspenseInstance(suspenseInstance);
    }

    function popToNextHostParent(fiber) {
      var parent = fiber.return;

      while (parent !== null && parent.tag !== HostComponent && parent.tag !== HostRoot && parent.tag !== SuspenseComponent) {
        parent = parent.return;
      }

      hydrationParentFiber = parent;
    }

    function popHydrationState(fiber) {
      if (!supportsHydration) {
        return false;
      }

      if (fiber !== hydrationParentFiber) {
        // We're deeper than the current hydration context, inside an inserted
        // tree.
        return false;
      }

      if (!isHydrating) {
        // If we're not currently hydrating but we're in a hydration context, then
        // we were an insertion and now need to pop up reenter hydration of our
        // siblings.
        popToNextHostParent(fiber);
        isHydrating = true;
        return false;
      }

      var type = fiber.type; // If we have any remaining hydratable nodes, we need to delete them now.
      // We only do this deeper than head and body since they tend to have random
      // other nodes in them. We also ignore components with pure text content in
      // side of them.
      // TODO: Better heuristic.

      if (fiber.tag !== HostComponent || type !== 'head' && type !== 'body' && !shouldSetTextContent(type, fiber.memoizedProps)) {
        var nextInstance = nextHydratableInstance;

        while (nextInstance) {
          deleteHydratableInstance(fiber, nextInstance);
          nextInstance = getNextHydratableSibling(nextInstance);
        }
      }

      popToNextHostParent(fiber);

      if (fiber.tag === SuspenseComponent) {
        nextHydratableInstance = skipPastDehydratedSuspenseInstance(fiber);
      } else {
        nextHydratableInstance = hydrationParentFiber ? getNextHydratableSibling(fiber.stateNode) : null;
      }

      return true;
    }

    function resetHydrationState() {
      if (!supportsHydration) {
        return;
      }

      hydrationParentFiber = null;
      nextHydratableInstance = null;
      isHydrating = false;
    }

    var ReactCurrentOwner$3 = ReactSharedInternals.ReactCurrentOwner;
    var didReceiveUpdate = false;
    var didWarnAboutBadClass;
    var didWarnAboutModulePatternComponent;
    var didWarnAboutContextTypeOnFunctionComponent;
    var didWarnAboutGetDerivedStateOnFunctionComponent;
    var didWarnAboutFunctionRefs;
    var didWarnAboutReassigningProps;
    var didWarnAboutMaxDuration;
    var didWarnAboutRevealOrder;
    var didWarnAboutTailOptions;
    var didWarnAboutDefaultPropsOnFunctionComponent;
    {
      didWarnAboutBadClass = {};
      didWarnAboutModulePatternComponent = {};
      didWarnAboutContextTypeOnFunctionComponent = {};
      didWarnAboutGetDerivedStateOnFunctionComponent = {};
      didWarnAboutFunctionRefs = {};
      didWarnAboutReassigningProps = false;
      didWarnAboutMaxDuration = false;
      didWarnAboutRevealOrder = {};
      didWarnAboutTailOptions = {};
      didWarnAboutDefaultPropsOnFunctionComponent = {};
    }

    function reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime) {
      if (current$$1 === null) {
        // If this is a fresh new component that hasn't been rendered yet, we
        // won't update its child set by applying minimal side-effects. Instead,
        // we will add them all to the child before it gets rendered. That means
        // we can optimize this reconciliation pass by not tracking side-effects.
        workInProgress.child = mountChildFibers(workInProgress, null, nextChildren, renderExpirationTime);
      } else {
        // If the current child is the same as the work in progress, it means that
        // we haven't yet started any work on these children. Therefore, we use
        // the clone algorithm to create a copy of all the current children.
        // If we had any progressed work already, that is invalid at this point so
        // let's throw it out.
        workInProgress.child = reconcileChildFibers(workInProgress, current$$1.child, nextChildren, renderExpirationTime);
      }
    }

    function forceUnmountCurrentAndReconcile(current$$1, workInProgress, nextChildren, renderExpirationTime) {
      // This function is fork of reconcileChildren. It's used in cases where we
      // want to reconcile without matching against the existing set. This has the
      // effect of all current children being unmounted; even if the type and key
      // are the same, the old child is unmounted and a new child is created.
      //
      // To do this, we're going to go through the reconcile algorithm twice. In
      // the first pass, we schedule a deletion for all the current children by
      // passing null.
      workInProgress.child = reconcileChildFibers(workInProgress, current$$1.child, null, renderExpirationTime); // In the second pass, we mount the new children. The trick here is that we
      // pass null in place of where we usually pass the current child set. This has
      // the effect of remounting all children regardless of whether their their
      // identity matches.

      workInProgress.child = reconcileChildFibers(workInProgress, null, nextChildren, renderExpirationTime);
    }

    function updateForwardRef(current$$1, workInProgress, Component, nextProps, renderExpirationTime) {
      // TODO: current can be non-null here even if the component
      // hasn't yet mounted. This happens after the first render suspends.
      // We'll need to figure out if this is fine or can cause issues.
      {
        if (workInProgress.type !== workInProgress.elementType) {
          // Lazy component props can't be validated in createElement
          // because they're only guaranteed to be resolved here.
          var innerPropTypes = Component.propTypes;

          if (innerPropTypes) {
            checkPropTypes(innerPropTypes, nextProps, // Resolved props
            'prop', getComponentName(Component), getCurrentFiberStackInDev);
          }
        }
      }
      var render = Component.render;
      var ref = workInProgress.ref; // The rest is a fork of updateFunctionComponent

      var nextChildren;
      prepareToReadContext(workInProgress, renderExpirationTime);
      {
        ReactCurrentOwner$3.current = workInProgress;
        setCurrentPhase('render');
        nextChildren = renderWithHooks(current$$1, workInProgress, render, nextProps, ref, renderExpirationTime);

        if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
          // Only double-render components with Hooks
          if (workInProgress.memoizedState !== null) {
            nextChildren = renderWithHooks(current$$1, workInProgress, render, nextProps, ref, renderExpirationTime);
          }
        }

        setCurrentPhase(null);
      }

      if (current$$1 !== null && !didReceiveUpdate) {
        bailoutHooks(current$$1, workInProgress, renderExpirationTime);
        return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
      } // React DevTools reads this flag.


      workInProgress.effectTag |= PerformedWork;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateMemoComponent(current$$1, workInProgress, Component, nextProps, updateExpirationTime, renderExpirationTime) {
      if (current$$1 === null) {
        var type = Component.type;

        if (isSimpleFunctionComponent(type) && Component.compare === null && // SimpleMemoComponent codepath doesn't resolve outer props either.
        Component.defaultProps === undefined) {
          var resolvedType = type;
          {
            resolvedType = resolveFunctionForHotReloading(type);
          } // If this is a plain function component without default props,
          // and with only the default shallow comparison, we upgrade it
          // to a SimpleMemoComponent to allow fast path updates.

          workInProgress.tag = SimpleMemoComponent;
          workInProgress.type = resolvedType;
          {
            validateFunctionComponentInDev(workInProgress, type);
          }
          return updateSimpleMemoComponent(current$$1, workInProgress, resolvedType, nextProps, updateExpirationTime, renderExpirationTime);
        }

        {
          var innerPropTypes = type.propTypes;

          if (innerPropTypes) {
            // Inner memo component props aren't currently validated in createElement.
            // We could move it there, but we'd still need this for lazy code path.
            checkPropTypes(innerPropTypes, nextProps, // Resolved props
            'prop', getComponentName(type), getCurrentFiberStackInDev);
          }
        }
        var child = createFiberFromTypeAndProps(Component.type, null, nextProps, null, workInProgress.mode, renderExpirationTime);
        child.ref = workInProgress.ref;
        child.return = workInProgress;
        workInProgress.child = child;
        return child;
      }

      {
        var _type = Component.type;
        var _innerPropTypes = _type.propTypes;

        if (_innerPropTypes) {
          // Inner memo component props aren't currently validated in createElement.
          // We could move it there, but we'd still need this for lazy code path.
          checkPropTypes(_innerPropTypes, nextProps, // Resolved props
          'prop', getComponentName(_type), getCurrentFiberStackInDev);
        }
      }
      var currentChild = current$$1.child; // This is always exactly one child

      if (updateExpirationTime < renderExpirationTime) {
        // This will be the props with resolved defaultProps,
        // unlike current.memoizedProps which will be the unresolved ones.
        var prevProps = currentChild.memoizedProps; // Default to shallow comparison

        var compare = Component.compare;
        compare = compare !== null ? compare : shallowEqual;

        if (compare(prevProps, nextProps) && current$$1.ref === workInProgress.ref) {
          return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
        }
      } // React DevTools reads this flag.


      workInProgress.effectTag |= PerformedWork;
      var newChild = createWorkInProgress(currentChild, nextProps, renderExpirationTime);
      newChild.ref = workInProgress.ref;
      newChild.return = workInProgress;
      workInProgress.child = newChild;
      return newChild;
    }

    function updateSimpleMemoComponent(current$$1, workInProgress, Component, nextProps, updateExpirationTime, renderExpirationTime) {
      // TODO: current can be non-null here even if the component
      // hasn't yet mounted. This happens when the inner render suspends.
      // We'll need to figure out if this is fine or can cause issues.
      {
        if (workInProgress.type !== workInProgress.elementType) {
          // Lazy component props can't be validated in createElement
          // because they're only guaranteed to be resolved here.
          var outerMemoType = workInProgress.elementType;

          if (outerMemoType.$$typeof === REACT_LAZY_TYPE) {
            // We warn when you define propTypes on lazy()
            // so let's just skip over it to find memo() outer wrapper.
            // Inner props for memo are validated later.
            outerMemoType = refineResolvedLazyComponent(outerMemoType);
          }

          var outerPropTypes = outerMemoType && outerMemoType.propTypes;

          if (outerPropTypes) {
            checkPropTypes(outerPropTypes, nextProps, // Resolved (SimpleMemoComponent has no defaultProps)
            'prop', getComponentName(outerMemoType), getCurrentFiberStackInDev);
          } // Inner propTypes will be validated in the function component path.

        }
      }

      if (current$$1 !== null) {
        var prevProps = current$$1.memoizedProps;

        if (shallowEqual(prevProps, nextProps) && current$$1.ref === workInProgress.ref && // Prevent bailout if the implementation changed due to hot reload:
        workInProgress.type === current$$1.type) {
          didReceiveUpdate = false;

          if (updateExpirationTime < renderExpirationTime) {
            return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
          }
        }
      }

      return updateFunctionComponent(current$$1, workInProgress, Component, nextProps, renderExpirationTime);
    }

    function updateFragment(current$$1, workInProgress, renderExpirationTime) {
      var nextChildren = workInProgress.pendingProps;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateMode(current$$1, workInProgress, renderExpirationTime) {
      var nextChildren = workInProgress.pendingProps.children;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateProfiler(current$$1, workInProgress, renderExpirationTime) {
      if (enableProfilerTimer) {
        workInProgress.effectTag |= Update;
      }

      var nextProps = workInProgress.pendingProps;
      var nextChildren = nextProps.children;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function markRef(current$$1, workInProgress) {
      var ref = workInProgress.ref;

      if (current$$1 === null && ref !== null || current$$1 !== null && current$$1.ref !== ref) {
        // Schedule a Ref effect
        workInProgress.effectTag |= Ref;
      }
    }

    function updateFunctionComponent(current$$1, workInProgress, Component, nextProps, renderExpirationTime) {
      {
        if (workInProgress.type !== workInProgress.elementType) {
          // Lazy component props can't be validated in createElement
          // because they're only guaranteed to be resolved here.
          var innerPropTypes = Component.propTypes;

          if (innerPropTypes) {
            checkPropTypes(innerPropTypes, nextProps, // Resolved props
            'prop', getComponentName(Component), getCurrentFiberStackInDev);
          }
        }
      }
      var context;

      if (!disableLegacyContext) {
        var unmaskedContext = getUnmaskedContext(workInProgress, Component, true);
        context = getMaskedContext(workInProgress, unmaskedContext);
      }

      var nextChildren;
      prepareToReadContext(workInProgress, renderExpirationTime);
      {
        ReactCurrentOwner$3.current = workInProgress;
        setCurrentPhase('render');
        nextChildren = renderWithHooks(current$$1, workInProgress, Component, nextProps, context, renderExpirationTime);

        if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
          // Only double-render components with Hooks
          if (workInProgress.memoizedState !== null) {
            nextChildren = renderWithHooks(current$$1, workInProgress, Component, nextProps, context, renderExpirationTime);
          }
        }

        setCurrentPhase(null);
      }

      if (current$$1 !== null && !didReceiveUpdate) {
        bailoutHooks(current$$1, workInProgress, renderExpirationTime);
        return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
      } // React DevTools reads this flag.


      workInProgress.effectTag |= PerformedWork;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateClassComponent(current$$1, workInProgress, Component, nextProps, renderExpirationTime) {
      {
        if (workInProgress.type !== workInProgress.elementType) {
          // Lazy component props can't be validated in createElement
          // because they're only guaranteed to be resolved here.
          var innerPropTypes = Component.propTypes;

          if (innerPropTypes) {
            checkPropTypes(innerPropTypes, nextProps, // Resolved props
            'prop', getComponentName(Component), getCurrentFiberStackInDev);
          }
        }
      } // Push context providers early to prevent context stack mismatches.
      // During mounting we don't know the child context yet as the instance doesn't exist.
      // We will invalidate the child context in finishClassComponent() right after rendering.

      var hasContext;

      if (isContextProvider(Component)) {
        hasContext = true;
        pushContextProvider(workInProgress);
      } else {
        hasContext = false;
      }

      prepareToReadContext(workInProgress, renderExpirationTime);
      var instance = workInProgress.stateNode;
      var shouldUpdate;

      if (instance === null) {
        if (current$$1 !== null) {
          // An class component without an instance only mounts if it suspended
          // inside a non- concurrent tree, in an inconsistent state. We want to
          // tree it like a new mount, even though an empty version of it already
          // committed. Disconnect the alternate pointers.
          current$$1.alternate = null;
          workInProgress.alternate = null; // Since this is conceptually a new fiber, schedule a Placement effect

          workInProgress.effectTag |= Placement;
        } // In the initial pass we might need to construct the instance.


        constructClassInstance(workInProgress, Component, nextProps, renderExpirationTime);
        mountClassInstance(workInProgress, Component, nextProps, renderExpirationTime);
        shouldUpdate = true;
      } else if (current$$1 === null) {
        // In a resume, we'll already have an instance we can reuse.
        shouldUpdate = resumeMountClassInstance(workInProgress, Component, nextProps, renderExpirationTime);
      } else {
        shouldUpdate = updateClassInstance(current$$1, workInProgress, Component, nextProps, renderExpirationTime);
      }

      var nextUnitOfWork = finishClassComponent(current$$1, workInProgress, Component, shouldUpdate, hasContext, renderExpirationTime);
      {
        var inst = workInProgress.stateNode;

        if (inst.props !== nextProps) {
          !didWarnAboutReassigningProps ? warning$1(false, 'It looks like %s is reassigning its own `this.props` while rendering. ' + 'This is not supported and can lead to confusing bugs.', getComponentName(workInProgress.type) || 'a component') : void 0;
          didWarnAboutReassigningProps = true;
        }
      }
      return nextUnitOfWork;
    }

    function finishClassComponent(current$$1, workInProgress, Component, shouldUpdate, hasContext, renderExpirationTime) {
      // Refs should update even if shouldComponentUpdate returns false
      markRef(current$$1, workInProgress);
      var didCaptureError = (workInProgress.effectTag & DidCapture) !== NoEffect;

      if (!shouldUpdate && !didCaptureError) {
        // Context providers should defer to sCU for rendering
        if (hasContext) {
          invalidateContextProvider(workInProgress, Component, false);
        }

        return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
      }

      var instance = workInProgress.stateNode; // Rerender

      ReactCurrentOwner$3.current = workInProgress;
      var nextChildren;

      if (didCaptureError && typeof Component.getDerivedStateFromError !== 'function') {
        // If we captured an error, but getDerivedStateFrom catch is not defined,
        // unmount all the children. componentDidCatch will schedule an update to
        // re-render a fallback. This is temporary until we migrate everyone to
        // the new API.
        // TODO: Warn in a future release.
        nextChildren = null;

        if (enableProfilerTimer) {
          stopProfilerTimerIfRunning(workInProgress);
        }
      } else {
        {
          setCurrentPhase('render');
          nextChildren = instance.render();

          if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
            instance.render();
          }

          setCurrentPhase(null);
        }
      } // React DevTools reads this flag.


      workInProgress.effectTag |= PerformedWork;

      if (current$$1 !== null && didCaptureError) {
        // If we're recovering from an error, reconcile without reusing any of
        // the existing children. Conceptually, the normal children and the children
        // that are shown on error are two different sets, so we shouldn't reuse
        // normal children even if their identities match.
        forceUnmountCurrentAndReconcile(current$$1, workInProgress, nextChildren, renderExpirationTime);
      } else {
        reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      } // Memoize state using the values we just used to render.
      // TODO: Restructure so we never read values from the instance.


      workInProgress.memoizedState = instance.state; // The context might have changed so we need to recalculate it.

      if (hasContext) {
        invalidateContextProvider(workInProgress, Component, true);
      }

      return workInProgress.child;
    }

    function pushHostRootContext(workInProgress) {
      var root = workInProgress.stateNode;

      if (root.pendingContext) {
        pushTopLevelContextObject(workInProgress, root.pendingContext, root.pendingContext !== root.context);
      } else if (root.context) {
        // Should always be set
        pushTopLevelContextObject(workInProgress, root.context, false);
      }

      pushHostContainer(workInProgress, root.containerInfo);
    }

    function updateHostRoot(current$$1, workInProgress, renderExpirationTime) {
      pushHostRootContext(workInProgress);
      var updateQueue = workInProgress.updateQueue;

      if (!(updateQueue !== null)) {
        {
          throw Error("If the root does not have an updateQueue, we should have already bailed out. This error is likely caused by a bug in React. Please file an issue.");
        }
      }

      var nextProps = workInProgress.pendingProps;
      var prevState = workInProgress.memoizedState;
      var prevChildren = prevState !== null ? prevState.element : null;
      processUpdateQueue(workInProgress, updateQueue, nextProps, null, renderExpirationTime);
      var nextState = workInProgress.memoizedState; // Caution: React DevTools currently depends on this property
      // being called "element".

      var nextChildren = nextState.element;

      if (nextChildren === prevChildren) {
        // If the state is the same as before, that's a bailout because we had
        // no work that expires at this time.
        resetHydrationState();
        return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
      }

      var root = workInProgress.stateNode;

      if (root.hydrate && enterHydrationState(workInProgress)) {
        // If we don't have any current children this might be the first pass.
        // We always try to hydrate. If this isn't a hydration pass there won't
        // be any children to hydrate which is effectively the same thing as
        // not hydrating.
        var child = mountChildFibers(workInProgress, null, nextChildren, renderExpirationTime);
        workInProgress.child = child;
        var node = child;

        while (node) {
          // Mark each child as hydrating. This is a fast path to know whether this
          // tree is part of a hydrating tree. This is used to determine if a child
          // node has fully mounted yet, and for scheduling event replaying.
          // Conceptually this is similar to Placement in that a new subtree is
          // inserted into the React tree here. It just happens to not need DOM
          // mutations because it already exists.
          node.effectTag = node.effectTag & ~Placement | Hydrating;
          node = node.sibling;
        }
      } else {
        // Otherwise reset hydration state in case we aborted and resumed another
        // root.
        reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
        resetHydrationState();
      }

      return workInProgress.child;
    }

    function updateHostComponent(current$$1, workInProgress, renderExpirationTime) {
      pushHostContext(workInProgress);

      if (current$$1 === null) {
        tryToClaimNextHydratableInstance(workInProgress);
      }

      var type = workInProgress.type;
      var nextProps = workInProgress.pendingProps;
      var prevProps = current$$1 !== null ? current$$1.memoizedProps : null;
      var nextChildren = nextProps.children;
      var isDirectTextChild = shouldSetTextContent(type, nextProps);

      if (isDirectTextChild) {
        // We special case a direct text child of a host node. This is a common
        // case. We won't handle it as a reified child. We will instead handle
        // this in the host environment that also have access to this prop. That
        // avoids allocating another HostText fiber and traversing it.
        nextChildren = null;
      } else if (prevProps !== null && shouldSetTextContent(type, prevProps)) {
        // If we're switching from a direct text child to a normal child, or to
        // empty, we need to schedule the text content to be reset.
        workInProgress.effectTag |= ContentReset;
      }

      markRef(current$$1, workInProgress); // Check the host config to see if the children are offscreen/hidden.

      if (workInProgress.mode & ConcurrentMode && renderExpirationTime !== Never && shouldDeprioritizeSubtree(type, nextProps)) {
        if (enableSchedulerTracing) {
          markSpawnedWork(Never);
        } // Schedule this fiber to re-render at offscreen priority. Then bailout.


        workInProgress.expirationTime = workInProgress.childExpirationTime = Never;
        return null;
      }

      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateHostText(current$$1, workInProgress) {
      if (current$$1 === null) {
        tryToClaimNextHydratableInstance(workInProgress);
      } // Nothing to do here. This is terminal. We'll do the completion step
      // immediately after.


      return null;
    }

    function mountLazyComponent(_current, workInProgress, elementType, updateExpirationTime, renderExpirationTime) {
      if (_current !== null) {
        // An lazy component only mounts if it suspended inside a non-
        // concurrent tree, in an inconsistent state. We want to treat it like
        // a new mount, even though an empty version of it already committed.
        // Disconnect the alternate pointers.
        _current.alternate = null;
        workInProgress.alternate = null; // Since this is conceptually a new fiber, schedule a Placement effect

        workInProgress.effectTag |= Placement;
      }

      var props = workInProgress.pendingProps; // We can't start a User Timing measurement with correct label yet.
      // Cancel and resume right after we know the tag.

      cancelWorkTimer(workInProgress);
      var Component = readLazyComponentType(elementType); // Store the unwrapped component in the type.

      workInProgress.type = Component;
      var resolvedTag = workInProgress.tag = resolveLazyComponentTag(Component);
      startWorkTimer(workInProgress);
      var resolvedProps = resolveDefaultProps(Component, props);
      var child;

      switch (resolvedTag) {
        case FunctionComponent:
          {
            {
              validateFunctionComponentInDev(workInProgress, Component);
              workInProgress.type = Component = resolveFunctionForHotReloading(Component);
            }
            child = updateFunctionComponent(null, workInProgress, Component, resolvedProps, renderExpirationTime);
            break;
          }

        case ClassComponent:
          {
            {
              workInProgress.type = Component = resolveClassForHotReloading(Component);
            }
            child = updateClassComponent(null, workInProgress, Component, resolvedProps, renderExpirationTime);
            break;
          }

        case ForwardRef:
          {
            {
              workInProgress.type = Component = resolveForwardRefForHotReloading(Component);
            }
            child = updateForwardRef(null, workInProgress, Component, resolvedProps, renderExpirationTime);
            break;
          }

        case MemoComponent:
          {
            {
              if (workInProgress.type !== workInProgress.elementType) {
                var outerPropTypes = Component.propTypes;

                if (outerPropTypes) {
                  checkPropTypes(outerPropTypes, resolvedProps, // Resolved for outer only
                  'prop', getComponentName(Component), getCurrentFiberStackInDev);
                }
              }
            }
            child = updateMemoComponent(null, workInProgress, Component, resolveDefaultProps(Component.type, resolvedProps), // The inner type can have defaults too
            updateExpirationTime, renderExpirationTime);
            break;
          }

        default:
          {
            var hint = '';
            {
              if (Component !== null && typeof Component === 'object' && Component.$$typeof === REACT_LAZY_TYPE) {
                hint = ' Did you wrap a component in React.lazy() more than once?';
              }
            } // This message intentionally doesn't mention ForwardRef or MemoComponent
            // because the fact that it's a separate type of work is an
            // implementation detail.

            {
              {
                throw Error("Element type is invalid. Received a promise that resolves to: " + Component + ". Lazy element type must resolve to a class or function." + hint);
              }
            }
          }
      }

      return child;
    }

    function mountIncompleteClassComponent(_current, workInProgress, Component, nextProps, renderExpirationTime) {
      if (_current !== null) {
        // An incomplete component only mounts if it suspended inside a non-
        // concurrent tree, in an inconsistent state. We want to treat it like
        // a new mount, even though an empty version of it already committed.
        // Disconnect the alternate pointers.
        _current.alternate = null;
        workInProgress.alternate = null; // Since this is conceptually a new fiber, schedule a Placement effect

        workInProgress.effectTag |= Placement;
      } // Promote the fiber to a class and try rendering again.


      workInProgress.tag = ClassComponent; // The rest of this function is a fork of `updateClassComponent`
      // Push context providers early to prevent context stack mismatches.
      // During mounting we don't know the child context yet as the instance doesn't exist.
      // We will invalidate the child context in finishClassComponent() right after rendering.

      var hasContext;

      if (isContextProvider(Component)) {
        hasContext = true;
        pushContextProvider(workInProgress);
      } else {
        hasContext = false;
      }

      prepareToReadContext(workInProgress, renderExpirationTime);
      constructClassInstance(workInProgress, Component, nextProps, renderExpirationTime);
      mountClassInstance(workInProgress, Component, nextProps, renderExpirationTime);
      return finishClassComponent(null, workInProgress, Component, true, hasContext, renderExpirationTime);
    }

    function mountIndeterminateComponent(_current, workInProgress, Component, renderExpirationTime) {
      if (_current !== null) {
        // An indeterminate component only mounts if it suspended inside a non-
        // concurrent tree, in an inconsistent state. We want to treat it like
        // a new mount, even though an empty version of it already committed.
        // Disconnect the alternate pointers.
        _current.alternate = null;
        workInProgress.alternate = null; // Since this is conceptually a new fiber, schedule a Placement effect

        workInProgress.effectTag |= Placement;
      }

      var props = workInProgress.pendingProps;
      var context;

      if (!disableLegacyContext) {
        var unmaskedContext = getUnmaskedContext(workInProgress, Component, false);
        context = getMaskedContext(workInProgress, unmaskedContext);
      }

      prepareToReadContext(workInProgress, renderExpirationTime);
      var value;
      {
        if (Component.prototype && typeof Component.prototype.render === 'function') {
          var componentName = getComponentName(Component) || 'Unknown';

          if (!didWarnAboutBadClass[componentName]) {
            warningWithoutStack$1(false, "The <%s /> component appears to have a render method, but doesn't extend React.Component. " + 'This is likely to cause errors. Change %s to extend React.Component instead.', componentName, componentName);
            didWarnAboutBadClass[componentName] = true;
          }
        }

        if (workInProgress.mode & StrictMode) {
          ReactStrictModeWarnings.recordLegacyContextWarning(workInProgress, null);
        }

        ReactCurrentOwner$3.current = workInProgress;
        value = renderWithHooks(null, workInProgress, Component, props, context, renderExpirationTime);
      } // React DevTools reads this flag.

      workInProgress.effectTag |= PerformedWork;

      if (typeof value === 'object' && value !== null && typeof value.render === 'function' && value.$$typeof === undefined) {
        {
          var _componentName = getComponentName(Component) || 'Unknown';

          if (!didWarnAboutModulePatternComponent[_componentName]) {
            warningWithoutStack$1(false, 'The <%s /> component appears to be a function component that returns a class instance. ' + 'Change %s to a class that extends React.Component instead. ' + "If you can't use a class try assigning the prototype on the function as a workaround. " + "`%s.prototype = React.Component.prototype`. Don't use an arrow function since it " + 'cannot be called with `new` by React.', _componentName, _componentName, _componentName);
            didWarnAboutModulePatternComponent[_componentName] = true;
          }
        } // Proceed under the assumption that this is a class instance

        workInProgress.tag = ClassComponent; // Throw out any hooks that were used.

        resetHooks(); // Push context providers early to prevent context stack mismatches.
        // During mounting we don't know the child context yet as the instance doesn't exist.
        // We will invalidate the child context in finishClassComponent() right after rendering.

        var hasContext = false;

        if (isContextProvider(Component)) {
          hasContext = true;
          pushContextProvider(workInProgress);
        } else {
          hasContext = false;
        }

        workInProgress.memoizedState = value.state !== null && value.state !== undefined ? value.state : null;
        var getDerivedStateFromProps = Component.getDerivedStateFromProps;

        if (typeof getDerivedStateFromProps === 'function') {
          applyDerivedStateFromProps(workInProgress, Component, getDerivedStateFromProps, props);
        }

        adoptClassInstance(workInProgress, value);
        mountClassInstance(workInProgress, Component, props, renderExpirationTime);
        return finishClassComponent(null, workInProgress, Component, true, hasContext, renderExpirationTime);
      } else {
        // Proceed under the assumption that this is a function component
        workInProgress.tag = FunctionComponent;
        {
          if (disableLegacyContext && Component.contextTypes) {
            warningWithoutStack$1(false, '%s uses the legacy contextTypes API which is no longer supported. ' + 'Use React.createContext() with React.useContext() instead.', getComponentName(Component) || 'Unknown');
          }

          if (debugRenderPhaseSideEffectsForStrictMode && workInProgress.mode & StrictMode) {
            // Only double-render components with Hooks
            if (workInProgress.memoizedState !== null) {
              value = renderWithHooks(null, workInProgress, Component, props, context, renderExpirationTime);
            }
          }
        }
        reconcileChildren(null, workInProgress, value, renderExpirationTime);
        {
          validateFunctionComponentInDev(workInProgress, Component);
        }
        return workInProgress.child;
      }
    }

    function validateFunctionComponentInDev(workInProgress, Component) {
      if (Component) {
        !!Component.childContextTypes ? warningWithoutStack$1(false, '%s(...): childContextTypes cannot be defined on a function component.', Component.displayName || Component.name || 'Component') : void 0;
      }

      if (workInProgress.ref !== null) {
        var info = '';
        var ownerName = getCurrentFiberOwnerNameInDevOrNull();

        if (ownerName) {
          info += '\n\nCheck the render method of `' + ownerName + '`.';
        }

        var warningKey = ownerName || workInProgress._debugID || '';
        var debugSource = workInProgress._debugSource;

        if (debugSource) {
          warningKey = debugSource.fileName + ':' + debugSource.lineNumber;
        }

        if (!didWarnAboutFunctionRefs[warningKey]) {
          didWarnAboutFunctionRefs[warningKey] = true;
          warning$1(false, 'Function components cannot be given refs. ' + 'Attempts to access this ref will fail. ' + 'Did you mean to use React.forwardRef()?%s', info);
        }
      }

      if (warnAboutDefaultPropsOnFunctionComponents && Component.defaultProps !== undefined) {
        var componentName = getComponentName(Component) || 'Unknown';

        if (!didWarnAboutDefaultPropsOnFunctionComponent[componentName]) {
          warningWithoutStack$1(false, '%s: Support for defaultProps will be removed from function components ' + 'in a future major release. Use JavaScript default parameters instead.', componentName);
          didWarnAboutDefaultPropsOnFunctionComponent[componentName] = true;
        }
      }

      if (typeof Component.getDerivedStateFromProps === 'function') {
        var _componentName2 = getComponentName(Component) || 'Unknown';

        if (!didWarnAboutGetDerivedStateOnFunctionComponent[_componentName2]) {
          warningWithoutStack$1(false, '%s: Function components do not support getDerivedStateFromProps.', _componentName2);
          didWarnAboutGetDerivedStateOnFunctionComponent[_componentName2] = true;
        }
      }

      if (typeof Component.contextType === 'object' && Component.contextType !== null) {
        var _componentName3 = getComponentName(Component) || 'Unknown';

        if (!didWarnAboutContextTypeOnFunctionComponent[_componentName3]) {
          warningWithoutStack$1(false, '%s: Function components do not support contextType.', _componentName3);
          didWarnAboutContextTypeOnFunctionComponent[_componentName3] = true;
        }
      }
    }

    var SUSPENDED_MARKER = {
      dehydrated: null,
      retryTime: NoWork
    };

    function shouldRemainOnFallback(suspenseContext, current$$1, workInProgress) {
      // If the context is telling us that we should show a fallback, and we're not
      // already showing content, then we should show the fallback instead.
      return hasSuspenseContext(suspenseContext, ForceSuspenseFallback) && (current$$1 === null || current$$1.memoizedState !== null);
    }

    function updateSuspenseComponent(current$$1, workInProgress, renderExpirationTime) {
      var mode = workInProgress.mode;
      var nextProps = workInProgress.pendingProps; // This is used by DevTools to force a boundary to suspend.

      {
        if (shouldSuspend(workInProgress)) {
          workInProgress.effectTag |= DidCapture;
        }
      }
      var suspenseContext = suspenseStackCursor.current;
      var nextDidTimeout = false;
      var didSuspend = (workInProgress.effectTag & DidCapture) !== NoEffect;

      if (didSuspend || shouldRemainOnFallback(suspenseContext, current$$1, workInProgress)) {
        // Something in this boundary's subtree already suspended. Switch to
        // rendering the fallback children.
        nextDidTimeout = true;
        workInProgress.effectTag &= ~DidCapture;
      } else {
        // Attempting the main content
        if (current$$1 === null || current$$1.memoizedState !== null) {
          // This is a new mount or this boundary is already showing a fallback state.
          // Mark this subtree context as having at least one invisible parent that could
          // handle the fallback state.
          // Boundaries without fallbacks or should be avoided are not considered since
          // they cannot handle preferred fallback states.
          if (nextProps.fallback !== undefined && nextProps.unstable_avoidThisFallback !== true) {
            suspenseContext = addSubtreeSuspenseContext(suspenseContext, InvisibleParentSuspenseContext);
          }
        }
      }

      suspenseContext = setDefaultShallowSuspenseContext(suspenseContext);
      pushSuspenseContext(workInProgress, suspenseContext);
      {
        if ('maxDuration' in nextProps) {
          if (!didWarnAboutMaxDuration) {
            didWarnAboutMaxDuration = true;
            warning$1(false, 'maxDuration has been removed from React. ' + 'Remove the maxDuration prop.');
          }
        }
      } // This next part is a bit confusing. If the children timeout, we switch to
      // showing the fallback children in place of the "primary" children.
      // However, we don't want to delete the primary children because then their
      // state will be lost (both the React state and the host state, e.g.
      // uncontrolled form inputs). Instead we keep them mounted and hide them.
      // Both the fallback children AND the primary children are rendered at the
      // same time. Once the primary children are un-suspended, we can delete
      // the fallback children — don't need to preserve their state.
      //
      // The two sets of children are siblings in the host environment, but
      // semantically, for purposes of reconciliation, they are two separate sets.
      // So we store them using two fragment fibers.
      //
      // However, we want to avoid allocating extra fibers for every placeholder.
      // They're only necessary when the children time out, because that's the
      // only time when both sets are mounted.
      //
      // So, the extra fragment fibers are only used if the children time out.
      // Otherwise, we render the primary children directly. This requires some
      // custom reconciliation logic to preserve the state of the primary
      // children. It's essentially a very basic form of re-parenting.

      if (current$$1 === null) {
        // If we're currently hydrating, try to hydrate this boundary.
        // But only if this has a fallback.
        if (nextProps.fallback !== undefined) {
          tryToClaimNextHydratableInstance(workInProgress); // This could've been a dehydrated suspense component.

          if (enableSuspenseServerRenderer) {
            var suspenseState = workInProgress.memoizedState;

            if (suspenseState !== null) {
              var dehydrated = suspenseState.dehydrated;

              if (dehydrated !== null) {
                return mountDehydratedSuspenseComponent(workInProgress, dehydrated, renderExpirationTime);
              }
            }
          }
        } // This is the initial mount. This branch is pretty simple because there's
        // no previous state that needs to be preserved.


        if (nextDidTimeout) {
          // Mount separate fragments for primary and fallback children.
          var nextFallbackChildren = nextProps.fallback;
          var primaryChildFragment = createFiberFromFragment(null, mode, NoWork, null);
          primaryChildFragment.return = workInProgress;

          if ((workInProgress.mode & BlockingMode) === NoMode) {
            // Outside of blocking mode, we commit the effects from the
            // partially completed, timed-out tree, too.
            var progressedState = workInProgress.memoizedState;
            var progressedPrimaryChild = progressedState !== null ? workInProgress.child.child : workInProgress.child;
            primaryChildFragment.child = progressedPrimaryChild;
            var progressedChild = progressedPrimaryChild;

            while (progressedChild !== null) {
              progressedChild.return = primaryChildFragment;
              progressedChild = progressedChild.sibling;
            }
          }

          var fallbackChildFragment = createFiberFromFragment(nextFallbackChildren, mode, renderExpirationTime, null);
          fallbackChildFragment.return = workInProgress;
          primaryChildFragment.sibling = fallbackChildFragment; // Skip the primary children, and continue working on the
          // fallback children.

          workInProgress.memoizedState = SUSPENDED_MARKER;
          workInProgress.child = primaryChildFragment;
          return fallbackChildFragment;
        } else {
          // Mount the primary children without an intermediate fragment fiber.
          var nextPrimaryChildren = nextProps.children;
          workInProgress.memoizedState = null;
          return workInProgress.child = mountChildFibers(workInProgress, null, nextPrimaryChildren, renderExpirationTime);
        }
      } else {
        // This is an update. This branch is more complicated because we need to
        // ensure the state of the primary children is preserved.
        var prevState = current$$1.memoizedState;

        if (prevState !== null) {
          if (enableSuspenseServerRenderer) {
            var _dehydrated = prevState.dehydrated;

            if (_dehydrated !== null) {
              if (!didSuspend) {
                return updateDehydratedSuspenseComponent(current$$1, workInProgress, _dehydrated, prevState, renderExpirationTime);
              } else if (workInProgress.memoizedState !== null) {
                // Something suspended and we should still be in dehydrated mode.
                // Leave the existing child in place.
                workInProgress.child = current$$1.child; // The dehydrated completion pass expects this flag to be there
                // but the normal suspense pass doesn't.

                workInProgress.effectTag |= DidCapture;
                return null;
              } else {
                // Suspended but we should no longer be in dehydrated mode.
                // Therefore we now have to render the fallback. Wrap the children
                // in a fragment fiber to keep them separate from the fallback
                // children.
                var _nextFallbackChildren = nextProps.fallback;

                var _primaryChildFragment = createFiberFromFragment( // It shouldn't matter what the pending props are because we aren't
                // going to render this fragment.
                null, mode, NoWork, null);

                _primaryChildFragment.return = workInProgress; // This is always null since we never want the previous child
                // that we're not going to hydrate.

                _primaryChildFragment.child = null;

                if ((workInProgress.mode & BlockingMode) === NoMode) {
                  // Outside of blocking mode, we commit the effects from the
                  // partially completed, timed-out tree, too.
                  var _progressedChild = _primaryChildFragment.child = workInProgress.child;

                  while (_progressedChild !== null) {
                    _progressedChild.return = _primaryChildFragment;
                    _progressedChild = _progressedChild.sibling;
                  }
                } else {
                  // We will have dropped the effect list which contains the deletion.
                  // We need to reconcile to delete the current child.
                  reconcileChildFibers(workInProgress, current$$1.child, null, renderExpirationTime);
                } // Because primaryChildFragment is a new fiber that we're inserting as the
                // parent of a new tree, we need to set its treeBaseDuration.


                if (enableProfilerTimer && workInProgress.mode & ProfileMode) {
                  // treeBaseDuration is the sum of all the child tree base durations.
                  var treeBaseDuration = 0;
                  var hiddenChild = _primaryChildFragment.child;

                  while (hiddenChild !== null) {
                    treeBaseDuration += hiddenChild.treeBaseDuration;
                    hiddenChild = hiddenChild.sibling;
                  }

                  _primaryChildFragment.treeBaseDuration = treeBaseDuration;
                } // Create a fragment from the fallback children, too.


                var _fallbackChildFragment = createFiberFromFragment(_nextFallbackChildren, mode, renderExpirationTime, null);

                _fallbackChildFragment.return = workInProgress;
                _primaryChildFragment.sibling = _fallbackChildFragment;
                _fallbackChildFragment.effectTag |= Placement;
                _primaryChildFragment.childExpirationTime = NoWork;
                workInProgress.memoizedState = SUSPENDED_MARKER;
                workInProgress.child = _primaryChildFragment; // Skip the primary children, and continue working on the
                // fallback children.

                return _fallbackChildFragment;
              }
            }
          } // The current tree already timed out. That means each child set is
          // wrapped in a fragment fiber.


          var currentPrimaryChildFragment = current$$1.child;
          var currentFallbackChildFragment = currentPrimaryChildFragment.sibling;

          if (nextDidTimeout) {
            // Still timed out. Reuse the current primary children by cloning
            // its fragment. We're going to skip over these entirely.
            var _nextFallbackChildren2 = nextProps.fallback;

            var _primaryChildFragment2 = createWorkInProgress(currentPrimaryChildFragment, currentPrimaryChildFragment.pendingProps, NoWork);

            _primaryChildFragment2.return = workInProgress;

            if ((workInProgress.mode & BlockingMode) === NoMode) {
              // Outside of blocking mode, we commit the effects from the
              // partially completed, timed-out tree, too.
              var _progressedState = workInProgress.memoizedState;

              var _progressedPrimaryChild = _progressedState !== null ? workInProgress.child.child : workInProgress.child;

              if (_progressedPrimaryChild !== currentPrimaryChildFragment.child) {
                _primaryChildFragment2.child = _progressedPrimaryChild;
                var _progressedChild2 = _progressedPrimaryChild;

                while (_progressedChild2 !== null) {
                  _progressedChild2.return = _primaryChildFragment2;
                  _progressedChild2 = _progressedChild2.sibling;
                }
              }
            } // Because primaryChildFragment is a new fiber that we're inserting as the
            // parent of a new tree, we need to set its treeBaseDuration.


            if (enableProfilerTimer && workInProgress.mode & ProfileMode) {
              // treeBaseDuration is the sum of all the child tree base durations.
              var _treeBaseDuration = 0;
              var _hiddenChild = _primaryChildFragment2.child;

              while (_hiddenChild !== null) {
                _treeBaseDuration += _hiddenChild.treeBaseDuration;
                _hiddenChild = _hiddenChild.sibling;
              }

              _primaryChildFragment2.treeBaseDuration = _treeBaseDuration;
            } // Clone the fallback child fragment, too. These we'll continue
            // working on.


            var _fallbackChildFragment2 = createWorkInProgress(currentFallbackChildFragment, _nextFallbackChildren2, currentFallbackChildFragment.expirationTime);

            _fallbackChildFragment2.return = workInProgress;
            _primaryChildFragment2.sibling = _fallbackChildFragment2;
            _primaryChildFragment2.childExpirationTime = NoWork; // Skip the primary children, and continue working on the
            // fallback children.

            workInProgress.memoizedState = SUSPENDED_MARKER;
            workInProgress.child = _primaryChildFragment2;
            return _fallbackChildFragment2;
          } else {
            // No longer suspended. Switch back to showing the primary children,
            // and remove the intermediate fragment fiber.
            var _nextPrimaryChildren = nextProps.children;
            var currentPrimaryChild = currentPrimaryChildFragment.child;
            var primaryChild = reconcileChildFibers(workInProgress, currentPrimaryChild, _nextPrimaryChildren, renderExpirationTime); // If this render doesn't suspend, we need to delete the fallback
            // children. Wait until the complete phase, after we've confirmed the
            // fallback is no longer needed.
            // TODO: Would it be better to store the fallback fragment on
            // the stateNode?
            // Continue rendering the children, like we normally do.

            workInProgress.memoizedState = null;
            return workInProgress.child = primaryChild;
          }
        } else {
          // The current tree has not already timed out. That means the primary
          // children are not wrapped in a fragment fiber.
          var _currentPrimaryChild = current$$1.child;

          if (nextDidTimeout) {
            // Timed out. Wrap the children in a fragment fiber to keep them
            // separate from the fallback children.
            var _nextFallbackChildren3 = nextProps.fallback;

            var _primaryChildFragment3 = createFiberFromFragment( // It shouldn't matter what the pending props are because we aren't
            // going to render this fragment.
            null, mode, NoWork, null);

            _primaryChildFragment3.return = workInProgress;
            _primaryChildFragment3.child = _currentPrimaryChild;

            if (_currentPrimaryChild !== null) {
              _currentPrimaryChild.return = _primaryChildFragment3;
            } // Even though we're creating a new fiber, there are no new children,
            // because we're reusing an already mounted tree. So we don't need to
            // schedule a placement.
            // primaryChildFragment.effectTag |= Placement;


            if ((workInProgress.mode & BlockingMode) === NoMode) {
              // Outside of blocking mode, we commit the effects from the
              // partially completed, timed-out tree, too.
              var _progressedState2 = workInProgress.memoizedState;

              var _progressedPrimaryChild2 = _progressedState2 !== null ? workInProgress.child.child : workInProgress.child;

              _primaryChildFragment3.child = _progressedPrimaryChild2;
              var _progressedChild3 = _progressedPrimaryChild2;

              while (_progressedChild3 !== null) {
                _progressedChild3.return = _primaryChildFragment3;
                _progressedChild3 = _progressedChild3.sibling;
              }
            } // Because primaryChildFragment is a new fiber that we're inserting as the
            // parent of a new tree, we need to set its treeBaseDuration.


            if (enableProfilerTimer && workInProgress.mode & ProfileMode) {
              // treeBaseDuration is the sum of all the child tree base durations.
              var _treeBaseDuration2 = 0;
              var _hiddenChild2 = _primaryChildFragment3.child;

              while (_hiddenChild2 !== null) {
                _treeBaseDuration2 += _hiddenChild2.treeBaseDuration;
                _hiddenChild2 = _hiddenChild2.sibling;
              }

              _primaryChildFragment3.treeBaseDuration = _treeBaseDuration2;
            } // Create a fragment from the fallback children, too.


            var _fallbackChildFragment3 = createFiberFromFragment(_nextFallbackChildren3, mode, renderExpirationTime, null);

            _fallbackChildFragment3.return = workInProgress;
            _primaryChildFragment3.sibling = _fallbackChildFragment3;
            _fallbackChildFragment3.effectTag |= Placement;
            _primaryChildFragment3.childExpirationTime = NoWork; // Skip the primary children, and continue working on the
            // fallback children.

            workInProgress.memoizedState = SUSPENDED_MARKER;
            workInProgress.child = _primaryChildFragment3;
            return _fallbackChildFragment3;
          } else {
            // Still haven't timed out.  Continue rendering the children, like we
            // normally do.
            workInProgress.memoizedState = null;
            var _nextPrimaryChildren2 = nextProps.children;
            return workInProgress.child = reconcileChildFibers(workInProgress, _currentPrimaryChild, _nextPrimaryChildren2, renderExpirationTime);
          }
        }
      }
    }

    function retrySuspenseComponentWithoutHydrating(current$$1, workInProgress, renderExpirationTime) {
      // We're now not suspended nor dehydrated.
      workInProgress.memoizedState = null; // Retry with the full children.

      var nextProps = workInProgress.pendingProps;
      var nextChildren = nextProps.children; // This will ensure that the children get Placement effects and
      // that the old child gets a Deletion effect.
      // We could also call forceUnmountCurrentAndReconcile.

      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function mountDehydratedSuspenseComponent(workInProgress, suspenseInstance, renderExpirationTime) {
      // During the first pass, we'll bail out and not drill into the children.
      // Instead, we'll leave the content in place and try to hydrate it later.
      if ((workInProgress.mode & BlockingMode) === NoMode) {
        {
          warning$1(false, 'Cannot hydrate Suspense in legacy mode. Switch from ' + 'ReactDOM.hydrate(element, container) to ' + 'ReactDOM.createBlockingRoot(container, { hydrate: true })' + '.render(element) or remove the Suspense components from ' + 'the server rendered components.');
        }
        workInProgress.expirationTime = Sync;
      } else if (isSuspenseInstanceFallback(suspenseInstance)) {
        // This is a client-only boundary. Since we won't get any content from the server
        // for this, we need to schedule that at a higher priority based on when it would
        // have timed out. In theory we could render it in this pass but it would have the
        // wrong priority associated with it and will prevent hydration of parent path.
        // Instead, we'll leave work left on it to render it in a separate commit.
        // TODO This time should be the time at which the server rendered response that is
        // a parent to this boundary was displayed. However, since we currently don't have
        // a protocol to transfer that time, we'll just estimate it by using the current
        // time. This will mean that Suspense timeouts are slightly shifted to later than
        // they should be.
        var serverDisplayTime = requestCurrentTimeForUpdate(); // Schedule a normal pri update to render this content.

        var newExpirationTime = computeAsyncExpiration(serverDisplayTime);

        if (enableSchedulerTracing) {
          markSpawnedWork(newExpirationTime);
        }

        workInProgress.expirationTime = newExpirationTime;
      } else {
        // We'll continue hydrating the rest at offscreen priority since we'll already
        // be showing the right content coming from the server, it is no rush.
        workInProgress.expirationTime = Never;

        if (enableSchedulerTracing) {
          markSpawnedWork(Never);
        }
      }

      return null;
    }

    function updateDehydratedSuspenseComponent(current$$1, workInProgress, suspenseInstance, suspenseState, renderExpirationTime) {
      // We should never be hydrating at this point because it is the first pass,
      // but after we've already committed once.
      warnIfHydrating();

      if ((workInProgress.mode & BlockingMode) === NoMode) {
        return retrySuspenseComponentWithoutHydrating(current$$1, workInProgress, renderExpirationTime);
      }

      if (isSuspenseInstanceFallback(suspenseInstance)) {
        // This boundary is in a permanent fallback state. In this case, we'll never
        // get an update and we'll never be able to hydrate the final content. Let's just try the
        // client side render instead.
        return retrySuspenseComponentWithoutHydrating(current$$1, workInProgress, renderExpirationTime);
      } // We use childExpirationTime to indicate that a child might depend on context, so if
      // any context has changed, we need to treat is as if the input might have changed.


      var hasContextChanged$$1 = current$$1.childExpirationTime >= renderExpirationTime;

      if (didReceiveUpdate || hasContextChanged$$1) {
        // This boundary has changed since the first render. This means that we are now unable to
        // hydrate it. We might still be able to hydrate it using an earlier expiration time, if
        // we are rendering at lower expiration than sync.
        if (renderExpirationTime < Sync) {
          if (suspenseState.retryTime <= renderExpirationTime) {
            // This render is even higher pri than we've seen before, let's try again
            // at even higher pri.
            var attemptHydrationAtExpirationTime = renderExpirationTime + 1;
            suspenseState.retryTime = attemptHydrationAtExpirationTime;
            scheduleWork(current$$1, attemptHydrationAtExpirationTime); // TODO: Early abort this render.
          } else {// We have already tried to ping at a higher priority than we're rendering with
              // so if we got here, we must have failed to hydrate at those levels. We must
              // now give up. Instead, we're going to delete the whole subtree and instead inject
              // a new real Suspense boundary to take its place, which may render content
              // or fallback. This might suspend for a while and if it does we might still have
              // an opportunity to hydrate before this pass commits.
            }
        } // If we have scheduled higher pri work above, this will probably just abort the render
        // since we now have higher priority work, but in case it doesn't, we need to prepare to
        // render something, if we time out. Even if that requires us to delete everything and
        // skip hydration.
        // Delay having to do this as long as the suspense timeout allows us.


        renderDidSuspendDelayIfPossible();
        return retrySuspenseComponentWithoutHydrating(current$$1, workInProgress, renderExpirationTime);
      } else if (isSuspenseInstancePending(suspenseInstance)) {
        // This component is still pending more data from the server, so we can't hydrate its
        // content. We treat it as if this component suspended itself. It might seem as if
        // we could just try to render it client-side instead. However, this will perform a
        // lot of unnecessary work and is unlikely to complete since it often will suspend
        // on missing data anyway. Additionally, the server might be able to render more
        // than we can on the client yet. In that case we'd end up with more fallback states
        // on the client than if we just leave it alone. If the server times out or errors
        // these should update this boundary to the permanent Fallback state instead.
        // Mark it as having captured (i.e. suspended).
        workInProgress.effectTag |= DidCapture; // Leave the child in place. I.e. the dehydrated fragment.

        workInProgress.child = current$$1.child; // Register a callback to retry this boundary once the server has sent the result.

        registerSuspenseInstanceRetry(suspenseInstance, retryDehydratedSuspenseBoundary.bind(null, current$$1));
        return null;
      } else {
        // This is the first attempt.
        reenterHydrationStateFromDehydratedSuspenseInstance(workInProgress, suspenseInstance);
        var nextProps = workInProgress.pendingProps;
        var nextChildren = nextProps.children;
        var child = mountChildFibers(workInProgress, null, nextChildren, renderExpirationTime);
        var node = child;

        while (node) {
          // Mark each child as hydrating. This is a fast path to know whether this
          // tree is part of a hydrating tree. This is used to determine if a child
          // node has fully mounted yet, and for scheduling event replaying.
          // Conceptually this is similar to Placement in that a new subtree is
          // inserted into the React tree here. It just happens to not need DOM
          // mutations because it already exists.
          node.effectTag |= Hydrating;
          node = node.sibling;
        }

        workInProgress.child = child;
        return workInProgress.child;
      }
    }

    function scheduleWorkOnFiber(fiber, renderExpirationTime) {
      if (fiber.expirationTime < renderExpirationTime) {
        fiber.expirationTime = renderExpirationTime;
      }

      var alternate = fiber.alternate;

      if (alternate !== null && alternate.expirationTime < renderExpirationTime) {
        alternate.expirationTime = renderExpirationTime;
      }

      scheduleWorkOnParentPath(fiber.return, renderExpirationTime);
    }

    function propagateSuspenseContextChange(workInProgress, firstChild, renderExpirationTime) {
      // Mark any Suspense boundaries with fallbacks as having work to do.
      // If they were previously forced into fallbacks, they may now be able
      // to unblock.
      var node = firstChild;

      while (node !== null) {
        if (node.tag === SuspenseComponent) {
          var state = node.memoizedState;

          if (state !== null) {
            scheduleWorkOnFiber(node, renderExpirationTime);
          }
        } else if (node.tag === SuspenseListComponent) {
          // If the tail is hidden there might not be an Suspense boundaries
          // to schedule work on. In this case we have to schedule it on the
          // list itself.
          // We don't have to traverse to the children of the list since
          // the list will propagate the change when it rerenders.
          scheduleWorkOnFiber(node, renderExpirationTime);
        } else if (node.child !== null) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === workInProgress) {
          return;
        }

        while (node.sibling === null) {
          if (node.return === null || node.return === workInProgress) {
            return;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      }
    }

    function findLastContentRow(firstChild) {
      // This is going to find the last row among these children that is already
      // showing content on the screen, as opposed to being in fallback state or
      // new. If a row has multiple Suspense boundaries, any of them being in the
      // fallback state, counts as the whole row being in a fallback state.
      // Note that the "rows" will be workInProgress, but any nested children
      // will still be current since we haven't rendered them yet. The mounted
      // order may not be the same as the new order. We use the new order.
      var row = firstChild;
      var lastContentRow = null;

      while (row !== null) {
        var currentRow = row.alternate; // New rows can't be content rows.

        if (currentRow !== null && findFirstSuspended(currentRow) === null) {
          lastContentRow = row;
        }

        row = row.sibling;
      }

      return lastContentRow;
    }

    function validateRevealOrder(revealOrder) {
      {
        if (revealOrder !== undefined && revealOrder !== 'forwards' && revealOrder !== 'backwards' && revealOrder !== 'together' && !didWarnAboutRevealOrder[revealOrder]) {
          didWarnAboutRevealOrder[revealOrder] = true;

          if (typeof revealOrder === 'string') {
            switch (revealOrder.toLowerCase()) {
              case 'together':
              case 'forwards':
              case 'backwards':
                {
                  warning$1(false, '"%s" is not a valid value for revealOrder on <SuspenseList />. ' + 'Use lowercase "%s" instead.', revealOrder, revealOrder.toLowerCase());
                  break;
                }

              case 'forward':
              case 'backward':
                {
                  warning$1(false, '"%s" is not a valid value for revealOrder on <SuspenseList />. ' + 'React uses the -s suffix in the spelling. Use "%ss" instead.', revealOrder, revealOrder.toLowerCase());
                  break;
                }

              default:
                warning$1(false, '"%s" is not a supported revealOrder on <SuspenseList />. ' + 'Did you mean "together", "forwards" or "backwards"?', revealOrder);
                break;
            }
          } else {
            warning$1(false, '%s is not a supported value for revealOrder on <SuspenseList />. ' + 'Did you mean "together", "forwards" or "backwards"?', revealOrder);
          }
        }
      }
    }

    function validateTailOptions(tailMode, revealOrder) {
      {
        if (tailMode !== undefined && !didWarnAboutTailOptions[tailMode]) {
          if (tailMode !== 'collapsed' && tailMode !== 'hidden') {
            didWarnAboutTailOptions[tailMode] = true;
            warning$1(false, '"%s" is not a supported value for tail on <SuspenseList />. ' + 'Did you mean "collapsed" or "hidden"?', tailMode);
          } else if (revealOrder !== 'forwards' && revealOrder !== 'backwards') {
            didWarnAboutTailOptions[tailMode] = true;
            warning$1(false, '<SuspenseList tail="%s" /> is only valid if revealOrder is ' + '"forwards" or "backwards". ' + 'Did you mean to specify revealOrder="forwards"?', tailMode);
          }
        }
      }
    }

    function validateSuspenseListNestedChild(childSlot, index) {
      {
        var isArray = Array.isArray(childSlot);
        var isIterable = !isArray && typeof getIteratorFn(childSlot) === 'function';

        if (isArray || isIterable) {
          var type = isArray ? 'array' : 'iterable';
          warning$1(false, 'A nested %s was passed to row #%s in <SuspenseList />. Wrap it in ' + 'an additional SuspenseList to configure its revealOrder: ' + '<SuspenseList revealOrder=...> ... ' + '<SuspenseList revealOrder=...>{%s}</SuspenseList> ... ' + '</SuspenseList>', type, index, type);
          return false;
        }
      }
      return true;
    }

    function validateSuspenseListChildren(children, revealOrder) {
      {
        if ((revealOrder === 'forwards' || revealOrder === 'backwards') && children !== undefined && children !== null && children !== false) {
          if (Array.isArray(children)) {
            for (var i = 0; i < children.length; i++) {
              if (!validateSuspenseListNestedChild(children[i], i)) {
                return;
              }
            }
          } else {
            var iteratorFn = getIteratorFn(children);

            if (typeof iteratorFn === 'function') {
              var childrenIterator = iteratorFn.call(children);

              if (childrenIterator) {
                var step = childrenIterator.next();
                var _i = 0;

                for (; !step.done; step = childrenIterator.next()) {
                  if (!validateSuspenseListNestedChild(step.value, _i)) {
                    return;
                  }

                  _i++;
                }
              }
            } else {
              warning$1(false, 'A single row was passed to a <SuspenseList revealOrder="%s" />. ' + 'This is not useful since it needs multiple rows. ' + 'Did you mean to pass multiple children or an array?', revealOrder);
            }
          }
        }
      }
    }

    function initSuspenseListRenderState(workInProgress, isBackwards, tail, lastContentRow, tailMode, lastEffectBeforeRendering) {
      var renderState = workInProgress.memoizedState;

      if (renderState === null) {
        workInProgress.memoizedState = {
          isBackwards: isBackwards,
          rendering: null,
          last: lastContentRow,
          tail: tail,
          tailExpiration: 0,
          tailMode: tailMode,
          lastEffect: lastEffectBeforeRendering
        };
      } else {
        // We can reuse the existing object from previous renders.
        renderState.isBackwards = isBackwards;
        renderState.rendering = null;
        renderState.last = lastContentRow;
        renderState.tail = tail;
        renderState.tailExpiration = 0;
        renderState.tailMode = tailMode;
        renderState.lastEffect = lastEffectBeforeRendering;
      }
    } // This can end up rendering this component multiple passes.
    // The first pass splits the children fibers into two sets. A head and tail.
    // We first render the head. If anything is in fallback state, we do another
    // pass through beginWork to rerender all children (including the tail) with
    // the force suspend context. If the first render didn't have anything in
    // in fallback state. Then we render each row in the tail one-by-one.
    // That happens in the completeWork phase without going back to beginWork.


    function updateSuspenseListComponent(current$$1, workInProgress, renderExpirationTime) {
      var nextProps = workInProgress.pendingProps;
      var revealOrder = nextProps.revealOrder;
      var tailMode = nextProps.tail;
      var newChildren = nextProps.children;
      validateRevealOrder(revealOrder);
      validateTailOptions(tailMode, revealOrder);
      validateSuspenseListChildren(newChildren, revealOrder);
      reconcileChildren(current$$1, workInProgress, newChildren, renderExpirationTime);
      var suspenseContext = suspenseStackCursor.current;
      var shouldForceFallback = hasSuspenseContext(suspenseContext, ForceSuspenseFallback);

      if (shouldForceFallback) {
        suspenseContext = setShallowSuspenseContext(suspenseContext, ForceSuspenseFallback);
        workInProgress.effectTag |= DidCapture;
      } else {
        var didSuspendBefore = current$$1 !== null && (current$$1.effectTag & DidCapture) !== NoEffect;

        if (didSuspendBefore) {
          // If we previously forced a fallback, we need to schedule work
          // on any nested boundaries to let them know to try to render
          // again. This is the same as context updating.
          propagateSuspenseContextChange(workInProgress, workInProgress.child, renderExpirationTime);
        }

        suspenseContext = setDefaultShallowSuspenseContext(suspenseContext);
      }

      pushSuspenseContext(workInProgress, suspenseContext);

      if ((workInProgress.mode & BlockingMode) === NoMode) {
        // Outside of blocking mode, SuspenseList doesn't work so we just
        // use make it a noop by treating it as the default revealOrder.
        workInProgress.memoizedState = null;
      } else {
        switch (revealOrder) {
          case 'forwards':
            {
              var lastContentRow = findLastContentRow(workInProgress.child);
              var tail;

              if (lastContentRow === null) {
                // The whole list is part of the tail.
                // TODO: We could fast path by just rendering the tail now.
                tail = workInProgress.child;
                workInProgress.child = null;
              } else {
                // Disconnect the tail rows after the content row.
                // We're going to render them separately later.
                tail = lastContentRow.sibling;
                lastContentRow.sibling = null;
              }

              initSuspenseListRenderState(workInProgress, false, // isBackwards
              tail, lastContentRow, tailMode, workInProgress.lastEffect);
              break;
            }

          case 'backwards':
            {
              // We're going to find the first row that has existing content.
              // At the same time we're going to reverse the list of everything
              // we pass in the meantime. That's going to be our tail in reverse
              // order.
              var _tail = null;
              var row = workInProgress.child;
              workInProgress.child = null;

              while (row !== null) {
                var currentRow = row.alternate; // New rows can't be content rows.

                if (currentRow !== null && findFirstSuspended(currentRow) === null) {
                  // This is the beginning of the main content.
                  workInProgress.child = row;
                  break;
                }

                var nextRow = row.sibling;
                row.sibling = _tail;
                _tail = row;
                row = nextRow;
              } // TODO: If workInProgress.child is null, we can continue on the tail immediately.


              initSuspenseListRenderState(workInProgress, true, // isBackwards
              _tail, null, // last
              tailMode, workInProgress.lastEffect);
              break;
            }

          case 'together':
            {
              initSuspenseListRenderState(workInProgress, false, // isBackwards
              null, // tail
              null, // last
              undefined, workInProgress.lastEffect);
              break;
            }

          default:
            {
              // The default reveal order is the same as not having
              // a boundary.
              workInProgress.memoizedState = null;
            }
        }
      }

      return workInProgress.child;
    }

    function updatePortalComponent(current$$1, workInProgress, renderExpirationTime) {
      pushHostContainer(workInProgress, workInProgress.stateNode.containerInfo);
      var nextChildren = workInProgress.pendingProps;

      if (current$$1 === null) {
        // Portals are special because we don't append the children during mount
        // but at commit. Therefore we need to track insertions which the normal
        // flow doesn't do during mount. This doesn't happen at the root because
        // the root always starts with a "current" with a null child.
        // TODO: Consider unifying this with how the root works.
        workInProgress.child = reconcileChildFibers(workInProgress, null, nextChildren, renderExpirationTime);
      } else {
        reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      }

      return workInProgress.child;
    }

    function updateContextProvider(current$$1, workInProgress, renderExpirationTime) {
      var providerType = workInProgress.type;
      var context = providerType._context;
      var newProps = workInProgress.pendingProps;
      var oldProps = workInProgress.memoizedProps;
      var newValue = newProps.value;
      {
        var providerPropTypes = workInProgress.type.propTypes;

        if (providerPropTypes) {
          checkPropTypes(providerPropTypes, newProps, 'prop', 'Context.Provider', getCurrentFiberStackInDev);
        }
      }
      pushProvider(workInProgress, newValue);

      if (oldProps !== null) {
        var oldValue = oldProps.value;
        var changedBits = calculateChangedBits(context, newValue, oldValue);

        if (changedBits === 0) {
          // No change. Bailout early if children are the same.
          if (oldProps.children === newProps.children && !hasContextChanged()) {
            return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
          }
        } else {
          // The context value changed. Search for matching consumers and schedule
          // them to update.
          propagateContextChange(workInProgress, context, changedBits, renderExpirationTime);
        }
      }

      var newChildren = newProps.children;
      reconcileChildren(current$$1, workInProgress, newChildren, renderExpirationTime);
      return workInProgress.child;
    }

    var hasWarnedAboutUsingContextAsConsumer = false;

    function updateContextConsumer(current$$1, workInProgress, renderExpirationTime) {
      var context = workInProgress.type; // The logic below for Context differs depending on PROD or DEV mode. In
      // DEV mode, we create a separate object for Context.Consumer that acts
      // like a proxy to Context. This proxy object adds unnecessary code in PROD
      // so we use the old behaviour (Context.Consumer references Context) to
      // reduce size and overhead. The separate object references context via
      // a property called "_context", which also gives us the ability to check
      // in DEV mode if this property exists or not and warn if it does not.

      {
        if (context._context === undefined) {
          // This may be because it's a Context (rather than a Consumer).
          // Or it may be because it's older React where they're the same thing.
          // We only want to warn if we're sure it's a new React.
          if (context !== context.Consumer) {
            if (!hasWarnedAboutUsingContextAsConsumer) {
              hasWarnedAboutUsingContextAsConsumer = true;
              warning$1(false, 'Rendering <Context> directly is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Consumer> instead?');
            }
          }
        } else {
          context = context._context;
        }
      }
      var newProps = workInProgress.pendingProps;
      var render = newProps.children;
      {
        !(typeof render === 'function') ? warningWithoutStack$1(false, 'A context consumer was rendered with multiple children, or a child ' + "that isn't a function. A context consumer expects a single child " + 'that is a function. If you did pass a function, make sure there ' + 'is no trailing or leading whitespace around it.') : void 0;
      }
      prepareToReadContext(workInProgress, renderExpirationTime);
      var newValue = readContext(context, newProps.unstable_observedBits);
      var newChildren;
      {
        ReactCurrentOwner$3.current = workInProgress;
        setCurrentPhase('render');
        newChildren = render(newValue);
        setCurrentPhase(null);
      } // React DevTools reads this flag.

      workInProgress.effectTag |= PerformedWork;
      reconcileChildren(current$$1, workInProgress, newChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateFundamentalComponent$1(current$$1, workInProgress, renderExpirationTime) {
      var fundamentalImpl = workInProgress.type.impl;

      if (fundamentalImpl.reconcileChildren === false) {
        return null;
      }

      var nextProps = workInProgress.pendingProps;
      var nextChildren = nextProps.children;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function updateScopeComponent(current$$1, workInProgress, renderExpirationTime) {
      var nextProps = workInProgress.pendingProps;
      var nextChildren = nextProps.children;
      reconcileChildren(current$$1, workInProgress, nextChildren, renderExpirationTime);
      return workInProgress.child;
    }

    function markWorkInProgressReceivedUpdate() {
      didReceiveUpdate = true;
    }

    function bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime) {
      cancelWorkTimer(workInProgress);

      if (current$$1 !== null) {
        // Reuse previous dependencies
        workInProgress.dependencies = current$$1.dependencies;
      }

      if (enableProfilerTimer) {
        // Don't update "base" render times for bailouts.
        stopProfilerTimerIfRunning(workInProgress);
      }

      var updateExpirationTime = workInProgress.expirationTime;

      if (updateExpirationTime !== NoWork) {
        markUnprocessedUpdateTime(updateExpirationTime);
      } // Check if the children have any pending work.


      var childExpirationTime = workInProgress.childExpirationTime;

      if (childExpirationTime < renderExpirationTime) {
        // The children don't have any work either. We can skip them.
        // TODO: Once we add back resuming, we should check if the children are
        // a work-in-progress set. If so, we need to transfer their effects.
        return null;
      } else {
        // This fiber doesn't have work, but its subtree does. Clone the child
        // fibers and continue.
        cloneChildFibers(current$$1, workInProgress);
        return workInProgress.child;
      }
    }

    function remountFiber(current$$1, oldWorkInProgress, newWorkInProgress) {
      {
        var returnFiber = oldWorkInProgress.return;

        if (returnFiber === null) {
          throw new Error('Cannot swap the root fiber.');
        } // Disconnect from the old current.
        // It will get deleted.


        current$$1.alternate = null;
        oldWorkInProgress.alternate = null; // Connect to the new tree.

        newWorkInProgress.index = oldWorkInProgress.index;
        newWorkInProgress.sibling = oldWorkInProgress.sibling;
        newWorkInProgress.return = oldWorkInProgress.return;
        newWorkInProgress.ref = oldWorkInProgress.ref; // Replace the child/sibling pointers above it.

        if (oldWorkInProgress === returnFiber.child) {
          returnFiber.child = newWorkInProgress;
        } else {
          var prevSibling = returnFiber.child;

          if (prevSibling === null) {
            throw new Error('Expected parent to have a child.');
          }

          while (prevSibling.sibling !== oldWorkInProgress) {
            prevSibling = prevSibling.sibling;

            if (prevSibling === null) {
              throw new Error('Expected to find the previous sibling.');
            }
          }

          prevSibling.sibling = newWorkInProgress;
        } // Delete the old fiber and place the new one.
        // Since the old fiber is disconnected, we have to schedule it manually.


        var last = returnFiber.lastEffect;

        if (last !== null) {
          last.nextEffect = current$$1;
          returnFiber.lastEffect = current$$1;
        } else {
          returnFiber.firstEffect = returnFiber.lastEffect = current$$1;
        }

        current$$1.nextEffect = null;
        current$$1.effectTag = Deletion;
        newWorkInProgress.effectTag |= Placement; // Restart work from the new fiber.

        return newWorkInProgress;
      }
    }

    function beginWork$1(current$$1, workInProgress, renderExpirationTime) {
      var updateExpirationTime = workInProgress.expirationTime;
      {
        if (workInProgress._debugNeedsRemount && current$$1 !== null) {
          // This will restart the begin phase with a new fiber.
          return remountFiber(current$$1, workInProgress, createFiberFromTypeAndProps(workInProgress.type, workInProgress.key, workInProgress.pendingProps, workInProgress._debugOwner || null, workInProgress.mode, workInProgress.expirationTime));
        }
      }

      if (current$$1 !== null) {
        var oldProps = current$$1.memoizedProps;
        var newProps = workInProgress.pendingProps;

        if (oldProps !== newProps || hasContextChanged() || // Force a re-render if the implementation changed due to hot reload:
        workInProgress.type !== current$$1.type) {
          // If props or context changed, mark the fiber as having performed work.
          // This may be unset if the props are determined to be equal later (memo).
          didReceiveUpdate = true;
        } else if (updateExpirationTime < renderExpirationTime) {
          didReceiveUpdate = false; // This fiber does not have any pending work. Bailout without entering
          // the begin phase. There's still some bookkeeping we that needs to be done
          // in this optimized path, mostly pushing stuff onto the stack.

          switch (workInProgress.tag) {
            case HostRoot:
              pushHostRootContext(workInProgress);
              resetHydrationState();
              break;

            case HostComponent:
              pushHostContext(workInProgress);

              if (workInProgress.mode & ConcurrentMode && renderExpirationTime !== Never && shouldDeprioritizeSubtree(workInProgress.type, newProps)) {
                if (enableSchedulerTracing) {
                  markSpawnedWork(Never);
                } // Schedule this fiber to re-render at offscreen priority. Then bailout.


                workInProgress.expirationTime = workInProgress.childExpirationTime = Never;
                return null;
              }

              break;

            case ClassComponent:
              {
                var Component = workInProgress.type;

                if (isContextProvider(Component)) {
                  pushContextProvider(workInProgress);
                }

                break;
              }

            case HostPortal:
              pushHostContainer(workInProgress, workInProgress.stateNode.containerInfo);
              break;

            case ContextProvider:
              {
                var newValue = workInProgress.memoizedProps.value;
                pushProvider(workInProgress, newValue);
                break;
              }

            case Profiler:
              if (enableProfilerTimer) {
                // Profiler should only call onRender when one of its descendants actually rendered.
                var hasChildWork = workInProgress.childExpirationTime >= renderExpirationTime;

                if (hasChildWork) {
                  workInProgress.effectTag |= Update;
                }
              }

              break;

            case SuspenseComponent:
              {
                var state = workInProgress.memoizedState;

                if (state !== null) {
                  if (enableSuspenseServerRenderer) {
                    if (state.dehydrated !== null) {
                      pushSuspenseContext(workInProgress, setDefaultShallowSuspenseContext(suspenseStackCursor.current)); // We know that this component will suspend again because if it has
                      // been unsuspended it has committed as a resolved Suspense component.
                      // If it needs to be retried, it should have work scheduled on it.

                      workInProgress.effectTag |= DidCapture;
                      break;
                    }
                  } // If this boundary is currently timed out, we need to decide
                  // whether to retry the primary children, or to skip over it and
                  // go straight to the fallback. Check the priority of the primary
                  // child fragment.


                  var primaryChildFragment = workInProgress.child;
                  var primaryChildExpirationTime = primaryChildFragment.childExpirationTime;

                  if (primaryChildExpirationTime !== NoWork && primaryChildExpirationTime >= renderExpirationTime) {
                    // The primary children have pending work. Use the normal path
                    // to attempt to render the primary children again.
                    return updateSuspenseComponent(current$$1, workInProgress, renderExpirationTime);
                  } else {
                    pushSuspenseContext(workInProgress, setDefaultShallowSuspenseContext(suspenseStackCursor.current)); // The primary children do not have pending work with sufficient
                    // priority. Bailout.

                    var child = bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);

                    if (child !== null) {
                      // The fallback children have pending work. Skip over the
                      // primary children and work on the fallback.
                      return child.sibling;
                    } else {
                      return null;
                    }
                  }
                } else {
                  pushSuspenseContext(workInProgress, setDefaultShallowSuspenseContext(suspenseStackCursor.current));
                }

                break;
              }

            case SuspenseListComponent:
              {
                var didSuspendBefore = (current$$1.effectTag & DidCapture) !== NoEffect;

                var _hasChildWork = workInProgress.childExpirationTime >= renderExpirationTime;

                if (didSuspendBefore) {
                  if (_hasChildWork) {
                    // If something was in fallback state last time, and we have all the
                    // same children then we're still in progressive loading state.
                    // Something might get unblocked by state updates or retries in the
                    // tree which will affect the tail. So we need to use the normal
                    // path to compute the correct tail.
                    return updateSuspenseListComponent(current$$1, workInProgress, renderExpirationTime);
                  } // If none of the children had any work, that means that none of
                  // them got retried so they'll still be blocked in the same way
                  // as before. We can fast bail out.


                  workInProgress.effectTag |= DidCapture;
                } // If nothing suspended before and we're rendering the same children,
                // then the tail doesn't matter. Anything new that suspends will work
                // in the "together" mode, so we can continue from the state we had.


                var renderState = workInProgress.memoizedState;

                if (renderState !== null) {
                  // Reset to the "together" mode in case we've started a different
                  // update in the past but didn't complete it.
                  renderState.rendering = null;
                  renderState.tail = null;
                }

                pushSuspenseContext(workInProgress, suspenseStackCursor.current);

                if (_hasChildWork) {
                  break;
                } else {
                  // If none of the children had any work, that means that none of
                  // them got retried so they'll still be blocked in the same way
                  // as before. We can fast bail out.
                  return null;
                }
              }
          }

          return bailoutOnAlreadyFinishedWork(current$$1, workInProgress, renderExpirationTime);
        } else {
          // An update was scheduled on this fiber, but there are no new props
          // nor legacy context. Set this to false. If an update queue or context
          // consumer produces a changed value, it will set this to true. Otherwise,
          // the component will assume the children have not changed and bail out.
          didReceiveUpdate = false;
        }
      } else {
        didReceiveUpdate = false;
      } // Before entering the begin phase, clear the expiration time.


      workInProgress.expirationTime = NoWork;

      switch (workInProgress.tag) {
        case IndeterminateComponent:
          {
            return mountIndeterminateComponent(current$$1, workInProgress, workInProgress.type, renderExpirationTime);
          }

        case LazyComponent:
          {
            var elementType = workInProgress.elementType;
            return mountLazyComponent(current$$1, workInProgress, elementType, updateExpirationTime, renderExpirationTime);
          }

        case FunctionComponent:
          {
            var _Component = workInProgress.type;
            var unresolvedProps = workInProgress.pendingProps;
            var resolvedProps = workInProgress.elementType === _Component ? unresolvedProps : resolveDefaultProps(_Component, unresolvedProps);
            return updateFunctionComponent(current$$1, workInProgress, _Component, resolvedProps, renderExpirationTime);
          }

        case ClassComponent:
          {
            var _Component2 = workInProgress.type;
            var _unresolvedProps = workInProgress.pendingProps;

            var _resolvedProps = workInProgress.elementType === _Component2 ? _unresolvedProps : resolveDefaultProps(_Component2, _unresolvedProps);

            return updateClassComponent(current$$1, workInProgress, _Component2, _resolvedProps, renderExpirationTime);
          }

        case HostRoot:
          return updateHostRoot(current$$1, workInProgress, renderExpirationTime);

        case HostComponent:
          return updateHostComponent(current$$1, workInProgress, renderExpirationTime);

        case HostText:
          return updateHostText(current$$1, workInProgress);

        case SuspenseComponent:
          return updateSuspenseComponent(current$$1, workInProgress, renderExpirationTime);

        case HostPortal:
          return updatePortalComponent(current$$1, workInProgress, renderExpirationTime);

        case ForwardRef:
          {
            var type = workInProgress.type;
            var _unresolvedProps2 = workInProgress.pendingProps;

            var _resolvedProps2 = workInProgress.elementType === type ? _unresolvedProps2 : resolveDefaultProps(type, _unresolvedProps2);

            return updateForwardRef(current$$1, workInProgress, type, _resolvedProps2, renderExpirationTime);
          }

        case Fragment:
          return updateFragment(current$$1, workInProgress, renderExpirationTime);

        case Mode:
          return updateMode(current$$1, workInProgress, renderExpirationTime);

        case Profiler:
          return updateProfiler(current$$1, workInProgress, renderExpirationTime);

        case ContextProvider:
          return updateContextProvider(current$$1, workInProgress, renderExpirationTime);

        case ContextConsumer:
          return updateContextConsumer(current$$1, workInProgress, renderExpirationTime);

        case MemoComponent:
          {
            var _type2 = workInProgress.type;
            var _unresolvedProps3 = workInProgress.pendingProps; // Resolve outer props first, then resolve inner props.

            var _resolvedProps3 = resolveDefaultProps(_type2, _unresolvedProps3);

            {
              if (workInProgress.type !== workInProgress.elementType) {
                var outerPropTypes = _type2.propTypes;

                if (outerPropTypes) {
                  checkPropTypes(outerPropTypes, _resolvedProps3, // Resolved for outer only
                  'prop', getComponentName(_type2), getCurrentFiberStackInDev);
                }
              }
            }
            _resolvedProps3 = resolveDefaultProps(_type2.type, _resolvedProps3);
            return updateMemoComponent(current$$1, workInProgress, _type2, _resolvedProps3, updateExpirationTime, renderExpirationTime);
          }

        case SimpleMemoComponent:
          {
            return updateSimpleMemoComponent(current$$1, workInProgress, workInProgress.type, workInProgress.pendingProps, updateExpirationTime, renderExpirationTime);
          }

        case IncompleteClassComponent:
          {
            var _Component3 = workInProgress.type;
            var _unresolvedProps4 = workInProgress.pendingProps;

            var _resolvedProps4 = workInProgress.elementType === _Component3 ? _unresolvedProps4 : resolveDefaultProps(_Component3, _unresolvedProps4);

            return mountIncompleteClassComponent(current$$1, workInProgress, _Component3, _resolvedProps4, renderExpirationTime);
          }

        case SuspenseListComponent:
          {
            return updateSuspenseListComponent(current$$1, workInProgress, renderExpirationTime);
          }

        case FundamentalComponent:
          {
            if (enableFundamentalAPI) {
              return updateFundamentalComponent$1(current$$1, workInProgress, renderExpirationTime);
            }

            break;
          }

        case ScopeComponent:
          {
            if (enableScopeAPI) {
              return updateScopeComponent(current$$1, workInProgress, renderExpirationTime);
            }

            break;
          }
      }

      {
        {
          throw Error("Unknown unit of work tag (" + workInProgress.tag + "). This error is likely caused by a bug in React. Please file an issue.");
        }
      }
    }

    function createFundamentalStateInstance(currentFiber, props, impl, state) {
      return {
        currentFiber: currentFiber,
        impl: impl,
        instance: null,
        prevProps: null,
        props: props,
        state: state
      };
    }

    function isFiberSuspenseAndTimedOut(fiber) {
      return fiber.tag === SuspenseComponent && fiber.memoizedState !== null;
    }

    function getSuspenseFallbackChild(fiber) {
      return fiber.child.sibling.child;
    }

    var emptyObject$1 = {};

    function collectScopedNodes(node, fn, scopedNodes) {
      if (enableScopeAPI) {
        if (node.tag === HostComponent) {
          var _type = node.type,
              memoizedProps = node.memoizedProps,
              stateNode = node.stateNode;

          var _instance = getPublicInstance(stateNode);

          if (_instance !== null && fn(_type, memoizedProps || emptyObject$1, _instance) === true) {
            scopedNodes.push(_instance);
          }
        }

        var child = node.child;

        if (isFiberSuspenseAndTimedOut(node)) {
          child = getSuspenseFallbackChild(node);
        }

        if (child !== null) {
          collectScopedNodesFromChildren(child, fn, scopedNodes);
        }
      }
    }

    function collectFirstScopedNode(node, fn) {
      if (enableScopeAPI) {
        if (node.tag === HostComponent) {
          var _type2 = node.type,
              memoizedProps = node.memoizedProps,
              stateNode = node.stateNode;

          var _instance2 = getPublicInstance(stateNode);

          if (_instance2 !== null && fn(_type2, memoizedProps, _instance2) === true) {
            return _instance2;
          }
        }

        var child = node.child;

        if (isFiberSuspenseAndTimedOut(node)) {
          child = getSuspenseFallbackChild(node);
        }

        if (child !== null) {
          return collectFirstScopedNodeFromChildren(child, fn);
        }
      }

      return null;
    }

    function collectScopedNodesFromChildren(startingChild, fn, scopedNodes) {
      var child = startingChild;

      while (child !== null) {
        collectScopedNodes(child, fn, scopedNodes);
        child = child.sibling;
      }
    }

    function collectFirstScopedNodeFromChildren(startingChild, fn) {
      var child = startingChild;

      while (child !== null) {
        var scopedNode = collectFirstScopedNode(child, fn);

        if (scopedNode !== null) {
          return scopedNode;
        }

        child = child.sibling;
      }

      return null;
    }

    function collectNearestScopeMethods(node, scope, childrenScopes) {
      if (isValidScopeNode(node, scope)) {
        childrenScopes.push(node.stateNode.methods);
      } else {
        var child = node.child;

        if (isFiberSuspenseAndTimedOut(node)) {
          child = getSuspenseFallbackChild(node);
        }

        if (child !== null) {
          collectNearestChildScopeMethods(child, scope, childrenScopes);
        }
      }
    }

    function collectNearestChildScopeMethods(startingChild, scope, childrenScopes) {
      var child = startingChild;

      while (child !== null) {
        collectNearestScopeMethods(child, scope, childrenScopes);
        child = child.sibling;
      }
    }

    function isValidScopeNode(node, scope) {
      return node.tag === ScopeComponent && node.type === scope && node.stateNode !== null;
    }

    function createScopeMethods(scope, instance) {
      return {
        getChildren: function () {
          var currentFiber = instance.fiber;
          var child = currentFiber.child;
          var childrenScopes = [];

          if (child !== null) {
            collectNearestChildScopeMethods(child, scope, childrenScopes);
          }

          return childrenScopes.length === 0 ? null : childrenScopes;
        },
        getChildrenFromRoot: function () {
          var currentFiber = instance.fiber;
          var node = currentFiber;

          while (node !== null) {
            var parent = node.return;

            if (parent === null) {
              break;
            }

            node = parent;

            if (node.tag === ScopeComponent && node.type === scope) {
              break;
            }
          }

          var childrenScopes = [];
          collectNearestChildScopeMethods(node.child, scope, childrenScopes);
          return childrenScopes.length === 0 ? null : childrenScopes;
        },
        getParent: function () {
          var node = instance.fiber.return;

          while (node !== null) {
            if (node.tag === ScopeComponent && node.type === scope) {
              return node.stateNode.methods;
            }

            node = node.return;
          }

          return null;
        },
        getProps: function () {
          var currentFiber = instance.fiber;
          return currentFiber.memoizedProps;
        },
        queryAllNodes: function (fn) {
          var currentFiber = instance.fiber;
          var child = currentFiber.child;
          var scopedNodes = [];

          if (child !== null) {
            collectScopedNodesFromChildren(child, fn, scopedNodes);
          }

          return scopedNodes.length === 0 ? null : scopedNodes;
        },
        queryFirstNode: function (fn) {
          var currentFiber = instance.fiber;
          var child = currentFiber.child;

          if (child !== null) {
            return collectFirstScopedNodeFromChildren(child, fn);
          }

          return null;
        },
        containsNode: function (node) {
          var fiber = getInstanceFromNode$2(node);

          while (fiber !== null) {
            if (fiber.tag === ScopeComponent && fiber.type === scope && fiber.stateNode === instance) {
              return true;
            }

            fiber = fiber.return;
          }

          return false;
        }
      };
    }

    function markUpdate(workInProgress) {
      // Tag the fiber with an update effect. This turns a Placement into
      // a PlacementAndUpdate.
      workInProgress.effectTag |= Update;
    }

    function markRef$1(workInProgress) {
      workInProgress.effectTag |= Ref;
    }

    var appendAllChildren;
    var updateHostContainer;
    var updateHostComponent$1;
    var updateHostText$1;

    if (supportsMutation) {
      // Mutation mode
      appendAllChildren = function (parent, workInProgress, needsVisibilityToggle, isHidden) {
        // We only have the top Fiber that was created but we need recurse down its
        // children to find all the terminal nodes.
        var node = workInProgress.child;

        while (node !== null) {
          if (node.tag === HostComponent || node.tag === HostText) {
            appendInitialChild(parent, node.stateNode);
          } else if (enableFundamentalAPI && node.tag === FundamentalComponent) {
            appendInitialChild(parent, node.stateNode.instance);
          } else if (node.tag === HostPortal) {// If we have a portal child, then we don't want to traverse
            // down its children. Instead, we'll get insertions from each child in
            // the portal directly.
          } else if (node.child !== null) {
            node.child.return = node;
            node = node.child;
            continue;
          }

          if (node === workInProgress) {
            return;
          }

          while (node.sibling === null) {
            if (node.return === null || node.return === workInProgress) {
              return;
            }

            node = node.return;
          }

          node.sibling.return = node.return;
          node = node.sibling;
        }
      };

      updateHostContainer = function (workInProgress) {// Noop
      };

      updateHostComponent$1 = function (current, workInProgress, type, newProps, rootContainerInstance) {
        // If we have an alternate, that means this is an update and we need to
        // schedule a side-effect to do the updates.
        var oldProps = current.memoizedProps;

        if (oldProps === newProps) {
          // In mutation mode, this is sufficient for a bailout because
          // we won't touch this node even if children changed.
          return;
        } // If we get updated because one of our children updated, we don't
        // have newProps so we'll have to reuse them.
        // TODO: Split the update API as separate for the props vs. children.
        // Even better would be if children weren't special cased at all tho.


        var instance = workInProgress.stateNode;
        var currentHostContext = getHostContext(); // TODO: Experiencing an error where oldProps is null. Suggests a host
        // component is hitting the resume path. Figure out why. Possibly
        // related to `hidden`.

        var updatePayload = prepareUpdate(instance, type, oldProps, newProps, rootContainerInstance, currentHostContext); // TODO: Type this specific to this type of component.

        workInProgress.updateQueue = updatePayload; // If the update payload indicates that there is a change or if there
        // is a new ref we mark this as an update. All the work is done in commitWork.

        if (updatePayload) {
          markUpdate(workInProgress);
        }
      };

      updateHostText$1 = function (current, workInProgress, oldText, newText) {
        // If the text differs, mark it as an update. All the work in done in commitWork.
        if (oldText !== newText) {
          markUpdate(workInProgress);
        }
      };
    } else if (supportsPersistence) {
      // Persistent host tree mode
      appendAllChildren = function (parent, workInProgress, needsVisibilityToggle, isHidden) {
        // We only have the top Fiber that was created but we need recurse down its
        // children to find all the terminal nodes.
        var node = workInProgress.child;

        while (node !== null) {
          // eslint-disable-next-line no-labels
          branches: if (node.tag === HostComponent) {
            var instance = node.stateNode;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var props = node.memoizedProps;
              var type = node.type;
              instance = cloneHiddenInstance(instance, type, props, node);
            }

            appendInitialChild(parent, instance);
          } else if (node.tag === HostText) {
            var _instance = node.stateNode;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var text = node.memoizedProps;
              _instance = cloneHiddenTextInstance(_instance, text, node);
            }

            appendInitialChild(parent, _instance);
          } else if (enableFundamentalAPI && node.tag === FundamentalComponent) {
            var _instance2 = node.stateNode.instance;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var _props = node.memoizedProps;
              var _type = node.type;
              _instance2 = cloneHiddenInstance(_instance2, _type, _props, node);
            }

            appendInitialChild(parent, _instance2);
          } else if (node.tag === HostPortal) {// If we have a portal child, then we don't want to traverse
            // down its children. Instead, we'll get insertions from each child in
            // the portal directly.
          } else if (node.tag === SuspenseComponent) {
            if ((node.effectTag & Update) !== NoEffect) {
              // Need to toggle the visibility of the primary children.
              var newIsHidden = node.memoizedState !== null;

              if (newIsHidden) {
                var primaryChildParent = node.child;

                if (primaryChildParent !== null) {
                  if (primaryChildParent.child !== null) {
                    primaryChildParent.child.return = primaryChildParent;
                    appendAllChildren(parent, primaryChildParent, true, newIsHidden);
                  }

                  var fallbackChildParent = primaryChildParent.sibling;

                  if (fallbackChildParent !== null) {
                    fallbackChildParent.return = node;
                    node = fallbackChildParent;
                    continue;
                  }
                }
              }
            }

            if (node.child !== null) {
              // Continue traversing like normal
              node.child.return = node;
              node = node.child;
              continue;
            }
          } else if (node.child !== null) {
            node.child.return = node;
            node = node.child;
            continue;
          } // $FlowFixMe This is correct but Flow is confused by the labeled break.


          node = node;

          if (node === workInProgress) {
            return;
          }

          while (node.sibling === null) {
            if (node.return === null || node.return === workInProgress) {
              return;
            }

            node = node.return;
          }

          node.sibling.return = node.return;
          node = node.sibling;
        }
      }; // An unfortunate fork of appendAllChildren because we have two different parent types.


      var appendAllChildrenToContainer = function (containerChildSet, workInProgress, needsVisibilityToggle, isHidden) {
        // We only have the top Fiber that was created but we need recurse down its
        // children to find all the terminal nodes.
        var node = workInProgress.child;

        while (node !== null) {
          // eslint-disable-next-line no-labels
          branches: if (node.tag === HostComponent) {
            var instance = node.stateNode;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var props = node.memoizedProps;
              var type = node.type;
              instance = cloneHiddenInstance(instance, type, props, node);
            }

            appendChildToContainerChildSet(containerChildSet, instance);
          } else if (node.tag === HostText) {
            var _instance3 = node.stateNode;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var text = node.memoizedProps;
              _instance3 = cloneHiddenTextInstance(_instance3, text, node);
            }

            appendChildToContainerChildSet(containerChildSet, _instance3);
          } else if (enableFundamentalAPI && node.tag === FundamentalComponent) {
            var _instance4 = node.stateNode.instance;

            if (needsVisibilityToggle && isHidden) {
              // This child is inside a timed out tree. Hide it.
              var _props2 = node.memoizedProps;
              var _type2 = node.type;
              _instance4 = cloneHiddenInstance(_instance4, _type2, _props2, node);
            }

            appendChildToContainerChildSet(containerChildSet, _instance4);
          } else if (node.tag === HostPortal) {// If we have a portal child, then we don't want to traverse
            // down its children. Instead, we'll get insertions from each child in
            // the portal directly.
          } else if (node.tag === SuspenseComponent) {
            if ((node.effectTag & Update) !== NoEffect) {
              // Need to toggle the visibility of the primary children.
              var newIsHidden = node.memoizedState !== null;

              if (newIsHidden) {
                var primaryChildParent = node.child;

                if (primaryChildParent !== null) {
                  if (primaryChildParent.child !== null) {
                    primaryChildParent.child.return = primaryChildParent;
                    appendAllChildrenToContainer(containerChildSet, primaryChildParent, true, newIsHidden);
                  }

                  var fallbackChildParent = primaryChildParent.sibling;

                  if (fallbackChildParent !== null) {
                    fallbackChildParent.return = node;
                    node = fallbackChildParent;
                    continue;
                  }
                }
              }
            }

            if (node.child !== null) {
              // Continue traversing like normal
              node.child.return = node;
              node = node.child;
              continue;
            }
          } else if (node.child !== null) {
            node.child.return = node;
            node = node.child;
            continue;
          } // $FlowFixMe This is correct but Flow is confused by the labeled break.


          node = node;

          if (node === workInProgress) {
            return;
          }

          while (node.sibling === null) {
            if (node.return === null || node.return === workInProgress) {
              return;
            }

            node = node.return;
          }

          node.sibling.return = node.return;
          node = node.sibling;
        }
      };

      updateHostContainer = function (workInProgress) {
        var portalOrRoot = workInProgress.stateNode;
        var childrenUnchanged = workInProgress.firstEffect === null;

        if (childrenUnchanged) {// No changes, just reuse the existing instance.
        } else {
          var container = portalOrRoot.containerInfo;
          var newChildSet = createContainerChildSet(container); // If children might have changed, we have to add them all to the set.

          appendAllChildrenToContainer(newChildSet, workInProgress, false, false);
          portalOrRoot.pendingChildren = newChildSet; // Schedule an update on the container to swap out the container.

          markUpdate(workInProgress);
          finalizeContainerChildren(container, newChildSet);
        }
      };

      updateHostComponent$1 = function (current, workInProgress, type, newProps, rootContainerInstance) {
        var currentInstance = current.stateNode;
        var oldProps = current.memoizedProps; // If there are no effects associated with this node, then none of our children had any updates.
        // This guarantees that we can reuse all of them.

        var childrenUnchanged = workInProgress.firstEffect === null;

        if (childrenUnchanged && oldProps === newProps) {
          // No changes, just reuse the existing instance.
          // Note that this might release a previous clone.
          workInProgress.stateNode = currentInstance;
          return;
        }

        var recyclableInstance = workInProgress.stateNode;
        var currentHostContext = getHostContext();
        var updatePayload = null;

        if (oldProps !== newProps) {
          updatePayload = prepareUpdate(recyclableInstance, type, oldProps, newProps, rootContainerInstance, currentHostContext);
        }

        if (childrenUnchanged && updatePayload === null) {
          // No changes, just reuse the existing instance.
          // Note that this might release a previous clone.
          workInProgress.stateNode = currentInstance;
          return;
        }

        var newInstance = cloneInstance(currentInstance, updatePayload, type, oldProps, newProps, workInProgress, childrenUnchanged, recyclableInstance);

        if (finalizeInitialChildren(newInstance, type, newProps, rootContainerInstance, currentHostContext)) {
          markUpdate(workInProgress);
        }

        workInProgress.stateNode = newInstance;

        if (childrenUnchanged) {
          // If there are no other effects in this tree, we need to flag this node as having one.
          // Even though we're not going to use it for anything.
          // Otherwise parents won't know that there are new children to propagate upwards.
          markUpdate(workInProgress);
        } else {
          // If children might have changed, we have to add them all to the set.
          appendAllChildren(newInstance, workInProgress, false, false);
        }
      };

      updateHostText$1 = function (current, workInProgress, oldText, newText) {
        if (oldText !== newText) {
          // If the text content differs, we'll create a new text instance for it.
          var rootContainerInstance = getRootHostContainer();
          var currentHostContext = getHostContext();
          workInProgress.stateNode = createTextInstance(newText, rootContainerInstance, currentHostContext, workInProgress); // We'll have to mark it as having an effect, even though we won't use the effect for anything.
          // This lets the parents know that at least one of their children has changed.

          markUpdate(workInProgress);
        }
      };
    } else {
      // No host operations
      updateHostContainer = function (workInProgress) {// Noop
      };

      updateHostComponent$1 = function (current, workInProgress, type, newProps, rootContainerInstance) {// Noop
      };

      updateHostText$1 = function (current, workInProgress, oldText, newText) {// Noop
      };
    }

    function cutOffTailIfNeeded(renderState, hasRenderedATailFallback) {
      switch (renderState.tailMode) {
        case 'hidden':
          {
            // Any insertions at the end of the tail list after this point
            // should be invisible. If there are already mounted boundaries
            // anything before them are not considered for collapsing.
            // Therefore we need to go through the whole tail to find if
            // there are any.
            var tailNode = renderState.tail;
            var lastTailNode = null;

            while (tailNode !== null) {
              if (tailNode.alternate !== null) {
                lastTailNode = tailNode;
              }

              tailNode = tailNode.sibling;
            } // Next we're simply going to delete all insertions after the
            // last rendered item.


            if (lastTailNode === null) {
              // All remaining items in the tail are insertions.
              renderState.tail = null;
            } else {
              // Detach the insertion after the last node that was already
              // inserted.
              lastTailNode.sibling = null;
            }

            break;
          }

        case 'collapsed':
          {
            // Any insertions at the end of the tail list after this point
            // should be invisible. If there are already mounted boundaries
            // anything before them are not considered for collapsing.
            // Therefore we need to go through the whole tail to find if
            // there are any.
            var _tailNode = renderState.tail;
            var _lastTailNode = null;

            while (_tailNode !== null) {
              if (_tailNode.alternate !== null) {
                _lastTailNode = _tailNode;
              }

              _tailNode = _tailNode.sibling;
            } // Next we're simply going to delete all insertions after the
            // last rendered item.


            if (_lastTailNode === null) {
              // All remaining items in the tail are insertions.
              if (!hasRenderedATailFallback && renderState.tail !== null) {
                // We suspended during the head. We want to show at least one
                // row at the tail. So we'll keep on and cut off the rest.
                renderState.tail.sibling = null;
              } else {
                renderState.tail = null;
              }
            } else {
              // Detach the insertion after the last node that was already
              // inserted.
              _lastTailNode.sibling = null;
            }

            break;
          }
      }
    }

    function completeWork(current, workInProgress, renderExpirationTime) {
      var newProps = workInProgress.pendingProps;

      switch (workInProgress.tag) {
        case IndeterminateComponent:
          break;

        case LazyComponent:
          break;

        case SimpleMemoComponent:
        case FunctionComponent:
          break;

        case ClassComponent:
          {
            var Component = workInProgress.type;

            if (isContextProvider(Component)) {
              popContext(workInProgress);
            }

            break;
          }

        case HostRoot:
          {
            popHostContainer(workInProgress);
            popTopLevelContextObject(workInProgress);
            var fiberRoot = workInProgress.stateNode;

            if (fiberRoot.pendingContext) {
              fiberRoot.context = fiberRoot.pendingContext;
              fiberRoot.pendingContext = null;
            }

            if (current === null || current.child === null) {
              // If we hydrated, pop so that we can delete any remaining children
              // that weren't hydrated.
              var wasHydrated = popHydrationState(workInProgress);

              if (wasHydrated) {
                // If we hydrated, then we'll need to schedule an update for
                // the commit side-effects on the root.
                markUpdate(workInProgress);
              }
            }

            updateHostContainer(workInProgress);
            break;
          }

        case HostComponent:
          {
            popHostContext(workInProgress);
            var rootContainerInstance = getRootHostContainer();
            var type = workInProgress.type;

            if (current !== null && workInProgress.stateNode != null) {
              updateHostComponent$1(current, workInProgress, type, newProps, rootContainerInstance);

              if (enableFlareAPI) {
                var prevListeners = current.memoizedProps.listeners;
                var nextListeners = newProps.listeners;

                if (prevListeners !== nextListeners) {
                  markUpdate(workInProgress);
                }
              }

              if (current.ref !== workInProgress.ref) {
                markRef$1(workInProgress);
              }
            } else {
              if (!newProps) {
                if (!(workInProgress.stateNode !== null)) {
                  {
                    throw Error("We must have new props for new mounts. This error is likely caused by a bug in React. Please file an issue.");
                  }
                } // This can happen when we abort work.


                break;
              }

              var currentHostContext = getHostContext(); // TODO: Move createInstance to beginWork and keep it on a context
              // "stack" as the parent. Then append children as we go in beginWork
              // or completeWork depending on we want to add then top->down or
              // bottom->up. Top->down is faster in IE11.

              var _wasHydrated = popHydrationState(workInProgress);

              if (_wasHydrated) {
                // TODO: Move this and createInstance step into the beginPhase
                // to consolidate.
                if (prepareToHydrateHostInstance(workInProgress, rootContainerInstance, currentHostContext)) {
                  // If changes to the hydrated node needs to be applied at the
                  // commit-phase we mark this as such.
                  markUpdate(workInProgress);
                }

                if (enableFlareAPI) {
                  var listeners = newProps.listeners;

                  if (listeners != null) {
                    updateEventListeners(listeners, workInProgress, rootContainerInstance);
                  }
                }
              } else {
                var instance = createInstance(type, newProps, rootContainerInstance, currentHostContext, workInProgress);
                appendAllChildren(instance, workInProgress, false, false); // This needs to be set before we mount Flare event listeners

                workInProgress.stateNode = instance;

                if (enableFlareAPI) {
                  var _listeners = newProps.listeners;

                  if (_listeners != null) {
                    updateEventListeners(_listeners, workInProgress, rootContainerInstance);
                  }
                } // Certain renderers require commit-time effects for initial mount.
                // (eg DOM renderer supports auto-focus for certain elements).
                // Make sure such renderers get scheduled for later work.


                if (finalizeInitialChildren(instance, type, newProps, rootContainerInstance, currentHostContext)) {
                  markUpdate(workInProgress);
                }
              }

              if (workInProgress.ref !== null) {
                // If there is a ref on a host node we need to schedule a callback
                markRef$1(workInProgress);
              }
            }

            break;
          }

        case HostText:
          {
            var newText = newProps;

            if (current && workInProgress.stateNode != null) {
              var oldText = current.memoizedProps; // If we have an alternate, that means this is an update and we need
              // to schedule a side-effect to do the updates.

              updateHostText$1(current, workInProgress, oldText, newText);
            } else {
              if (typeof newText !== 'string') {
                if (!(workInProgress.stateNode !== null)) {
                  {
                    throw Error("We must have new props for new mounts. This error is likely caused by a bug in React. Please file an issue.");
                  }
                } // This can happen when we abort work.

              }

              var _rootContainerInstance = getRootHostContainer();

              var _currentHostContext = getHostContext();

              var _wasHydrated2 = popHydrationState(workInProgress);

              if (_wasHydrated2) {
                if (prepareToHydrateHostTextInstance(workInProgress)) {
                  markUpdate(workInProgress);
                }
              } else {
                workInProgress.stateNode = createTextInstance(newText, _rootContainerInstance, _currentHostContext, workInProgress);
              }
            }

            break;
          }

        case ForwardRef:
          break;

        case SuspenseComponent:
          {
            popSuspenseContext(workInProgress);
            var nextState = workInProgress.memoizedState;

            if (enableSuspenseServerRenderer) {
              if (nextState !== null && nextState.dehydrated !== null) {
                if (current === null) {
                  var _wasHydrated3 = popHydrationState(workInProgress);

                  if (!_wasHydrated3) {
                    {
                      throw Error("A dehydrated suspense component was completed without a hydrated node. This is probably a bug in React.");
                    }
                  }

                  prepareToHydrateHostSuspenseInstance(workInProgress);

                  if (enableSchedulerTracing) {
                    markSpawnedWork(Never);
                  }

                  return null;
                } else {
                  // We should never have been in a hydration state if we didn't have a current.
                  // However, in some of those paths, we might have reentered a hydration state
                  // and then we might be inside a hydration state. In that case, we'll need to
                  // exit out of it.
                  resetHydrationState();

                  if ((workInProgress.effectTag & DidCapture) === NoEffect) {
                    // This boundary did not suspend so it's now hydrated and unsuspended.
                    workInProgress.memoizedState = null;
                  } // If nothing suspended, we need to schedule an effect to mark this boundary
                  // as having hydrated so events know that they're free be invoked.
                  // It's also a signal to replay events and the suspense callback.
                  // If something suspended, schedule an effect to attach retry listeners.
                  // So we might as well always mark this.


                  workInProgress.effectTag |= Update;
                  return null;
                }
              }
            }

            if ((workInProgress.effectTag & DidCapture) !== NoEffect) {
              // Something suspended. Re-render with the fallback children.
              workInProgress.expirationTime = renderExpirationTime; // Do not reset the effect list.

              return workInProgress;
            }

            var nextDidTimeout = nextState !== null;
            var prevDidTimeout = false;

            if (current === null) {
              if (workInProgress.memoizedProps.fallback !== undefined) {
                popHydrationState(workInProgress);
              }
            } else {
              var prevState = current.memoizedState;
              prevDidTimeout = prevState !== null;

              if (!nextDidTimeout && prevState !== null) {
                // We just switched from the fallback to the normal children.
                // Delete the fallback.
                // TODO: Would it be better to store the fallback fragment on
                // the stateNode during the begin phase?
                var currentFallbackChild = current.child.sibling;

                if (currentFallbackChild !== null) {
                  // Deletions go at the beginning of the return fiber's effect list
                  var first = workInProgress.firstEffect;

                  if (first !== null) {
                    workInProgress.firstEffect = currentFallbackChild;
                    currentFallbackChild.nextEffect = first;
                  } else {
                    workInProgress.firstEffect = workInProgress.lastEffect = currentFallbackChild;
                    currentFallbackChild.nextEffect = null;
                  }

                  currentFallbackChild.effectTag = Deletion;
                }
              }
            }

            if (nextDidTimeout && !prevDidTimeout) {
              // If this subtreee is running in blocking mode we can suspend,
              // otherwise we won't suspend.
              // TODO: This will still suspend a synchronous tree if anything
              // in the concurrent tree already suspended during this render.
              // This is a known bug.
              if ((workInProgress.mode & BlockingMode) !== NoMode) {
                // TODO: Move this back to throwException because this is too late
                // if this is a large tree which is common for initial loads. We
                // don't know if we should restart a render or not until we get
                // this marker, and this is too late.
                // If this render already had a ping or lower pri updates,
                // and this is the first time we know we're going to suspend we
                // should be able to immediately restart from within throwException.
                var hasInvisibleChildContext = current === null && workInProgress.memoizedProps.unstable_avoidThisFallback !== true;

                if (hasInvisibleChildContext || hasSuspenseContext(suspenseStackCursor.current, InvisibleParentSuspenseContext)) {
                  // If this was in an invisible tree or a new render, then showing
                  // this boundary is ok.
                  renderDidSuspend();
                } else {
                  // Otherwise, we're going to have to hide content so we should
                  // suspend for longer if possible.
                  renderDidSuspendDelayIfPossible();
                }
              }
            }

            if (supportsPersistence) {
              // TODO: Only schedule updates if not prevDidTimeout.
              if (nextDidTimeout) {
                // If this boundary just timed out, schedule an effect to attach a
                // retry listener to the proimse. This flag is also used to hide the
                // primary children.
                workInProgress.effectTag |= Update;
              }
            }

            if (supportsMutation) {
              // TODO: Only schedule updates if these values are non equal, i.e. it changed.
              if (nextDidTimeout || prevDidTimeout) {
                // If this boundary just timed out, schedule an effect to attach a
                // retry listener to the proimse. This flag is also used to hide the
                // primary children. In mutation mode, we also need the flag to
                // *unhide* children that were previously hidden, so check if the
                // is currently timed out, too.
                workInProgress.effectTag |= Update;
              }
            }

            if (enableSuspenseCallback && workInProgress.updateQueue !== null && workInProgress.memoizedProps.suspenseCallback != null) {
              // Always notify the callback
              workInProgress.effectTag |= Update;
            }

            break;
          }

        case Fragment:
          break;

        case Mode:
          break;

        case Profiler:
          break;

        case HostPortal:
          popHostContainer(workInProgress);
          updateHostContainer(workInProgress);
          break;

        case ContextProvider:
          // Pop provider fiber
          popProvider(workInProgress);
          break;

        case ContextConsumer:
          break;

        case MemoComponent:
          break;

        case IncompleteClassComponent:
          {
            // Same as class component case. I put it down here so that the tags are
            // sequential to ensure this switch is compiled to a jump table.
            var _Component = workInProgress.type;

            if (isContextProvider(_Component)) {
              popContext(workInProgress);
            }

            break;
          }

        case SuspenseListComponent:
          {
            popSuspenseContext(workInProgress);
            var renderState = workInProgress.memoizedState;

            if (renderState === null) {
              // We're running in the default, "independent" mode. We don't do anything
              // in this mode.
              break;
            }

            var didSuspendAlready = (workInProgress.effectTag & DidCapture) !== NoEffect;
            var renderedTail = renderState.rendering;

            if (renderedTail === null) {
              // We just rendered the head.
              if (!didSuspendAlready) {
                // This is the first pass. We need to figure out if anything is still
                // suspended in the rendered set.
                // If new content unsuspended, but there's still some content that
                // didn't. Then we need to do a second pass that forces everything
                // to keep showing their fallbacks.
                // We might be suspended if something in this render pass suspended, or
                // something in the previous committed pass suspended. Otherwise,
                // there's no chance so we can skip the expensive call to
                // findFirstSuspended.
                var cannotBeSuspended = renderHasNotSuspendedYet() && (current === null || (current.effectTag & DidCapture) === NoEffect);

                if (!cannotBeSuspended) {
                  var row = workInProgress.child;

                  while (row !== null) {
                    var suspended = findFirstSuspended(row);

                    if (suspended !== null) {
                      didSuspendAlready = true;
                      workInProgress.effectTag |= DidCapture;
                      cutOffTailIfNeeded(renderState, false); // If this is a newly suspended tree, it might not get committed as
                      // part of the second pass. In that case nothing will subscribe to
                      // its thennables. Instead, we'll transfer its thennables to the
                      // SuspenseList so that it can retry if they resolve.
                      // There might be multiple of these in the list but since we're
                      // going to wait for all of them anyway, it doesn't really matter
                      // which ones gets to ping. In theory we could get clever and keep
                      // track of how many dependencies remain but it gets tricky because
                      // in the meantime, we can add/remove/change items and dependencies.
                      // We might bail out of the loop before finding any but that
                      // doesn't matter since that means that the other boundaries that
                      // we did find already has their listeners attached.

                      var newThennables = suspended.updateQueue;

                      if (newThennables !== null) {
                        workInProgress.updateQueue = newThennables;
                        workInProgress.effectTag |= Update;
                      } // Rerender the whole list, but this time, we'll force fallbacks
                      // to stay in place.
                      // Reset the effect list before doing the second pass since that's now invalid.


                      if (renderState.lastEffect === null) {
                        workInProgress.firstEffect = null;
                      }

                      workInProgress.lastEffect = renderState.lastEffect; // Reset the child fibers to their original state.

                      resetChildFibers(workInProgress, renderExpirationTime); // Set up the Suspense Context to force suspense and immediately
                      // rerender the children.

                      pushSuspenseContext(workInProgress, setShallowSuspenseContext(suspenseStackCursor.current, ForceSuspenseFallback));
                      return workInProgress.child;
                    }

                    row = row.sibling;
                  }
                }
              } else {
                cutOffTailIfNeeded(renderState, false);
              } // Next we're going to render the tail.

            } else {
              // Append the rendered row to the child list.
              if (!didSuspendAlready) {
                var _suspended = findFirstSuspended(renderedTail);

                if (_suspended !== null) {
                  workInProgress.effectTag |= DidCapture;
                  didSuspendAlready = true; // Ensure we transfer the update queue to the parent so that it doesn't
                  // get lost if this row ends up dropped during a second pass.

                  var _newThennables = _suspended.updateQueue;

                  if (_newThennables !== null) {
                    workInProgress.updateQueue = _newThennables;
                    workInProgress.effectTag |= Update;
                  }

                  cutOffTailIfNeeded(renderState, true); // This might have been modified.

                  if (renderState.tail === null && renderState.tailMode === 'hidden' && !renderedTail.alternate) {
                    // We need to delete the row we just rendered.
                    // Reset the effect list to what it was before we rendered this
                    // child. The nested children have already appended themselves.
                    var lastEffect = workInProgress.lastEffect = renderState.lastEffect; // Remove any effects that were appended after this point.

                    if (lastEffect !== null) {
                      lastEffect.nextEffect = null;
                    } // We're done.


                    return null;
                  }
                } else if (now() > renderState.tailExpiration && renderExpirationTime > Never) {
                  // We have now passed our CPU deadline and we'll just give up further
                  // attempts to render the main content and only render fallbacks.
                  // The assumption is that this is usually faster.
                  workInProgress.effectTag |= DidCapture;
                  didSuspendAlready = true;
                  cutOffTailIfNeeded(renderState, false); // Since nothing actually suspended, there will nothing to ping this
                  // to get it started back up to attempt the next item. If we can show
                  // them, then they really have the same priority as this render.
                  // So we'll pick it back up the very next render pass once we've had
                  // an opportunity to yield for paint.

                  var nextPriority = renderExpirationTime - 1;
                  workInProgress.expirationTime = workInProgress.childExpirationTime = nextPriority;

                  if (enableSchedulerTracing) {
                    markSpawnedWork(nextPriority);
                  }
                }
              }

              if (renderState.isBackwards) {
                // The effect list of the backwards tail will have been added
                // to the end. This breaks the guarantee that life-cycles fire in
                // sibling order but that isn't a strong guarantee promised by React.
                // Especially since these might also just pop in during future commits.
                // Append to the beginning of the list.
                renderedTail.sibling = workInProgress.child;
                workInProgress.child = renderedTail;
              } else {
                var previousSibling = renderState.last;

                if (previousSibling !== null) {
                  previousSibling.sibling = renderedTail;
                } else {
                  workInProgress.child = renderedTail;
                }

                renderState.last = renderedTail;
              }
            }

            if (renderState.tail !== null) {
              // We still have tail rows to render.
              if (renderState.tailExpiration === 0) {
                // Heuristic for how long we're willing to spend rendering rows
                // until we just give up and show what we have so far.
                var TAIL_EXPIRATION_TIMEOUT_MS = 500;
                renderState.tailExpiration = now() + TAIL_EXPIRATION_TIMEOUT_MS;
              } // Pop a row.


              var next = renderState.tail;
              renderState.rendering = next;
              renderState.tail = next.sibling;
              renderState.lastEffect = workInProgress.lastEffect;
              next.sibling = null; // Restore the context.
              // TODO: We can probably just avoid popping it instead and only
              // setting it the first time we go from not suspended to suspended.

              var suspenseContext = suspenseStackCursor.current;

              if (didSuspendAlready) {
                suspenseContext = setShallowSuspenseContext(suspenseContext, ForceSuspenseFallback);
              } else {
                suspenseContext = setDefaultShallowSuspenseContext(suspenseContext);
              }

              pushSuspenseContext(workInProgress, suspenseContext); // Do a pass over the next row.

              return next;
            }

            break;
          }

        case FundamentalComponent:
          {
            if (enableFundamentalAPI) {
              var fundamentalImpl = workInProgress.type.impl;
              var fundamentalInstance = workInProgress.stateNode;

              if (fundamentalInstance === null) {
                var getInitialState = fundamentalImpl.getInitialState;
                var fundamentalState;

                if (getInitialState !== undefined) {
                  fundamentalState = getInitialState(newProps);
                }

                fundamentalInstance = workInProgress.stateNode = createFundamentalStateInstance(workInProgress, newProps, fundamentalImpl, fundamentalState || {});

                var _instance5 = getFundamentalComponentInstance(fundamentalInstance);

                fundamentalInstance.instance = _instance5;

                if (fundamentalImpl.reconcileChildren === false) {
                  return null;
                }

                appendAllChildren(_instance5, workInProgress, false, false);
                mountFundamentalComponent(fundamentalInstance);
              } else {
                // We fire update in commit phase
                var prevProps = fundamentalInstance.props;
                fundamentalInstance.prevProps = prevProps;
                fundamentalInstance.props = newProps;
                fundamentalInstance.currentFiber = workInProgress;

                if (supportsPersistence) {
                  var _instance6 = cloneFundamentalInstance(fundamentalInstance);

                  fundamentalInstance.instance = _instance6;
                  appendAllChildren(_instance6, workInProgress, false, false);
                }

                var shouldUpdate = shouldUpdateFundamentalComponent(fundamentalInstance);

                if (shouldUpdate) {
                  markUpdate(workInProgress);
                }
              }
            }

            break;
          }

        case ScopeComponent:
          {
            if (enableScopeAPI) {
              if (current === null) {
                var _type3 = workInProgress.type;
                var scopeInstance = {
                  fiber: workInProgress,
                  methods: null
                };
                workInProgress.stateNode = scopeInstance;
                scopeInstance.methods = createScopeMethods(_type3, scopeInstance);

                if (enableFlareAPI) {
                  var _listeners2 = newProps.listeners;

                  if (_listeners2 != null) {
                    var _rootContainerInstance2 = getRootHostContainer();

                    updateEventListeners(_listeners2, workInProgress, _rootContainerInstance2);
                  }
                }

                if (workInProgress.ref !== null) {
                  markRef$1(workInProgress);
                  markUpdate(workInProgress);
                }
              } else {
                if (enableFlareAPI) {
                  var _prevListeners = current.memoizedProps.listeners;
                  var _nextListeners = newProps.listeners;

                  if (_prevListeners !== _nextListeners || workInProgress.ref !== null) {
                    markUpdate(workInProgress);
                  }
                } else {
                  if (workInProgress.ref !== null) {
                    markUpdate(workInProgress);
                  }
                }

                if (current.ref !== workInProgress.ref) {
                  markRef$1(workInProgress);
                }
              }
            }

            break;
          }

        default:
          {
            {
              throw Error("Unknown unit of work tag (" + workInProgress.tag + "). This error is likely caused by a bug in React. Please file an issue.");
            }
          }
      }

      return null;
    }

    function unwindWork(workInProgress, renderExpirationTime) {
      switch (workInProgress.tag) {
        case ClassComponent:
          {
            var Component = workInProgress.type;

            if (isContextProvider(Component)) {
              popContext(workInProgress);
            }

            var effectTag = workInProgress.effectTag;

            if (effectTag & ShouldCapture) {
              workInProgress.effectTag = effectTag & ~ShouldCapture | DidCapture;
              return workInProgress;
            }

            return null;
          }

        case HostRoot:
          {
            popHostContainer(workInProgress);
            popTopLevelContextObject(workInProgress);
            var _effectTag = workInProgress.effectTag;

            if (!((_effectTag & DidCapture) === NoEffect)) {
              {
                throw Error("The root failed to unmount after an error. This is likely a bug in React. Please file an issue.");
              }
            }

            workInProgress.effectTag = _effectTag & ~ShouldCapture | DidCapture;
            return workInProgress;
          }

        case HostComponent:
          {
            // TODO: popHydrationState
            popHostContext(workInProgress);
            return null;
          }

        case SuspenseComponent:
          {
            popSuspenseContext(workInProgress);

            if (enableSuspenseServerRenderer) {
              var suspenseState = workInProgress.memoizedState;

              if (suspenseState !== null && suspenseState.dehydrated !== null) {
                if (!(workInProgress.alternate !== null)) {
                  {
                    throw Error("Threw in newly mounted dehydrated component. This is likely a bug in React. Please file an issue.");
                  }
                }

                resetHydrationState();
              }
            }

            var _effectTag2 = workInProgress.effectTag;

            if (_effectTag2 & ShouldCapture) {
              workInProgress.effectTag = _effectTag2 & ~ShouldCapture | DidCapture; // Captured a suspense effect. Re-render the boundary.

              return workInProgress;
            }

            return null;
          }

        case SuspenseListComponent:
          {
            popSuspenseContext(workInProgress); // SuspenseList doesn't actually catch anything. It should've been
            // caught by a nested boundary. If not, it should bubble through.

            return null;
          }

        case HostPortal:
          popHostContainer(workInProgress);
          return null;

        case ContextProvider:
          popProvider(workInProgress);
          return null;

        default:
          return null;
      }
    }

    function unwindInterruptedWork(interruptedWork) {
      switch (interruptedWork.tag) {
        case ClassComponent:
          {
            var childContextTypes = interruptedWork.type.childContextTypes;

            if (childContextTypes !== null && childContextTypes !== undefined) {
              popContext(interruptedWork);
            }

            break;
          }

        case HostRoot:
          {
            popHostContainer(interruptedWork);
            popTopLevelContextObject(interruptedWork);
            break;
          }

        case HostComponent:
          {
            popHostContext(interruptedWork);
            break;
          }

        case HostPortal:
          popHostContainer(interruptedWork);
          break;

        case SuspenseComponent:
          popSuspenseContext(interruptedWork);
          break;

        case SuspenseListComponent:
          popSuspenseContext(interruptedWork);
          break;

        case ContextProvider:
          popProvider(interruptedWork);
          break;

        default:
          break;
      }
    }

    function createCapturedValue(value, source) {
      // If the value is an error, call this function immediately after it is thrown
      // so the stack is accurate.
      return {
        value: value,
        source: source,
        stack: getStackByFiberInDevAndProd(source)
      };
    } // This module is forked in different environments.
    // By default, return `true` to log errors to the console.
    // Forks can return `false` if this isn't desirable.


    function showErrorDialog(capturedError) {
      return true;
    }

    function logCapturedError(capturedError) {
      var logError = showErrorDialog(capturedError); // Allow injected showErrorDialog() to prevent default console.error logging.
      // This enables renderers like ReactNative to better manage redbox behavior.

      if (logError === false) {
        return;
      }

      var error = capturedError.error;
      {
        var componentName = capturedError.componentName,
            componentStack = capturedError.componentStack,
            errorBoundaryName = capturedError.errorBoundaryName,
            errorBoundaryFound = capturedError.errorBoundaryFound,
            willRetry = capturedError.willRetry; // Browsers support silencing uncaught errors by calling
        // `preventDefault()` in window `error` handler.
        // We record this information as an expando on the error.

        if (error != null && error._suppressLogging) {
          if (errorBoundaryFound && willRetry) {
            // The error is recoverable and was silenced.
            // Ignore it and don't print the stack addendum.
            // This is handy for testing error boundaries without noise.
            return;
          } // The error is fatal. Since the silencing might have
          // been accidental, we'll surface it anyway.
          // However, the browser would have silenced the original error
          // so we'll print it first, and then print the stack addendum.


          console.error(error); // For a more detailed description of this block, see:
          // https://github.com/facebook/react/pull/13384
        }

        var componentNameMessage = componentName ? "The above error occurred in the <" + componentName + "> component:" : 'The above error occurred in one of your React components:';
        var errorBoundaryMessage; // errorBoundaryFound check is sufficient; errorBoundaryName check is to satisfy Flow.

        if (errorBoundaryFound && errorBoundaryName) {
          if (willRetry) {
            errorBoundaryMessage = "React will try to recreate this component tree from scratch " + ("using the error boundary you provided, " + errorBoundaryName + ".");
          } else {
            errorBoundaryMessage = "This error was initially handled by the error boundary " + errorBoundaryName + ".\n" + "Recreating the tree from scratch failed so React will unmount the tree.";
          }
        } else {
          errorBoundaryMessage = 'Consider adding an error boundary to your tree to customize error handling behavior.\n' + 'Visit https://fb.me/react-error-boundaries to learn more about error boundaries.';
        }

        var combinedMessage = "" + componentNameMessage + componentStack + "\n\n" + ("" + errorBoundaryMessage); // In development, we provide our own message with just the component stack.
        // We don't include the original error message and JS stack because the browser
        // has already printed it. Even if the application swallows the error, it is still
        // displayed by the browser thanks to the DEV-only fake event trick in ReactErrorUtils.

        console.error(combinedMessage);
      }
    }

    var didWarnAboutUndefinedSnapshotBeforeUpdate = null;
    {
      didWarnAboutUndefinedSnapshotBeforeUpdate = new Set();
    }
    var PossiblyWeakSet = typeof WeakSet === 'function' ? WeakSet : Set;

    function logError(boundary, errorInfo) {
      var source = errorInfo.source;
      var stack = errorInfo.stack;

      if (stack === null && source !== null) {
        stack = getStackByFiberInDevAndProd(source);
      }

      var capturedError = {
        componentName: source !== null ? getComponentName(source.type) : null,
        componentStack: stack !== null ? stack : '',
        error: errorInfo.value,
        errorBoundary: null,
        errorBoundaryName: null,
        errorBoundaryFound: false,
        willRetry: false
      };

      if (boundary !== null && boundary.tag === ClassComponent) {
        capturedError.errorBoundary = boundary.stateNode;
        capturedError.errorBoundaryName = getComponentName(boundary.type);
        capturedError.errorBoundaryFound = true;
        capturedError.willRetry = true;
      }

      try {
        logCapturedError(capturedError);
      } catch (e) {
        // This method must not throw, or React internal state will get messed up.
        // If console.error is overridden, or logCapturedError() shows a dialog that throws,
        // we want to report this error outside of the normal stack as a last resort.
        // https://github.com/facebook/react/issues/13188
        setTimeout(function () {
          throw e;
        });
      }
    }

    var callComponentWillUnmountWithTimer = function (current$$1, instance) {
      startPhaseTimer(current$$1, 'componentWillUnmount');
      instance.props = current$$1.memoizedProps;
      instance.state = current$$1.memoizedState;
      instance.componentWillUnmount();
      stopPhaseTimer();
    }; // Capture errors so they don't interrupt unmounting.


    function safelyCallComponentWillUnmount(current$$1, instance) {
      {
        invokeGuardedCallback(null, callComponentWillUnmountWithTimer, null, current$$1, instance);

        if (hasCaughtError()) {
          var unmountError = clearCaughtError();
          captureCommitPhaseError(current$$1, unmountError);
        }
      }
    }

    function safelyDetachRef(current$$1) {
      var ref = current$$1.ref;

      if (ref !== null) {
        if (typeof ref === 'function') {
          {
            invokeGuardedCallback(null, ref, null, null);

            if (hasCaughtError()) {
              var refError = clearCaughtError();
              captureCommitPhaseError(current$$1, refError);
            }
          }
        } else {
          ref.current = null;
        }
      }
    }

    function safelyCallDestroy(current$$1, destroy) {
      {
        invokeGuardedCallback(null, destroy, null);

        if (hasCaughtError()) {
          var error = clearCaughtError();
          captureCommitPhaseError(current$$1, error);
        }
      }
    }

    function commitBeforeMutationLifeCycles(current$$1, finishedWork) {
      switch (finishedWork.tag) {
        case FunctionComponent:
        case ForwardRef:
        case SimpleMemoComponent:
          {
            commitHookEffectList(UnmountSnapshot, NoEffect$1, finishedWork);
            return;
          }

        case ClassComponent:
          {
            if (finishedWork.effectTag & Snapshot) {
              if (current$$1 !== null) {
                var prevProps = current$$1.memoizedProps;
                var prevState = current$$1.memoizedState;
                startPhaseTimer(finishedWork, 'getSnapshotBeforeUpdate');
                var instance = finishedWork.stateNode; // We could update instance props and state here,
                // but instead we rely on them being set during last render.
                // TODO: revisit this when we implement resuming.

                {
                  if (finishedWork.type === finishedWork.elementType && !didWarnAboutReassigningProps) {
                    !(instance.props === finishedWork.memoizedProps) ? warning$1(false, 'Expected %s props to match memoized props before ' + 'getSnapshotBeforeUpdate. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                    !(instance.state === finishedWork.memoizedState) ? warning$1(false, 'Expected %s state to match memoized state before ' + 'getSnapshotBeforeUpdate. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                  }
                }
                var snapshot = instance.getSnapshotBeforeUpdate(finishedWork.elementType === finishedWork.type ? prevProps : resolveDefaultProps(finishedWork.type, prevProps), prevState);
                {
                  var didWarnSet = didWarnAboutUndefinedSnapshotBeforeUpdate;

                  if (snapshot === undefined && !didWarnSet.has(finishedWork.type)) {
                    didWarnSet.add(finishedWork.type);
                    warningWithoutStack$1(false, '%s.getSnapshotBeforeUpdate(): A snapshot value (or null) ' + 'must be returned. You have returned undefined.', getComponentName(finishedWork.type));
                  }
                }
                instance.__reactInternalSnapshotBeforeUpdate = snapshot;
                stopPhaseTimer();
              }
            }

            return;
          }

        case HostRoot:
        case HostComponent:
        case HostText:
        case HostPortal:
        case IncompleteClassComponent:
          // Nothing to do for these component types
          return;

        default:
          {
            {
              {
                throw Error("This unit of work tag should not have side-effects. This error is likely caused by a bug in React. Please file an issue.");
              }
            }
          }
      }
    }

    function commitHookEffectList(unmountTag, mountTag, finishedWork) {
      var updateQueue = finishedWork.updateQueue;
      var lastEffect = updateQueue !== null ? updateQueue.lastEffect : null;

      if (lastEffect !== null) {
        var firstEffect = lastEffect.next;
        var effect = firstEffect;

        do {
          if ((effect.tag & unmountTag) !== NoEffect$1) {
            // Unmount
            var destroy = effect.destroy;
            effect.destroy = undefined;

            if (destroy !== undefined) {
              destroy();
            }
          }

          if ((effect.tag & mountTag) !== NoEffect$1) {
            // Mount
            var create = effect.create;
            effect.destroy = create();
            {
              var _destroy = effect.destroy;

              if (_destroy !== undefined && typeof _destroy !== 'function') {
                var addendum = void 0;

                if (_destroy === null) {
                  addendum = ' You returned null. If your effect does not require clean ' + 'up, return undefined (or nothing).';
                } else if (typeof _destroy.then === 'function') {
                  addendum = '\n\nIt looks like you wrote useEffect(async () => ...) or returned a Promise. ' + 'Instead, write the async function inside your effect ' + 'and call it immediately:\n\n' + 'useEffect(() => {\n' + '  async function fetchData() {\n' + '    // You can await here\n' + '    const response = await MyAPI.getData(someId);\n' + '    // ...\n' + '  }\n' + '  fetchData();\n' + "}, [someId]); // Or [] if effect doesn't need props or state\n\n" + 'Learn more about data fetching with Hooks: https://fb.me/react-hooks-data-fetching';
                } else {
                  addendum = ' You returned: ' + _destroy;
                }

                warningWithoutStack$1(false, 'An effect function must not return anything besides a function, ' + 'which is used for clean-up.%s%s', addendum, getStackByFiberInDevAndProd(finishedWork));
              }
            }
          }

          effect = effect.next;
        } while (effect !== firstEffect);
      }
    }

    function commitPassiveHookEffects(finishedWork) {
      if ((finishedWork.effectTag & Passive) !== NoEffect) {
        switch (finishedWork.tag) {
          case FunctionComponent:
          case ForwardRef:
          case SimpleMemoComponent:
            {
              commitHookEffectList(UnmountPassive, NoEffect$1, finishedWork);
              commitHookEffectList(NoEffect$1, MountPassive, finishedWork);
              break;
            }

          default:
            break;
        }
      }
    }

    function commitLifeCycles(finishedRoot, current$$1, finishedWork, committedExpirationTime) {
      switch (finishedWork.tag) {
        case FunctionComponent:
        case ForwardRef:
        case SimpleMemoComponent:
          {
            commitHookEffectList(UnmountLayout, MountLayout, finishedWork);
            break;
          }

        case ClassComponent:
          {
            var instance = finishedWork.stateNode;

            if (finishedWork.effectTag & Update) {
              if (current$$1 === null) {
                startPhaseTimer(finishedWork, 'componentDidMount'); // We could update instance props and state here,
                // but instead we rely on them being set during last render.
                // TODO: revisit this when we implement resuming.

                {
                  if (finishedWork.type === finishedWork.elementType && !didWarnAboutReassigningProps) {
                    !(instance.props === finishedWork.memoizedProps) ? warning$1(false, 'Expected %s props to match memoized props before ' + 'componentDidMount. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                    !(instance.state === finishedWork.memoizedState) ? warning$1(false, 'Expected %s state to match memoized state before ' + 'componentDidMount. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                  }
                }
                instance.componentDidMount();
                stopPhaseTimer();
              } else {
                var prevProps = finishedWork.elementType === finishedWork.type ? current$$1.memoizedProps : resolveDefaultProps(finishedWork.type, current$$1.memoizedProps);
                var prevState = current$$1.memoizedState;
                startPhaseTimer(finishedWork, 'componentDidUpdate'); // We could update instance props and state here,
                // but instead we rely on them being set during last render.
                // TODO: revisit this when we implement resuming.

                {
                  if (finishedWork.type === finishedWork.elementType && !didWarnAboutReassigningProps) {
                    !(instance.props === finishedWork.memoizedProps) ? warning$1(false, 'Expected %s props to match memoized props before ' + 'componentDidUpdate. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                    !(instance.state === finishedWork.memoizedState) ? warning$1(false, 'Expected %s state to match memoized state before ' + 'componentDidUpdate. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                  }
                }
                instance.componentDidUpdate(prevProps, prevState, instance.__reactInternalSnapshotBeforeUpdate);
                stopPhaseTimer();
              }
            }

            var updateQueue = finishedWork.updateQueue;

            if (updateQueue !== null) {
              {
                if (finishedWork.type === finishedWork.elementType && !didWarnAboutReassigningProps) {
                  !(instance.props === finishedWork.memoizedProps) ? warning$1(false, 'Expected %s props to match memoized props before ' + 'processing the update queue. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                  !(instance.state === finishedWork.memoizedState) ? warning$1(false, 'Expected %s state to match memoized state before ' + 'processing the update queue. ' + 'This might either be because of a bug in React, or because ' + 'a component reassigns its own `this.props`. ' + 'Please file an issue.', getComponentName(finishedWork.type) || 'instance') : void 0;
                }
              } // We could update instance props and state here,
              // but instead we rely on them being set during last render.
              // TODO: revisit this when we implement resuming.

              commitUpdateQueue(finishedWork, updateQueue, instance, committedExpirationTime);
            }

            return;
          }

        case HostRoot:
          {
            var _updateQueue = finishedWork.updateQueue;

            if (_updateQueue !== null) {
              var _instance = null;

              if (finishedWork.child !== null) {
                switch (finishedWork.child.tag) {
                  case HostComponent:
                    _instance = getPublicInstance(finishedWork.child.stateNode);
                    break;

                  case ClassComponent:
                    _instance = finishedWork.child.stateNode;
                    break;
                }
              }

              commitUpdateQueue(finishedWork, _updateQueue, _instance, committedExpirationTime);
            }

            return;
          }

        case HostComponent:
          {
            var _instance2 = finishedWork.stateNode; // Renderers may schedule work to be done after host components are mounted
            // (eg DOM renderer may schedule auto-focus for inputs and form controls).
            // These effects should only be committed when components are first mounted,
            // aka when there is no current/alternate.

            if (current$$1 === null && finishedWork.effectTag & Update) {
              var type = finishedWork.type;
              var props = finishedWork.memoizedProps;
              commitMount(_instance2, type, props, finishedWork);
            }

            return;
          }

        case HostText:
          {
            // We have no life-cycles associated with text.
            return;
          }

        case HostPortal:
          {
            // We have no life-cycles associated with portals.
            return;
          }

        case Profiler:
          {
            if (enableProfilerTimer) {
              var onRender = finishedWork.memoizedProps.onRender;

              if (typeof onRender === 'function') {
                if (enableSchedulerTracing) {
                  onRender(finishedWork.memoizedProps.id, current$$1 === null ? 'mount' : 'update', finishedWork.actualDuration, finishedWork.treeBaseDuration, finishedWork.actualStartTime, getCommitTime(), finishedRoot.memoizedInteractions);
                } else {
                  onRender(finishedWork.memoizedProps.id, current$$1 === null ? 'mount' : 'update', finishedWork.actualDuration, finishedWork.treeBaseDuration, finishedWork.actualStartTime, getCommitTime());
                }
              }
            }

            return;
          }

        case SuspenseComponent:
          {
            commitSuspenseHydrationCallbacks(finishedRoot, finishedWork);
            return;
          }

        case SuspenseListComponent:
        case IncompleteClassComponent:
        case FundamentalComponent:
        case ScopeComponent:
          return;

        default:
          {
            {
              {
                throw Error("This unit of work tag should not have side-effects. This error is likely caused by a bug in React. Please file an issue.");
              }
            }
          }
      }
    }

    function hideOrUnhideAllChildren(finishedWork, isHidden) {
      if (supportsMutation) {
        // We only have the top Fiber that was inserted but we need to recurse down its
        // children to find all the terminal nodes.
        var node = finishedWork;

        while (true) {
          if (node.tag === HostComponent) {
            var instance = node.stateNode;

            if (isHidden) {
              hideInstance(instance);
            } else {
              unhideInstance(node.stateNode, node.memoizedProps);
            }
          } else if (node.tag === HostText) {
            var _instance3 = node.stateNode;

            if (isHidden) {
              hideTextInstance(_instance3);
            } else {
              unhideTextInstance(_instance3, node.memoizedProps);
            }
          } else if (node.tag === SuspenseComponent && node.memoizedState !== null && node.memoizedState.dehydrated === null) {
            // Found a nested Suspense component that timed out. Skip over the
            // primary child fragment, which should remain hidden.
            var fallbackChildFragment = node.child.sibling;
            fallbackChildFragment.return = node;
            node = fallbackChildFragment;
            continue;
          } else if (node.child !== null) {
            node.child.return = node;
            node = node.child;
            continue;
          }

          if (node === finishedWork) {
            return;
          }

          while (node.sibling === null) {
            if (node.return === null || node.return === finishedWork) {
              return;
            }

            node = node.return;
          }

          node.sibling.return = node.return;
          node = node.sibling;
        }
      }
    }

    function commitAttachRef(finishedWork) {
      var ref = finishedWork.ref;

      if (ref !== null) {
        var instance = finishedWork.stateNode;
        var instanceToUse;

        switch (finishedWork.tag) {
          case HostComponent:
            instanceToUse = getPublicInstance(instance);
            break;

          default:
            instanceToUse = instance;
        } // Moved outside to ensure DCE works with this flag


        if (enableScopeAPI && finishedWork.tag === ScopeComponent) {
          instanceToUse = instance.methods;
        }

        if (typeof ref === 'function') {
          ref(instanceToUse);
        } else {
          {
            if (!ref.hasOwnProperty('current')) {
              warningWithoutStack$1(false, 'Unexpected ref object provided for %s. ' + 'Use either a ref-setter function or React.createRef().%s', getComponentName(finishedWork.type), getStackByFiberInDevAndProd(finishedWork));
            }
          }
          ref.current = instanceToUse;
        }
      }
    }

    function commitDetachRef(current$$1) {
      var currentRef = current$$1.ref;

      if (currentRef !== null) {
        if (typeof currentRef === 'function') {
          currentRef(null);
        } else {
          currentRef.current = null;
        }
      }
    } // User-originating errors (lifecycles and refs) should not interrupt
    // deletion, so don't let them throw. Host-originating errors should
    // interrupt deletion, so it's okay


    function commitUnmount(finishedRoot, current$$1, renderPriorityLevel) {
      onCommitUnmount(current$$1);

      switch (current$$1.tag) {
        case FunctionComponent:
        case ForwardRef:
        case MemoComponent:
        case SimpleMemoComponent:
          {
            var updateQueue = current$$1.updateQueue;

            if (updateQueue !== null) {
              var lastEffect = updateQueue.lastEffect;

              if (lastEffect !== null) {
                var firstEffect = lastEffect.next; // When the owner fiber is deleted, the destroy function of a passive
                // effect hook is called during the synchronous commit phase. This is
                // a concession to implementation complexity. Calling it in the
                // passive effect phase (like they usually are, when dependencies
                // change during an update) would require either traversing the
                // children of the deleted fiber again, or including unmount effects
                // as part of the fiber effect list.
                //
                // Because this is during the sync commit phase, we need to change
                // the priority.
                //
                // TODO: Reconsider this implementation trade off.

                var priorityLevel = renderPriorityLevel > NormalPriority ? NormalPriority : renderPriorityLevel;
                runWithPriority$2(priorityLevel, function () {
                  var effect = firstEffect;

                  do {
                    var destroy = effect.destroy;

                    if (destroy !== undefined) {
                      safelyCallDestroy(current$$1, destroy);
                    }

                    effect = effect.next;
                  } while (effect !== firstEffect);
                });
              }
            }

            break;
          }

        case ClassComponent:
          {
            safelyDetachRef(current$$1);
            var instance = current$$1.stateNode;

            if (typeof instance.componentWillUnmount === 'function') {
              safelyCallComponentWillUnmount(current$$1, instance);
            }

            return;
          }

        case HostComponent:
          {
            if (enableFlareAPI) {
              var dependencies = current$$1.dependencies;

              if (dependencies !== null) {
                var respondersMap = dependencies.responders;

                if (respondersMap !== null) {
                  var responderInstances = Array.from(respondersMap.values());

                  for (var i = 0, length = responderInstances.length; i < length; i++) {
                    var responderInstance = responderInstances[i];
                    unmountResponderInstance(responderInstance);
                  }

                  dependencies.responders = null;
                }
              }
            }

            safelyDetachRef(current$$1);
            return;
          }

        case HostPortal:
          {
            // TODO: this is recursive.
            // We are also not using this parent because
            // the portal will get pushed immediately.
            if (supportsMutation) {
              unmountHostComponents(finishedRoot, current$$1, renderPriorityLevel);
            } else if (supportsPersistence) {
              emptyPortalContainer(current$$1);
            }

            return;
          }

        case FundamentalComponent:
          {
            if (enableFundamentalAPI) {
              var fundamentalInstance = current$$1.stateNode;

              if (fundamentalInstance !== null) {
                unmountFundamentalComponent(fundamentalInstance);
                current$$1.stateNode = null;
              }
            }

            return;
          }

        case DehydratedFragment:
          {
            if (enableSuspenseCallback) {
              var hydrationCallbacks = finishedRoot.hydrationCallbacks;

              if (hydrationCallbacks !== null) {
                var onDeleted = hydrationCallbacks.onDeleted;

                if (onDeleted) {
                  onDeleted(current$$1.stateNode);
                }
              }
            }

            return;
          }

        case ScopeComponent:
          {
            if (enableScopeAPI) {
              safelyDetachRef(current$$1);
            }
          }
      }
    }

    function commitNestedUnmounts(finishedRoot, root, renderPriorityLevel) {
      // While we're inside a removed host node we don't want to call
      // removeChild on the inner nodes because they're removed by the top
      // call anyway. We also want to call componentWillUnmount on all
      // composites before this host node is removed from the tree. Therefore
      // we do an inner loop while we're still inside the host node.
      var node = root;

      while (true) {
        commitUnmount(finishedRoot, node, renderPriorityLevel); // Visit children because they may contain more composite or host nodes.
        // Skip portals because commitUnmount() currently visits them recursively.

        if (node.child !== null && ( // If we use mutation we drill down into portals using commitUnmount above.
        // If we don't use mutation we drill down into portals here instead.
        !supportsMutation || node.tag !== HostPortal)) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === root) {
          return;
        }

        while (node.sibling === null) {
          if (node.return === null || node.return === root) {
            return;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      }
    }

    function detachFiber(current$$1) {
      var alternate = current$$1.alternate; // Cut off the return pointers to disconnect it from the tree. Ideally, we
      // should clear the child pointer of the parent alternate to let this
      // get GC:ed but we don't know which for sure which parent is the current
      // one so we'll settle for GC:ing the subtree of this child. This child
      // itself will be GC:ed when the parent updates the next time.

      current$$1.return = null;
      current$$1.child = null;
      current$$1.memoizedState = null;
      current$$1.updateQueue = null;
      current$$1.dependencies = null;
      current$$1.alternate = null;
      current$$1.firstEffect = null;
      current$$1.lastEffect = null;
      current$$1.pendingProps = null;
      current$$1.memoizedProps = null;

      if (alternate !== null) {
        detachFiber(alternate);
      }
    }

    function emptyPortalContainer(current$$1) {
      if (!supportsPersistence) {
        return;
      }

      var portal = current$$1.stateNode;
      var containerInfo = portal.containerInfo;
      var emptyChildSet = createContainerChildSet(containerInfo);
      replaceContainerChildren(containerInfo, emptyChildSet);
    }

    function commitContainer(finishedWork) {
      if (!supportsPersistence) {
        return;
      }

      switch (finishedWork.tag) {
        case ClassComponent:
        case HostComponent:
        case HostText:
        case FundamentalComponent:
          {
            return;
          }

        case HostRoot:
        case HostPortal:
          {
            var portalOrRoot = finishedWork.stateNode;
            var containerInfo = portalOrRoot.containerInfo,
                pendingChildren = portalOrRoot.pendingChildren;
            replaceContainerChildren(containerInfo, pendingChildren);
            return;
          }

        default:
          {
            {
              {
                throw Error("This unit of work tag should not have side-effects. This error is likely caused by a bug in React. Please file an issue.");
              }
            }
          }
      }
    }

    function getHostParentFiber(fiber) {
      var parent = fiber.return;

      while (parent !== null) {
        if (isHostParent(parent)) {
          return parent;
        }

        parent = parent.return;
      }

      {
        {
          throw Error("Expected to find a host parent. This error is likely caused by a bug in React. Please file an issue.");
        }
      }
    }

    function isHostParent(fiber) {
      return fiber.tag === HostComponent || fiber.tag === HostRoot || fiber.tag === HostPortal;
    }

    function getHostSibling(fiber) {
      // We're going to search forward into the tree until we find a sibling host
      // node. Unfortunately, if multiple insertions are done in a row we have to
      // search past them. This leads to exponential search for the next sibling.
      // TODO: Find a more efficient way to do this.
      var node = fiber;

      siblings: while (true) {
        // If we didn't find anything, let's try the next sibling.
        while (node.sibling === null) {
          if (node.return === null || isHostParent(node.return)) {
            // If we pop out of the root or hit the parent the fiber we are the
            // last sibling.
            return null;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;

        while (node.tag !== HostComponent && node.tag !== HostText && node.tag !== DehydratedFragment) {
          // If it is not host node and, we might have a host node inside it.
          // Try to search down until we find one.
          if (node.effectTag & Placement) {
            // If we don't have a child, try the siblings instead.
            continue siblings;
          } // If we don't have a child, try the siblings instead.
          // We also skip portals because they are not part of this host tree.


          if (node.child === null || node.tag === HostPortal) {
            continue siblings;
          } else {
            node.child.return = node;
            node = node.child;
          }
        } // Check if this host node is stable or about to be placed.


        if (!(node.effectTag & Placement)) {
          // Found it!
          return node.stateNode;
        }
      }
    }

    function commitPlacement(finishedWork) {
      if (!supportsMutation) {
        return;
      } // Recursively insert all host nodes into the parent.


      var parentFiber = getHostParentFiber(finishedWork); // Note: these two variables *must* always be updated together.

      var parent;
      var isContainer;
      var parentStateNode = parentFiber.stateNode;

      switch (parentFiber.tag) {
        case HostComponent:
          parent = parentStateNode;
          isContainer = false;
          break;

        case HostRoot:
          parent = parentStateNode.containerInfo;
          isContainer = true;
          break;

        case HostPortal:
          parent = parentStateNode.containerInfo;
          isContainer = true;
          break;

        case FundamentalComponent:
          if (enableFundamentalAPI) {
            parent = parentStateNode.instance;
            isContainer = false;
          }

        // eslint-disable-next-line-no-fallthrough

        default:
          {
            {
              throw Error("Invalid host parent fiber. This error is likely caused by a bug in React. Please file an issue.");
            }
          }
      }

      if (parentFiber.effectTag & ContentReset) {
        // Reset the text content of the parent before doing any insertions
        resetTextContent(parent); // Clear ContentReset from the effect tag

        parentFiber.effectTag &= ~ContentReset;
      }

      var before = getHostSibling(finishedWork); // We only have the top Fiber that was inserted but we need to recurse down its
      // children to find all the terminal nodes.

      var node = finishedWork;

      while (true) {
        var isHost = node.tag === HostComponent || node.tag === HostText;

        if (isHost || enableFundamentalAPI && node.tag === FundamentalComponent) {
          var stateNode = isHost ? node.stateNode : node.stateNode.instance;

          if (before) {
            if (isContainer) {
              insertInContainerBefore(parent, stateNode, before);
            } else {
              insertBefore(parent, stateNode, before);
            }
          } else {
            if (isContainer) {
              appendChildToContainer(parent, stateNode);
            } else {
              appendChild(parent, stateNode);
            }
          }
        } else if (node.tag === HostPortal) {// If the insertion itself is a portal, then we don't want to traverse
          // down its children. Instead, we'll get insertions from each child in
          // the portal directly.
        } else if (node.child !== null) {
          node.child.return = node;
          node = node.child;
          continue;
        }

        if (node === finishedWork) {
          return;
        }

        while (node.sibling === null) {
          if (node.return === null || node.return === finishedWork) {
            return;
          }

          node = node.return;
        }

        node.sibling.return = node.return;
        node = node.sibling;
      }
    }

    function unmountHostComponents(finishedRoot, current$$1, renderPriorityLevel) {
      // We only have the top Fiber that was deleted but we need to recurse down its
      // children to find all the terminal nodes.
      var node = current$$1; // Each iteration, currentParent is populated with node's host parent if not
      // currentParentIsValid.

      var currentParentIsValid = false; // Note: these two variables *must* always be updated together.

      var currentParent;
      var currentParentIsContainer;

      while (true) {
        if (!currentParentIsValid) {
          var parent = node.return;

          findParent: while (true) {
            if (!(parent !== null)) {
              {
                throw Error("Expected to find a host parent. This error is likely caused by a bug in React. Please file an issue.");
              }
            }

            var parentStateNode = parent.stateNode;

            switch (parent.tag) {
              case HostComponent:
                currentParent = parentStateNode;
                currentParentIsContainer = false;
                break findParent;

              case HostRoot:
      