import { PointerType } from '../types';
import { DragConfig, InternalDragOptions, Vector2 } from '../types';
export declare const DEFAULT_PREVENT_SCROLL_DELAY = 250;
export declare const DEFAULT_DRAG_DELAY = 180;
export declare const DEFAULT_SWIPE_VELOCITY = 0.5;
export declare const DEFAULT_SWIPE_DISTANCE = 50;
export declare const DEFAULT_SWIPE_DURATION = 250;
export declare const dragConfigResolver: {
    device(this: InternalDragOptions, _v: any, _k: string, { pointer: { touch, lock, mouse } }: DragConfig): "mouse" | "touch" | "pointer";
    preventScrollAxis(this: InternalDragOptions, value: 'x' | 'y' | 'xy', _k: string, { preventScroll }: DragConfig): "x" | "y" | "xy" | undefined;
    pointerCapture(this: InternalDragOptions, _v: any, _k: string, { pointer: { capture, buttons } }: {
        pointer?: {
            capture?: boolean | undefined;
            buttons?: number | undefined;
        } | undefined;
    }): boolean;
    keys(value?: boolean): boolean;
    threshold(this: InternalDragOptions, value: number | Vector2, _k: string, { filterTaps, tapsThreshold, axis }: {
        filterTaps?: boolean | undefined;
        tapsThreshold?: number | undefined;
        axis?: undefined;
    }): [number, number];
    swipe(this: InternalDragOptions, { velocity, distance, duration }?: {
        velocity?: number | undefined;
        distance?: number | undefined;
        duration?: number | undefined;
    }): {
        velocity: Vector2;
        distance: Vector2;
        duration: number;
    };
    delay(value?: number | boolean): number;
    axisThreshold(value: Record<PointerType, number>): Record<PointerType, number>;
    axis(this: import("../types").InternalCoordinatesOptions<import("../types").CoordinatesKey>, _v: any, _k: string, { axis }: import("../types").CoordinatesConfig<import("../types").CoordinatesKey>): "x" | "y" | undefined;
    bounds(value?: import("../types").DragBounds | ((state: import("../types").State) => import("../types").DragBounds)): HTMLElement | [Vector2, Vector2] | (() => EventTarget | null);
    enabled(value?: boolean): boolean;
    eventOptions(value: AddEventListenerOptions | undefined, _k: string, config: {
        shared: import("../types").GenericOptions;
    }): {
        once?: boolean | undefined;
        passive?: boolean | undefined;
        signal?: AbortSignal | undefined;
        capture?: boolean | undefined;
    };
    preventDefault(value?: boolean): boolean;
    triggerAllEvents(value?: boolean): boolean;
    rubberband(value?: number | boolean | Vector2): Vector2;
    from(value: number | Vector2 | ((s: import("../types").State) => Vector2)): [number, number] | ((s: import("../types").State) => Vector2) | undefined;
    transform(this: import("../types").InternalGestureOptions<import("../types").GestureKey>, value: any, _k: string, config: {
        shared: import("../types").GenericOptions;
    }): any;
};
