import _extends from '@babel/runtime/helpers/esm/extends';
import * as React from 'react';

function create(type) {
  const El = type + 'BufferGeometry';
  return /*#__PURE__*/React.forwardRef(({
    args,
    children,
    ...props
  }, ref) => /*#__PURE__*/React.createElement("mesh", _extends({
    ref: ref
  }, props), /*#__PURE__*/React.createElement(El, {
    attach: "geometry",
    args: args
  }), children));
}

const Box = create('box');
const Circle = create('circle');
const Cone = create('cone');
const Cylinder = create('cylinder');
const Sphere = create('sphere');
const Plane = create('plane');
const Tube = create('tube');
const Torus = create('torus');
const TorusKnot = create('torusKnot');
const Tetrahedron = create('tetrahedron');
const Ring = create('ring');
const Polyhedron = create('polyhedron');
const Icosahedron = create('icosahedron');
const Octahedron = create('octahedron');
const Dodecahedron = create('dodecahedron');
const Extrude = create('extrude');
const Lathe = create('lathe');
const Capsule = create('capsule');

export { Box, Capsule, Circle, Cone, Cylinder, Dodecahedron, Extrude, Icosahedron, Lathe, Octahedron, Plane, Polyhedron, Ring, Sphere, Tetrahedron, Torus, TorusKnot, Tube };
