import _extends from '@babel/runtime/helpers/esm/extends';
import * as React from 'react';
import { useMemo } from 'react';
import { extend } from '@react-three/fiber';
import { suspend } from 'suspend-react';
import { FontLoader, TextGeometry } from 'three-stdlib';

const types = ['string', 'number'];

const getTextFromChildren = children => {
  let label = '';
  React.Children.map(children, child => {
    if (types.includes(typeof child)) {
      label += child + '';
    }
  });
  return label;
};

const Text3DBase = /*#__PURE__*/React.forwardRef(({
  font,
  loader,
  size = 1,
  height = 0.2,
  bevelThickness = 0.1,
  bevelSize = 0.01,
  bevelEnabled = false,
  bevelOffset = 0,
  bevelSegments = 4,
  curveSegments = 8,
  children,
  ...props
}, ref) => {
  React.useMemo(() => {
    extend({
      RenamedTextGeometry: TextGeometry
    });
  }, []);

  const _font = React.useMemo(() => loader.parse(font), [font]);

  const opts = useMemo(() => {
    return {
      font: _font,
      size,
      height,
      bevelThickness,
      bevelSize,
      bevelEnabled,
      bevelSegments,
      bevelOffset,
      curveSegments
    };
  }, [_font, size, height, bevelThickness, bevelSize, bevelEnabled, bevelOffset, curveSegments]);
  /**
   * We need the `children` in the deps because we
   * need to be able to do `<Text3d>{state}</Text3d>`.
   */

  const txt = useMemo(() => getTextFromChildren(children), [children]);
  const args = React.useMemo(() => [txt, opts], [txt, opts]);
  return /*#__PURE__*/React.createElement("mesh", _extends({}, props, {
    ref: ref
  }), /*#__PURE__*/React.createElement("renamedTextGeometry", {
    args: args
  }), children);
});
const Text3DSuspend = /*#__PURE__*/React.forwardRef(({
  font,
  loader,
  ...props
}, ref) => {
  const _font = suspend(async () => {
    const json = await (await fetch(font)).json();
    return json;
  }, [font]);

  return /*#__PURE__*/React.createElement(Text3DBase, _extends({}, props, {
    ref: ref,
    font: _font,
    loader: loader
  }));
});
const Text3D = /*#__PURE__*/React.forwardRef((props, ref) => {
  const loader = React.useMemo(() => new FontLoader(), []);

  if (typeof props.font === 'string') {
    return /*#__PURE__*/React.createElement(Text3DSuspend, _extends({}, props, {
      ref: ref,
      loader: loader
    }));
  } else {
    return /*#__PURE__*/React.createElement(Text3DBase, _extends({}, props, {
      ref: ref,
      loader: loader
    }));
  }
});

export { Text3D };
