import _extends from '@babel/runtime/helpers/esm/extends';
import * as React from 'react';
import { MeshSurfaceSampler } from 'three-stdlib';
import { Vector3, Color, Object3D } from 'three';

const Sampler = ({
  children,
  weight,
  transform,
  instances,
  mesh,
  ...props
}) => {
  const group = React.useRef(null);
  const instancedRef = React.useRef(null);
  const meshToSampleRef = React.useRef(null);
  React.useEffect(() => {
    var _instances$current, _mesh$current;

    instancedRef.current = (_instances$current = instances == null ? void 0 : instances.current) !== null && _instances$current !== void 0 ? _instances$current : group.current.children.find(c => c.hasOwnProperty('instanceMatrix'));
    meshToSampleRef.current = (_mesh$current = mesh == null ? void 0 : mesh.current) !== null && _mesh$current !== void 0 ? _mesh$current : group.current.children.find(c => c.type === 'Mesh');
  }, [children, mesh == null ? void 0 : mesh.current, instances == null ? void 0 : instances.current]);
  React.useEffect(() => {
    if (typeof meshToSampleRef.current === 'undefined') return;
    if (typeof instancedRef.current === 'undefined') return;
    const sampler = new MeshSurfaceSampler(meshToSampleRef.current);

    if (weight) {
      sampler.setWeightAttribute(weight);
    }

    sampler.build();
    const position = new Vector3();
    const normal = new Vector3();
    const color = new Color();
    const dummy = new Object3D();
    meshToSampleRef.current.updateMatrixWorld(true);

    for (let i = 0; i < instancedRef.current.count; i++) {
      sampler.sample(position, normal, color);

      if (typeof transform === 'function') {
        transform({
          dummy,
          sampledMesh: meshToSampleRef.current,
          position,
          normal,
          color
        }, i);
      } else {
        dummy.position.copy(position);
      }

      dummy.updateMatrix();
      instancedRef.current.setMatrixAt(i, dummy.matrix);
    }

    instancedRef.current.instanceMatrix.needsUpdate = true;
  }, [children, mesh == null ? void 0 : mesh.current, instances == null ? void 0 : instances.current]);
  return /*#__PURE__*/React.createElement("group", _extends({
    ref: group
  }, props), children);
};

export { Sampler };
