import * as React from 'react';
import { Color, InstancedMesh, Mesh, Object3D, Vector3 } from 'three';
import { GroupProps } from '@react-three/fiber';
declare type SamplePayload = {
    position: Vector3;
    normal: Vector3;
    color: Color;
};
export declare type TransformFn = (payload: TransformPayload, i: number) => void;
declare type TransformPayload = SamplePayload & {
    dummy: Object3D;
    sampledMesh: Mesh;
};
declare type Props = {
    mesh?: React.RefObject<Mesh>;
    instances?: React.RefObject<InstancedMesh>;
    weight?: string;
    transform?: TransformFn;
};
export declare const Sampler: ({ children, weight, transform, instances, mesh, ...props }: React.PropsWithChildren<Props & GroupProps>) => JSX.Element;
export {};
