import _extends from '@babel/runtime/helpers/esm/extends';
import * as THREE from 'three';
import * as React from 'react';
import { useThree, createPortal, useFrame } from '@react-three/fiber';
import { useFBO } from './useFBO.js';

const RenderTexture = /*#__PURE__*/React.forwardRef(({
  children,
  width,
  height,
  renderPriority = 0,
  eventPriority = 0,
  frames = Infinity,
  ...props
}, forwardRef) => {
  const {
    size,
    viewport
  } = useThree();
  const fbo = useFBO((width || size.width) * viewport.dpr, (height || size.height) * viewport.dpr, {
    samples: 8
  });
  const [vScene] = React.useState(() => new THREE.Scene());
  const compute = React.useCallback((event, state, previous) => {
    var _fbo$texture, _previous$previousRoo;

    // Since this is only a texture it does not have an easy way to obtain the parent, which we
    // need to transform event coordinates to local coordinates. We use r3f internals to find the
    // next Object3D.
    let parent = (_fbo$texture = fbo.texture) == null ? void 0 : _fbo$texture.__r3f.parent;

    while (parent && !(parent instanceof THREE.Object3D)) {
      parent = parent.__r3f.parent;
    }

    if (!parent) return false; // First we call the previous state-onion-layers compute, this is what makes it possible to nest portals

    if (!previous.raycaster.camera) previous.events.compute(event, previous, (_previous$previousRoo = previous.previousRoot) == null ? void 0 : _previous$previousRoo.getState()); // We run a quick check against the parent, if it isn't hit there's no need to raycast at all

    const [intersection] = previous.raycaster.intersectObject(parent);
    if (!intersection) return false; // We take that hits uv coords, set up this layers raycaster, et voilà, we have raycasting on arbitrary surfaces

    const uv = intersection.uv;
    state.raycaster.setFromCamera(state.pointer.set(uv.x * 2 - 1, uv.y * 2 - 1), state.camera);
  }, []);
  React.useImperativeHandle(forwardRef, () => fbo.texture, [fbo]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, createPortal( /*#__PURE__*/React.createElement(Container, {
    renderPriority: renderPriority,
    frames: frames,
    fbo: fbo
  }, children), vScene, {
    events: {
      compute,
      priority: eventPriority
    }
  }), /*#__PURE__*/React.createElement("primitive", _extends({
    object: fbo.texture
  }, props)));
}); // The container component has to be separate, it can not be inlined because "useFrame(state" when run inside createPortal will return
// the portals own state which includes user-land overrides (custom cameras etc), but if it is executed in <RenderTexture>'s render function
// it would return the default state.

function Container({
  frames,
  renderPriority,
  children,
  fbo
}) {
  let count = 0;
  useFrame(state => {
    if (frames === Infinity || count < frames) {
      state.gl.setRenderTarget(fbo);
      state.gl.render(state.scene, state.camera);
      state.gl.setRenderTarget(null);
      count++;
    }
  }, renderPriority);
  return /*#__PURE__*/React.createElement(React.Fragment, null, children);
}

export { RenderTexture };
