import _extends from '@babel/runtime/helpers/esm/extends';
import * as React from 'react';
import { MeshStandardMaterial, Color } from 'three';
import mergeRefs from 'react-merge-refs';
import { MarchingCubes as MarchingCubes$1 } from 'three-stdlib';
import { useFrame } from '@react-three/fiber';

const globalContext = /*#__PURE__*/React.createContext(null);
const MarchingCubes = /*#__PURE__*/React.forwardRef(({
  resolution = 28,
  maxPolyCount = 10000,
  enableUvs = false,
  enableColors = false,
  children,
  ...props
}, ref) => {
  const marchingCubesRef = React.useRef(null);
  const marchingCubes = React.useMemo(() => new MarchingCubes$1(resolution, new MeshStandardMaterial(), enableUvs, enableColors, maxPolyCount), [resolution, maxPolyCount, enableUvs, enableColors]);
  const api = React.useMemo(() => ({
    getParent: () => marchingCubesRef
  }), []);
  useFrame(() => {
    marchingCubes.reset();
  }, -1); // To make sure the reset runs before the balls or planes are added

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("primitive", _extends({
    object: marchingCubes,
    ref: mergeRefs([marchingCubesRef, ref])
  }, props), /*#__PURE__*/React.createElement(globalContext.Provider, {
    value: api
  }, children)));
});
const MarchingCube = /*#__PURE__*/React.forwardRef(({
  strength = 0.5,
  subtract = 12,
  color = new Color('#fff'),
  ...props
}, ref) => {
  const {
    getParent
  } = React.useContext(globalContext);
  const parentRef = React.useMemo(() => getParent(), [getParent]);
  const cubeRef = React.useRef();
  useFrame(() => {
    if (!parentRef.current || !cubeRef.current) return;
    parentRef.current.addBall(cubeRef.current.position.x, cubeRef.current.position.y, cubeRef.current.position.z, strength, subtract, color);
  });
  return /*#__PURE__*/React.createElement("group", _extends({
    ref: mergeRefs([ref, cubeRef])
  }, props));
});
const MarchingPlane = /*#__PURE__*/React.forwardRef(({
  planeType: _planeType = 'x',
  strength = 0.5,
  subtract = 12,
  ...props
}, ref) => {
  const {
    getParent
  } = React.useContext(globalContext);
  const parentRef = React.useMemo(() => getParent(), [getParent]);
  const wallRef = React.useRef();
  const planeType = React.useMemo(() => _planeType === 'x' ? 'addPlaneX' : _planeType === 'y' ? 'addPlaneY' : 'addPlaneZ', [_planeType]);
  useFrame(() => {
    if (!parentRef.current || !wallRef.current) return;
    parentRef.current[planeType](strength, subtract);
  });
  return /*#__PURE__*/React.createElement("group", _extends({
    ref: mergeRefs([ref, wallRef])
  }, props));
});

export { MarchingCube, MarchingCubes, MarchingPlane };
