"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("@babel/runtime/helpers/extends"),r=require("react"),t=require("three"),n=require("@react-three/fiber"),a=require("./shaderMaterial.cjs.js"),o=require("./useTexture.cjs.js");function c(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}function i(e){if(e&&e.__esModule)return e;var r=Object.create(null);return e&&Object.keys(e).forEach((function(t){if("default"!==t){var n=Object.getOwnPropertyDescriptor(e,t);Object.defineProperty(r,t,n.get?n:{enumerable:!0,get:function(){return e[t]}})}})),r.default=e,Object.freeze(r)}var s=c(e),l=i(r),u=i(t);const f=a.shaderMaterial({color:new u.Color("white"),scale:[1,1],imageBounds:[1,1],map:null,zoom:1,grayscale:0,opacity:1},"\n  varying vec2 vUv;\n  void main() {\n    gl_Position = projectionMatrix * viewMatrix * modelMatrix * vec4(position, 1.);\n    vUv = uv;\n  }\n","\n  // mostly from https://gist.github.com/statico/df64c5d167362ecf7b34fca0b1459a44\n  varying vec2 vUv;\n  uniform vec2 scale;\n  uniform vec2 imageBounds;\n  uniform vec3 color;\n  uniform sampler2D map;\n  uniform float zoom;\n  uniform float grayscale;\n  uniform float opacity;\n  const vec3 luma = vec3(.299, 0.587, 0.114);\n  vec4 toGrayscale(vec4 color, float intensity) {\n    return vec4(mix(color.rgb, vec3(dot(color.rgb, luma)), intensity), color.a);\n  }\n  vec2 aspect(vec2 size) {\n    return size / min(size.x, size.y);\n  }\n  void main() {\n    vec2 s = aspect(scale);\n    vec2 i = aspect(imageBounds);\n    float rs = s.x / s.y;\n    float ri = i.x / i.y;\n    vec2 new = rs < ri ? vec2(i.x * s.y / i.y, s.y) : vec2(s.x, i.y * s.x / i.x);\n    vec2 offset = (rs < ri ? vec2((new.x - s.x) / 2.0, 0.0) : vec2(0.0, (new.y - s.y) / 2.0)) / new;\n    vec2 uv = vUv * s / new + offset;\n    vec2 zUv = (uv - vec2(0.5, 0.5)) / zoom + vec2(0.5, 0.5);\n    gl_FragColor = toGrayscale(texture2D(map, zUv) * vec4(color, opacity), grayscale);\n    \n    #include <tonemapping_fragment>\n    #include <encodings_fragment>\n  }\n"),m=l.forwardRef((({children:e,color:r,segments:t=1,scale:a=1,zoom:o=1,grayscale:c=0,opacity:i=1,texture:u,toneMapped:m,transparent:v,...d},g)=>{n.extend({ImageMaterial:f});const p=n.useThree((e=>e.gl)),y=Array.isArray(a)?[a[0],a[1]]:[a,a],x=[u.image.width,u.image.height];return l.createElement("mesh",s.default({ref:g,scale:a},d),l.createElement("planeGeometry",{args:[1,1,t,t]}),l.createElement("imageMaterial",{color:r,map:u,"map-encoding":p.outputEncoding,zoom:o,grayscale:c,opacity:i,scale:y,imageBounds:x,toneMapped:m,transparent:v}),e)})),v=l.forwardRef((({url:e,...r},t)=>{const n=o.useTexture(e);return l.createElement(m,s.default({},r,{texture:n,ref:t}))})),d=l.forwardRef((({url:e,...r},t)=>l.createElement(m,s.default({},r,{ref:t})))),g=l.forwardRef(((e,r)=>{if(e.url)return l.createElement(v,s.default({},e,{ref:r}));if(e.texture)return l.createElement(d,s.default({},e,{ref:r}));throw new Error("<Image /> requires a url or texture")}));exports.Image=g;
