import * as React from 'react';
import { Texture, Scene, Loader, CubeTexture, TextureEncoding } from 'three';
import { PresetsType } from '../helpers/environment-assets';
declare type Props = {
    children?: React.ReactNode;
    frames?: number;
    near?: number;
    far?: number;
    resolution?: number;
    background?: boolean | 'only';
    map?: THREE.Texture;
    files?: string | string[];
    path?: string;
    preset?: PresetsType;
    scene?: Scene | React.MutableRefObject<THREE.Scene>;
    extensions?: (loader: Loader) => void;
    ground?: boolean | {
        radius?: number;
        height?: number;
        scale?: number;
    };
    encoding?: TextureEncoding;
};
export declare function EnvironmentMap({ scene, background, map }: Props): null;
export declare function useEnvironment({ files, path, preset, encoding, extensions, }: Partial<Props>): Texture | CubeTexture;
export declare function EnvironmentCube({ background, scene, ...rest }: Props): null;
export declare function EnvironmentPortal({ children, near, far, resolution, frames, map, background, scene, files, path, preset, extensions, }: Props): JSX.Element;
export declare function Environment(props: Props): JSX.Element;
export {};
