require("dotenv").config()
const express = require('express')
const path = require('path')
const expressLayouts = require('express-ejs-layouts')
const connectDB = require("./config/db");
const errorHandler = require("./middleware/errorHandler");
const session = require('express-session');
const bodyParser = require("body-parser");

connectDB()
const app = express()

app.set('view engine', 'ejs')
app.use(expressLayouts)
app.use(session({
  secret: 'sr-213ds-d3d31',
  resave: true,
  saveUninitialized: true
}));
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(express.static(path.join(__dirname, 'public')))
//app.use(express.static(__dirname + '../public'));

// Usando router

const router = require('./routes/router')
app.use(router.routes)

// Middleware
app.use(express.json());
app.use(function(req, res, next) {
    //res.header("Access-Control-Allow-Origin", "https://epicacreative.com"); // update to match the domain you will make the request from
        const allowedOrigins = ['https://epicacreative.com', 'http://wooda.devuocloud.com', 'https://gowooda.es', 'https://www.gowooda.es'];
        const origin = req.headers.origin;
        if (allowedOrigins.includes(origin)) {
                res.setHeader('Access-Control-Allow-Origin', origin);
        }
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
  });

//app.get('/', (req, res) => {
//    res.send('Dashboard con Node Js')
//})

// Routes
app.use("/api/v1", require("./routes/apiRoutes"));

// Error Handler
app.use(errorHandler);


const PORT = process.env.PORT;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
