const nodemailer = require("nodemailer");
const fs = require('fs');
const { promisify } = require('util');
const readFile = promisify(fs.readFile);
require('dotenv').config();

async function sendContactMail(contact) {

    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        port: process.env.EMAIL_PORT,
        secure: true,
        auth: {
            type: "OAuth2",
            user: process.env.EMAIL_ADDRESS,
            clientId: process.env.EMAIL_CLIENT_TOKEN,
            clientSecret: process.env.EMAIL_SECRET_TOKEN,
            refreshToken: process.env.EMAIL_REFRESH_TOKEN,
        },
        tls: {
            rejectUnauthorized: false
        }
    });

    let info = await transporter.sendMail({
        from: process.env.EMAIL_ADDRESS,
        to: process.env.EMAIL_TO_DESTINY,
        subject: "New contact from " + contact.name,
        text: "Nuevo contacto de Wooda ",
        html: 
            "<p>Nombre: "+ contact.name+"</p>"+
            "<p>Email: "+ contact.email+"</p>"+
            "<p>Empresa: "+ contact.company+"</p>"+
            "<p>Telefono: "+ contact.phone+"</p>"+ 
            "<p>Mensaje: "+ contact.message+"</p>"+
            "<p>Saludos</p>",
    });
}
async function sendNewsletterMail(email) {

    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        port: process.env.EMAIL_PORT,
        secure: true,
        auth: {
            type: "OAuth2",
            user: process.env.EMAIL_ADDRESS,
            clientId: process.env.EMAIL_CLIENT_TOKEN,
            clientSecret: process.env.EMAIL_SECRET_TOKEN,
            refreshToken: process.env.EMAIL_REFRESH_TOKEN,
        },
        tls: {
            rejectUnauthorized: false
        }
    });

    let info = await transporter.sendMail({
        from: process.env.EMAIL_ADDRESS,
        to: process.env.EMAIL_TO_DESTINY,
        subject: "New newsletter",
        text: "Nuevo newsLetter de wooda ",
        html: "<p>Email: "+ email+"</p>",
    });
}

async function sendClientMail(email) {

    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        port: process.env.EMAIL_PORT,
        secure: true,
        auth: {
            type: "OAuth2",
            user: process.env.EMAIL_ADDRESS,
            clientId: process.env.EMAIL_CLIENT_TOKEN,
            clientSecret: process.env.EMAIL_SECRET_TOKEN,
            refreshToken: process.env.EMAIL_REFRESH_TOKEN,
        },
        tls: {
            rejectUnauthorized: false
        }
    });

    let info = await transporter.sendMail({
        from: process.env.EMAIL_ADDRESS,
        to: email,
        subject: "Estás a un paso de convertirte en un Wooder!",
        text: "Nuevo newsLetter de wooda ",
        html: await readFile('/var/www/html/backendsender/backend/views/template.ejs', 'utf8'),
    });
}


module.exports = { sendContactMail , sendNewsletterMail, sendClientMail};
