const Contact = require("../models/Contact");
const Newsletter = require("../models/Newsletter");
const User = require("../models/User");
const bcrypt = require('bcryptjs');
const ErrorResponse = require("../utils/errorResponse");
const asyncHandler = require("../middleware/asyncHandler");
const { sendContactMail, sendNewsletterMail, sendClientMail } = require("../models/Mailer");
// CONTACT API
exports.getContacts = asyncHandler(async (req, res, next) => {
  let searchString = req.query.search.value;
  const contacts = await Contact.find({ "name": { $regex: ".*" + searchString + ".*" } })
    .skip(req.query.start)
    .limit(req.query.length);
  const contactsCount = await Contact.find({ "name": { $regex: ".*" + searchString + ".*" } }).count();
  res.status(200).json({
    success: true,
    data: contacts,
    recordsFiltered: contactsCount,
    recordsTotal: contactsCount,
    draw: req.query.draw,
  });
});

exports.getContactById = asyncHandler(async (req, res, next) => {
  const contact = await Contact.findById(req.params.id);

  res.status(200).json({
    success: true,
    data: contact,
  });
});

exports.createNewContact = asyncHandler(async (req, res, next) => {
  const contact = await Contact.create(req.body);
  if (!contact) {
    return next(
      new ErrorResponse(`No se pudo guardar el contacto`, 404)
    );
  }
  await sendContactMail(contact);

  res.status(200).json({
    success: true,
    data: contact,
  });
});

exports.deleteContact = asyncHandler(async (req, res, next) => {
  Contact.findByIdAndRemove(req.params.id, (err, doc) => {
    if (!err) {
      res.status(200).json({
        success: true,
        message: "deleted"
      });
    } else {
      console.log('Failed to Delete: ' + err);
    }
  });
})

//NEWSLETTERS API

exports.getNewsletters = asyncHandler(async (req, res, next) => {

  let searchString = req.query.search.value;
  const newsletters = await Newsletter.find({ "email": { $regex: ".*" + searchString + ".*" } })
    .skip(req.query.start)
    .limit(req.query.length);
  const newsletterCount = await Newsletter.find({ "email": { $regex: ".*" + searchString + ".*" } }).count();
  res.status(200).json({
    success: true,
    data: newsletters,
    recordsFiltered: newsletterCount,
    recordsTotal: newsletterCount,
    draw: req.query.draw,
  });
});

exports.getNewsletterById = asyncHandler(async (req, res, next) => {
  const newsletter = await Newsletter.findById(req.params.id);
  res.status(200).json({
    success: true,
    data: newsletter,
  });
});

exports.createNewsLetter = asyncHandler(async (req, res, next) => {
  const newsletter = await Newsletter.create(req.body);

  if (!newsletter) {
    return next(
      new ErrorResponse(`No se pudo guardar el newsletter`, 404)
    );
  }
  await sendNewsletterMail(newsletter.email);

  await sendClientMail(newsletter.email);

  res.status(200).json({
    success: true,
    data: newsletter,
  });
});

exports.deleteNewsLetter = asyncHandler(async (req, res, next) => {
  Newsletter.findByIdAndRemove(req.params.id, (err, doc) => {
    if (!err) {
      res.status(200).json({
        success: true,
        message: "deleted"
      });
    } else {
      console.log('Failed to Delete user Details: ' + err);
    }
  });
})

//User

exports.createUser = asyncHandler(async (req, res, next) => {

  const { email, password } = req.body;

  const oldUser = await User.findOne({ email });

  if (oldUser) {
    return res.status(409).send("This email is already registerd");
  }

  encryptedPassword = await bcrypt.hash(password, 10);

  const user = await User.create({email: email, password : encryptedPassword });

  if (!user) {
    return next(
      new ErrorResponse(`No se pudo guardar el usuario`, 404)
    );
  }

  res.status(200).json({
    success: true,
    data: user,
  });
});

exports.login = asyncHandler(async (req, res, next) => {

  const { email, password } = req.body;

  if (!email || !password) {
    res.render('login', { layout: 'layoutAuth' , message : "Debe ingresar ambos campos" });
  }

  const user = await User.findOne({ email: email });

  if (!user) {
    return res.render('login', { layout: 'layoutAuth' , message : "Email incorrecto" });
  }

  bcrypt.compare(password, user.password, function (error, isMatch) {
    if (!isMatch) {
      return res.render('login', { layout: 'layoutAuth' , message : "Contraseña incorrecta" });
    }
    else {
      req.session.user = true;
      return res.redirect('/contacts');
    }
  })
});

exports.logout = async (req, res) => {
  req.session.destroy();
  res.render('login', { layout: 'layoutAuth' , message : "" });
};

exports.createPaswordEndpoint = async (req, res) => {

  const bcrypt = require("bcryptjs")

  const password = "mypass123"
  const saltRounds = 10

  bcrypt.genSalt(saltRounds, function (saltError, salt) {
    if (saltError) {
      throw saltError
    } else {
      bcrypt.hash(password, salt, function (hashError, hash) {
        if (hashError) {
          throw hashError
        } else {
          console.log(hash)
        }
      })
    }
  })

};
